CREATE DATABASE IF NOT EXISTS `bemutato` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_hungarian_ci;
USE `bemutato`;

CREATE TABLE `eloadas` (
  `id` int(11) NOT NULL,
  `cim` varchar(100) COLLATE utf8mb4_hungarian_ci NOT NULL,
  `szinhazid` int(11) DEFAULT NULL,
  `datum` date NOT NULL,
  `mufaj` varchar(30) COLLATE utf8mb4_hungarian_ci DEFAULT NULL,
  `nyelv` varchar(15) COLLATE utf8mb4_hungarian_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_hungarian_ci;

INSERT INTO `eloadas` (`id`, `cim`, `szinhazid`, `datum`, `mufaj`, `nyelv`) VALUES
(1, 'M. ország gyermekei', 110, '2014-02-11', NULL, 'magyar'),
(2, 'Herzl', 64, '2014-11-24', 'színmű', 'magyar'),
(3, 'Hamupipőke', 199, '2014-09-26', 'mesebalett', 'magyar'),
(4, 'Kabaré', 70, '2019-04-05', 'kabaré', NULL),
(5, 'Hétszínvirág', 139, '2015-02-14', 'bábjáték', NULL),
(6, 'Balta a fejbe', 129, '2014-01-11', 'tragikomédia', 'magyar'),
(7, 'A londoni lakosztály', 182, '2019-10-10', NULL, NULL),
(8, 'A cigány', 53, '2017-09-15', 'zenés előadás', 'magyar'),
(9, 'Emese almája', 139, '2015-04-11', NULL, NULL),
(10, 'Advent a Hargitán', 50, '2013-11-29', 'dráma', 'magyar'),
(11, 'Circus Maximus', 156, '2013-04-06', 'cirkuszi előadás', NULL),
(12, 'Lehár - Szép álom, szállj szívemre', 64, '2015-09-14', 'zenés játék', 'magyar'),
(13, 'Prométheusz', 8, '2017-04-07', 'táncelőadás', NULL),
(14, 'Mátyás mesék', 23, '2013-11-15', 'mesejáték', 'magyar'),
(15, 'A Mester és Margarita', 157, '2021-09-01', NULL, NULL),
(16, 'Falstaff', 99, '2012-02-24', 'vígopera', 'magyar'),
(17, 'A diótörő és az egérkirály', 54, '2013-12-28', NULL, 'magyar'),
(18, 'A csapodár madárka', 119, '2012-07-19', 'komédia', 'magyar'),
(19, 'Mágnás Miska', 39, '2012-08-18', 'operett', 'magyar'),
(20, 'Sose halunk meg', 195, '2013-06-29', 'musical', 'magyar'),
(21, 'Csillagképek', 190, '2019-10-20', NULL, NULL),
(22, 'Utazás az éjszakába', 109, '2015-10-30', 'dráma', 'magyar'),
(23, 'Vonat elé leguggolni', 76, '2020-01-10', NULL, NULL),
(24, 'My Fair Lady', 32, '2013-10-18', 'musical', 'magyar'),
(25, 'Váltságdíj - Nárcisz és Echo', 29, '2014-04-17', 'opera', 'magyar'),
(26, 'A színigazgató', 99, '2012-10-21', 'opera', 'magyar'),
(27, 'Faust I.', 34, '2015-04-25', 'színmű', 'magyar'),
(28, 'EztRád', 14, '2016-03-17', 'zenés előadás', 'magyar'),
(29, 'Tajtékos napok', 140, '2014-03-21', 'színmű', 'magyar'),
(30, 'Én és a kisöcsém', 9, '2014-10-03', 'operett', 'magyar'),
(31, 'Születésnap', 30, '2020-09-26', NULL, NULL),
(32, 'Szeretik a banánt, elvtársak?', NULL, '2014-11-23', 'monodráma', 'magyar'),
(33, 'Mutatvány de la Danse', NULL, '2019-11-15', 'újcirkusz', NULL),
(34, 'A három zsivány', 47, '2012-05-20', 'bábjáték', 'magyar'),
(35, 'A három kismalac', 70, '2014-09-10', 'zenés bábjáték', 'magyar'),
(36, 'A nagybőgő', 181, '2018-01-20', 'tragikomédia', NULL),
(37, 'Holdbeli csónakos', 99, '2015-09-25', NULL, 'magyar'),
(38, 'Sam, avagy felkészülés a családi életre', 160, '2021-12-11', 'dráma', NULL),
(39, 'A Béres', 162, '2016-02-26', 'dráma', 'magyar'),
(40, 'Szétbombázva', 95, '2019-04-04', NULL, NULL),
(41, 'Amy világa', 68, '2021-09-05', 'színmű', NULL),
(42, 'Mamma Mia!', 118, '2014-09-26', 'musical', 'magyar'),
(43, 'Ramazuri', 197, '2021-06-05', 'táncelőadás', NULL),
(44, 'Liliom', 185, '2017-02-24', NULL, 'magyar'),
(45, 'Tisztelt Ház', 52, '2018-11-25', NULL, NULL),
(46, 'Mocorgó', 151, '2020-11-08', 'bábelőadás', NULL),
(47, 'Sziluett Cinema: Budapest', 107, '2014-05-28', 'táncelőadás', 'magyar'),
(48, 'Eleven népmesék', 148, '2021-10-30', 'krimi vígjáték', NULL),
(49, 'Mirr-Murr kalandjai', 129, '2017-11-03', NULL, 'magyar'),
(50, 'Grace és Gloria', 109, '2014-10-03', 'színmű', 'magyar'),
(51, 'A szabin nők elrablása', 195, '2017-02-11', 'zenés vígjáték', 'magyar'),
(52, 'Hengergő', 40, '2018-03-03', 'csecsemő színház', NULL),
(53, 'Mady Baby', NULL, '2020-02-08', NULL, NULL),
(54, 'Oszd Meg!', 152, '2014-05-16', 'zenés előadás', 'magyar'),
(55, 'Pinokkió', 136, '2017-01-18', 'táncelőadás', NULL),
(56, 'Komámasszony, hol a stukker?', 30, '2017-09-30', NULL, 'magyar'),
(57, 'Tolvajnők naplója', 33, '2012-09-02', 'színmű', 'magyar'),
(58, 'Hol szoknya, hol nadrág', 134, '2015-04-17', NULL, 'magyar'),
(59, 'ELMARAD! - Kőszívű ember fiai', 185, '2020-03-13', 'színmű', NULL),
(60, 'Hepa / Show', NULL, '2020-03-07', 'táncelőadás', NULL),
(61, 'Szent Péter esernyője', 73, '2019-11-29', NULL, NULL),
(62, '4x100', 30, '2012-05-18', 'színmű', 'magyar'),
(63, 'Tengeren', 129, '2019-12-13', NULL, NULL),
(64, 'Quixote', 32, '2016-03-06', 'táncelőadás', 'magyar'),
(65, 'Rendezői változat', NULL, '2018-04-12', NULL, NULL),
(66, 'Protest - Út a forradalomhoz', 20, '2021-08-03', NULL, NULL),
(67, 'Játék a kastélyban', 9, '2012-09-28', 'komédia', 'magyar'),
(68, 'A szerelmi tilalom', 22, '2015-09-29', 'vígopera', 'magyar'),
(69, 'Zárlat', 140, '2014-04-24', 'táncelőadás', 'magyar'),
(70, 'Alul semmi', 152, '2015-10-30', 'színmű', 'magyar'),
(71, 'Hamlet', 82, '2014-06-21', NULL, 'angol'),
(72, 'A kredenc a pincében maradt', NULL, '2021-09-28', 'táncelőadás', NULL),
(73, 'SUGAR (Some like it hot) - Van, aki forrón szereti', 181, '2019-12-20', NULL, NULL),
(74, 'Macskajáték', 12, '2015-10-15', 'tragikomédia', 'magyar'),
(75, 'Leértékelés', 188, '2013-02-09', 'táncelőadás', 'magyar'),
(76, 'Egy csepp méz', 190, '2021-09-26', NULL, NULL),
(77, 'BartóKodály', 11, '2012-12-14', 'táncelőadás', 'magyar'),
(78, 'Saját drive', 200, '2021-09-20', NULL, NULL),
(79, 'Egerek és emberek', 12, '2012-10-06', 'színmű', 'magyar'),
(80, 'A bőgős fia meg az ördögök', 192, '2017-10-27', 'bábelőadás', NULL),
(81, 'A kávéház', 26, '2018-09-10', NULL, NULL),
(82, 'Hair', 68, '2015-06-24', 'zenés előadás', 'magyar'),
(83, 'Jobb fe´lni - avagy Egység Kétség Háromság', NULL, '2020-09-26', NULL, NULL),
(84, 'Anonyma/Nő háborúban', 62, '2019-05-15', 'monodráma', NULL),
(85, 'Blokkoló', 96, '2014-12-14', NULL, 'magyar'),
(86, 'Komámasszony, hol a stukker', 202, '2016-02-15', NULL, 'magyar'),
(87, 'Jézus Krisztus szupersztár', 181, '2015-11-13', 'rockopera', 'magyar'),
(88, 'Bolondokháza', 22, '2015-09-19', 'vígopera', 'magyar'),
(89, 'Annuska', 109, '2014-04-11', 'vígjáték', 'magyar'),
(90, 'Örökké...szabadon', 182, '2019-03-07', NULL, NULL),
(91, 'Yvonne, a burgundi hercegnő', 140, '2013-12-10', 'színmű', 'magyar'),
(92, 'Nagyon Nagy Ő', 182, '2017-10-27', NULL, 'magyar'),
(93, 'Szajré', 121, '2016-09-23', 'bűnügyi komédia', 'magyar'),
(94, 'Szent tehenek', 31, '2014-09-07', 'színmű', 'magyar'),
(95, 'Az arab éjszaka', 95, '2018-10-05', NULL, NULL),
(96, 'Nők', 121, '2013-12-20', 'színmű', 'magyar'),
(97, 'Zsidó mesék', NULL, '2018-05-07', NULL, NULL),
(98, '1089 (színház az orrod hegyén)', 140, '2017-02-10', 'színmű', 'magyar'),
(99, 'A Gézagyerek', 165, '2012-02-05', NULL, NULL),
(100, 'Játék a kastélyban', 195, '2012-01-28', NULL, 'magyar'),
(101, 'S(irály) generáció', 175, '2021-08-27', NULL, NULL),
(102, 'A széttáncolt cipellők', 112, '2021-02-28', 'bábjáték', NULL),
(103, 'Az öngyilkos', 76, '2016-04-23', 'komédia', 'magyar'),
(104, 'Az utolsó pohár', 144, '2014-04-17', 'színmű', 'magyar'),
(105, 'Egerek és emberek', 30, '2018-01-13', NULL, NULL),
(106, 'Augusztus Oklahomában', 148, '2016-11-12', 'dráma', 'magyar'),
(107, 'Az ellopott futár', 129, '2014-11-08', 'komédia', 'magyar'),
(108, 'A Bánk bán per', NULL, '2020-03-06', NULL, NULL),
(109, 'Pinokkió', 51, '2018-10-13', 'bábjáték', NULL),
(110, 'Bogáncsvirág', 129, '2021-05-20', 'krimi', NULL),
(111, 'Alkésztisz', 184, '2020-02-07', NULL, NULL),
(112, 'Bűn és bűnhődés', 170, '2016-10-15', 'dráma', 'magyar'),
(113, 'Amerikai komédia', 29, '2014-03-21', 'musical', 'magyar'),
(114, 'Az átváltozás', 20, '2018-01-12', NULL, NULL),
(115, 'Jujj, jön a Rongymacska!', 139, '2019-05-11', 'csecsemő színház', NULL),
(116, 'Szakácskönyv a túlélésért', 155, '2014-11-02', 'színmű', 'magyar'),
(117, 'A hal nem hal bele', 101, '2014-10-04', 'színmű', 'magyar'),
(118, 'Cosi fan tutte', 21, '2016-06-17', 'opera', 'magyar'),
(119, 'Psyché', 95, '2016-03-08', NULL, 'magyar'),
(120, 'Zűrzavaros éjszaka', 32, '2016-03-24', 'vígjáték', 'magyar'),
(121, 'Házassági leckék 2', 35, '2020-10-30', NULL, NULL),
(122, 'Trójai nők', 128, '2019-03-17', NULL, NULL),
(123, 'Magas (szőke) barna férfi felemás…', 102, '2019-12-07', NULL, NULL),
(124, 'Izland - Magyarország', 184, '2018-03-28', NULL, NULL),
(125, 'Winterreise', 20, '2021-10-29', 'zenés előadás', NULL),
(126, 'Szmarana', 65, '2018-01-24', 'táncelőadás', NULL),
(127, 'We hear you - Hallgatlak!', 127, '2015-10-23', NULL, 'magyar'),
(128, 'Császárok napja - Felejtésre ítélve - Messalina', 9, '2015-09-12', NULL, 'magyar'),
(129, 'Tartuffe', 9, '2017-05-05', 'vígjáték', 'magyar'),
(130, 'A fehér kór', 30, '2017-03-03', NULL, 'magyar'),
(131, 'Hitgyógyász', 140, '2012-12-02', 'színmű', 'magyar'),
(132, 'Bábelna', 9, '2013-03-11', NULL, 'magyar'),
(133, 'Vasárnapi gyerekek', 134, '2013-03-27', 'családregény', 'magyar'),
(134, 'Gioconda', 22, '2019-02-22', 'opera', NULL),
(135, 'A főfőnök', 129, '2017-04-01', 'komédia', 'magyar'),
(136, 'Cabaret', 76, '2019-09-28', 'musical', NULL),
(137, 'A pandamedvék története...', 140, '2018-04-08', NULL, NULL),
(138, 'Most mindenki együtt!', 134, '2013-11-15', NULL, 'magyar'),
(139, 'Mikszáth különös házasságai', 56, '2015-11-14', 'játék', 'magyar'),
(140, 'Tavaszi áldozat', 137, '2014-03-21', 'táncelőadás', NULL),
(141, 'Első kétszáz évem', 64, '2017-09-11', 'monodráma', 'magyar'),
(142, 'K-Arcok', 78, '2021-12-18', 'táncelőadás', NULL),
(143, 'Cirque Invisible', 173, '2012-06-02', NULL, NULL),
(144, 'Film', 36, '2020-12-31', NULL, NULL),
(145, 'Kean, a színész', 36, '2018-03-09', NULL, NULL),
(146, 'MU Terminál A Est, 2014 - együtt elesünk / quietum iter (csendes menetelés)', 8, '2014-11-28', 'táncelőadás', 'magyar'),
(147, 'ATLAS Budapest', 8, '2014-09-04', NULL, NULL),
(148, 'Betörő az albérlőm', 118, '2013-05-11', 'vígjáték', 'magyar'),
(149, 'Vasárnap 16:48', 77, '2012-10-11', 'dráma', 'magyar'),
(150, 'Pesti Coco', NULL, '2021-10-28', NULL, NULL),
(151, 'Jó emberek', 35, '2014-11-28', 'színmű', 'magyar'),
(152, 'A Nagymama', 59, '2019-10-27', 'vígjáték', NULL),
(153, 'Gyerekünk', NULL, '2020-02-16', NULL, NULL),
(154, 'Gondolatok Táncban és Versben', NULL, '2018-09-11', NULL, NULL),
(155, 'A néma levente', 73, '2012-09-21', 'színmű', 'magyar'),
(156, 'Motyó király birodalma', 13, '2020-01-26', 'bábjáték', NULL),
(157, 'A Hang-villa titka', 102, '2020-10-03', 'mesejáték', NULL),
(158, 'Védett férfiak kertje', 127, '2018-02-26', NULL, NULL),
(159, 'Jó estét nyár, jó estét szerelem', 60, '2015-09-06', 'zenés előadás', 'magyar'),
(160, 'Magánélet', 203, '2014-04-04', 'színmű', 'magyar'),
(161, 'Berlin, Alexanderplatz', 34, '2018-03-10', NULL, NULL),
(162, 'Édes Dezső!', 93, '2016-10-07', 'színjáték', 'magyar'),
(163, 'Otthol, édes otthol', 99, '2022-01-22', 'vígjáték', NULL),
(164, 'Rómeó és Júlia', 22, '2016-01-15', 'balett', 'magyar'),
(165, 'Nyitnikék', 13, '2019-09-29', 'zenés bábjáték', NULL),
(166, 'Hűség', 110, '2017-10-14', NULL, 'magyar'),
(167, 'Izgass fel!', NULL, '2019-05-17', 'musical-thriller', NULL),
(168, 'Charley nénje', 109, '2015-12-11', 'zenés vígjáték', 'magyar'),
(169, 'Gershwin Show-Revü', 159, '2012-12-22', 'revü', 'magyar'),
(170, 'Szerb Antal Száz verse - Bálint András estje', 190, '2021-10-03', NULL, NULL),
(171, 'Hamlet', 170, '2017-10-01', 'dráma', 'magyar'),
(172, 'Aranyecset', 22, '2013-10-26', 'balett', 'magyar'),
(173, 'Vaknyugat', 123, '2012-03-31', 'színmű', 'magyar'),
(174, 'Az úrhatnám polgár', 22, '2021-06-12', 'vígjáték', NULL),
(175, 'Forró hétvége', 168, '2014-02-28', 'vígjáték', 'magyar'),
(176, 'Lili bárónő', 109, '2016-10-28', 'operett', 'magyar'),
(177, 'Luxemburg grófja', 32, '2019-09-20', 'operett', NULL),
(178, 'Narrativárium - PapiPanír', NULL, '2021-12-04', NULL, NULL),
(179, 'Minden egér szereti a sajtot', 177, '2014-03-02', 'zenés mesejáték', 'magyar'),
(180, 'NT Live - Alan Bennett: People', 94, '2013-04-02', 'színházi közvetítés', 'angol'),
(181, 'Marie Antoinette', 29, '2016-03-06', 'zenés előadás', 'magyar'),
(182, 'Rose', 68, '2013-11-12', 'színmű', 'magyar'),
(183, 'A holló árnyékában', 56, '2012-10-17', 'színmű', 'magyar'),
(184, 'Férjek és feleségek', 134, '2021-06-20', NULL, NULL),
(185, 'A tündérkirálynő', 22, '2016-06-17', 'opera', 'angol'),
(186, 'Ketten', 90, '2013-10-04', 'improvizáció', 'magyar'),
(187, 'Bál a Savoyban', 148, '2017-04-22', 'operett', 'magyar'),
(188, 'Karamazovok', 140, '2019-05-26', NULL, NULL),
(189, 'Oszkár és Rózsa mami', 38, '2018-02-26', NULL, 'magyar'),
(190, 'Veszedelmes viszonyok', 76, '2020-10-10', NULL, NULL),
(191, 'A Bunkerrajzoló', 195, '2016-11-05', 'zenés előadás', 'magyar'),
(192, 'Valahol Európában', 119, '2016-11-19', 'musical', NULL),
(193, 'DNS', 9, '2018-06-17', NULL, NULL),
(194, 'Rükverc', 21, '2013-01-25', 'színmű', 'magyar'),
(195, 'Az Én Falum / Lang Toi', 173, '2012-01-05', NULL, NULL),
(196, 'A sevillai borbély', 122, '2013-03-22', 'opera', NULL),
(197, 'Shakespeare királynője', 181, '2016-06-24', 'színmű', 'magyar'),
(198, 'Magyar Cirkuszcsillagok', 156, '2015-01-10', 'cirkuszi előadás', NULL),
(199, 'A New York-i páparablás', 100, '2017-03-25', NULL, 'magyar'),
(200, 'A szűz, a sóher, a Mikulás és a többiek', 182, '2013-09-27', 'komédia', 'magyar'),
(201, 'A dzsungel könyve', 185, '2016-10-21', 'musical', 'magyar'),
(202, 'Világtalanok', 130, '2020-11-13', 'ballada', NULL),
(203, 'Bunbury', 58, '2017-01-14', 'komédia', 'magyar'),
(204, 'Moha és Páfrány', 181, '2018-04-27', 'mesejáték', NULL),
(205, 'Pepita', 131, '2018-05-12', NULL, 'magyar'),
(206, 'Domján', 109, '2012-11-16', 'színmű', 'magyar'),
(207, 'Szerelmesek a város felett', 58, '2013-11-29', 'dráma', 'magyar'),
(208, 'Unokák a polcon', 43, '2014-04-26', 'bábjáték', 'magyar'),
(209, 'Paradicsomleves betűtésztával', 112, '2019-12-01', 'zenés bábjáték', NULL),
(210, 'Éjjeli menedékhely', 157, '2014-11-08', 'dráma', 'magyar'),
(211, 'Lila ákác', 129, '2012-09-29', 'színmű', 'magyar'),
(212, 'Esti próba', 64, '2012-10-28', 'színmű', 'magyar'),
(213, 'Korai menyegző', 181, '2019-02-16', NULL, NULL),
(214, 'Szégyen', 132, '2012-06-15', 'színmű', 'magyar'),
(215, 'A mi utcánk', 140, '2014-06-14', 'fizikai színház', 'magyar'),
(216, 'Alul semmi', 50, '2019-05-17', NULL, NULL),
(217, 'Vendégség', 109, '2016-04-29', 'történelmi dráma', 'magyar'),
(218, 'SingSingSing2', 12, '2013-12-28', 'musical show', 'magyar'),
(219, 'Verona', 52, '2019-03-06', 'dráma', NULL),
(220, 'A császár új ruhája', 38, '2018-05-13', 'bábjáték', NULL),
(221, 'Ármányos puncs-pancs', 139, '2019-04-27', 'bábjáték', NULL),
(222, 'Ady!', 181, '2017-02-25', NULL, NULL),
(223, 'Oblom-off', 9, '2017-10-06', 'színmű', 'magyar'),
(224, 'Gardénia', 141, '2012-12-07', NULL, NULL),
(225, 'Hello, Dolly!', 56, '2015-10-17', 'musical', 'magyar'),
(226, 'Bogyó és Babóca', 28, '2018-03-24', 'bábjáték', NULL),
(227, 'Az öreg hölgy látogatása', 50, '2012-01-13', 'tragikomédia', 'magyar'),
(228, 'Vitéz László Ángliában', 43, '2020-01-29', 'bábjáték', NULL),
(229, 'Brand', 140, '2016-03-18', NULL, 'magyar'),
(230, 'Szellőn szökellő', 27, '2020-11-16', 'bábelőadás', NULL),
(231, 'Szoborrá avatom... (That\'s alright with me)', 124, '2013-04-10', 'táncelőadás', 'magyar'),
(232, 'Legyetek jók, ha tudtok', 83, '2019-01-11', 'zenés játék', NULL),
(233, 'Roberto Zucco', 140, '2016-09-15', NULL, 'magyar'),
(234, 'Denevér (ősbemutató)', NULL, '2021-05-12', NULL, NULL),
(235, 'Láthatatlan nő', NULL, '2020-09-03', 'kortárs tánc', NULL),
(236, 'Szumidagava', 140, '2018-10-05', NULL, NULL),
(237, 'Egy, kettő, három', 81, '2016-11-04', 'vígjáték', 'magyar'),
(238, 'A gondnok', 14, '2012-02-10', 'színmű', 'magyar'),
(239, 'Regö rejtem', 151, '2018-11-11', 'mesejáték', NULL),
(240, 'Csongor és Tünde', 73, '2014-09-26', 'színmű', 'magyar'),
(241, 'A világ teremtődése', 202, '2016-01-30', NULL, 'magyar'),
(242, 'Macska a forró bádogtetőn', 134, '2015-11-13', 'színjáték', 'magyar'),
(243, 'Tegnap', 188, '2022-01-17', 'táncelőadás', NULL),
(244, 'Gyere haza, Bánk!', 122, '2017-02-28', 'beavató színház', 'magyar'),
(245, 'János vitézke', NULL, '2020-05-02', 'interaktív mesejáték', NULL),
(246, 'Ifjú Koreográfusok Fóruma+ - Góbi Rita', 78, '2021-06-19', 'táncelőadás', NULL),
(247, 'Ketten egyedül', 152, '2015-05-09', 'színmű', 'magyar'),
(248, 'Utánképzés ittas vezetőknek', 130, '2020-06-20', 'komédia', NULL),
(249, 'Nincstelenek', 140, '2014-09-19', 'színmű', 'magyar'),
(250, 'Aranytó', 68, '2015-07-24', 'színmű', 'magyar'),
(251, 'Eclipse', 91, '2015-12-11', 'táncelőadás', 'magyar'),
(252, 'Ügyes kis hazugságok', 118, '2016-10-13', 'vígjáték', 'magyar'),
(253, 'Bóbita', 28, '2014-04-05', NULL, 'magyar'),
(254, 'Kertész utcai Shaxpeare-mosó', 20, '2019-09-28', NULL, NULL),
(255, 'Csillagok között', 56, '2013-12-07', NULL, 'magyar'),
(256, 'Rettentő görög vitéz', 129, '2013-03-02', NULL, 'magyar'),
(257, 'Csokonai-történetek', 122, '2016-01-01', 'beszélgetés', 'magyar'),
(258, 'Az ezred lánya', 150, '2022-01-14', 'vígopera', NULL),
(259, 'Múviláv - Majdnem mint a filmeken', NULL, '2021-08-06', 'zenés előadás', NULL),
(260, 'A Mindentvarró Tű', 27, '2015-11-01', 'bábelőadás', NULL),
(261, 'Az ajtó', 182, '2016-02-04', NULL, 'magyar'),
(262, 'Fényevők', 34, '2014-02-15', 'színmű', 'magyar'),
(263, 'Szóvirágok', 71, '2015-03-14', 'színmű', 'magyar'),
(264, 'Marslakók', NULL, '2019-03-20', 'talk show', NULL),
(265, 'Vőlegény', 9, '2017-09-29', NULL, 'magyar'),
(266, 'Mekk Elek, az ezermester', 76, '2014-04-28', 'gyermekelőadás', 'magyar'),
(267, 'Orfeusz és Euridiké', 136, '2012-11-17', 'táncelőadás', 'magyar'),
(268, 'Brand', 157, '2015-02-22', 'színmű', 'magyar'),
(269, 'A dzsungel könyve', 112, '2021-11-28', 'zenés mesejáték', NULL),
(270, 'Bakaruhában', 73, '2020-09-26', NULL, NULL),
(271, 'Radar!', 197, '2012-12-21', 'táncelőadás', 'magyar'),
(272, 'Széttört tál', 185, '2016-11-07', NULL, 'magyar'),
(273, 'Micimackó', 24, '2014-05-25', 'gyermekelőadás', 'magyar'),
(274, 'Sok hűhó semmiért', 94, '2013-03-26', 'színházi közvetítés', 'angol'),
(275, 'Lélektől lélekig…, s tovább…', 106, '2021-12-08', 'zenés előadás', NULL),
(276, 'Merlin', 128, '2021-12-12', NULL, NULL),
(277, 'Sosem lehet tudni', 9, '2019-04-05', 'vígjáték', NULL),
(278, 'Bunbury, avagy Szilárdnak kell lenni', 121, '2018-09-28', 'komédia', NULL),
(279, 'Mackó születésnapja', 38, '2015-03-29', 'bábjáték', NULL),
(280, 'Hamlet', NULL, '2021-08-29', NULL, NULL),
(281, 'Hoffmann meséi', 150, '2021-12-04', 'opera', NULL),
(282, 'A gyertyák csonkig égnek', 162, '2012-10-05', 'játék', 'magyar'),
(283, 'Castel Felice', 129, '2017-03-04', 'történelmi dráma', 'magyar'),
(284, 'Hermelin', 32, '2021-10-29', NULL, NULL),
(285, 'Angyali üdvözlet', 144, '2019-02-23', NULL, NULL),
(286, 'Midőn halni készül', 50, '2015-10-27', 'dráma', 'magyar'),
(287, 'Virágot Algernonnak', 195, '2020-09-26', 'színmű', NULL),
(288, 'János vitéz', 134, '2016-10-07', 'daljáték', 'magyar'),
(289, 'A Bandy Lányok', 32, '2016-12-03', 'zenés előadás', 'magyar'),
(290, 'A császár keze', 148, '2015-12-19', 'színmű', 'magyar'),
(291, 'A miskolci gyökerek', NULL, '2018-08-02', 'stand-up comedy', NULL),
(292, 'Csongor és Tünde', 73, '2012-01-12', NULL, NULL),
(293, 'Furcsa pár', 73, '2015-10-21', 'vígjáték', 'magyar'),
(294, 'Színház vagy szex', 10, '2013-09-29', 'vígjáték', 'magyar'),
(295, 're:Verze', 90, '2015-11-14', 'improvizáció', 'magyar'),
(296, 'Szamár a torony tetején', 172, '2012-11-12', 'mesejáték', NULL),
(297, 'Páratlan páros', 134, '2013-01-03', 'bohózat', 'magyar'),
(298, 'Magyarmesék', 34, '2013-02-17', 'színmű', 'magyar'),
(299, 'Fázisok - Függés és Polaritásaim', 78, '2014-09-27', 'táncelőadás', 'magyar'),
(300, 'Idősutazás', 129, '2016-04-30', 'vígjáték', 'magyar'),
(301, 'Siegfried', 22, '2016-03-19', 'zenedráma', 'német'),
(302, 'Kölcsönlakás', 195, '2020-10-24', 'komédia', NULL),
(303, 'Skót mámor', 174, '2017-12-03', 'vígjáték', 'magyar'),
(304, 'Brémai muzsikusok', 140, '2014-10-20', 'színmű', 'magyar'),
(305, 'Mennyország Kft. - Kertész Ricsi önálló estje', 71, '2018-02-10', 'stand-up comedy', NULL),
(306, 'Csokonai Lili - Tizenhét hattyúk', 170, '2012-10-05', 'színmű', 'magyar'),
(307, 'Dunakanyar', 126, '2016-03-22', 'dráma', 'magyar'),
(308, 'Tökéletes menyegző', 7, '2012-05-23', NULL, NULL),
(309, 'Fény által', NULL, '2021-11-04', 'táncelőadás', NULL),
(310, 'The Black Paintings / Blue', 137, '2021-10-01', 'táncjáték', NULL),
(311, 'Akárki', 38, '2012-06-25', 'bábjáték', NULL),
(312, 'Evita', 137, '2016-11-25', 'musical', 'magyar'),
(313, 'Macho men', 124, '2014-10-04', 'színmű', 'szerb'),
(314, 'Mojo', 117, '2018-06-21', NULL, NULL),
(315, 'Amphitryon', 157, '2013-02-23', 'színmű', 'magyar'),
(316, 'Loop - merülés két levegővel', 133, '2017-03-03', NULL, 'magyar'),
(317, 'Balfácánt vacsorára', 95, '2015-07-20', 'bohózat', 'magyar'),
(318, 'A dzsungel könyve', 9, '2014-03-21', 'musical', 'magyar'),
(319, 'Lóvátett lovagok', 60, '2017-09-29', 'komédia', 'magyar'),
(320, 'Illatszertár', 185, '2012-03-30', 'vígjáték', 'magyar'),
(321, 'System 32', 8, '2013-02-22', 'táncelőadás', 'magyar'),
(322, 'Így szerettek ők', NULL, '2016-09-01', 'zenés est', 'magyar'),
(323, 'Az örökség', 200, '2019-02-28', NULL, NULL),
(324, 'Jégvirág cukrászda', 112, '2013-12-01', 'gyermekelőadás', 'magyar'),
(325, 'Árgyélus királyfi', 44, '2019-11-09', NULL, NULL),
(326, 'The Collection (A Gyűjtemény)', 36, '2012-06-09', NULL, 'angol'),
(327, 'Magyar Elektra', 181, '2014-11-21', 'tragédia', 'magyar'),
(328, 'Hárman a padon', 44, '2021-11-16', 'komédia', NULL),
(329, 'Hamlet', 32, '2013-04-14', 'tragédia', 'magyar'),
(330, 'Valahol Európában', 23, '2018-12-21', 'musical', NULL),
(331, 'Táncirkusz', NULL, '2019-11-16', 'balett', NULL),
(332, 'Geppetto és bábuja', 88, '2012-03-10', NULL, 'magyar'),
(333, 'Prozódia', 25, '2014-08-06', 'táncelőadás', 'magyar'),
(334, 'Amadeus', 68, '2014-06-18', 'színmű', 'magyar'),
(335, 'Übü király', 140, '2016-04-12', 'dráma', 'magyar'),
(336, 'A női partőrség szeme láttára', 58, '2014-05-11', 'komédia', 'magyar'),
(337, 'Színházi vándorok', 134, '2014-10-24', NULL, 'magyar'),
(338, 'Jégbe zárt cirkuszvilág - Antarktisz gyermekei', 156, '2017-04-08', 'cirkuszi előadás', NULL),
(339, 'A vadkacsa', 44, '2014-11-14', 'színmű', 'magyar'),
(340, 'Szamár a torony tetején', 144, '2012-02-25', 'mesejáték', 'magyar'),
(341, 'A képzelt beteg, avagy őfelsége komédiása', NULL, '2020-10-30', 'opera', NULL),
(342, 'Maya hajója', 144, '2015-01-16', 'bábjáték', NULL),
(343, 'Domáci Miláčik', 119, '2012-05-23', 'szlovák', NULL),
(344, 'Szerencsés János, avagy az ördög három aranyhajszála', 27, '2016-11-27', 'bábjáték', NULL),
(345, 'Felbukkan egy szombóc', 38, '2012-10-07', 'mesejáték', 'magyar'),
(346, 'Tigris és hiéna', 129, '2013-05-04', NULL, 'magyar'),
(347, 'Frankenstein', 43, '2022-02-25', NULL, NULL),
(348, 'Hamupipőke', 23, '2014-01-17', 'opera', 'magyar'),
(349, 'Tűzoltó leszel, s katona!', 129, '2013-10-12', 'zenés előadás', 'magyar'),
(350, 'Szentivánéji álom', 157, '2014-09-19', 'vígjáték', 'magyar'),
(351, 'Mózes és Jézus Pesten', 64, '2021-09-22', 'kabaré', NULL),
(352, 'Parasztbecsület / Bajazzók', 39, '2012-07-27', 'opera', NULL),
(353, 'Az arc fogalma Isten fiában', 173, '2012-09-25', 'színmű', NULL),
(354, 'Liliomfi', 118, '2019-03-23', 'zenés komédia', NULL),
(355, 'Újévi Operett Gála', 114, '2012-12-31', 'operett gála', 'magyar'),
(356, 'A király beszéde', 181, '2013-12-20', 'dráma', 'magyar'),
(357, 'Csönd', 55, '2021-11-03', 'táncelőadás', NULL),
(358, 'Bányavakság', 181, '2014-02-26', NULL, 'magyar'),
(359, 'Taníts meg kinőni az őrületünket', 173, '2013-03-29', 'táncelőadás', 'izlandi'),
(360, 'A gondnok', 190, '2019-02-24', NULL, NULL),
(361, 'Pimpáré és Vakvarjúcska', 27, '2018-11-25', 'bábjáték', NULL),
(362, 'Bepasiztunk', 118, '2015-11-19', 'zenés előadás', 'magyar'),
(363, 'Azonnal kabaré, avagy instant Comedy', 5, '2017-02-16', NULL, 'magyar'),
(364, 'Kocsonya Mihály házassága', 13, '2017-11-28', 'bábjáték', NULL),
(365, 'Részegek', NULL, '2018-03-30', 'színmű', NULL),
(366, 'Anyegin', 22, '2012-11-03', 'balett', NULL),
(367, 'A jó pálinka itassa magát', 99, '2012-01-20', NULL, 'magyar'),
(368, 'Tartuffe', 23, '2016-04-15', 'komédia', 'magyar'),
(369, 'Tiltott ösvények / Nem én voltam', 199, '2021-11-20', 'balett', NULL),
(370, 'Sicc', 129, '2015-02-21', 'mesejáték', 'magyar'),
(371, 'Mágnás Miska', 9, '2016-12-09', 'operett', 'magyar'),
(372, 'Baal', 26, '2016-03-09', NULL, 'magyar'),
(373, 'Retró szálló', 44, '2018-10-30', 'zenés est', NULL),
(374, 'A kék madár', 13, '2015-09-18', 'zenés mesejáték', NULL),
(375, 'Szépkisnap', 201, '2016-12-06', NULL, 'magyar'),
(376, 'Veszedelmes viszonyok', 99, '2017-12-01', 'színmű', NULL),
(377, 'IZP-estek - Ádám Anna: Utopia/Dystopia', NULL, '2021-07-17', 'táncelőadás', NULL),
(378, 'A trubadúr', 23, '2016-04-08', 'opera', 'olasz'),
(379, 'Csillagszedő Márió', 112, '2013-01-13', 'gyermekelőadás', 'magyar'),
(380, 'A hattyúk tava', 86, '2015-04-25', 'balett', NULL),
(381, 'Proving Ground', 8, '2016-11-18', 'táncelőadás', 'magyar'),
(382, 'Illatszertár', 35, '2012-12-30', 'színmű', 'magyar'),
(383, 'Ascher Tamás Háromszéken', 34, '2017-12-17', 'dráma', 'magyar'),
(384, 'Balta a fejbe', 83, '2018-04-20', 'tragikomédia', NULL),
(385, 'Workshop előadás: Changes', NULL, '2021-06-27', NULL, NULL),
(386, 'Hamlet', 140, '2013-03-27', NULL, 'magyar'),
(387, 'A császár', 34, '2020-03-06', NULL, NULL),
(388, 'Mirandolina', 148, '2021-09-25', 'vígjáték', NULL),
(389, 'Stabat Mater', 73, '2016-04-16', 'táncelőadás', 'magyar'),
(390, 'Tárgytalanul / Sans objet', 173, '2012-09-12', 'újcirkusz', 'francia'),
(391, 'Egy éjszaka Miskolcon', 32, '2016-12-30', NULL, 'magyar'),
(392, 'Utcazenészek', 56, '2012-11-17', 'zenés vígjáték', 'magyar'),
(393, 'Liliom', 170, '2018-12-15', NULL, NULL),
(394, '2_elle_y', 61, '2017-03-31', 'táncelőadás', NULL),
(395, 'III. Richárd', 70, '2013-02-15', 'dráma', 'magyar'),
(396, 'Sej, szellők...', 174, '2016-05-08', NULL, 'magyar'),
(397, 'Meggyeskert', 20, '2013-10-12', 'színmű', 'magyar'),
(398, 'Ül, áll, fekszik', 131, '2018-12-08', 'csecsemő színház', NULL),
(399, 'Ne most, drágám!', 118, '2019-02-01', 'bohózat', NULL),
(400, 'Zárt ajtók', 140, '2019-03-14', NULL, NULL),
(401, 'Underground project', 36, '2020-10-10', NULL, NULL),
(402, 'A sötétben látó tündér', 129, '2013-04-20', NULL, 'magyar'),
(403, 'Forró fej', 31, '2015-07-24', NULL, 'magyar'),
(404, 'Antigoné', 95, '2022-01-29', NULL, NULL),
(405, 'Kaviár és lencse', 73, '2020-09-25', 'komédia', NULL),
(406, 'Szegény Dániel', 121, '2012-01-27', 'krimi', 'magyar'),
(407, 'Csontketreceink', 8, '2012-05-04', NULL, NULL),
(408, 'A diszpécser', 99, '2017-10-14', NULL, 'magyar'),
(409, 'Kerengők - Csongor és Tünde', 54, '2016-04-15', NULL, 'magyar'),
(410, 'My fair lady', 12, '2017-04-01', 'musical', 'magyar'),
(411, 'Állami áruház', 134, '2019-03-01', 'operett', NULL),
(412, 'Luke és Jon', 12, '2015-02-02', NULL, 'magyar'),
(413, '777', 78, '2017-03-11', 'táncelőadás', NULL),
(414, 'Ó, azok a szép napok!', 141, '2013-05-17', 'színmű', 'magyar'),
(415, 'Ahogy tetszik', 198, '2021-10-12', 'táncelőadás', NULL),
(416, 'Lövések a Broadwayn', 152, '2021-09-12', 'musical', NULL),
(417, 'Szép nyári nap', NULL, '2018-08-03', 'musical', NULL),
(418, 'Nem, nem, hanem', 112, '2016-02-20', 'csecsemő színház', 'magyar'),
(419, 'Éhség', 173, '2013-12-04', NULL, 'magyar'),
(420, 'Broadway felett az ég', 35, '2014-11-07', 'musical', 'magyar'),
(421, 'Liliomfi', 56, '2012-12-28', 'vígjáték', 'magyar'),
(422, 'Mirandolina', 130, '2016-02-19', 'vígjáték', 'magyar'),
(423, 'Jeruzsálem', 122, '2016-09-29', NULL, 'magyar'),
(424, 'A király beszéde', 134, '2018-10-06', 'dráma', NULL),
(425, 'A holdbeli csónakos', 1, '2013-01-24', 'színmű', 'magyar'),
(426, 'Ünnep', 32, '2019-01-25', 'dráma', NULL),
(427, 'Sirály', 192, '2015-02-27', NULL, 'magyar'),
(428, 'A víg özvegy', 22, '2014-02-22', 'balett', NULL),
(429, 'A megtorlás napja', 124, '2017-09-28', NULL, 'magyar'),
(430, 'Líra / Forgatagban', NULL, '2018-12-07', 'táncelőadás', NULL),
(431, 'Árnyak és vágyak', 137, '2015-04-17', 'balett', NULL),
(432, 'Amikor meghalnak az angyalok', 64, '2014-11-16', 'színmű', 'magyar'),
(433, 'Frankenstein', 23, '2015-03-06', 'színmű', 'magyar'),
(434, 'Elisabeth', 134, '2021-10-15', 'musical', NULL),
(435, 'Száraz', 124, '2014-03-08', 'színmű', 'magyar'),
(436, 'Szimpla szerda', 23, '2015-10-30', NULL, 'magyar'),
(437, 'Revizor', 70, '2012-06-01', 'komédia', 'magyar'),
(438, 'Tűzpróba avagy a Heilbronni Katica', 129, '2015-01-10', NULL, 'magyar'),
(439, 'Popper és Müller: két mester egy este', 182, '2014-12-29', 'zenés előadás', 'magyar'),
(440, 'Halál Velencében', 79, '2013-11-22', 'színmű', 'magyar'),
(441, 'Elmúlik...', 87, '2016-04-21', 'táncelőadás', 'magyar'),
(442, 'Sok hűhó semmiért', 35, '2015-12-05', 'vígjáték', 'magyar'),
(443, 'A szent család', 181, '2012-04-20', 'komédia', 'magyar'),
(444, 'Ha lesz egy férfinak...', 155, '2012-10-23', NULL, 'magyar'),
(445, 'Boeing, Boeing', 134, '2016-01-08', 'vígjáték', 'magyar'),
(446, 'Rocco és fivérei', 157, '2019-09-19', NULL, NULL),
(447, 'Lili bárónő', 70, '2013-12-06', 'operett', 'magyar'),
(448, 'Bolha a fülbe', 10, '2014-07-19', 'vígjáték', 'magyar'),
(449, 'Top Dogs', 130, '2015-09-25', NULL, 'magyar'),
(450, 'A Noszty fiú esete Tóth Marival', 162, '2015-11-13', 'zenés színmű', 'magyar'),
(451, 'Szekrénymesék', 129, '2012-02-18', 'bábjáték', 'magyar'),
(452, 'Marshal Fifty-Six', 49, '2021-10-16', NULL, NULL),
(453, 'Jávor: A fenegyerek, a színművész és az ember', 64, '2016-09-13', 'zenés játék', 'magyar'),
(454, 'Gala', 173, '2017-03-16', 'táncelőadás', NULL),
(455, 'Bál a Savoyban', 59, '2020-09-17', 'operett', NULL),
(456, 'Bánk bán', 105, '2014-11-25', 'dráma', 'magyar'),
(457, 'Leselkedők', 15, '2014-08-21', 'színmű', 'magyar'),
(458, 'A bábjátékos', 12, '2016-01-09', 'rockopera', 'magyar'),
(459, 'Chioggiai csetepaté', 181, '2018-03-09', 'komédia', NULL),
(460, 'Tévedések vígjátéka', 192, '2019-02-09', 'vígjáték', NULL),
(461, 'Don Juan visszatér', 200, '2018-11-25', NULL, NULL),
(462, 'Otaku - Otthon Japánban', 32, '2013-10-20', NULL, 'magyar'),
(463, 'Kripli Mari', NULL, '2014-11-13', 'színmű', 'magyar'),
(464, 'A dzsungel könyve', 47, '2012-11-25', NULL, NULL),
(465, 'Blue Hotel', 180, '2013-02-06', 'színmű', 'magyar'),
(466, 'Naplók', 129, '2013-01-12', 'színjáték', 'magyar'),
(467, 'Vénusz nercben', 44, '2014-04-24', NULL, 'magyar'),
(468, 'Oldás-Áldás', 18, '2021-06-11', 'monodráma', NULL),
(469, 'Coriolanus', 129, '2014-03-08', 'tragédia', 'magyar'),
(470, 'Vörös ördögök', 187, '2018-05-26', NULL, NULL),
(471, 'Sóvirág', 133, '2015-10-13', 'táncelőadás', 'magyar'),
(472, 'Szöktetés a szerájból', 150, '2020-05-01', 'daljáték', NULL),
(473, 'Terror', 76, '2018-02-24', NULL, NULL),
(474, 'Rokonok', 109, '2018-09-28', 'dráma', NULL),
(475, 'Függöny fel!', 134, '2018-01-05', NULL, NULL),
(476, 'Ahogy tetszik', 9, '2016-10-14', 'vígjáték', 'magyar'),
(477, 'Nem élhetek muzsikaszó nélkül', 162, '2013-09-20', 'vígjáték', 'magyar'),
(478, 'A tizenegyes kórterem', 36, '2016-11-11', NULL, 'magyar'),
(479, 'Négy évszak - A falka', 32, '2018-11-15', 'táncjáték', NULL),
(480, 'Apák és fiúk', 34, '2021-12-18', NULL, NULL),
(481, '80 nap alatt a Föld körül', 193, '2013-02-21', 'táncelőadás', 'magyar'),
(482, 'Macbeth', 129, '2018-10-19', NULL, NULL),
(483, 'Kockavarázs', 139, '2019-12-14', 'csecsemő színház', NULL),
(484, 'Batu-tá kalandjai', 38, '2017-09-03', 'mesejáték', 'magyar'),
(485, 'Bölcs Náthán', 165, '2012-04-13', 'dráma', NULL),
(486, 'Műhely bemutató varieté', 8, '2017-03-28', 'táncelőadás', NULL),
(487, 'Pereg a film... zene', 79, '2012-09-21', 'zenés összeállítás', 'magyar'),
(488, 'Két magas nő meg Ő', 201, '2017-05-06', NULL, 'magyar'),
(489, 'Ruy Blas', 32, '2018-01-26', 'színmű', NULL),
(490, 'Szerencsés flótás', 200, '2012-08-02', 'operett', 'magyar'),
(491, 'Lángolj!', 96, '2013-05-26', 'színmű', 'magyar'),
(492, 'Cabaret', 140, '2020-03-28', NULL, NULL),
(493, 'Levél egy meg nem született gyermekhez', 109, '2012-10-24', 'színmű', 'magyar'),
(494, 'Birdie', 19, '2015-04-17', 'táncelőadás', NULL),
(495, 'A nagy Gatsby', 199, '2015-11-06', 'táncelőadás', NULL),
(496, 'Plázs - Hurrá, nyaralunk!', 38, '2013-02-17', NULL, 'magyar'),
(497, 'Negyed', 199, '2019-05-10', 'táncelőadás', NULL),
(498, 'Ben Hur', 118, '2017-02-11', 'komédia', 'magyar'),
(499, 'Hurrá, Kacabajka!', 139, '2018-10-29', 'mesejáték', NULL),
(500, 'Zimmezumm', 4, '2012-03-10', NULL, 'magyar'),
(501, 'Csoportterápia', 73, '2018-03-23', 'mjuzikelkámedi', NULL),
(502, 'Züfec', 110, '2014-10-24', 'színmű', 'magyar'),
(503, 'Demencia', 132, '2013-10-15', 'színmű', NULL),
(504, 'A Nyugat lánya', NULL, '2018-12-01', 'opera', NULL),
(505, 'In_Time', 198, '2019-11-06', 'táncjáték', NULL),
(506, 'Közelebb!', 99, '2014-12-13', NULL, 'magyar'),
(507, 'Női posta - Oláh Ibolya színházkoncertje', NULL, '2020-12-19', 'koncert', NULL),
(508, 'Liliomfi', 20, '2012-10-05', 'vígjáték', 'magyar'),
(509, 'Emlékezz rám!', 160, '2013-10-26', NULL, 'magyar'),
(510, 'Ory grófja', 122, '2019-02-08', 'opera', NULL),
(511, 'Egy ember az örökkévalóságnak', 157, '2019-02-16', NULL, NULL),
(512, 'A kaméliás hölgy', 130, '2016-11-11', 'romantikus vígjáték ', 'magyar'),
(513, 'Déjá Vu', 32, '2021-10-01', NULL, NULL),
(514, 'Hippolyt, a lakáj', 109, '2013-11-22', 'zenés vígjáték', 'magyar'),
(515, 'Másolat / Utsushi', 173, '2012-10-05', 'táncelőadás', 'japán'),
(516, 'Csárdáskirálynő', 17, '2016-07-28', 'nagyoperett', 'magyar'),
(517, 'Rigoletto', 23, '2013-03-22', 'opera', 'olasz'),
(518, 'A méhek istene', 160, '2019-12-07', NULL, NULL),
(519, 'Bárkibármikor', 49, '2014-10-09', 'színmű', 'magyar'),
(520, 'Origami mesék', 32, '2013-10-08', 'gyermekelőadás', 'magyar'),
(521, 'Pájinkás János', 140, '2018-04-17', NULL, NULL),
(522, 'Homokrajzok', 189, '2019-10-16', 'balett', NULL),
(523, 'Szépek és átkozottak', 140, '2020-01-18', NULL, NULL),
(524, 'Übü király', 134, '2018-02-16', 'mesejáték', NULL),
(525, 'Don Juan', 32, '2019-10-04', 'vígjáték', NULL),
(526, 'Hamupipőke', 88, '2014-04-27', 'gyermekelőadás', 'magyar'),
(527, 'A kő', 60, '2021-09-18', NULL, NULL),
(528, 'Hófehérke és a hét törpe', 56, '2020-10-03', 'zenés mesejáték', 'magyar'),
(529, 'Boribon, a király', 95, '2014-02-21', 'zenés mesejáték', 'magyar'),
(530, 'Paravarieté', 6, '2017-12-02', 'zenés játék', 'magyar'),
(531, 'Utazás a koponyám körül', 83, '2014-02-02', 'színmű', 'magyar'),
(532, 'Az eastwicki boszorkányok', 163, '2019-02-23', 'színjáték', NULL),
(533, 'Bérgyilkos a barátom', 152, '2016-10-08', NULL, 'magyar'),
(534, 'Tangó', 20, '2012-12-21', 'színmű', 'magyar'),
(535, 'Angyalok szárnyalása', 50, '2016-11-14', NULL, 'magyar'),
(536, 'Hetedhét varázslat', 51, '2017-05-10', 'zenés játék', 'magyar'),
(537, 'Jonatán', 194, '2015-11-15', 'színmű', 'magyar'),
(538, 'SzélKatona József Színház', NULL, '2018-03-03', NULL, NULL),
(539, 'Koppélia', 129, '2015-10-10', 'mesejáték', 'magyar'),
(540, 'Az édes teher', 149, '2016-04-29', 'zenés bohózat', 'magyar'),
(541, 'Hogyan találtak egymásra a nők és a férfiak', 140, '2018-10-02', 'mozgásszínház', NULL),
(542, 'Öt ablak a látás nyelvtana', 31, '2013-07-19', 'zenés előadás', 'magyar'),
(543, 'Csinibaba', 195, '2018-10-27', 'zenés előadás', NULL),
(544, 'Teljes lényeddel', 152, '2018-11-30', NULL, NULL),
(545, 'Üvegfal mögött', 34, '2013-11-28', 'színmű', 'magyar'),
(546, 'Tök Magda kalandjai - A csodaszérum', 106, '2021-10-25', 'zenés mesejáték', NULL),
(547, 'Veszedelmes viszonyok', 163, '2018-03-23', NULL, NULL),
(548, 'A sárkány kertje / A távolság mechanikája', NULL, '2019-05-26', 'táncelőadás', NULL),
(549, 'Kert', 8, '2012-10-12', 'táncelőadás', 'magyar'),
(550, 'Tévedések vígjátéka', NULL, '2019-07-06', 'vígjáték', NULL),
(551, 'Szentivánéji álom', 30, '2021-12-18', NULL, NULL),
(552, 'Két úr szolgája', 12, '2013-10-05', 'komédia', 'magyar'),
(553, 'Az univerzum fényei', 156, '2013-10-05', 'cirkuszi előadás', 'magyar'),
(554, 'Őfelsége komédiása', 95, '2014-10-18', 'színmű', 'magyar'),
(555, 'Nóra', 34, '2016-12-20', NULL, 'magyar'),
(556, 'Karády Katalin: A Díva', 64, '2017-09-16', 'zenés játék', 'magyar'),
(557, 'A régi nyár', 73, '2019-09-27', 'operett', NULL),
(558, 'Ármány és szerelem', 99, '2020-02-07', 'színmű', NULL),
(559, 'Kitaszított (Disgraced)', 182, '2019-09-20', NULL, NULL),
(560, 'PszichoAn(n)alízis (Kosztolányi Dezső: Édes Anna)', 153, '2013-11-16', 'színmű', 'magyar'),
(561, 'Interview', NULL, '2020-02-13', NULL, NULL),
(562, 'Az aranyember – ősbemutató', NULL, '2021-04-12', NULL, NULL),
(563, 'Momo', 32, '2015-11-27', 'zenés mesejáték', 'magyar'),
(564, '...Sem emlék, sem varázslat...', 44, '2016-05-08', 'önálló est', 'magyar'),
(565, 'A Pál utcai fiúk', 170, '2016-11-05', 'zenés játék', 'magyar'),
(566, 'A skizofrén', 123, '2016-06-10', 'táncelőadás', 'magyar'),
(567, 'A játék vége', NULL, '2018-04-13', 'színmű', NULL),
(568, 'A bagoly, aki félt a sötétben', 88, '2016-10-01', 'bábelőadás', NULL),
(569, 'Rítus', 163, '2014-03-20', NULL, 'magyar'),
(570, 'Szerelmi bájital', 23, '2016-01-15', 'vígopera', 'magyar'),
(571, 'Furcsa pár (Női változat)', 95, '2014-03-29', 'komédia', 'magyar'),
(572, 'Illúziók', 79, '2017-03-03', 'dramatizált játék', 'magyar'),
(573, 'Litera-túra', 130, '2016-05-09', NULL, 'magyar'),
(574, 'Leánder és Lenszirom', 148, '2020-11-07', 'mesejáték', NULL),
(575, 'Kérem, én még nem játszottam', 79, '2017-11-07', NULL, 'magyar'),
(576, 'Toldi', 60, '2014-04-04', NULL, 'magyar'),
(577, 'Ópiumkeringő', 83, '2019-02-15', NULL, NULL),
(578, 'A fösvény', 50, '2015-12-12', 'vígjáték', 'magyar'),
(579, 'Jegyzetek', 55, '2014-12-06', 'táncelőadás', 'magyar'),
(580, 'K. Szabó Csenger: Rozsdás éberség', NULL, '2019-09-21', 'táncelőadás', NULL),
(581, 'Egyik kicsi, másik nagy', 112, '2013-11-02', 'csecsemő színház', 'magyar'),
(582, 'Az ügy', 34, '2018-12-19', 'bohózat', NULL),
(583, 'Ünnep', 182, '2019-09-28', 'zenés vígjáték', NULL),
(584, 'Szibériai csárdás', 129, '2015-04-25', 'zenés játék', 'magyar'),
(585, 'Kacsa, Halál, Tulipán', 140, '2019-09-15', NULL, NULL),
(586, 'Fafeye, a tenger ész', 185, '2012-09-28', 'zenés játék', 'magyar'),
(587, 'Szép napok', 34, '2014-01-24', 'színmű', 'magyar'),
(588, 'Álarcosbál', 77, '2013-04-26', 'színmű', 'magyar'),
(589, 'A padlás', 70, '2020-12-07', 'mesemusical', NULL),
(590, 'Az álom féltestvére', 200, '2013-01-19', 'színmű', 'magyar'),
(591, 'Weöres Kaviár', 9, '2019-12-29', 'varieté', NULL),
(592, 'A csodálatos kalucsni', 47, '2020-02-16', 'mesejáték', NULL),
(593, 'Hétköznapi őrületek', 9, '2017-11-24', 'színmű', 'magyar'),
(594, 'Jancsi és Juliska', 131, '2017-09-23', 'bábjáték', 'magyar'),
(595, 'Rómeó és Júlia', 122, '2016-02-19', 'tragédia', 'magyar'),
(596, 'Hannibál tanár úr', 181, '2013-03-22', 'dráma', 'magyar'),
(597, 'Közel - távol', NULL, '2020-02-28', 'táncelőadás', NULL),
(598, 'Notesz - Hanyas vagy, Radnóti?', 138, '2017-03-24', NULL, 'magyar'),
(599, 'Dominógyilkosság', 114, '2021-06-04', 'krimi', NULL),
(600, 'Ványabácsi', 23, '2017-09-29', NULL, 'magyar'),
(601, 'A vak király', 26, '2021-12-02', NULL, NULL),
(602, 'Marica grófnő', 134, '2013-09-27', 'operett', 'magyar'),
(603, 'A játékos', 190, '2017-05-07', NULL, 'magyar'),
(604, 'Antigoné', NULL, '2018-03-19', 'táncelőadás', NULL),
(605, 'Pöttöm Panna', 131, '2017-10-07', 'bábjáték', 'magyar'),
(606, 'A holdbéli csónakos', 38, '2015-11-29', NULL, NULL),
(607, 'Fehérlófia', 12, '2016-04-25', 'zenés mesejáték', 'magyar'),
(608, 'John Gabriel Borkman', 60, '2018-12-14', NULL, NULL),
(609, 'Credo', 137, '2019-02-28', 'táncelőadás', NULL),
(610, 'Nappalok és éjszakák', 76, '2016-10-07', NULL, 'magyar'),
(611, 'A bagoly', 16, '2012-11-30', 'abszurd játék', 'magyar'),
(612, 'Az aranyszőrű bárány', 27, '2018-10-14', 'mesejáték', NULL),
(613, 'Szikramanók - Karácsonyi kaland a cirkuszban', 156, '2018-10-20', 'cirkuszi előadás', NULL),
(614, 'Át az ingoványon', 110, '2016-04-23', NULL, 'magyar'),
(615, 'Diskurzusművész(t)estek - Harakyrie Eleison', 158, '2013-10-05', NULL, 'magyar'),
(616, 'Aida', 150, '2015-04-04', 'opera', 'olasz'),
(617, 'Amadeus', 23, '2017-12-22', 'színmű', NULL),
(618, 'A maláji lány', 56, '2015-04-18', 'zenés vígjáték', 'magyar'),
(619, 'A mi osztályunk', 76, '2017-10-06', NULL, 'magyar'),
(620, 'A lányom pasiját szeretem', 182, '2020-07-28', NULL, NULL),
(621, 'Kismama-kaland - 280 nap alatt a pocak körül', 122, '2015-11-06', NULL, 'magyar'),
(622, 'Van kérdés!', 164, '2015-05-14', NULL, 'magyar'),
(623, 'Augusztus Oklahomában', 122, '2018-11-16', 'komédia', NULL),
(624, 'A kutya különös esete az éjszakában', 35, '2014-03-08', 'színmű', 'magyar'),
(625, 'Felejtő', NULL, '2018-09-27', NULL, NULL),
(626, 'Törvényen belül', NULL, '2020-01-06', NULL, NULL),
(627, 'Tűzrőlpattant Tündérország', 122, '2015-01-13', 'musical', 'magyar'),
(628, 'A nevető ember', 148, '2012-12-15', 'dráma', 'magyar'),
(629, 'A Víg özvegy', 59, '2020-03-01', 'operett', NULL),
(630, 'Száll a kakukk fészkére...', 97, '2018-06-02', NULL, NULL),
(631, 'Egy nap dátum nélkül / Magdalena', 14, '2013-04-27', NULL, 'magyar'),
(632, 'Hárman a padon', 73, '2018-10-13', 'színmű', NULL),
(633, 'Ahogy azt az apám elképzelte', 179, '2012-04-23', 'táncelőadás', 'magyar'),
(634, 'Összezárva', NULL, '2021-07-09', 'komédia', NULL),
(635, 'Hol egymást találjuk', NULL, '2021-08-28', 'performance', NULL),
(636, 'Búcsúfia', NULL, '2018-06-16', NULL, NULL),
(637, 'Hová lett a kommunizmus?', 124, '2013-03-01', NULL, 'magyar'),
(638, 'A lakatlan sziget', 22, '2014-11-23', 'opera', NULL),
(639, 'A nadrág', 121, '2015-11-13', 'komédia', 'magyar'),
(640, 'Tudós nők', 129, '2016-04-23', 'vígjáték', 'magyar'),
(641, 'A játszma vége', 9, '2021-05-14', 'színmű', NULL),
(642, 'kettős:játék', 40, '2016-02-20', NULL, 'magyar'),
(643, 'Részegek', 157, '2016-11-19', NULL, 'magyar'),
(644, 'Tartuffe', 99, '2012-11-30', 'komédia', 'magyar'),
(645, 'Metmamorfózis', 25, '2020-11-03', 'táncelőadás', NULL),
(646, 'Advent Hargitán', 182, '2019-12-05', 'dráma', NULL),
(647, 'Diótörő', 32, '2012-12-14', 'mesebalett', 'magyar'),
(648, 'Tóték', 23, '2018-09-28', 'groteszk', NULL),
(649, 'Veszélyes forduló', 121, '2019-11-08', 'játék', NULL),
(650, 'Terrorizmus', 95, '2015-10-01', NULL, 'magyar'),
(651, 'Hippolütosz', 157, '2017-04-09', NULL, 'magyar'),
(652, 'Alszanak a halak?', 73, '2021-11-02', 'monodráma', NULL),
(653, 'k2 HírHalász Program: CUCLI III. rész', NULL, '2020-02-26', NULL, NULL),
(654, 'Férfiak, nők és férfiak', 140, '2016-12-10', NULL, 'magyar'),
(655, 'Fase', 173, '2012-05-15', NULL, 'magyar'),
(656, 'Harlem Swing - Ne rosszalkodj!', 35, '2012-11-16', 'musical', 'magyar'),
(657, 'Amber', NULL, '2021-09-07', 'táncelőadás', NULL),
(658, 'Nero', 130, '2012-01-22', NULL, NULL),
(659, 'Amőba - az örökké változó Egység', NULL, '2019-05-11', 'táncelőadás', NULL),
(660, 'Sárkány a szekrényben', 50, '2019-09-20', 'zenés mesejáték', NULL),
(661, 'Mercedes Benz', 95, '2019-04-13', NULL, NULL),
(662, 'Ismerős történet', 155, '2019-10-26', NULL, NULL),
(663, 'Úri muri', 129, '2020-02-22', NULL, NULL),
(664, 'A muzsika hangja', 83, '2015-11-27', 'musical', 'magyar'),
(665, 'Időfutár', 83, '2018-10-13', 'zenés játék', NULL),
(666, 'Melinda álma', NULL, '2019-04-11', 'táncelőadás', NULL),
(667, 'Kurázsi mama és gyerekei', 190, '2012-10-12', 'színmű', 'magyar'),
(668, 'Megtisztulás - Mikve', 95, '2020-03-07', NULL, NULL),
(669, 'A padlás', 37, '2018-05-18', 'musical', NULL),
(670, 'Víz, víz, tiszta víz', 112, '2016-04-10', NULL, 'magyar'),
(671, 'Illatszertár', 32, '2014-12-05', 'vígjáték', 'magyar'),
(672, 'Illatszertár', 9, '2014-01-31', 'vígjáték', 'magyar'),
(673, 'Kálmán Imre, az operettkirály', 64, '2019-10-17', NULL, NULL),
(674, 'Kulcskeresők', 126, '2021-10-14', 'színjáték', NULL),
(675, 'Irma, te Édes', 73, '2014-11-21', 'színmű', 'magyar'),
(676, 'A tizenháromszáz', 45, '2020-02-28', 'táncelőadás', NULL),
(677, 'Szerettem őt', 79, '2012-04-26', 'színmű', 'magyar'),
(678, 'Lady Chatterley szeretője', 166, '2019-12-14', NULL, NULL),
(679, 'Csoda korban élünk', 152, '2017-10-07', NULL, 'magyar'),
(680, 'Ketten', 203, '2019-02-08', NULL, NULL),
(681, 'Asszony asszonynak farkasa', 129, '2018-01-12', NULL, NULL),
(682, 'X&Y', 19, '2013-04-18', 'táncelőadás', 'magyar'),
(683, 'Csin-csin', 182, '2016-03-10', NULL, 'magyar'),
(684, 'Eörsi István: Emlékezés a régi szép időkre - börtönmonológ', 20, '2016-10-21', 'monodráma', NULL),
(685, 'Örömünnep - Johann Sebastiann Bach világi kantátái alapján', 22, '2018-05-11', NULL, NULL),
(686, 'A muzsika hangja', 185, '2013-12-13', 'musical', 'magyar'),
(687, 'Valaki jön majd', 79, '2013-05-23', 'színmű', 'magyar'),
(688, 'Oidipusz nyomozás', 102, '2013-10-24', 'krimi', 'magyar'),
(689, 'A Hold szerelmesei', 38, '2016-04-29', NULL, NULL),
(690, 'Homokpuzzle', 14, '2012-03-23', 'színmű', 'magyar'),
(691, 'A Turbin család napjai', 181, '2017-10-28', NULL, 'magyar'),
(692, 'Fényességes csillag', 183, '2012-03-11', 'misztériumjáték', NULL),
(693, 'IZP - Nagy Lili: Was Ms. de Beauvoir right? / Vasas Művek: EXIsT', NULL, '2020-11-07', 'táncelőadás', NULL),
(694, 'A bukás', 182, '2020-09-14', 'monodráma', NULL),
(695, 'A hattyúk tava', 115, '2015-11-27', 'táncjáték', NULL),
(696, 'Ghost', 29, '2013-06-01', 'musical', 'magyar'),
(697, 'Torzonborz 2. - Torzonborz visszatér', 4, '2016-10-01', 'bábelőadás', NULL),
(698, 'El kell mondanom', 79, '2021-09-13', NULL, NULL),
(699, 'ÁJLÁVJU, de jó vagy, légy más', 130, '2017-03-10', 'musical', 'magyar'),
(700, 'Szentivánéji álom', 61, '2012-01-19', 'táncelőadás', 'magyar'),
(701, 'Hajnalban, délben, este', 83, '2016-01-29', 'vígjáték', 'magyar'),
(702, 'Bethlen téri kabaré', 123, '2013-03-20', 'stand-up comedy', 'magyar'),
(703, 'Müller táncosai', 181, '2018-03-17', 'táncelőadás', NULL),
(704, 'Tesztoszteron', 122, '2019-04-26', 'vígjáték', NULL),
(705, 'Az én kis hűtőkamrám', 95, '2019-10-11', NULL, NULL),
(706, 'Filter', 78, '2012-02-10', NULL, 'magyar'),
(707, 'Meselevelek', 32, '2014-10-10', 'mesejáték', 'magyar'),
(708, 'Vasarely-etűdök', 115, '2021-04-15', 'balett', NULL),
(709, 'Godspell', 182, '2014-08-08', 'musical', 'magyar'),
(710, 'Hajnal hasad', 181, '2020-10-13', NULL, NULL),
(711, 'Gesztenyéskert', 74, '2021-12-19', 'mesejáték', NULL),
(712, 'Érintések', 107, '2013-03-08', 'táncelőadás', 'magyar'),
(713, 'Szerelmes Shakespeare', 148, '2021-09-16', 'romantikus vígjáték ', NULL),
(714, 'Isten bolondja - II. rész', 157, '2021-12-14', NULL, NULL),
(715, 'Fém', 93, '2016-12-03', NULL, 'magyar'),
(716, '999', NULL, '2020-11-04', NULL, NULL),
(717, '39 lépcsőfok', 114, '2017-10-13', 'tragikomédia', 'magyar'),
(718, 'Szélkötő Kalamona', 187, '2018-09-29', 'mesemusical', NULL),
(719, 'Az apostol', NULL, '2019-09-26', NULL, NULL),
(720, 'Játék a kastélyban', 99, '2019-05-24', 'vígjáték', NULL),
(721, 'A kaktusz virága', 182, '2021-12-25', 'zenés vígjáték', NULL),
(722, 'Nercbanda', 121, '2016-12-16', 'musical', 'magyar'),
(723, 'Sok hűhó semmiért', 44, '2017-03-10', 'komédia', 'magyar'),
(724, 'A testőr', 76, '2012-09-29', 'vígjáték', 'magyar'),
(725, 'Mirandolina', 73, '2012-04-13', 'vígjáték', 'magyar'),
(726, 'Beszélj hozzám / Tűzmadár szvit', 115, '2017-01-30', 'táncelőadás', NULL),
(727, 'Delila', 35, '2018-03-09', 'vígjáték', NULL),
(728, 'Holle anyó', 43, '2017-04-21', 'bábelőadás', 'magyar'),
(729, 'Érintés / Shoku', 173, '2013-09-24', 'táncelőadás', NULL),
(730, 'Házasság Palermóban', 157, '2017-11-18', NULL, 'magyar'),
(731, 'Ariadné Naxoszban', 22, '2013-05-17', 'opera', NULL),
(732, 'Nyolckor a bárkán', 134, '2015-10-14', 'zenés mesejáték', 'magyar'),
(733, 'Piszkos meló', 141, '2013-10-04', 'színmű', 'magyar'),
(734, 'A csúnya', 181, '2014-01-08', 'komédia', 'magyar'),
(735, 'A Mester és Margarita', 170, '2014-10-12', 'dráma', 'magyar'),
(736, 'A nagymama', 44, '2018-10-26', 'vígjáték', NULL),
(737, 'Torzmása', 74, '2021-09-03', NULL, NULL),
(738, 'Helver éjszakája', 24, '2012-10-05', 'színmű', 'magyar'),
(739, 'A testőr', 95, '2012-04-13', 'vígjáték', 'magyar'),
(740, 'Sirály', 143, '2018-09-29', NULL, NULL),
(741, 'Leonce és Léna', 14, '2017-12-09', NULL, 'magyar'),
(742, 'Click', 78, '2015-11-14', 'táncelőadás', 'magyar'),
(743, 'Márton partjelző fázik', 9, '2019-10-25', 'színmű', NULL),
(744, 'A furfangos menyasszony', 149, '2017-05-06', 'zenés vígjáték', 'magyar'),
(745, 'Berzsián és Dideki', 105, '2012-06-04', NULL, NULL),
(746, 'Tánckánon - Hommage á Kodály', 84, '2017-04-21', 'táncelőadás', NULL),
(747, 'Dalok a szobából', NULL, '2021-09-26', NULL, NULL),
(748, 'Bíborsziget', 170, '2018-10-12', 'vígjáték', NULL),
(749, 'Az óceán kincsei', NULL, '2020-09-28', 'táncelőadás', NULL),
(750, 'Csizmás kandúr', 102, '2013-10-12', 'gyermekelőadás', 'magyar'),
(751, 'Tikiriki-Takarak', 38, '2014-10-05', 'gyermekelőadás', NULL),
(752, 'Stiffelio', 22, '2013-04-08', 'opera', NULL),
(753, '39 lépcsőfok', 23, '2021-11-12', 'krimi vígjáték', NULL),
(754, 'Jiddis Világ', 64, '2015-09-08', 'színmű', 'magyar'),
(755, 'Diótörő', NULL, '2018-12-14', 'balett', NULL),
(756, 'Titkaink', 49, '2013-09-28', 'színmű', 'magyar'),
(757, 'Nyitott ablak', 44, '2018-09-28', 'zenés játék', NULL),
(758, 'Egy bizonyítás körvonalai', 9, '2018-05-18', 'színmű', NULL),
(759, 'Vackor nyomában', 132, '2017-12-16', 'mesemusical', 'magyar'),
(760, 'Az arany kígyó', 182, '2020-02-15', NULL, NULL),
(761, 'Násztánc', 84, '2016-04-15', 'táncelőadás', 'magyar'),
(762, 'A vágy villamosa', 32, '2012-12-01', 'színmű', 'magyar'),
(763, 'Fiatalság, bolondság', 130, '2012-03-18', 'zenés játék', 'magyar'),
(764, 'Kabaré', 32, '2018-03-23', 'musical', NULL),
(765, 'A vihar', 43, '2018-09-26', 'bábjáték', NULL),
(766, 'Édes bosszú', 56, '2018-03-10', 'vígjáték', NULL),
(767, 'Vesztegzár a Grand Hotelben', 50, '2015-10-02', 'zenés vígjáték', 'magyar'),
(768, 'Ferenczi és Freud', 64, '2017-11-25', NULL, 'magyar'),
(769, 'Valamit valamiért - avagy Ki ölte meg Marilyn Monroe-t?', 187, '2015-12-10', 'thriller', 'magyar'),
(770, 'Szomszédnéni együtt és külön', 71, '2018-01-25', NULL, NULL),
(771, 'Fedák Sári', 157, '2015-10-28', NULL, 'magyar'),
(772, 'Túl a Maszat-hegyen', 165, '2013-10-12', 'zenés játék', NULL),
(773, 'Kakuk Marci', 143, '2013-12-14', 'vígjáték', 'magyar'),
(774, 'Futótűz', 200, '2012-02-24', NULL, 'magyar'),
(775, 'Godot-ra várva', 34, '2014-04-26', 'színmű', 'magyar'),
(776, 'Egri csillagok', 50, '2020-01-14', 'musical', NULL),
(777, 'AZnavour', 123, '2014-05-05', 'színmű', 'magyar'),
(778, 'Művészet', 140, '2020-02-28', NULL, NULL),
(779, 'Az ezeregyéjszaka másnapján', NULL, '2018-03-14', NULL, NULL),
(780, 'Forró vizet a kopaszra', 196, '2019-10-09', 'mesejáték', NULL),
(781, 'A tanú', 195, '2019-02-16', 'vígjáték', NULL),
(782, 'Szomorú vasárnap', 118, '2018-03-29', 'musical', NULL),
(783, 'Bolha a fülbe', 32, '2021-10-15', 'vígjáték', NULL),
(784, 'Naplemente előtt', 102, '2019-01-26', NULL, NULL),
(785, 'Bohémélet', 23, '2021-10-22', 'opera', NULL),
(786, 'A harmadik hullám', 77, '2012-11-10', 'színmű', 'magyar'),
(787, 'Queendom', 135, '2017-11-24', NULL, 'magyar'),
(788, 'Sirály avagy 80 kiló szerelem', 76, '2015-02-28', 'színjáték', 'magyar'),
(789, 'Hajszál híján Hollywood', 100, '2017-10-27', 'vígjáték', 'magyar'),
(790, 'Galamb', 194, '2014-12-13', 'abszurd játék', 'magyar'),
(791, 'Demó verzió', 72, '2015-05-29', 'táncelőadás', 'magyar'),
(792, 'Sacre', 11, '2019-11-26', 'táncelőadás', NULL),
(793, 'A halott város', 122, '2012-01-27', 'opera', NULL),
(794, 'Othello Gyulaházán', 108, '2012-10-05', 'vígjáték', NULL),
(795, 'UNTITLED - a meditation in one act', 8, '2014-09-17', 'táncelőadás', 'magyar'),
(796, 'Shirley Valentine', NULL, '2016-10-11', 'komédia', 'magyar'),
(797, 'A vád tanúja', 114, '2020-02-08', NULL, NULL),
(798, 'Piroskaland', 131, '2016-09-24', 'bábjáték', NULL),
(799, 'A legnagyobb tilos!', 73, '2017-10-25', 'gyermekelőadás', NULL),
(800, 'A tengerkék kutyus', 116, '2014-08-30', 'gyermekelőadás', 'magyar');
INSERT INTO `eloadas` (`id`, `cim`, `szinhazid`, `datum`, `mufaj`, `nyelv`) VALUES
(801, 'Jövőre veled, ugyanitt', 44, '2017-11-04', 'romantikus vígjáték ', 'magyar'),
(802, 'A beszélő köntös', 134, '2018-10-05', 'musical', NULL),
(803, 'A helység kalapácsa', 181, '2012-08-01', 'komédia', 'magyar'),
(804, 'Az őslakó (The Man From Earth)', 182, '2019-01-01', NULL, NULL),
(805, 'Szent Johanna', 73, '2016-11-25', 'színmű', 'magyar'),
(806, 'Zorba, a görög', 39, '2014-07-04', 'táncelőadás', 'magyar'),
(807, 'Magyar táncok', 130, '2014-03-07', 'táncelőadás', NULL),
(808, 'Tanulni, tanulni, tanulni', 173, '2012-04-19', 'színmű', 'magyar'),
(809, 'A fösvény', 143, '2013-03-09', 'színmű', 'magyar'),
(810, 'A hallgatás ÁFA', 5, '2015-10-15', 'kabaré', 'magyar'),
(811, 'Yerma-sorsok', 36, '2020-03-07', NULL, NULL),
(812, 'Momo', 30, '2014-12-10', 'zenés mesejáték', 'magyar'),
(813, 'Család ellen nincs orvosság', 168, '2016-12-17', NULL, 'magyar'),
(814, '33 álom', 20, '2021-10-01', NULL, NULL),
(815, 'A Montmartre-i ibolya', 44, '2013-04-12', 'operett', 'magyar'),
(816, 'A tékozló fiú', NULL, '2018-03-25', NULL, NULL),
(817, 'Pöttöm Panna', 162, '2013-03-02', 'zenés mesejáték', 'magyar'),
(818, 'A Platonov', 34, '2019-03-08', NULL, NULL),
(819, 'Leonce és Léna', 134, '2021-11-19', NULL, NULL),
(820, 'Férfiak, nők, Fellini', 199, '2015-03-08', 'balett', NULL),
(821, 'A legkisebb boszorkány', 32, '2019-09-28', 'zenés mesejáték', NULL),
(822, 'Náthán gyermekei', 157, '2012-02-04', 'színmű', 'magyar'),
(823, 'Zorba, a görög', 32, '2016-01-16', 'musical', 'magyar'),
(824, 'Szegény Dzsoni és Árnika', 80, '2016-04-20', 'táncjáték', 'magyar'),
(825, 'Kamaszok', 109, '2016-12-14', 'táncelőadás', NULL),
(826, 'Vuk', 129, '2016-11-26', 'mesejáték', 'magyar'),
(827, 'Művészet', 152, '2020-09-04', NULL, NULL),
(828, 'Pletykák', 32, '2012-01-27', 'bohózat', 'magyar'),
(829, 'Egy jobb világ', 152, '2021-10-30', NULL, NULL),
(830, 'Agria kabaré!', 109, '2012-03-13', NULL, 'magyar'),
(831, 'Egy csók és más semmi', 44, '2020-10-02', 'operett', NULL),
(832, 'Igazságtalanság', 130, '2016-10-23', 'történelmi dráma', 'magyar'),
(833, 'Anna Karenina', 77, '2013-03-22', 'dráma', 'magyar'),
(834, 'Névtelen hősök', NULL, '2020-11-07', 'opera', NULL),
(835, 'Álommese (Kívül-Belül) – csecsemőszínházi előadás', 28, '2019-11-30', 'csecsemő színház', NULL),
(836, 'Facér pasi naplója', 83, '2012-11-16', 'színmű', 'magyar'),
(837, 'A Pál utcai fiúk', 95, '2017-09-16', 'zenés játék', 'magyar'),
(838, 'A vízzel szemben', 171, '2015-12-09', 'színmű', 'magyar'),
(839, 'Black Comedy', 35, '2012-03-08', 'bohózat', 'magyar'),
(840, 'Zűrzavaros éjszaka', 9, '2014-05-09', 'komédia', 'magyar'),
(841, 'Monoton', NULL, '2018-03-09', 'táncelőadás', NULL),
(842, 'Helló, Héraklész!', 43, '2021-10-09', 'bábelőadás', NULL),
(843, 'ELMARAD! - VII. Olivér', 111, '2020-03-28', NULL, NULL),
(844, 'Játék a kastélyban', 109, '2012-04-20', 'vígjáték', 'magyar'),
(845, 'A vihar', 20, '2012-05-12', 'színmű', 'magyar'),
(846, 'A dzsungel könyve', 99, '2012-01-13', 'musical', 'magyar'),
(847, 'Furcsa pár (női változat)', 102, '2020-11-28', 'komédia', NULL),
(848, 'Punktum!', 30, '2018-10-11', 'mesejáték', NULL),
(849, 'Lúdas Matyi', 4, '2018-09-29', 'bábjáték', NULL),
(850, 'Dzsungelmese, avagy Kisoroszlán keresi a sörényét', 4, '2014-04-26', 'gyermekelőadás', 'magyar'),
(851, 'Walter, a falra festett sárkány', 113, '2014-09-28', 'gyermekelőadás', NULL),
(852, 'Chioggiai csetepaté', 83, '2015-10-16', 'komédia', 'magyar'),
(853, 'Romok igaz menedék', 7, '2012-09-19', 'táncelőadás', NULL),
(854, 'Közel a vég', 8, '2012-03-30', NULL, 'magyar'),
(855, 'Vidám kísértet', 73, '2016-10-07', 'vígjáték', 'magyar'),
(856, 'LOVE\'n Go', 197, '2013-02-05', 'akció-performansz', 'magyar'),
(857, 'Angyal lesen', NULL, '2019-12-20', 'táncelőadás', NULL),
(858, 'Mary Poppins', 118, '2012-09-21', 'musical', 'magyar'),
(859, 'Vas Laci', 27, '2021-10-31', 'bábelőadás', NULL),
(860, 'Cuhorka Emese, Fülöp László: Szabadulóművészek', NULL, '2020-11-29', 'táncelőadás', NULL),
(861, 'ELMARAD! - ICTUSCORDIS: Dialogue', NULL, '2020-03-20', 'táncelőadás', NULL),
(862, 'Zrínyi 1566', 185, '2019-10-11', 'rock-musical', NULL),
(863, 'Jancsi és Juliska', 116, '2017-11-26', 'bábjáték', 'magyar'),
(864, 'Mit eszik a micsoda?', 4, '2018-03-31', 'bábelőadás', 'magyar'),
(865, 'Hangyaboly', 134, '2012-10-05', 'színmű', 'magyar'),
(866, 'Figaro házassága', 134, '2016-04-22', 'vígjáték', 'magyar'),
(867, 'Zimmer Frei: Family Affair / Budapest', 45, '2016-04-15', 'doku-színház', 'magyar'),
(868, 'Bohémélet', 99, '2022-01-15', 'opera', NULL),
(869, 'Leszek az özvegyed', 149, '2014-03-28', 'komédia', 'magyar'),
(870, 'Elfelejti, belebotlik...', 55, '2017-02-15', 'táncelőadás', NULL),
(871, 'Terülj, terülj, asztalkám', 186, '2012-02-05', 'mesejáték', NULL),
(872, 'Ma éjjel szabad vagyok', 149, '2013-05-04', 'bohózat', 'magyar'),
(873, 'Holdodiglan', 116, '2019-09-01', 'bábjáték', NULL),
(874, 'A tanítónő', 148, '2012-09-29', 'színmű', 'magyar'),
(875, 'Terecske', 67, '2016-07-07', NULL, 'magyar'),
(876, 'Téltánc', 32, '2017-12-08', 'balett', NULL),
(877, 'Zerline, a szobalány története', 23, '2012-12-14', 'színmű', 'magyar'),
(878, 'Once / Egyszer...', 118, '2019-09-20', 'musical', NULL),
(879, 'Angliai Második Edward élete', 134, '2012-11-30', 'színmű', 'magyar'),
(880, 'Kaputt', 71, '2015-03-27', NULL, 'magyar'),
(881, 'Csudavilág', 73, '2016-01-22', NULL, 'magyar'),
(882, 'A nép ellensége', 70, '2017-02-03', NULL, NULL),
(883, 'Ablak', 89, '2015-02-15', NULL, 'magyar'),
(884, 'A bolygó hollandi', 39, '2016-07-01', 'opera', 'magyar'),
(885, 'Musical pályázat: A tegnap holnapja / Shakespeare Zrt.', 118, '2021-07-12', 'musical', NULL),
(886, 'Liolá', 69, '2012-11-06', NULL, NULL),
(887, 'A revizor', 134, '2021-06-03', 'komédia', NULL),
(888, 'A pandák gyönyörű utazása', 138, '2018-11-10', NULL, NULL),
(889, 'Valahol Európában', 99, '2021-10-09', 'musical', NULL),
(890, 'Vénusz nercben', 60, '2012-11-23', 'színmű', 'magyar'),
(891, 'Állatkerti történet', 95, '2019-11-28', 'zenés mesejáték', NULL),
(892, 'Carmen', 115, '2014-10-24', 'balett', NULL),
(893, 'Négyeshatos', 144, '2012-05-11', 'színmű', 'magyar'),
(894, 'Irodai patkányok', NULL, '2020-09-18', 'zenés előadás', NULL),
(895, 'Még egy táncelőadás', 179, '2020-01-21', 'táncelőadás', NULL),
(896, 'Legénylakás', 35, '2019-12-21', 'zenés vígjáték', NULL),
(897, 'DROSZT - Budapest - Éjszaka - Taxi', 161, '2013-10-10', 'színmű', 'magyar'),
(898, 'Caligula', 95, '2018-10-05', 'abszurd dráma', NULL),
(899, 'Szóló szőlő, mosolygó alma, csengő barack', 27, '2018-01-28', 'bábjáték', NULL),
(900, 'Én, Te Őt!', 121, '2013-09-13', 'komédia', 'magyar'),
(901, 'Panka és a Mumus', 56, '2015-10-04', 'mesejáték', 'magyar'),
(902, 'Marvin szobája', 6, '2019-05-03', NULL, NULL),
(903, 'No exit', 25, '2020-12-01', 'táncelőadás', NULL),
(904, 'Tagadj, tagadj, tagadj', 68, '2017-09-16', NULL, 'magyar'),
(905, 'VANmeSe', 183, '2017-06-13', 'zenés mesejáték', NULL),
(906, 'Előttem az élet', 79, '2014-05-08', 'színmű', 'magyar'),
(907, 'Prah', 163, '2017-01-13', NULL, 'magyar'),
(908, 'A tökéletes boldogság világa', 34, '2017-03-11', NULL, 'magyar'),
(909, 'Léthatár', 193, '2019-02-21', 'táncelőadás', NULL),
(910, 'Figaro házassága', 148, '2014-10-04', 'színmű', 'magyar'),
(911, 'Don Carlos', 95, '2013-01-12', 'drámai költemény', 'magyar'),
(912, 'Apácák', NULL, '2021-06-27', NULL, NULL),
(913, 'Rómeo és Júlia', 109, '2015-02-27', 'tragédia', 'magyar'),
(914, 'Túlvilági utazók', 120, '2017-01-12', 'tragikomédia', 'magyar'),
(915, 'Az ügynök halála', 134, '2018-11-23', 'dráma', NULL),
(916, 'Csókos asszony', 109, '2012-10-05', 'operett', 'magyar'),
(917, 'A denevér', 122, '2016-10-07', 'operett', 'magyar'),
(918, 'Rítus', 137, '2013-11-08', 'táncjáték', NULL),
(919, 'Mestermunka', NULL, '2019-02-22', NULL, NULL),
(920, 'Bolondok hajója', 36, '2016-05-26', NULL, 'magyar'),
(921, 'Itthon maradok / Joyful!', NULL, '2020-10-11', 'balett', NULL),
(922, 'A végítélet napja', 34, '2013-10-19', 'színmű', 'magyar'),
(923, 'A nép ellensége', 23, '2016-11-04', 'színmű', 'magyar'),
(924, 'A csend szigetei', 178, '2013-04-05', 'táncelőadás', 'magyar'),
(925, 'Sírkő és kakaó', 163, '2013-05-17', 'zenés színmű', 'magyar'),
(926, 'A Szép, a Szende és a Szeleburdi', 195, '2020-08-25', 'zenés mesejáték', NULL),
(927, 'A gyáva kistigris', 38, '2019-05-12', 'bábelőadás', NULL),
(928, 'Tündér Lala', 38, '2015-05-10', 'bábjáték', NULL),
(929, 'A Varázshegy', 162, '2012-01-27', NULL, 'magyar'),
(930, 'Szökdelés a szerájból', 22, '2016-03-06', 'vígopera', 'magyar'),
(931, 'Ne hisztizz', 107, '2014-05-16', 'táncelőadás', 'magyar'),
(932, 'Morcos Borz ünnepe', 106, '2019-12-15', 'mesejáték', NULL),
(933, 'Furnitur', 141, '2012-02-25', 'színmű', 'magyar'),
(934, 'Pipás Pista', 23, '2013-01-25', 'színmű', 'magyar'),
(935, 'Az arany ára', 70, '2014-02-21', NULL, 'magyar'),
(936, 'Magyar Elektra', 99, '2018-02-16', 'tragédia', NULL),
(937, 'Hazatér', 31, '2014-07-24', 'színmű', 'magyar'),
(938, 'Rosmersholm', 32, '2014-01-31', 'színmű', 'magyar'),
(939, 'Belső Gyermek', 200, '2012-05-29', NULL, 'magyar'),
(940, 'Az oroszlán télen', 117, '2017-12-21', 'dráma', NULL),
(941, 'Cirkuszhercegnő', 32, '2018-09-21', NULL, NULL),
(942, 'Fehérlófia', 4, '2014-03-01', 'bábjáték', 'magyar'),
(943, 'ELMARAD! - Magyar elektra', 122, '2020-03-13', 'tragédia', NULL),
(944, 'My Fair Lady', 73, '2012-12-31', 'musical', NULL),
(945, 'Hetedhét - Mesék a Kék Bolygóról', 148, '2013-05-04', NULL, 'magyar'),
(946, 'Vibration', 107, '2018-02-09', 'táncelőadás', NULL),
(947, 'SZERETŐK - Az érzékek titkos ösvényein', 153, '2013-05-23', NULL, 'magyar'),
(948, 'Play Krúdy!', 182, '2017-02-04', 'színmű', 'magyar'),
(949, 'Toldi', 50, '2013-12-17', 'zenés mesejáték', 'magyar'),
(950, 'Baal', 15, '2014-12-18', 'színmű', 'magyar'),
(951, 'Az ember tragédiája 2.0', 95, '2021-09-25', 'színjáték', NULL),
(952, 'Zsuzsi kisasszony', 73, '2021-05-13', 'operett', NULL),
(953, 'Lakásavató', 140, '2018-10-12', NULL, NULL),
(954, 'Az ember tragédiája 1.', 95, '2018-12-01', 'dráma', NULL),
(955, 'Bartók titkos színháza', NULL, '2019-10-01', 'opera', NULL),
(956, 'H LH T TL NS G', 184, '2017-02-03', NULL, 'magyar'),
(957, 'Leenane szépe', 35, '2015-01-24', 'színmű', 'magyar'),
(958, 'Oszlopos Simeon', 202, '2019-12-17', NULL, NULL),
(959, 'A kis herceg', 182, '2020-12-06', 'gyerekműsor', NULL),
(960, 'Boeing, Boeing - Leszállás Párizsban', 195, '2018-12-01', 'vígjáték', NULL),
(961, 'János vitéz', 32, '2019-03-06', 'balett', NULL),
(962, 'Ma este megbukunk', 35, '2015-09-27', 'színmű', 'magyar'),
(963, 'A vesztaszűz', 22, '2018-04-03', 'opera', NULL),
(964, 'Az öldöklés istene', 73, '2021-10-16', 'bohózat', NULL),
(965, 'Hekabé', 95, '2015-11-18', 'táncjáték', NULL),
(966, 'Én a szabadságot választottam', 128, '2015-11-14', 'színmű', 'magyar'),
(967, 'SUB.LAB.PRO: Topáz', NULL, '2021-12-17', 'táncelőadás', NULL),
(968, 'New York csalogánya', 23, '2021-12-28', 'vígjáték', NULL),
(969, 'Huzatos Ház', NULL, '2018-04-20', NULL, NULL),
(970, 'Orfeusz és Euridiké', 115, '2015-04-24', 'balett', NULL),
(971, 'A szemüveges szirén', 122, '2018-03-19', NULL, NULL),
(972, 'Hatan pizsamában', 163, '2014-02-28', 'vígjáték', 'magyar'),
(973, 'Max és Móric', 88, '2018-03-11', 'bábjáték', NULL),
(974, 'Spinoza és Rembrandt', 64, '2013-04-10', 'zenés játék', 'magyar'),
(975, 'Helené', 171, '2014-11-24', NULL, NULL),
(976, 'Hoppárézimi', 182, '2021-07-07', NULL, NULL),
(977, 'Irma, te édes', 56, '2017-11-18', 'zenés komédia', NULL),
(978, 'A dzsungel könyve', 119, '2012-07-24', 'táncjáték', 'magyar'),
(979, 'A Menedék', 62, '2020-09-04', NULL, NULL),
(980, 'Bolondos mesék', 139, '2019-10-05', 'bábjáték', NULL),
(981, 'Két hold világa', 92, '2021-08-13', NULL, NULL),
(982, 'CMMN SNS PRJCT', 8, '2016-11-26', 'táncelőadás', NULL),
(983, 'Sardar Tagirovsky: Diótörő', 36, '2019-12-31', NULL, NULL),
(984, 'A sötétben látó tündér', 181, '2015-05-29', 'gyermekelőadás', 'magyar'),
(985, 'Viszlát a levegőben', 193, '2020-09-29', 'táncelőadás', NULL),
(986, 'Szőllősi Krisztina: A falka', NULL, '2021-07-17', 'táncelőadás', NULL),
(987, 'Az elvarázsolt egérkisasszony', 139, '2014-10-11', 'bábjáték', NULL),
(988, 'Hazudj inkább, kedvesem!', 114, '2018-01-06', 'bűnügyi komédia', NULL),
(989, 'Csongor és Tünde', 109, '2014-02-28', 'táncjáték', 'magyar'),
(990, 'Viktória', 32, '2016-09-23', 'operett', 'magyar'),
(991, 'Fidelio', 150, '2020-12-16', 'opera', NULL),
(992, 'Sok alvó közt semmi dolgom nékem', 31, '2014-07-31', NULL, 'magyar'),
(993, 'Most Budapest', NULL, '2019-04-27', NULL, NULL),
(994, 'A férfiak a fejükre estek', 56, '2017-03-18', 'zenés vígjáték', 'magyar'),
(995, 'MU Terminál: Generáció X', NULL, '2019-12-13', 'táncelőadás', NULL),
(996, 'Álomgyár', 157, '2018-10-02', NULL, NULL),
(997, 'Mamó', NULL, '2021-06-10', NULL, NULL),
(998, 'Dzson Meklén vagyok', 74, '2021-09-11', 'vígjáték', NULL),
(999, 'Rómeó és Júlia', 156, '2017-10-02', 'cirkuszi előadás', NULL),
(1000, 'Hajmeresztő', 35, '2017-10-20', NULL, 'magyar'),
(1001, 'Lady Budapest', 29, '2016-10-21', 'operett', 'magyar'),
(1002, 'Vörös izzás - Fehér rózsa', 87, '2016-10-21', NULL, 'magyar'),
(1003, 'Pinokkió', 112, '2017-02-26', 'bábjáték', 'magyar'),
(1004, 'Toldi', 130, '2018-03-23', 'musical', NULL),
(1005, 'Ricse, Ricse, Beatrice', 162, '2017-11-24', 'musical', 'magyar'),
(1006, 'A nagy Gatsby', 170, '2019-09-07', 'zenés előadás', NULL),
(1007, 'Gulag - Piros ló - Nowadays - bemutakoznak a fizikaisok', NULL, '2018-12-20', NULL, NULL),
(1008, 'Dogma', NULL, '2019-05-19', NULL, NULL),
(1009, 'Ármány és szerelem', 134, '2017-02-24', NULL, 'magyar'),
(1010, 'Aladdin', 189, '2020-04-28', 'mesebalett', NULL),
(1011, 'Apa csak 1 van', 168, '2019-12-06', 'vígjáték', NULL),
(1012, 'Fishez', NULL, '2020-10-18', NULL, NULL),
(1013, 'Starfactory', 195, '2015-04-18', 'musical', 'magyar'),
(1014, 'Maggi és Lillemor - Mamu alatt izzik a parázs', 6, '2021-03-07', 'vígjáték', NULL),
(1015, 'Az aranyszőrű bárány', 151, '2018-03-18', 'mesejáték', NULL),
(1016, 'The Show Must Go On', 173, '2014-04-10', 'táncelőadás', NULL),
(1017, 'A százholdas pagony meséi', 38, '2013-11-02', 'gyermekelőadás', 'magyar'),
(1018, 'A konyha', 83, '2015-10-02', 'színmű', 'magyar'),
(1019, 'Az Őrült Nők Ketrece', 81, '2014-07-12', 'zenés előadás', 'magyar'),
(1020, 'Rumcájsz', 43, '2020-09-12', 'bábjáték', NULL),
(1021, 'Finito', 181, '2012-04-27', 'komédia', 'magyar'),
(1022, 'Lúdas Matyi', 181, '2016-03-31', 'mesejáték', 'magyar'),
(1023, 'Az üvegcipő', 12, '2013-11-23', 'vígjáték', 'magyar'),
(1024, 'opera amorale', 158, '2013-05-04', 'táncelőadás', 'magyar'),
(1025, 'Rigócsőr király', 88, '2016-03-25', 'bábjáték', 'magyar'),
(1026, 'Kié vagy, mondd?', NULL, '2017-01-14', 'zenés előadás', 'magyar'),
(1027, 'Madárka', 201, '2018-05-03', NULL, NULL),
(1028, 'Őszi szonáta', 68, '2016-03-28', 'színjáték', 'magyar'),
(1029, 'Régimódi történet', 122, '2013-11-29', 'színmű', 'magyar'),
(1030, 'Csücsök, avagy a nagy pudinghajsza', 28, '2021-09-18', 'gyerekműsor', NULL),
(1031, 'Veszedelmes viszonyok', 44, '2014-02-07', 'színmű', 'magyar'),
(1032, 'A sevillai borbély', 73, '2012-10-19', 'vígjáték', NULL),
(1033, 'Császárok napja - Az elrontott ünnep - Philippus Arabs', 9, '2017-04-12', NULL, 'magyar'),
(1034, 'Földrengés Londonban', 170, '2016-04-01', 'színmű', 'magyar'),
(1035, 'A nép ellensége', 194, '2012-03-24', 'dráma', 'magyar'),
(1036, 'Függöny fel!', 35, '2013-10-18', 'komédia', 'magyar'),
(1037, 'Dada Cabaret', 128, '2016-10-20', NULL, 'magyar'),
(1038, 'A bolondok grófja', 162, '2013-10-11', 'énekes bohóság', 'magyar'),
(1039, 'A teljes tizedik évad', 77, '2012-04-27', 'színmű', 'magyar'),
(1040, 'Tanár úr kérem!', 121, '2018-03-23', 'zenés játék', NULL),
(1041, 'Edgar', 22, '2019-06-01', 'opera', NULL),
(1042, 'Radioaktív', 201, '2018-02-17', NULL, NULL),
(1043, 'Nóra', 99, '2017-12-02', 'színmű', NULL),
(1044, 'Cyrano', 32, '2019-03-22', 'színmű', NULL),
(1045, 'Táncórák', 79, '2018-09-14', NULL, NULL),
(1046, 'Egy kis furfang', 168, '2021-12-18', 'komédia', NULL),
(1047, 'Egy elsurranó patkány', 157, '2012-10-14', 'színmű', 'magyar'),
(1048, 'kiNŐttem', NULL, '2020-09-06', NULL, NULL),
(1049, 'Protokoll', 190, '2012-01-22', 'színmű', NULL),
(1050, 'A két Lotti', 30, '2016-09-30', NULL, NULL),
(1051, 'Én a négyzeten', 169, '2014-05-06', 'pantomim', 'magyar'),
(1052, '1984', 23, '2020-10-09', 'színmű', NULL),
(1053, 'Sztár leszel!', 56, '2022-01-15', 'zenés vígjáték', NULL),
(1054, 'Chicago', 129, '2018-01-20', NULL, NULL),
(1055, 'Földes László HOBO: Vadászat', 157, '2021-09-29', 'zenés dráma', NULL),
(1056, 'Faust', 22, '2015-05-17', 'opera', 'francia'),
(1057, 'A mindentlátó királylány', 131, '2016-11-25', 'bábjáték', NULL),
(1058, 'Dallam', 124, '2014-02-01', 'színmű', 'magyar'),
(1059, 'Az eltört korsó', 32, '2014-06-06', 'vígjáték', 'magyar'),
(1060, 'Üvegfigurák', 190, '2017-12-16', NULL, 'magyar'),
(1061, 'Oberfrank Réka-MU Színház: Miracle / Molnár Csaba-MU Színház: Ördög', NULL, '2021-12-18', 'táncelőadás', NULL),
(1062, 'Ha átléped a küszöbünk', 140, '2020-09-07', NULL, NULL),
(1063, 'Izeg-mozog!', 112, '2016-10-08', 'csecsemő színház', 'magyar'),
(1064, 'Immortel', 191, '2018-05-28', 'táncelőadás', NULL),
(1065, 'Itt vagyok!', 88, '2019-10-31', 'csecsemő színház', NULL),
(1066, 'A hatodik napon', 79, '2021-10-26', NULL, NULL),
(1067, 'Csakazértis szerelem', 56, '2014-03-01', 'zenés játék', 'magyar'),
(1068, 'Holdfény mulató', 85, '2017-08-04', 'musical', 'magyar'),
(1069, 'Félúton (Balett + Kőszegi Ákos)', 134, '2017-05-12', 'táncelőadás', NULL),
(1070, 'A Rózsák háborúja', 85, '2012-07-19', 'komédia', 'magyar'),
(1071, 'Edith és Marlene', 70, '2018-02-23', 'zenés játék', NULL),
(1072, 'Élet-ritmusra', 23, '2021-12-11', 'monodráma', NULL),
(1073, 'Jonatán és a többiek', 129, '2014-02-22', 'gyermekelőadás', 'magyar'),
(1074, 'Déryné hadművelet', 143, '2016-12-02', NULL, 'magyar'),
(1075, 'Hófehérke avagy a Varázstükör krónikái', 112, '2012-02-04', 'mesejáték', 'magyar'),
(1076, 'Bakkhánsnők', 32, '2016-10-01', 'zenés játék', 'magyar'),
(1077, 'A királykisasszony, aki nem mehetett el a bálba', 139, '2015-12-05', NULL, NULL),
(1078, 'Viharok', 14, '2013-10-24', 'színmű', 'magyar'),
(1079, 'A pillangók szabadok', 134, '2019-04-12', 'romantikus vígjáték ', NULL),
(1080, 'Kutyaharapás', 14, '2016-09-10', NULL, 'magyar'),
(1081, 'A sötétben látó tündér', 32, '2014-12-11', 'mesejáték', 'magyar'),
(1082, 'Kőszív', 139, '2017-04-29', 'mesejáték', 'magyar'),
(1083, 'Cirkusz a javából!', 156, '2012-03-24', NULL, 'magyar'),
(1084, 'A szving meg a tangó', 12, '2019-02-23', 'táncjáték', NULL),
(1085, 'Meseautó', 99, '2017-02-17', 'zenés vígjáték', 'magyar'),
(1086, 'Kazamaták', 23, '2018-02-09', 'színmű', NULL),
(1087, 'A hetvenkedő katona', 60, '2013-03-10', 'komédia', 'magyar'),
(1088, 'Hófehérke és a hét törpe', 115, '2018-02-12', 'mesebalett', NULL),
(1089, 'NT Live - James Graham: This House', 94, '2013-05-17', 'színházi közvetítés', 'angol'),
(1090, 'Szexpedíció', 182, '2019-05-24', 'vígjáték', NULL),
(1091, 'Határvidékek', 123, '2013-09-24', 'táncelőadás', 'magyar'),
(1092, 'Az alvó Királylány', 142, '2014-11-27', NULL, 'magyar'),
(1093, 'A tengerkék kutyus', 30, '2012-03-03', 'mesejáték', 'magyar'),
(1094, 'A Fura', 68, '2016-12-17', NULL, 'magyar'),
(1095, 'Minden máshogy van', NULL, '2018-06-13', NULL, NULL),
(1096, 'West side story', 23, '2012-02-18', 'musical', 'magyar'),
(1097, 'Valahol Európában', 130, '2017-05-12', 'musical', 'magyar'),
(1098, 'Play', 130, '2014-10-28', 'táncmesejáték', NULL),
(1099, 'Arabella', 22, '2012-03-17', 'opera', 'német'),
(1100, 'A muzsika hangja', 148, '2015-12-12', 'musical', 'magyar'),
(1101, 'Süss fel, nap!', 112, '2018-03-10', 'csecsemő színház', NULL),
(1102, 'A férfiagy - avagy nincs itt valami ellentmondás?', 152, '2013-10-12', 'vígjáték', 'magyar'),
(1103, 'Pomádé király új ruhája', 148, '2017-12-16', 'gyerekopera', NULL),
(1104, 'Háromnegyed', 160, '2015-03-21', NULL, NULL),
(1105, 'Kiállok magamért', 89, '2021-10-15', NULL, NULL),
(1106, 'Mit csinálsz, ha...', 32, '2013-10-05', 'gyermekelőadás', 'magyar'),
(1107, 'Az őrült nő naplója', 56, '2018-12-20', 'zenés játék', NULL),
(1108, 'A kaukázusi krétakör', 21, '2017-05-26', NULL, 'magyar'),
(1109, 'Anna Karenina', 32, '2016-10-28', 'táncjáték', 'magyar'),
(1110, 'Macskajáték', 157, '2019-12-14', NULL, NULL),
(1111, 'Évszakok', 139, '2018-12-08', 'csecsemő színház', NULL),
(1112, 'Szegény Dzsoni és Árnika', 181, '2018-09-19', 'mesejáték', NULL),
(1113, 'Veled, Uram!', 29, '2012-03-30', 'rockopera', 'magyar'),
(1114, 'Rigócsőr királyfi', 109, '2020-10-20', 'mesejáték', NULL),
(1115, 'Hello, Dolly!', 73, '2016-03-04', 'musical', 'magyar'),
(1116, 'A doktor úr', 99, '2012-03-09', 'bohózat', 'magyar'),
(1117, 'P - avagy jelenetek egy vándorszínész életéből', 164, '2018-02-11', NULL, NULL),
(1118, 'Kedves Marcipán', 88, '2018-05-12', 'mesejáték', NULL),
(1119, 'Búcsú a szerelemtől', 79, '2013-02-07', 'színmű', 'magyar'),
(1120, 'Fairplay - Sportóriások legendája', 61, '2017-08-13', 'táncelőadás', NULL),
(1121, 'Császármorzsa', 162, '2021-06-04', 'tragikomédia', NULL),
(1122, 'A hold foglyai', 92, '2014-07-22', 'színmű', 'magyar'),
(1123, 'Te tudod, én élem', 96, '2016-10-28', NULL, 'magyar'),
(1124, 'Bálsój szerelem a Málenkij robot idején', NULL, '2021-11-26', NULL, NULL),
(1125, 'Svejk, a derék elsőháborús katona', 23, '2014-11-21', 'vígjáték', 'magyar'),
(1126, 'George&Cole', 140, '2017-02-11', 'zenés előadás', 'magyar'),
(1127, 'A híd (Error)', 99, '2021-10-22', 'színpadi játék', NULL),
(1128, 'Énekes madár', 99, '2018-12-07', NULL, NULL),
(1129, 'Hacsek és Sajó, no meg a harmadik', 64, '2012-03-03', 'kabaré', 'magyar'),
(1130, 'Laurencia', 150, '2020-03-06', 'balett', NULL),
(1131, 'Lear', 197, '2015-04-17', 'fizikai színház', 'magyar'),
(1132, 'Apácák', 126, '2021-12-02', 'musical', NULL),
(1133, 'Appassionata', 187, '2017-04-29', 'dráma', 'magyar'),
(1134, 'Keep in touching', 91, '2016-04-29', 'táncelőadás', 'magyar'),
(1135, 'Félőlény', 32, '2018-09-29', 'zenés mesejáték', NULL),
(1136, 'Mesterhármas', 79, '2017-02-09', NULL, 'magyar'),
(1137, 'Finito', 148, '2013-01-26', 'komédia', 'magyar'),
(1138, 'Nyolckor a bárkán', 99, '2015-09-26', 'gyermekelőadás', 'magyar'),
(1139, 'A négy évig tartó őrség', 22, '2018-05-17', NULL, NULL),
(1140, 'És már senki sem, avagy a Tíz kicsi néger', 114, '2014-02-15', 'bűnügyi komédia', 'magyar'),
(1141, 'Szentivánéji álom', 22, '2016-05-27', 'opera', 'angol'),
(1142, 'A mi kis városunk', 73, '2020-01-31', NULL, NULL),
(1143, 'Pilátus', 64, '2021-10-09', 'monodráma', NULL),
(1144, 'Budapesti Útikalauz időutazóknak', NULL, '2021-09-03', 'újcirkusz', NULL),
(1145, 'Életrevalók', 114, '2017-02-04', 'vígjáték', 'magyar'),
(1146, 'A félkegyelmű', 9, '2013-03-01', 'színmű', 'magyar'),
(1147, 'Csak kétszer vagy fiatal', 56, '2013-10-12', NULL, 'magyar'),
(1148, 'SunCity - a Holnap Tali!-musical', 83, '2017-11-17', 'musical', 'magyar'),
(1149, 'Az álmok valóra válnak', 123, '2015-04-17', 'táncelőadás', 'magyar'),
(1150, 'Bolha a fülbe', 190, '2012-03-25', 'vígjáték', 'magyar'),
(1151, 'Cájtstükk', 110, '2016-11-15', NULL, 'magyar'),
(1152, 'Az ember tragédiája', 157, '2018-10-19', NULL, NULL),
(1153, 'Kígyómarás', 12, '2014-03-01', 'színmű', 'magyar'),
(1154, 'Pillangó', 129, '2015-02-28', NULL, 'magyar'),
(1155, 'Borsószem hercegkisasszony', 131, '2014-12-16', 'bábjáték', NULL),
(1156, 'Hippolyt', 68, '2013-07-04', 'színmű', 'magyar'),
(1157, 'A súgó', 157, '2020-01-05', NULL, NULL),
(1158, 'Mezítláb a parkban', 50, '2015-12-08', NULL, 'magyar'),
(1159, 'Cselédek', 111, '2015-10-02', 'színmű', 'magyar'),
(1160, 'Vérnász', 140, '2013-10-18', 'színmű', 'magyar'),
(1161, 'Peer Gynt', 141, '2012-09-19', 'táncelőadás', 'magyar'),
(1162, 'Pettson és Findusz - A váratlan vendég', 88, '2019-03-16', 'bábjáték', NULL),
(1163, 'Steinerék', 155, '2017-06-03', NULL, 'magyar'),
(1164, 'Vadkacsa', 32, '2020-02-13', 'színmű', NULL),
(1165, 'Tapasztalt asszony', 48, '2012-10-16', NULL, 'magyar'),
(1166, 'Voks', 133, '2012-02-02', NULL, 'magyar'),
(1167, 'Abigail bulija', 21, '2015-01-16', 'színmű', 'magyar'),
(1168, 'Pom Pom meséi', 13, '2017-04-03', 'bábjáték', NULL),
(1169, 'Tündérszép Ilona és Árgyélus királyfi', 36, '2013-11-30', 'mesejáték', 'magyar'),
(1170, 'Éden', 140, '2018-01-27', NULL, NULL),
(1171, 'A kőszívű ember fiai', 73, '2017-03-03', 'színmű', 'magyar'),
(1172, 'Rozsda Lovag és Fránya Frida', 29, '2021-12-10', 'operett', NULL),
(1173, 'Óz, a nagy varázsló', 7, '2012-03-09', NULL, NULL),
(1174, 'Szerelem', 134, '2013-10-05', 'színmű', 'magyar'),
(1175, 'Úri muri', 157, '2018-01-07', NULL, NULL),
(1176, 'Visszaröpülés', 135, '2014-09-10', 'zenés előadás', 'magyar'),
(1177, 'A Mary Wigmann Dance Evening', 173, '2014-10-14', 'táncelőadás', NULL),
(1178, 'A mi történetünk', 36, '2017-02-21', NULL, 'magyar'),
(1179, 'Iphigenia A-tól T-ig', 140, '2015-02-01', 'színmű', 'magyar'),
(1180, 'Újságmúzeum Live', NULL, '2020-09-10', NULL, NULL),
(1181, 'Bűn és bűnhődés', 195, '2018-01-27', NULL, NULL),
(1182, 'Psyché', 25, '2014-12-03', 'táncelőadás', 'magyar'),
(1183, 'Gloria', 190, '2019-03-09', NULL, NULL),
(1184, '56 csepp vér', 95, '2016-10-01', 'musical', 'magyar'),
(1185, 'Fel is út, le is út!', 186, '2012-12-20', 'komédia', NULL),
(1186, 'Black Comedy', 95, '2019-01-12', NULL, NULL),
(1187, 'Lovatlan Szent György', 73, '2013-01-29', 'önálló est', 'magyar'),
(1188, 'Ádám almái', 99, '2017-02-18', NULL, 'magyar'),
(1189, 'Horizont Táncfesztivál - A kiméra gyöngyei', NULL, '2019-04-24', 'táncelőadás', NULL),
(1190, 'Fehér Szalag', 34, '2019-10-12', 'színmű', NULL),
(1191, 'Error', 99, '2020-11-21', 'színpadi játék', NULL),
(1192, 'Csomópont', 123, '2017-05-31', 'táncelőadás', NULL),
(1193, 'Spam operett', 190, '2015-04-26', 'zenés előadás', 'magyar'),
(1194, 'Bestia', 173, '2012-01-14', 'táncelőadás', 'magyar'),
(1195, 'Fekete Péter', 129, '2013-01-19', 'zenés vígjáték', 'magyar'),
(1196, 'Julie kisasszony', 30, '2015-09-23', 'színmű', 'magyar'),
(1197, 'Portugál', 130, '2019-12-13', 'tragikomédia', NULL),
(1198, 'Mintapinty', 122, '2018-10-27', NULL, NULL),
(1199, 'Csókos asszony', 185, '2015-01-30', 'operett', 'magyar'),
(1200, 'Abigél', 185, '2019-02-22', NULL, NULL),
(1201, 'A sütemények királynője', 140, '2015-12-03', NULL, 'magyar'),
(1202, 'A fösvény', 83, '2017-02-24', 'vígjáték', 'magyar'),
(1203, 'Isten hozott a majomházban', 8, '2017-12-15', NULL, 'magyar'),
(1204, 'S.Ö.R. - Shakespeare Összes Rövidítve', 73, '2013-11-30', NULL, 'magyar'),
(1205, 'A Pál utcai fiúk', 181, '2012-01-31', 'színmű', 'magyar'),
(1206, 'Csingiling az erdőben', 56, '2018-03-25', 'mesejáték', NULL),
(1207, 'Kasimir és Karoline', 35, '2019-01-06', NULL, NULL),
(1208, 'A szörnyeteg', 143, '2015-02-17', NULL, 'magyar'),
(1209, 'Körhinta', 38, '2018-12-16', 'csecsemő színház', NULL),
(1210, 'DEkaMerON', 195, '2021-11-26', NULL, NULL),
(1211, 'A vadkacsa', 140, '2017-11-25', NULL, 'magyar'),
(1212, 'Doktor Proktor és a holdkaméleonok', 40, '2014-01-11', NULL, 'magyar'),
(1213, 'Zorba, a görög', 182, '2016-09-24', 'musical', 'magyar'),
(1214, 'Orlando', 166, '2021-08-31', NULL, NULL),
(1215, 'Andrea Chénier', 22, '2021-05-29', 'opera', NULL),
(1216, 'Amphitryon', 140, '2019-03-24', NULL, NULL),
(1217, 'Churchill és Garbo', 79, '2021-12-11', NULL, NULL),
(1218, 'FészeKabaré', 194, '2013-12-14', 'kabaré', 'magyar'),
(1219, 'Varázsfuvola! Szeretem!', 87, '2012-11-03', 'opera', NULL),
(1220, 'Caligula helytartója', 70, '2012-03-16', NULL, 'magyar'),
(1221, 'Az anyu én vagyok', 129, '2014-10-18', 'komédia', 'magyar'),
(1222, 'Farsang', 34, '2012-11-17', 'színmű', 'magyar'),
(1223, 'Két úr szolgája', 109, '2018-01-26', NULL, NULL),
(1224, 'Marica grófnő', 29, '2020-10-23', 'operett', NULL),
(1225, 'Születésnap', NULL, '2018-03-19', NULL, NULL),
(1226, 'The Underground Files - Szemelvények egy orosz hivatalnok naplójából (2021)', NULL, '2021-11-09', 'táncelőadás', NULL),
(1227, 'Senki fája', 64, '2014-12-06', 'monodráma', 'magyar'),
(1228, 'Süssünk, süssünk valamit!', 4, '2012-09-15', 'bábjáték', 'magyar'),
(1229, 'A hideg gyermek', 32, '2012-11-29', 'vígjáték', 'magyar'),
(1230, 'Operácska - Rigoletto', 32, '2014-02-19', 'opera', NULL),
(1231, 'A mi osztályunk', 52, '2018-10-06', NULL, NULL),
(1232, 'Ahogy tetszik', 157, '2014-02-14', 'vígjáték', 'magyar'),
(1233, 'Tizenkét dühös ember', 181, '2014-03-21', NULL, 'magyar'),
(1234, 'Meggyeskert', 66, '2014-11-07', 'színpadi játék', 'magyar'),
(1235, 'A szerenád', 44, '2012-03-11', 'zenés mesejáték', 'magyar'),
(1236, 'III. Richárd', 157, '2017-01-10', 'dráma', 'magyar'),
(1237, 'Csitt', 13, '2019-02-17', 'csecsemő színház', NULL),
(1238, 'Agyatlan karácsony', 182, '2019-09-28', 'komédia', NULL),
(1239, 'Békediktátum- Trianon 100', 44, '2020-03-23', NULL, NULL),
(1240, 'Menekülők', 122, '2017-10-27', 'dráma', 'magyar'),
(1241, 'Kasimir és Karoline', 95, '2019-12-15', NULL, NULL),
(1242, 'Az óriáscsecsemő', 40, '2018-06-06', 'opera', NULL),
(1243, 'Outbreak', 197, '2014-10-21', 'táncelőadás', 'magyar'),
(1244, 'A muzsika hangja', 109, '2013-01-11', 'musical', 'magyar'),
(1245, 'A dzsungel könyve', 192, '2019-02-08', 'musical', NULL),
(1246, 'A királyi úton', 34, '2019-10-05', NULL, NULL),
(1247, 'Vérnász', 26, '2017-10-29', NULL, 'magyar'),
(1248, 'Godot-ra várva', 30, '2017-09-08', NULL, 'magyar'),
(1249, 'Godspell', 99, '2021-06-22', 'musical', NULL),
(1250, 'Etűdök alapszínekre', 63, '2013-01-29', 'mozgásszínház', 'magyar'),
(1251, 'Nézz vissza haraggal', NULL, '2020-04-19', NULL, NULL),
(1252, 'Kerengő', 78, '2017-01-14', 'táncelőadás', NULL),
(1253, 'Sajtkirály', 130, '2017-04-02', 'mesejáték', 'magyar'),
(1254, 'Black comedy', 129, '2012-11-17', 'bohózat', 'magyar'),
(1255, 'Hogyan születnek a császárok?', 140, '2020-02-27', NULL, NULL),
(1256, 'Bernarda Alba háza', 50, '2015-01-30', 'dráma', 'magyar'),
(1257, 'ELMARAD! - Falstaff II. - Operabeavató', NULL, '2020-03-25', 'opera', NULL),
(1258, 'Cukorfalat/Hard Candy', 152, '2012-03-31', NULL, 'magyar'),
(1259, 'Szibériai csárdás', 102, '2021-10-09', 'zenés vígjáték', NULL),
(1260, 'Tartuffe', 34, '2019-12-21', NULL, NULL),
(1261, 'A Pulitzer-ügy', 64, '2016-03-20', 'dráma', 'magyar'),
(1262, 'Zsiványok Betlehemben', 56, '2017-11-26', 'zenés mesejáték', 'magyar'),
(1263, 'Elza, vagy a világ vége', 110, '2017-02-03', NULL, 'magyar'),
(1264, 'Forgószél, avagy a képzelet csodája', 80, '2019-04-11', 'mesebalett', NULL),
(1265, 'Lúd Zsolt és kutyája, Mattyi', 62, '2014-12-22', 'színmű', 'magyar'),
(1266, 'Szerelmek az égből', 182, '2013-09-24', 'romantikus vígjáték ', 'magyar'),
(1267, 'SzemLélek', 154, '2022-02-21', 'táncelőadás', NULL),
(1268, 'Fókaszív', 38, '2020-12-11', 'mesejáték', NULL),
(1269, 'Szemünk fénye', 117, '2019-10-09', NULL, NULL),
(1270, 'Rómeó és Júlia', 56, '2013-11-13', 'dráma', 'magyar'),
(1271, 'Macbeth', 20, '2019-03-14', NULL, NULL),
(1272, 'P@88w0rLd', 8, '2016-03-10', 'táncelőadás', 'magyar'),
(1273, 'Janika', 56, '2017-10-14', 'vígjáték', 'magyar'),
(1274, 'Tóték', 20, '2013-03-09', 'tragikomédia', 'magyar'),
(1275, 'Hegedűs a háztetőn', 29, '2021-05-25', 'musical', NULL),
(1276, 'Bonyodalmas balkáni lakodalmas', 115, '2012-10-13', 'táncelőadás', 'magyar'),
(1277, 'Üzlet', 45, '2013-11-26', NULL, 'magyar'),
(1278, 'Macbeth', 83, '2014-12-13', 'színmű', 'magyar'),
(1279, 'Az apa', 60, '2020-10-17', NULL, NULL),
(1280, 'Öröm és boldogság', 30, '2021-09-18', NULL, NULL),
(1281, 'Gőzben', 121, '2016-02-12', 'színmű', 'magyar'),
(1282, 'Háború és béke', 170, '2017-12-16', NULL, 'magyar'),
(1283, 'Don Giovanni', 22, '2016-12-16', 'opera', 'olasz'),
(1284, 'Bogarak', 136, '2019-03-10', 'táncelőadás', NULL),
(1285, 'Vitéz lélek', 157, '2013-09-27', 'példázat', 'magyar'),
(1286, 'Kisanyukám! /négyen háromszögben/', NULL, '2020-10-04', NULL, NULL),
(1287, 'A három pillangó', 88, '2015-02-08', 'bábjáték', NULL),
(1288, 'Bikini - Demokrácia', 46, '2012-04-23', NULL, NULL),
(1289, 'Csend', 8, '2013-02-22', 'táncelőadás', 'magyar'),
(1290, 'Ludas eM / Mesterkurzus', 32, '2012-01-13', 'táncelőadás', 'magyar'),
(1291, 'Ítél a nép', 144, '2018-11-16', NULL, NULL),
(1292, 'Titus Andronicus', 9, '2018-11-30', 'tragédia', NULL),
(1293, 'Pucér fiúk olvasnak - #1 Fiala Borcsa', 138, '2020-03-07', NULL, NULL),
(1294, 'Sakk', 148, '2013-11-09', 'musical', 'magyar'),
(1295, 'Radnóti - Álmok', 9, '2014-11-08', NULL, 'magyar'),
(1296, 'Fantomfájdalom', 189, '2021-09-15', 'balett', NULL),
(1297, 'Lucifer Show', 102, '2017-12-16', NULL, 'magyar'),
(1298, 'Black Comedy', 76, '2016-10-22', 'bohózat', 'magyar'),
(1299, 'Ágacska', 51, '2012-09-23', 'zenés mesejáték', 'magyar'),
(1300, 'Szabó Magda: Ókút', NULL, '2019-10-05', NULL, NULL),
(1301, 'Csongor és Tünde', 32, '2017-12-08', 'dráma', NULL),
(1302, 'Szindbád', 157, '2015-12-18', 'színmű', 'magyar'),
(1303, 'Miú és Vau', 151, '2018-04-15', 'bábjáték', NULL),
(1304, 'Köztársaság', 31, '2016-08-19', NULL, 'magyar'),
(1305, 'Torzonborz, a rabló', 4, '2014-10-04', 'bábjáték', NULL),
(1306, 'A kölyök', 109, '2015-04-10', 'musical', 'magyar'),
(1307, 'Csodaszarvas', 119, '2014-07-19', 'magyar', NULL),
(1308, 'Homokember', NULL, '2018-05-02', NULL, NULL),
(1309, 'Pirkad', 179, '2013-05-16', 'táncelőadás', 'magyar'),
(1310, 'A hazudós egér', 38, '2018-02-18', 'bábelőadás', 'magyar'),
(1311, 'Mielőtt az éj leszáll!', 110, '2014-04-26', 'színmű', 'magyar'),
(1312, 'Nyúl Péter', 43, '2015-10-02', NULL, NULL),
(1313, 'Semmit se bánok', 79, '2019-09-12', NULL, NULL),
(1314, 'Pichet Klunchun és én', 173, '2012-01-27', NULL, 'angol'),
(1315, 'A kincses sziget', 83, '2019-11-29', 'musical', NULL),
(1316, 'Bánk bán', 50, '2016-03-11', 'dráma', 'magyar'),
(1317, 'Bivaly-szuflé', 76, '2013-02-23', 'komédia', 'magyar'),
(1318, 'Bohóc-Szvit', 181, '2017-10-14', 'dráma', 'magyar'),
(1319, 'Figaro házassága', NULL, '2019-02-02', 'vígopera', NULL),
(1320, 'Mágnás Miska', 99, '2013-09-27', 'nagyoperett', 'magyar'),
(1321, 'Budapest Orfeum - újratöltve', 182, '2015-10-08', NULL, 'magyar'),
(1322, 'Othello', 23, '2014-01-24', 'tragédia', 'magyar'),
(1323, 'Fázisok', 78, '2013-06-14', 'táncelőadás', 'magyar'),
(1324, 'Cseppkánon', 135, '2015-10-09', 'táncelőadás', 'magyar'),
(1325, 'Macskajáték', 50, '2016-09-02', 'tragikomédia', 'magyar'),
(1326, 'Don Carlos', 150, '2020-05-16', 'opera', NULL),
(1327, 'Maga lesz a férjem', 121, '2020-10-02', 'zenés vígjáték', NULL),
(1328, 'Mesterkurzus', 122, '2017-02-17', NULL, 'magyar'),
(1329, 'Filuména házassága', 102, '2017-11-11', 'komédia', 'magyar'),
(1330, 'Kököjszi és Bobojsza', 30, '2015-02-25', 'mesejáték', 'magyar'),
(1331, 'Finito', 6, '2015-10-03', 'színmű', 'magyar'),
(1332, 'Samu Kristóf, Szarvas Krisztina - Járvány / Eggyel többen!', 78, '2018-04-28', 'táncelőadás', NULL),
(1333, 'A fejedelem', 185, '2021-12-17', 'musical', NULL),
(1334, 'Kimondhatatlan', NULL, '2020-10-14', NULL, NULL),
(1335, 'Trainspotting', 152, '2019-10-11', NULL, NULL),
(1336, 'Széttört álmok', 137, '2012-05-25', NULL, NULL),
(1337, 'Nagyvizit', 121, '2021-10-01', 'tragikomédia', NULL),
(1338, 'Gomboló', 151, '2013-04-17', 'zenés mesejáték', 'magyar'),
(1339, 'Kegyelemkenyér', 6, '2015-02-08', 'színmű', 'magyar'),
(1340, 'Rózsa és Ibolya', 32, '2020-03-04', 'mesebalett', NULL),
(1341, 'Lenz', 200, '2013-11-15', 'színmű', 'magyar'),
(1342, 'Szirmok', 151, '2018-05-30', 'csecsemő színház', NULL),
(1343, 'Kottavető, avagy fejjel a hangfalnak', 180, '2013-03-14', 'zenés előadás', 'magyar'),
(1344, 'Woyzeck', 32, '2013-12-08', NULL, 'magyar'),
(1345, 'Macskalépcső', 182, '2014-03-06', 'színmű', 'magyar'),
(1346, 'Égben maradt repülő', 56, '2016-02-20', 'zenés előadás', 'magyar'),
(1347, 'Hedda Gabler', 190, '2013-12-22', 'színmű', 'magyar'),
(1348, 'Maszmók Afrikában', 129, '2018-04-06', 'mesejáték', NULL),
(1349, 'A Pál utcai fiúk', 17, '2021-07-30', 'zenés játék', NULL),
(1350, 'Sárkányölő Krisztián', 129, '2017-04-14', 'mesejáték', 'magyar'),
(1351, 'A helység kalapácsa', 192, '2012-02-17', NULL, NULL),
(1352, 'Ikrek előnyben!', 56, '2016-03-19', 'zenés vígjáték', 'magyar'),
(1353, 'Az áruló (Lószúnyog)', 34, '2012-12-03', 'színmű', 'magyar'),
(1354, 'Monokli', 60, '2012-03-16', 'játék', 'magyar'),
(1355, 'Musical Koncert- Musical Revolution', 23, '2017-05-07', 'zenés előadás', 'magyar'),
(1356, 'Ájlávjú', 35, '2017-11-17', NULL, 'magyar'),
(1357, 'Ahogy tetszik', 44, '2021-11-19', 'vígjáték', NULL),
(1358, 'Nero', 144, '2020-10-16', NULL, NULL),
(1359, 'A megmentő', NULL, '2018-09-22', NULL, NULL),
(1360, 'Hippolütosz és Aricia', 22, '2013-06-26', 'zenés tragédia', 'francia'),
(1361, 'Utazás az éjszakába', 73, '2013-10-06', 'dráma', 'magyar'),
(1362, 'A titok arat - Ady est 3.', 142, '2012-10-08', NULL, 'magyar'),
(1363, 'Kivettem a fejemből egy gömböt', 101, '2017-11-05', 'zenés előadás', 'magyar'),
(1364, 'Pinokkió', 116, '2019-12-01', 'zenés mesejáték', NULL),
(1365, 'Csongor és Tünde', 162, '2014-11-28', 'színmű', 'magyar'),
(1366, 'Hippolyt, a lakáj', 56, '2018-12-15', 'zenés vígjáték', NULL),
(1367, 'Mese az igazságtételről avagy A hét szamuráj', 20, '2015-10-30', 'színmű', 'magyar'),
(1368, 'A kisfiú meg az oroszlánok', 129, '2017-02-10', 'mesejáték', 'magyar'),
(1369, 'Profana', 42, '2012-03-10', 'táncelőadás', 'magyar'),
(1370, 'Hétórai tea', 36, '2012-02-24', NULL, 'magyar'),
(1371, 'Csíksomlyói Passió', 162, '2019-04-26', NULL, NULL),
(1372, 'Szentivánéji szexkomédia', 60, '2017-02-24', NULL, 'magyar'),
(1373, 'A mosoly országa', 29, '2014-05-16', 'operett', 'magyar'),
(1374, 'A vád tanúja', 148, '2018-02-10', 'krimi', NULL),
(1375, 'A dög', 176, '2013-06-08', 'színmű', 'magyar'),
(1376, 'Mária evangéliuma', 195, '2016-07-08', 'rockopera', 'magyar'),
(1377, 'Az özvegy Karnyóné és a két szeleburdiak', 50, '2017-10-24', 'zenés bohózat', 'magyar'),
(1378, 'Arany-légy', 172, '2012-02-19', NULL, NULL),
(1379, 'GreekLateNight', 22, '2016-02-05', 'opera', 'olasz'),
(1380, 'Valódi hamisítvány', 68, '2018-04-13', NULL, NULL),
(1381, 'Szeretkezz, ne háborúzz!', 70, '2020-09-18', 'zenés vígjáték', NULL),
(1382, 'PIN:okkio', 83, '2019-09-28', 'mesejáték', NULL),
(1383, 'A padlás', 76, '2014-09-27', 'mesemusical', 'magyar'),
(1384, 'Rügyek és gyökerek', 43, '2020-10-29', 'bábjáték', NULL),
(1385, 'A Hétfejű Tündér', 43, '2012-01-19', 'bábjáték', 'magyar'),
(1386, 'Hesszelők', NULL, '2021-06-30', 'táncelőadás', NULL),
(1387, 'A tribádok éjszakája', 6, '2018-10-19', NULL, NULL),
(1388, 'Jelenkorunk ’20', 8, '2020-11-21', NULL, NULL),
(1389, 'Kreatív kapcsolatok', 32, '2016-06-16', 'opera', 'magyar'),
(1390, 'Tartuffe', 32, '2021-12-18', 'színmű', NULL),
(1391, 'Mi és Miskolc, avagy 272307 lépés a város felé', 32, '2012-09-08', 'játék', 'magyar'),
(1392, 'Pan-Pot - A szolidan éneklős', 173, '2013-09-18', NULL, NULL),
(1393, 'A kézmosás fontosságáról', 101, '2014-11-20', 'színmű', 'magyar'),
(1394, 'Ha mi holtak feltámadunk', 12, '2017-10-18', NULL, 'magyar'),
(1395, 'Ego Trip', 191, '2013-10-24', 'táncelőadás', 'magyar'),
(1396, 'Liliomfi', 111, '2021-06-16', NULL, NULL),
(1397, 'EX', 162, '2016-12-16', 'zenés vígjáték', 'magyar'),
(1398, 'A lélek legszebb éjszakája', 20, '2018-12-14', NULL, NULL),
(1399, 'Athéni Timon', 140, '2015-04-04', 'színmű', 'magyar'),
(1400, 'A csillagszemű juhász', 43, '2016-10-09', 'bábjáték', NULL),
(1401, 'Buborékok', 134, '2012-04-27', 'zenés vígjáték', 'magyar'),
(1402, 'Kaviár és lencse', 148, '2015-04-25', 'vígjáték', 'magyar'),
(1403, 'A zlíni bőröző', 36, '2013-09-19', 'színmű', 'magyar'),
(1404, 'Csoda Óperencián', 71, '2018-04-28', 'show műsor', NULL),
(1405, 'Mov(i)e stars', 194, '2014-04-12', 'mozgásszínház', 'magyar'),
(1406, 'Stop', 13, '2018-09-20', 'zenés játék', NULL),
(1407, 'Vén Európa Hotel', 123, '2015-12-07', 'dráma', 'magyar'),
(1408, 'MOMO', 98, '2013-09-27', NULL, 'magyar'),
(1409, 'Az egérfogó', 100, '2015-03-28', 'krimi', 'magyar'),
(1410, 'A tanítónő', 32, '2013-10-04', 'színmű', 'magyar'),
(1411, 'Csoda', 181, '2013-09-24', 'komédia', 'magyar'),
(1412, 'Valahol Európában', NULL, '2020-08-29', 'musical', NULL),
(1413, 'Gyertyaláng', 178, '2021-10-10', 'táncelőadás', NULL),
(1414, 'Bábelna - Keleti Nyitás', 54, '2016-09-21', NULL, 'magyar'),
(1415, 'A vihar', 134, '2013-02-15', 'dráma', 'magyar'),
(1416, 'A palacsintás király', 129, '2016-02-20', 'zenés mesejáték', 'magyar'),
(1417, 'Teremtés-játék', NULL, '2020-09-20', NULL, NULL),
(1418, 'Kövek', 182, '2019-03-28', NULL, NULL),
(1419, 'Boundless', 193, '2014-10-31', 'táncelőadás', 'magyar'),
(1420, 'A tökéletességen innen', 164, '2017-10-20', NULL, 'magyar'),
(1421, 'A Forint/Médeia', 32, '2012-12-02', 'táncjáték', 'magyar'),
(1422, 'My fair lady', 35, '2016-09-30', 'zenés előadás', 'magyar'),
(1423, 'Nebáncsvirág', 44, '2016-10-07', 'operett', 'magyar'),
(1424, 'Gém', 93, '2016-03-19', NULL, 'magyar'),
(1425, 'Leonce és Léna', 23, '2022-01-14', 'musical', NULL),
(1426, 'A képzelt beteg', 134, '2017-10-06', NULL, 'magyar'),
(1427, 'C\'est la vie', 6, '2019-10-04', 'zenés játék', NULL),
(1428, 'Alice az ágyban', NULL, '2020-03-03', NULL, NULL),
(1429, 'Doctor Herz', 37, '2021-11-19', NULL, NULL),
(1430, 'A csengő', 99, '2014-01-22', 'vígopera', NULL),
(1431, 'A kaktusz virága', 30, '2013-10-06', 'zenés vígjáték', 'magyar'),
(1432, 'Tökéletes gyilkosság', 83, '2016-04-08', NULL, 'magyar'),
(1433, 'Oberfrank Réka-MU Színház: Top X vol.1 Dear 21st century!/ Molnár Csaba-MU Színház: Gods and monster', NULL, '2020-12-04', 'táncelőadás', NULL),
(1434, 'A kék bolygó', 129, '2019-02-08', 'mesejáték', NULL),
(1435, 'Mozaik - összeáll a kép', 90, '2014-03-29', 'improvizáció', 'magyar'),
(1436, 'Magammal viszem', 26, '2021-06-17', NULL, NULL),
(1437, 'A nagymama', 102, '2012-12-08', 'vígjáték', 'magyar'),
(1438, 'Macbeth', 120, '2017-02-10', NULL, 'magyar'),
(1439, 'Sirály', 148, '2018-10-06', 'színmű', NULL),
(1440, 'Mikve', 73, '2016-11-26', NULL, 'magyar'),
(1441, 'Social error - The last man in Budapest', 15, '2013-05-25', 'színmű', 'magyar'),
(1442, 'Irma, te édes', 6, '2014-05-09', 'zenés komédia', 'magyar'),
(1443, 'Hodworks / Unusual Symptoms (DE) - Coexist', NULL, '2019-11-07', NULL, NULL),
(1444, 'Pomádé király új ruhája', 22, '2017-06-09', 'gyerekopera', 'magyar'),
(1445, 'IKF (Ifjú Koreográfusok Fóruma) - Gyulai Júlia Anna és a Közép-Európa Táncszínház', 123, '2015-01-17', 'táncelőadás', 'magyar'),
(1446, 'Jóccakát, Anya!', 182, '2017-03-09', NULL, 'magyar'),
(1447, 'Trójai játékok', 86, '2014-05-03', 'balett', NULL),
(1448, 'Szigorúan ellenőrzött vonatok', 181, '2015-01-16', 'tragikomédia', 'magyar'),
(1449, 'Don Quijote voltam', 130, '2015-12-17', NULL, 'magyar'),
(1450, 'Hoppá-hoppá! Avagy Vadkan Dönci és Cirmos Liza', 43, '2014-10-04', 'bábjáték', NULL),
(1451, 'Kincsem', 152, '2014-04-05', 'színmű', 'magyar'),
(1452, 'A kármeliták', 22, '2016-12-02', 'opera', 'francia'),
(1453, 'Pinocchio, azaz volt egyszer egy fadarab', 28, '2013-04-13', 'gyermekelőadás', 'magyar'),
(1454, 'Az ördög szekrénye', 157, '2013-05-04', 'színmű', 'magyar'),
(1455, 'A Herner Ferike faterja', 6, '2018-09-21', NULL, NULL),
(1456, 'Fel is út, le is út', 168, '2017-10-21', 'komédia', 'magyar'),
(1457, 'Hová lett Hófehér?', 199, '2015-10-16', 'gyermekelőadás', 'magyar'),
(1458, 'Szétbombázva', 122, '2019-02-20', 'tragédia', NULL),
(1459, 'Pornó', 9, '2021-09-18', NULL, NULL),
(1460, 'Kurtág György: Fin de partie', NULL, '2021-04-07', 'opera', NULL),
(1461, 'Szegfű és Janika', 171, '2016-03-05', NULL, 'magyar'),
(1462, 'Függöny fel!', 129, '2017-01-21', 'bohózat', 'magyar'),
(1463, 'A hullaégető', 68, '2017-02-11', NULL, 'magyar'),
(1464, 'Önként, dalolva', NULL, '2018-05-26', NULL, NULL),
(1465, 'Oberfrank Réka: Zoom / Molnár Csaba: Ördög (ONLINE)', NULL, '2021-09-17', 'táncelőadás', NULL),
(1466, 'Rigó Jancsi', 109, '2019-11-15', 'operett', NULL),
(1467, 'Hallgatni akartam', 170, '2016-09-10', 'monodráma', 'magyar'),
(1468, 'Carmen', 22, '2014-10-31', 'opera', NULL),
(1469, 'Carmina Burana', 137, '2019-04-23', 'táncelőadás', NULL),
(1470, 'Négy meztelen férfi', 168, '2015-09-19', 'vígjáték', 'magyar'),
(1471, 'Marat/Sade', 105, '2012-02-09', NULL, NULL),
(1472, 'IZP-estek - Foundry Dance Theatre: HalluciNatiOn', NULL, '2021-07-21', 'táncelőadás', NULL),
(1473, 'A két Lotti', 44, '2021-11-21', NULL, NULL),
(1474, 'Mekk Elek, ezermester', 112, '2018-12-02', 'bábjáték', NULL),
(1475, '32. Színikritikusok Díja - díjátadó gála', 157, '2012-09-16', 'gála', 'magyar'),
(1476, 'Kaddis a meg nem született gyermekért', 170, '2019-04-06', NULL, NULL),
(1477, 'A pillangók szabadok', 50, '2020-10-16', NULL, NULL),
(1478, 'A Blaha-sztori', 123, '2013-03-13', 'zenés előadás', 'magyar'),
(1479, 'Movein Mission: Dupla est', 197, '2016-04-01', 'táncelőadás', NULL),
(1480, 'Gabriella tizennégyszer', 194, '2012-10-13', 'dráma', 'magyar'),
(1481, 'Atelier 21220 – MU Színház: Rave', 8, '2019-10-18', NULL, NULL),
(1482, 'Freak Fusion: Game over?', NULL, '2020-01-10', NULL, NULL),
(1483, 'Hamlet', 110, '2020-12-05', NULL, NULL),
(1484, 'Dino Coming Out', NULL, '2019-04-29', NULL, NULL),
(1485, 'Traviata', NULL, '2019-02-23', 'balett', NULL),
(1486, 'Liliom', 12, '2016-03-05', NULL, 'magyar'),
(1487, 'A csillagos ég (avagy a nemzetközi sikerre való tekintet)', 190, '2013-10-27', 'színmű', 'magyar'),
(1488, 'Az özvegy Karnyóné s két szeleburdiak', 163, '2021-10-21', 'bábjáték', NULL),
(1489, 'Švejk, a derék katona', 73, '2016-04-08', NULL, 'magyar'),
(1490, 'Ők tudják, mi a szerelem; Antipygmalion, avagy tudják ők, mi a szerelem?', 23, '2014-02-14', NULL, 'magyar'),
(1491, 'Nero, a véres költő', NULL, '2019-09-27', NULL, NULL),
(1492, 'Love Songs', 152, '2013-04-03', 'táncelőadás', NULL),
(1493, 'Zene-bona, szana-szét', 181, '2015-11-18', 'zenés előadás', 'magyar'),
(1494, 'Az értelmiség útja az osztályhatalomig', 128, '2016-03-24', 'felolvasószínház', 'magyar'),
(1495, 'SzínházJegyetem 2.0', 44, '2014-12-20', 'szatíra', 'magyar'),
(1496, 'Don Perlimplin / Don Cristobal', 122, '2013-06-18', 'opera', NULL),
(1497, 'Egy anya története', 29, '2015-06-12', 'opera', 'magyar'),
(1498, 'Hajnali Hold', 84, '2012-06-07', 'táncelőadás', 'magyar'),
(1499, 'Macbeth', 182, '2021-10-10', 'thriller', NULL),
(1500, 'Nyomorult nőszemélyek, Női vértanú szentek modern krónikája', NULL, '2019-10-19', NULL, NULL),
(1501, 'Pogánytánc', 9, '2020-08-28', 'dráma', NULL),
(1502, 'Fény presszó', NULL, '2018-05-12', NULL, NULL),
(1503, 'A Pali', NULL, '2019-10-23', NULL, NULL),
(1504, 'Duna 55', 178, '2012-11-13', 'táncelőadás', 'magyar'),
(1505, 'Karenina, Anna', 102, '2018-03-03', NULL, 'magyar'),
(1506, 'A kékszakállú herceg vára', 145, '2021-08-06', 'operakoncert', NULL),
(1507, 'A legkisebb boszorkány', 43, '2015-11-08', 'bábjáték', NULL),
(1508, 'Lót - Szodomában kövérebb a fű', 20, '2019-12-20', NULL, NULL),
(1509, 'Gyuszi', 139, '2017-03-11', 'bábelőadás', 'magyar'),
(1510, 'Pulóvergyűjtő', NULL, '2019-05-01', NULL, NULL),
(1511, 'Holdbeli csónakos', 32, '2014-03-07', 'zenés mesejáték', 'magyar'),
(1512, 'Istipisti és a kővirágok', 131, '2016-04-01', NULL, NULL),
(1513, 'Kéretik elégetni', 36, '2015-09-08', NULL, 'magyar'),
(1514, 'Csalóka szivárvány', 102, '2014-11-15', 'színmű', 'magyar'),
(1515, 'A kengurukölyök', 144, '2016-10-08', 'bábjáték', NULL),
(1516, 'Egyasszony', 68, '2015-10-21', 'színmű', 'magyar'),
(1517, 'Bányavíz', 14, '2013-09-17', 'színmű', 'magyar'),
(1518, 'Helikopter', 173, '2013-02-22', 'táncelőadás', NULL),
(1519, 'Rohonc, avagy az öldöklő angyal', 187, '2019-03-30', 'tragikomédia', NULL),
(1520, 'Nézőművészeti Kft.: Testvérest', 101, '2017-02-24', NULL, 'magyar'),
(1521, 'MU Terminál C est, 2014 - Guilherme Miotto és Gergye Krisztián közös estje', 8, '2014-05-23', 'zenedráma', NULL),
(1522, 'Picasso kalandjai', 99, '2012-09-28', 'abszurd játék', 'magyar'),
(1523, 'Félőlény', 148, '2016-12-10', 'zenés mesejáték', 'magyar'),
(1524, 'Mumus a padláson', 38, '2013-12-01', 'gyermekelőadás', 'magyar'),
(1525, 'A nők iskolája', 181, '2019-04-26', 'komédia', NULL),
(1526, 'Ruszalka, a vízitündér', 87, '2014-02-09', 'gyermekelőadás', 'magyar'),
(1527, 'VAMP, a vámpírmusical', 56, '2012-09-07', 'musical', 'magyar'),
(1528, 'A Mézga család', NULL, '2019-04-15', 'zenés vígjáték', NULL),
(1529, 'Isten, haza, család', 34, '2021-10-16', NULL, NULL),
(1530, 'Gangaray Trambulin III. - VáltozáSokk', 104, '2014-02-15', 'táncelőadás', 'magyar'),
(1531, 'Hoppláda', 23, '2015-02-27', 'mesejáték', 'magyar'),
(1532, 'Hófehérke és a hét törpe', 139, '2013-12-07', 'gyermekelőadás', 'magyar'),
(1533, 'Dido és Aeneas', 23, '2021-11-05', 'opera', NULL),
(1534, 'Hyppolit, a lakáj', 108, '2015-12-30', 'zenés vígjáték', 'magyar'),
(1535, 'Play Strindberg!', 95, '2016-01-23', NULL, NULL),
(1536, 'Oliver!', 44, '2012-11-04', 'musical', 'magyar'),
(1537, 'Audiencia', 60, '2016-10-14', 'szatíra', 'magyar'),
(1538, 'The Waves / Mimi', 80, '2021-11-13', 'tragikomédia', NULL),
(1539, 'Főfőnök', 99, '2019-02-08', 'vígjáték', NULL),
(1540, 'A Gézagyerek', 148, '2012-01-28', 'színjáték', 'magyar'),
(1541, 'Lélekharang', 182, '2020-09-27', NULL, NULL),
(1542, 'A dzsungel könyve', 12, '2016-06-24', 'musical', 'magyar'),
(1543, 'Az aranyember', 102, '2013-10-05', 'színmű', 'magyar'),
(1544, 'Vonalhúzás', 83, '2014-05-16', 'színmű', 'magyar'),
(1545, 'MU Terminál - Terra toma', 8, '2014-09-26', 'táncelőadás', 'magyar'),
(1546, 'Mindennapi kenyerünket', 120, '2019-06-12', 'tragikomédia', NULL),
(1547, 'Körforgás-est', 80, '2020-10-10', 'balett', NULL),
(1548, 'Platonov - Apátlanul', 190, '2014-05-25', 'színmű', 'magyar'),
(1549, 'Bombaüzlet?!', 152, '2013-03-29', 'kabaré', 'magyar'),
(1550, 'Rigócsőr király', 27, '2016-02-07', NULL, NULL),
(1551, 'Ágacska', 99, '2013-12-06', 'zenés mesejáték', 'magyar'),
(1552, 'Három jiddise mame', 64, '2021-09-28', 'zenés játék', NULL),
(1553, 'Írók, gyilkosok, lúzerek', 102, '2016-09-17', NULL, 'magyar'),
(1554, 'Anna Karenina', NULL, '2020-02-08', 'táncelőadás', NULL),
(1555, 'Dorottya', 134, '2016-04-08', NULL, 'magyar'),
(1556, 'Jégszirom', 83, '2013-10-31', 'színmű', 'magyar'),
(1557, 'Művészet', 110, '2016-06-08', 'felolvasószínház', 'magyar'),
(1558, 'Rebeka', 146, '2019-03-02', NULL, NULL),
(1559, 'Lavina', 141, '2016-11-04', NULL, NULL),
(1560, '40! avagy Véges élet', 71, '2014-10-30', NULL, 'magyar'),
(1561, 'Vértelenül (Senza sangue)', NULL, '2018-05-27', 'opera', NULL),
(1562, 'Bodzaszörp', 106, '2021-12-19', 'zenés mesejáték', NULL),
(1563, 'LIAison', 35, '2021-09-06', NULL, NULL),
(1564, 'A Mester és Margarita', 95, '2014-04-12', NULL, 'magyar'),
(1565, 'Páros/Páratlan', 199, '2014-03-08', 'táncelőadás', 'magyar'),
(1566, 'Egy régi kertben', 191, '2013-12-20', 'táncelőadás', 'magyar'),
(1567, 'Szigorúan ellenőrzött vonatok', 9, '2012-10-05', 'színmű', 'magyar'),
(1568, 'Don Quijote', 25, '2021-09-27', 'táncelőadás', NULL),
(1569, 'Eddmegleves', 88, '2019-02-09', 'bábjáték', NULL),
(1570, 'Happy New Year Show', 103, '2012-12-31', 'show műsor', 'magyar'),
(1571, 'Godot-ra várva', 32, '2014-11-29', 'színmű', 'magyar'),
(1572, 'Énekes madár', 181, '2018-09-28', 'népszínmű', NULL),
(1573, 'Apácák', NULL, '2018-05-25', NULL, NULL),
(1574, 'Ha álom az élet', 122, '2017-09-30', 'zenés előadás', 'magyar'),
(1575, 'Rocknagyi', 56, '2019-03-09', 'zenés játék', NULL),
(1576, 'Black Comedy', 23, '2021-10-29', 'vígjáték', NULL),
(1577, 'Szegény Dzsoni és Árnika', 29, '2017-05-09', 'operett', 'magyar'),
(1578, 'Betörő az albérlőm', 32, '2019-11-22', 'komédia', NULL),
(1579, 'Akarunk', NULL, '2019-09-18', NULL, NULL);
INSERT INTO `eloadas` (`id`, `cim`, `szinhazid`, `datum`, `mufaj`, `nyelv`) VALUES
(1580, 'A padlás', 130, '2013-11-30', 'mesemusical', 'magyar'),
(1581, 'A didergő király', 116, '2015-11-29', NULL, NULL),
(1582, 'I love musical', 30, '2012-02-24', 'musical', 'magyar'),
(1583, 'Antigoné', 26, '2012-12-03', 'színmű', 'magyar'),
(1584, 'Dől a lé, avagy pénz áll a házhoz', 168, '2014-12-18', 'színmű', 'magyar'),
(1585, 'Csoportterápia', 148, '2014-02-15', 'musical', 'magyar'),
(1586, 'József és a színes szélesvásznú álomkabát', 109, '2015-10-09', 'musical', 'magyar'),
(1587, 'Gyöngyhalász', 11, '2018-03-20', 'táncelőadás', NULL),
(1588, 'Az Öreghíd alatt', 67, '2021-07-09', NULL, NULL),
(1589, 'Coraline', 43, '2019-01-17', 'bábelőadás', NULL),
(1590, 'Kozmikus magány', 170, '2018-12-05', NULL, NULL),
(1591, 'VIP - Világirodalmi Paródiák', 64, '2012-02-06', NULL, 'magyar'),
(1592, 'Csókos asszony', 83, '2018-05-26', 'operett', NULL),
(1593, 'Romeo és Júlia', 83, '2014-03-14', 'tragédia', 'magyar'),
(1594, 'Kozmosz-szösz', 30, '2020-03-12', NULL, NULL),
(1595, 'Kakas a köszörűkövön', 194, '2016-01-27', NULL, 'magyar'),
(1596, 'Bambina - A roma milliárdosnő', NULL, '2020-10-21', NULL, NULL),
(1597, 'Csodálatos vagy, Júlia!', 182, '2015-01-23', 'színmű', 'magyar'),
(1598, 'A gyilkos', 23, '2019-03-22', NULL, NULL),
(1599, 'Helka - a Balaton tündére', 151, '2012-06-16', 'bábjáték', 'magyar'),
(1600, 'Viharos éjszaka', 30, '2012-11-30', 'komédia', 'magyar'),
(1601, 'Rengeteg Ábel és Kürtős Kata kalandjai', 186, '2018-06-01', 'bábjáték', NULL),
(1602, 'Régimódi történet', 95, '2018-02-10', 'családregény', NULL),
(1603, 'Pim, a földimalac', 131, '2020-10-10', 'bábelőadás', NULL),
(1604, 'Színház vagy szex', 10, '2013-09-29', 'komédia', 'magyar'),
(1605, 'Elvesztve', 23, '2016-05-11', 'monodráma', 'magyar'),
(1606, 'Az üvegcipő', 76, '2019-01-19', 'vígjáték', NULL),
(1607, 'Szárnyak zenéje', 154, '2013-01-22', 'táncelőadás', 'magyar'),
(1608, 'A boldog (Utolsóból első)', 73, '2013-11-19', NULL, 'magyar'),
(1609, 'Nem látlak', 171, '2014-12-05', NULL, 'magyar'),
(1610, 'Kölcsönlakás', 185, '2020-10-22', 'bohózat', NULL),
(1611, 'A csütörtöki hölgyek', 182, '2019-01-17', 'vígjáték', NULL),
(1612, 'Le grand C', 173, '2014-01-03', 'újcirkusz', NULL),
(1613, 'Messzeringó', 27, '2020-11-29', 'bábelőadás', NULL),
(1614, 'Enyém, tied', 130, '2016-09-23', 'zenés mesejáték', 'magyar'),
(1615, 'A testőr', NULL, '2021-06-07', 'vígjáték', NULL),
(1616, 'Brothers', 173, '2012-05-03', NULL, NULL),
(1617, 'Péter Kata', 31, '2012-08-02', NULL, 'magyar'),
(1618, 'Bűn és bűnhődés', 32, '2017-10-06', 'dráma', 'magyar'),
(1619, 'Pisztácia és mogyoró', 95, '2021-10-16', 'komédia', NULL),
(1620, 'Menyegző', 137, '2020-04-21', 'balett', NULL),
(1621, 'Orlando', 57, '2016-12-01', NULL, 'magyar'),
(1622, 'Láz - Does it start with a kiss? / Ismeretlen Királyság', 197, '2013-12-13', 'táncelőadás', 'magyar'),
(1623, 'Illegális Cabaret', 75, '2014-01-17', NULL, NULL),
(1624, 'A Pál utcai fiúk', 148, '2017-01-14', NULL, 'magyar'),
(1625, 'Csillagkirály legendája - felnőtteknek', 194, '2015-09-19', 'színmű', 'magyar'),
(1626, 'Sirály', 23, '2020-10-23', 'színmű', NULL),
(1627, 'A kék pék', 9, '2012-12-14', 'interaktív mesejáték', 'magyar'),
(1628, 'Pokoli bál', 136, '2014-03-22', 'táncelőadás', 'magyar'),
(1629, 'Úr és kutya', 190, '2012-04-11', 'irodalmi est', 'magyar'),
(1630, '4x100', 69, '2015-10-15', NULL, 'magyar'),
(1631, 'Duók', 44, '2015-05-07', 'táncelőadás', NULL),
(1632, 'Ahogy tetszik', 23, '2014-11-07', 'vígjáték', 'magyar'),
(1633, 'Veszett fejsze', 32, '2014-03-21', 'vígjáték', 'magyar'),
(1634, 'Kőműves Kelemen', 26, '2016-10-07', 'mozgásszínház', 'magyar'),
(1635, 'Aranykulcsocska', 148, '2021-12-18', 'gyermekelőadás', NULL),
(1636, 'Lila ákác', 102, '2019-03-09', NULL, NULL),
(1637, 'Az étkezés ártalmasságáról', 68, '2017-04-13', 'felolvasószínház', 'magyar'),
(1638, 'Stílus(os) gyakorlat(ok)', 24, '2013-10-11', 'játék', 'magyar'),
(1639, 'Ez az enyém!', 129, '2014-04-26', NULL, 'magyar'),
(1640, 'Így viszik át', 138, '2017-12-31', NULL, 'magyar'),
(1641, 'Cyrano de Bergerac', 157, '2016-05-13', 'színmű', 'magyar'),
(1642, 'Holnemvoltfa', 181, '2012-11-20', 'mesejáték', 'magyar'),
(1643, 'Az ember komédiája', 148, '2015-09-19', 'vígjáték', 'magyar'),
(1644, 'Egy őrült naplója', 12, '2014-01-13', 'monodráma', 'magyar'),
(1645, 'A csillagszemű juhász', 13, '2019-01-26', 'bábjáték', NULL),
(1646, 'A bunda', 140, '2014-11-20', 'színmű', 'magyar'),
(1647, 'Ostrom opera - Kőszeg 1532', 67, '2014-08-29', 'opera', 'magyar'),
(1648, 'Hamlet', 195, '2020-02-15', 'tragédia', NULL),
(1649, 'Cabaret', 181, '2017-12-15', 'musical', NULL),
(1650, 'Vörös és fekete', 181, '2015-04-17', 'musical', 'magyar'),
(1651, 'A sivatag hercege', 99, '2013-01-11', 'zenés játék', 'magyar'),
(1652, 'Szóval - 1945', 190, '2017-04-04', 'talk show', 'magyar'),
(1653, 'Váratlan találkozások', 50, '2021-11-09', NULL, NULL),
(1654, 'Tóték', 108, '2012-03-09', 'tragikomédia', NULL),
(1655, 'Bűn és bűnhődés', 41, '2015-06-03', 'színmű', 'magyar'),
(1656, 'A vörös Pimpernel', NULL, '2021-10-18', NULL, NULL),
(1657, 'Család ellen nincs orvosság', 95, '2012-06-02', 'komédia', 'magyar'),
(1658, 'Szerelmi üzletek', 9, '2018-08-16', NULL, NULL),
(1659, 'Az öldöklés istene', 54, '2018-04-07', NULL, NULL),
(1660, 'Mirr-Murr, a kandúr', 44, '2013-03-10', 'zenés mesejáték', 'magyar'),
(1661, 'Az előszobaszekrény boszorkánya', 27, '2016-02-21', NULL, NULL),
(1662, 'Pettson és Findusz', 38, '2019-11-24', 'bábjáték', NULL),
(1663, 'Meztelen éj ... Mozart', 162, '2014-09-21', 'színmű', 'magyar'),
(1664, 'Escurial', 31, '2015-08-28', 'színmű', 'magyar'),
(1665, 'A kis hableány', 30, '2015-09-30', 'színmű', 'magyar'),
(1666, 'Macbeth', 12, '2017-02-25', NULL, 'magyar'),
(1667, 'MU Terminál C est, 2015 - Érdekellentét/Ütközéspont (Clash) / Árnyék (Shadow)', 8, '2015-05-30', 'táncelőadás', 'magyar'),
(1668, 'Kinizsi Pál', 151, '2016-09-25', 'bábjáték', NULL),
(1669, 'Horizont Táncfesztivál - Állatok farsangja', NULL, '2019-04-25', 'táncelőadás', NULL),
(1670, 'Csíksomlyói passió', 185, '2013-10-04', 'passiójáték', 'magyar'),
(1671, 'Mindent a kertbe!', 32, '2016-01-29', 'színmű', 'magyar'),
(1672, 'Atlantic Flight - Nagy Cirkuszi Utazás', 156, '2018-04-07', 'cirkuszi előadás', NULL),
(1673, 'Egerek és emberek', 50, '2014-11-28', 'színmű', 'magyar'),
(1674, 'Makrancos Kata avagy a hárpia megzabolázása', 9, '2015-05-15', 'vígjáték', 'magyar'),
(1675, 'Liliomfi', 23, '2016-01-29', 'vígjáték', 'magyar'),
(1676, 'Cirkopolis', 87, '2013-01-08', 'újcirkusz', NULL),
(1677, 'Sweet Charity', 50, '2021-05-07', 'musical', NULL),
(1678, 'IKF (Ifjú Koreográfusok Fóruma)', 123, '2014-09-06', 'táncelőadás', 'magyar'),
(1679, 'Munkácsy, a festőfejedelem', 102, '2013-11-09', 'musical', 'magyar'),
(1680, 'A doktor úr', 195, '2020-09-12', 'vígjáték', NULL),
(1681, 'Olasz szalmakalap', 9, '2014-08-16', 'zenés előadás', 'magyar'),
(1682, 'Akár Akárki', 143, '2013-05-02', 'játék', 'magyar'),
(1683, 'Hajmeresztő', 109, '2013-12-13', 'interaktív krimi', 'magyar'),
(1684, 'Mindenre nyitottan / Open for everything', 173, '2012-06-08', 'táncelőadás', 'magyar'),
(1685, 'Csigaház', 88, '2014-01-17', 'gyermekelőadás', 'magyar'),
(1686, 'Tizenhárom almafa', 157, '2020-03-06', NULL, NULL),
(1687, 'Ájlávjú-Jókedvű musical-revü', 9, '2021-10-01', 'musical', NULL),
(1688, 'Próféták', 96, '2012-04-26', 'színmű', 'magyar'),
(1689, 'Farnace', 22, '2015-06-12', 'opera', 'olasz'),
(1690, 'Szapphó', 33, '2013-04-11', 'tragikomédia', 'magyar'),
(1691, 'A kismalac meg a farkasok', 112, '2019-05-05', 'bábjáték', NULL),
(1692, 'Zárt tárgyalás', 120, '2017-06-22', NULL, 'magyar'),
(1693, 'Akit az istenek szeretnek', 68, '2014-04-30', 'zenés előadás', 'magyar'),
(1694, 'Egyenlőség', 121, '2012-11-16', 'vígjáték', 'magyar'),
(1695, 'Jancsi és Julis', 134, '2018-10-10', 'zenés mesejáték', NULL),
(1696, 'Varázsfuvola', 50, '2012-02-21', 'opera', 'magyar'),
(1697, 'Meggyeskert', 157, '2019-03-02', NULL, NULL),
(1698, 'Trianon', 50, '2021-06-05', NULL, NULL),
(1699, 'Toborzó', 154, '2021-06-09', 'táncelőadás', NULL),
(1700, 'Stravinsky inspirációk', 193, '2013-04-22', 'táncelőadás', 'magyar'),
(1701, 'A férjvadász', 109, '2018-03-23', 'zenés vígjáték', NULL),
(1702, 'Egy doktorkisasszony naplójegyzetei', 36, '2018-10-18', NULL, NULL),
(1703, 'Az analfabéta', 79, '2017-03-28', NULL, 'magyar'),
(1704, 'Csipkerózsika', 22, '2016-04-17', 'balett', 'magyar'),
(1705, 'Indul a bakterház', 56, '2019-10-19', 'vígjáték', 'magyar'),
(1706, 'Horizont Táncfesztivál - Environment Vertical - Függőlegesen', NULL, '2018-04-24', 'táncelőadás', NULL),
(1707, 'A születésnap', 99, '2014-10-11', 'abszurd játék', 'magyar'),
(1708, 'Captatás szünet nélkül', 140, '2016-05-23', NULL, 'magyar'),
(1709, 'Mandragóra', NULL, '2021-10-08', NULL, NULL),
(1710, 'Az égig érő fa', 27, '2020-09-20', 'bábelőadás', NULL),
(1711, 'Az örök nő', 102, '2017-03-08', NULL, 'magyar'),
(1712, 'A város emlékezete', 144, '2019-09-22', NULL, NULL),
(1713, 'Katona 30 est', 34, '2012-10-15', 'gála', 'magyar'),
(1714, 'Iokaszté királyné', 122, '2014-05-08', 'dráma', 'magyar'),
(1715, 'ELMARAD! Busa Balázs: Epreskert / Hámor József: Liza – Gangaray Artistic Program (G.A.P.)', NULL, '2020-03-13', 'táncelőadás', NULL),
(1716, 'Külvárosok angyala', 97, '2018-12-08', NULL, NULL),
(1717, 'Harlekin', NULL, '2019-09-17', NULL, NULL),
(1718, 'A Mester és Margarita', NULL, '2020-12-11', 'opera', NULL),
(1719, 'Pizza Kamikaze', 155, '2014-04-17', 'színmű', 'magyar'),
(1720, 'A nagymama', 73, '2015-09-25', 'vígjáték', 'magyar'),
(1721, 'Válasszunk párt', 180, '2014-01-22', 'zenés előadás', 'magyar'),
(1722, 'Rozsda lovag', 136, '2013-01-20', 'mesemusical', 'magyar'),
(1723, 'A balkon', 128, '2017-10-03', NULL, 'magyar'),
(1724, 'Diamonds', NULL, '2018-05-17', NULL, NULL),
(1725, 'Szelíden és szilárdan', 143, '2014-02-22', 'színmű', 'magyar'),
(1726, '10 kicsi néger', 120, '2018-10-05', NULL, NULL),
(1727, 'Lúdas Matyi', 134, '2013-10-09', 'zenés mesejáték', 'magyar'),
(1728, 'Hair', 129, '2014-09-27', 'musical', 'magyar'),
(1729, 'Bányavirág', 181, '2012-01-19', 'felolvasószínház', 'magyar'),
(1730, 'Lili bárónő', 95, '2012-12-15', 'operett', 'magyar'),
(1731, 'Az én szobám', 140, '2018-12-16', NULL, NULL),
(1732, 'Egy szerethető nő', 56, '2020-02-21', 'vígjáték', NULL),
(1733, 'Papírhajótöröttek', 123, '2015-06-20', 'táncelőadás', 'magyar'),
(1734, 'Marat / Sade', 158, '2014-08-30', 'színmű', 'magyar'),
(1735, 'Az angyalok nem sírnak', 56, '2016-09-24', NULL, 'magyar'),
(1736, 'A szegények iskolája', 79, '2014-04-23', 'interaktív előadás', 'magyar'),
(1737, 'Csókos asszony', 102, '2017-10-07', 'operett', 'magyar'),
(1738, 'Túsztörténet', 37, '2015-10-18', NULL, 'magyar'),
(1739, 'Római vakáció', 68, '2013-07-26', 'zenés előadás', 'magyar'),
(1740, 'Első kétszáz évem', 200, '2018-03-21', NULL, NULL),
(1741, 'Hurkacövekleves', 176, '2017-03-18', 'mesejáték', 'magyar'),
(1742, 'Pinokkió', 30, '2016-03-12', NULL, 'magyar'),
(1743, 'Halál Thébában', 95, '2017-12-15', 'drámai trilógia', NULL),
(1744, 'Utazás a koponyám körül', 101, '2021-10-07', NULL, NULL),
(1745, 'DiverZity', 42, '2013-10-11', 'táncelőadás', 'magyar'),
(1746, 'Hő-hő, felhő!', 4, '2017-04-15', 'csecsemő színház', 'magyar'),
(1747, 'Pionírszív', NULL, '2018-03-02', NULL, NULL),
(1748, 'A trollgyerek', 40, '2014-11-28', 'mesejáték', NULL),
(1749, 'Egy kupac kufli', NULL, '2020-10-10', 'mesejáték', NULL),
(1750, 'Szülői értekezlet', 200, '2015-05-17', 'színmű', 'magyar'),
(1751, 'Bánk bán', 157, '2017-09-21', NULL, 'magyar'),
(1752, 'Vadember', 8, '2012-01-17', NULL, 'magyar'),
(1753, 'Helló, Zombi!', 14, '2015-10-09', 'mozgásszínház', 'magyar'),
(1754, 'Madárház', 144, '2013-04-06', 'bábjáték', 'magyar'),
(1755, 'Naftalin', 73, '2017-04-07', 'bohózat', 'magyar'),
(1756, 'Virágot Algernonnak', 114, '2015-10-31', 'színmű', 'magyar'),
(1757, 'Micimackó', 51, '2017-11-12', 'mesemusical', 'magyar'),
(1758, 'Rítus - a válság katarzisa', NULL, '2018-02-24', NULL, NULL),
(1759, 'Engedjki!', 164, '2015-10-24', NULL, 'magyar'),
(1760, 'Hamlet', 95, '2015-04-18', 'tragédia', 'magyar'),
(1761, 'Táncoló tavasz', 154, '2012-04-17', 'táncelőadás', 'magyar'),
(1762, 'Urbi Et Orbi - Síremlék', 190, '2021-11-27', NULL, NULL),
(1763, 'SHIN Eunju – Batarita', NULL, '2020-01-17', 'táncelőadás', NULL),
(1764, 'Szerelmes Shakespeare', 32, '2020-03-27', 'romantikus vígjáték ', NULL),
(1765, 'Hamlet', 9, '2015-04-07', 'tragédia', 'magyar'),
(1766, 'Az ezeregyéjszaka virágai (felnőtteknek)', 136, '2012-03-24', 'táncelőadás', 'magyar'),
(1767, 'Egy spanyol darab', 6, '2017-04-06', 'színmű', 'magyar'),
(1768, 'Páratlan páros', NULL, '2018-04-06', NULL, NULL),
(1769, 'Mackókaland', NULL, '2019-03-24', 'mesejáték', NULL),
(1770, 'Óz, a nagy varázsló', 109, '2012-11-09', 'zenés mesejáték', 'magyar'),
(1771, 'Operácska - Szerelmi bájital', 32, '2014-04-02', NULL, 'magyar'),
(1772, 'Tofu P. Potter', NULL, '2020-10-31', 'táncelőadás', NULL),
(1773, 'Portugál', 76, '2012-02-04', 'tragikomédia', 'magyar'),
(1774, 'Tizenkét hónap', 196, '2019-10-24', 'mesejáték', NULL),
(1775, 'Végállomás', 9, '2016-10-05', 'krimi', 'magyar'),
(1776, 'Himmelwerk GmbH', 144, '2013-04-12', NULL, 'magyar'),
(1777, 'Száll a kakukk fészkére', NULL, '2019-02-23', 'táncelőadás', NULL),
(1778, 'Puszták népe', 178, '2016-01-11', 'táncelőadás', 'magyar'),
(1779, 'Mária testamentuma', 157, '2017-03-17', 'önálló est', 'magyar'),
(1780, 'MIRROR', 197, '2020-03-09', 'táncelőadás', NULL),
(1781, 'Titánia - Nemzethy népszínmű', 144, '2017-10-13', NULL, 'magyar'),
(1782, 'Képzelt beteg', 109, '2013-10-29', 'táncjáték', 'magyar'),
(1783, 'Vesztegzár a Grand Hotelben', 102, '2018-12-08', 'zenés vígjáték', NULL),
(1784, 'Reptében', 107, '2017-05-29', 'táncelőadás', NULL),
(1785, 'Telitalálat', 145, '2016-08-05', 'komédia', 'magyar'),
(1786, 'Manon', 22, '2015-02-28', 'balett', NULL),
(1787, 'Karagöz, a csalafinta pék', 113, '2014-03-21', NULL, NULL),
(1788, 'A gézagyerek', 32, '2012-10-18', 'istendráma', 'magyar'),
(1789, 'Don Juan', 128, '2013-05-05', 'színmű', 'magyar'),
(1790, 'Popfesztivál 40', 170, '2013-09-08', 'zenés előadás', 'magyar'),
(1791, 'Félőlény', 182, '2013-10-19', 'musical', 'magyar'),
(1792, 'A Rajna kincse', 22, '2015-03-21', 'opera', NULL),
(1793, 'Ármány és szerelem', 30, '2014-10-10', 'színmű', 'magyar'),
(1794, 'Részegek', 76, '2020-04-25', 'tragikomédia', NULL),
(1795, 'Ahogy tetszik', 21, '2016-03-18', NULL, 'magyar'),
(1796, 'Szövegséták Esterházyval', NULL, '2018-04-15', NULL, NULL),
(1797, 'Várunk. Haza.', 144, '2016-03-17', NULL, 'magyar'),
(1798, 'A furulyás', 131, '2012-03-25', NULL, 'magyar'),
(1799, 'Fig_Ht', 19, '2021-06-29', 'táncelőadás', NULL),
(1800, 'Jean, Julie, Kristin', NULL, '2020-11-28', NULL, NULL),
(1801, 'Az élet csodaszép', 195, '2019-11-29', NULL, NULL),
(1802, 'Love Story', 56, '2018-12-01', NULL, NULL),
(1803, 'Nyolckor a bárkán', 70, '2016-12-02', 'zenés előadás', 'magyar'),
(1804, 'Kutyacska', 95, '2020-01-21', 'bábelőadás', NULL),
(1805, 'Otthon', 167, '2017-02-01', 'táncelőadás', NULL),
(1806, 'Boldogtalanok', 23, '2013-04-26', 'színmű', 'magyar'),
(1807, 'Horizont Táncfesztivál - Tartuffe: Egy színdarab színrevitele', NULL, '2019-04-26', 'táncelőadás', NULL),
(1808, 'Egerek', 157, '2014-10-11', 'zenés mesejáték', 'magyar'),
(1809, 'A nők iskolája', 9, '2012-05-04', 'komédia', 'magyar'),
(1810, 'Álmos legendája', 12, '2016-04-16', 'táncelőadás', 'magyar'),
(1811, 'Légy jó mindhalálig', 44, '2013-12-20', 'musical', 'magyar'),
(1812, 'Kincskereső kisködmön', 44, '2017-09-16', NULL, 'magyar'),
(1813, 'Árgyélus királyfi', 106, '2020-02-23', 'zenés mesejáték', 'magyar'),
(1814, 'Catullus', 83, '2013-03-09', 'színmű', 'magyar'),
(1815, 'Tarantella', 36, '2016-01-01', NULL, 'magyar'),
(1816, 'Hippolyt, a lakáj', 50, '2012-09-28', 'zenés vígjáték', 'magyar'),
(1817, 'Tizenkét szék', 148, '2016-03-26', 'komédia', 'magyar'),
(1818, 'Lady Lear', 45, '2016-10-31', NULL, 'magyar'),
(1819, 'Népmesécske', 74, '2014-10-05', 'interaktív mesejáték', 'magyar'),
(1820, 'Új stílusgyakorlatok', 129, '2020-10-30', NULL, NULL),
(1821, 'Fiú, leány', 30, '2014-05-06', 'romantikus komédia', 'magyar'),
(1822, 'Tánc-tér-képek', 78, '2015-03-19', 'táncelőadás', 'magyar'),
(1823, 'Illatszertár', 129, '2017-11-25', NULL, 'magyar'),
(1824, 'A diótörő', 22, '2015-11-28', 'mesebalett', 'magyar'),
(1825, 'Lift', 73, '2012-11-27', 'komédia', 'magyar'),
(1826, 'Reggeli dinoszauruszokkal', 144, '2017-12-15', NULL, NULL),
(1827, 'Bambi', 13, '2016-03-06', 'bábelőadás', NULL),
(1828, 'Tanár úr kérem', 44, '2016-09-24', NULL, 'magyar'),
(1829, 'Luna / Verso', NULL, '2020-03-02', 'táncelőadás', NULL),
(1830, 'Szeress, ha bírsz!', NULL, '2021-11-13', NULL, NULL),
(1831, 'József és testvérei', 20, '2017-02-04', NULL, 'magyar'),
(1832, 'Mesél a bécsi erdő', 23, '2017-01-27', 'népszínmű', 'magyar'),
(1833, 'Duna/Tisza', 102, '2016-10-07', NULL, 'magyar'),
(1834, 'A fösvény', 66, '2012-12-31', NULL, NULL),
(1835, 'Evita', 185, '2017-10-20', 'musical', 'magyar'),
(1836, 'Édes Anyád', 6, '2018-12-14', 'bohózat', NULL),
(1837, 'Sírpiknik', 44, '2020-03-13', 'komédia', NULL),
(1838, 'Egy vagyok', NULL, '2020-09-29', 'performance', NULL),
(1839, 'Kék róka', 6, '2015-11-13', 'színmű', 'magyar'),
(1840, 'Bohémélet', 22, '2016-02-19', 'opera', 'olasz'),
(1841, 'Racine / Strindberg', 140, '2018-03-27', NULL, NULL),
(1842, 'SajátSzínház: Mindennek ellenére?', NULL, '2020-11-29', NULL, NULL),
(1843, 'Szegény Dzsoni és Árnika', 13, '2019-11-10', 'bábjáték', NULL),
(1844, 'Holnapelőtt', 83, '2019-10-05', NULL, NULL),
(1845, 'Rózsa és Ibolya', 122, '2017-11-28', 'mesejáték', 'magyar'),
(1846, 'Malakiás napja', 134, '2016-11-10', 'felolvasószínház', 'magyar'),
(1847, 'Mazsola', 113, '2015-09-27', 'bábjáték', NULL),
(1848, 'A női szabó', 73, '2015-04-17', 'vígjáték', 'magyar'),
(1849, 'Nemzeti Vegyesbolt', 96, '2013-12-31', 'vígjáték', 'magyar'),
(1850, 'Menyasszonytánc', 148, '2020-10-28', 'musical', NULL),
(1851, 'Karma, az élet játéka', 65, '2012-11-15', 'táncelőadás', 'magyar'),
(1852, 'A szilfid', 22, '2014-05-03', 'balett', NULL),
(1853, 'Anne Frank naplója / A képfaragó', 29, '2020-02-15', 'opera', NULL),
(1854, 'Parasztbecsület / Bajazzók', 23, '2019-04-05', 'opera', NULL),
(1855, 'XVIII. Duna Karnevál Gála', 82, '2013-06-21', 'táncelőadás', 'magyar'),
(1856, 'Június', 148, '2014-11-15', 'színmű', 'magyar'),
(1857, 'Chicago', 181, '2018-12-21', 'musical', NULL),
(1858, 'Márton partjelző fázik', 6, '2018-03-02', NULL, NULL),
(1859, 'Lili bárónő', 17, '2019-08-02', NULL, NULL),
(1860, 'A hókirálynő', 109, '2015-11-10', 'zenés mesejáték', 'magyar'),
(1861, 'Malaga', 159, '2015-04-21', 'dráma', 'magyar'),
(1862, 'Kon-Takt(s)', NULL, '2021-10-29', 'balett', NULL),
(1863, 'A Félőlény', 23, '2018-02-16', 'mesejáték', NULL),
(1864, 'A király beszéde', 102, '2019-10-05', NULL, NULL),
(1865, 'Rekviem egy álomért', 30, '2021-09-04', NULL, NULL),
(1866, 'Le villi - Lidércek', 191, '2012-11-28', 'táncelőadás', 'magyar'),
(1867, 'Addams Family', NULL, '2020-04-17', NULL, NULL),
(1868, 'Bernarda Alba háza', NULL, '2018-05-17', NULL, NULL),
(1869, 'Az egérlyukból', 129, '2018-05-29', 'dráma', NULL),
(1870, 'Unferlédi', 122, '2019-04-27', NULL, NULL),
(1871, 'In illo tempore', 8, '2013-05-29', 'táncelőadás', 'magyar'),
(1872, 'Átváltozások', 9, '2012-08-17', NULL, NULL),
(1873, 'Acélmagnóliák', 134, '2016-03-04', 'színjáték', 'magyar'),
(1874, 'Varázskendő', 73, '2016-01-22', NULL, 'magyar'),
(1875, 'Egy rózsaszál szebben beszél', 6, '2016-03-12', 'zenés előadás', 'magyar'),
(1876, 'Étellift / a Te szemeddel - beszéljünk róla!', 182, '2015-11-12', NULL, 'magyar'),
(1877, 'IZP-estek - Rácz Réka: Nárcisz / Kiss Róbert: A második nem (The Second sex)', NULL, '2021-09-23', 'táncelőadás', NULL),
(1878, 'Kuszakeszi történet', 151, '2020-10-04', 'bábelőadás', NULL),
(1879, 'Foundry Dance Theatre/Öntöde Színház: Inanima/Lélekvesztő', NULL, '2018-12-11', NULL, NULL),
(1880, 'Babaház (Nóra)', 144, '2016-11-23', NULL, 'magyar'),
(1881, 'Elmentek - Notóriusok 30.2', 21, '2013-02-11', 'színmű', 'magyar'),
(1882, 'Asagao', 14, '2013-05-22', 'zenés előadás', 'magyar'),
(1883, 'Györgyike drága gyermek', NULL, '2018-04-06', NULL, NULL),
(1884, 'A pelikán', 166, '2012-11-27', 'felolvasószínház', 'magyar'),
(1885, 'Concerto / Vadak / A szent', 137, '2021-11-26', 'táncelőadás', NULL),
(1886, 'Messiás', 150, '2019-12-21', 'oratórium', NULL),
(1887, 'Hodworks: SUNDAY', 179, '2018-02-15', 'táncelőadás', NULL),
(1888, 'Dalok a földszintről', NULL, '2018-05-23', NULL, NULL),
(1889, 'IV. Henrik', 181, '2012-02-29', 'dráma', 'magyar'),
(1890, 'Elfolyó idő', NULL, '2018-01-30', 'táncelőadás', NULL),
(1891, 'May B', 173, '2013-05-10', 'táncelőadás', NULL),
(1892, 'Anna Karenina befejezetlen története', 57, '2018-03-02', NULL, NULL),
(1893, 'Túlóra', 140, '2017-04-01', NULL, 'magyar'),
(1894, 'Elveszett paradicsom', 182, '2020-09-03', NULL, NULL),
(1895, 'Bob herceg', 44, '2017-09-29', 'magyar', NULL),
(1896, 'Terror', 9, '2019-02-08', 'dráma', NULL),
(1897, 'Dávid király zsoltárai klezmerbe öltöztetve', 64, '2012-09-06', 'színmű', 'magyar'),
(1898, 'Mese a hársfa alatt', 27, '2014-11-30', 'bábjáték', NULL),
(1899, 'Farkasok és bárányok', 148, '2016-09-24', 'vígjáték', 'magyar'),
(1900, 'Lúdas Matyi', 131, '2016-09-23', NULL, NULL),
(1901, 'Alku', 102, '2014-10-10', 'dráma', 'magyar'),
(1902, 'Bánk Bán', 22, '2017-09-09', 'opera', 'magyar'),
(1903, 'Borka Mumusföldön', 201, '2012-03-26', 'bábjáték', 'magyar'),
(1904, 'Elsötétítés', 79, '2014-04-11', 'színmű', 'magyar'),
(1905, 'A testőr', 44, '2016-11-04', 'komédia', 'magyar'),
(1906, 'Vad nyomozók', 190, '2021-09-07', NULL, NULL),
(1907, 'MIT – A ember tragédiája rövidítve', NULL, '2019-11-18', NULL, NULL),
(1908, 'Fekete Péter', 73, '2017-10-06', 'kisoperett', 'magyar'),
(1909, 'Anyádék rajtam keresnek', 91, '2015-12-04', 'táncelőadás', 'magyar'),
(1910, 'Valami csaj(ok), avagy egyszeröt', 141, '2015-01-25', 'dráma', 'magyar'),
(1911, 'Szóval, én uralkodnék a vágyaim felett!?', 153, '2013-02-09', 'színmű', 'magyar'),
(1912, 'Az iglic', 34, '2013-10-18', 'színmű', 'magyar'),
(1913, 'Koppenhága', 79, '2015-01-21', 'színmű', 'magyar'),
(1914, 'Vágyrajárók', 102, '2017-11-04', NULL, 'magyar'),
(1915, 'MU TerMini: ManóTáncok', NULL, '2020-12-19', 'táncelőadás', NULL),
(1916, 'Szalonklára', 155, '2021-09-07', NULL, NULL),
(1917, 'Medve', 36, '2016-03-10', NULL, 'magyar'),
(1918, 'Madarak voltunk', 27, '2018-04-22', 'bábjáték', NULL),
(1919, 'Telik – egy óra az életedből', NULL, '2021-08-30', NULL, NULL),
(1920, 'Hajmeresztő', 56, '2012-03-24', 'bűnügyi játék', 'magyar'),
(1921, 'Numera! - Fókuszban a KETTES számMaladype Színház', NULL, '2015-01-18', NULL, 'magyar'),
(1922, 'Tóték', 109, '2017-10-13', NULL, 'magyar'),
(1923, 'Belül semmi', 71, '2016-03-11', 'kabaré', 'magyar'),
(1924, 'Óz', 134, '2016-02-17', 'zenés mesejáték', 'magyar'),
(1925, 'Rivaldafény (A Chanel-Lány)', 181, '2017-04-07', 'tragikomédia', 'magyar'),
(1926, 'A kezdő', 140, '2019-10-31', NULL, NULL),
(1927, 'Békakirály', 151, '2017-02-05', 'bábelőadás', NULL),
(1928, 'Werther', 22, '2015-10-25', 'dráma', 'magyar'),
(1929, 'A dzsungel könyve', 56, '2012-04-04', 'zenés játék', 'magyar'),
(1930, 'III. Richárd', 128, '2016-05-18', 'színmű', 'magyar'),
(1931, 'Elnémult harangok', 185, '2021-05-14', 'színjáték', NULL),
(1932, 'Égigérő fű', 44, '2019-09-21', 'vígjáték', NULL),
(1933, 'Tábori piknik', 44, '2013-04-28', 'abszurd játék', 'magyar'),
(1934, 'Leenane szépe', 129, '2017-11-17', NULL, 'magyar'),
(1935, 'FLASHBACK - Egy kiállítás képei', 197, '2014-04-23', 'táncelőadás', 'magyar'),
(1936, 'Az öldöklés istene', NULL, '2021-05-20', NULL, NULL),
(1937, 'Hazatérés', 126, '2015-03-09', 'dráma', 'magyar'),
(1938, 'Bolha a fülbe', 122, '2012-10-05', 'bohózat', 'magyar'),
(1939, 'A hóember, aki találkozni akart a Nappal', 116, '2019-02-10', 'bábjáték', NULL),
(1940, 'A karnevál vége', 182, '2012-02-10', 'színmű', 'magyar'),
(1941, 'Haza - Szerelem - Politika', 143, '2021-09-20', NULL, NULL),
(1942, 'SZRLM', 154, '2021-10-27', 'táncelőadás', NULL),
(1943, 'FARSANG avagy…ez is mekkora egy tahó…', 9, '2021-05-07', 'komédia', NULL),
(1944, 'Légy jó mindhalálig', 109, '2015-01-09', 'musical', 'magyar'),
(1945, 'Balett +', 134, '2015-11-12', 'táncjáték', 'magyar'),
(1946, 'Karnyóné-gyakorlatok', 140, '2012-03-14', NULL, 'magyar'),
(1947, 'A nyugat császára', 60, '2020-02-28', NULL, NULL),
(1948, 'Szuterén', 8, '2015-09-15', 'táncelőadás', 'magyar'),
(1949, 'Rosencrantz és Guildenstern halott', 14, '2014-09-18', NULL, 'magyar'),
(1950, 'Csárdáskirálynő', 122, '2019-11-08', 'operett', NULL),
(1951, 'Koronázási szertartásjáték - Szent László', 95, '2014-08-16', 'színpadi játék', 'magyar'),
(1952, 'Sómese', 131, '2012-09-21', 'mesejáték', 'magyar'),
(1953, 'Közellenség', 76, '2021-11-20', 'zenés előadás', NULL),
(1954, 'FLESH-dance', 8, '2012-06-01', 'táncelőadás', 'magyar'),
(1955, 'Nem értem, de veletek nevetek', 123, '2013-05-15', 'táncelőadás', 'magyar'),
(1956, 'Sába királynője', 22, '2015-07-03', 'opera', 'magyar'),
(1957, 'Ploutos (Wealth)', 54, '2013-06-24', 'színmű', 'angol'),
(1958, 'Óz, a nagy varázsló', 73, '2014-12-13', 'zenés mesejáték', 'magyar'),
(1959, 'II. Richárd', 60, '2019-12-21', NULL, NULL),
(1960, 'Csoda és Kósza', 129, '2016-02-13', 'mesejáték', 'magyar'),
(1961, 'SUGAR (Van, aki forrón szereti)', 56, '2012-08-18', 'musical', 'magyar'),
(1962, 'Legyen a feleségem!', 114, '2014-10-11', 'vígjáték', 'magyar'),
(1963, 'Diótörő', 134, '2012-12-26', 'balett', NULL),
(1964, 'Éjjeli menedékhely', 44, '2013-11-29', 'színmű', 'magyar'),
(1965, 'Elvarázsolt kastély', 76, '2015-04-22', 'táncjáték', 'magyar'),
(1966, 'Bunbury, avagy hazudj, ha tudsz', 126, '2020-04-24', 'zenés vígjáték', NULL),
(1967, 'Trianon', 95, '2020-03-07', NULL, NULL),
(1968, 'kArc', 48, '2012-04-10', NULL, NULL),
(1969, 'Suteru Tabi (Az elválás útja)', 157, '2012-11-03', 'színmű', 'japán'),
(1970, 'Hókusz Pókusz cirkusz', 143, '2017-03-01', NULL, 'magyar'),
(1971, 'Minden egér szereti a sajtot', 32, '2017-09-29', 'zenés mesejáték', 'magyar'),
(1972, 'Csíksomlyói passió', 109, '2012-03-23', NULL, 'magyar'),
(1973, 'Helló, dr. Mengele!', 192, '2015-05-29', NULL, 'magyar'),
(1974, 'A vihar kapujában', 185, '2018-01-18', 'dráma', NULL),
(1975, 'Kőműves Kelemen', 134, '2018-02-09', 'zenés előadás', NULL),
(1976, 'Veszek egy éjszakát', 102, '2016-11-12', 'komédia', 'magyar'),
(1977, 'Lesz vigasz?', 134, '2012-10-12', 'zenés színmű', 'magyar'),
(1978, 'Doktor Zsivágó', 148, '2016-12-17', 'musical', 'magyar'),
(1979, 'Függésben', 40, '2014-11-21', 'színmű', NULL),
(1980, 'A nyomorultak', 118, '2015-08-14', 'musical', 'magyar'),
(1981, 'Igenis, miniszterelnök úr!', 81, '2013-11-05', 'komédia', 'magyar'),
(1982, 'Holdbeli csónakos', 12, '2013-11-11', 'zenés mesejáték', 'magyar'),
(1983, 'Pán Péter kalandjai', 8, '2017-01-21', 'táncelőadás', 'magyar'),
(1984, 'A didergő király', 56, '2013-12-02', 'mesejáték', 'magyar'),
(1985, 'Trambulin', 72, '2013-10-26', 'táncelőadás', 'magyar'),
(1986, 'Firkamese', 139, '2014-12-13', 'bábpantomim', NULL),
(1987, 'Diótörőcske', 95, '2021-10-09', 'zenés mesejáték', NULL),
(1988, 'Weekend', 74, '2018-10-19', 'tragikomédia', 'magyar'),
(1989, 'Adáshiba', 111, '2018-04-07', 'komédia', NULL),
(1990, 'A főnök meg én meg a főnök', 152, '2017-04-29', 'vígjáték', 'magyar'),
(1991, 'Nyolckor a bárkán', 50, '2013-11-09', 'zenés mesejáték', 'magyar'),
(1992, 'Hajmeresztő', 185, '2012-10-26', 'színmű', 'magyar'),
(1993, 'Kereki', 201, '2021-09-12', NULL, NULL),
(1994, 'Lila fecske', 38, '2016-11-06', 'bábelőadás', 'magyar'),
(1995, 'Első szerelem', 122, '2014-02-07', 'dráma', 'magyar'),
(1996, 'Koldusopera', 170, '2015-03-14', 'színmű', 'magyar'),
(1997, 'Kövek', 12, '2013-02-18', 'zenés játék', NULL),
(1998, 'Balfácánt vacsorára', 185, '2016-10-07', 'vígjáték', 'magyar'),
(1999, 'TestVér', 191, '2016-06-15', 'táncelőadás', 'magyar'),
(2000, 'Örvény (Vortex)', 173, '2014-06-05', 'újcirkusz', NULL),
(2001, 'Sztálinváros', 130, '2014-11-21', 'bohózat', 'magyar'),
(2002, 'Ízlések és pofonok - Éjjel-nappal Budaörs', 30, '2014-02-15', 'kabaré', 'magyar'),
(2003, 'Tetkó', 129, '2014-11-22', NULL, 'magyar'),
(2004, 'Ágacska', 102, '2022-01-13', 'mesejáték', NULL),
(2005, 'Nyúzzatok meg', 173, '2013-04-11', 'táncelőadás', 'magyar'),
(2006, 'Cleansed', 140, '2019-01-11', NULL, NULL),
(2007, 'A boldogság madara', 47, '2019-11-17', 'mesejáték', NULL),
(2008, 'Újvilág passió', 134, '2012-09-21', 'színmű', 'magyar'),
(2009, 'Társasjáték New Yorkban', 134, '2019-11-16', 'komédia', NULL),
(2010, 'The Blues Brothers Band', 12, '2018-04-14', NULL, NULL),
(2011, 'Hysterology', 8, '2014-11-12', 'színmű', 'angol'),
(2012, 'Textúra 2020 - #01', NULL, '2020-11-03', NULL, NULL),
(2013, 'Vaknyugat', 181, '2012-12-21', 'komédia', 'magyar'),
(2014, 'On the Road', 151, '2014-02-13', 'bábjáték', 'angol'),
(2015, 'Régimódi történet', 148, '2019-10-05', NULL, NULL),
(2016, 'Csoda', 176, '2013-01-26', 'színmű', 'magyar'),
(2017, 'Rózsakirálylány', 40, '2021-08-28', 'gyerekműsor', NULL),
(2018, 'III/II-es Richard, avagy hús és hentesáru', 124, '2013-04-26', 'színmű', 'magyar'),
(2019, 'Mohács', 109, '2012-01-27', 'dráma', 'magyar'),
(2020, 'T', 130, '2014-02-06', 'színmű', 'magyar'),
(2021, 'Afterparty - egy fiktív törzs fiktív rituáléja', 133, '2021-09-22', 'táncelőadás', NULL),
(2022, 'A három kismalac és a farkasok', 192, '2012-05-14', 'bábjáték', NULL),
(2023, 'Cirkuszkocsival a sarkvidéken', 134, '2014-10-14', NULL, 'magyar'),
(2024, 'Blick Théâtre: [hullu]', 173, '2017-05-05', 'újcirkusz', NULL),
(2025, 'Hétalvó', 131, '2013-04-26', 'mesejáték', 'magyar'),
(2026, 'Halál', 69, '2016-03-04', NULL, NULL),
(2027, 'Piros kocka, ezüst orr', 88, '2018-05-12', 'mesejáték', NULL),
(2028, 'Görgey', 109, '2015-03-27', 'dráma', 'magyar'),
(2029, 'Vojáger', 32, '2021-07-23', 'színmű', NULL),
(2030, 'Silence Book', 57, '2019-05-11', NULL, NULL),
(2031, 'Csalóka Péter', 129, '2013-10-19', 'zenés mesejáték', 'magyar'),
(2032, 'A tücsök és a hangya', 116, '2017-10-22', 'bábjáték', 'magyar'),
(2033, 'Othello', 34, '2020-10-09', NULL, NULL),
(2034, 'XIV. René', 23, '2018-03-23', 'zenés vígjáték', NULL),
(2035, 'Árgyélus királyfi', 23, '2016-02-26', 'daljáték', 'magyar'),
(2036, 'A hülyéje', 32, '2016-12-02', 'bohózat', 'magyar'),
(2037, 'Villám gazdit keres', 124, '2021-11-14', 'felolvasószínház', NULL),
(2038, 'Requiem', 3, '2016-06-02', 'táncelőadás', 'magyar'),
(2039, 'Network', 35, '2022-01-15', NULL, NULL),
(2040, 'A krokodilus', 157, '2016-10-07', 'színmű', 'magyar'),
(2041, 'A helység kalapácsa', 139, '2018-02-24', 'bábjáték', NULL),
(2042, 'Egy bolond százat csinál', 73, '2012-10-26', 'zenés színmű', 'magyar'),
(2043, 'Múlnak a gyermekévek...', 44, '2015-12-29', NULL, 'magyar'),
(2044, 'Alhangya', 129, '2015-01-10', 'komédia', 'magyar'),
(2045, 'Az Ötödik Évszak', 3, '2014-10-08', 'balett', 'magyar'),
(2046, 'Min nevet az ember?', 126, '2015-01-09', 'zenés vígjáték', 'magyar'),
(2047, 'Athéni Timon', 96, '2012-10-05', 'színmű', 'magyar'),
(2048, 'Karinthy Ferenc - Dunakanyar', 111, '2021-06-10', NULL, NULL),
(2049, 'Kifelé!', 33, '2014-03-15', 'színmű', 'magyar'),
(2050, 'Virrasztók', 48, '2012-06-20', NULL, NULL),
(2051, 'A bűvös patkó', 50, '2017-10-13', 'zenés mesejáték', 'magyar'),
(2052, 'Mulatság', 140, '2012-04-18', NULL, 'magyar'),
(2053, 'A kiskakas gyémánt félkrajcárja', 27, '2013-10-06', NULL, 'magyar'),
(2054, 'A szegény ember hegedűje', 13, '2015-11-08', NULL, NULL),
(2055, 'S. Ö. R.: Shakespeare Összes Rövidítve', 181, '2014-10-08', NULL, 'magyar'),
(2056, 'Nyakigláb, Csupaháj, Málészáj', 177, '2013-05-19', NULL, 'magyar'),
(2057, 'A halhatatlanságra vágyó királyfi', 112, '2018-02-18', 'mesejáték', NULL),
(2058, 'Pesti barokk', 68, '2016-10-07', NULL, 'magyar'),
(2059, 'Diótörő és egérkirály', 44, '2018-12-07', 'musical', NULL),
(2060, 'Cigánykerék', 185, '2021-10-15', 'musical', NULL),
(2061, 'Vendégség', 162, '2012-04-20', 'színmű', 'magyar'),
(2062, 'Lila ákác', 50, '2016-05-13', NULL, 'magyar'),
(2063, 'Münchausen báró kalandjai', 112, '2017-11-05', 'mesejáték', 'magyar'),
(2064, 'Zűrzavaros éccaka', 69, '2012-03-29', NULL, NULL),
(2065, 'Boci-boci tarka', 140, '2019-10-15', NULL, NULL),
(2066, 'A vágy villamosa', 99, '2016-02-05', 'színmű', 'magyar'),
(2067, 'Beethoven V.', 198, '2020-11-04', 'táncelőadás', NULL),
(2068, 'Musical pályázat: Hegyikristály / Kazinczy - a tizenötödik', 118, '2021-07-05', 'musical', NULL),
(2069, 'Mesék a Tejúton túlról', 88, '2012-04-22', 'mesejáték', 'magyar'),
(2070, 'Karácsonyi misztérium', 1, '2013-12-22', 'misztériumjáték', 'magyar'),
(2071, 'Lammermoori Lucia', 22, '2016-11-18', 'opera', 'olasz'),
(2072, 'Zserbótangó', 162, '2018-04-06', 'tragikomédia', NULL),
(2073, 'Horda', 78, '2013-04-24', 'táncelőadás', 'magyar'),
(2074, 'Az arab éjszaka', 172, '2014-05-11', 'színmű', 'magyar'),
(2075, 'On the air', NULL, '2018-02-23', 'táncelőadás', NULL),
(2076, 'Carmen', 99, '2020-02-21', 'opera', NULL),
(2077, 'Hogyan ettem kutyát?', 12, '2013-04-27', 'színpadi játék', 'magyar'),
(2078, 'Menyegző', 25, '2017-03-19', 'táncelőadás', NULL),
(2079, 'Két úr szolgája', 60, '2014-12-07', 'komédia', 'magyar'),
(2080, 'Parasztbecsület / Egy pohár víz', 99, '2016-02-19', 'opera', 'magyar'),
(2081, 'Mátyásmese, avagy hogyan került álruha a királyra?', 134, '2013-03-06', 'mesejáték', 'magyar'),
(2082, 'Freak Fusion: Restlesslegs', NULL, '2020-09-14', 'újcirkusz', NULL),
(2083, 'Büszkeség és balítélet', 35, '2018-09-14', NULL, NULL),
(2084, 'Titius Andronicus', 44, '2014-05-22', 'tragédia', 'magyar'),
(2085, 'Vérnász', 83, '2013-12-22', 'színmű', 'magyar'),
(2086, 'Előjáték Lear királyhoz', 143, '2020-11-05', NULL, NULL),
(2087, 'Falstaff I. - Operabeavató', NULL, '2019-04-03', NULL, NULL),
(2088, 'Amazonok – Három év múlva', 79, '2018-12-13', NULL, NULL),
(2089, 'A széttáncolt cipellők', 50, '2016-09-16', 'zenés mesejáték', 'magyar'),
(2090, 'Ártatlan vagyok', 56, '2018-11-10', 'vígjáték', NULL),
(2091, 'Bánk az esküdtszék előtt', 102, '2016-10-13', NULL, 'magyar'),
(2092, 'Pastorale', 100, '2016-03-18', NULL, 'magyar'),
(2093, 'Bányavirág', 70, '2014-09-26', 'tragikomédia', 'magyar'),
(2094, '...Tied a világ!', 114, '2014-06-19', 'zenés előadás', 'magyar'),
(2095, 'Gengszterek', 64, '2018-10-20', 'tragikomédia', NULL),
(2096, 'Ezeregyéjszaka', 129, '2020-01-17', NULL, NULL),
(2097, 'A gammasugarak hatása a százszorszépekre', 153, '2013-02-16', 'dráma', 'magyar'),
(2098, 'Kodály- és Ligeti-est', 136, '2017-10-13', 'táncelőadás', NULL),
(2099, 'Cirkuszhercegnő', 73, '2012-02-17', 'nagyoperett', 'magyar'),
(2100, 'Café Mennyország', NULL, '2019-07-17', 'kabaré', NULL),
(2101, 'Dark Play - Játék a cybertérben', 36, '2015-02-25', 'színmű', 'magyar'),
(2102, 'Vízmezők', NULL, '2021-08-27', NULL, NULL),
(2103, 'A hideg szív', 38, '2015-02-13', NULL, NULL),
(2104, 'Svejk', 76, '2019-03-02', 'zenés komédia', NULL),
(2105, 'Keep in Touch', 167, '2019-12-05', 'táncelőadás', NULL),
(2106, 'Emlékkönyv', 32, '2014-11-07', NULL, 'magyar'),
(2107, 'Liliom', 32, '2016-02-26', NULL, 'magyar'),
(2108, 'Képzelt riport egy amerikai popfesztiválról', 109, '2013-10-04', 'musical', 'magyar'),
(2109, 'Allez', 2, '2017-10-12', NULL, NULL),
(2110, 'Alt duett', 202, '2012-10-15', 'tragikomédia', 'magyar'),
(2111, 'Trisztán és Izolda', 43, '2014-02-06', NULL, 'magyar'),
(2112, 'Jézus Krisztus szupersztár', 118, '2017-10-15', 'rockopera', 'magyar'),
(2113, 'Enigma', NULL, '2018-05-16', NULL, NULL),
(2114, 'Mindent Éváról', 68, '2015-09-11', 'színmű', 'magyar'),
(2115, 'Mágikus Ha: Szó és dallam- vers a dalban', 140, '2017-04-13', NULL, 'magyar'),
(2116, 'Kramer kontra Kramer', 68, '2012-06-26', 'színmű', 'magyar'),
(2117, 'PASS-PORT Subotica/Szabadka', 46, '2012-05-20', NULL, NULL),
(2118, 'Hát, nem tudom...Jiří Menzel 80', NULL, '2018-07-04', 'felolvasószínház', NULL),
(2119, 'Csínom Palkó', 29, '2015-04-24', 'operett', 'magyar'),
(2120, 'Fatornyok', 162, '2020-09-25', NULL, NULL),
(2121, 'Holdbeli csónakos', 122, '2012-11-14', 'zenés mesejáték', 'magyar'),
(2122, 'Hókirálynő', 4, '2014-11-29', 'bábjáték', NULL),
(2123, 'Madagaszkár', 181, '2021-12-03', 'musical', NULL),
(2124, 'After the Choice / Home, sweet home...', 125, '2014-11-08', 'táncelőadás', 'magyar'),
(2125, 'Szentandrásnapi mámor', 171, '2016-02-17', NULL, 'magyar'),
(2126, 'Vacsora négyesben', 6, '2019-12-14', NULL, NULL),
(2127, 'A hullám', 185, '2015-11-13', NULL, 'magyar'),
(2128, 'Hodworks: Szólók', 179, '2017-02-16', 'táncelőadás', 'magyar'),
(2129, 'A pasi a szomszéd sír mellől', 79, '2013-04-14', 'komédia', 'magyar'),
(2130, 'Szivárvány havasán - Köpönyeg és palást', 9, '2016-03-05', 'dráma', 'magyar'),
(2131, 'A doktor úr', 170, '2020-02-29', NULL, NULL),
(2132, 'Ki ölte meg Szomna Grancsát', NULL, '2019-09-15', NULL, NULL),
(2133, 'Operett Gála', 29, '2019-09-25', 'operett', NULL),
(2134, 'Fantasio / Fortunio', NULL, '2020-09-21', 'vígopera', NULL),
(2135, 'Mórok', 92, '2012-07-24', NULL, 'magyar'),
(2136, 'The station', 8, '2017-10-13', 'táncelőadás', NULL),
(2137, 'Carmen', 148, '2012-03-10', 'opera', 'magyar'),
(2138, 'Afrika', 139, '2018-01-13', 'mesejáték', NULL),
(2139, 'Kérész a Trezorban', 135, '2016-03-01', 'táncelőadás', 'magyar'),
(2140, 'A tündérlaki lányok', 148, '2019-02-09', 'színmű', NULL),
(2141, 'Leányvásár', 39, '2013-07-05', 'nagyoperett', 'magyar'),
(2142, 'Csirkefej', 70, '2015-01-09', 'tragédia', 'magyar'),
(2143, 'Poppea megkoronázása', 34, '2020-03-07', 'zenés előadás', NULL),
(2144, 'Macskablöff', 88, '2018-09-29', 'bábjáték', NULL),
(2145, 'Oresztész szereti Hermionét, aki szereti Pürrhoszt, aki szereti Andromakhét, aki szereti Hektórt, ak', 20, '2021-10-09', NULL, NULL),
(2146, 'Az anyu én vagyok!', 185, '2014-09-25', 'komédia', 'magyar'),
(2147, '12 dühös ember', 23, '2014-10-15', 'színmű', 'magyar'),
(2148, 'Jövőre Veled ugyanitt 2.', 134, '2021-06-26', NULL, NULL),
(2149, 'Tengertánc', 100, '2019-10-14', 'csecsemő színház', NULL),
(2150, 'PR-Evolution Company: Agapé', NULL, '2020-10-06', 'táncelőadás', NULL),
(2151, 'Szélben szállók', 144, '2013-12-20', NULL, 'magyar'),
(2152, 'A földimalac, aki semmiben sem volt biztos', 38, '2017-04-23', 'bábjáték', 'magyar'),
(2153, 'Anatol és a nők', 190, '2014-03-02', 'színmű', 'magyar'),
(2154, 'Puskás, a musical', 148, '2021-12-11', 'musical', NULL),
(2155, 'Nekünk nyolc?', 185, '2016-04-14', NULL, 'magyar'),
(2156, '12 dühös ember', 99, '2017-05-26', 'bűnügyi játék', 'magyar'),
(2157, 'Játékok', 200, '2013-02-01', 'táncelőadás', 'magyar'),
(2158, 'Hamlet', 6, '2016-04-09', 'színpadi játék', 'magyar'),
(2159, 'Vízkereszt, vagy amit akartok', 76, '2014-11-29', 'komédia', 'magyar'),
(2160, 'A köpeny / Gianni Schicchi', 23, '2019-10-11', 'opera', NULL),
(2161, 'Zenél az erkély - kakaóval - Hamucipőcske', 134, '2013-12-15', 'színmű', 'magyar'),
(2162, 'Boribon és Annipanni', 43, '2013-10-08', NULL, NULL),
(2163, 'Mici néni két élete', 195, '2019-04-06', NULL, NULL),
(2164, 'A Szél kapuja', 135, '2019-04-15', 'táncelőadás', NULL),
(2165, 'Tipli', 160, '2020-03-13', NULL, NULL),
(2166, 'Para', 122, '2020-02-05', 'dráma', NULL),
(2167, 'Bertolt Brecht: A szecsuáni jólélek', NULL, '2021-04-02', NULL, NULL),
(2168, 'Black Comedy', 9, '2013-05-10', 'bohózat', 'magyar'),
(2169, 'Ithaka', 34, '2018-05-19', NULL, NULL),
(2170, 'Leánder és Lenszirom', 22, '2015-04-11', 'meseopera', 'magyar'),
(2171, 'Lúdas Matyi', 43, '2012-09-30', 'bábjáték', 'magyar'),
(2172, 'Dzsinn', 90, '2019-11-10', 'improvizáció', NULL),
(2173, 'Seb', NULL, '2020-11-26', NULL, NULL),
(2174, 'Leánder és Lenszirom', 157, '2020-09-19', 'mesejáték', NULL),
(2175, '3 kívánság', 32, '2014-04-29', 'táncelőadás', NULL),
(2176, 'Trianon100 - Magyarország messzire van', 182, '2020-04-18', 'zenés előadás', NULL),
(2177, 'Az a szép, fényes nap', 162, '2014-05-16', 'történelmi játék', 'magyar'),
(2178, 'Macbeth', 23, '2014-10-03', 'opera', 'olasz'),
(2179, 'Semmi', 185, '2014-10-01', NULL, NULL),
(2180, 'Utolsó pillanat', 172, '2012-10-03', NULL, NULL),
(2181, 'Sem mim / Parabelo', 191, '2013-04-20', 'balett', NULL),
(2182, 'Luxemburg grófja', 23, '2015-12-11', 'operett', 'magyar'),
(2183, 'Göcögő', 116, '2015-03-21', 'csecsemő színház', NULL),
(2184, 'Család ellen nincs orvosság', 134, '2017-01-06', 'komédia', 'magyar'),
(2185, 'Mario és a varázsló', 40, '2012-09-30', NULL, 'magyar'),
(2186, 'Egerek', 181, '2017-09-12', 'zenés mesejáték', 'magyar'),
(2187, 'Lady Bracknell és a lazac mosolya, avagy a bunburisták', 121, '2019-12-05', NULL, NULL),
(2188, 'Nyolc nő', 122, '2015-11-13', 'bűnügyi komédia', 'magyar'),
(2189, 'Pirat07&QueenOfLove', 40, '2012-01-09', NULL, NULL),
(2190, 'Párhuzamos dimenzió', NULL, '2021-06-15', 'táncelőadás', NULL),
(2191, 'Pécsi Balett 60 – jubileumi est', 115, '2021-10-06', 'táncelőadás', NULL),
(2192, 'A mulandó', 184, '2015-03-20', 'színmű', 'magyar'),
(2193, 'Estihajnalka', 201, '2019-03-08', 'revü', NULL),
(2194, 'Makrancos évszakok', 95, '2016-10-25', 'mesejáték', 'magyar'),
(2195, 'Lángoló kerékpár', 77, '2012-01-21', 'színmű', 'magyar'),
(2196, 'ELMARAD! - Oberfrank Réka: TOP X VOL.1. Dear 21st century! / Molnár Csaba: Gods and Monsters', NULL, '2020-03-19', 'táncelőadás', NULL),
(2197, 'Sirály', 157, '2013-01-12', 'színmű', 'magyar'),
(2198, 'Segítsd a királyt!', 122, '2014-12-19', 'dráma', 'magyar'),
(2199, 'Don Juan menyasszonyai', 130, '2012-10-05', 'zenés színmű', 'magyar'),
(2200, 'A kis hableány', 129, '2018-11-30', 'mesejáték', NULL),
(2201, 'Kutya-macska barátság', 151, '2015-03-22', 'bábjáték', NULL),
(2202, 'Szerelem, ó!', 50, '2020-03-06', 'vígjáték', NULL),
(2203, '\'84', 20, '2020-09-18', NULL, NULL),
(2204, 'Kabaré', 12, '2012-12-01', 'musical', 'magyar'),
(2205, 'Jövőre, Veled, Itt', 134, '2013-07-19', 'romantikus vígjáték ', 'magyar'),
(2206, 'Szerelem, Ó!', 95, '2020-01-24', 'bohózat', NULL),
(2207, 'PASS-PORT Segedin/Szeged', 46, '2012-10-19', NULL, NULL),
(2208, 'Tisztasági festés', 127, '2019-01-24', NULL, NULL),
(2209, 'Rómeó és Júlia', 87, '2014-02-12', 'táncelőadás', NULL),
(2210, 'Napfény kettőnknek', 79, '2012-11-06', 'színmű', 'magyar'),
(2211, 'Lajtha', 11, '2017-04-19', 'táncelőadás', NULL),
(2212, 'Kakuk Marci', 73, '2018-04-06', 'komédia', NULL),
(2213, 'Kócosak', 140, '2017-05-30', NULL, 'magyar'),
(2214, 'Marco Polo kalandjai', 82, '2015-08-26', 'táncelőadás', NULL),
(2215, 'Az égigérő fa', 38, '2015-09-27', NULL, NULL),
(2216, 'IV. Henrik', 94, '2015-02-20', 'színházi közvetítés', 'angol'),
(2217, 'A patkányok', 105, '2013-12-20', 'tragikomédia', 'magyar'),
(2218, 'A vöröslámpás ház', 56, '2015-04-25', 'zenés vígjáték', 'magyar'),
(2219, 'A hős', 140, '2019-05-09', 'dráma', NULL),
(2220, 'A mizantróp (Le Misanthrope)', 182, '2012-08-23', 'zenés színmű', 'magyar'),
(2221, 'Loveshake', NULL, '2018-01-20', NULL, 'magyar'),
(2222, 'Úri muri', 148, '2014-03-15', 'zenés színmű', 'magyar'),
(2223, 'Váci utcza 40', 74, '2019-10-12', 'tragikomédia', NULL),
(2224, 'Stuart Mária', 181, '2019-03-29', NULL, NULL),
(2225, 'Keresztül-kasul', 79, '2021-07-05', NULL, NULL),
(2226, 'Rettenetes szülők', 126, '2018-03-27', 'dráma', 'magyar'),
(2227, 'A papucsszaggató királykisasszonyok', 27, '2019-10-06', 'bábjáték', NULL),
(2228, 'Jöhetsz drágám!', 51, '2017-11-18', 'vígjáték', 'magyar'),
(2229, 'Sóska, sültkrumpli', 185, '2019-11-25', 'tragikomédia', NULL),
(2230, 'Shreds', 104, '2019-04-30', 'táncelőadás', NULL),
(2231, 'Banális viszonyok - Édes finomságok', 115, '2013-02-01', 'táncelőadás', 'magyar'),
(2232, 'Az élet a-moll (álom)', 31, '2015-08-20', 'színmű', 'magyar'),
(2233, 'Levelek a lövészárokból', 44, '2014-10-31', NULL, 'magyar'),
(2234, 'Gerincbántalmak', 98, '2014-04-06', NULL, NULL),
(2235, 'A kisfiú meg az oroszlánok', 76, '2017-05-10', 'mesejáték', 'magyar'),
(2236, 'Othello', 157, '2018-12-08', NULL, NULL),
(2237, 'OZ, a nagy varázsló', 129, '2013-09-28', 'zenés mesejáték', 'magyar'),
(2238, 'Adáshiba', 181, '2013-02-15', 'komédia', 'magyar'),
(2239, 'Elza K.', 140, '2017-04-07', NULL, NULL),
(2240, 'Hattyúcskák tava', 129, '2013-12-14', 'táncmesejáték', 'magyar'),
(2241, 'Mi történt Baby Jane-nel?', NULL, '2019-09-21', NULL, NULL),
(2242, 'Négyhangú opera', 23, '2021-11-05', 'opera', NULL),
(2243, 'Józsi', 6, '2013-04-26', 'színmű', 'magyar'),
(2244, 'Teljesen idegenek', 114, '2019-11-23', NULL, NULL),
(2245, 'Az ölében én', 62, '2017-02-09', NULL, 'magyar'),
(2246, 'A pillangók szabadok', NULL, '2021-06-02', 'vígjáték', NULL),
(2247, 'Játszótér', 198, '2018-09-26', 'táncmesejáték', NULL),
(2248, 'Body Building', 124, '2013-11-24', 'táncelőadás', 'magyar'),
(2249, 'Háry János', 39, '2014-08-01', 'daljáték', 'magyar'),
(2250, 'Vuk', 112, '2020-03-01', 'bábjáték', NULL),
(2251, 'Revenge', 171, '2015-11-15', NULL, 'magyar'),
(2252, 'Kamrapocok', 139, '2017-11-18', 'mesejáték', 'magyar'),
(2253, 'Jean-Paul Marat üldöztetése és meggyilkolása, ahogy a charentoni elmegyógyintézet színjátszói előadj', 140, '2019-09-21', NULL, NULL),
(2254, 'Bernarda Alba háza', 182, '2018-02-22', 'dráma', 'magyar'),
(2255, 'Rómeó és Júlia', 115, '2018-10-26', 'balett', NULL),
(2256, 'Várj, míg sötét lesz!', 129, '2021-09-10', NULL, NULL),
(2257, 'Producerek', 32, '2021-06-18', 'musical', NULL),
(2258, 'Tartuffe', 20, '2015-01-16', 'színmű', 'magyar'),
(2259, 'Ványa bácsi', 134, '2018-01-06', NULL, NULL),
(2260, 'Háztűznéző', 34, '2017-10-07', NULL, 'magyar'),
(2261, 'Fekete Péter', 59, '2019-03-03', NULL, NULL),
(2262, 'Rükverc', 181, '2017-05-12', NULL, 'magyar'),
(2263, 'Szeretők / a Te szemeddel - beszéljünk róla!', 182, '2015-11-21', NULL, 'magyar'),
(2264, 'Gyilkosság az Orient Expresszen', 152, '2020-09-05', 'krimi', NULL),
(2265, 'Kurázsi mama és gyermekei', 44, '2018-02-09', 'dráma', NULL),
(2266, 'A skarlát betű', 80, '2017-11-11', 'balett', 'magyar'),
(2267, 'K - Egy ország két lóért', 26, '2017-02-27', NULL, 'magyar'),
(2268, 'Az én kis állataim', 181, '2016-11-15', 'mesejáték', 'magyar'),
(2269, 'Delete', 40, '2013-01-18', 'színmű', 'magyar'),
(2270, 'Hosszú út az éjszakába', 134, '2014-02-14', NULL, 'magyar'),
(2271, 'Csoportterápia', 100, '2019-01-19', 'musical', NULL),
(2272, 'Charley nénje', 73, '2019-04-12', NULL, NULL),
(2273, 'Merénylet - De Sade úr betanításában', 158, '2014-10-29', 'színmű', 'magyar'),
(2274, 'Tündér Lala', 181, '2012-09-18', 'zenés mesejáték', 'magyar'),
(2275, 'Legendák színháza - A nagy szimultán', NULL, '2018-04-07', NULL, NULL),
(2276, 'Micimackó', 50, '2018-02-14', 'mesejáték', NULL),
(2277, 'Öt nő az esőben', 73, '2014-11-22', 'színmű', 'magyar'),
(2278, 'Antigoné', 99, '2013-11-08', 'tragédia', 'magyar'),
(2279, 'A falu rossza', 140, '2018-10-22', NULL, NULL),
(2280, 'Isten ostora', 157, '2014-12-19', 'dráma', 'magyar'),
(2281, 'Diótörő', 13, '2018-11-17', 'bábjáték', NULL),
(2282, 'A kartonpapa', 181, '2019-12-07', 'fekete komédia', NULL),
(2283, 'Én Prométheuszra gondoltam', 89, '2017-05-05', NULL, 'magyar'),
(2284, 'A legkisebb boszorkány', 131, '2015-09-25', NULL, NULL),
(2285, 'Isten pénze', 44, '2017-12-15', 'musical', NULL),
(2286, 'A cigánybáró', 22, '2017-03-24', 'nagyoperett', 'magyar'),
(2287, 'Kacor király', 13, '2019-03-10', 'bábjáték', NULL),
(2288, 'Bál a Savoyban', 181, '2014-12-30', 'operett', 'magyar'),
(2289, '10', 190, '2018-12-22', NULL, NULL),
(2290, 'Ahol a sötétség', 158, '2020-11-18', 'táncelőadás', NULL),
(2291, 'Magyar Népmesék', 136, '2020-02-22', 'táncelőadás', NULL),
(2292, 'Végzetes csapda', 36, '2014-10-31', 'színmű', 'magyar'),
(2293, 'Demerung (Csehov Meggyeskertje)', 124, '2022-01-08', NULL, NULL),
(2294, '999', NULL, '2021-11-21', NULL, NULL),
(2295, 'Én és a kisöcsém', 29, '2015-03-13', 'operett', 'magyar'),
(2296, '...hogy mi az a MAJOMTŐR...', 14, '2012-02-28', 'zenés játék', 'magyar'),
(2297, 'Parsifal', 150, '2020-04-10', 'zenés játék', NULL),
(2298, 'Nem, nem, köszönöm', NULL, '2020-10-09', 'monodráma', NULL),
(2299, 'Caligula helytartója', 157, '2018-09-21', 'dráma', 'magyar'),
(2300, 'Chicago', 130, '2016-04-27', 'musical', 'magyar'),
(2301, 'A Glembay ház', 190, '2015-12-19', 'színmű', 'magyar'),
(2302, 'Utolsó', 132, '2014-09-11', 'színmű', 'magyar'),
(2303, 'Pillangók', 173, '2012-05-18', 'interaktív mesejáték', 'magyar'),
(2304, 'Csongor és Tünde', 99, '2016-12-09', 'színjáték', 'magyar'),
(2305, 'ALíz Csudaországban', 181, '2021-10-12', 'zenés mesejáték', NULL),
(2306, 'Abigél', 148, '2017-12-09', 'színmű', NULL),
(2307, 'Megöltem az anyámat', 109, '2012-11-30', 'színmű', 'magyar'),
(2308, 'A vámkisasszony', 201, '2015-08-02', NULL, 'magyar'),
(2309, 'A kiskakas gyémánt félkrajcárja', 113, '2013-11-10', 'bábjáték', 'magyar'),
(2310, 'Mondjad, Atikám', 170, '2017-10-07', NULL, 'magyar'),
(2311, 'Júlia - Párbeszéd a szerelemről', 83, '2017-01-10', NULL, 'magyar'),
(2312, 'Papageno a metróban', 50, '2012-03-02', 'színmű', 'magyar'),
(2313, 'La Mancha lovagja', 32, '2017-03-24', 'musical', 'magyar'),
(2314, 'Volpone', 9, '2017-05-12', 'komédia', 'magyar'),
(2315, 'Szentivánéji álom', 192, '2012-05-04', NULL, NULL),
(2316, 'Hamupipőke', 116, '2014-09-20', 'gyermekelőadás', NULL),
(2317, 'Az üvegcipő', 23, '2015-11-27', 'vígjáték', 'magyar'),
(2318, 'Az imposztor', 108, '2016-02-26', 'komédia', 'magyar'),
(2319, 'Fat pig', 121, '2022-01-28', 'vígjáték', NULL),
(2320, 'Fordul', NULL, '2018-03-14', 'táncelőadás', NULL),
(2321, 'Kőműves Kelemen', 195, '2019-10-26', NULL, NULL),
(2322, 'A pokoli puncs-pancs', 6, '2016-12-04', 'zenés játék', NULL),
(2323, 'És közben szól a dal...', 134, '2015-03-05', NULL, NULL),
(2324, 'Nyáron, este fél tizenegykor', 157, '2014-11-21', 'színmű', 'magyar'),
(2325, 'Az aranyhalacska, avagy a halász meg a nagyravágyó felesége', 88, '2016-10-01', 'bábelőadás', NULL),
(2326, 'Az ingolstadti invázió', 140, '2016-10-21', NULL, 'magyar'),
(2327, 'Forgószél avagy a képzelet csodája', 80, '2012-01-14', 'balett', 'magyar'),
(2328, 'V. Szimfónia', 198, '2020-09-23', 'táncelőadás', NULL),
(2329, 'Tehetetlen tudat / (te)nder – Ambíció tehetségprogram', NULL, '2019-03-19', NULL, NULL),
(2330, 'Az üvegbúra', 20, '2018-05-26', NULL, NULL),
(2331, 'Agyagból gyúrt mese', 88, '2012-10-19', NULL, NULL),
(2332, 'Bolyongók', 118, '2020-01-18', 'mesemusical', NULL),
(2333, 'Szilveszter: Hét évszak, közte egy tél', 74, '2021-12-19', 'tragikomédia', NULL),
(2334, 'Mágusok és varázslók', 148, '2018-10-27', 'színmű', NULL),
(2335, 'A szecsuáni jólélek', 185, '2016-01-29', 'zenés előadás', 'magyar'),
(2336, 'Körös-körül', NULL, '2020-03-22', 'zenés bábjáték', NULL),
(2337, 'Nyitott ablak', 73, '2020-03-06', 'bohózat', NULL),
(2338, 'A webáruház', 129, '2012-03-09', 'játék', 'magyar'),
(2339, 'Hamvas Béla: Karnevál I.-II.-III.-IV.', 110, '2019-10-11', NULL, NULL),
(2340, 'Carmen', 95, '2017-03-04', 'színmű', 'magyar'),
(2341, 'Méray Tibor - 90', 64, '2014-04-13', 'zenés előadás', 'magyar'),
(2342, 'Kaleidoszkóp Hommage á Bartók Béla / A meztelen majom', NULL, '2021-07-20', 'táncelőadás', NULL),
(2343, 'A fecske', 150, '2019-05-26', 'opera', NULL),
(2344, 'Berzsián és Dideki', 139, '2015-10-03', 'bábjáték', NULL),
(2345, 'Végállomás', 152, '2015-04-11', 'színmű', 'magyar'),
(2346, 'Szutyok', 76, '2019-10-12', 'tragikomédia', NULL),
(2347, 'A víg özvegy', 122, '2013-09-13', 'operett', 'magyar'),
(2348, 'Üvegfigurák', 50, '2013-10-11', 'színjáték', 'magyar'),
(2349, 'Anconai szerelmesek 2', 129, '2014-01-18', 'zenés vígjáték', 'magyar'),
(2350, 'Szigliget', 9, '2014-03-14', 'bohózat', 'magyar');
INSERT INTO `eloadas` (`id`, `cim`, `szinhazid`, `datum`, `mufaj`, `nyelv`) VALUES
(2351, 'Bohémélet', 122, '2012-04-20', 'opera', 'magyar'),
(2352, 'A jóember Szecsuánból', 134, '2017-11-17', NULL, 'magyar'),
(2353, 'Írisz', NULL, '2019-03-22', 'táncelőadás', NULL),
(2354, 'Ványa bá', 9, '2015-12-04', 'színmű', 'magyar'),
(2355, 'A homokember', 140, '2014-12-12', 'színmű', 'magyar'),
(2356, 'Képzelt beteg', 126, '2015-06-26', 'vígjáték', 'magyar'),
(2357, 'Hóhérok', 34, '2017-03-18', NULL, 'magyar'),
(2358, 'A hülyéje', 106, '2014-12-11', 'bohózat', NULL),
(2359, 'Vérnász', 134, '2017-11-24', 'táncelőadás', NULL),
(2360, 'Hamvaimból', 130, '2020-09-30', 'monodráma', NULL),
(2361, 'A gyertyák csonkig égnek', 23, '2014-10-09', 'opera', 'olasz'),
(2362, 'A vadhattyú', 88, '2017-10-07', 'mesejáték', NULL),
(2363, 'Csalódások', 44, '2012-09-14', 'vígjáték', 'magyar'),
(2364, 'Ha az álom az élet', 122, '2017-09-29', 'zenés előadás', 'magyar'),
(2365, 'A beszélő köntös', 50, '2018-04-09', NULL, NULL),
(2366, 'SingSingSing3', 44, '2012-03-23', 'musical', 'magyar'),
(2367, 'Eleje - Notóriusok 30.1', 21, '2012-11-15', 'színmű', 'magyar'),
(2368, 'Utazás az éjszakába', 83, '2017-02-03', 'tragédia', 'magyar'),
(2369, 'Simeon', 197, '2014-03-21', 'táncelőadás', 'magyar'),
(2370, 'Boros Cipellők: Köszönés helyett', NULL, '2020-09-30', 'táncelőadás', NULL),
(2371, 'Ahogytetszik', 32, '2017-10-13', 'vígjáték', 'magyar'),
(2372, 'Kasimir és Karoline', 32, '2021-10-16', 'színmű', NULL),
(2373, 'Közellenség', 83, '2013-12-21', 'zenés színmű', 'magyar'),
(2374, 'Szentivánéji álom', 199, '2019-04-27', 'balett', NULL),
(2375, 'Kedves én!', 16, '2019-04-26', NULL, NULL),
(2376, 'A FANTOM vacsorája - Csengeri Attila és ????', 182, '2014-03-26', NULL, 'magyar'),
(2377, 'Ájlávjú', 202, '2021-06-10', 'musical', NULL),
(2378, 'A szűz és a szörny', 162, '2012-05-26', 'tragikomédia', 'magyar'),
(2379, 'Góbi Rita Társulat - Sziget-táncmonológok fényfürdőben', 107, '2020-12-14', 'táncelőadás', NULL),
(2380, 'Jó estét nyár, jó estét szerelem', 37, '2019-05-19', NULL, 'magyar'),
(2381, 'Don Pasquale', 22, '2016-01-09', 'vígopera', 'magyar'),
(2382, 'Az a szép, fényes nap', 95, '2020-01-25', 'történelmi dráma', NULL),
(2383, 'A ravatal', 1, '2014-11-15', 'bohózat', 'magyar'),
(2384, 'Ármány és szerelem', 44, '2016-02-12', 'színmű', 'magyar'),
(2385, 'Vérvörös Törtfehér Méregzöld', 49, '2020-10-08', NULL, NULL),
(2386, 'Szömörce, az eszement falu', 168, '2020-10-31', NULL, NULL),
(2387, 'Iphigeneia Auliszban', 44, '2012-10-13', 'tragédia', 'magyar'),
(2388, 'Jaroslav Krček: A Császár Új Ruhája - Kerek Gábor: Paródia', 150, '2014-10-12', 'opera', NULL),
(2389, 'Zita Magyar királynék', 56, '2018-10-20', NULL, NULL),
(2390, 'IV. em. 14.', 91, '2015-04-29', 'táncelőadás', 'magyar'),
(2391, 'Segítség, én vagyok a feleségem!', 56, '2014-04-27', 'vígjáték', 'magyar'),
(2392, 'Tóték', 76, '2013-11-09', 'tragikomédia', 'magyar'),
(2393, 'Játék a kastélyban', 76, '2017-10-21', NULL, 'magyar'),
(2394, 'Képzelt riport egy amerikai popfesztiválról', 129, '2016-10-08', 'musical', 'magyar'),
(2395, 'Árgyélus királyfi és Tündérszép Ilona', 177, '2015-05-30', 'magyar', NULL),
(2396, 'Frank Sinatra - A Hang', 103, '2013-02-25', 'musical show', 'magyar'),
(2397, 'A rút kiskacsa', 113, '2015-04-06', 'bábjáték', NULL),
(2398, 'Három nővér', 24, '2012-04-27', NULL, 'magyar'),
(2399, 'Születés, szerelem, halál', 69, '2012-04-21', NULL, 'magyar'),
(2400, 'A Kisgömböc', NULL, '2021-08-23', 'gyerekműsor', NULL),
(2401, 'Ernst (komoly) az élet (Bunbury)', 9, '2018-03-23', 'vígjáték', NULL),
(2402, 'Jászai Mari', 109, '2014-11-28', 'monodráma', 'magyar'),
(2403, 'Elektra', 128, '2017-05-26', NULL, NULL),
(2404, 'Árad a gazság', 9, '2021-10-15', 'színmű', NULL),
(2405, 'Csillagkirály legendája - gyerekeknek', 194, '2015-09-19', 'gyermekelőadás', 'magyar'),
(2406, 'Freskó', 65, '2021-06-10', 'táncelőadás', NULL),
(2407, 'Ördögi kör', 182, '2020-02-14', 'vígjáték', NULL),
(2408, 'MA és AL (MA AND AL)', 128, '2012-01-27', 'beavató színház', 'angol'),
(2409, 'Máraira hangolva: Szepes Mária és Faludy', 182, '2014-12-06', 'zenés előadás', 'magyar'),
(2410, 'A denevér', 73, '2016-01-22', 'operett', 'magyar'),
(2411, 'Döglött aknák', 162, '2013-02-08', 'komédia', 'magyar'),
(2412, 'A walesi lakoma', 148, '2014-06-13', 'színmű', 'magyar'),
(2413, 'Kirikou és a boszorkány', 38, '2017-03-10', 'mesejáték', NULL),
(2414, 'Don Carlos, spanyol infáns', 182, '2020-04-28', 'krimi', NULL),
(2415, 'A lemez két oldala (jótékonysági előadás)', NULL, '2017-11-28', NULL, NULL),
(2416, 'Család ellen nincs orvosság', 185, '2017-10-07', 'bohózat', 'magyar'),
(2417, 'Szerelmi bájital', 122, '2015-10-16', 'vígopera', 'magyar'),
(2418, 'Eszter', 125, '2012-03-20', 'táncelőadás', 'magyar'),
(2419, 'Don Quijote', 22, '2016-11-19', 'balett', 'magyar'),
(2420, 'Kecsege, facsiga', 131, '2013-09-20', 'gyermekelőadás', 'magyar'),
(2421, 'Octopus, avagy Szent György és a Sárkány', 140, '2019-03-03', NULL, NULL),
(2422, 'Hazárd keringő', 119, '2012-05-04', NULL, NULL),
(2423, 'I killed my mother (Megöltem az anyámat)', 152, '2013-05-03', 'színmű', 'angol'),
(2424, 'Bolond Istók', 50, '2017-04-19', NULL, 'magyar'),
(2425, 'Sonkamenüett', 50, '2016-12-09', 'musical', 'magyar'),
(2426, 'Abszurdia', 137, '2017-03-01', 'táncelőadás', NULL),
(2427, 'Amerikai Elektra', 134, '2020-02-14', 'tragédia', NULL),
(2428, 'A három kismalac', 13, '2016-01-17', 'bábelőadás', NULL),
(2429, 'István, a király', 29, '2018-08-24', 'rockopera', NULL),
(2430, 'Pukedli', 54, '2016-12-26', NULL, 'magyar'),
(2431, 'Adáshiba', 44, '2012-12-14', 'komédia', 'magyar'),
(2432, 'Megint elröpült…', NULL, '2020-09-16', NULL, NULL),
(2433, 'Antigoné 016', 123, '2016-02-26', NULL, 'magyar'),
(2434, 'A kopasz énekesnő', 32, '2013-03-23', 'abszurd dráma', 'magyar'),
(2435, 'Sörgyári Capriccio', 102, '2016-12-10', 'vígjáték', 'magyar'),
(2436, 'Érettségi', 185, '2021-11-12', NULL, NULL),
(2437, 'Akinek meg kell halnia', 23, '2018-03-31', 'passiójáték', NULL),
(2438, 'Naptárlányok', 83, '2017-09-29', NULL, 'magyar'),
(2439, 'Bonnie & Clyde', 122, '2018-09-28', 'musical', NULL),
(2440, 'Vigyázz, Kész, Kabaré', 5, '2018-04-04', NULL, NULL),
(2441, 'Midnight tango', 69, '2012-11-12', 'táncelőadás', NULL),
(2442, 'Sirály', 32, '2013-12-07', 'dráma', 'magyar'),
(2443, 'DreaMe', 8, '2012-03-02', NULL, 'magyar'),
(2444, 'Mario és a varázsló / A kékszakállú herceg vára', 22, '2013-11-09', 'opera', NULL),
(2445, 'Notre Dame', 150, '2021-06-09', 'opera', NULL),
(2446, 'Esterházy', 64, '2016-02-27', NULL, 'magyar'),
(2447, 'Kiszáradás', 2, '2018-01-19', NULL, NULL),
(2448, 'Végszó', 79, '2019-12-12', NULL, NULL),
(2449, 'A félkegyelmű', 170, '2018-02-28', 'dráma', NULL),
(2450, 'Csillagokkal táncoló Kojot', 136, '2014-04-26', 'táncelőadás', 'magyar'),
(2451, 'Fehérlófia', 97, '2016-04-02', NULL, 'magyar'),
(2452, 'Osztrigás Mici', 56, '2021-10-02', 'zenés bohózat', NULL),
(2453, 'Frivol', 54, '2021-09-14', 'táncelőadás', NULL),
(2454, 'Dajkamese', NULL, '2019-10-22', NULL, NULL),
(2455, 'Péter, avagy szélhámos kerestetik', 121, '2016-10-28', 'vígjáték', 'magyar'),
(2456, 'Lúdbőr', 8, '2016-09-19', 'táncelőadás', 'magyar'),
(2457, 'Csipike és Kukucsi', 130, '2021-11-26', 'mesejáték', NULL),
(2458, 'Heldenplatz', 21, '2012-10-12', 'színmű', 'magyar'),
(2459, 'Romeo és Júlia', 95, '2019-11-23', NULL, NULL),
(2460, 'A kutya különös esete az éjszakában', 76, '2019-04-13', NULL, NULL),
(2461, 'Bánk bán', 23, '2013-03-15', 'tragédia', 'magyar'),
(2462, 'A gát', 181, '2015-10-02', NULL, 'magyar'),
(2463, 'Panna, a pöttöm', 51, '2018-04-15', 'mesejáték', NULL),
(2464, 'A testőr', 60, '2015-03-07', 'komédia', 'magyar'),
(2465, 'NOIR - Brightmore Brothers\' Bloody Steak Restaurant', 97, '2019-12-07', NULL, NULL),
(2466, 'NemAkárki', 31, '2019-06-30', NULL, NULL),
(2467, 'Én és a kisöcsém', 185, '2017-01-20', 'operett', 'magyar'),
(2468, 'Csalafinta Karagöz', 4, '2012-02-11', NULL, 'magyar'),
(2469, 'Összeérő párhuzamok', NULL, '2019-03-03', 'tragikomédia', NULL),
(2470, 'Barbelo, avagy kutyákról és gyerekekről', 200, '2014-05-30', 'színmű', 'magyar'),
(2471, 'Meghallgatás', 6, '2019-03-08', NULL, NULL),
(2472, 'Illatszertár', 152, '2020-10-30', NULL, NULL),
(2473, 'Kőműves Kelemen', 99, '2020-11-20', 'rockopera', NULL),
(2474, 'Menjünk, menjünk Betlehembe!', 4, '2013-12-01', 'gyermekelőadás', 'magyar'),
(2475, 'Julie kisasszony', 12, '2014-05-24', 'színmű', 'magyar'),
(2476, 'Mennyország', 50, '2013-02-15', 'vígjáték', 'magyar'),
(2477, 'Dermedési pont', 16, '2013-11-26', 'színmű', 'magyar'),
(2478, 'Sirály - a Csehov árnyékában', 130, '2013-02-08', 'dráma', 'magyar'),
(2479, 'Agave', 32, '2019-02-02', NULL, NULL),
(2480, 'Premier', 170, '2019-03-02', NULL, NULL),
(2481, 'Egerek és emberek', 56, '2015-01-17', 'színmű', 'magyar'),
(2482, 'Szembesítés', 121, '2017-02-17', 'dráma', 'magyar'),
(2483, 'Woodbeat', 40, '2012-01-12', NULL, NULL),
(2484, 'Oscar', 129, '2018-12-14', 'bohózat', NULL),
(2485, 'Három lány', 9, '2019-02-15', 'dráma', NULL),
(2486, 'Caligula helytartója', 185, '2018-01-12', 'dráma', NULL),
(2487, 'Denevér (Nietoperz)', 173, '2013-09-28', NULL, 'lengyel'),
(2488, 'Sötét galamb', 44, '2012-12-01', 'dráma', 'magyar'),
(2489, 'Kék róka', 162, '2019-10-11', 'színjáték', NULL),
(2490, 'Kihallgatás?', 54, '2017-04-04', NULL, 'magyar'),
(2491, 'Leszel a barátom?', 191, '2012-04-12', 'táncjáték', 'magyar'),
(2492, 'La Mancha lovagja', 29, '2020-09-11', 'operett', NULL),
(2493, 'Individuum - Gangaray Trambulin VI.', 104, '2014-10-24', 'táncelőadás', 'magyar'),
(2494, 'Eldorádó', 102, '2020-02-08', NULL, NULL),
(2495, 'Counted silence - Leszámolt csend', 104, '2013-12-21', 'táncelőadás', 'magyar'),
(2496, 'Gyerekrablás a Palánk utcában', 163, '2017-07-21', 'zenés előadás', 'magyar'),
(2497, 'Csongor és Tünde', 87, '2013-04-07', 'drámai költemény', 'magyar'),
(2498, 'Pomádé király új ruhája', 99, '2014-10-03', NULL, 'magyar'),
(2499, 'Na\' Conxypanban hull a hó', 122, '2012-11-30', 'színmű', 'magyar'),
(2500, 'Kegyelem', 140, '2013-02-23', 'színpadi játék', 'magyar'),
(2501, 'Pillangó', 44, '2020-02-07', NULL, NULL),
(2502, 'A Rézhegyek királynője', 112, '2015-11-29', NULL, NULL),
(2503, 'Kabaré', 170, '2021-10-09', 'musical', NULL),
(2504, 'Három esős nap', 117, '2018-10-01', NULL, NULL),
(2505, 'Holle anyó', 109, '2013-11-06', 'mesejáték', 'magyar'),
(2506, 'A király és a szűz', 50, '2018-06-16', NULL, NULL),
(2507, 'Hegedűs a háztetőn', 147, '2017-09-10', 'musical', 'magyar'),
(2508, 'A szegény csizmadia és a Szélkirály', 50, '2016-02-11', 'mesejáték', 'magyar'),
(2509, 'Levelek Adytól - Jordán Tamás önálló estje', 6, '2021-09-19', NULL, NULL),
(2510, 'Kisgömböc', 123, '2014-01-26', NULL, 'magyar'),
(2511, 'Salemi boszorkányok', 148, '2013-09-28', 'dráma', 'magyar'),
(2512, 'Bakkhánsnők', 140, '2017-06-15', NULL, 'magyar'),
(2513, 'Tirpák Madonna - Ráskó Eszter önálló estje', 71, '2022-01-28', 'stand-up comedy', NULL),
(2514, 'Válogatás', 140, '2016-09-10', NULL, 'magyar'),
(2515, 'A kopasz énekesnő', NULL, '2019-10-01', NULL, NULL),
(2516, 'Legyetek jók, ha tudtok', 109, '2017-01-20', 'színmű', 'magyar'),
(2517, 'Bizalomjáték', 45, '2014-09-28', NULL, 'magyar'),
(2518, 'Boldogság', 102, '2016-01-23', 'vígjáték', 'magyar'),
(2519, 'Hová lett a cipellőm?', 32, '2013-10-08', 'gyermekelőadás', 'magyar'),
(2520, 'Emigránsok', 201, '2016-03-03', NULL, 'magyar'),
(2521, 'Leláncolt Prométheusz', 34, '2018-12-20', NULL, NULL),
(2522, 'Én és a kisöcsém', 32, '2012-09-15', 'zenés bohózat', 'magyar'),
(2523, 'Agyeldobás (Jeeves and Wooster)', 118, '2015-04-18', 'színmű', 'magyar'),
(2524, 'Ki a hunyó, avagy Bubus', 143, '2012-10-06', NULL, NULL),
(2525, 'A sötétben látó tündér', 76, '2016-10-15', NULL, NULL),
(2526, 'Zsákbamacska', 30, '2013-01-12', 'vígjáték', 'magyar'),
(2527, 'Koronázás', 182, '2016-03-25', NULL, 'magyar'),
(2528, 'Janika', 195, '2017-12-02', 'vígjáték', NULL),
(2529, 'Hol a pénz?', 73, '2012-01-14', 'komédia', 'magyar'),
(2530, 'Legénybúcsú', 114, '2019-05-04', NULL, NULL),
(2531, 'Bodnárné', 162, '2013-03-22', 'játék', 'magyar'),
(2532, 'Szerelmükből születtem én', 38, '2013-12-08', NULL, 'magyar'),
(2533, 'Hüvelyk Matyi', 4, '2016-02-13', NULL, NULL),
(2534, 'Mágnás Miska', 148, '2014-04-26', 'operett', 'magyar'),
(2535, 'A testőr', 148, '2013-02-16', 'vígjáték', 'magyar'),
(2536, 'Black Comedy', 126, '2016-10-10', 'vígjáték', 'magyar'),
(2537, 'Prakriti', 104, '2021-06-23', 'táncelőadás', NULL),
(2538, 'Marcella-show', 73, '2014-06-27', 'zenés előadás', 'magyar'),
(2539, 'Bolero Vers-Tánc-Színház', 134, '2017-04-11', NULL, 'magyar'),
(2540, 'Divided Time', NULL, '2021-10-01', 'táncelőadás', NULL),
(2541, 'Testnapló', 8, '2019-02-01', 'táncelőadás', NULL),
(2542, 'A Nyugat női', 134, '2014-01-09', NULL, 'magyar'),
(2543, 'Az egérfogó', 181, '2016-12-16', 'krimi', 'magyar'),
(2544, 'IZP-estek - Raubinek Lili: Énekek diorámával / Juhász Adél: László Károlyné', NULL, '2020-11-23', 'táncelőadás', NULL),
(2545, 'Az özvegy Karnyóné és a két szeleburdiak', 129, '2012-10-06', 'vígjáték', 'magyar'),
(2546, 'Líra és Epika', 140, '2020-03-05', 'mesejáték', NULL),
(2547, 'Csillaglépő csodaszarvas', 151, '2020-03-15', NULL, NULL),
(2548, 'Lidérc', 64, '2020-03-07', 'dráma', NULL),
(2549, 'A csárdás-ápolás művészete', NULL, '2018-05-18', NULL, NULL),
(2550, 'H-arcok (Hullámzó talaj, Beszélj hozzám)', 115, '2014-02-07', 'táncelőadás', NULL),
(2551, 'Az égig-érő fa', 131, '2020-10-17', 'bábelőadás', NULL),
(2552, 'La Mancha lovagja', 9, '2012-11-30', 'színmű', 'magyar'),
(2553, 'Kövek a zsebben', 202, '2014-12-22', NULL, 'magyar'),
(2554, 'Pötty', 131, '2016-05-28', 'mesejáték', 'magyar'),
(2555, 'Életkút (Az ismeretlen kutatása)', NULL, '2021-12-21', 'táncelőadás', NULL),
(2556, 'A három sárkány', 102, '2015-11-07', 'színmű', 'magyar'),
(2557, 'Traviata', 22, '2012-03-25', 'opera', 'olasz'),
(2558, 'A dühös lovag', 122, '2014-11-17', NULL, 'magyar'),
(2559, 'Magyar hősök, csaták és szerelmek', 154, '2019-03-02', 'táncelőadás', NULL),
(2560, 'Unokám, Benjamin', 79, '2015-05-27', 'színmű', 'magyar'),
(2561, 'Félúton a Fórum felé', 152, '2015-06-12', 'musical', 'magyar'),
(2562, 'Kukorica-Derce avagy A talléros kalap és más mesék', 129, '2012-04-21', NULL, 'magyar'),
(2563, 'Az utolsó hősszerelmes', 50, '2019-04-01', 'vígjáték', NULL),
(2564, 'Marilyn Monroe csodálatos halála', 121, '2012-10-12', 'tragikomédia', 'magyar'),
(2565, 'Etikett avagy A tökéletes ember', 127, '2016-02-13', NULL, NULL),
(2566, 'Vészhelyzetben', 99, '2015-07-08', 'bohózat', 'magyar'),
(2567, 'Teher alatt nő', NULL, '2018-06-01', NULL, NULL),
(2568, 'Az áruló', 44, '2013-03-26', NULL, 'magyar'),
(2569, 'Légy jó mindhalálig', 134, '2020-10-02', NULL, NULL),
(2570, 'Színezüst csehó', 52, '2019-05-17', 'musical', NULL),
(2571, 'A padlás', 95, '2014-11-29', 'mesemusical', 'magyar'),
(2572, 'Roberto Zucco', 128, '2013-11-23', NULL, 'magyar'),
(2573, 'Az ünnep', 181, '2018-04-20', 'dráma', NULL),
(2574, 'Édes Élet Cukrászda', 4, '2016-11-26', 'bábelőadás', NULL),
(2575, 'Az óra, amikor semmit nem tudtunk egymásról', 99, '2018-12-01', NULL, NULL),
(2576, 'Nyolc nő', 134, '2020-09-25', NULL, NULL),
(2577, 'Becsület - Árulás - Önámítás', 143, '2021-09-21', NULL, NULL),
(2578, 'Egyszer volt, hol nem volt Gyöngyöspatán...', 203, '2012-01-06', NULL, 'magyar'),
(2579, 'Advent Hargitán', 185, '2018-11-30', 'színjáték', NULL),
(2580, 'lieBESTod', 124, '2014-06-01', 'zenés előadás', 'magyar'),
(2581, 'A miniszter félrelép', NULL, '2018-05-08', NULL, NULL),
(2582, 'Tóth Ilonka', 157, '2016-10-25', NULL, NULL),
(2583, 'Poppea megkoronázása', NULL, '2020-09-25', 'opera', NULL),
(2584, 'Szürke galamb', 21, '2019-05-17', NULL, NULL),
(2585, 'A kőszívű ember fiai', 50, '2012-11-30', NULL, 'magyar'),
(2586, 'Az előszobaszekrény boszorkánya', 27, '2015-10-25', 'mesejáték', NULL),
(2587, 'Ki lakik az asztal alatt?', 4, '2020-01-25', 'csecsemő színház', NULL),
(2588, 'Adieu Paure Carneval', 140, '2015-09-27', 'zenés előadás', 'magyar'),
(2589, 'All genius all idiot', 173, '2017-03-31', 'újcirkusz', NULL),
(2590, 'Figaro 2.0', 22, '2015-10-19', 'vígopera', NULL),
(2591, 'Hello, Dolly!', 32, '2018-11-16', NULL, NULL),
(2592, 'Chioggiai csetepaté', 52, '2018-12-13', 'komédia', NULL),
(2593, 'Tartuffe', 157, '2019-10-18', NULL, NULL),
(2594, 'Óriásölő Margaret', 27, '2019-12-01', 'bábjáték', NULL),
(2595, 'Kispolgárok', 34, '2012-01-20', NULL, 'magyar'),
(2596, 'Lomtalanítás', 27, '2016-01-13', 'táncjáték', NULL),
(2597, 'A bagoly, aki félt a sötétben', 28, '2016-10-22', 'bábjáték', NULL),
(2598, 'A kétszereplős darab', 96, '2012-03-03', 'színmű', 'magyar'),
(2599, 'A Pentheszileia Program', 170, '2016-10-16', NULL, 'magyar'),
(2600, 'N mint Nosferatu', 173, '2015-05-15', NULL, 'magyar'),
(2601, 'Az anyu én vagyok!', 195, '2016-04-01', 'komédia', 'magyar'),
(2602, 'Boeing, Boeing', 99, '2017-09-16', 'vígjáték', 'magyar'),
(2603, 'Portugál levelek', 138, '2021-10-28', NULL, NULL),
(2604, 'Ciceró Szicíliában', 33, '2014-04-22', 'színmű', 'magyar'),
(2605, 'Két úr szolgája', 92, '2021-08-08', 'vígjáték', NULL),
(2606, 'Amphitryon', 140, '2014-02-25', 'színmű', 'magyar'),
(2607, 'Borban él az élet', 134, '2015-10-17', 'operett', 'magyar'),
(2608, '80 nap alatt a föld körül', 95, '2019-02-23', 'komédia', NULL),
(2609, 'Felnőtt mese', 55, '2021-12-21', 'táncelőadás', NULL),
(2610, 'Woyzeck', 157, '2018-04-11', NULL, NULL),
(2611, 'Augusztus Oklahomában', 95, '2015-11-28', 'családregény', 'magyar'),
(2612, 'Szent Péter esernyője', 185, '2017-11-24', 'vígjáték', 'magyar'),
(2613, 'Aranyoskám', 118, '2022-05-20', 'musical', NULL),
(2614, 'Tökéletlenek', 35, '2018-12-14', NULL, NULL),
(2615, 'Korrup Schőn', 62, '2015-03-31', NULL, 'magyar'),
(2616, 'Prostitúció', 200, '2016-01-10', NULL, 'magyar'),
(2617, 'Csoportterápia', 134, '2015-01-09', NULL, 'magyar'),
(2618, 'Dr. Faustus', 94, '2013-05-30', 'színházi közvetítés', 'angol'),
(2619, 'A Hókirálynő', 134, '2017-12-06', 'mesejáték', NULL),
(2620, 'Az idő vasfoga', 174, '2012-11-17', 'komédia', 'magyar'),
(2621, 'Csíksomlyói Passió', 157, '2017-03-10', NULL, 'magyar'),
(2622, 'Vendetta', 36, '2017-10-07', NULL, 'magyar'),
(2623, 'Randevú Párizsban, avagy Szenteltvíz és kokain', 10, '2012-06-12', 'komédia', 'magyar'),
(2624, 'Az arab éjszaka', 30, '2018-10-06', NULL, NULL),
(2625, 'Hamlet', 109, '2016-10-07', 'tragédia', 'magyar'),
(2626, 'Nyitott házasság', 182, '2020-01-31', NULL, NULL),
(2627, 'Válótársak', 79, '2014-12-16', 'színmű', 'magyar'),
(2628, 'Yvonne', 128, '2020-01-25', NULL, NULL),
(2629, 'Feledi János - Feledi Project: Rekviem', 25, '2020-03-04', 'táncelőadás', NULL),
(2630, 'Meseautó', 118, '2018-11-18', NULL, NULL),
(2631, 'Csókos asszony', 95, '2015-09-26', 'operett', 'magyar'),
(2632, 'Tiszavirág', 83, '2021-03-27', 'dráma', NULL),
(2633, 'Otthon, édes otthon', 156, '2012-05-29', NULL, 'magyar'),
(2634, 'négyNEGYED', 32, '2013-04-09', 'táncelőadás', 'magyar'),
(2635, 'Álarcosbál', 30, '2017-04-21', NULL, 'magyar'),
(2636, 'Nagyvárosi fények', 114, '2020-10-17', 'vígjáték', NULL),
(2637, 'Peregrinusok', 78, '2014-04-02', 'táncelőadás', 'magyar'),
(2638, 'My Fair Lady', 165, '2012-12-31', 'musical', NULL),
(2639, 'Három nővér', 20, '2016-10-14', 'színmű', 'magyar'),
(2640, 'come, been and gone', 173, '2014-03-06', 'táncelőadás', NULL),
(2641, 'Alíz', 129, '2012-12-01', 'mesejáték', 'magyar'),
(2642, 'Esznek-e a halottak epertortát?', 28, '2019-01-12', 'bábjáték', NULL),
(2643, 'Koto és Kaori', 41, '2012-03-08', NULL, 'magyar'),
(2644, 'Asszony a fronton', 79, '2012-10-06', 'színmű', 'magyar'),
(2645, 'Hatás alatt', NULL, '2021-10-15', NULL, NULL),
(2646, 'Acélmagnóliák', 9, '2018-11-23', 'színjáték', NULL),
(2647, 'Maskarák', 30, '2016-11-19', 'tragikomédia', NULL),
(2648, 'Nine', 29, '2021-09-24', 'musical', NULL),
(2649, 'Rosalie elmegy meghalni', 201, '2016-05-14', NULL, 'magyar'),
(2650, 'Játék a kastélyban', 122, '2017-12-22', 'vígjáték', NULL),
(2651, 'Lenka és Palkó', 131, '2017-02-17', 'bábjáték', 'magyar'),
(2652, 'Boldogtalanok', 172, '2021-01-19', NULL, NULL),
(2653, 'Horizont Táncfesztivál - United space of ambivalence', NULL, '2019-04-27', 'táncelőadás', NULL),
(2654, 'Móka Miki és barátai', 51, '2013-10-20', 'mesejáték', 'magyar'),
(2655, 'Mágnás Miska', 170, '2019-10-26', 'operett', NULL),
(2656, 'Róza', 121, '2014-12-05', 'vígjáték', 'magyar'),
(2657, 'Szibériai csárdás', 148, '2019-09-21', 'zenés játék', NULL),
(2658, 'Szutyok', 95, '2016-01-30', NULL, 'magyar'),
(2659, 'Virágot Algernonnak', 29, '2015-12-17', 'musical', 'magyar'),
(2660, 'A szabin nők elrablása', 192, '2012-12-30', NULL, NULL),
(2661, 'A halál nem bicikli (hogy ellopják tőled)', 48, '2013-04-25', 'színmű', 'magyar'),
(2662, 'a TÁGRA ZÁRT SZEMEK próbája', 166, '2015-11-25', 'színmű', 'magyar'),
(2663, 'A Holnemvoltbolt', NULL, '2017-12-22', 'zenés mesejáték', 'magyar'),
(2664, 'Macbeth', 191, '2015-03-06', 'táncelőadás', 'magyar'),
(2665, 'Az eltört korsó', 129, '2012-11-24', 'vígjáték', 'magyar'),
(2666, 'Rómeó és Júlia', NULL, '2018-03-14', NULL, NULL),
(2667, 'Egyszer volt, hol nem volt...hu', 203, '2013-02-27', 'színmű', 'magyar'),
(2668, 'Gyilkosság telefonhívásra', 79, '2014-02-27', 'színmű', 'magyar'),
(2669, 'Mundstock úr', 155, '2021-07-17', NULL, NULL),
(2670, 'Szerelemvarázs', 118, '2014-02-06', NULL, 'magyar'),
(2671, 'Oliver!', 99, '2019-10-04', 'musical', NULL),
(2672, 'Széttépve - Szabó Kimmel Tamás zenés estje', 117, '2019-02-22', NULL, NULL),
(2673, 'Pimpáré és Vakvarjúcska', 130, '2012-11-30', 'mesejáték', 'magyar'),
(2674, 'A miniszter felesége', 157, '2016-12-16', 'vígjáték', 'magyar'),
(2675, 'Jövőre veled ugyanitt', 73, '2018-10-12', 'romantikus vígjáték ', NULL),
(2676, 'Szemben a nappal', 148, '2017-10-21', NULL, 'magyar'),
(2677, 'Standing Ground', 8, '2017-10-06', 'táncelőadás', NULL),
(2678, 'Holdvilág és utasa', 83, '2013-09-21', 'színmű', 'magyar'),
(2679, 'Mesteremberek', 34, '2021-10-04', 'vígjáték', NULL),
(2680, 'Árvaálom', 173, '2016-03-17', 'doku-színház', 'magyar'),
(2681, 'A szép és a szörnyeteg', 56, '2014-10-22', 'zenés mesejáték', 'magyar'),
(2682, 'Írószövetségek harca', 1, '2013-02-23', 'színmű', 'magyar'),
(2683, 'Hapcikirály', 112, '2014-10-05', 'bábjáték', NULL),
(2684, 'Bánatos kurváim emlékezete', 138, '2020-01-13', NULL, NULL),
(2685, 'Hetvenhét', 50, '2013-01-11', 'interaktív mesejáték', 'magyar'),
(2686, 'Patika', 20, '2018-12-15', NULL, NULL),
(2687, 'Óz, a nagy varázsló', 151, '2014-01-19', 'gyermekelőadás', 'magyar'),
(2688, 'Deprivus', 136, '2021-07-09', 'táncelőadás', NULL),
(2689, 'IZP-estek: Test est/The Dark Night Of The Soul', NULL, '2019-12-19', 'táncelőadás', NULL),
(2690, 'Cukor Kreml', 21, '2015-05-15', 'színmű', 'magyar'),
(2691, 'Babahajó', 62, '2015-09-10', NULL, 'magyar'),
(2692, 'A bőbeszédű diófa', 112, '2015-11-01', NULL, NULL),
(2693, 'Az elnök szabadsága', 79, '2021-08-26', NULL, NULL),
(2694, 'A szőke ciklon', 114, '2015-08-14', 'színmű', 'magyar'),
(2695, 'Játsszunk mesét! - Piroska és a farkas', 13, '2013-02-08', 'mesejáték', 'magyar'),
(2696, 'Jubileumi beszélgetések', 49, '2019-01-13', NULL, NULL),
(2697, 'A falu rossza', 9, '2016-05-06', 'népszínmű', 'magyar'),
(2698, 'Váratlan vendég', 148, '2020-02-08', 'krimi', NULL),
(2699, 'Rómeó és Júlia', 70, '2017-03-24', NULL, 'magyar'),
(2700, 'Teljes napfogyatkozás', 143, '2015-01-24', 'színmű', 'magyar'),
(2701, 'Édes Anna', 148, '2015-02-07', 'színmű', 'magyar'),
(2702, 'Négyzetgyök', 111, '2015-04-10', NULL, 'magyar'),
(2703, 'Kövek a zsebben', 181, '2017-01-20', NULL, 'magyar'),
(2704, 'Haikuk', 140, '2013-04-20', 'színmű', 'magyar'),
(2705, 'Woman, BODY', 191, '2014-05-23', 'táncelőadás', NULL),
(2706, 'Johanna a máglyán', 157, '2013-11-29', 'zenés színmű', 'magyar'),
(2707, 'Ide-oda', 131, '2018-03-31', 'bábelőadás', 'magyar'),
(2708, 'Földindulás', 162, '2012-03-23', 'dráma', 'magyar'),
(2709, 'Hogy élnek a halak a tengerben?', 62, '2012-05-03', NULL, 'magyar'),
(2710, 'Musik, Musikk, Musique', 34, '2012-03-20', 'koncertvarieté', 'magyar'),
(2711, 'Szajré', 140, '2020-02-01', 'fekete komédia', NULL),
(2712, 'Szerencsére a tej', 140, '2020-02-22', NULL, NULL),
(2713, 'Oszkár és Rózsa mami', 122, '2018-03-27', NULL, NULL),
(2714, 'Dancing On A Grinder', NULL, '2021-09-18', NULL, NULL),
(2715, 'Lóvátett lovagok', 94, '2015-03-12', 'színházi közvetítés', 'angol'),
(2716, 'Rózsa és Ibolya', 23, '2015-11-06', 'mesejáték', 'magyar'),
(2717, 'Arzén és levendula', 73, '2019-03-01', NULL, NULL),
(2718, 'Babits Mihály: Barackvirág / Gozzi: A három narancs szerelmese', 124, '2014-10-25', 'színmű', 'magyar'),
(2719, 'Csodagömb - Cirkuszi Nagykarácsony', 156, '2017-11-04', 'cirkuszi előadás', 'magyar'),
(2720, 'Szimpla szerda', 36, '2016-10-07', NULL, 'magyar'),
(2721, 'XIV. René', 121, '2017-11-10', 'zenés előadás', 'magyar'),
(2722, 'A zsákfalu', 124, '2013-05-24', 'színmű', 'magyar'),
(2723, 'Pezsgős vacsora', 50, '2020-11-20', NULL, NULL),
(2724, 'Alegría', 147, '2012-05-17', NULL, NULL),
(2725, 'Ingyenélők', 157, '2015-02-21', 'vígjáték', 'magyar'),
(2726, 'Naftalin', 134, '2013-04-05', 'bohózat', 'magyar'),
(2727, 'Ajándékul vegyétek tőlem', NULL, '2021-06-01', 'performance', NULL),
(2728, 'Mellettem elférsz', 79, '2014-09-12', NULL, 'magyar'),
(2729, 'MU Terminál A est, 2015 - Fejes Ádám: A dzsungel könyve', 8, '2015-11-28', 'táncelőadás', 'magyar'),
(2730, 'Legszebb férfikor', 152, '2019-12-15', NULL, NULL),
(2731, 'L\'immédiat', 157, '2012-03-20', NULL, NULL),
(2732, 'Zsuzsika hangja', 121, '2017-03-17', 'interaktív mesejáték', 'magyar'),
(2733, 'Don Quijote', 22, '2012-03-24', 'balett', 'magyar'),
(2734, 'Project Rampz', 123, '2016-02-19', 'táncelőadás', 'magyar'),
(2735, 'Óz, a csodák csodája', 170, '2015-10-31', 'zenés mesejáték', 'magyar'),
(2736, 'Biedermann és a gyújtogatók', 129, '2014-05-03', NULL, 'magyar'),
(2737, 'Fülke', 64, '2019-10-26', NULL, NULL),
(2738, 'Kortalan kortárs - MEGSZÁLLOTTSÁG', 138, '2017-04-06', NULL, 'magyar'),
(2739, 'A sevillai borbély', 145, '2017-07-28', 'vígopera', 'magyar'),
(2740, 'Vőlegény', 60, '2014-03-14', 'színmű', 'magyar'),
(2741, 'Haragossziget', 9, '2019-12-15', NULL, NULL),
(2742, 'Fame', 29, '2015-06-26', 'musical', 'magyar'),
(2743, 'Pinokkió Cirkuszi Meséje', 8, '2018-04-21', 'mesejáték', NULL),
(2744, 'Tájkép Klárikával', NULL, '2019-05-08', 'improvizáció', NULL),
(2745, 'Pinokkió', 56, '2017-01-29', 'mesejáték', 'magyar'),
(2746, 'Sztárcsinálók', 73, '2015-01-30', 'rock-musical', 'magyar'),
(2747, 'Az ördög', 121, '2017-11-24', 'vígjáték', 'magyar'),
(2748, 'Hair', NULL, '2021-06-27', 'musical', NULL),
(2749, 'Három nővér', 193, '2018-03-22', 'táncelőadás', NULL),
(2750, 'Naphimnusz', 84, '2013-01-06', 'táncelőadás', 'magyar'),
(2751, 'Égigérő mesefa első virága - Medve ének', 88, '2016-01-30', 'bábjáték', NULL),
(2752, 'Család ellen nincs orvosság', 44, '2016-03-18', 'komédia', 'magyar'),
(2753, 'Szerelem', 56, '2019-11-09', 'vígjáték', NULL),
(2754, 'Menekülés', 23, '2016-12-09', 'dráma', 'magyar'),
(2755, 'Székely fonó', 22, '2016-10-01', 'daljáték', 'magyar'),
(2756, 'A magyar Faust', 122, '2015-10-02', 'tragikomédia', 'magyar'),
(2757, 'A Nagy Ho-ho-ho Horgász Télen-Nyáron', 162, '2018-12-08', 'mesejáték', NULL),
(2758, 'Az emlékfoltozók', 112, '2016-02-07', NULL, NULL),
(2759, 'Tanár úr kérem!', 129, '2019-10-18', 'zenés játék', NULL),
(2760, 'Élet a Holdon', 22, '2015-11-20', 'vígopera', 'magyar'),
(2761, 'Egykutya', NULL, '2020-03-02', 'tragikomédia', NULL),
(2762, 'The great Gatsby', NULL, '2018-07-06', 'balett', NULL),
(2763, 'Physpacom - physical space communication', 191, '2012-04-18', 'táncelőadás', 'magyar'),
(2764, 'A két kicsi pingvin', 116, '2018-09-02', 'bábjáték', NULL),
(2765, 'Mamu alatt izzik Párizs', 6, '2020-12-11', 'komédia', NULL),
(2766, 'Bánk bán', 99, '2020-09-25', 'tragédia', NULL),
(2767, 'Krizantémok, avagy Liù halála', NULL, '2019-06-08', 'kamara est', NULL),
(2768, 'Páratlan páros 2.', 134, '2014-01-03', 'bohózat', 'magyar'),
(2769, 'Az operapróba', 22, '2018-05-17', 'vígopera', NULL),
(2770, 'Kispolgári nász', 98, '2012-02-21', NULL, 'magyar'),
(2771, 'A velencei kalmár', 157, '2013-03-22', 'színmű', 'magyar'),
(2772, 'Stop', 195, '2017-10-17', 'zenés játék', 'magyar'),
(2773, 'Székesfehérvári Balett Színház: Naplemente', NULL, '2019-02-24', 'táncelőadás', NULL),
(2774, '11', 14, '2013-11-06', 'táncelőadás', 'magyar'),
(2775, 'Köztársaság', 186, '2013-02-21', 'dráma', 'magyar'),
(2776, 'Ezüstlakodalom', 8, '2016-04-16', NULL, 'magyar'),
(2777, 'My Land', NULL, '2018-10-16', 'balett', NULL),
(2778, 'Papageno titka', 116, '2017-05-07', 'zenés bábjáték', 'magyar'),
(2779, 'Karnyóné', 138, '2016-12-04', NULL, 'magyar'),
(2780, 'Tündér Lala', 27, '2015-09-20', NULL, NULL),
(2781, 'Az elveszett Csontváry', 99, '2019-10-05', NULL, NULL),
(2782, 'Szent Péter esernyője', 126, '2018-04-10', 'vígjáték', NULL),
(2783, 'Nők. Játszmák. Rivaldafény.', 102, '2017-09-16', NULL, 'magyar'),
(2784, 'Janika', 73, '2017-09-22', 'vígjáték', 'magyar'),
(2785, 'Balfék', 134, '2015-01-02', 'bohózat', 'magyar'),
(2786, 'A színházcsináló', 60, '2012-01-06', 'színmű', 'magyar'),
(2787, 'Bors néni', 134, '2012-10-24', 'mesejáték', 'magyar'),
(2788, 'Áthallás', NULL, '2021-10-13', NULL, NULL),
(2789, 'Déryné ifjasszony', 73, '2021-04-23', NULL, NULL),
(2790, 'Az elvarázsolt testvérek', 38, '2014-10-26', 'bábjáték', 'magyar'),
(2791, 'Na\'Conxypanban hull a hó', 140, '2018-12-15', NULL, NULL),
(2792, 'Limit way / Emese & Emil', 123, '2012-12-07', 'táncelőadás', 'magyar'),
(2793, 'Pukedli - Hajsza', 95, '2017-01-19', NULL, 'magyar'),
(2794, 'Hókirálynő', 43, '2015-02-25', 'bábjáték', NULL),
(2795, 'Egy őrült naplója', 66, '2012-10-26', NULL, NULL),
(2796, 'One more time with feeling', 57, '2018-04-06', 'dráma', NULL),
(2797, 'Iphigeneia Auliszban', 140, '2017-10-06', NULL, 'magyar'),
(2798, 'Szerelmem, Majomúr', 26, '2015-04-28', NULL, 'magyar'),
(2799, 'Warrenné mestersége', 109, '2019-10-04', 'színjáték', NULL),
(2800, 'Üvegbúra', 11, '2015-02-18', 'táncelőadás', 'magyar'),
(2801, 'Papa és Josette', 140, '2020-02-23', NULL, NULL),
(2802, 'Nem menekülhetsz a vasárnaptól', 75, '2014-02-26', 'monodráma', NULL),
(2803, 'Furcsa pár - Női változat', 182, '2017-01-06', 'vígjáték', 'magyar'),
(2804, 'Csikóink', 122, '2014-10-17', 'mozgásszínház', NULL),
(2805, 'Tigris', 144, '2021-12-17', NULL, NULL),
(2806, 'Vágy', 137, '2020-03-03', 'táncelőadás', NULL),
(2807, 'Kézről kézre', 10, '2017-07-07', 'bohózat', 'magyar'),
(2808, 'A rodológia rövid története', 140, '2017-02-24', NULL, 'magyar'),
(2809, 'Máglya', 170, '2017-09-30', NULL, 'magyar'),
(2810, 'A király mulat', 31, '2012-05-31', 'színmű', 'magyar'),
(2811, 'Lehár gála', 29, '2020-11-11', 'zenés előadás', NULL),
(2812, 'Varázsfuvola', 148, '2015-03-28', 'opera', NULL),
(2813, 'Tündéria', 56, '2014-03-25', 'gyermekelőadás', 'magyar'),
(2814, 'Emil és a detektívek', 30, '2021-10-02', 'musical', NULL),
(2815, 'Folytassa, Ciceró! - avagy Botrány a törvényszéken', 83, '2018-09-21', 'zenés komédia', NULL),
(2816, 'Hamupipő', 4, '2013-04-06', 'bábjáték', 'magyar'),
(2817, 'A kripli', 129, '2020-09-12', 'komédia', NULL),
(2818, 'Szélfútta levél (Mensáros László 1956-os emlékezései)', 122, '2016-10-14', 'doku-színház', 'magyar'),
(2819, 'Segítsd a királyt!', 129, '2014-05-26', 'beavató színház', 'magyar'),
(2820, 'Sirály', 81, '2015-05-31', 'színmű', 'magyar'),
(2821, 'Az elveszett levél', 12, '2014-10-11', 'komédia', 'magyar'),
(2822, 'Gubanc', 45, '2015-06-01', NULL, 'magyar'),
(2823, 'Petőfi-játék', 146, '2019-08-09', NULL, NULL),
(2824, 'Kisrigók', 43, '2020-12-18', 'bábelőadás', NULL),
(2825, 'Irgum-Burgum Benedek', 113, '2013-04-07', 'gyermekelőadás', 'magyar'),
(2826, 'Morfium Nővér', 191, '2013-09-28', 'táncelőadás', NULL),
(2827, 'Agónia', 44, '2013-09-21', 'dráma', 'magyar'),
(2828, 'Az egérlyukból', NULL, '2018-09-16', NULL, NULL),
(2829, 'Helló, náci!', 181, '2017-05-17', 'dráma', 'magyar'),
(2830, 'A második teríték', 162, '2016-09-23', 'színmű', 'magyar'),
(2831, 'Egy szoknya, egy nadrág', 102, '2021-09-11', 'zenés vígjáték', NULL),
(2832, 'Száll a kakukk fészkére', 134, '2020-08-07', NULL, NULL),
(2833, 'Bűntény a Kecskeszigeten', 102, '2015-12-14', 'dráma', 'magyar'),
(2834, 'A királykisasszony, akinek nem volt birodalma', 151, '2015-02-01', 'bábjáték', NULL),
(2835, 'Az egérfogó', 109, '2019-12-06', 'krimi', NULL),
(2836, 'Rigoletto', NULL, '2018-08-05', NULL, NULL),
(2837, 'Barátom, Gombocska és a mágikus levelek története', 30, '2016-05-04', 'zenés előadás', 'magyar'),
(2838, 'Hattyúk tava', 189, '2021-06-04', 'balett', NULL),
(2839, 'Szeretők / Étellift - két egyfelvonásos', 182, '2015-10-24', NULL, 'magyar'),
(2840, 'FACTURA LAMIACEAE avagy az árvacsalánfélék családjához való teremtő vonzás törvényeiről', 33, '2014-09-23', 'monodráma', 'magyar'),
(2841, 'Legénybúcsú', 129, '2021-09-11', 'vígjáték', NULL),
(2842, 'Purparlé Velencében', 24, '2014-05-30', 'zenés komédia', 'magyar'),
(2843, 'La Traviata', 122, '2016-04-01', 'opera', 'olasz'),
(2844, 'Az arab éjszaka', 9, '2013-10-08', 'színmű', 'magyar'),
(2845, 'A kőszívű ember fiai', 99, '2014-03-14', 'színmű', 'magyar'),
(2846, '9000 km - Táncos történelem óra', 183, '2012-10-22', NULL, NULL),
(2847, 'Salamon király szorong', 79, '2016-06-09', 'színmű', 'magyar'),
(2848, 'Törés', 104, '2015-12-04', 'táncelőadás', 'magyar'),
(2849, 'Szentivánéji álom', 53, '2017-08-19', NULL, 'magyar'),
(2850, 'Szentivánéji álom', 80, '2013-10-19', 'balett', 'magyar'),
(2851, 'Csapodárok', 190, '2020-09-13', NULL, NULL),
(2852, 'Kísértetek', 9, '2016-09-30', 'dráma', 'magyar'),
(2853, 'Becsvölgye', 99, '2015-12-05', 'krimi', 'magyar'),
(2854, 'Buborékok', 109, '2013-04-19', 'szatirikus komédia', 'magyar'),
(2855, 'Csipkerózsika', NULL, '2021-10-03', 'gyerekműsor', NULL),
(2856, 'Májlájt', 194, '2012-04-14', 'dráma', 'magyar'),
(2857, 'Utolsó estém a földön', 140, '2016-03-03', NULL, 'magyar'),
(2858, 'Patika', 73, '2014-03-28', 'vígjáték', 'magyar'),
(2859, 'Anyám mondta - Mamelosn', 155, '2013-09-28', 'színmű', 'magyar'),
(2860, 'Európa-Ázsia', 77, '2013-12-20', 'színmű', 'magyar'),
(2861, 'Szenvedélyem, Velence', 103, '2014-01-31', 'táncelőadás', 'magyar'),
(2862, 'A karácsonyi rózsa legendája', 40, '2015-11-29', NULL, 'magyar'),
(2863, 'Égigérő fű', 129, '2015-03-14', NULL, 'magyar'),
(2864, 'I & Time', 198, '2019-09-15', 'táncelőadás', NULL),
(2865, 'Éneklő fiatalok', NULL, '2021-08-23', NULL, NULL),
(2866, 'Süsü, a sárkány', 196, '2020-02-12', 'zenés mesejáték', NULL),
(2867, 'A 3 emeletes mesekönyv', 131, '2017-10-21', 'bábelőadás', 'magyar'),
(2868, 'A vágy', 190, '2019-12-21', NULL, NULL),
(2869, 'Tomorrow\'s Parties', 173, '2013-05-25', 'színmű', NULL),
(2870, 'Szerelmünk, Kalotaszeg', 178, '2018-04-12', 'táncelőadás', NULL),
(2871, 'Ebcsont és nyúlcipő', 30, '2017-05-12', 'mesejáték', 'magyar'),
(2872, 'Az utolsó üzlet', 23, '2018-11-23', 'színmű', NULL),
(2873, 'Mario és a varázsló', 130, '2021-11-12', NULL, NULL),
(2874, 'Művészet', 9, '2017-12-01', 'komédia', 'magyar'),
(2875, 'A szent család', 202, '2018-12-13', NULL, NULL),
(2876, 'Urbi et orbi', 180, '2014-04-11', 'zenés előadás', 'magyar'),
(2877, 'Undermän', 173, '2012-12-20', NULL, NULL),
(2878, 'A kétfejű fenevad', 134, '2014-02-21', 'színmű', 'magyar'),
(2879, 'Kérem vigyázzanak, az ajtók záródnak!', 200, '2012-11-20', NULL, 'magyar'),
(2880, 'Minden egér szereti a sajtot', NULL, '2015-11-20', 'mesejáték', 'magyar'),
(2881, 'Kórház-Bakony', NULL, '2014-06-29', NULL, NULL),
(2882, 'A fizikusok', 7, '2012-10-12', NULL, NULL),
(2883, 'Felnőttkorunk ‘89', NULL, '2018-11-17', NULL, NULL),
(2884, 'Második nekifutás', 121, '2015-12-18', 'vígjáték', 'magyar'),
(2885, 'A manó', NULL, '2019-04-12', NULL, NULL),
(2886, 'Apa lánya', 43, '2018-12-13', 'bábelőadás', NULL),
(2887, 'Bádogdob', 34, '2016-12-22', NULL, 'magyar'),
(2888, 'Csontketrec', 185, '2020-01-28', NULL, NULL),
(2889, 'Medvék minden mennyiségben', 112, '2019-10-05', 'mesejáték', NULL),
(2890, 'Isten pénze', 29, '2014-11-28', 'musical', 'magyar'),
(2891, 'Médeia', 16, '2019-02-27', NULL, NULL),
(2892, 'A Napló, avagy a Don Juan-katalógus', 83, '2015-11-06', 'vígjáték', 'magyar'),
(2893, 'Sámson és Delila', 150, '2020-11-29', 'opera', NULL),
(2894, 'Visszavonulás', 79, '2017-11-27', NULL, 'magyar'),
(2895, 'Rák Jóska, dán királyfi', 130, '2017-01-27', 'tragikomédia', 'magyar'),
(2896, 'La Mancha lovagja', 23, '2012-11-16', 'musical', 'magyar'),
(2897, 'Furcsa pár', 32, '2017-12-01', 'vígjáték', NULL),
(2898, 'Psyhé-Liorona', 124, '2014-06-16', NULL, 'magyar'),
(2899, 'Kövek', 185, '2015-10-13', NULL, 'magyar'),
(2900, 'Outsiders', NULL, '2021-11-25', 'táncelőadás', NULL),
(2901, 'Tizenkét dühös ember', 76, '2018-01-13', 'bűnügyi játék', NULL),
(2902, 'Komámasszony, hol a stukker?', 102, '2014-12-13', 'vígjáték', 'magyar'),
(2903, 'Ecc-pecc kimehetsz', 152, '2016-04-30', 'szatirikus vígjáték', 'magyar'),
(2904, 'Mihail Afanaszjevics Bulgakov: Képmutatók cselszövése', 200, '2012-09-14', 'színmű', 'magyar'),
(2905, 'Szerelem', 134, '2015-10-09', 'színjáték', 'magyar'),
(2906, 'A tökmag és a hórihorgas', 192, '2012-11-12', 'bábjáték', NULL),
(2907, 'Apák fiai', 175, '2018-12-20', NULL, NULL),
(2908, 'KV Társulat: Pofon', NULL, '2020-10-14', NULL, NULL),
(2909, 'Tannhäuser', 23, '2020-10-24', 'opera', NULL),
(2910, 'A képzelt beteg', 43, '2016-11-19', NULL, NULL),
(2911, 'Mélyben (Éjjeli menedékhely)', 165, '2013-03-16', 'színmű', NULL),
(2912, 'Love Letters - Szerelmes levelek', 44, '2015-10-24', NULL, 'magyar'),
(2913, 'Gyöngyszólam', 178, '2012-03-08', 'táncelőadás', 'magyar'),
(2914, 'Somnakaj', 87, '2014-04-04', 'zenés sorsjáték', 'magyar'),
(2915, 'Gershwin show', 64, '2012-09-20', 'színpadi játék', 'magyar'),
(2916, 'Mártírok', 129, '2014-10-11', NULL, 'magyar'),
(2917, 'Világszép Nádszálkisasszony', 139, '2016-10-08', NULL, 'magyar'),
(2918, 'A rendíthetetlen ólomkatona', 146, '2017-12-09', 'mesejáték', 'magyar'),
(2919, 'Anya-e vagy?', 175, '2021-09-04', NULL, NULL),
(2920, 'Fergeteges - A királyné, a gróf és a cigánylány', 103, '2013-10-04', 'táncelőadás', 'magyar'),
(2921, 'Oliver!', 83, '2022-01-28', 'musical', NULL),
(2922, 'Árulás', 70, '2013-09-26', 'dráma', 'magyar'),
(2923, 'Leonce és Léna', 95, '2017-10-07', NULL, 'magyar'),
(2924, 'Csöngő', 160, '2014-02-22', NULL, 'magyar'),
(2925, 'Bloodshot (Véraláfutás)', 33, '2014-04-11', 'fizikai színház', 'magyar'),
(2926, 'A sHÓwKIRÁLYNŐ', 50, '2018-11-27', 'zenés játék', NULL),
(2927, 'A csúnya kacsa', 180, '2016-01-16', NULL, 'magyar'),
(2928, 'Hogyan nevezzelek', NULL, '2018-05-12', NULL, NULL),
(2929, 'Minden jó, ha vége jó', 34, '2016-06-04', NULL, 'magyar'),
(2930, 'Agnes, Isten báránya', 64, '2013-10-19', 'dráma', 'magyar'),
(2931, 'Hamlet - Let That Motherf*cker Burn', 123, '2016-02-05', NULL, NULL),
(2932, 'Népírtás, avagy nem funkcionál a májam', 95, '2020-04-25', 'komédia', NULL),
(2933, 'Lüszisztraté', 140, '2019-02-16', 'beavató színház', NULL),
(2934, 'What a wonderful song', 182, '2013-06-04', 'zenés est', 'magyar'),
(2935, 'Az Ösvény', 36, '2012-01-12', 'színmű', 'magyar'),
(2936, 'Tiszavirág / DANCE is not DEAD!', 78, '2019-11-23', 'táncelőadás', NULL),
(2937, 'Néró', 23, '2016-09-30', 'színmű', 'magyar'),
(2938, 'Batu-tá kalandjai', 43, '2018-11-09', 'bábjáték', NULL),
(2939, 'Platonov', 26, '2012-04-02', NULL, 'magyar'),
(2940, 'A kékszakállú herceg vára', NULL, '2018-05-24', 'opera', NULL),
(2941, 'A vihar', 92, '2012-07-12', NULL, NULL),
(2942, 'Ecki, Becki, Tengerecki', 131, '2019-10-12', 'bábjáték', NULL),
(2943, 'Hymen', 19, '2012-03-29', 'táncelőadás', 'magyar'),
(2944, 'Csoportterápia', 67, '2019-07-11', NULL, NULL),
(2945, 'Marica grófnő', 32, '2017-09-22', 'operett', 'magyar'),
(2946, 'Vidám kísértet', 114, '2015-05-06', 'bohózat', 'magyar'),
(2947, 'Szenvedély', 157, '2016-10-15', 'színmű', 'magyar'),
(2948, 'A pillangók szabadok', 102, '2018-02-23', 'romantikus vígjáték ', 'magyar'),
(2949, 'Dark Matters', 173, '2012-02-17', 'táncelőadás', 'magyar'),
(2950, 'Tosca', 32, '2015-09-25', 'opera', 'olasz'),
(2951, 'Bécsi vér', 44, '2014-12-12', 'operett', 'magyar'),
(2952, 'Sacra Hungarica', NULL, '2019-04-18', NULL, NULL),
(2953, 'Rómeó és Júlia', 155, '2019-03-30', NULL, NULL),
(2954, 'Carmina Burana', NULL, '2018-09-22', NULL, NULL),
(2955, 'Bocs, félrement!', 68, '2016-11-17', NULL, 'magyar'),
(2956, 'Madeleine', 173, '2012-03-02', NULL, 'magyar'),
(2957, 'V. Henrik', 92, '2016-07-15', 'dráma', NULL),
(2958, 'Pszicho', 50, '2019-03-01', NULL, NULL),
(2959, 'A cirkuszhercegnő', 134, '2022-01-07', 'operett', NULL),
(2960, 'Varsói melódia', 68, '2018-07-19', NULL, NULL),
(2961, 'Utánképzés ittas vezetőknek', 83, '2018-03-23', 'keserű komédia', NULL),
(2962, 'Mesterdetektív', 9, '2013-03-14', NULL, 'magyar'),
(2963, 'Mélyen tisztelt K!', 144, '2013-10-11', 'színjáték', 'magyar'),
(2964, 'A padlás', 9, '2015-12-11', 'mesemusical', 'magyar'),
(2965, 'A Zuhanás Sokkja', 175, '2019-05-04', NULL, NULL),
(2966, 'Garmann nyara', 38, '2016-03-20', NULL, NULL),
(2967, '9-től 5-ig', 129, '2019-12-07', NULL, NULL),
(2968, 'Peer Gynt', 144, '2017-06-09', NULL, 'magyar'),
(2969, 'A kis herceg', 148, '2019-03-23', 'mesejáték', NULL),
(2970, 'Chioggiai csetepaté', 134, '2012-12-12', 'színmű', 'magyar'),
(2971, 'Koldusopera', 50, '2014-10-17', 'színmű', 'magyar'),
(2972, 'Pamacs', 159, '2014-04-26', 'zenés mesejáték', 'magyar'),
(2973, 'Szemünk fényei', 36, '2015-11-16', NULL, 'magyar'),
(2974, 'Elisabeth', 148, '2019-12-14', 'musical', NULL),
(2975, 'Orosz lekvár', 129, '2015-05-09', 'komédia', 'magyar'),
(2976, 'Lumpáciusz Vagabundusz', 170, '2014-03-22', 'zenés vígjáték', 'magyar'),
(2977, 'Világszép nádszálkisasszony', 181, '2013-09-17', 'zenés mesejáték', 'magyar'),
(2978, 'A vérszipoly', 152, '2012-12-07', 'zenés komédia', 'magyar'),
(2979, 'Macbeth', 140, '2015-11-07', 'színmű', 'magyar'),
(2980, 'Beszélhetünk erről? / Can We Talk About This?', 173, '2012-02-22', NULL, 'angol'),
(2981, 'Háry János', 43, '2017-10-05', 'bábjáték', 'magyar'),
(2982, 'Ördögölő Józsiás', 12, '2013-03-23', 'zenés játék', 'magyar'),
(2983, 'Gina', 190, '2020-09-26', NULL, NULL),
(2984, 'Disney On Ice - Varázslatos Jégfesztivál', NULL, '2019-02-01', 'zenés revü', NULL),
(2985, 'Movements to Stravinsky / Mimi', NULL, '2021-10-06', 'táncelőadás', NULL),
(2986, 'A varázsfuvola', 122, '2018-04-25', 'opera', NULL),
(2987, 'Talált szív', 88, '2014-09-28', 'bábjáték', NULL),
(2988, 'Valentin nap éjszakája', 79, '2017-12-14', NULL, 'magyar'),
(2989, 'Stern Lili: LOOP POOL', 123, '2019-03-06', NULL, NULL),
(2990, 'Mátyás és Janus', NULL, '2019-09-22', NULL, NULL),
(2991, 'A másik', 182, '2016-03-31', NULL, 'magyar'),
(2992, 'Kecskeméti City Balett: Hamupipőke', NULL, '2021-12-02', 'balett', NULL),
(2993, 'Aladdin és a bűvös lámpa', 122, '2012-02-02', 'mesejáték', 'magyar'),
(2994, 'Érzettér-e-valaha - Az ismeretlen kutatása', NULL, '2020-12-14', 'táncelőadás', NULL),
(2995, 'Tartuffe', 1, '2013-10-07', 'vígjáték', 'magyar'),
(2996, 'Amazonok', 79, '2015-12-14', 'színmű', 'magyar'),
(2997, 'Öntudat', 75, '2013-10-18', 'népszínmű', NULL),
(2998, 'Salsa, szivar, szerelem...', 56, '2019-10-05', 'zenés játék', NULL),
(2999, 'A két Korea újraegyesítése', 34, '2014-10-17', 'színmű', 'magyar'),
(3000, 'Egerek', 50, '2015-10-20', 'zenés mesejáték', 'magyar'),
(3001, 'Premierajándék', 152, '2017-12-02', 'bohózat', 'magyar'),
(3002, 'Hollók (Les Corbeaux)', 173, '2013-10-18', 'táncelőadás', 'magyar'),
(3003, 'Anyám, a nyolcadik kerület', NULL, '2018-06-22', 'monodráma', NULL),
(3004, 'Jövőre veled ugyanitt 2.', 95, '2018-10-19', 'romantikus vígjáték ', NULL),
(3005, 'Mezítláb a parkban', 181, '2015-09-25', 'vígjáték', 'magyar'),
(3006, 'Álom luxuskivitelben', 199, '2019-02-23', 'táncjáték', NULL),
(3007, 'Álszentek összeesküvése', 70, '2015-03-27', 'színmű', 'magyar'),
(3008, 'Házasságon innen és túl', 76, '2015-12-12', NULL, 'magyar'),
(3009, 'Leányálom Kft.', 112, '2013-04-27', NULL, 'magyar'),
(3010, 'Az imposztor', 76, '2016-12-17', 'komédia', NULL),
(3011, 'Tanuld meg ezt a versemet', 30, '2013-11-23', NULL, 'magyar'),
(3012, 'Made in Hungaria', 73, '2013-04-12', 'musical', 'magyar'),
(3013, 'A fösvény', 95, '2013-10-26', 'dráma', 'magyar'),
(3014, 'Shakespeare a mellényzsebben', 9, '2021-12-17', NULL, NULL),
(3015, 'Tomasz Man: 111', 181, '2013-09-19', 'színmű', 'magyar'),
(3016, 'Robin Hood', 4, '2019-04-06', 'bábjáték', NULL),
(3017, 'Május!', 130, '2014-02-21', NULL, 'magyar'),
(3018, 'Az ismeretlen kutatása - Improvizációs alkotóműhely', 8, '2012-04-26', NULL, 'magyar'),
(3019, 'Babett hazudik', 36, '2016-03-06', NULL, 'magyar'),
(3020, 'Julie kisasszony', NULL, '2018-04-28', 'táncelőadás', NULL),
(3021, 'Hamupipőke', 99, '2018-05-26', 'vígopera', NULL),
(3022, 'Haramiák', 60, '2015-12-19', 'színmű', 'magyar'),
(3023, 'Footmarks', 11, '2020-11-30', 'táncelőadás', NULL),
(3024, 'Angyalföldi ballada', 102, '2015-12-12', 'zenés ballada', 'magyar'),
(3025, 'Lear király', 95, '2013-11-23', 'dráma', 'magyar'),
(3026, 'Keresztkantáták', NULL, '2020-05-22', NULL, NULL),
(3027, 'Három nővér', 32, '2018-10-05', 'dráma', NULL),
(3028, 'Vircsaft', 155, '2021-12-16', NULL, NULL),
(3029, 'Pletykafészek', 100, '2018-10-05', 'vígjáték', NULL),
(3030, 'Apád előtt ne vetkőzz', 68, '2020-11-03', NULL, NULL),
(3031, 'János vitéz', 29, '2019-11-22', 'daljáték', NULL),
(3032, 'Éjjeli menedékhely', 148, '2017-09-23', 'dráma', NULL),
(3033, 'Pokol', 105, '2012-06-12', NULL, NULL),
(3034, 'Vízkereszt, vagy amit akartok', 126, '2019-09-20', 'komédia', NULL),
(3035, 'Hatalom - Karrier - Bukás', 143, '2021-09-22', NULL, NULL),
(3036, 'A Pincérfrakk utcai cicák', 112, '2014-04-27', 'bábjáték', 'magyar'),
(3037, 'Szerelem, Ó!', 109, '2012-11-23', 'vígjáték', 'magyar'),
(3038, 'Csipike, az óriás törpe', 32, '2016-09-30', 'zenés mesejáték', 'magyar'),
(3039, 'Játék a kastélyban', 163, '2020-03-27', 'komédia', NULL),
(3040, 'A negyedik kapu', 200, '2014-08-23', 'színmű', 'magyar'),
(3041, 'A láthatatlan apuka', 53, '2015-04-12', NULL, 'magyar'),
(3042, 'Szilánkok', 182, '2018-06-18', NULL, NULL),
(3043, 'Másvilág', 24, '2017-12-12', NULL, NULL),
(3044, 'Emberi hang', 79, '2017-10-06', 'önálló est', 'magyar'),
(3045, 'Homebank', 9, '2018-01-26', NULL, NULL),
(3046, 'Batarita: Amint megragadja // TáncKedd VOL.2. // TRIP', NULL, '2020-11-03', 'táncelőadás', NULL),
(3047, 'Aida', 22, '2014-08-01', 'opera', 'olasz'),
(3048, 'Futótűz', 190, '2017-01-07', NULL, 'magyar'),
(3049, 'Óz, a nagy varázsló', 32, '2012-09-22', 'zenés mesejáték', 'magyar'),
(3050, 'Ti-Ti-Tá - Játék a ritmussal', 38, '2012-09-21', 'mesejáték', 'magyar'),
(3051, 'Bernd Róza', 152, '2019-09-28', 'dráma', NULL),
(3052, 'Eltűnő ingerek - ősbemutató', NULL, '2018-12-14', NULL, NULL),
(3053, 'Baal', 134, '2019-01-11', NULL, NULL),
(3054, 'Lúdas Matyi', 113, '2014-10-12', 'bábjáték', NULL),
(3055, 'Tortúra', 121, '2017-01-13', NULL, 'magyar'),
(3056, 'A medve nem játék', 44, '2020-03-18', 'komédia', NULL),
(3057, 'Két nő és...', 73, '2019-10-12', 'komédia', NULL),
(3058, 'Az apáca', 166, '2017-10-18', NULL, 'magyar'),
(3059, 'Leánykérés', 8, '2012-10-19', 'bábjáték', 'magyar'),
(3060, 'Honderű', 60, '2019-09-06', NULL, NULL),
(3061, 'Világszép Nádszálkisasszony', 23, '2019-02-15', 'zenés mesejáték', NULL),
(3062, 'Csetlő-botló Fajankó', 10, '2017-10-08', 'zenés mesejáték', 'magyar'),
(3063, 'A félőlény', 185, '2020-09-16', 'zenés mesejáték', NULL),
(3064, 'A hülyéje', 76, '2015-01-17', 'bohózat', 'magyar'),
(3065, 'A csúnya kislány', 27, '2019-01-20', 'bábjáték', NULL),
(3066, 'A karmester szeretője', 83, '2017-03-19', NULL, 'magyar'),
(3067, 'A politikusok lelki világa', 124, '2018-01-19', NULL, NULL),
(3068, 'Pilinkó, a csalimadár', 116, '2015-02-07', NULL, NULL),
(3069, 'Szedjetek szét', NULL, '2021-09-03', NULL, NULL),
(3070, 'MORGAN és FREEMAN', 8, '2014-04-11', 'táncelőadás', 'magyar'),
(3071, 'Fekete Sáfrán', 183, '2012-10-04', 'színmű', 'magyar'),
(3072, 'Addikt', 99, '2016-10-08', 'színmű', 'magyar'),
(3073, 'A háromfejű király', 140, '2019-11-23', NULL, NULL),
(3074, 'Jóembert keresünk', 170, '2012-10-13', 'zenés színmű', 'magyar'),
(3075, 'Terror', 21, '2016-10-08', NULL, 'magyar'),
(3076, 'Parázsfuvolácska', 23, '2017-02-24', 'meseopera', 'magyar'),
(3077, 'Godspell', 76, '2015-09-19', 'musical', 'magyar'),
(3078, 'Helené', 140, '2017-11-13', 'beavató színház', 'magyar'),
(3079, 'Ki fut a nő után', 174, '2015-02-28', NULL, 'magyar'),
(3080, 'Megidézett Kárpátalja', 84, '2014-11-16', 'táncelőadás', 'magyar'),
(3081, 'Stuart Mária', 20, '2014-05-17', 'színmű', 'magyar'),
(3082, 'Anna Karenina', 80, '2019-12-21', 'balett', NULL),
(3083, 'My Fair Lady', 95, '2014-02-15', 'musical', 'magyar'),
(3084, 'Ládafia', 131, '2014-02-21', 'gyermekelőadás', 'magyar'),
(3085, 'Tesztoszteron', 76, '2019-11-23', NULL, NULL),
(3086, 'Fától fáig', NULL, '2018-12-17', NULL, NULL),
(3087, 'Öböl', 8, '2015-04-24', 'táncelőadás', 'magyar'),
(3088, 'Antigoné - Karsai György beavatószínháza', 140, '2017-01-26', NULL, 'magyar'),
(3089, 'A hőstenor', 44, '2021-09-24', 'bohózat', NULL),
(3090, 'Harlequinade', 32, '2017-04-29', 'táncelőadás', NULL),
(3091, 'A vérszipoly', 35, '2021-03-06', NULL, NULL),
(3092, 'A nagy kézrablás', 152, '2016-04-23', NULL, 'magyar'),
(3093, 'Tévedések vígjátéka', 50, '2015-06-01', 'vígjáték', 'magyar'),
(3094, 'Csárdáskirálynő', 109, '2017-11-17', 'operett', 'magyar'),
(3095, 'Árnyország', 181, '2014-12-10', NULL, 'magyar'),
(3096, 'Pánik a fedélzeten', 6, '2013-10-18', 'musical', 'magyar'),
(3097, 'Príma környék', 70, '2012-11-30', 'komédia', 'magyar'),
(3098, 'Istenítélet (Salemi boszorkányok)', 170, '2015-12-20', 'színmű', 'magyar'),
(3099, 'Száll a kakukk fészkére', 102, '2021-11-27', NULL, NULL),
(3100, 'Borisz Godunov', 34, '2017-05-27', NULL, 'magyar'),
(3101, 'A lepkeoroszlán', 88, '2017-11-25', 'mesejáték', 'magyar'),
(3102, 'Angéla evangéliuma avagy a réterdősi patkányfogó', 35, '2012-11-02', 'szatíra', 'magyar'),
(3103, 'MU TERMINÁL B est, 2014 - Jens Bjerregaard: In the light / Aurelien Zouki: Pietá', 8, '2014-02-28', 'táncelőadás', NULL),
(3104, 'Egy rókáról és egy farkasról', 27, '2018-09-23', 'bábjáték', NULL),
(3105, 'Peter', 185, '2016-01-27', NULL, 'magyar'),
(3106, 'Úrhatnám polgár', NULL, '2018-07-20', 'komédia', NULL),
(3107, 'Nagy vacsora', 200, '2019-09-28', NULL, NULL),
(3108, 'Trió', 138, '2017-05-18', NULL, 'magyar'),
(3109, 'Bánk bán', 70, '2018-04-27', NULL, NULL),
(3110, 'Vérnász', 36, '2019-10-04', NULL, NULL),
(3111, 'Alternatív Stand up / Cabaret Ma sorozat részeként', 71, '2013-10-07', 'stand-up comedy', 'magyar'),
(3112, 'Küszöb', 140, '2013-05-29', 'táncelőadás', 'magyar'),
(3113, 'Betyárvilág', 154, '2019-09-24', 'táncelőadás', NULL),
(3114, 'Amika cukrászdája', 88, '2013-09-21', 'bábjáték', 'magyar'),
(3115, 'Apa Anya Fiú Lány', 30, '2019-10-26', NULL, NULL),
(3116, 'Mágnás Miska', 56, '2016-04-16', NULL, 'magyar'),
(3117, 'Pinokkió', 34, '2012-10-19', 'gyerekbábthriller', 'magyar'),
(3118, 'A lilahajú tündér', 4, '2019-10-12', 'bábjáték', NULL),
(3119, 'Lovak', 50, '2014-09-26', 'musical', 'magyar'),
(3120, 'Figaro házassága', NULL, '2018-12-14', 'vígopera', NULL),
(3121, 'Solaris', 140, '2015-03-13', 'színmű', 'magyar'),
(3122, 'Hit és illúzió', NULL, '2018-09-27', NULL, NULL),
(3123, 'Apátlanok', 68, '2015-03-01', 'színmű', 'magyar'),
(3124, 'Pumukli', 51, '2016-10-08', NULL, 'magyar'),
(3125, 'Állati zenék', 44, '2013-10-19', 'gyermekelőadás', 'magyar');
INSERT INTO `eloadas` (`id`, `cim`, `szinhazid`, `datum`, `mufaj`, `nyelv`) VALUES
(3126, 'Marica grófnő', 99, '2015-10-09', 'nagyoperett', 'magyar'),
(3127, 'A kakaska krajcárkái', 139, '2013-10-05', 'gyermekelőadás', 'magyar'),
(3128, 'Legyetek jók, ha tudtok!', 30, '2014-10-22', 'zenés előadás', 'magyar'),
(3129, 'Carousel - Liliom', 29, '2019-04-26', 'musical', NULL),
(3130, 'A dzsungel könyve', 95, '2012-09-22', 'musical', 'magyar'),
(3131, 'Táncvarázs - modern tánc és modern társastánc', NULL, '2018-05-26', 'táncelőadás', NULL),
(3132, 'Lekváros keksz járvány idején', NULL, '2020-10-22', NULL, NULL),
(3133, 'Idióta', 122, '2018-04-27', NULL, NULL),
(3134, 'Öreg tó', 91, '2014-05-02', 'táncelőadás', 'magyar'),
(3135, 'Játékosok & Cselédek', 23, '2015-09-25', NULL, 'magyar'),
(3136, 'MEGSZÁLLOTTSÁG avagy A postás mindig kétszer csenget', 182, '2018-07-31', NULL, NULL),
(3137, 'Shylock', 181, '2014-10-18', NULL, 'magyar'),
(3138, 'Három kismalac', 76, '2012-02-27', 'zenés játék', 'magyar'),
(3139, 'Kafkamánia', 98, '2013-02-19', NULL, 'magyar'),
(3140, 'Norma', 122, '2018-01-26', 'opera', NULL),
(3141, 'Kávécsarnok - három egyfelvonásos egy részben Szép Ernőtől és Molnár Ferenctől', 123, '2013-04-10', 'színmű', 'magyar'),
(3142, 'Feledi Project: Orfeusz / Revenge (Élektra)', 25, '2019-10-19', 'táncelőadás', NULL),
(3143, 'Állati reptér', 36, '2017-12-23', 'mesejáték', 'magyar'),
(3144, 'Boeing, Boeing - Leszállás Párizsban', 95, '2020-10-10', NULL, NULL),
(3145, 'Papucsszaggató királykisasszonyok', 144, '2014-05-23', 'színmű', 'magyar'),
(3146, 'Ratkó-lányok', 152, '2018-04-28', NULL, NULL),
(3147, 'Pulcinella és a varázskút', 112, '2017-01-29', 'bábjáték', NULL),
(3148, 'Ivanov', 9, '2017-03-03', 'dráma', 'magyar'),
(3149, 'Dühöngő', 201, '2013-07-18', 'színmű', 'magyar'),
(3150, 'Zárt tárgyalás', 143, '2018-12-14', 'dráma', NULL),
(3151, 'A mindentlátó királylány', 112, '2013-10-06', 'gyermekelőadás', 'magyar'),
(3152, 'A király beszéde', 148, '2019-09-28', 'dráma', NULL),
(3153, 'Színészköztársaság', 23, '2015-01-29', NULL, 'magyar'),
(3154, 'A pincér', 153, '2012-07-24', 'színmű', 'magyar'),
(3155, 'Sírig tartsd a Sade’!', NULL, '2019-12-17', NULL, NULL),
(3156, 'Főnix - Tűzcirkusz', 156, '2019-01-19', 'cirkuszi előadás', NULL),
(3157, 'Búcsúkoncert', 110, '2020-02-22', NULL, NULL),
(3158, 'Madame de Sade - Sade a nők szemszögéből', 182, '2019-05-16', NULL, NULL),
(3159, 'MU Terminál B Est, 2012', 8, '2012-02-17', NULL, 'magyar'),
(3160, 'A negyedik - Dante pokla', 190, '2020-12-18', NULL, NULL),
(3161, 'Sára asszony', 157, '2019-01-17', NULL, NULL),
(3162, 'A kis hableány', 131, '2020-02-08', 'bábjáték', NULL),
(3163, 'Emberszag', 14, '2015-12-18', NULL, 'magyar'),
(3164, 'A bolond Ásvayné', 162, '2014-03-28', 'játék', 'magyar'),
(3165, 'A kairói lúd, avagy A rászedett vőlegény', NULL, '2019-04-11', NULL, NULL),
(3166, 'Balkán kobra', 152, '2013-12-07', 'színmű', 'magyar'),
(3167, 'Egyenes labirintus', 109, '2015-11-30', 'táncjáték', NULL),
(3168, 'A testőr', NULL, '2018-04-06', 'vígjáték', NULL),
(3169, 'Talány Akusztik: koncert-színház', NULL, '2018-05-27', NULL, NULL),
(3170, 'Siegfried-idill, avagy Egy barátság vége', 22, '2018-05-15', NULL, NULL),
(3171, 'Süsü, a sárkány kalandjai', 51, '2014-10-19', 'zenés mesejáték', 'magyar'),
(3172, 'A heilbronni Katica', 15, '2015-01-17', 'dráma', 'magyar'),
(3173, 'Sógornők', 60, '2013-08-31', 'komédia', 'magyar'),
(3174, 'Nyitott ablak', 121, '2014-10-31', 'zenés vígjáték', 'magyar'),
(3175, 'Az eastwicki boszorkányok', 114, '2017-04-22', NULL, 'magyar'),
(3176, 'Ádám almái', 9, '2020-06-26', 'vígjáték', NULL),
(3177, 'Az ötödik pecsét', 185, '2016-12-09', 'színmű', 'magyar'),
(3178, 'Mesél a bécsi erdő', NULL, '2019-10-26', NULL, NULL),
(3179, 'Piroska', 71, '2016-10-22', 'mesejáték', NULL),
(3180, 'János király', 129, '2013-11-16', 'keserű komédia', 'magyar'),
(3181, 'Az öreg hölgy látogatása', 170, '2020-10-16', NULL, NULL),
(3182, 'Vuk', 118, '2014-11-15', 'gyermek musical', 'magyar'),
(3183, 'A trubadúr', 22, '2016-03-18', 'opera', 'olasz'),
(3184, 'Hozott lélek', 181, '2016-09-10', NULL, 'magyar'),
(3185, 'A csomótündér', 88, '2013-01-26', NULL, 'magyar'),
(3186, 'Leszállt az ég dicső királya', 112, '2019-12-15', 'bábjáték', NULL),
(3187, 'Három magas nő', NULL, '2021-10-22', NULL, NULL),
(3188, 'Don Giovanni', 32, '2014-01-18', 'opera', NULL),
(3189, 'Na, de államtitkár úr!', 56, '2020-10-10', 'vígjáték', NULL),
(3190, 'Mary és a tenger', 139, '2016-04-16', NULL, NULL),
(3191, 'Nyolckor a bárkán', 36, '2016-12-23', NULL, NULL),
(3192, 'Túl az Óperencián', 134, '2019-03-27', 'táncmesejáték', NULL),
(3193, 'A négy évszak', 134, '2014-04-25', 'táncelőadás', NULL),
(3194, 'Shirley Valentine', 76, '2021-12-10', NULL, NULL),
(3195, 'Játék a kastélyban', 32, '2017-03-31', 'vígjáték', 'magyar'),
(3196, 'Avar', 104, '2014-12-20', 'táncelőadás', 'magyar'),
(3197, 'Toldi', 97, '2018-04-14', NULL, NULL),
(3198, 'Jászol-mese Betlehemben', 32, '2014-12-04', 'gyermekelőadás', 'magyar'),
(3199, 'Triangulum', 38, '2016-02-21', 'bábelőadás', NULL),
(3200, 'Bizánc', 162, '2018-02-23', 'színmű', NULL),
(3201, 'A nagybőgő', 200, '2015-11-13', NULL, 'magyar'),
(3202, 'A kaktusz virága', 73, '2013-10-05', 'zenés vígjáték', 'magyar'),
(3203, 'Asszony a fronton', 185, '2014-10-04', 'monodráma', 'magyar'),
(3204, 'Kivilágos kivirradtig', 32, '2016-10-14', NULL, 'magyar'),
(3205, 'Kulcskeresők', 130, '2015-02-20', 'tragikomédia', 'magyar'),
(3206, 'GYERMEK (Henrik Ibsen: Nóra)', 166, '2015-03-23', NULL, NULL),
(3207, 'Anna Karenina', 60, '2019-10-25', 'dráma', NULL),
(3208, 'Az isteni Sarah', 68, '2012-03-24', 'színmű', 'magyar'),
(3209, 'Novecento', 44, '2020-08-09', 'monodráma', NULL),
(3210, 'Közhely', 133, '2013-11-29', 'táncelőadás', 'magyar'),
(3211, 'Evita', 12, '2014-04-26', 'rockopera', 'magyar'),
(3212, 'Fizikusok', 73, '2017-11-10', 'komédia', NULL),
(3213, 'Made in Hungaria', 50, '2021-11-13', NULL, NULL),
(3214, 'Meseautó', 129, '2016-11-18', NULL, 'magyar'),
(3215, 'Bölcs Náthán', 181, '2013-11-02', 'színmű', 'magyar'),
(3216, 'Nézőművészeti Kft.: 7 nap', NULL, '2018-10-09', NULL, NULL),
(3217, 'Vesztegzár a Grand Hotelben', 73, '2021-12-17', NULL, NULL),
(3218, 'Történetek a Kutyusról meg a Cicusról', 38, '2018-11-25', 'bábjáték', NULL),
(3219, 'Beatles.hu', 148, '2016-04-23', NULL, 'magyar'),
(3220, 'Rómeó és Júlia', 126, '2020-10-30', NULL, NULL),
(3221, 'GermanLateNight', 22, '2018-05-13', 'opera', NULL),
(3222, 'Second Life, avagy Kétéletem', 68, '2018-04-21', NULL, NULL),
(3223, 'Jancsi és Juliska', 27, '2015-10-11', NULL, NULL),
(3224, 'Soha senkinek', 101, '2016-04-12', NULL, 'magyar'),
(3225, 'Bartók színháza', 140, '2019-10-18', NULL, NULL),
(3226, 'Koldusopera', 30, '2019-12-21', 'zenés előadás', NULL),
(3227, 'Az ígéret földje', 35, '2012-10-19', 'dráma', 'magyar'),
(3228, 'Tüzet viszek', 122, '2016-04-29', 'tragédia', 'magyar'),
(3229, 'Adok-papok', NULL, '2018-07-02', NULL, NULL),
(3230, 'Bábuk', NULL, '2019-06-28', NULL, NULL),
(3231, 'Vágy (Bernarda Alba háza, Coppélia, koncert tangóharmonikára és zenekarra)', 137, '2020-02-28', 'mesebalett', NULL),
(3232, 'Mengele törpéi', NULL, '2018-05-22', NULL, NULL),
(3233, 'Zsuzsi kisasszony', 56, '2018-03-17', 'operett', NULL),
(3234, 'Mosó Masa mosodája', 151, '2015-11-08', 'bábjáték', 'magyar'),
(3235, 'Sirály', 170, '2021-12-17', NULL, NULL),
(3236, 'Az ördögszántotta hegy', 4, '2017-05-19', 'bábelőadás', 'magyar'),
(3237, 'A félelem megeszi a lelket', 54, '2017-10-14', NULL, 'magyar'),
(3238, 'Chicago', 134, '2019-09-27', NULL, NULL),
(3239, 'House of Asterion', 123, '2017-03-22', NULL, 'angol'),
(3240, 'Szöktetés a szerájból', 150, '2019-05-01', 'daljáték', NULL),
(3241, 'Mesebeszéd', 130, '2013-05-03', 'zenés mesejáték', 'magyar'),
(3242, 'Kalauz nélkül', 1, '2015-04-24', 'játék', 'magyar'),
(3243, 'Horizont Táncfesztivál - Sötét frigy (A pekingi kacsa nyomán)', NULL, '2018-04-28', 'táncelőadás', NULL),
(3244, 'Tessék engem megmenteni!', 27, '2016-04-10', NULL, NULL),
(3245, 'Cosi fan tutte', 22, '2014-10-10', 'opera', NULL),
(3246, 'Halhatatlan', 74, '2019-01-13', 'dráma', 'magyar'),
(3247, 'Outlét', 128, '2015-12-21', 'performance', 'magyar'),
(3248, 'A sündisznó', 95, '2018-10-16', 'interaktív mesejáték', NULL),
(3249, 'Amazonok (érzelmes zakatolás)', 134, '2012-02-05', NULL, 'magyar'),
(3250, 'Egy komcsi nyanya vagyok!', 34, '2013-05-17', 'színmű', 'magyar'),
(3251, 'J háborúja', NULL, '2018-11-10', 'monodráma', NULL),
(3252, 'Mátyás és a bolondkirály', 44, '2015-10-24', 'zenés mesejáték', 'magyar'),
(3253, 'Spenót Panna', 44, '2019-10-20', 'mesejáték', NULL),
(3254, 'Nem fizetek!', 9, '2016-08-19', NULL, 'magyar'),
(3255, 'Négy fal között', 133, '2016-09-30', NULL, 'magyar'),
(3256, 'Francia rúdugrás', 76, '2019-11-29', NULL, NULL),
(3257, 'Cyber Cyrano', 95, '2013-09-28', 'színmű', 'magyar'),
(3258, 'Don Carlos', NULL, '2020-02-07', 'opera', NULL),
(3259, 'K.O. [kötelező | olvasmány]', 194, '2015-02-28', 'színjáték', 'magyar'),
(3260, 'János vitéz', 95, '2015-09-24', NULL, 'magyar'),
(3261, 'A chicagói hercegnő', 29, '2016-04-24', 'operett', 'magyar'),
(3262, 'Elsötétítés', 32, '2012-02-22', 'színmű', 'magyar'),
(3263, 'Hair', 195, '2019-09-28', 'musical', NULL),
(3264, 'Zorba', 80, '2012-10-13', 'balett', 'magyar'),
(3265, 'Művház', 124, '2013-10-25', NULL, 'magyar'),
(3266, 'Mekk Elek, az ezermester', 71, '2014-10-11', 'zenés mesejáték', 'magyar'),
(3267, 'Csárdás a zivatarban', 42, '2020-12-17', 'táncelőadás', NULL),
(3268, 'Szülőfalum, Pest', 170, '2022-01-15', 'színházi est', 'magyar'),
(3269, 'Idegen elemek', 31, '2014-08-21', 'színmű', 'magyar'),
(3270, 'Fekete zongora', NULL, '2020-08-21', 'felolvasószínház', NULL),
(3271, 'Jászai', 122, '2012-05-04', 'színmű', 'magyar'),
(3272, 'Miki a Mikulásnál', 194, '2015-12-06', 'gyermekelőadás', 'magyar'),
(3273, '100 év Orfeum', 30, '2014-07-05', 'zenés előadás', 'magyar'),
(3274, 'Momo', 97, '2016-03-26', NULL, 'magyar'),
(3275, 'Neuropean', 197, '2017-12-08', 'táncelőadás', NULL),
(3276, 'Az égigérő paszuly', 151, '2016-02-07', 'színház és tánc', NULL),
(3277, 'Rászorultak', 33, '2015-06-09', 'performance', 'magyar'),
(3278, 'Bánk bán', 23, '2016-10-07', 'opera', 'magyar'),
(3279, 'Bernarda Alba háza - a Stúdió 2.1. Színházban', 69, '2012-10-12', NULL, NULL),
(3280, 'W. úr üzen', 54, '2014-05-29', 'színmű', 'magyar'),
(3281, 'West Side Story', 22, '2015-09-11', 'musical', 'angol'),
(3282, 'Egy fiú Boszniából', 201, '2016-12-21', NULL, 'magyar'),
(3283, 'Magyar Elektra', 1, '2017-04-07', NULL, 'magyar'),
(3284, 'Lyon Lea', 155, '2013-12-18', 'színmű', 'magyar'),
(3285, 'Moszkva-Petuski', 152, '2016-11-26', NULL, 'magyar'),
(3286, 'Játék az életrajzzal', 30, '2013-10-19', 'színmű', 'magyar'),
(3287, 'Tavaszi áldozat / Tűzmadár', 82, '2014-06-27', 'balett', NULL),
(3288, 'Ripacsok', 64, '2013-03-25', NULL, 'magyar'),
(3289, 'Aurora', 61, '2018-07-27', 'táncelőadás', NULL),
(3290, 'Holle anyó', 151, '2014-11-16', 'bábjáték', NULL),
(3291, 'Rómeó és Júlia', 83, '2020-09-18', 'tragédia', NULL),
(3292, 'Napraforgó', 200, '2016-02-11', NULL, 'magyar'),
(3293, 'A király beszéde', 44, '2017-01-27', 'dráma', 'magyar'),
(3294, 'Tündérkeresztanya', 112, '2016-11-06', 'mesejáték', NULL),
(3295, 'Az öldöklés istene', 148, '2021-10-02', NULL, NULL),
(3296, 'A Kígyóasszony', 140, '2012-10-20', 'színmű', 'magyar'),
(3297, 'BALETT+ Airtist', 3, '2016-12-21', 'táncjáték', 'magyar'),
(3298, 'Zűrbolygó', 151, '2016-05-15', 'interaktív bábjáték', NULL),
(3299, 'ELMARAD! - A vörös postakocsi', 50, '2020-03-13', 'színjáték', NULL),
(3300, 'Judit', 130, '2017-12-14', NULL, NULL),
(3301, 'Metamorfózis', 25, '2020-11-03', 'táncelőadás', NULL),
(3302, 'Beszélő fejek', 35, '2021-10-24', NULL, NULL),
(3303, 'Énekes madár', 30, '2012-04-06', 'játék', 'magyar'),
(3304, 'Titanic', NULL, '2019-12-13', 'musical', NULL),
(3305, 'Rövidhullám', 8, '2012-04-29', NULL, 'magyar'),
(3306, 'A padlás', 32, '2013-02-02', 'mesemusical', 'magyar'),
(3307, 'Az idegen', 140, '2019-04-04', 'monodráma', NULL),
(3308, 'ZS-kategória (önfeledt zsidózás revüvel)', 155, '2015-04-12', NULL, 'magyar'),
(3309, 'A bűvös vadász', 22, '2014-12-14', 'opera', 'német'),
(3310, 'A rendes lányok csendben sírnak', 170, '2021-10-08', NULL, NULL),
(3311, 'Toldi', 140, '2012-10-25', NULL, 'magyar'),
(3312, 'Képzelt riport egy amerikai popfesztiválról', 182, '2019-12-26', 'zenés játék', NULL),
(3313, 'Emil és a detektívek', 185, '2013-09-25', 'zenés előadás', 'magyar'),
(3314, 'A négylábú kastély meséi', 151, '2020-02-09', NULL, NULL),
(3315, 'Top Dogs', 9, '2012-05-11', NULL, 'magyar'),
(3316, 'Babaváró', NULL, '2020-10-08', 'musical', NULL),
(3317, 'A dzsungel könyve', 73, '2018-11-30', 'musical', NULL),
(3318, 'Cabaret', 56, '2018-10-06', NULL, NULL),
(3319, 'Medve - Leánykérés - Jubileum', 140, '2012-11-30', 'színmű', 'magyar'),
(3320, 'Isten madárkái', 140, '2012-04-03', NULL, 'magyar'),
(3321, 'Kean, a színész', 185, '2014-11-28', 'komédia', 'magyar'),
(3322, 'Szent Johanna', 109, '2013-03-01', 'szatirikus tragédia', 'magyar'),
(3323, 'Füstös', 140, '2019-05-06', NULL, NULL),
(3324, 'Traviata', 148, '2017-02-04', 'opera', 'magyar'),
(3325, 'Akit Biffnek hívtak', 140, '2018-03-18', NULL, NULL),
(3326, 'Elhalasztott holnap', 123, '2013-10-03', 'zenés előadás', 'magyar'),
(3327, 'Oszlopos Simeon', 21, '2015-10-16', 'színmű', 'magyar'),
(3328, 'B monitor (ősbemutató)', 140, '2019-03-05', NULL, NULL),
(3329, 'A rajongók', 95, '2016-04-23', 'színmű', 'magyar'),
(3330, 'Bogyó és Babóca', 181, '2018-05-04', 'mesejáték', NULL),
(3331, 'Bohémélet', 125, '2020-11-06', 'táncelőadás', NULL),
(3332, 'A vágy villamosa', 94, '2014-11-17', 'színházi közvetítés', 'angol'),
(3333, 'Rosmersholm', 105, '2013-01-10', 'színmű', 'magyar'),
(3334, 'A szecsuáni jó ember', 20, '2021-11-26', NULL, NULL),
(3335, 'A padlás', 148, '2017-09-30', 'musical', 'magyar'),
(3336, 'Gyöngyhalászok', 107, '2014-04-07', 'táncelőadás', 'magyar'),
(3337, 'Ízek, táncok, érzések', 193, '2019-11-15', 'táncelőadás', NULL),
(3338, 'Holt lelkek', 34, '2018-01-04', NULL, 'magyar'),
(3339, 'Visszatérő', 40, '2017-10-24', NULL, 'magyar'),
(3340, 'A tündérlaki lányok', 44, '2013-02-01', 'vígjáték', 'magyar'),
(3341, 'Kései találkozás', 79, '2019-06-04', 'romantikus vígjáték ', NULL),
(3342, 'Csíksomlyói passió', 99, '2015-03-06', 'passiójáték', 'magyar'),
(3343, '1001', 194, '2013-09-19', 'színjáték', 'magyar'),
(3344, 'János vitéz', 109, '2020-01-24', 'daljáték', NULL),
(3345, 'Mit keresett Jakab az ágy alatt?', 43, '2018-04-04', 'interaktív bábjáték', NULL),
(3346, 'A kőszívű ember fiai', 162, '2016-10-14', 'történelmi szinmű', 'magyar'),
(3347, 'Különös', 175, '2020-10-30', NULL, NULL),
(3348, 'Klamm háborúja', 134, '2018-01-12', NULL, NULL),
(3349, 'Marica grófnő', 44, '2012-02-10', 'nagyoperett', 'magyar'),
(3350, 'NégyN', NULL, '2019-12-13', NULL, NULL),
(3351, 'Gréta', 151, '2021-04-16', 'bábelőadás', NULL),
(3352, 'Ádám almái', 32, '2019-12-06', 'komédia', NULL),
(3353, 'OMG', NULL, '2019-03-22', 'balett', NULL),
(3354, 'Vízkereszt', 134, '2016-09-30', 'vígjáték', 'magyar'),
(3355, 'Az arany meg az asszony / Tóték', NULL, '2019-04-26', 'opera', NULL),
(3356, 'Tündér Míra', 109, '2017-02-09', 'mesejáték', 'magyar'),
(3357, 'Király Kis Miklós', 112, '2017-05-21', 'mesejáték', 'magyar'),
(3358, 'Terror', 99, '2021-06-12', NULL, NULL),
(3359, 'Kövérkirály', 8, '2013-03-28', 'játék', 'magyar'),
(3360, 'Plateau', NULL, '2020-01-25', 'táncelőadás', NULL),
(3361, 'Az úrhatnám szolgáló', 22, '2016-04-02', 'opera', 'magyar'),
(3362, 'Yvonne, burgundi hercegnő', 140, '2020-03-08', NULL, NULL),
(3363, 'Emigránsok', 169, '2013-05-13', 'tragikomédia', 'magyar'),
(3364, 'Babszem Jankó', 27, '2012-01-10', 'játék', 'magyar'),
(3365, 'Woyzeck', NULL, '2018-09-22', NULL, NULL),
(3366, 'Battery Dance Company (New York)', 54, '2013-03-26', 'táncelőadás', NULL),
(3367, 'fosztóKÉPZŐ', 96, '2018-06-02', NULL, NULL),
(3368, 'Kicsi', NULL, '2020-03-29', NULL, NULL),
(3369, 'Szöveg és zene', 26, '2014-05-08', 'színmű', 'magyar'),
(3370, 'Semmi pánik', 148, '2016-10-01', 'bohózat', 'magyar'),
(3371, 'Fanny és Alexander', 105, '2012-03-30', NULL, NULL),
(3372, 'Cseresznyéskert', 73, '2014-10-14', 'színmű', 'magyar'),
(3373, 'Pumukli', 109, '2015-02-03', 'gyermekelőadás', 'magyar'),
(3374, 'Határaink', 144, '2015-10-09', NULL, 'magyar'),
(3375, 'Memo- A felejtés nélküli ember', 134, '2020-10-10', 'felolvasószínház', NULL),
(3376, 'vér_nász', 123, '2016-03-25', 'táncelőadás', 'magyar'),
(3377, 'Etűdök', 86, '2014-03-22', 'balett', NULL),
(3378, 'Farkas vs. Piroska', 129, '2019-10-11', 'mesejáték', NULL),
(3379, 'A falak titkos élete', 124, '2017-10-21', NULL, 'magyar'),
(3380, 'Európa, édes hazám', 95, '2017-04-08', NULL, 'magyar'),
(3381, 'Ofélia árnyszínháza', 190, '2016-11-13', 'mesejáték', NULL),
(3382, 'Kulcskeresők', 73, '2021-09-17', 'tragikomédia', NULL),
(3383, 'A szelíd teremtés', 9, '2014-09-26', 'színmű', 'magyar'),
(3384, 'A varázsfuvola', 32, '2018-01-19', 'opera', NULL),
(3385, 'Bonnie és Clyde', NULL, '2019-06-29', 'musical', NULL),
(3386, 'Piszkavas (Leenane szépe)', 202, '2015-04-13', 'vígjáték', 'magyar'),
(3387, 'Három nővér', 122, '2018-02-23', NULL, NULL),
(3388, 'Tartuffe', 6, '2014-02-13', 'vígjáték', 'magyar'),
(3389, 'Peti a képtárban', 131, '2013-03-14', 'bábjáték', 'magyar'),
(3390, 'Tied a világ!', 134, '2015-09-21', 'zenés előadás', 'magyar'),
(3391, 'A Pincérfrakk utcai cicák', 143, '2013-11-12', 'színmű', 'magyar'),
(3392, 'Holle anyó', 113, '2019-01-13', 'mesejáték', 'magyar'),
(3393, 'Templom', 14, '2017-10-01', NULL, 'magyar'),
(3394, 'Szerelem, ó!', 143, '2021-01-16', 'zenés bohózat', NULL),
(3395, 'taking place', 8, '2016-05-18', 'táncelőadás', 'magyar'),
(3396, 'Pöttöm Panna', 109, '2017-10-04', 'mesejáték', 'magyar'),
(3397, 'Hamupipőke', 137, '2019-11-15', 'mesebalett', NULL),
(3398, 'Bambi', 43, '2018-01-18', 'mesejáték', NULL),
(3399, 'Nero, a véres költő', 83, '2013-05-16', 'játék', 'magyar'),
(3400, 'IZP-estek: Juhász Adél: László Károlyné / Krizsán Dániel: Diplopia', NULL, '2021-12-14', 'táncelőadás', NULL),
(3401, 'A kiskakas gyémánt félkrajcárja', 151, '2019-03-10', 'bábjáték', NULL),
(3402, 'A padlás', 23, '2021-09-24', 'mesemusical', NULL),
(3403, 'A walkür', 22, '2016-03-06', 'zenedráma', 'német'),
(3404, 'IV. Henrik', 126, '2021-11-26', 'színmű', NULL),
(3405, 'Szócső', 138, '2020-11-05', NULL, NULL),
(3406, 'Tancika Marcika', 13, '2015-09-27', NULL, NULL),
(3407, 'Irány Hawaii!', 62, '2017-03-17', NULL, 'magyar'),
(3408, 'Cinema Szinetár', 150, '2019-05-05', NULL, NULL),
(3409, 'Haptic & 2. repulsion', 173, '2012-11-30', 'táncelőadás', 'magyar'),
(3410, 'Donizetti: Rita', NULL, '2018-07-13', NULL, NULL),
(3411, 'OFFlány', 130, '2016-01-04', 'felolvasószínház', 'magyar'),
(3412, 'Erdély - Tündérkert', 32, '2015-02-20', 'történelmi szinmű', 'magyar'),
(3413, 'Iván, a rettenet', 190, '2016-10-16', 'színmű', 'magyar'),
(3414, 'Exit Wounds', 2, '2019-10-19', 'monodráma', NULL),
(3415, 'Szarvasok szövetsége', 151, '2013-11-12', NULL, 'magyar'),
(3416, 'Énekes madár', 143, '2012-02-18', NULL, 'magyar'),
(3417, 'A félőlény', 121, '2019-12-14', 'zenés mesejáték', NULL),
(3418, 'DIJORI / Mama', NULL, '2021-11-26', NULL, NULL),
(3419, '#kaméleon', NULL, '2021-10-28', 'táncelőadás', NULL),
(3420, 'Szentivánéji álom', 23, '2018-10-05', 'vígjáték', NULL),
(3421, 'Az ügynök halála', 20, '2016-06-03', 'színmű', 'magyar'),
(3422, 'Az átnevelhetetlen', 34, '2020-02-22', NULL, NULL),
(3423, 'Tóték', 185, '2020-01-31', 'tragikomédia', NULL),
(3424, 'Semmelweis', NULL, '2018-09-28', NULL, NULL),
(3425, 'Boldog Óra', 18, '2014-03-21', 'színmű', 'magyar'),
(3426, 'Boldogság, avagy élet 50 felett', 182, '2021-11-21', NULL, NULL),
(3427, 'Hajnalban, délben, este', 50, '2021-02-12', NULL, NULL),
(3428, 'Hangemberek', 162, '2015-03-27', 'vígjáték', 'magyar'),
(3429, 'Hamlet', 26, '2015-04-20', 'tragédia', 'magyar'),
(3430, 'Hazudj inkább, kedvesem!', 30, '2016-09-17', NULL, 'magyar'),
(3431, 'Az emberi hang - Facebooking', 32, '2015-06-21', 'opera', NULL),
(3432, 'Lautrec táncolni fog', 158, '2016-09-23', 'táncelőadás', 'magyar'),
(3433, 'A mi utcánk', 99, '2021-11-06', 'monodráma', NULL),
(3434, 'Present-Project', 191, '2014-06-02', 'táncelőadás', 'magyar'),
(3435, 'Karinthy, a Frici', 64, '2012-09-05', 'színmű', 'magyar'),
(3436, 'It\'s going to get worse and worse and worse, my friend', 8, '2012-09-06', 'táncelőadás', NULL),
(3437, 'Isten háta mögött', 79, '2015-04-16', 'színmű', 'magyar'),
(3438, 'Apróbetűs részek - Kovács András Péter önálló estje', NULL, '2020-01-24', 'stand-up comedy', NULL),
(3439, 'Alice Csodaországban', 148, '2016-03-19', 'zenés mesejáték', 'magyar'),
(3440, 'MU Terminál C-Est, 2013 - Rush / Hullám', 8, '2013-05-24', 'táncelőadás', 'magyar'),
(3441, 'Radnóti: Úgy éltem életem', 76, '2014-12-02', NULL, 'magyar'),
(3442, 'A kiskakas gyémánt félkrajcárja', 131, '2015-04-10', NULL, NULL),
(3443, 'Csörte', 50, '2012-01-06', NULL, 'magyar'),
(3444, 'Amália', 140, '2017-03-05', NULL, 'magyar'),
(3445, 'Hosszú út az éjszakába', 9, '2015-01-30', 'dráma', 'magyar'),
(3446, 'Miért pont Ázsia? - Badár Sándor önálló estje', 71, '2021-11-25', 'stand-up comedy', NULL),
(3447, 'Máté-passió', 22, '2013-03-28', 'opera', NULL),
(3448, 'Gulag - Piros ló - Nowadays', 140, '2019-01-29', NULL, NULL),
(3449, 'L\'élek', 118, '2013-03-02', 'zenés est', 'magyar'),
(3450, 'Tricks&Tracks 2.', 19, '2014-03-20', 'táncelőadás', 'magyar'),
(3451, 'A fiú, akit Karácsonynak hívnak', 131, '2017-11-21', 'bábjáték', 'magyar'),
(3452, 'Mikulás a világ körül', 112, '2012-12-02', NULL, 'magyar'),
(3453, 'Bankhitel', 114, '2017-12-15', 'vígjáték', 'magyar'),
(3454, 'Egy főn délutánja (L\'Apres-midi d\'un Foehn)', 173, '2014-06-05', 'újcirkusz', NULL),
(3455, 'III. Richárd', 92, '2016-07-13', 'dráma', NULL),
(3456, 'Érinthetetlenek', 82, '2012-06-28', 'musical', 'magyar'),
(3457, 'Acélmagnóliák', 76, '2013-03-23', 'színmű', 'magyar'),
(3458, 'Életvárók', 34, '2014-05-31', NULL, 'magyar'),
(3459, 'Opus 96', 135, '2017-10-07', NULL, 'magyar'),
(3460, 'A padlás', 99, '2013-01-18', 'musical', 'magyar'),
(3461, 'Közellenség', NULL, '2020-11-09', NULL, NULL),
(3462, 'Tél', 181, '2014-04-23', NULL, 'magyar'),
(3463, 'A windsori víg nők', 22, '2016-05-24', 'daljáték', 'magyar'),
(3464, 'Édesanyám sok szép szava...', 123, '2016-03-16', 'táncelőadás', 'magyar'),
(3465, 'Don Juan', 60, '2016-11-04', NULL, 'magyar'),
(3466, 'Bolha a fülbe', 99, '2014-01-31', 'vígjáték', 'magyar'),
(3467, 'Don Quijote', 157, '2015-09-18', 'színmű', 'magyar'),
(3468, 'Úton', 140, '2016-11-16', NULL, 'magyar'),
(3469, 'Nyakigláb, Csupaháj, Málészáj', 102, '2015-10-10', 'mesejáték', 'magyar'),
(3470, 'Szent Péter esernyője', 50, '2013-02-15', 'színmű', 'magyar'),
(3471, 'Dzsinn – És te mire vágysz?', 90, '2019-11-10', 'improvizáció', NULL),
(3472, 'Lola Budapesten', 64, '2016-09-10', 'zenés előadás', 'magyar'),
(3473, 'Mézeshetek', 56, '2014-03-22', 'zenés vígjáték', 'magyar'),
(3474, 'Két nő (És Valaki)', 114, '2017-03-27', 'felolvasószínház', 'magyar'),
(3475, 'Gyöngyhajú Lány Balladája', 103, '2016-03-12', 'táncelőadás', 'magyar'),
(3476, 'Horizont Táncfesztivál - Ali & Alpo', NULL, '2019-04-25', 'táncelőadás', NULL),
(3477, 'Dzsamilé', 22, '2015-02-20', 'opera', NULL),
(3478, 'Made in Hungária', 185, '2013-02-08', 'musical', 'magyar'),
(3479, 'A hölgy fecseg és nyomoz', 114, '2013-03-07', 'bűnügyi bohózat', 'magyar'),
(3480, 'A hahagáj', 184, '2016-02-05', NULL, 'magyar'),
(3481, 'Az eredeti Hamlet', 46, '2012-03-06', NULL, NULL),
(3482, 'Amerikai bölény', 152, '2016-03-05', NULL, 'magyar'),
(3483, 'Atelier 21220: Late night show', NULL, '2018-04-06', NULL, NULL),
(3484, 'Woyzeck', 8, '2018-10-19', NULL, NULL),
(3485, 'A tanú', 152, '2012-12-06', 'színmű', 'magyar'),
(3486, 'III. Richárd', 201, '2014-07-26', 'színmű', 'magyar'),
(3487, 'Diggerdrájver', 20, '2015-05-09', 'színmű', 'magyar'),
(3488, '9-től 5-ig - A musical', 102, '2020-09-19', 'musical', NULL),
(3489, 'Elfogyni az ölelésben - Ady Endre szerelmei', 118, '2022-01-21', 'színjáték', NULL),
(3490, 'Liszt Ferenc: Magyar rapszódia', 198, '2019-03-19', 'táncelőadás', NULL),
(3491, 'Szentivánéji álom', 170, '2017-02-25', 'vígjáték', 'magyar'),
(3492, 'Kolpert úr', 23, '2012-10-26', 'színmű', 'magyar'),
(3493, 'United Space of Ambivalence', NULL, '2018-02-09', 'táncelőadás', NULL),
(3494, 'A főnök meg én meg a főnök', 195, '2020-11-28', 'komédia', NULL),
(3495, 'Császárok napja: Heliogabalus - A napkirály', 9, '2013-12-19', 'színmű', 'magyar'),
(3496, 'Marsall', 73, '2017-11-11', NULL, NULL),
(3497, 'Képzelt riport egy amerikai popfesztiválról', NULL, '2018-04-13', NULL, NULL),
(3498, 'A Négyszögletű Kerek Erdő', 76, '2013-05-09', 'mesemusical', 'magyar'),
(3499, 'A falu rossza', 176, '2018-05-13', NULL, NULL),
(3500, 'Figaro házassága', 30, '2015-05-23', 'zenés előadás', 'magyar'),
(3501, 'Csónak', 152, '2012-01-13', NULL, 'magyar'),
(3502, 'Örömállam', 186, '2012-03-22', NULL, NULL),
(3503, 'Kohlhaas', 14, '2015-09-11', 'színmű', 'magyar'),
(3504, 'Fej nélküli holttest', 6, '2016-05-13', 'színmű', 'magyar'),
(3505, 'Hedda Gabler szkeccsek', 140, '2020-03-09', NULL, NULL),
(3506, 'Szeretetkönyv', 44, '2012-12-17', NULL, 'magyar'),
(3507, 'A Carmen Cortés en Compania előadása', 152, '2013-03-22', 'táncelőadás', NULL),
(3508, 'Rigoletto', 148, '2014-01-25', 'opera', NULL),
(3509, 'Liliom', 134, '2014-09-26', NULL, 'magyar'),
(3510, 'Ármány és szerelem', 12, '2018-02-24', 'rock-musical', NULL),
(3511, 'A nyomorultak', 32, '2012-03-02', NULL, 'magyar'),
(3512, 'Margit, a hazának szentelt áldozat', NULL, '2021-09-08', 'opera', NULL),
(3513, 'Akárki hivatása', 200, '2012-03-13', NULL, 'magyar'),
(3514, 'MU Terminál A est, 2013: Fejes Ádám: Femina / Jack Gallagher: Divided we stand', 8, '2013-11-29', 'táncelőadás', 'magyar'),
(3515, 'Oscar', 185, '2019-10-25', 'vígjáték', NULL),
(3516, 'Ludas Matyi', 126, '2017-01-12', 'mesejáték', 'magyar'),
(3517, 'Detektívjátszma', 50, '2018-10-12', 'krimi', NULL),
(3518, 'Hófehérke meg a törpék', 76, '2012-12-19', 'meseoperett', 'magyar'),
(3519, 'Verona, 1301', 122, '2015-10-09', NULL, 'magyar'),
(3520, 'Szelep', 64, '2013-03-23', 'kabaré', 'magyar'),
(3521, 'Síppal-dobbal', 112, '2017-09-30', 'csecsemő színház', 'magyar'),
(3522, 'Dinasztiák', 156, '2021-02-13', 'cirkuszi előadás', NULL),
(3523, 'A négyszögletű kerek erdő', 30, '2019-02-02', 'mesejáték', NULL),
(3524, 'Meseautó', 134, '2013-02-12', 'zenés játék', 'magyar'),
(3525, 'Callgirl', 194, '2015-11-06', NULL, 'magyar'),
(3526, 'Örvény', 79, '2015-03-25', 'színmű', 'magyar'),
(3527, 'Mata Hari', 64, '2018-03-21', 'zenés előadás', NULL),
(3528, 'A dzsungel könyve', 8, '2016-02-27', 'táncelőadás', 'magyar'),
(3529, 'Sleeping Beauty Projekt', 91, '2017-03-10', 'táncelőadás', 'magyar'),
(3530, 'Közellenség', 185, '2015-03-06', NULL, 'magyar'),
(3531, 'Farsangi kalamajka avagy A torkos csütörtök', 23, '2014-12-05', 'opera', 'olasz'),
(3532, 'Being Connected', 123, '2012-02-26', 'táncelőadás', 'magyar'),
(3533, 'Nyolc nő', 73, '2019-01-18', NULL, NULL),
(3534, 'Mikve', 76, '2015-04-11', 'színmű', 'magyar'),
(3535, 'Borsszem Jankó', 141, '2012-04-30', 'mesejáték', NULL),
(3536, 'K-Arcok: Lépcső - Uraim', 78, '2016-02-18', 'táncelőadás', 'magyar'),
(3537, 'Rendőrség', 141, '2012-10-07', NULL, NULL),
(3538, 'Tűzoltó', 73, '2012-11-03', 'vígjáték', NULL),
(3539, 'Csizmás Kandúr', 131, '2012-02-12', NULL, 'magyar'),
(3540, 'Kutyaévek', 144, '2020-12-18', NULL, NULL),
(3541, 'Casablanca', 199, '2017-10-20', 'táncelőadás', NULL),
(3542, 'Merlin, avagy Isten, Haza, Család', 20, '2012-10-19', NULL, 'magyar'),
(3543, 'Liliomfi', 195, '2021-09-18', 'zenés vígjáték', NULL),
(3544, 'Maria Callas mesterkurzusa', NULL, '2018-11-21', NULL, NULL),
(3545, 'Color House', 194, '2013-07-27', 'színjáték', 'magyar'),
(3546, 'Két ember balladája', NULL, '2017-09-10', NULL, NULL),
(3547, 'A gyertyák csonkig égnek', 102, '2018-10-12', 'színjáték', NULL),
(3548, 'Gluck: Don Juan - Vivaldi: A négy évszak', 137, '2017-05-09', 'táncelőadás', NULL),
(3549, 'Farkashas', 38, '2015-10-04', NULL, NULL),
(3550, 'Tündér a padláson', 143, '2012-11-21', 'mesejáték', 'magyar'),
(3551, 'Egérfogó', 30, '2015-03-28', 'színmű', 'magyar'),
(3552, 'Magyar zombi', 70, '2013-04-12', 'komédia', 'magyar'),
(3553, 'Othello', 102, '2015-10-03', 'dráma', 'magyar'),
(3554, 'Felmászott a nyúl a fára', 123, '2013-11-10', 'gyermekelőadás', 'magyar'),
(3555, '4x100', 148, '2016-02-13', 'tragikomédia', 'magyar'),
(3556, 'Woyzeck', 140, '2017-05-14', NULL, 'magyar'),
(3557, 'Vadászat', 173, '2018-03-28', 'táncelőadás', NULL),
(3558, 'Gulliver utazásai', 83, '2020-01-10', 'zenés játék', NULL),
(3559, 'Acis és Galatea (ifjúsági változat)', 122, '2018-11-05', 'opera', NULL),
(3560, 'Én, Leonardo - A fény születése', 103, '2015-04-17', 'táncelőadás', 'magyar'),
(3561, '80 nap alatt a Föld körül', 148, '2014-12-13', 'színpadi játék', 'magyar'),
(3562, 'Illaberek', 34, '2013-11-29', 'színmű', 'magyar'),
(3563, 'La Mancha lovagja', 102, '2016-10-01', 'musical', 'magyar'),
(3564, 'Szegény Dely Mári', 74, '2020-03-19', 'ballada', NULL),
(3565, 'Figaro házassága avagy egy őrült nap emléke', 157, '2017-11-10', NULL, 'magyar'),
(3566, 'A Grönholm-módszer', 99, '2016-02-12', 'színpadi játék', 'magyar'),
(3567, 'Pán Péter-hová lett Sohaország?', 199, '2014-10-30', 'táncmesejáték', 'magyar'),
(3568, 'Csipkerózsika', 47, '2012-09-08', 'bábjáték', NULL),
(3569, 'Akár akárki', 122, '2015-01-16', NULL, 'magyar'),
(3570, 'Augusztus Oklahomában', 181, '2015-02-20', 'keserű komédia', 'magyar'),
(3571, 'Az ember tr.', 4, '2014-05-30', 'színmű', 'magyar'),
(3572, 'Josephine császárné', 150, '2021-06-16', 'opera', NULL),
(3573, 'Könnyűbulvár', 71, '2018-01-24', 'stand-up comedy', NULL),
(3574, 'Punch és Judy', 150, '2014-10-14', 'opera', NULL),
(3575, 'A gondnok', 44, '2018-10-20', 'abszurd dráma', NULL),
(3576, 'Virágbolt - Bristol Xpress', 169, '2014-11-12', 'színmű', 'magyar'),
(3577, 'Holdbeli csónakos', 43, '2019-10-08', 'bábjáték', NULL),
(3578, 'Párnakönyv', 79, '2013-02-12', 'színmű', 'magyar'),
(3579, 'Second', 123, '2017-02-24', 'táncelőadás', NULL),
(3580, 'Székely János: Caligula helytartója', NULL, '2018-05-23', 'dráma', NULL),
(3581, 'Egy bolond négyet csinál', 5, '2014-05-22', 'kabaré', 'magyar'),
(3582, 'Médeia', 9, '2018-09-28', 'tragédia', NULL),
(3583, 'A munka gyümölcse', 137, '2016-05-11', 'táncelőadás', 'magyar'),
(3584, 'Fénygolyók', 63, '2015-03-27', NULL, 'magyar'),
(3585, 'Effi Briest', 200, '2012-11-16', 'felolvasószínház', 'magyar'),
(3586, 'Hát, ha van is, én még nem találtam meg', 34, '2020-10-10', NULL, NULL),
(3587, 'My little Gólem', 155, '2013-12-12', 'színmű', 'magyar'),
(3588, 'Klassz óra', 145, '2016-07-17', NULL, 'magyar'),
(3589, 'Légy jó mindhalálig', 122, '2013-12-13', 'musical', 'magyar'),
(3590, 'Momentán Plusz - Halloween különkiadás', 90, '2012-11-01', 'interaktív játék', 'magyar'),
(3591, 'A Grönholm-módszer', 9, '2016-10-11', NULL, 'magyar'),
(3592, 'Médeia', 157, '2019-09-20', NULL, NULL),
(3593, 'Taurin-Trauma', 129, '2015-12-12', NULL, 'magyar'),
(3594, 'Dolgok, amikért érdemes élni', 35, '2017-10-06', NULL, 'magyar'),
(3595, 'Ajtók kilincs nélkül', 125, '2017-04-24', 'táncelőadás', NULL),
(3596, 'Hatalmas Aphrodité', 118, '2018-02-16', 'musical', NULL),
(3597, 'Don Carlos', 128, '2012-05-20', 'dráma', 'magyar'),
(3598, 'Hinoki', 173, '2014-10-24', 'táncelőadás', NULL),
(3599, 'Gina és Fidel', NULL, '2018-09-21', 'dráma', NULL),
(3600, 'Egy szerelem három éjszakája', 106, '2020-10-30', 'musical', NULL),
(3601, 'Istvánka', 119, '2016-05-27', 'dráma', 'magyar'),
(3602, 'Said', 57, '2015-03-24', NULL, 'magyar'),
(3603, 'A Napsugár fiúk', 129, '2021-06-11', 'vígjáték', NULL),
(3604, 'Versengő Zenebónia', 95, '2015-01-18', 'mesejáték', 'magyar'),
(3605, 'Arthur the King Part Two - The Round Table', 54, '2013-02-08', 'színmű', 'angol'),
(3606, 'Lear király', 182, '2020-10-28', 'szatíra', NULL),
(3607, 'Indul a bakterház', 95, '2013-09-21', 'komédia', 'magyar'),
(3608, 'Sandy is going out', NULL, '2018-02-09', 'táncelőadás', NULL),
(3609, 'exPre', 188, '2019-01-18', NULL, NULL),
(3610, 'A Kék Angyal', 20, '2013-05-11', 'zenés színmű', 'magyar'),
(3611, 'Valahol Európában', 83, '2016-12-02', 'musical', NULL),
(3612, 'Repül az alma', 160, '2018-04-07', NULL, NULL),
(3613, 'Veselosti minulosty (Régmúlt idők örömei)', 169, '2014-03-27', 'kortárstánc', NULL),
(3614, 'Európa, Európa!', 144, '2012-10-26', 'dráma', 'magyar'),
(3615, 'Egy élet háromszor', 16, '2016-04-23', NULL, 'magyar'),
(3616, 'Heilbronni Katica', 144, '2021-10-20', NULL, NULL),
(3617, 'Jóccakát, anya', 73, '2017-09-23', NULL, 'magyar'),
(3618, 'Ének az esőben', 29, '2016-08-12', 'musical', 'magyar'),
(3619, 'Nem válok el!', 149, '2015-04-23', 'vígjáték', 'magyar'),
(3620, 'Hercegek - katonák', 129, '2012-10-20', 'mesejáték', 'magyar'),
(3621, 'Just Dance and Nothing Else', 104, '2019-12-18', 'táncelőadás', NULL),
(3622, 'Kakukkfészek', 50, '2021-09-10', NULL, NULL),
(3623, 'Sirály', 140, '2019-02-08', NULL, NULL),
(3624, 'Footloose', 185, '2012-02-24', NULL, 'magyar'),
(3625, 'A szerelmesek házai', 190, '2020-02-23', NULL, NULL),
(3626, 'Traviata', 125, '2016-03-03', 'táncelőadás', 'magyar'),
(3627, 'A Herner Ferike faterja', 95, '2016-09-29', 'komédia', 'magyar'),
(3628, 'Terike és Irén', 16, '2018-04-21', 'felolvasószínház', 'magyar'),
(3629, 'We live happily', 55, '2016-02-13', 'táncelőadás', 'magyar'),
(3630, 'Valami titkos dolog', 151, '2019-09-27', 'bábjáték', NULL),
(3631, 'Szemenszedett mese', 131, '2016-09-24', 'bábjáték', NULL),
(3632, 'Parasztopera', 32, '2014-12-06', NULL, 'magyar'),
(3633, 'Vitéz László - Az elásott kincs', 38, '2013-09-22', 'gyermekelőadás', 'magyar'),
(3634, 'Előttem az élet', 202, '2017-04-20', NULL, 'magyar'),
(3635, 'ELMARAD! - A nagy Romulus', NULL, '2020-03-29', NULL, NULL),
(3636, 'Az idő végezete', 188, '2020-01-23', 'táncelőadás', NULL),
(3637, 'Haszene, egy kis zsidó esküvő', 64, '2015-09-20', 'zenés játék', 'magyar'),
(3638, 'Három koporsó', 99, '2014-02-21', 'abszurd játék', 'magyar'),
(3639, 'Folklór-kalendárium -Téli tánc', 154, '2013-02-15', NULL, 'magyar'),
(3640, 'Parallel', 124, '2014-12-04', 'színmű', 'angol'),
(3641, 'Hoztam valamit a hegyekből', 157, '2015-10-10', NULL, 'magyar'),
(3642, 'Kukucs', 116, '2019-04-14', 'zenés bábjáték', NULL),
(3643, 'Timothy and the Things: Szabadulóművészek', NULL, '2020-11-29', 'táncelőadás', NULL),
(3644, 'Köd utánam', 20, '2015-10-09', 'operett', 'magyar'),
(3645, 'Csipike, az óriás törpe', 131, '2013-01-25', 'mesejáték', 'magyar'),
(3646, 'IKF (Ifjú Koreográfusok Fóruma) - A8ak', 78, '2015-06-06', 'táncelőadás', 'magyar'),
(3647, 'Parasztopera', 69, '2012-01-21', NULL, NULL),
(3648, '(Szép) új világ', 172, '2012-04-15', NULL, NULL),
(3649, 'Nanga és az elefántgyerekek', 131, '2015-12-11', NULL, NULL),
(3650, 'A kis herceg', 130, '2021-09-04', 'gyerekműsor', NULL),
(3651, 'Csókos asszony', 134, '2014-11-14', 'operett', 'magyar'),
(3652, 'Starfactory', 152, '2013-06-01', 'zenés előadás', 'magyar'),
(3653, 'Jövedelmező állás', 181, '2014-04-11', 'komédia', 'magyar'),
(3654, 'Sötétben nem látok aludni', 116, '2016-08-28', NULL, NULL),
(3655, 'Hol utca hány - mindennapi musical', 140, '2016-03-08', NULL, 'magyar'),
(3656, 'Egy csók és más semmi', 152, '2019-10-12', 'zenés vígjáték', NULL),
(3657, 'Lovagias ügy', 17, '2017-07-28', 'zenés vígjáték', 'magyar'),
(3658, 'Reflex', 15, '2013-10-28', NULL, 'magyar'),
(3659, 'Árnyék', NULL, '2020-09-08', NULL, NULL),
(3660, 'Horizont Táncfesztivál - Dr. Maybe Darling', NULL, '2019-04-24', 'táncelőadás', NULL),
(3661, 'A fából faragott királyfi', 137, '2012-03-25', 'balett', 'magyar'),
(3662, 'Isten kontra Alexander', 36, '2014-04-06', 'színmű', 'magyar'),
(3663, 'Antigoné', 122, '2014-03-14', NULL, 'magyar'),
(3664, 'A házasságszerző', 30, '2018-03-24', NULL, NULL),
(3665, 'Trilógia maraton 2/3', 158, '2012-03-18', 'performance', 'magyar'),
(3666, 'A talizmán', 134, '2015-04-10', 'komédia', 'magyar'),
(3667, 'Sok hűhó semmiért', 26, '2019-05-25', NULL, NULL),
(3668, 'Hat Tánc', 25, '2017-09-28', 'táncelőadás', NULL),
(3669, 'Lúdas Matyi (Matyi elszabadul, avagy sok lúd disznót győz)', 23, '2020-02-14', NULL, NULL),
(3670, 'A tétova menyasszony', NULL, '2019-09-07', NULL, NULL),
(3671, 'Optimista est', 173, '2016-03-09', NULL, 'magyar'),
(3672, 'Házimurik', NULL, '2018-01-12', 'monodráma', NULL),
(3673, 'Öngyilkos érzelmek', 14, '2013-10-18', 'színmű', 'magyar'),
(3674, 'Kávéház a vén fiákerhez', 56, '2017-11-30', 'zenés játék', 'magyar'),
(3675, 'Szürke galamb', 144, '2017-01-20', NULL, 'magyar'),
(3676, 'Téli rege', 190, '2017-03-05', NULL, 'magyar'),
(3677, 'Fallen', NULL, '2018-06-01', NULL, NULL),
(3678, 'Vízkereszt, vagy amire vágytok', 66, '2015-07-03', 'vígjáték', 'magyar'),
(3679, 'Térden állva jövök hozzád', 56, '2021-12-04', 'zenés vígjáték', NULL),
(3680, 'Macbeth/Anatómia', 128, '2013-09-06', NULL, 'magyar'),
(3681, 'Oedipus', 73, '2012-05-04', 'tragédia', NULL),
(3682, 'A mizantróp', 26, '2016-04-26', 'tragédia', 'magyar'),
(3683, 'Rómeó és Júlia', 30, '2016-01-23', 'színmű', 'magyar'),
(3684, 'Bebújós', 200, '2017-04-14', NULL, 'magyar'),
(3685, 'A Négyszögletű Kerek Erdő', 52, '2018-04-06', NULL, NULL),
(3686, 'Kultúr', 124, '2014-11-29', 'doku-színház', 'magyar'),
(3687, 'Numera! - Fókuszban az EGYES számMaladype Színház', NULL, '2014-12-07', NULL, 'magyar'),
(3688, 'Krisztus születése', 122, '2015-02-13', NULL, 'magyar'),
(3689, 'Hófödte álom - Ősi cirkuszi mese', 156, '2019-10-12', 'cirkuszi előadás', NULL),
(3690, 'Lenka és a tündér', 38, '2019-09-15', 'bábjáték', NULL),
(3691, 'Social Karaoke', NULL, '2021-10-09', NULL, NULL),
(3692, 'Pomádé király új ruhája', 23, '2013-01-18', 'zenés komédia', NULL),
(3693, 'Az ablakmosó', 31, '2012-08-23', NULL, 'magyar'),
(3694, 'Vaknyugat', 185, '2014-03-20', 'színmű', 'magyar'),
(3695, 'Balkán kobra', 56, '2019-01-26', 'zenés komédia', NULL),
(3696, 'Legyen Férfi, Monsieur Pignon!', NULL, '2018-10-23', 'vígjáték', NULL),
(3697, 'A Mester és Margarita', 122, '2015-02-27', NULL, 'magyar'),
(3698, 'Pass-port No. 1', 46, '2012-05-23', NULL, 'magyar'),
(3699, 'MU Terminál B-Est: Új generáció', NULL, '2020-03-01', 'táncelőadás', NULL),
(3700, 'A revizor', 170, '2014-01-08', 'tragikomédia', 'magyar'),
(3701, 'Simon Boccanegra', 23, '2013-10-18', 'opera', 'olasz'),
(3702, 'Az aranjuezi szép napok', 123, '2016-06-30', NULL, 'magyar'),
(3703, 'A pillangók szabadok', 109, '2014-01-28', 'színmű', 'magyar'),
(3704, 'Anyám tyúkja', 20, '2014-04-11', 'színmű', 'magyar'),
(3705, 'Veszedelmes viszonyok', 29, '2022-01-28', 'zenedráma', NULL),
(3706, 'Rómeó és Júlia - Shakespeare-mesék', 13, '2012-10-06', 'bábjáték', 'magyar'),
(3707, 'Sündör és Niru', 201, '2016-06-04', 'bábjáték', 'magyar'),
(3708, 'Az ajtó', 122, '2016-01-15', NULL, 'magyar'),
(3709, 'Egmont - zenés médiaszenny 60 percben', 128, '2012-05-20', 'színmű', 'magyar'),
(3710, 'Rigócsőr király', 177, '2015-12-02', 'zenés mesejáték', NULL),
(3711, 'Porgy és Bess', 39, '2013-08-09', 'opera', NULL),
(3712, 'Matkó Tamás: Quad / Kálmán Eszter: Domestic Noise', NULL, '2020-01-31', NULL, NULL),
(3713, 'Pinokkió', 13, '2016-04-29', NULL, NULL),
(3714, '9000 km - Adventi játék', 183, '2012-11-18', NULL, NULL),
(3715, 'A denevér', 99, '2017-12-22', 'vígopera', NULL),
(3716, 'Kőműves Kelemen', 122, '2016-09-16', 'rockopera', 'magyar'),
(3717, 'Panta Rhei', 125, '2019-06-02', 'táncelőadás', NULL),
(3718, 'Ládafia', 50, '2014-10-08', 'táncmesejáték', 'magyar'),
(3719, 'Cosi fan tutte', 23, '2020-01-17', 'vígopera', NULL),
(3720, 'Jó házból való úrilány jelentkezését várom!', 149, '2019-10-12', 'vígjáték', NULL),
(3721, 'Artúr, a cipőhorgász', 122, '2014-01-22', 'zenés mesejáték', 'magyar'),
(3722, 'Szerelem és halványlila dunszt', 6, '2020-04-10', NULL, NULL),
(3723, 'Az élet álom', 140, '2018-03-31', NULL, NULL),
(3724, 'Az algoritmus', 110, '2020-09-18', NULL, NULL),
(3725, 'Tanulmány a nőkről', 50, '2019-11-29', 'zenés előadás', NULL),
(3726, 'Diszkódisznók', 36, '2016-01-22', NULL, 'magyar'),
(3727, 'Kozmikus Ady', 159, '2014-09-06', 'irodalmi est', 'magyar'),
(3728, 'Virágot Algernonnak', 23, '2019-05-03', NULL, NULL),
(3729, 'A medve, akit Vasárnapnak hívtak', 28, '2015-04-18', NULL, NULL),
(3730, 'Novecento (Az óceánjáró zongorista legendája)', 182, '2019-02-19', NULL, NULL),
(3731, 'Nagyvizit', 44, '2019-11-08', 'tragikomédia', NULL),
(3732, 'IMAGINE - Seholsincs ember', 106, '2015-12-08', 'zenés előadás', 'magyar'),
(3733, 'Elfújta a szél', 29, '2013-07-26', 'musical', 'magyar'),
(3734, 'André Chénier', 23, '2012-10-19', 'opera', 'olasz'),
(3735, 'Sok hűhó semmiért', 97, '2016-04-16', 'vígjáték', 'magyar'),
(3736, 'Meggyeskert', 181, '2020-09-04', 'színmű', NULL),
(3737, 'Sütibár', 71, '2015-10-17', 'gyermekelőadás', 'magyar'),
(3738, 'Az utolsó velencei kalmár', 155, '2021-10-24', NULL, NULL),
(3739, 'Mágnás Miska', 23, '2019-12-13', 'operett', NULL),
(3740, 'Rumcájsz, a rabló', 70, '2013-10-09', 'zenés mesejáték', 'magyar'),
(3741, 'A tengerlépő cipő', 151, '2019-02-24', 'zenés bábjáték', NULL),
(3742, 'A képzelt beteg', 20, '2013-12-21', 'színmű', 'magyar'),
(3743, 'Stabat Mater', 137, '2013-02-22', 'balett', 'magyar'),
(3744, 'Emberi tragédia', 109, '2018-02-23', 'táncelőadás', NULL),
(3745, 'Image / I hear you', NULL, '2018-05-26', 'táncelőadás', NULL),
(3746, 'Antigoné', 136, '2014-11-13', 'táncjáték', 'magyar'),
(3747, 'Fehérlófia', 43, '2013-03-10', 'bábjáték', 'magyar'),
(3748, 'Valami csaj(ok)', 79, '2016-12-15', NULL, 'magyar'),
(3749, 'Köztársaság', 185, '2013-11-08', 'dráma', 'magyar'),
(3750, 'Betyárjáték', 157, '2016-01-09', 'zenés előadás', 'magyar'),
(3751, 'Sárkányölő Krisztián', 131, '2013-11-15', NULL, 'magyar'),
(3752, 'Mátyás király juhásza', 73, '2019-11-30', 'mesejáték', NULL),
(3753, 'Abigél', 44, '2015-12-18', 'musical', 'magyar'),
(3754, 'Absinth', 122, '2013-03-21', 'zenés előadás', 'magyar'),
(3755, 'Mi történt, miután Nóra elhagyta a férjét, avagy a társaságok támaszai', 20, '2012-01-07', NULL, NULL),
(3756, 'Az Űr-Zűr', 89, '2013-10-06', 'gyermekelőadás', 'magyar'),
(3757, 'A kőszívű ember fiai', 129, '2013-03-15', 'történelmi színmű', 'magyar'),
(3758, 'Momo', 95, '2014-10-03', 'zenés mesejáték', 'magyar'),
(3759, 'kattogas@porn.no', 96, '2015-10-30', NULL, 'magyar'),
(3760, 'Harminchatok', 127, '2012-04-15', 'színmű', 'magyar'),
(3761, 'Mario és a varázsló', 182, '2018-10-18', NULL, NULL),
(3762, 'Cigánytábor az égbe megy', 181, '2013-02-08', 'zenés ballada', 'magyar'),
(3763, 'A manógyár', 112, '2018-11-25', 'bábjáték', NULL),
(3764, 'O. márkiné', 57, '2017-11-17', NULL, 'magyar'),
(3765, 'Rémes születésnap', 182, '2018-07-24', 'vígjáték', NULL),
(3766, 'Édes Anna', 20, '2019-10-03', NULL, NULL),
(3767, 'Úrhatnám polgár', 102, '2014-02-08', 'komédia', 'magyar'),
(3768, 'Naftalin', 100, '2016-03-04', 'zenés bohózat', 'magyar'),
(3769, 'Vízkereszt, vagy bánom is én', 148, '2015-09-26', 'vígjáték', 'magyar'),
(3770, 'Szinyor Béla', 181, '2012-02-09', 'komédia', 'magyar'),
(3771, 'Hegyen-völgyön lakodalom', 39, '2012-07-13', 'táncelőadás', 'magyar'),
(3772, 'Címzett ismeretlen', NULL, '2020-09-09', NULL, NULL),
(3773, 'Egy apró kérés', 68, '2020-02-19', 'vígjáték', NULL),
(3774, 'Csönd', NULL, '2021-10-24', 'táncelőadás', NULL),
(3775, 'Puha pihe', 153, '2013-11-08', 'színjáték', 'magyar'),
(3776, 'Hodworks: Délibáb', 179, '2019-02-08', 'táncelőadás', NULL),
(3777, 'Tigris és hiéna', 12, '2012-01-12', 'történelmi dráma', 'magyar'),
(3778, 'Kálvária Lakópark', NULL, '2018-05-26', NULL, NULL),
(3779, 'Nélküled', NULL, '2021-06-10', NULL, NULL),
(3780, 'Rongyos életek', 64, '2015-09-15', 'zenés játék', 'magyar'),
(3781, 'IKF – Ifjú Koreográfusok Fóruma', 78, '2018-06-09', NULL, NULL),
(3782, 'A virágot lépő lány', 27, '2017-10-22', 'gyermekelőadás', 'magyar'),
(3783, 'A bolygó hollandi', 22, '2013-01-19', 'opera', NULL),
(3784, 'Kreutzer szonáta', 162, '2013-11-15', 'játék', 'magyar'),
(3785, 'Kistigris és Kismackó', 88, '2017-02-04', 'bábjáték', NULL),
(3786, 'Don Carlos', 190, '2021-10-10', NULL, NULL),
(3787, 'Apátlanok', 20, '2016-01-15', 'színmű', 'magyar'),
(3788, 'Íphigeneia Tauriszban', 22, '2014-06-22', 'opera', NULL),
(3789, 'Kövek', 32, '2014-09-17', 'színmű', 'magyar'),
(3790, 'Az imposztor', 102, '2022-01-29', 'vígjáték', NULL),
(3791, 'Három kívánság', 38, '2017-04-23', 'bábjáték', 'magyar'),
(3792, 'Rozsda lovag és Fránya Frida', 136, '2016-09-10', 'musical', 'magyar'),
(3793, 'A tünetegyüttes', 133, '2019-02-18', NULL, NULL),
(3794, 'Mesél a bécsi erdő', 20, '2016-03-18', 'színmű', 'magyar'),
(3795, 'A hisztérika', NULL, '2021-11-30', NULL, NULL),
(3796, 'Röpülj, lelkem!', 110, '2016-01-04', 'zenés előadás', 'magyar'),
(3797, 'Kaktuszvirág', 68, '2019-12-03', NULL, NULL),
(3798, 'Diótörő', 99, '2013-11-30', 'balett', NULL),
(3799, 'A Tündérlaki lányok', 126, '2017-03-27', 'vígjáték', 'magyar'),
(3800, 'Mengele bőröndje', 182, '2017-12-16', 'monodráma', 'magyar'),
(3801, 'Az ember tragédiája junior', 134, '2020-01-22', NULL, NULL),
(3802, 'A hűtlen feleség', 154, '2020-04-09', 'táncelőadás', NULL),
(3803, 'Arany', 148, '2017-03-25', 'színmű', 'magyar'),
(3804, 'Boeing, Boeing - Leszállás Párizsban', 152, '2013-10-05', 'bohózat', 'magyar'),
(3805, 'Tátitá', 104, '2015-02-27', 'táncelőadás', 'magyar'),
(3806, 'Amika cukrászdája', 140, '2020-02-22', NULL, NULL),
(3807, 'A Mikulás manói', 56, '2015-11-17', 'zenés mesejáték', 'magyar'),
(3808, 'Egyensúly', 80, '2015-11-14', 'balett', NULL),
(3809, 'Egy csók és más semmi', 134, '2021-06-22', 'operett', NULL),
(3810, 'A repülő gyermek', 26, '2017-04-12', NULL, 'német'),
(3811, 'Ördögök', 157, '2021-12-17', NULL, NULL),
(3812, 'Sztárcsinálók', 76, '2017-02-18', 'rockopera', NULL),
(3813, 'Bagolykisasszony meséje', 4, '2015-10-10', 'bábjáték', NULL),
(3814, 'Nostradamus - Világok vándora', 103, '2016-05-14', 'táncelőadás', 'magyar'),
(3815, 'Segítség, megnősültem!', NULL, '2016-10-29', NULL, NULL),
(3816, 'Kék róka', 23, '2015-04-21', 'színjáték', 'magyar'),
(3817, 'KFM', NULL, '2020-02-15', 'balett', NULL),
(3818, 'Don Juan', 140, '2014-04-16', 'színmű', 'magyar'),
(3819, 'A kis herceg', 30, '2021-10-22', 'bábelőadás', NULL),
(3820, 'SZERELEM (Henrik Ibsen: Kis Eyolf)', 166, '2013-04-07', 'színmű', 'magyar'),
(3821, 'Justine', 173, '2013-11-21', NULL, 'magyar'),
(3822, 'Holle anyó', 27, '2015-11-29', NULL, NULL),
(3823, 'IKF (Ifjú Koreográfusok Fóruma)', 123, '2013-05-18', 'táncelőadás', 'magyar'),
(3824, 'Chaos | The Waves', 80, '2021-09-28', 'balett', NULL),
(3825, 'Alkésztisz', 140, '2018-04-04', NULL, NULL),
(3826, 'Manon Lescaut', 150, '2019-05-18', 'opera', NULL),
(3827, 'Pinokkió', 23, '2016-10-21', 'mesejáték', 'magyar'),
(3828, 'Tájbrék', 194, '2014-10-18', 'tragikomédia', 'magyar'),
(3829, 'Lear király', 50, '2013-04-25', 'dráma', 'magyar'),
(3830, 'Jeanne d’Arc a tűzben', NULL, '2019-09-29', NULL, NULL),
(3831, 'Arzén és levendula', 102, '2016-02-20', 'bűnügyi bohózat', 'magyar'),
(3832, 'Egy csók és más semmi', 32, '2015-10-22', 'zenés komédia', 'magyar'),
(3833, 'Hét évszak, közte egy tél', 74, '2020-12-19', 'tragikomédia', NULL),
(3834, 'A Szkalla lányok', 201, '2012-04-06', NULL, 'magyar'),
(3835, 'Salemi boszorkányok', 187, '2018-10-13', 'dráma', 'magyar'),
(3836, 'Shirley Valentine', 185, '2014-01-18', NULL, 'magyar'),
(3837, 'A királylány bajusza', 162, '2015-09-19', 'zenés mesejáték', 'magyar'),
(3838, 'Emma csöndje', 40, '2021-09-25', 'bábjáték', NULL),
(3839, 'Földindulás', 87, '2015-10-16', NULL, 'magyar'),
(3840, 'Jelenetek egy kivégzésből', 73, '2012-03-02', 'dráma', NULL),
(3841, 'Hazatérés', 30, '2014-11-27', 'színmű', 'magyar'),
(3842, 'Wayne McGregor-Random Dance: Atomos', 173, '2015-04-24', 'táncelőadás', NULL),
(3843, 'Francia rúdugrás', 32, '2020-06-12', 'vígjáték', NULL),
(3844, 'Liliom', 44, '2015-11-06', 'színmű', 'magyar'),
(3845, 'Könnyű erkölcsök', 126, '2016-08-08', NULL, 'magyar'),
(3846, 'Mágnás Miska', 73, '2014-02-21', 'operett', 'magyar'),
(3847, 'Én és a kisöcsém', 99, '2014-09-26', 'operett', 'magyar'),
(3848, 'Hamupipőke', 109, '2012-12-15', 'táncmesejáték', 'magyar'),
(3849, 'Bolha a fülbe', 148, '2018-03-10', 'vígjáték', NULL),
(3850, 'Koronázási Szertartásjáték - Könyves Kálmán: A szellem harcosa', 95, '2015-08-15', NULL, 'magyar'),
(3851, 'Doktor Faust', 22, '2015-05-22', 'szcenírozott előadás', 'német'),
(3852, 'Leonida Gem Session', 7, '2012-09-21', NULL, NULL),
(3853, 'Mi újság?', 28, '2017-09-30', 'interaktív előadás', 'magyar'),
(3854, '3:1 a szerelem javára', 95, '2014-07-31', 'zenés vígjáték', 'magyar'),
(3855, 'Az ifjú Mátyás', 122, '2018-11-14', 'zenés mesejáték', NULL),
(3856, 'A házasságlevél', 185, '2015-10-22', 'vígjáték', 'magyar'),
(3857, 'Pokoli vígjáték', 170, '2012-03-17', 'zenés dráma', NULL),
(3858, 'Equus', 195, '2016-02-20', 'színjáték', 'magyar'),
(3859, 'Bolha a fülbe', 70, '2020-01-31', 'bohózat', NULL),
(3860, 'Az álarcosbál', 22, '2018-04-21', 'opera', 'olasz'),
(3861, 'Verdi miniatures', 125, '2013-10-29', 'táncelőadás', 'magyar'),
(3862, 'Esőember', 44, '2019-03-29', 'dráma', NULL),
(3863, 'Kóda - utóirat két hegedűre', 2, '2017-03-04', NULL, 'magyar'),
(3864, 'Katona József - avagy légy a pókok között fickándozik', 134, '2016-11-11', NULL, 'magyar'),
(3865, 'Halálra táncoltatott lány', 26, '2013-12-09', NULL, 'magyar'),
(3866, 'Szívszakadtig', 49, '2017-03-27', NULL, 'magyar'),
(3867, 'Karamazov fivérek', 182, '2019-03-26', NULL, NULL),
(3868, 'Rózsa és Ibolya', 27, '2013-10-06', 'gyermekelőadás', 'magyar'),
(3869, 'Vineta köztársaság', 9, '2017-02-24', 'színmű', 'magyar'),
(3870, 'Lear király', 34, '2021-05-29', NULL, NULL),
(3871, 'A Mikulás új szánja', 112, '2021-12-05', 'zenés mesejáték', NULL),
(3872, 'Az ismeretlen', 79, '2017-09-07', NULL, 'magyar'),
(3873, 'Oszi Boszi, a repülő nagyanyó', 29, '2012-12-16', 'zenés előadás', 'magyar'),
(3874, 'Szentivánéji álom', 99, '2014-10-10', 'vígjáték', 'magyar'),
(3875, 'Szép Heléna', 181, '2012-10-05', 'operett', 'magyar'),
(3876, 'Csendkoordináták', 78, '2012-04-13', NULL, 'magyar'),
(3877, 'A tanítónő', 126, '2021-08-24', 'színmű', NULL),
(3878, 'Zserbótangó', 50, '2013-12-06', 'tragikomédia', 'magyar'),
(3879, 'TIKK', 164, '2014-11-15', 'színmű', 'magyar'),
(3880, 'Képíró', 178, '2019-03-30', 'táncelőadás', NULL),
(3881, 'Kalucsni', 129, '2019-03-02', NULL, NULL),
(3882, 'Odaadó hívetek, Surik', 95, '2020-01-10', NULL, NULL),
(3883, 'A Gulag virágai', 157, '2016-11-12', NULL, 'magyar'),
(3884, 'Közös nevező', 173, '2014-10-10', 'táncelőadás', NULL),
(3885, 'Már megint kezdik!', 160, '2016-12-03', NULL, NULL),
(3886, 'A négyszögletű kerek erdő', 32, '2013-09-21', 'mesejáték', 'magyar'),
(3887, 'Kohlhaas Mihály', 140, '2019-12-17', NULL, NULL),
(3888, '6', 157, '2016-03-05', NULL, 'magyar'),
(3889, 'Anna Karenina', 148, '2015-10-10', 'dráma', 'magyar'),
(3890, 'romance.com', 79, '2015-02-12', 'színmű', 'magyar'),
(3891, 'Bánk bán', 34, '2019-12-20', NULL, NULL),
(3892, 'Makrancos hölgy, avagy a személyiség megzabolázása', 185, '2016-03-11', 'vígjáték', 'magyar'),
(3893, 'A szabadulás pillanata', 182, '2020-08-22', NULL, NULL),
(3894, 'Lö csibészek - A Pokoli Trió', 62, '2014-10-11', 'színmű', 'magyar'),
(3895, 'Álomőrző', 193, '2016-03-30', 'újcirkusz', 'magyar'),
(3896, 'R&L, avagy a mágusok birodalma', 30, '2013-10-13', 'színmű', 'magyar'),
(3897, 'Én vagyok én, te vagy te', 38, '2013-09-29', 'bábjáték', 'magyar');
INSERT INTO `eloadas` (`id`, `cim`, `szinhazid`, `datum`, `mufaj`, `nyelv`) VALUES
(3898, 'Dögkeselyű', 118, '2014-12-05', 'zenés előadás', 'magyar'),
(3899, 'Papírvarázs', 38, '2017-10-01', NULL, 'magyar'),
(3900, 'Légy a levesben', 140, '2013-02-26', 'színpadi játék', 'magyar'),
(3901, 'Mária főhadnagy', 23, '2013-02-08', 'nagyoperett', 'magyar'),
(3902, 'Stuart Mária', 73, '2013-01-11', 'színmű', 'magyar'),
(3903, 'János-passió', 22, '2015-04-02', 'oratórium', 'német'),
(3904, 'Shirley Valentine', 122, '2014-03-07', NULL, 'magyar'),
(3905, 'Esküvőtől válóperig', 152, '2012-06-21', 'bohózat', 'magyar'),
(3906, 'Valle della luna', 169, '2015-03-30', NULL, 'magyar'),
(3907, 'Big Bang', 173, '2012-05-11', NULL, 'magyar'),
(3908, 'A sötétség hatalma', 30, '2017-11-18', NULL, 'magyar'),
(3909, 'Semleges nemek', 203, '2014-12-18', 'színmű', 'magyar'),
(3910, '1x3 néha 4', 134, '2021-10-22', NULL, NULL),
(3911, 'Hétköznapi őrületek', 152, '2014-12-06', 'komédia', 'magyar'),
(3912, 'Tanulmány a nőkről', 181, '2018-11-16', NULL, NULL),
(3913, 'Vörös', 21, '2013-11-08', 'színmű', 'magyar'),
(3914, 'Ürgék', 21, '2018-05-18', NULL, NULL),
(3915, 'Mario és a varázsló', 50, '2016-01-15', NULL, 'magyar'),
(3916, 'Az idő ura', 65, '2014-11-25', 'táncelőadás', 'magyar'),
(3917, 'Fekete zaj', 32, '2017-01-13', NULL, 'magyar'),
(3918, 'A szív hídjai', 68, '2013-06-29', 'színmű', 'magyar'),
(3919, 'Az öreg hölgy látogatása', 109, '2014-09-26', 'tragikomédia', 'magyar'),
(3920, 'Trójai játékok - amazonokkal', 86, '2014-09-27', 'balett', NULL),
(3921, 'Kezembe temetem forró arcomat', 26, '2020-01-20', NULL, NULL),
(3922, 'Bányavakság', 14, '2012-11-24', 'színmű', 'magyar'),
(3923, 'A balkáni kobra', 76, '2014-02-08', 'zenés komédia', 'magyar'),
(3924, 'Csirkefej', 143, '2020-02-28', 'tragédia', NULL),
(3925, 'Istent a falra festeni', 122, '2014-09-26', 'színmű', 'magyar'),
(3926, 'Bányavakság', 70, '2016-10-28', 'tragikomédia', 'magyar'),
(3927, 'A púpos lovacska', 129, '2020-03-27', NULL, NULL),
(3928, 'Egy darabot a szívemből', 195, '2015-09-26', 'musical', 'magyar'),
(3929, 'Parasztopera', 9, '2014-11-21', NULL, 'magyar'),
(3930, 'Pixel', 140, '2018-02-24', NULL, NULL),
(3931, 'Kézről kézre', 32, '2013-12-06', 'bohózat', 'magyar'),
(3932, 'A székely menyecske meg az ördög', 76, '2016-02-08', 'bábjáték', 'magyar'),
(3933, 'A Nagy Ho-ho-ho-horgász', 76, '2013-03-06', 'zenés mesejáték', 'magyar'),
(3934, 'Sárga vonal', 140, '2015-11-21', 'színmű', 'magyar'),
(3935, 'Farsang', 157, '2012-03-23', NULL, NULL),
(3936, 'Égimese', 109, '2013-02-07', 'zenés mesejáték', 'magyar'),
(3937, 'A windsori víg nők', 185, '2019-04-05', 'vígjáték', NULL),
(3938, 'A zöld madár', 88, '2018-09-29', 'bábjáték', NULL),
(3939, 'Cabaret', 73, '2013-11-29', 'musical', 'magyar'),
(3940, 'Buborékok', 190, '2015-03-01', 'színmű', 'magyar'),
(3941, 'Csodálatos, képes rettenetek - Ady-est 2.', 142, '2012-03-01', NULL, NULL),
(3942, 'Ballada a 301-es parcella bolondjáról', 134, '2019-10-25', NULL, NULL),
(3943, 'Szabadesés, avagy Barnaby Brocket kalandjai a felhőkön innen és túl', 43, '2020-01-10', 'bábjáték', NULL),
(3944, 'Fekete ég - A fehér felhő', 157, '2014-09-27', 'színmű', 'magyar'),
(3945, 'Maya', 29, '2018-11-30', 'operett', NULL),
(3946, 'Cabaret', 182, '2015-06-09', 'musical', 'magyar'),
(3947, 'Királyok könyve -Történetek Szent Lászlóról', 38, '2019-10-07', 'mesejáték', NULL),
(3948, 'László király visszatér!', 99, '2020-08-20', 'történelmi vígjáték', NULL),
(3949, 'Pitypang/Por', 18, '2019-12-12', NULL, NULL),
(3950, 'Sybill', 29, '2015-12-08', 'operett', 'magyar'),
(3951, 'Pass-port Európa', 46, '2012-09-27', 'színmű', 'magyar'),
(3952, 'Kvartett', 60, '2014-10-10', 'komédia', 'magyar'),
(3953, 'Hókirálynő', 181, '2019-01-29', 'mesejáték', 'magyar'),
(3954, 'SISI', 198, '2021-06-16', 'táncelőadás', NULL),
(3955, 'Az üvegcipő', 102, '2017-02-25', NULL, 'magyar'),
(3956, 'Mese a fiókból', 109, '2016-02-05', 'mesejáték', 'magyar'),
(3957, 'Pöttyös Panni', 129, '2015-04-04', 'gyermekelőadás', 'magyar'),
(3958, 'Liliom', 58, '2012-01-14', NULL, NULL),
(3959, 'A Gazdagság', NULL, '2019-01-19', 'komédia', NULL),
(3960, 'Kalliopé', 163, '2016-11-10', 'dráma', 'magyar'),
(3961, 'A só', 27, '2017-01-29', 'bábjáték', NULL),
(3962, 'Shadows of Cherry Orchard (A cseresznyéskert árnyai)', 6, '2012-03-27', 'bábjáték', 'japán'),
(3963, 'Szerelmem, Sárdy', 56, '2015-11-28', 'zenés napló', 'magyar'),
(3964, 'Éjjeli menedékhely', 181, '2012-10-26', 'dráma', 'magyar'),
(3965, 'A Pendragon-legenda', 29, '2019-05-11', 'musical', NULL),
(3966, 'IKF (Ifjú Koreográfusok Fóruma) - Pálfi Gabriella', 123, '2013-09-28', 'táncelőadás', 'magyar'),
(3967, 'Az özvegy Karnyóné és a két szeleburdiak', 23, '2013-09-20', 'zenés vígjáték', 'magyar'),
(3968, 'Pimpáré és Vakvarjúcska', 151, '2012-01-29', NULL, 'magyar'),
(3969, 'Isten pénze', 185, '2018-10-19', 'musical', NULL),
(3970, 'Halálra táncoltatott lány', NULL, '2021-09-12', 'táncelőadás', NULL),
(3971, 'Pirosmalac', 13, '2014-02-20', NULL, NULL),
(3972, 'Én, te, ő', 143, '2015-01-30', 'színmű', 'magyar'),
(3973, 'Paulus', 123, '2013-03-07', 'színmű', 'magyar'),
(3974, '...a földgömböt itt hegyezd ki!', 38, '2020-03-29', 'bábjáték', NULL),
(3975, 'Légy jó mindhalálig', 181, '2014-09-30', 'musical', 'magyar'),
(3976, '3050 gramm', 45, '2014-12-19', NULL, 'magyar'),
(3977, 'A komédia művészete', 140, '2017-01-06', NULL, 'magyar'),
(3978, 'Az utolsó tekercs', 171, '2013-04-12', 'színmű', 'magyar'),
(3979, 'Circus Classicus', 156, '2014-03-29', NULL, 'magyar'),
(3980, 'Figaro3', 22, '2021-06-26', 'opera', NULL),
(3981, 'Pustol a hó', 157, '2019-01-27', NULL, NULL),
(3982, 'Romantika', 194, '2012-12-08', 'abszurd dráma', 'magyar'),
(3983, 'A szörny, az átok és az áldozat', NULL, '2018-04-28', NULL, NULL),
(3984, 'Hétszínvirág', 116, '2017-01-01', 'bábjáték', 'magyar'),
(3985, 'Nem is én vagyok ez már', 36, '2021-09-17', 'misztikus thriller', NULL),
(3986, 'I. Erzsébet', 14, '2013-11-27', 'színmű', 'magyar'),
(3987, 'Gina és Fidel - találkozás', 182, '2019-10-20', NULL, NULL),
(3988, 'A kappan, a csirke és a marabu...', 79, '2012-12-29', 'zenés színmű', 'magyar'),
(3989, 'Bruno Isaković: DENUDED', 169, '2015-05-21', 'táncelőadás', NULL),
(3990, 'Két néni, ha elindul', 134, '2013-02-22', 'abszurd dráma', 'magyar'),
(3991, 'A mindentlátó királylány', 88, '2020-11-13', 'mesejáték', NULL),
(3992, 'Kalózkaland', 195, '2019-12-13', 'zenés mesejáték', NULL),
(3993, 'Utas és holdvilág', NULL, '2019-07-24', NULL, NULL),
(3994, 'Liliomfi', 30, '2015-11-28', 'színmű', 'magyar'),
(3995, 'A mi kis városunk', 121, '2017-09-29', 'színjáték', 'magyar'),
(3996, 'Menyegző/eARTh', 137, '2016-11-11', 'kortárs tánc', 'magyar'),
(3997, 'Orfeusz és Euridiké', 137, '2018-06-27', 'táncelőadás', NULL),
(3998, 'A mi kis városunk', 130, '2017-12-08', 'színmű', NULL),
(3999, 'Sirály', 34, '2015-12-20', 'színmű', 'magyar'),
(4000, 'Metropolisz', 128, '2020-09-19', 'táncelőadás', NULL),
(4001, 'Várnagy Kristóf: Test est / Máday Tímea Kinga: Luna', NULL, '2021-10-12', 'táncelőadás', NULL),
(4002, 'Testvérek', 13, '2016-09-04', NULL, NULL),
(4003, 'Szingli\'z Night- Benk Dénes, Hajdú Balázs, Tóth Edu, Ráskó Eszter, Musimbe Dávid Dennis', NULL, '2018-11-11', 'stand-up comedy', NULL),
(4004, 'A kaméliás hölgy, avagy a kegyvesztetek tündöklése', 122, '2022-01-28', 'zenés tragédia', NULL),
(4005, 'Vitéz Mihály', 9, '2015-02-06', 'tragikomédia', 'magyar'),
(4006, 'A bogyósgyümölcskertész fia', 54, '2021-05-22', NULL, NULL),
(4007, 'Tökéletes esküvő', 168, '2018-10-27', 'vígjáték', NULL),
(4008, 'Vitéz László menyecskét keres', NULL, '2017-03-24', 'bábjáték', 'magyar'),
(4009, 'A Dédi', 9, '2016-12-02', NULL, 'magyar'),
(4010, 'Elsötétítés', 140, '2018-10-28', NULL, NULL),
(4011, 'Hamupipőke', 129, '2019-02-15', 'meseopera', NULL),
(4012, 'Árvák', 144, '2016-05-06', NULL, 'magyar'),
(4013, 'Vadak Ura -The Covenant', NULL, '2021-10-15', 'musical', NULL),
(4014, 'Sors-kanyar', NULL, '2021-11-06', NULL, NULL),
(4015, 'Illatszertár', 148, '2013-12-14', 'színmű', 'magyar'),
(4016, 'Tiszta föld', 78, '2014-11-13', 'táncelőadás', 'magyar'),
(4017, 'Paprika Jancsi és az ördögök aranya', 13, '2015-01-25', 'bábjáték', NULL),
(4018, 'Rigócsőr király', 131, '2014-03-28', 'gyermekelőadás', 'magyar'),
(4019, 'Az utolsó magyar', 194, '2013-11-30', 'abszurd dráma', 'magyar'),
(4020, 'Jézus Krisztus szupersztár', 148, '2014-12-20', 'rockopera', 'magyar'),
(4021, 'Cyrano de Bergerac', 66, '2015-03-06', NULL, 'magyar'),
(4022, 'Foszlányok', 104, '2017-05-25', 'táncelőadás', NULL),
(4023, 'Zűrzavar 2045', 20, '2020-10-09', NULL, NULL),
(4024, 'Az elveszett levél', 23, '2016-02-12', 'zenés tragikomédia', 'magyar'),
(4025, 'Odüsszeusz szemeteslapáton', 77, '2014-03-29', 'színmű', 'magyar'),
(4026, 'Vérnász', 95, '2015-01-17', NULL, 'magyar'),
(4027, 'Legyetek jók, ha tudtok!', 185, '2021-06-11', 'zenés játék', NULL),
(4028, 'Hogyan legyünk boldogtalanok?', NULL, '2019-12-13', NULL, NULL),
(4029, 'Utánképzés (ittas vezetőknek)', 23, '2017-04-07', 'színmű', 'magyar'),
(4030, 'Linda Vista', 32, '2020-10-16', 'vígjáték', NULL),
(4031, 'Olympia', 121, '2015-02-13', 'vígjáték', 'magyar'),
(4032, 'Fatia Negra', 162, '2021-06-18', NULL, NULL),
(4033, 'A nyaralás', 34, '2013-01-26', 'komédia', 'magyar'),
(4034, 'Kaddis', 68, '2013-06-05', 'színmű', 'angol'),
(4035, 'A Majomkirály', 191, '2013-06-15', 'táncelőadás', NULL),
(4036, 'Titus Anatómiája, Róma bukása', 122, '2014-11-21', NULL, 'magyar'),
(4037, 'Az ügynök halála', 76, '2012-11-10', 'színmű', 'magyar'),
(4038, 'Bodor Panna: Világgá', 2, '2020-01-13', NULL, NULL),
(4039, 'Csínom Palkó', 109, '2019-01-25', 'táncjáték', NULL),
(4040, 'Babaróka', 88, '2019-02-09', 'bábjáték', NULL),
(4041, 'Az éjszaka a nappal anyja', 140, '2017-11-16', NULL, 'magyar'),
(4042, 'Di-dá-dú', 116, '2014-04-06', 'gyermekelőadás', 'magyar'),
(4043, 'Fekete kutya', NULL, '2018-05-21', 'táncelőadás', NULL),
(4044, 'A doktor úr', 185, '2013-04-12', 'bohózat', 'magyar'),
(4045, 'Closer', 161, '2015-05-11', 'színmű', 'magyar'),
(4046, 'A bánya; Szerelem', 22, '2016-10-21', 'opera', NULL),
(4047, 'Egy tenyér ha csattan', 138, '2018-10-05', NULL, NULL),
(4048, 'C’est la vie', 50, '2020-01-24', NULL, NULL),
(4049, 'Az üstökös', 18, '2018-12-12', NULL, NULL),
(4050, 'A nyílt tengeren', 102, '2016-10-26', NULL, 'magyar'),
(4051, 'Vadászat', 30, '2022-02-26', NULL, NULL),
(4052, 'Káli holtak', 21, '2021-09-17', NULL, NULL),
(4053, 'Közelítés', 191, '2018-05-28', 'táncelőadás', NULL),
(4054, 'A velencei kalmár', 95, '2016-02-13', NULL, 'magyar'),
(4055, 'Szélike királykisasszony', 27, '2015-02-01', 'bábjáték', NULL),
(4056, 'Prah', 181, '2016-09-25', 'komédia', 'magyar'),
(4057, 'Odüsszeusz bolyongásai', 144, '2018-09-23', 'bábjáték', NULL),
(4058, 'Édes életek', 148, '2017-03-11', 'tragikomédia', 'magyar'),
(4059, 'Csizmás kandúr', 73, '2014-04-12', 'mesejáték', 'magyar'),
(4060, 'A kis herceg és a planéták', 99, '2015-12-18', 'beavató színház', 'magyar'),
(4061, 'Szájon lőtt tigris', 157, '2017-01-13', 'zenés est', 'magyar'),
(4062, 'Zsanett 2.0', NULL, '2021-09-18', NULL, NULL),
(4063, 'Kooperett', 9, '2015-08-24', 'zenés előadás', 'magyar'),
(4064, 'Telma és Lujza', 140, '2017-04-06', NULL, 'magyar'),
(4065, 'Schweinland', 8, '2013-09-13', 'táncelőadás', 'magyar'),
(4066, 'Cudar világ', 9, '2014-02-07', 'zenés színmű', 'magyar'),
(4067, 'Üvegfigurák', 157, '2021-12-16', NULL, NULL),
(4068, 'Vitéz Mihály', NULL, '2019-04-13', NULL, NULL),
(4069, 'The Drone of Monk Nestor', 78, '2012-01-23', NULL, NULL),
(4070, '1st Steps', NULL, '2019-09-06', 'balett', NULL),
(4071, 'Nő a múltból', 32, '2014-09-27', 'színmű', 'magyar'),
(4072, 'Vesztett éden', 56, '2013-12-20', NULL, 'magyar'),
(4073, 'Magyar', 141, '2016-05-22', NULL, NULL),
(4074, 'Teljesen idegenek', 76, '2020-11-28', 'komédia', NULL),
(4075, 'Naftalin', NULL, '2019-04-05', NULL, NULL),
(4076, 'Viva Bartók!', 190, '2017-09-26', 'zenés előadás', 'magyar'),
(4077, 'Numera! - Fókuszban a NÉGYES és ÖTÖS számMaladype Színház', NULL, '2015-04-19', NULL, 'magyar'),
(4078, 'Kerekecske-gombocska', 4, '2013-11-09', 'csecsemő színház', 'magyar'),
(4079, 'Árpád-ház', 180, '2016-07-02', NULL, 'magyar'),
(4080, 'Brilliant Corners', 173, '2012-04-28', NULL, 'magyar'),
(4081, 'Amerikai legenda', 56, '2018-01-21', 'zenés játék', NULL),
(4082, 'A halandóság feltételei', 179, '2014-09-09', 'táncelőadás', 'magyar'),
(4083, 'Hunyadi László', 22, '2012-09-29', 'opera', 'magyar'),
(4084, 'Elv-társak - Notóriusok 30.4', 21, '2013-05-31', NULL, 'magyar'),
(4085, 'Komolyan röhejes vagyok', 132, '2021-06-13', NULL, NULL),
(4086, 'Kurázsi mama és gyermekei', 192, '2012-11-30', NULL, NULL),
(4087, 'Rumini', 125, '2020-11-15', NULL, NULL),
(4088, 'Óz', 112, '2019-02-03', 'zenés mesejáték', NULL),
(4089, 'A fáklya kialszik', 92, '2013-08-02', 'dráma', 'magyar'),
(4090, 'Furnitur', 62, '2014-01-26', 'színmű', 'magyar'),
(4091, 'A mindig modern kis sapka', 75, '2013-12-06', 'bábjáték', NULL),
(4092, 'Az eltört korsó', 181, '2014-09-19', 'komédia', 'magyar'),
(4093, 'Gyilkosok éjszakája', 171, '2016-04-09', NULL, 'magyar'),
(4094, 'Pipitér és Libatop', 13, '2013-11-08', NULL, 'magyar'),
(4095, 'Kurázsi mama és gyermekei', 23, '2015-01-23', 'dráma', 'magyar'),
(4096, 'Csongor és Tünde', 122, '2015-11-03', 'mesejáték', 'magyar'),
(4097, 'Ármány és szerelem', 143, '2013-01-12', 'színmű', 'magyar'),
(4098, 'Balhéatlasz', 101, '2013-10-26', 'színmű', 'magyar'),
(4099, 'A kisfiú meg az oroszlánok', 83, '2012-12-01', 'mesejáték', 'magyar'),
(4100, 'Az a skót darab', 124, '2015-11-17', 'színmű', 'magyar'),
(4101, 'Idáig tudom a történetet', 54, '2018-12-12', NULL, 'magyar'),
(4102, 'Diótörő', 140, '2012-10-27', NULL, 'magyar'),
(4103, 'Klotild néni', 121, '2013-10-11', 'bohózat', 'magyar'),
(4104, 'Misi mókus kalandjai', 70, '2015-10-01', 'zenés mesejáték', NULL),
(4105, 'Csipkerózsika', 202, '2012-10-07', 'zenés játék', 'magyar'),
(4106, 'Amadeus', 102, '2020-10-10', 'színjáték', NULL),
(4107, 'Kóbor csillag', 122, '2012-03-30', 'zenés játék', 'magyar'),
(4108, 'Az eset', 73, '2015-09-21', 'dráma', 'magyar'),
(4109, 'Vasárnap mondd el!', 118, '2021-06-11', 'musical', NULL),
(4110, 'A hideg gyermek', 140, '2012-11-07', 'színmű', 'magyar'),
(4111, 'Rigoletto', 32, '2014-11-28', 'opera', NULL),
(4112, 'Párterápia', 68, '2016-07-08', 'vígjáték', 'magyar'),
(4113, 'The Hungarian Blues Brothers (TM)', 201, '2012-07-21', NULL, 'magyar'),
(4114, 'Csetepaté Chioggiában', 102, '2012-04-28', 'vígjáték', 'magyar'),
(4115, 'A bőrönd és ők', 64, '2015-09-03', 'kabaré', 'magyar'),
(4116, 'Csinibaba', 148, '2013-04-20', 'zenés előadás', 'magyar'),
(4117, 'Vaknyugat', 81, '2012-12-30', 'színmű', 'magyar'),
(4118, 'A hollókirály', NULL, '2020-03-07', 'bábjáték', NULL),
(4119, 'Saloon', 82, '2017-08-04', 'újcirkusz', NULL),
(4120, 'Az ügynök halála', 32, '2012-02-10', 'dráma', 'magyar'),
(4121, 'Lear', 22, '2016-01-30', 'opera', 'német'),
(4122, 'Gátak és gátlások', 9, '2019-04-16', NULL, NULL),
(4123, 'Lili bárónő', 32, '2013-06-06', 'operett', 'magyar'),
(4124, 'Pesten születtem', 170, '2012-09-09', 'zenés előadás', 'magyar'),
(4125, 'Sári bíró', 162, '2017-03-03', 'vígjáték', 'magyar'),
(4126, 'Helver Éjszakája', NULL, '2021-11-27', NULL, NULL),
(4127, 'A vihar', 22, '2016-05-21', 'opera', 'angol'),
(4128, 'Gólem', 64, '2014-04-15', 'színmű', 'magyar'),
(4129, 'Lóvátett lovagok', 73, '2019-10-11', 'vígjáték', NULL),
(4130, 'Ha elállt az eső', 76, '2020-02-22', 'dráma', NULL),
(4131, 'Körbe, körbe, karikába', 112, '2016-10-01', NULL, NULL),
(4132, 'A szecsuáni jólélek', 99, '2016-12-10', NULL, 'magyar'),
(4133, 'Kányavár', NULL, '2018-06-15', NULL, NULL),
(4134, 'Keselyűfészek', 140, '2012-12-05', 'színmű', 'magyar'),
(4135, 'Ádám almái', 76, '2020-01-18', NULL, NULL),
(4136, 'Iszméné', 190, '2022-01-06', NULL, NULL),
(4137, 'Médeia', 140, '2019-12-20', NULL, NULL),
(4138, 'Kampókemp', 40, '2014-03-22', 'színmű', 'magyar'),
(4139, 'Frames', 72, '2017-03-03', 'táncelőadás', NULL),
(4140, 'Csókos asszony', 99, '2020-08-29', 'operett', NULL),
(4141, 'A nagymama', 109, '2020-10-09', 'romantikus vígjáték ', NULL),
(4142, 'Nyuszi-Hopp!', 116, '2018-03-18', 'csecsemő színház', NULL),
(4143, 'Jazzkéz és Whisky', 120, '2018-05-23', NULL, NULL),
(4144, 'Mese a Látóhegyről', 95, '2017-09-17', 'zenés mesejáték', 'magyar'),
(4145, 'Kököjszi és Bobojsza', 36, '2014-12-28', 'interaktív előadás', 'magyar'),
(4146, 'La Fontaine mesék', 112, '2018-09-13', 'bábjáték', NULL),
(4147, 'Rejtelmek', 6, '2015-04-11', NULL, 'magyar'),
(4148, 'Börtönkarrier', 70, '2015-11-20', 'zenés vígjáték', 'magyar'),
(4149, 'Rómeó és Júlia', 94, '2014-03-06', 'színházi közvetítés', 'angol'),
(4150, 'Porgy és Bess', 22, '2018-01-27', 'opera', NULL),
(4151, 'Rokonok', 9, '2012-03-14', NULL, 'magyar'),
(4152, 'Doboz', 200, '2018-12-07', NULL, NULL),
(4153, 'Tarkabarka', 112, '2019-02-09', 'csecsemő színház', NULL),
(4154, 'Bubamara', 56, '2014-10-18', 'musical', 'magyar'),
(4155, 'Szaffi', 129, '2020-10-02', 'mesejáték', NULL),
(4156, 'Zűrzavaros éjszaka', 157, '2013-10-19', 'komédia', 'magyar'),
(4157, 'Az úr komédiásai', 157, '2017-02-24', NULL, 'magyar'),
(4158, 'Az álarcosbál', 39, '2015-07-03', 'opera', 'olasz'),
(4159, 'Nyuszi ül a hóban', 102, '2016-01-13', 'zenés mesejáték', 'magyar'),
(4160, 'Ez történt Bécsben', 23, '2015-01-03', 'operett', 'magyar'),
(4161, 'Krapek', 184, '2018-12-06', 'monodráma', NULL),
(4162, 'Comment lájv', 194, '2014-03-29', NULL, 'magyar'),
(4163, 'Zeng a lélek', 151, '2018-12-22', 'misztériumjáték', NULL),
(4164, 'A szerelem forgandó', 182, '2018-10-30', 'komédia', NULL),
(4165, 'A chioggiai csetepaté', 122, '2015-04-17', NULL, 'magyar'),
(4166, 'Grand Finale 2015. - A Ritmus Ünnepe, a Zongora Virtuóza', 103, '2015-12-31', 'gála', NULL),
(4167, 'MOLIÉRE - the passion', 190, '2019-10-18', NULL, NULL),
(4168, 'Tárlat az utcán', 109, '2017-04-08', 'dráma', 'magyar'),
(4169, 'Lúdas Matyi', 38, '2017-11-26', 'bábelőadás', 'magyar'),
(4170, 'Carmen', 3, '2015-04-23', 'táncelőadás', NULL),
(4171, 'Balfácánt vacsorára', 129, '2018-12-08', NULL, NULL),
(4172, 'Csáth és démonai', 170, '2021-09-27', 'felolvasószínház', NULL),
(4173, 'Hullámok', 25, '2018-11-13', NULL, NULL),
(4174, 'Én, Iphigénia', 201, '2020-02-02', NULL, NULL),
(4175, 'Ősvigasztalás', 50, '2017-09-08', 'színmű', 'magyar'),
(4176, 'Mephisto', 170, '2013-11-08', 'dráma', 'magyar'),
(4177, 'XX_&_Fragments_', 19, '2017-04-04', 'táncelőadás', NULL),
(4178, 'Őrültek, haza!', NULL, '2019-11-16', NULL, NULL),
(4179, 'Szemenszedett mese', 140, '2015-05-03', 'színmű', 'magyar'),
(4180, 'Az utolsó óra', 79, '2013-02-14', 'színmű', 'magyar'),
(4181, 'Príma környék', 60, '2012-10-12', 'komédia', 'magyar'),
(4182, 'Csodaszarvas', 178, '2014-05-08', 'táncelőadás', 'magyar'),
(4183, 'Johanna, avagy maradjunk már emberek', 23, '2020-02-21', NULL, NULL),
(4184, 'A félőlény', 140, '2020-02-23', NULL, NULL),
(4185, 'Lúdas Matyi', 32, '2015-09-06', 'mesejáték', 'magyar'),
(4186, 'Pillangókisasszony', 23, '2012-03-16', 'opera', 'olasz'),
(4187, 'A nép ellensége', NULL, '2021-10-20', NULL, NULL),
(4188, 'Koronázási szertartásjáték - István', 95, '2013-08-17', NULL, 'magyar'),
(4189, 'Angyalok Amerikában', 140, '2019-11-08', NULL, NULL),
(4190, 'Kulcskeresők', 109, '2019-05-10', 'tragikomédia', NULL),
(4191, 'Tosca', 23, '2015-03-13', 'zenedráma', 'olasz'),
(4192, 'Spartacus', 82, '2013-06-28', 'balett', 'magyar'),
(4193, 'Kebab', 185, '2012-12-12', 'színmű', 'magyar'),
(4194, 'János vitéz', 122, '2012-09-21', 'daljáték', 'magyar'),
(4195, 'A császárfiú álma', 40, '2018-11-17', 'zenés mesejáték', NULL),
(4196, 'Horizont Táncfesztivál - Special Society', NULL, '2019-04-25', 'táncelőadás', NULL),
(4197, 'Az üvegcipő', 9, '2014-05-02', 'vígjáték', 'magyar'),
(4198, 'Miss Daisy sofőrje', 100, '2021-10-16', NULL, NULL),
(4199, 'Piszkos Fred, a kapitány', 85, '2014-06-06', 'musical', 'magyar'),
(4200, 'A csomótündér', 43, '2017-09-30', 'bábjáték', 'magyar'),
(4201, 'Én, József Attila', 118, '2012-02-10', 'musical', 'magyar'),
(4202, 'Antigoné', 181, '2012-03-09', 'tragédia', 'magyar'),
(4203, 'Érintés paradoxon', 135, '2021-11-30', 'táncelőadás', NULL),
(4204, 'Jövedelmező állás', 62, '2013-02-05', 'színmű', 'magyar'),
(4205, 'A csodálatos mesefa', 29, '2017-05-28', 'operett', NULL),
(4206, 'GAP - The Soloist', 191, '2012-09-22', 'táncjáték', 'magyar'),
(4207, 'A nők iskolája', 34, '2016-10-09', NULL, 'magyar'),
(4208, 'Peer Gynt', 12, '2019-11-30', 'drámai költemény', NULL),
(4209, 'Jóembert keresünk', 95, '2017-10-25', NULL, 'magyar'),
(4210, 'Aliz!', 30, '2020-02-22', 'mesejáték', NULL),
(4211, 'Táncfantáziák', 109, '2012-05-04', NULL, 'magyar'),
(4212, 'A kegyelmesasszony portréja', 162, '2018-09-28', 'vígjáték', NULL),
(4213, 'Pozsgai Zsolt - Léda', NULL, '2019-05-11', 'színmű', NULL),
(4214, 'A jegyzőkönyv', NULL, '2020-11-14', NULL, NULL),
(4215, 'Minden egér szereti a sajtot', 38, '2013-03-29', 'bábjáték', 'magyar'),
(4216, 'A vágy villamosa', 8, '2014-10-10', 'táncelőadás', 'magyar'),
(4217, 'iO - A csodák birodalma', 147, '2012-05-13', NULL, 'magyar'),
(4218, 'A négyszögletű kerek erdő', 6, '2015-12-05', 'mesejáték', 'magyar'),
(4219, 'Kulcskeresők', 44, '2015-03-13', NULL, 'magyar'),
(4220, 'Egy disznótor pontos leírása', 32, '2017-12-29', NULL, NULL),
(4221, 'Ha beüt a ménkű!', 168, '2019-05-11', NULL, NULL),
(4222, 'A vágy villamosa', 181, '2017-11-03', 'dráma', 'magyar'),
(4223, 'Bolha a fülbe', 152, '2018-12-15', 'bohózat', NULL),
(4224, 'VI. Nagy Iván Nemzetközi Balettgála', 150, '2020-05-10', 'balett', NULL),
(4225, 'Fame - A hírnév ára', 95, '2021-09-11', 'musical', NULL),
(4226, 'Hessmese', 134, '2017-09-21', 'mesejáték', 'magyar'),
(4227, 'A Szemüveges Szirén', 116, '2019-10-06', NULL, NULL),
(4228, 'A helység kalapácsa', 157, '2014-12-20', 'színmű', 'magyar'),
(4229, 'Vritti', 8, '2013-11-08', 'táncelőadás', 'magyar'),
(4230, 'A mi falunk', NULL, '2021-08-24', NULL, NULL),
(4231, 'A nagy hadronütköztető', NULL, '2021-09-14', NULL, NULL),
(4232, 'Heinrich von Kleist: Pentheszileia', 110, '2019-02-15', NULL, NULL),
(4233, 'Játék a kastélyban', 95, '2019-10-05', 'komédia', NULL),
(4234, 'Császárok napja: Pertinax', 9, '2015-03-25', 'színmű', 'magyar'),
(4235, 'BOEING, BOEING – leszállás Párizsban', 59, '2018-10-14', 'vígjáték', NULL),
(4236, 'Vőlegény', 185, '2014-02-07', 'komédia', 'magyar'),
(4237, 'Óz', 185, '2019-11-06', 'mesemusical', NULL),
(4238, 'Szeszélyes nyár', 157, '2015-12-12', 'színmű', 'magyar'),
(4239, 'A Vágy nevű villamos', 95, '2019-04-27', 'színmű', NULL),
(4240, 'Ilka titka', 88, '2021-10-09', 'bábjáték', NULL),
(4241, 'A gömbfejűek és a csúcsfejűek avagy A gazdag a gazdaggal társul szívesen', 140, '2012-10-01', 'színmű', 'magyar'),
(4242, 'Karrier, avagy a lónak négy lába van, mégis...', 122, '2012-01-06', 'komédia', 'magyar'),
(4243, 'Áldja meg az Isten, Mr. Vonnegut', 96, '2012-03-10', 'színmű', 'magyar'),
(4244, 'itcomesitgoes', 91, '2013-11-30', 'táncelőadás', 'magyar'),
(4245, 'Párcsere', 134, '2014-10-04', 'komédia', 'magyar'),
(4246, 'Amadeus', 95, '2015-02-21', 'színmű', 'magyar'),
(4247, 'Apropó', 133, '2013-03-08', 'táncelőadás', 'magyar'),
(4248, 'Az éjszaka csodái - tánc, tüll, tablet', 133, '2015-04-16', 'táncelőadás', 'magyar'),
(4249, 'Szikra Ferkó', 113, '2013-03-10', 'gyermekelőadás', 'magyar'),
(4250, 'Boldogtalanok', 32, '2015-04-10', 'színmű', 'magyar'),
(4251, 'Csongorok, Tündék', 121, '2013-11-23', 'színmű', 'magyar'),
(4252, 'Az árnyék nélküli asszony', 22, '2014-05-25', 'opera', NULL),
(4253, 'AlkalMáté Trupp: Czukor Balázs', NULL, '2019-07-25', 'improvizáció', NULL),
(4254, 'Marica grófnő', 10, '2014-10-03', 'nagyoperett', 'magyar'),
(4255, 'A padlás', 73, '2015-10-16', 'mesemusical', 'magyar'),
(4256, 'Hippolyt, a lakáj', 181, '2013-09-27', 'zenés vígjáték', 'magyar'),
(4257, 'Malte Laurids Brigge feljegyzései', 36, '2022-01-28', NULL, NULL),
(4258, 'Pusztuló', 120, '2016-10-27', NULL, 'magyar'),
(4259, 'Könyvtári capriccio', 73, '2015-12-05', 'játék', 'magyar'),
(4260, 'Dolgok, amikért érdemes élni', 114, '2020-02-22', NULL, NULL),
(4261, 'Almaszósz', 83, '2013-11-09', 'zenés mesejáték', 'magyar'),
(4262, 'Júlia - Párbeszéd a szerelemről', NULL, '2018-12-15', 'monodráma', NULL),
(4263, 'Az élet kapuja', 162, '2020-02-28', NULL, NULL),
(4264, 'Egérfogó', 95, '2021-11-06', 'krimi', NULL),
(4265, 'Félelem és fogcsikor', 140, '2018-01-21', 'zenés előadás', NULL),
(4266, 'Strip-tease', 64, '2017-04-29', 'komédia', 'magyar'),
(4267, 'A bajnok', 34, '2016-03-19', NULL, 'magyar'),
(4268, 'Vizitáció', 8, '2014-09-19', 'táncelőadás', 'magyar'),
(4269, 'Közelebb', 152, '2021-10-02', NULL, NULL),
(4270, 'Nevető antikvitás', 122, '2014-04-10', 'irodalmi est', 'magyar'),
(4271, 'A Montmartre-i ibolya', 99, '2018-10-12', 'operett', NULL),
(4272, 'K-Arcok: Harslet // Dark Matter', 78, '2021-12-04', 'táncelőadás', NULL),
(4273, 'Lélegezz', 34, '2017-02-25', NULL, 'magyar'),
(4274, 'Misu háborúja', NULL, '2018-10-15', NULL, NULL),
(4275, 'Dr - A Te Álmod', 57, '2015-10-03', 'színmű', 'magyar'),
(4276, 'Vakság', 101, '2012-04-27', NULL, 'magyar'),
(4277, 'A szűz és a szörny', 50, '2015-09-21', 'tragikomédia', 'magyar'),
(4278, 'Szerelmes Shakespeare', 118, '2017-06-09', 'musical', 'magyar'),
(4279, 'István, a király', 50, '2013-09-27', 'rockopera', 'magyar'),
(4280, 'Terülj, terülj, asztalkám!', 4, '2013-10-26', 'gyermekelőadás', 'magyar'),
(4281, 'Nevetséges sötétség', 145, '2021-07-06', NULL, NULL),
(4282, 'Tesztoszteron', 66, '2012-04-20', NULL, NULL),
(4283, 'A velencei kalmár', 140, '2018-09-15', NULL, NULL),
(4284, 'Valami bűzlik', 102, '2021-09-18', NULL, NULL),
(4285, 'Apátlanul (Platonov)', 134, '2017-01-07', 'színmű', 'magyar'),
(4286, 'Angyalok Amerikában', 157, '2012-09-28', 'színmű', 'magyar'),
(4287, 'Momo', 122, '2013-01-10', 'színmű', 'magyar'),
(4288, 'Komámasszony, hol a stukker?', 17, '2015-07-30', 'vígjáték', 'magyar'),
(4289, 'Várj, míg sötét lesz', 68, '2016-04-01', 'krimi', 'magyar'),
(4290, 'Lili bárónő', 119, '2015-10-09', 'magyar', NULL),
(4291, 'Pinkó és a szegényember', 1, '2013-09-30', 'mesejáték', 'magyar'),
(4292, 'European Freaks - Üzenjük Brüsszelnek!', 127, '2019-11-26', NULL, NULL),
(4293, 'Antigoné', 24, '2015-10-30', 'színmű', 'magyar'),
(4294, 'Manőver', 67, '2021-07-01', 'vígjáték', NULL),
(4295, 'Évek vándora', 99, '2015-02-20', NULL, 'magyar'),
(4296, 'Lúdas Matyi', 88, '2015-10-03', NULL, NULL),
(4297, 'Gyilkosság meghirdetve', 129, '2018-10-27', NULL, NULL),
(4298, 'Utolsó vacsora - á la carte Góbi', 107, '2013-10-29', 'táncelőadás', 'magyar'),
(4299, 'Tisztújítás', 70, '2016-01-15', 'komédia', 'magyar'),
(4300, 'A velencei kalmár', 32, '2019-03-29', 'vígjáték', NULL),
(4301, 'Lear halála', 32, '2018-09-28', 'dráma', NULL),
(4302, 'Csongor és Tünde', 157, '2012-10-06', 'színmű', 'magyar'),
(4303, 'Angster re-generációk', 63, '2017-02-22', NULL, 'magyar'),
(4304, 'A legyek', 20, '2019-12-20', NULL, NULL),
(4305, 'Kinek az ég alatt már senkije sincsen', 60, '2017-03-16', NULL, 'magyar'),
(4306, 'A tizedes meg a többiek', 83, '2016-09-30', 'komédia', 'magyar'),
(4307, 'Csíkos csoda', 139, '2017-10-14', 'csecsemő színház', 'magyar'),
(4308, 'Pillangókisasszony', 82, '2013-07-26', 'opera', NULL),
(4309, 'Közeleg az idő', 95, '2018-09-15', 'komédia', NULL),
(4310, 'Odüsszeusz 2.0, avagy dráma dráma nélkül', NULL, '2021-09-07', 'dráma', NULL),
(4311, 'Rajkók', 202, '2020-04-18', 'musical', NULL),
(4312, 'Ten_Net', 11, '2019-04-24', 'táncelőadás', NULL),
(4313, 'Danny mesél: Kodzsugukila, a boszorkány', 151, '2017-05-21', 'zenés mesejáték', 'magyar'),
(4314, 'Farkasbarkas és Rókakoma', 151, '2019-05-12', 'bábjáték', NULL),
(4315, 'A salemi boszorkányok', 9, '2018-05-11', 'dráma', NULL),
(4316, 'Vadméz', 117, '2019-06-24', 'komédia', NULL),
(4317, 'A csillagok csókja', 151, '2019-02-03', 'bábjáték', NULL),
(4318, 'Nyam-nyami', 116, '2016-03-20', NULL, NULL),
(4319, 'Dekameron', 173, '2014-05-09', 'táncelőadás', 'magyar'),
(4320, 'Mondj egy mesét', 160, '2018-01-13', 'improvizáció', NULL),
(4321, 'Catulli Carmina & Carmina Burana', 82, '2015-07-10', 'táncjáték', 'magyar'),
(4322, 'Lúdas Matyi', 73, '2021-08-28', 'zenés mesejáték', NULL),
(4323, 'Édes Anna', 76, '2013-01-19', 'színmű', 'magyar'),
(4324, 'Kőműves Kelemen', 165, '2012-09-14', 'zenés színmű', NULL),
(4325, 'Anima', 140, '2019-12-11', 'bábelőadás', NULL),
(4326, 'Voyager 3', 133, '2014-11-21', NULL, 'magyar'),
(4327, 'SzentivánéjiÁ!', 32, '2020-11-07', 'vígjáték', NULL),
(4328, 'Vas Laci!', 112, '2013-04-14', 'gyermekelőadás', 'magyar'),
(4329, 'Anconai szerelmesek', 56, '2013-03-22', 'zenés komédia', 'magyar'),
(4330, 'Énekes madár', 129, '2013-10-05', 'színmű', 'magyar'),
(4331, 'Apa', 68, '2015-02-12', 'színmű', 'magyar'),
(4332, 'Őszintén szólva', 122, '2020-10-09', 'komédia', NULL),
(4333, 'Kis hölgy a Maximból', 9, '2020-02-14', 'bohózat', NULL),
(4334, 'Álomszövők', 151, '2016-04-10', NULL, NULL),
(4335, 'Tatiana', 173, '2018-03-09', 'táncelőadás', NULL),
(4336, 'Monocrossing', 78, '2013-03-01', 'táncelőadás', 'magyar'),
(4337, 'Kerek Istenfája...', 145, '2015-08-19', 'táncelőadás', 'magyar'),
(4338, 'A régi nyár', 29, '2013-11-27', 'operett', 'magyar'),
(4339, 'Drótos Jankó', 119, '2018-04-20', 'mesejáték', NULL),
(4340, 'Tartuffe', 76, '2015-10-30', 'színmű', 'magyar'),
(4341, 'Diótörő herceg', 129, '2017-10-13', NULL, 'magyar'),
(4342, 'Lúdas Matyi', 112, '2019-05-26', 'bábjáték', NULL),
(4343, 'Toldi', 12, '2015-01-05', 'zenés játék', 'magyar'),
(4344, 'A bűn paradoxona, avagy az apokalipszis magányos lovasai', 122, '2019-04-18', 'misztikus thriller', NULL),
(4345, 'A kaukázusi krétakör', 43, '2016-04-15', NULL, NULL),
(4346, 'Mezítláb a parkban', 163, '2016-02-12', 'vígjáték', 'magyar'),
(4347, 'Die Päpstin - A pápanő', 102, '2018-09-29', 'színmű', NULL),
(4348, 'Monte Cristo grófja', 195, '2012-03-03', NULL, 'magyar'),
(4349, 'Whisky esővízzel', 121, '2014-09-19', 'zenés komédia', 'magyar'),
(4350, 'A mizantróp', NULL, '2019-10-11', 'komédia', NULL),
(4351, 'A vigéc', 1, '2014-02-22', 'bohózat', 'magyar'),
(4352, 'Leszállás Párizsban', NULL, '2018-04-06', NULL, NULL),
(4353, 'Tokaji aszú', 44, '2015-10-09', 'zenés vígjáték', 'magyar'),
(4354, 'Kávécsarnok / Május', 23, '2012-04-27', 'színmű', 'magyar'),
(4355, 'Shadows', 171, '2016-05-06', NULL, 'spanyol'),
(4356, 'Válogatáskazi – avagy - szomjas fiúk tolják a kakaót', NULL, '2020-10-15', NULL, NULL),
(4357, 'Hétköznapi csoda', 52, '2019-11-22', NULL, NULL),
(4358, 'Jancsi és Juliska', 83, '2017-11-29', 'meseopera', 'magyar'),
(4359, 'A Jóka ördöge', 27, '2017-09-24', 'bábelőadás', 'magyar'),
(4360, 'A revizor', 148, '2015-02-14', 'komédia', 'magyar'),
(4361, 'Császárok napja: Maximinus és Gordianus', 9, '2016-11-06', NULL, 'magyar'),
(4362, 'A rézerdő lakói', 76, '2015-10-20', 'mesejáték', 'magyar'),
(4363, 'Tündér Míra', 83, '2016-11-05', 'mesejáték', 'magyar'),
(4364, 'A csapodár madárka', 73, '2021-08-21', 'komédia', NULL),
(4365, 'Boszorkányok a Bármi utcából', 196, '2019-02-14', 'mesejáték', NULL),
(4366, 'A kék pék', 129, '2017-09-11', NULL, 'magyar'),
(4367, 'A királynő aranyból van (Stuart Mária)', 162, '2016-05-20', 'dráma', 'magyar'),
(4368, 'Színésznők', 185, '2012-10-10', 'színmű', 'magyar'),
(4369, 'Különös házasság', NULL, '2018-09-22', 'színmű', 'magyar'),
(4370, 'Kabaré', 43, '2015-04-13', 'zenés előadás', NULL),
(4371, 'Hullám és gumikötél', 34, '2012-05-19', NULL, 'magyar'),
(4372, 'Éden földön (Hany Istók legendája)', 136, '2015-09-25', 'színmű', 'magyar'),
(4373, 'Páratlan páros', 109, '2020-03-10', 'komédia', NULL),
(4374, 'A kripli', 9, '2015-09-25', 'dráma', 'magyar'),
(4375, 'III. Richard', 182, '2020-10-08', 'dráma', NULL),
(4376, 'Rest mese', 116, '2017-02-12', 'bábjáték', 'magyar'),
(4377, 'Nyolc nő', 9, '2016-02-12', 'bűnügyi komédia', 'magyar'),
(4378, 'Les Enfants Terribles (Veszedelmes Éden )', NULL, '2021-11-13', 'táncelőadás', NULL),
(4379, 'Mephisto', 157, '2013-05-10', 'színjáték', 'magyar'),
(4380, 'Ady / Petőfi', 101, '2013-01-22', NULL, 'magyar'),
(4381, 'Folyóügy', NULL, '2021-05-25', NULL, NULL),
(4382, 'Janika', 121, '2012-12-14', 'vígjáték', 'magyar'),
(4383, '1,7', 91, '2016-11-12', 'táncelőadás', 'magyar'),
(4384, 'Tizenkét dühös ember', 95, '2015-10-10', NULL, 'magyar'),
(4385, 'Csoportterápia', 185, '2014-03-14', 'mjuzikelkámedi', 'magyar'),
(4386, 'Dandin György', 32, '2012-11-30', 'vígjáték', 'magyar'),
(4387, 'Gardénia', 134, '2020-08-08', 'színmű', NULL),
(4388, 'A legvidámabb barakk', 79, '2013-12-28', 'zenés előadás', 'magyar'),
(4389, 'Apácák', 148, '2012-10-06', 'musical', 'magyar'),
(4390, 'Holle anyó', 119, '2013-11-05', 'szlovák', NULL),
(4391, 'Ványa bácsik, avagy Nyaralj ködben', 36, '2017-12-13', 'zenés előadás', 'magyar'),
(4392, 'Minden dolgok könyve', 28, '2017-04-01', NULL, NULL),
(4393, 'Dog story', 114, '2018-05-19', 'musical', NULL),
(4394, 'Turandot', 190, '2016-03-13', NULL, 'magyar'),
(4395, 'Segítség! Én vagyok a feleségem!', 56, '2022-02-19', 'vígjáték', NULL),
(4396, 'Ecset és kalapács', 9, '2014-11-04', 'felolvasószínház', 'magyar'),
(4397, 'Álmomban megcsaltál', 152, '2021-05-15', NULL, NULL),
(4398, 'Meanwhile in Kansas', 161, '2013-01-10', 'színmű', 'magyar'),
(4399, 'Így beszélnek ők - Írók stand-upolnak / Cabaret Ma sorozat részeként', 71, '2014-03-10', NULL, 'magyar'),
(4400, 'Kampec III.', 153, '2014-10-18', 'színmű', 'magyar'),
(4401, 'Pinokkió', 31, '2013-08-30', 'színmű', 'magyar'),
(4402, 'Karácsonyi álom', 168, '2017-11-19', 'zenés mesejáték', 'magyar'),
(4403, 'Bors néni, Bors!', 122, '2013-09-30', 'gyermekelőadás', 'magyar'),
(4404, 'Dödölle', 4, '2015-01-24', 'bábjáték', NULL),
(4405, 'Chioggiai csetepaté', 148, '2020-03-07', 'vígjáték', NULL),
(4406, 'Lép és Idő - SVUNG táncest', 124, '2014-05-04', 'mozgásszínház', 'magyar'),
(4407, 'Mit ér, ha? – zenés női varieté a mulandóságról', 89, '2021-09-17', 'zenés előadás', NULL),
(4408, 'Isten pénze', 108, '2012-12-21', 'musical', NULL),
(4409, 'Hatan pizsamában', 114, '2013-10-18', 'vígjáték', 'magyar'),
(4410, 'Átriumklorid', 54, '2014-04-02', 'színmű', 'magyar'),
(4411, 'Bűn és bűnhődés', 160, '2016-10-17', NULL, NULL),
(4412, 'Megadom magam', 111, '2016-04-10', 'zenés előadás', 'magyar'),
(4413, 'Válaszúton', 142, '2015-05-12', 'színmű', 'magyar'),
(4414, 'Fear the szaknévsor!', 71, '2016-12-03', 'stand-up comedy', 'magyar'),
(4415, 'Terror', 134, '2021-11-12', NULL, NULL),
(4416, 'A nagy négyes', 102, '2019-11-22', NULL, NULL),
(4417, 'Párnaember', 52, '2018-12-11', NULL, NULL),
(4418, 'Emilia Galotti', 129, '2016-11-19', 'tragédia', 'magyar'),
(4419, 'Maja, a méhecske', 75, '2014-12-10', 'bábjáték', NULL),
(4420, 'Péter és a farkas', 4, '2012-04-21', 'zenés játék', 'magyar'),
(4421, 'A palacsintás király', 109, '2014-11-05', 'zenés mesejáték', 'magyar'),
(4422, 'Dunakanyar', 73, '2017-11-11', NULL, NULL),
(4423, 'Baal', 60, '2019-03-01', NULL, NULL),
(4424, 'Szökevény csillagok', 23, '2014-11-14', 'daljáték', 'magyar'),
(4425, 'A Csizmadia, a Szélkirály és a Nyúlpásztor esete', 27, '2019-09-15', 'bábjáték', NULL),
(4426, 'Vőlegény', 68, '2017-09-15', NULL, 'magyar'),
(4427, 'Anna Karenina', 199, '2017-02-24', 'táncjáték', NULL),
(4428, 'Holt lelkek', 190, '2013-01-27', 'színmű', 'magyar'),
(4429, 'Csongor és Tünde', 134, '2015-02-13', 'mesejáték', 'magyar'),
(4430, 'Földes est', NULL, '2018-04-10', NULL, NULL),
(4431, 'Orlando', 122, '2016-03-11', 'színmű', 'magyar'),
(4432, 'ÖRÖMKÖNNY(V)EIM', 79, '2017-11-19', NULL, 'magyar'),
(4433, 'Három lélek egy szerelemben', 123, '2015-02-07', 'színmű', 'magyar'),
(4434, 'e föld befogad avagy SZÁMODRA HELY', 20, '2014-10-03', 'színmű', 'magyar'),
(4435, 'Hamlet', 13, '2014-10-03', 'bábjáték', NULL),
(4436, 'Vak-töltények', 123, '2015-09-25', NULL, 'magyar'),
(4437, 'Orosz népi posta', 6, '2014-12-05', 'komédia', 'magyar'),
(4438, 'Kislányom, Anne Frank', 193, '2014-04-25', 'táncelőadás', 'magyar'),
(4439, 'IV. Henrik', 32, '2014-10-03', 'dráma', 'magyar'),
(4440, 'A kéjenc útja', 22, '2015-01-18', 'opera', NULL),
(4441, 'Üvöltő szelek', 199, '2019-10-18', 'táncjáték', NULL),
(4442, 'Kaland a nagy családerdőben', 50, '2021-11-02', 'mesejáték', NULL),
(4443, 'A velencei kalmár', 70, '2014-05-02', 'színmű', 'magyar'),
(4444, 'Alkésztisz', 165, '2013-10-09', 'színmű', 'magyar'),
(4445, 'Vízkereszt, vagy bánom is én', 67, '2014-07-10', 'zenés vígjáték', 'magyar'),
(4446, 'Asszony a fronton', 170, '2014-12-05', 'színmű', 'magyar'),
(4447, 'A csúnya', 48, '2012-03-31', 'komédia', NULL),
(4448, 'Óz, a nagy varázsló', 13, '2012-03-11', NULL, 'magyar'),
(4449, 'Kurázsi mama és gyermekei', 129, '2021-10-16', NULL, NULL),
(4450, 'A Nagy Romulus', 32, '2015-10-09', 'történelmi színmű', 'magyar'),
(4451, 'Edith és Marlene', 201, '2013-12-05', 'zenés előadás', 'magyar'),
(4452, 'Kalandok Zenebóniában', 95, '2013-11-14', 'zenés mesejáték', 'magyar'),
(4453, 'Sándor Mátyás', 130, '2020-09-25', NULL, NULL),
(4454, 'Szentivánéji álom', 37, '2014-05-20', NULL, 'magyar'),
(4455, 'Minden negyedik', 201, '2021-11-08', NULL, NULL),
(4456, 'Szent Imre', NULL, '2021-08-21', NULL, NULL),
(4457, 'Összkomfort', 171, '2015-10-12', NULL, 'magyar'),
(4458, 'Hamlet', 157, '2012-03-16', 'színmű', 'magyar'),
(4459, 'Szélkötő Kalamona', 4, '2016-04-16', NULL, NULL),
(4460, 'Harlekin kalandjai', 13, '2012-09-30', 'mesejáték', 'magyar'),
(4461, 'Az ügynök halála', 129, '2012-05-05', NULL, 'magyar'),
(4462, 'Székek', 83, '2018-04-27', NULL, NULL),
(4463, 'Hazafit nekünk!', 157, '2012-04-27', 'színmű', 'magyar'),
(4464, 'Badu mama gyermekei', 151, '2020-09-25', 'bábelőadás', NULL),
(4465, 'Ólomkatona', 56, '2019-12-08', 'zenés mesejáték', NULL),
(4466, 'Zéró Gravitáció', 156, '2014-10-11', NULL, 'magyar'),
(4467, 'Hajtűkanyar autósiskola', 200, '2021-09-01', NULL, NULL),
(4468, 'Örömöcskék, vétkecskék', 26, '2016-02-10', NULL, 'magyar'),
(4469, 'Frankenstein', 83, '2015-02-13', 'színmű', 'magyar'),
(4470, 'Farkasszem', 14, '2014-11-08', 'zenés előadás', 'magyar'),
(4471, 'Bella Figura', 60, '2021-10-22', 'komédia', NULL),
(4472, 'A fesztivál csillagai', 156, '2014-01-18', 'cirkuszi előadás', 'magyar'),
(4473, 'Szent szörnyetegek', 157, '2017-12-16', NULL, 'magyar'),
(4474, 'Részvétel', 169, '2014-05-21', 'zenés előadás', 'magyar'),
(4475, 'Csingiling és a kalózok', 56, '2018-09-30', 'mesejáték', NULL),
(4476, 'A nagy füzet', 14, '2013-02-15', NULL, 'magyar'),
(4477, 'Moha és Páfrány', 131, '2018-10-13', 'mesejáték', NULL),
(4478, 'Bolero', 198, '2020-02-28', 'balett', NULL),
(4479, 'Mellékhatás', 79, '2016-09-16', 'színmű', 'magyar'),
(4480, 'Lulu', 11, '2016-03-17', 'táncelőadás', 'magyar'),
(4481, 'Violante és a bíró', 159, '2014-09-06', 'monodráma', 'magyar'),
(4482, 'Julius Caesar', 170, '2014-12-06', 'színmű', 'magyar'),
(4483, 'A K-Arcok sorozat második szakmai bemutatója', 78, '2016-02-17', 'táncelőadás', 'magyar'),
(4484, 'Gyere haza, Mikkamakka!', 38, '2020-02-16', 'bábjáték', NULL),
(4485, 'Agytakarítás (személyest)', 64, '2014-12-27', 'színmű', 'magyar'),
(4486, 'Vihar', 95, '2012-03-02', NULL, 'magyar'),
(4487, 'A salemi boszorkányok', 76, '2016-02-20', 'dráma', 'magyar'),
(4488, 'Levitáció', 78, '2012-11-16', 'táncelőadás', 'magyar'),
(4489, 'Állampolgári ismeretek', 31, '2013-08-15', NULL, NULL),
(4490, 'Lököttek', 121, '2019-09-27', 'komédia', NULL),
(4491, 'Bridge/A nagy játszma', 149, '2015-11-22', 'vígjáték', 'magyar'),
(4492, 'The Table', 173, '2014-04-17', 'színpadi játék', NULL),
(4493, 'Cirkuszi kavalkád', 156, '2012-09-22', NULL, 'magyar'),
(4494, 'Numera! - Fókuszban a HÁRMAS számMaladype Színház', NULL, '2015-02-08', NULL, 'magyar'),
(4495, 'A titkos házasság', 32, '2015-01-16', 'vígopera', NULL),
(4496, 'A csengő', 134, '2021-07-23', 'vígopera', NULL),
(4497, 'Fenevadak', 199, '2015-05-10', 'táncelőadás', NULL),
(4498, 'Jónás könyve', 181, '2021-06-25', NULL, NULL),
(4499, 'Robinson és Crusoe', 109, '2014-12-16', 'színjáték', 'magyar'),
(4500, 'Túl a Maszat-hegyen', 192, '2018-05-26', 'mesejáték', NULL),
(4501, 'Bihari', 34, '2016-02-27', NULL, 'magyar'),
(4502, 'Ez is József Attila!', 102, '2017-10-09', NULL, 'magyar'),
(4503, 'Anyegin', 83, '2014-11-22', 'színház és tánc', 'magyar'),
(4504, 'Tükör rezgés', 123, '2014-04-29', 'táncelőadás', 'magyar'),
(4505, 'Pastorale', 23, '2015-12-17', NULL, 'magyar'),
(4506, 'Mindenki Egerszegre!', 201, '2017-07-08', NULL, 'magyar'),
(4507, 'Don Quijote avagy Alonso Quijana útja a végtelenbe', 13, '2015-04-11', 'bábjáték', NULL),
(4508, 'A krétakör-ítélet', 24, '2016-03-20', NULL, 'magyar'),
(4509, 'Az ablak', 4, '2015-04-24', 'bábjáték', NULL),
(4510, 'Subsurface', 188, '2017-09-13', 'táncelőadás', NULL),
(4511, 'Rév Fülöp', 116, '2014-02-09', 'bábjáték', 'magyar'),
(4512, 'Két Verona Kft.', 201, '2017-07-01', 'zenés vígjáték', 'magyar'),
(4513, 'IZP-estek - Thury Zita: Reset', NULL, '2020-11-30', 'táncelőadás', NULL),
(4514, 'Baby Boy / József-legenda', 137, '2016-03-18', 'táncjáték', 'magyar'),
(4515, 'Gyilkosság az Ó utcában!', 90, '2019-11-09', 'improvizáció', NULL),
(4516, 'Na most akkor', NULL, '2018-05-27', NULL, NULL),
(4517, 'Füled érjen bokáig!', 107, '2016-05-22', 'táncelőadás', 'magyar'),
(4518, 'Heisenberg', NULL, '2018-01-24', NULL, NULL),
(4519, 'Farsang falshang nélkül', 30, '2013-02-22', 'zenés összeállítás', 'magyar'),
(4520, 'Keménykalap és krumpliorr', 44, '2020-09-20', 'mesejáték', NULL),
(4521, 'Kutyaportéka - kisvárosi kórkép', NULL, '2019-09-07', NULL, NULL),
(4522, 'Pacsirta', 83, '2019-12-14', 'színmű', NULL),
(4523, 'Műszaki hiba', 5, '2016-03-12', 'kabaré', 'magyar'),
(4524, 'Csak szólni egy szót mint ember', 157, '2017-04-03', 'önálló est', 'magyar'),
(4525, 'Made in Hungária', 122, '2015-12-18', 'musical', 'magyar'),
(4526, 'Vacsora öt személyre', 30, '2019-05-17', NULL, NULL),
(4527, 'Amrita', 65, '2013-11-26', 'táncelőadás', 'magyar'),
(4528, 'In Memoriam Borbély Szilárd: Szemünk előtt vonulnak el', 169, '2014-05-26', 'színmű', 'magyar'),
(4529, 'Folyóügy', 36, '2017-09-29', NULL, 'magyar'),
(4530, 'Jónások - Babits LIVE!', NULL, '2021-09-14', NULL, NULL),
(4531, 'A test emlékezete - hommage a Magdalena Abakanowicz', 158, '2020-10-27', 'táncelőadás', NULL),
(4532, 'Kézről kézre', 118, '2014-01-31', 'bohózat', 'magyar'),
(4533, 'Három szótag', 79, '2017-04-26', 'zenés előadás', 'magyar'),
(4534, 'Reggeli dioszauruszokkal', 144, '2017-12-15', NULL, 'magyar'),
(4535, 'Találkozás', 60, '2015-10-23', NULL, 'magyar'),
(4536, 'Volpone', 23, '2016-09-23', 'komédia', 'magyar'),
(4537, 'Operácska - Figaro házassága', 32, '2014-10-09', 'opera', NULL),
(4538, 'Bagatell - gondolatok egy pincében', 34, '2013-03-02', NULL, NULL),
(4539, 'Téli utazás', 170, '2014-01-04', 'színmű', 'magyar'),
(4540, 'Száz ölelés', 135, '2012-09-19', 'táncelőadás', 'magyar'),
(4541, 'Moha és Páfrány', 88, '2016-01-30', NULL, NULL),
(4542, 'III. Richárd', 190, '2018-02-18', NULL, NULL),
(4543, 'Kaland a nagy családerdőben', 50, '2021-11-02', 'mesejáték', NULL),
(4544, 'Lolita', 191, '2017-03-23', 'táncelőadás', NULL),
(4545, 'A hülyéje', 95, '2017-07-16', NULL, 'magyar'),
(4546, 'Trianon', NULL, '2018-06-22', NULL, NULL),
(4547, 'Az öldöklés istene', 64, '2018-03-29', 'bohózat', NULL),
(4548, 'Kistigris és Kismackó', 43, '2016-02-25', NULL, NULL),
(4549, 'Huszka gála', 29, '2020-11-10', 'zenés előadás', NULL),
(4550, 'Macskajáték', 30, '2017-01-07', NULL, NULL),
(4551, 'Rozsda lovag és a kísértet', 136, '2014-02-22', 'gyermek musical', 'magyar'),
(4552, 'Amphitryon', 130, '2014-09-27', 'tragikomédia', 'magyar'),
(4553, 'Úrilány szobát keres', 56, '2021-11-20', NULL, NULL),
(4554, 'A tavasz ébredése', 130, '2022-01-22', 'dráma', NULL),
(4555, 'Face Nord', 173, '2014-02-21', 'újcirkusz', NULL),
(4556, 'Az ügynök halála', 185, '2018-03-02', 'dráma', NULL),
(4557, 'Komcsi kabaré', 64, '2012-03-04', 'kabaré', 'magyar'),
(4558, 'Imádok férjhez menni', 56, '2016-11-19', 'zenés vígjáték', 'magyar'),
(4559, 'Coppélia', 22, '2014-10-30', 'táncjáték', 'magyar'),
(4560, 'Szerelem', 79, '2016-04-05', NULL, 'magyar'),
(4561, 'Egy csók és más semmi', 168, '2018-03-10', NULL, NULL),
(4562, 'Góbi Rita: Freestyle', 107, '2019-04-10', NULL, NULL),
(4563, 'Szerelmünk, Sisi', 64, '2020-09-24', 'monodráma', NULL),
(4564, 'BajuSS', 62, '2018-05-10', NULL, NULL),
(4565, 'Óriáscsecsemő', 134, '2015-02-20', NULL, 'magyar'),
(4566, 'Egy őrült naplója', 68, '2016-07-22', NULL, 'magyar'),
(4567, 'Bob herceg', 23, '2013-12-13', 'nagyoperett', 'magyar'),
(4568, 'Bob herceg', 148, '2019-04-13', 'operett', NULL),
(4569, 'Az ügynök halála', 70, '2016-03-11', 'dráma', 'magyar'),
(4570, 'Függönyt fel!', 143, '2021-03-27', 'vígjáték', NULL),
(4571, 'Tanulmány a nőkről', 118, '2014-04-19', 'musical', 'magyar'),
(4572, 'Noir', 42, '2019-01-17', NULL, NULL),
(4573, 'Don Giovanni', 122, '2015-04-09', 'opera', NULL),
(4574, 'Anamnesis', 34, '2012-04-27', NULL, 'magyar'),
(4575, 'VIII. Henrik', 94, '2014-02-13', 'színházi közvetítés', NULL),
(4576, 'A miniszter félrelép', 99, '2021-06-05', 'bohózat', NULL),
(4577, 'A tribádok éjszakája', 76, '2014-10-03', 'színjáték', 'magyar'),
(4578, 'Kék nagyapó története', 131, '2013-10-18', 'gyermekelőadás', 'magyar'),
(4579, 'Júlia – párbeszéd a szerelemről', 44, '2018-12-15', 'monodráma', NULL),
(4580, 'A művésznő és rajongói', 190, '2018-10-19', NULL, NULL),
(4581, 'Tisztelt hazudozó!', 79, '2013-12-10', 'színmű', 'magyar'),
(4582, 'Zero Gravity', 87, '2013-04-23', 'balett', NULL),
(4583, 'Lux úr szabadalma, avagy a nyolcadik mennyország', 126, '2020-11-17', 'felolvasószínház', NULL),
(4584, 'A kutya különös esete az éjszakában', 32, '2016-11-25', NULL, 'magyar'),
(4585, 'Chicago', 35, '2013-12-29', 'zenés előadás', 'magyar'),
(4586, 'Aréna', 148, '2018-12-15', 'musical', NULL),
(4587, 'Francia rúdugrás', NULL, '2021-05-22', NULL, NULL),
(4588, 'Özönvíz előtt', 141, '2012-11-29', NULL, NULL),
(4589, 'Pyramidon', 78, '2012-05-04', 'táncelőadás', 'magyar'),
(4590, 'Übü király, vagy a lengyelek', 20, '2014-10-16', 'színmű', 'magyar'),
(4591, 'Aukció', 158, '2014-05-07', 'táncelőadás', 'magyar'),
(4592, 'Hegedűs a háztetőn', 32, '2019-11-29', 'musical', NULL),
(4593, 'Kivi', 43, '2013-02-21', NULL, 'magyar'),
(4594, 'Presszó szonáta', NULL, '2021-06-14', NULL, NULL),
(4595, 'Az áldozat', 162, '2015-05-15', 'dráma', 'magyar'),
(4596, 'Gergye Krisztián-Feledi János: Gravitáció', NULL, '2020-09-26', 'táncelőadás', NULL),
(4597, 'Kolónia - meneküléstörténetek', 127, '2021-08-25', NULL, NULL),
(4598, 'Rév Fülöp', 83, '2014-10-11', 'színmű', 'magyar'),
(4599, 'Talking Head', 173, '2013-01-25', 'táncelőadás', NULL),
(4600, 'Szex - Pénz - Rock & Roll', 71, '2018-01-27', 'stand-up comedy', NULL),
(4601, 'Az üvegcipő', 70, '2019-06-07', 'színmű', NULL),
(4602, 'akezdetvége', 15, '2014-10-31', 'színmű', 'magyar'),
(4603, 'Fergeteges látogatás', 56, '2021-09-11', 'vígjáték', NULL),
(4604, 'Mi, szemüvegesek', 30, '2013-05-13', 'színmű', 'magyar'),
(4605, 'Gellérthegyi álmok', 152, '2016-11-05', NULL, 'magyar'),
(4606, 'Jóccakát, anya', 50, '2015-11-13', 'színmű', 'magyar'),
(4607, 'Semmi pánik', 100, '2015-12-04', 'komédia', 'magyar'),
(4608, 'Fehér Ló Fia', 38, '2016-11-27', NULL, NULL),
(4609, 'A szerelemről és más démonokról', 22, '2017-01-27', 'opera', NULL),
(4610, 'Equus', 9, '2020-01-31', NULL, NULL),
(4611, 'Mata Hari', 87, '2014-04-01', 'opera', 'magyar'),
(4612, 'Jelenetek 2 házasságból', 9, '2015-10-09', 'komédia', 'magyar'),
(4613, 'Biedermann és a gyújtogatók', 122, '2019-03-01', 'dráma', NULL),
(4614, 'Edmond', 122, '2022-01-07', 'vígjáték', NULL),
(4615, 'SignNature', 72, '2016-05-27', NULL, 'magyar'),
(4616, 'Tóték', 32, '2014-10-04', 'tragikomédia', 'magyar'),
(4617, 'Kartonpapa', 95, '2018-02-09', 'komédia', NULL),
(4618, 'Egerek könyve', 112, '2018-01-14', 'mesejáték', NULL),
(4619, 'A szerető álma', 79, '2012-11-15', 'zenés összeállítás', 'magyar'),
(4620, 'Koldus és királyfi', 95, '2013-12-22', 'musical', 'magyar'),
(4621, 'Hamu és gyémánt', 56, '2016-11-12', 'zenés előadás', 'magyar'),
(4622, 'A vihar', 157, '2019-12-20', NULL, NULL),
(4623, 'A haza', 38, '2014-12-07', 'gyermekelőadás', NULL),
(4624, 'Szépséges Mezőség', 178, '2021-10-24', 'táncelőadás', NULL),
(4625, 'Harper Regan', 21, '2015-10-08', 'színmű', 'magyar'),
(4626, 'Férfivallomások', 171, '2016-02-19', NULL, 'magyar'),
(4627, 'A feledékeny boszorkány', 116, '2015-09-27', 'bábelőadás', NULL),
(4628, 'De mi lett a nővel?', 36, '2017-02-26', 'játék', 'magyar'),
(4629, 'Párnaember', 124, '2014-01-11', 'színmű', 'magyar'),
(4630, 'Balfácánt vacsorára', 122, '2021-12-18', 'vígjáték', NULL),
(4631, 'Papírvirágok', 182, '2018-04-25', NULL, NULL),
(4632, 'Pillangókisasszony', 122, '2012-12-07', NULL, 'magyar'),
(4633, 'Guppi', 6, '2014-09-26', 'színmű', 'magyar'),
(4634, 'Hoffmann meséi', 23, '2014-04-11', 'opera', 'magyar'),
(4635, 'Háry János', 148, '2016-02-06', 'daljáték', 'magyar'),
(4636, 'Játszd újra, Sam!', 99, '2016-05-27', 'romantikus vígjáték ', 'magyar'),
(4637, 'Cseresznyéskert', 99, '2013-03-22', 'komédia', 'magyar'),
(4638, 'Pesti zsidó sanzon-világ', 64, '2021-09-26', 'zenés játék', NULL),
(4639, 'Organitórium', 63, '2020-02-04', 'interaktív előadás', NULL),
(4640, 'A kripli', 76, '2015-10-10', 'színmű', 'magyar'),
(4641, 'Fúrnitúr', 99, '2020-02-14', 'tragikomédia', NULL),
(4642, 'Ship of Fools (Bolondok hajója)', 77, '2012-10-11', 'táncelőadás', NULL),
(4643, 'Házasságszédelgő', 73, '2020-10-10', 'vígjáték', NULL),
(4644, 'A fény éjszakája', 109, '2013-09-27', 'dráma', 'magyar'),
(4645, 'Alhangya', 140, '2017-11-19', NULL, 'magyar'),
(4646, 'A plafonon túl', 182, '2019-07-20', NULL, NULL),
(4647, 'Tóték', 182, '2018-07-03', 'tragikomédia', NULL),
(4648, 'A védőbeszéd', NULL, '2017-04-19', NULL, 'magyar'),
(4649, 'Szélvész után is szép vagy', 170, '2022-01-21', NULL, NULL),
(4650, 'A falu rossza', 126, '2018-01-22', 'zenés komédia', 'magyar'),
(4651, 'Szörényi75 - István, a király', NULL, '2020-04-26', 'zenés előadás', NULL),
(4652, 'Trauma', NULL, '2018-05-04', NULL, NULL),
(4653, 'Hé, Magyar Joe!', 157, '2018-11-17', 'zenés előadás', NULL),
(4654, 'Backstage', 130, '2015-11-28', 'táncjáték', NULL),
(4655, 'Gombóc Artúr, a nagy utazó', 114, '2014-12-20', 'zenés előadás', 'magyar'),
(4656, 'Hat hét, hat tánc', 23, '2021-09-24', 'komédia', NULL),
(4657, 'Szentivánéjjel', 31, '2014-08-28', 'színmű', 'magyar'),
(4658, 'Ricsifiú: A szabolcsi Picasso - Kertész Ricsi önálló estje', NULL, '2020-01-10', 'stand-up comedy', NULL),
(4659, 'A hattyú', 20, '2018-03-24', 'komédia', NULL),
(4660, 'Majd, ha az eső eláll', 146, '2018-08-10', NULL, NULL),
(4661, 'A bolond lány', 121, '2015-10-09', 'vígjáték', 'magyar'),
(4662, 'A toll', 162, '2014-12-12', 'színmű', 'magyar'),
(4663, 'A föltámadás szomorúsága - Ady-est', 157, '2014-04-09', 'irodalmi est', 'magyar'),
(4664, 'Kísértetek', NULL, '2018-01-05', NULL, NULL),
(4665, 'A két egyetlen - Karinthy Frigyes nagy szerelmei', 118, '2021-04-16', NULL, NULL),
(4666, 'Márai naplói...', 44, '2016-02-20', 'önálló est', 'magyar'),
(4667, 'Othello Gyulaházán', 181, '2012-12-14', 'vígjáték', 'magyar'),
(4668, 'Tribunusok és költők', 50, '2015-10-26', NULL, NULL),
(4669, 'Osztályvigyázz!', 181, '2019-01-12', ' dráma', NULL),
(4670, 'Chatszoba - ahol a vágyak életre kelnek', 182, '2015-10-01', NULL, 'magyar'),
(4671, 'Őztestvérek', 27, '2014-10-12', 'bábjáték', NULL),
(4672, 'Mementó', 178, '2017-01-27', 'táncelőadás', NULL),
(4673, 'Muharay Musical Gála', 52, '2018-05-31', NULL, NULL),
(4674, 'Frankie (Frank Sinatra élete)', NULL, '2019-05-18', NULL, NULL);
INSERT INTO `eloadas` (`id`, `cim`, `szinhazid`, `datum`, `mufaj`, `nyelv`) VALUES
(4675, 'A szerelem zsoldosai', 71, '2015-10-29', 'zenés előadás', 'magyar'),
(4676, 'A dzsungel könyve', 70, '2015-06-12', 'musical', 'magyar'),
(4677, 'IETO', 173, '2012-05-24', NULL, NULL),
(4678, 'SUGAR - Van aki forrón szereti', 83, '2016-02-26', 'zenés előadás', 'magyar'),
(4679, 'Trio', NULL, '2020-04-09', NULL, NULL),
(4680, 'Én, Sally, táncolunk', 191, '2017-03-27', 'táncelőadás', NULL),
(4681, 'Csapodár madárka', 143, '2019-04-13', 'komédia', NULL),
(4682, 'Pantalone házassága (Commedia dell\'arte)', 95, '2012-09-25', 'színmű', 'magyar'),
(4683, 'A két pápa', 79, '2020-09-22', NULL, NULL),
(4684, 'Fesztikon', 156, '2016-01-16', 'cirkuszi előadás', NULL),
(4685, 'Tessék engem megmenteni', 129, '2014-04-12', 'zenés mesejáték', 'magyar'),
(4686, 'A vándorkutya', 170, '2018-10-05', NULL, NULL),
(4687, 'Pán Péter', 185, '2018-01-24', 'mesejáték', NULL),
(4688, 'Cigányprímás', 56, '2012-02-11', 'operett', 'magyar'),
(4689, 'Rómeó és Júlia', 146, '2018-07-21', NULL, NULL),
(4690, 'A pozsonyi metro - Kelet- európai egypercesek', 36, '2015-12-17', 'zenés est', 'magyar'),
(4691, 'Offroad', 57, '2016-03-11', NULL, 'magyar'),
(4692, 'Légy jó mindhalálig', 102, '2017-09-30', 'musical', 'magyar'),
(4693, 'A mindent látó királylány', 116, '2018-10-28', 'bábjáték', NULL),
(4694, 'Illatszertár', 134, '2020-01-03', 'romantikus komédia', NULL),
(4695, 'Josha', 169, '2012-03-07', NULL, 'magyar'),
(4696, 'KÉTség - Beszélj Rólam!', 44, '2015-05-09', NULL, 'magyar'),
(4697, 'Bál a Savoyban', 73, '2012-10-05', 'operett', 'magyar'),
(4698, 'Sirály', 32, '2014-02-01', 'dráma', 'magyar'),
(4699, 'Tóték - Tokaj', 100, '2019-10-26', NULL, NULL),
(4700, 'Luxemburg grófja', 29, '2017-11-04', 'operett', 'magyar'),
(4701, 'Vadászjelenetek Alsó-Bajorországból', NULL, '2018-09-28', 'dráma', NULL),
(4702, 'Édes Anna', 32, '2018-10-12', NULL, NULL),
(4703, 'Az Isten ostora', 122, '2013-02-15', 'színmű', 'magyar'),
(4704, 'Különterem', 64, '2017-03-20', NULL, 'magyar'),
(4705, 'Jónás könyve', 130, '2020-04-24', 'fizikai színház', NULL),
(4706, 'Lenka és Palkó', 139, '2018-04-21', 'bábjáték', NULL),
(4707, 'Bozótmély', 57, '2018-11-03', NULL, NULL),
(4708, 'A Mester és Margarita', 140, '2018-10-25', NULL, NULL),
(4709, 'János vitéz', 59, '2018-11-11', 'daljáték', NULL),
(4710, 'Szerelmek városa', 170, '2021-09-04', 'zenedráma', NULL),
(4711, 'Engedetlenek', 164, '2016-05-06', NULL, 'magyar'),
(4712, 'Az ember tragédiája', 122, '2012-03-02', NULL, 'magyar'),
(4713, 'És már senki sem - avagy tíz kicsi néger', 185, '2017-03-31', 'krimi', 'magyar'),
(4714, 'A köpenicki kapitány', 140, '2016-01-30', NULL, 'magyar'),
(4715, 'A megvádolt', 134, '2016-01-09', 'történelmi dráma', 'magyar'),
(4716, 'Kurázsi mama és gyermekei', 32, '2013-01-15', 'beavató színház', 'magyar'),
(4717, 'Drakula utolsó tánca', 154, '2016-07-08', 'táncelőadás', 'magyar'),
(4718, 'Pletykák', 95, '2017-04-15', 'bohózat', 'magyar'),
(4719, 'Hollywoodi Csillagok: Gyémántok Asszonya: Gábor Zsazsa', 56, '2017-09-30', NULL, 'magyar'),
(4720, 'A só', 113, '2016-09-25', 'mesejáték', NULL),
(4721, 'Kodály dialógok', 191, '2017-02-22', 'táncelőadás', NULL),
(4722, 'Óz, a nagy varázsló', 99, '2013-09-28', 'zenés mesejáték', 'magyar'),
(4723, 'Point of No Return', NULL, '2019-04-26', 'táncelőadás', NULL),
(4724, 'Fátyol nélkül', 170, '2014-10-11', 'színmű', 'magyar'),
(4725, 'Solus Christus', 178, '2017-12-07', 'táncelőadás', NULL),
(4726, 'Kafka a tengerparton', 157, '2019-04-05', NULL, NULL),
(4727, 'Egerek és emberek', 182, '2017-10-17', 'dráma', 'magyar'),
(4728, 'A varázsfuvola', 122, '2017-04-28', 'opera', NULL),
(4729, 'A tizedik menyasszony', 167, '2021-06-06', 'táncelőadás', NULL),
(4730, 'A víg özvegy', 44, '2013-10-18', 'operett', 'magyar'),
(4731, 'Peer Gynt', 20, '2012-03-17', 'színmű', 'magyar'),
(4732, 'Élektra', 30, '2019-03-30', NULL, NULL),
(4733, 'Vagabondó', 141, '2012-07-07', 'bábjáték', 'magyar'),
(4734, 'Mozgófénykép', 190, '2013-04-21', 'vígjáték', 'magyar'),
(4735, '152 lépés Auschwitz felé', NULL, '2019-08-12', 'monodráma', NULL),
(4736, 'Deep Dish', 173, '2014-05-16', 'táncelőadás', NULL),
(4737, 'Viktória', 29, '2013-01-25', 'operett', 'német'),
(4738, 'Léghajó a Bodza utcában', 131, '2019-02-09', 'bábjáték', NULL),
(4739, 'Lenni vagy nem', NULL, '2020-01-31', NULL, NULL),
(4740, 'Andromakhé', 20, '2020-10-09', NULL, NULL),
(4741, 'Egy nyári nap', 143, '2020-12-05', NULL, NULL),
(4742, 'G', 79, '2012-11-09', 'monodráma', 'magyar'),
(4743, 'Tündérkeresztanya', 116, '2016-02-28', NULL, NULL),
(4744, 'Bányavirág', 6, '2012-03-02', 'színmű', 'magyar'),
(4745, 'Sárkánytojás', 100, '2019-02-22', 'interaktív bábjáték', NULL),
(4746, 'Nem vagyok Miriam!', 170, '2019-02-27', NULL, NULL),
(4747, 'Cefre Palota - Bödőcs Tibor önálló előadása', 71, '2015-02-07', 'stand-up comedy', 'magyar'),
(4748, 'A varázskert', 131, '2018-09-22', 'bábjáték', NULL),
(4749, 'Megharapott / Bitten', 8, '2013-09-20', 'táncelőadás', 'magyar'),
(4750, 'Mimikri', 137, '2014-03-07', 'táncelőadás', NULL),
(4751, 'Sztárcsinálók', 9, '2018-03-16', 'rockopera', NULL),
(4752, 'A kolozsvári bíró', 50, '2012-10-12', 'zenés mesejáték', 'magyar'),
(4753, 'Jadviga párnája', 122, '2016-11-25', NULL, 'magyar'),
(4754, 'Falstaff', 22, '2013-09-21', 'opera', NULL),
(4755, 'game-changer', NULL, '2021-10-07', 'táncelőadás', NULL),
(4756, 'Liliom', 50, '2019-10-04', NULL, NULL),
(4757, 'Az álomkommandó', 60, '2013-10-26', 'dráma', 'magyar'),
(4758, 'A miniszter félrelép', 185, '2014-10-17', 'bohózat', 'magyar'),
(4759, 'Jancsi és Juliska', 113, '2013-10-13', 'gyermekelőadás', 'magyar'),
(4760, 'Johari beszélgetések', 91, '2013-05-10', 'táncelőadás', 'magyar'),
(4761, 'Madarat tolláról', 44, '2017-02-12', 'zenés előadás', 'magyar'),
(4762, 'NIKÉ, szabadságunk szobra', NULL, '2021-08-23', 'performance', NULL),
(4763, 'Kingdom', 11, '2021-05-31', 'táncelőadás', NULL),
(4764, 'Zene, New York, Szerelem', 12, '2015-02-28', 'musical', 'magyar'),
(4765, 'Kantarzsíni bolhapiac', 172, '2012-01-13', NULL, NULL),
(4766, 'Hamupipőke', 112, '2018-05-20', 'mesejáték', NULL),
(4767, 'A Név: Carmen', 129, '2017-09-29', NULL, 'magyar'),
(4768, 'Egy rózsa hangjai', 104, '2013-05-31', 'táncelőadás', 'magyar'),
(4769, 'Rozsdatemető 2.0', 34, '2019-03-09', 'dráma', NULL),
(4770, 'Bácskai Juli Pszichoszínháza, Ezt benézted! Bukás, veszteség', NULL, '2018-04-10', NULL, NULL),
(4771, 'Tündérhon vándorai', 95, '2016-02-24', NULL, 'magyar'),
(4772, 'Szent György és a sárkány', 9, '2013-06-22', 'tragikomédia', 'magyar'),
(4773, 'A sevillai borbély', 95, '2013-04-06', 'vígopera', NULL),
(4774, 'Három nővér', 95, '2016-11-26', 'színmű', 'magyar'),
(4775, 'A három sárkány', 73, '2012-03-23', 'játék', 'magyar'),
(4776, 'Mátyás király krónikái', 70, '2018-09-28', 'mesejáték', NULL),
(4777, 'Panthera', 99, '2019-05-29', NULL, NULL),
(4778, 'A víg özvegy', 23, '2014-12-12', 'nagyoperett', 'magyar'),
(4779, 'Virtus', 197, '2013-04-05', 'táncelőadás', 'magyar'),
(4780, 'Az új nagyi', 112, '2015-10-04', NULL, NULL),
(4781, 'A Pitbull cselekedetei', 181, '2012-03-22', 'felolvasószínház', 'magyar'),
(4782, 'Aladdin', 50, '2020-01-29', NULL, NULL),
(4783, 'Télen telelek', 131, '2017-11-21', NULL, 'magyar'),
(4784, 'Különóra', 109, '2018-05-12', 'tragikomédia', NULL),
(4785, 'Országjáró Mátyás király', 162, '2013-07-19', 'zenés játék', 'magyar'),
(4786, 'Az újrakezdő - Árva Bethlen Kata', 187, '2018-10-30', 'monodráma', NULL),
(4787, 'MU Terminál B est, 2015 - Zeit For Life! / A ZÖLD ASZTAL Projekt - második felvonás', 8, '2015-02-27', 'táncelőadás', 'magyar'),
(4788, 'Jászok', NULL, '2016-06-03', 'táncjáték', 'magyar'),
(4789, 'Rövid', 152, '2012-03-13', NULL, 'magyar'),
(4790, 'Nikola Tesla - Végtelen energia', NULL, '2020-02-28', NULL, NULL),
(4791, 'Karikatúra', NULL, '2020-10-26', NULL, NULL),
(4792, 'Halálos tavasz', 85, '2015-06-13', 'színmű', 'magyar'),
(4793, 'Magyar anzix', 178, '2013-05-16', 'táncelőadás', 'magyar'),
(4794, 'Halpern és Johnson', 155, '2016-12-15', NULL, 'magyar'),
(4795, 'All Ears', 124, '2014-10-17', 'táncelőadás', 'magyar'),
(4796, 'Fekete Péter', 118, '2015-02-13', 'kisoperett', 'magyar'),
(4797, 'Te csak pipálj, Ladányi!', 121, '2014-02-14', 'színmű', 'magyar'),
(4798, 'Deficit', 162, '2012-10-26', 'abszurd játék', 'magyar'),
(4799, 'A 42. hét', 49, '2012-09-28', 'színmű', 'magyar'),
(4800, 'Herkules-sarok', 140, '2020-01-17', NULL, NULL),
(4801, 'Ki vagy te, kortárs tánc?', 78, '2015-12-12', 'táncelőadás', 'magyar'),
(4802, 'Szemünk fénye', 107, '2014-10-07', 'kortárs tánc', 'magyar'),
(4803, 'Vőlegény', 134, '2017-04-14', 'vígjáték', 'magyar'),
(4804, 'Az ördög', 129, '2015-11-14', 'vígjáték', 'magyar'),
(4805, 'Az Isten balján', 50, '2015-11-20', NULL, 'magyar'),
(4806, 'Feketeszárú cseresznye', 32, '2019-10-11', 'színjáték', NULL),
(4807, 'Ments meg, Uram! (Dead Man Walking)', NULL, '2020-09-16', 'opera', NULL),
(4808, 'A Schroffenstein család', 140, '2018-03-17', NULL, NULL),
(4809, 'Figaro házassága', 185, '2013-03-28', 'vígjáték', 'magyar'),
(4810, 'Juhász Péter: Sinni / Mészáros Máté: Ketten', 78, '2019-10-20', 'táncelőadás', NULL),
(4811, 'Szent Péter esernyője', 126, '2016-05-23', 'vígjáték', 'magyar'),
(4812, 'Hóhérok', 32, '2018-02-02', NULL, NULL),
(4813, 'Watergate: Az időkripták rejtélye', 160, '2021-09-12', NULL, NULL),
(4814, 'A tanítónő', 99, '2021-10-02', NULL, NULL),
(4815, 'Irgum-burgum Macibál', 112, '2014-10-04', 'bábjáték', NULL),
(4816, 'Álmos utas haragja', 138, '2020-02-19', NULL, NULL),
(4817, 'Csalóka szivárvány', 185, '2015-04-17', 'játék', 'magyar'),
(4818, 'Bölcs Náthán', 185, '2012-10-12', 'játék', 'magyar'),
(4819, 'Piroskával mindig baj volt', 140, '2019-11-30', NULL, NULL),
(4820, 'Az égigérő paszuly', 196, '2018-11-15', 'népszínmű', NULL),
(4821, 'Bächer Pestje', 64, '2013-03-14', 'kabaré', 'magyar'),
(4822, 'Találkozások Újcirkusz-est', 123, '2021-06-24', 'újcirkusz', NULL),
(4823, 'Ármányos puncspancs', 38, '2018-10-14', 'mesejáték', NULL),
(4824, 'A szfinx, avagy búcsú a kellékektől; Te Imre, itt valami ketyeg', 162, '2016-04-08', NULL, 'magyar'),
(4825, 'A mundérvásárhelyi búcsú', 23, '2012-11-23', 'komédia', 'magyar'),
(4826, 'Szeretlek Faust/Mindszenty', 163, '2021-10-23', NULL, NULL),
(4827, 'Hegedűs a háztetőn', 98, '2013-04-22', 'musical', NULL),
(4828, 'Csizmás Kandúr', 112, '2012-03-24', NULL, 'magyar'),
(4829, 'Hajrá Háry!', 180, '2012-02-20', NULL, 'magyar'),
(4830, 'Esti Kornél', 43, '2019-12-10', 'bábjáték', NULL),
(4831, 'Hedda Gabler', 134, '2017-02-17', NULL, 'magyar'),
(4832, 'János vitéz', 99, '2012-09-21', 'színpadi játék', 'magyar'),
(4833, 'Két nő', 114, '2017-12-08', NULL, 'magyar'),
(4834, 'Kakuk Marci', 162, '2016-01-15', 'zenés előadás', 'magyar'),
(4835, 'Jean Cocteau: Orpheusz', 151, '2014-09-25', 'komédia', NULL),
(4836, 'LOL', 86, '2017-10-20', 'balett', NULL),
(4837, 'Családi kérdés - Befejezetlen szimfónia', 157, '2015-04-12', 'színmű', 'magyar'),
(4838, 'Az üvegcipő', 50, '2017-05-20', 'vígjáték', 'magyar'),
(4839, 'Kokainfutár', 32, '2014-01-14', 'beavató színház', 'magyar'),
(4840, 'Magyar nátha', 200, '2018-04-06', NULL, NULL),
(4841, 'Atelier 21220 – MU Színház: FRAGILE', NULL, '2020-10-22', NULL, NULL),
(4842, 'Bányavirág', 157, '2013-03-23', 'dráma', 'magyar'),
(4843, 'Karácsonyi ének', 6, '2012-11-23', 'zenés játék', 'magyar'),
(4844, 'Nem félünk a farkastól', 32, '2019-10-05', 'dráma', NULL),
(4845, 'Mind1', 78, '2015-12-11', 'táncelőadás', 'magyar'),
(4846, 'Huckleberry Finn kalandjai', 121, '2014-03-18', 'színmű', 'magyar'),
(4847, 'Svejk', 185, '2014-04-18', 'komédia', 'magyar'),
(4848, 'A lepkegyűjtő', 35, '2015-04-11', 'thriller', 'magyar'),
(4849, '100+1 holdaspagony', 144, '2020-09-12', 'bábelőadás', NULL),
(4850, 'Szerelmi bájital', 99, '2014-02-28', 'vígopera', NULL),
(4851, 'Szorul a hurok', 79, '2014-01-22', 'színmű', 'magyar'),
(4852, 'Függöny fel!', 70, '2016-06-10', 'vígjáték', 'magyar'),
(4853, 'A kis Mukk', 43, '2013-05-07', 'zenés bábjáték', 'magyar'),
(4854, 'A gondnok', 140, '2012-10-22', 'színmű', 'magyar'),
(4855, 'Kafka a tengerparton', 95, '2018-04-07', NULL, NULL),
(4856, 'Spin|Off', 93, '2014-09-28', NULL, 'magyar'),
(4857, 'Hogyan ettem kutyát?', 44, '2014-02-08', 'monodráma', 'magyar'),
(4858, 'Anconai szerelmesek', 76, '2018-12-01', 'zenés komédia', NULL),
(4859, 'Az őz', 79, '2016-10-15', NULL, 'magyar'),
(4860, 'A nép ellensége', 34, '2013-04-27', 'színmű', 'magyar'),
(4861, 'Hamvas Béla: Karnevál V.-VI.-VII.', 110, '2019-10-12', NULL, NULL),
(4862, 'CLOSER', 182, '2017-02-18', NULL, 'magyar'),
(4863, 'Játszd újra, Sam!', 32, '2013-03-22', 'romantikus vígjáték ', 'magyar'),
(4864, 'Macbeth', 73, '2018-02-16', 'tragédia', NULL),
(4865, 'Bolha a fülbe', 50, '2012-03-30', 'bohózat', 'magyar'),
(4866, 'Numera! - Fókuszban a NULLA számMaladype Színház', NULL, '2014-11-02', NULL, 'magyar'),
(4867, 'Felülről az ibolyát', 127, '2014-05-29', NULL, 'magyar'),
(4868, 'Időfutár', 23, '2019-10-18', 'színmű', NULL),
(4869, 'Bovary Emma', 166, '2012-12-13', 'monodráma', 'magyar'),
(4870, 'A nadrág', 59, '2020-01-26', 'vígjáték', NULL),
(4871, 'Jó ember Szecsuánból', 140, '2017-09-15', NULL, 'magyar'),
(4872, 'A világot tartó oszlopok', 18, '2021-09-13', NULL, NULL),
(4873, 'A dzsungel könyve', 13, '2014-12-14', 'bábjáték', 'magyar'),
(4874, 'Ágacska', 23, '2014-02-28', 'mesejáték', 'magyar'),
(4875, 'Figaro házassága', 85, '2013-08-02', 'vígopera', 'magyar'),
(4876, 'Óz, a nagy varázsló', 53, '2015-10-08', 'mesejáték', 'magyar'),
(4877, 'Toldi', 103, '2012-03-23', 'musical költemény', 'magyar'),
(4878, 'Annonciation', 173, '2013-02-22', 'táncelőadás', NULL),
(4879, 'A legyező', 32, '2015-02-19', 'vígjáték', 'magyar'),
(4880, 'János vitéz', 40, '2012-04-14', 'mesejáték', 'magyar'),
(4881, 'Egyet nekem, egyet neked', 8, '2014-11-07', 'táncelőadás', 'magyar'),
(4882, 'Mirandolina', 95, '2013-03-09', 'vígjáték', 'magyar'),
(4883, 'Az ember tragédiája', 32, '2016-10-07', 'tragédia', 'magyar'),
(4884, 'A Dohány utcai seriff', 200, '2012-12-14', 'dráma', 'magyar'),
(4885, 'A kölyök', 185, '2014-10-03', 'musical', 'magyar'),
(4886, 'János Vitéz', 112, '2015-04-12', 'bábjáték', NULL),
(4887, 'Ahogy tetszik', 140, '2018-01-12', NULL, NULL),
(4888, 'Pokolbéli víg napjaim', NULL, '2021-11-06', NULL, NULL),
(4889, 'Táncol az erkély kakaóval - Diótörő', 3, '2014-12-06', NULL, 'magyar'),
(4890, 'Kövérkirály', 50, '2016-04-18', 'mesejáték', 'magyar'),
(4891, 'Bizánc', 95, '2012-11-17', 'színmű', 'magyar'),
(4892, 'Mézga Géza', 143, '2012-10-08', 'zenés mesejáték', 'magyar'),
(4893, 'Kripta', 191, '2013-09-27', 'táncelőadás', NULL),
(4894, 'Live Art: Prince for lonely days - Egy elfelejtett János története', 123, '2013-12-17', 'színmű', 'magyar'),
(4895, 'Micsoda társaság!', 134, '2016-09-21', 'mesejáték', 'magyar'),
(4896, 'A kaukázusi krétakör', 32, '2017-09-30', 'színmű', 'magyar'),
(4897, 'MacVedel a kalózkísértet', 134, '2014-02-11', NULL, 'magyar'),
(4898, 'Hagyaték', 89, '2019-11-06', NULL, NULL),
(4899, 'Csip-csip csóka', 28, '2016-01-09', NULL, NULL),
(4900, 'Kakasviadal', 112, '2021-02-07', 'bábelőadás', NULL),
(4901, 'A diktátor', 170, '2018-10-13', NULL, NULL),
(4902, 'Ludas Matyi Jr.', 148, '2018-12-08', 'zenés színmű', NULL),
(4903, 'Császárok napja - Agrippina - a legjobb anya - optima mater', 9, '2016-01-29', NULL, 'magyar'),
(4904, 'Az elveszett szaloncukor', 4, '2017-12-02', 'bábelőadás', 'magyar'),
(4905, 'Nabucco', 122, '2014-02-28', 'opera', 'olasz'),
(4906, 'Az ember tragédiája', 169, '2015-05-18', NULL, 'magyar'),
(4907, 'A didergő király', 196, '2017-10-26', 'zenés mesejáték', 'magyar'),
(4908, 'Légszükséglet', NULL, '2018-05-21', 'táncelőadás', NULL),
(4909, 'Tessék engem megmenteni!', 38, '2012-03-11', NULL, NULL),
(4910, 'Diótörő', 137, '2016-10-26', 'balett', 'magyar'),
(4911, '80 nap alatt a Föld körül', 43, '2019-04-04', 'bábjáték', NULL),
(4912, 'Kalauz Jutka', 68, '2013-03-05', 'zenés előadás', 'magyar'),
(4913, 'Ö.K.Ö.R.', 99, '2021-10-15', NULL, NULL),
(4914, 'Aladdin és a csodalámpa', 134, '2019-09-18', 'zenés mesejáték', NULL),
(4915, 'Pillantás a hídról', 32, '2015-10-16', 'színmű', 'magyar'),
(4916, 'Agora', 104, '2020-02-07', 'táncelőadás', NULL),
(4917, 'Musical történetek', 32, '2013-10-11', 'musical', 'magyar'),
(4918, 'A hülyéje', 9, '2014-11-28', 'vígjáték', 'magyar'),
(4919, 'Kokkola', 31, '2013-08-02', 'tragikomédia', 'magyar'),
(4920, 'Határátlépések', 68, '2020-09-11', NULL, NULL),
(4921, '15 próbálkozás a színészetre', 192, '2019-02-08', NULL, NULL),
(4922, 'Frank Stein', NULL, '2018-05-17', NULL, NULL),
(4923, 'Kalucsni', 140, '2017-02-25', NULL, 'magyar'),
(4924, '1914', 170, '2014-10-15', NULL, NULL),
(4925, 'Patkányok', 41, '2016-11-25', NULL, 'magyar'),
(4926, 'Pianoplays / Passage', 80, '2019-02-16', 'balett', NULL),
(4927, 'János vitéz', 30, '2015-10-08', 'daljáték', 'magyar'),
(4928, 'Dióliget', 74, '2021-10-10', 'mesejáték', NULL),
(4929, 'Dudogó Szimfónia', NULL, '2018-05-14', 'táncelőadás', NULL),
(4930, 'A Napsugár fiúk', 118, '2012-12-08', 'komédia', 'magyar'),
(4931, 'Mirkó királyfi', 180, '2012-03-28', 'mesejáték', 'magyar'),
(4932, 'Antigoné', 143, '2012-11-09', 'színmű', 'magyar'),
(4933, 'Julie kisasszony', 169, '2012-06-25', 'színmű', 'magyar'),
(4934, '10', 76, '2021-10-02', 'dráma', NULL),
(4935, 'Marica grófnő', 59, '2019-01-20', 'operett', NULL),
(4936, 'Novemberi éj', 122, '2013-11-23', NULL, 'magyar'),
(4937, 'Apák és fiúk', 95, '2017-01-21', 'színmű', 'magyar'),
(4938, 'Élet.történetek.hu - Pira Bella', 68, '2017-10-28', NULL, 'magyar'),
(4939, 'Parázsfuvolácska', 22, '2014-03-30', 'opera', NULL),
(4940, 'eddig minden rendben #metoo', 96, '2017-12-02', NULL, NULL),
(4941, 'Figaro házassága', 95, '2016-11-05', 'vígjáték', 'magyar'),
(4942, 'Ez van', 143, '2014-09-06', 'zenés vígjáték', 'magyar'),
(4943, 'Nincsenapám, seanyám', 160, '2016-09-30', NULL, NULL),
(4944, 'Gingalló', 43, '2017-02-11', 'zenés bábjáték', NULL),
(4945, 'Az úgy volt...', 146, '2017-04-23', 'mesejáték', 'magyar'),
(4946, 'A búsképű lovag - Don Quijote De La Mancha szörnyűséges kalandjai és gyönyörűszép halála', 95, '2021-10-30', 'zenés előadás', NULL),
(4947, 'Zelda - Egy utolsó vad nő', 201, '2019-04-11', NULL, NULL),
(4948, 'Hogyan lett? Kipling mesék', 88, '2014-02-01', 'gyermekelőadás', 'magyar'),
(4949, 'Az 1/2 kegyelmű', 140, '2012-03-31', NULL, 'magyar'),
(4950, 'Tóték', 163, '2012-04-20', 'tragikomédia', 'magyar'),
(4951, 'Így szerettek ők – József Attila II.', NULL, '2018-12-10', 'felolvasószínház', NULL),
(4952, 'Bölcsődal', 31, '2012-09-01', 'színmű', 'magyar'),
(4953, 'Augusztus Oklahomában', 185, '2019-12-06', 'komédia', NULL),
(4954, 'Tütü-tutu autó', 112, '2015-03-07', 'csecsemő színház', NULL),
(4955, 'Cirkuszi szomszédolás', 156, '2017-01-28', 'cirkuszi előadás', NULL),
(4956, 'Rosmersholm', 79, '2018-04-05', NULL, NULL),
(4957, 'Szökőár', 2, '2019-06-11', NULL, NULL),
(4958, 'Faust, az elkárhozott', 99, '2016-04-22', 'táncelőadás', 'magyar'),
(4959, 'Kakaóscsiga', NULL, '2019-04-27', NULL, NULL),
(4960, 'Hópehely hercegnő', 95, '2016-11-26', 'mesejáték', 'magyar'),
(4961, 'Csoda', 148, '2017-02-11', 'tragikomédia', 'magyar'),
(4962, 'Pipp és Polli', 43, '2017-10-09', 'bábelőadás', 'magyar'),
(4963, 'Abigail bulija', 9, '2021-05-21', 'színmű', NULL),
(4964, 'Kurázsi mama és gyermekei', 34, '2015-01-17', 'színmű', 'magyar'),
(4965, 'Bál a Savoyban', 129, '2016-03-05', 'nagyoperett', 'magyar'),
(4966, 'KZ Oratórium', 157, '2014-01-27', 'dráma', 'magyar'),
(4967, 'Keménykalap és krumpliorr', 71, '2018-05-05', 'mesejáték', NULL),
(4968, 'A manóvizsga', 134, '2017-03-01', 'mesejáték', 'magyar'),
(4969, 'Jeanne d\'Arc', 34, '2018-12-18', NULL, NULL),
(4970, 'Mizantróp', 161, '2013-01-19', NULL, NULL),
(4971, 'Békakirályfi', 88, '2019-10-04', 'bábjáték', NULL),
(4972, 'Szöktetés a Szerájból', 122, '2019-12-06', 'vígopera', NULL),
(4973, 'Bohóc kerestetik', 136, '2021-10-28', 'táncelőadás', NULL),
(4974, 'Lúdas Matyi', 27, '2015-04-12', 'bábjáték', NULL),
(4975, 'mackóélet/mackóálom', 140, '2016-01-10', NULL, 'magyar'),
(4976, 'Az öreg kisasszony autósmeséi', 30, '2016-10-21', NULL, 'magyar'),
(4977, 'Zenekar a gomba alatt', 44, '2015-05-31', 'zenés mesejáték', 'magyar'),
(4978, 'Mágnás Miska', 134, '2016-11-18', 'nagyoperett', 'magyar'),
(4979, 'Hitted volna?', 68, '2013-10-03', 'színmű', 'magyar'),
(4980, 'Hepp!!!', 130, '2015-05-29', 'cirkuszi előadás', NULL),
(4981, 'Edith és Marlene', 95, '2014-10-16', 'zenés játék', 'magyar'),
(4982, 'A rátóti csikótojás', 109, '2020-11-20', 'mesejáték', NULL),
(4983, 'Ismeri a tejutat?', 109, '2015-11-13', 'dráma', 'magyar'),
(4984, 'Az aranygyapjas kaland', 40, '2019-04-06', 'bábjáték', NULL),
(4985, 'Rómeó és Júlia', 157, '2021-06-11', 'tragédia', NULL),
(4986, 'Boszorkányok a Bármi utcából', 131, '2019-09-21', 'bábjáték', NULL),
(4987, 'Anconai szerelmesek', 95, '2016-07-17', NULL, NULL),
(4988, 'Mi lennék nélküled? – Jászai Maritól napjainkig', 92, '2021-07-29', NULL, NULL),
(4989, 'Szilveszter 2015', 23, '2015-12-31', 'zenés revü', 'magyar'),
(4990, 'Petra von Kant', 34, '2014-10-15', 'színmű', 'magyar'),
(4991, 'Énekes madár', 162, '2014-10-17', 'színmű', 'magyar'),
(4992, 'Szakonyi 2013', 24, '2013-04-26', 'színmű', 'magyar'),
(4993, 'Pettson és Findusz', 43, '2012-10-10', 'zenés mesejáték', 'magyar'),
(4994, 'A nők (is) a fejükre estek', 56, '2019-04-13', 'vígjáték', NULL),
(4995, 'Bál a Savoyban', 32, '2020-09-18', 'operett', NULL),
(4996, 'Bérgyilkos a barátom', 185, '2018-10-05', 'bohózat', NULL),
(4997, 'Nyolc nő', 76, '2017-04-08', 'bűnügyi bohózat', 'magyar'),
(4998, 'Öröm és boldogság', 182, '2019-06-20', NULL, NULL),
(4999, 'Fuharosok', 140, '2019-10-10', NULL, NULL),
(5000, 'A kastély', 140, '2012-12-13', 'színpadi játék', 'magyar'),
(5001, 'A jegesmedve szerelMese', 134, '2021-11-04', 'gyerekműsor', NULL),
(5002, 'Báthory Erzsébet', 82, '2012-07-13', NULL, 'magyar'),
(5003, 'Makrancos Kata', 148, '2017-10-07', NULL, 'magyar'),
(5004, 'Rózsák háborúja', 129, '2018-03-02', NULL, NULL),
(5005, 'A hülyéje', 23, '2014-04-04', 'vígjáték', 'magyar'),
(5006, 'Babaróka', 43, '2021-09-26', 'bábelőadás', NULL),
(5007, 'Istenek tanácsa', 79, '2016-01-28', 'színmű', 'magyar'),
(5008, '1x3 néha 4 avagy egyszerháromnéhanégy', 118, '2012-05-25', 'bohózat', 'magyar'),
(5009, 'Boldog képek', 27, '2019-02-03', 'bábjáték', 'magyar'),
(5010, 'Ormányos Hüntyüllér', 139, '2018-12-01', 'bábjáték', NULL),
(5011, 'Két úr szolgája', 148, '2018-09-29', 'komédia', NULL),
(5012, 'Császárok napja: Caracalla', 9, '2014-09-16', NULL, 'magyar'),
(5013, 'Oidipusz király', 140, '2020-02-16', NULL, NULL),
(5014, 'A Jeditanács összeül', 62, '2017-10-27', NULL, 'magyar'),
(5015, 'Vízkereszt vagy bánom is én', 9, '2017-08-17', NULL, 'magyar'),
(5016, 'Chicago', 32, '2012-10-19', 'musical', 'magyar'),
(5017, 'Hamlet', 92, '2013-07-05', 'dráma', 'magyar'),
(5018, 'Máli néni', 9, '2013-11-29', 'vígjáték', 'magyar'),
(5019, 'Csárdáskirálynő', 181, '2021-09-24', 'nagyoperett', NULL),
(5020, 'Ábel és Eszter', 79, '2013-09-17', 'színmű', 'magyar'),
(5021, 'Memo - A felejtés nélküli ember', 23, '2013-10-25', 'színmű', 'magyar'),
(5022, 'Bernarda Late Night Show', 24, '2013-12-20', 'tragédia', 'magyar'),
(5023, 'Kölcsönlakás', 114, '2016-12-10', 'bohózat', 'magyar'),
(5024, 'Meg tudom magyarázni... (De ki az a BUBUS?)', 168, '2016-10-09', 'vígjáték', 'magyar'),
(5025, 'KILÉPŐ - Improszínház', 32, '2013-10-19', 'improvizáció', 'magyar'),
(5026, 'Jadviga párnája', 68, '2012-10-12', 'színmű', 'magyar'),
(5027, 'Vitéz lélek', 56, '2021-10-16', NULL, NULL),
(5028, 'Pokémon go', 79, '2018-02-20', NULL, NULL),
(5029, 'Négy napló és egy vers', 109, '2014-04-29', 'táncelőadás', 'magyar'),
(5030, 'A tavasz ébredése', 106, '2018-03-25', NULL, NULL),
(5031, 'Col-Lab Sacro Sanctus / Poliamoria', 78, '2018-03-25', 'táncelőadás', NULL),
(5032, 'Dózsa', 162, '2015-09-20', NULL, 'magyar'),
(5033, 'Ördöglakat', 182, '2020-04-25', 'krimi', NULL),
(5034, 'A fizikusok', 44, '2015-01-23', 'komédia', 'magyar'),
(5035, 'A képmutogató', 83, '2018-01-12', NULL, NULL),
(5036, 'Időfutár', 122, '2016-12-19', NULL, 'magyar'),
(5037, 'Kiváló dolgozók', 20, '2020-10-24', NULL, NULL),
(5038, 'C\'est la vie', 32, '2013-10-03', 'zenés előadás', 'magyar'),
(5039, 'Hangulatkocsma', 140, '2016-03-04', NULL, 'magyar'),
(5040, 'Stravinsky/Bartók', 80, '2020-11-26', 'balett', NULL),
(5041, 'Lear király', 190, '2015-10-04', 'színmű', 'magyar'),
(5042, 'Mágikus állatok iskolája', 40, '2017-02-25', 'mesejáték', NULL),
(5043, 'Concerto', 41, '2016-08-05', NULL, 'magyar'),
(5044, 'Gólyakalifa', 124, '2018-01-29', NULL, NULL),
(5045, 'Luxemburg grófja', 181, '2016-01-15', 'operett', 'magyar'),
(5046, 'Péter és a farkas', 44, '2020-02-22', 'gyerekműsor', NULL),
(5047, 'Képzelt beteg', 30, '2014-03-29', 'színmű', 'magyar'),
(5048, 'Szoba', 122, '2019-05-11', 'táncelőadás', NULL),
(5049, 'Luxemburg grófja', 73, '2015-03-13', 'operett', 'magyar'),
(5050, 'A rét', 184, '2021-10-23', 'táncelőadás', NULL),
(5051, 'Hét boszorka', 35, '2013-03-08', 'zenés est', 'magyar'),
(5052, 'Ophélia', 92, '2016-07-09', 'színmű', 'angol'),
(5053, 'A jegesmedve', 122, '2016-03-19', 'monodráma', 'magyar'),
(5054, 'Eklektikon 2048', 32, '2018-11-30', 'népszínmű', NULL),
(5055, 'Kreol, kreál', NULL, '2020-05-15', 'táncelőadás', NULL),
(5056, 'Punch and Judy', 140, '2020-02-22', NULL, NULL),
(5057, 'Teremtmények', 34, '2021-12-17', NULL, NULL),
(5058, 'Mágyika, avagy az ördögök könyve', 27, '2017-11-26', 'bábelőadás', 'magyar'),
(5059, 'A víg özvegy', 12, '2019-10-19', 'operett', NULL),
(5060, 'Avantgarde', 140, '2017-11-26', NULL, 'magyar'),
(5061, 'Halj meg és nagy leszel', 157, '2015-10-04', NULL, 'magyar'),
(5062, 'Mianyánk', 89, '2015-10-02', NULL, 'magyar'),
(5063, 'Raped Europeans', 158, '2013-10-18', 'táncelőadás', 'magyar'),
(5064, 'E kor nekünk szülőnk és megölőnk', 202, '2012-04-30', NULL, 'magyar'),
(5065, 'Kampf', 3, '2015-11-15', 'táncelőadás', 'magyar'),
(5066, 'Túl a Maszat-hegyen', 13, '2022-01-23', 'zenés mesejáték', NULL),
(5067, 'Mein kleiner Blumengarten (Én kis virágos kertem)', 191, '2012-04-25', 'táncelőadás', 'magyar'),
(5068, 'Annuska2.0', 74, '2018-11-18', 'vígjáték', NULL),
(5069, 'Déry és Böbe', 36, '2016-10-28', NULL, 'magyar'),
(5070, 'Burok', 133, '2018-02-02', 'táncelőadás', NULL),
(5071, 'Rumini és a négy jogar', 151, '2014-05-18', 'bábjáték', 'magyar'),
(5072, 'Az éjszakában', 128, '2017-02-25', 'felolvasószínház', 'magyar'),
(5073, 'OTTHON (August Strindberg: A pelikán)', 166, '2014-05-05', 'színmű', 'magyar'),
(5074, 'H@Hamlet', 203, '2015-11-05', 'színmű', 'magyar'),
(5075, '8. sorozat / Sequences 8.', 173, '2013-06-06', 'újcirkusz', NULL),
(5076, 'József és testvérei', 38, '2015-07-04', NULL, NULL),
(5077, 'Illúziók', 122, '2012-04-13', 'színmű', 'magyar'),
(5078, 'Mezőség - Mikrokozmosz', 84, '2012-10-12', 'táncelőadás', 'magyar'),
(5079, 'A rögöcsei csoda', 122, '2013-03-01', 'komédia', 'magyar'),
(5080, 'Tara teknője', 63, '2018-02-21', NULL, NULL),
(5081, 'Erdő', 126, '2019-03-27', 'vígjáték', NULL),
(5082, 'Seherezádé', 129, '2014-09-20', 'színmű', 'magyar'),
(5083, 'Blaskó Borbála: Csajka', NULL, '2018-11-30', NULL, NULL),
(5084, 'My fair lady', 44, '2016-12-09', 'musical', 'magyar'),
(5085, 'Don Carlos', 129, '2018-03-10', NULL, NULL),
(5086, 'Tűznyelők', 140, '2019-03-13', 'groteszk', NULL),
(5087, 'Jelenetek egy házasságból', 99, '2012-03-02', 'színpadi játék', 'magyar'),
(5088, 'A fizikusok', 99, '2019-02-02', 'komédia', NULL),
(5089, 'Eszter hagyatéka', 182, '2019-03-05', 'színmű', 'magyar'),
(5090, 'Kukac Kata kalandjai', 56, '2019-09-29', 'mesemusical', 'magyar'),
(5091, 'Diótörő', 199, '2015-12-10', 'mesebalett', 'magyar'),
(5092, 'Itt van a város, vagyunk lakói', 123, '2015-05-08', 'táncelőadás', 'magyar'),
(5093, 'Tünet Együttes: Trolletetés', 133, '2020-02-14', 'táncelőadás', NULL),
(5094, 'A férfiak szexuális világa', 200, '2013-12-18', 'színmű', 'magyar'),
(5095, 'István, a király', 150, '2020-10-17', 'rockopera', NULL),
(5096, 'Spiritiszták', 22, '2014-01-19', 'opera', 'olasz'),
(5097, 'Az ördög', 32, '2013-02-01', 'vígjáték', 'magyar'),
(5098, 'Edith és Marlene', 99, '2018-10-06', 'zenés játék', NULL),
(5099, 'A harmadik hableány', 38, '2014-04-27', 'gyermekelőadás', 'magyar'),
(5100, 'Sérült színház (Disabled Theater)', 173, '2013-03-13', NULL, 'német'),
(5101, 'Kicsibácsi és Kicsinéni (meg az Imikém)', 38, '2017-06-27', 'mesejáték', 'magyar'),
(5102, 'A gömbfejűek és a csúcsfejűek', NULL, '2018-05-24', NULL, NULL),
(5103, 'Hamlet', 122, '2020-08-11', 'dráma', NULL),
(5104, 'A velencei kalmár', 60, '2016-03-09', 'dráma', 'magyar'),
(5105, 'A te országod', 41, '2015-12-16', NULL, 'magyar'),
(5106, 'Love letters (Szerelmes levelek)', 68, '2020-11-06', NULL, NULL),
(5107, 'Róma réme', 148, '2019-12-07', 'zenés színmű', NULL),
(5108, 'InVízió', 8, '2014-06-01', 'táncelőadás', 'magyar'),
(5109, 'Történetek a Kutyusról meg a Cicusról', 4, '2019-03-09', 'bábjáték', NULL),
(5110, 'Jelenetek egy házasságból', 190, '2012-12-02', 'színmű', 'magyar'),
(5111, 'Az öreg hölgy látogatása', 23, '2013-11-29', 'dráma', 'magyar'),
(5112, 'Diploma előtt', 9, '2019-03-29', 'romantikus vígjáték ', NULL),
(5113, 'Pszeudo', 72, '2017-05-27', 'táncelőadás', NULL),
(5114, 'Anna Karenina', 129, '2013-04-27', NULL, 'magyar'),
(5115, 'Távoli dal', 170, '2017-03-18', NULL, 'magyar'),
(5116, 'Party', 60, '2021-12-04', 'komédia', NULL),
(5117, 'Az illatszertár', 59, '2020-09-25', 'vígjáték', NULL),
(5118, 'A tettyei muzsikusok', 4, '2012-10-07', 'bábjáték', 'magyar'),
(5119, 'Liliputiak lázadása', 64, '2021-10-02', 'monodráma', NULL),
(5120, 'Pintyőke cirkusz, világszám!', 131, '2016-03-04', NULL, NULL),
(5121, 'A szuzai menyegző', 129, '2012-03-24', 'dráma', 'magyar'),
(5122, 'Mecseki tigris, vagy amit akartok', 99, '2018-10-13', 'dráma', NULL),
(5123, 'Siess élni!', 181, '2021-07-08', NULL, NULL),
(5124, 'Dongó', 110, '2016-02-26', NULL, 'magyar'),
(5125, 'Leonce és Léna', 184, '2013-10-04', 'színmű', 'magyar'),
(5126, 'Bőrpofa - a VRRRRRÜMM láncfűrésszel', 21, '2012-01-07', NULL, 'magyar'),
(5127, 'Sztriptíz', 56, '2012-03-30', NULL, NULL),
(5128, 'Utolsók', 109, '2015-03-14', 'táncjáték', NULL),
(5129, 'Ajnácska', 181, '2015-03-04', 'zenés mesejáték', 'magyar'),
(5130, 'A három kismalac', 116, '2015-08-30', NULL, NULL),
(5131, 'Vallomás/Confession', 203, '2017-09-29', 'monodráma', 'magyar'),
(5132, 'Az ördög kútja - vasi mende-mondák', 38, '2013-11-03', 'gyermekelőadás', 'magyar'),
(5133, 'egy meg egy az egy - Tibornak szeretettel', 135, '2013-03-22', 'színmű', NULL),
(5134, 'Dűne', 78, '2013-11-15', 'táncelőadás', 'magyar'),
(5135, 'Stuart Mária', NULL, '2018-04-19', 'dráma', NULL),
(5136, 'A varázsfuvola', 150, '2014-04-12', 'opera', NULL),
(5137, 'Őrült tánc! - de van benne rendszer', 86, '2015-09-19', 'táncelőadás', 'magyar'),
(5138, 'Aranycsapat', 148, '2012-04-14', 'musical', 'magyar'),
(5139, 'Anconai szerelmesek', 130, '2015-04-16', 'zenés komédia', 'magyar'),
(5140, 'Rigócsőr király', 116, '2018-12-09', 'bábjáték', NULL),
(5141, 'Kabaré', 130, '2013-03-22', 'musical', 'magyar'),
(5142, 'Faust II.', 34, '2015-04-26', 'színmű', 'magyar'),
(5143, 'Csak táncolunk...', 86, '2012-05-11', NULL, 'magyar'),
(5144, 'Egri csillagok', 157, '2018-03-09', NULL, NULL),
(5145, 'Danny mesél: Szaszuma és a szél', 151, '2015-09-20', 'zenés mesejáték', NULL),
(5146, 'Los Vivancos', 82, '2012-06-15', NULL, NULL),
(5147, 'Szentivánéji variációk', 140, '2017-11-04', NULL, 'magyar'),
(5148, 'Lisztmánia - Az iszonyat balladája / Lisztmánia', 115, '2012-03-23', 'balett', 'magyar'),
(5149, 'Kean, a színész', 152, '2017-03-04', NULL, 'magyar'),
(5150, 'Love, Love, Love', 117, '2017-10-05', NULL, 'magyar'),
(5151, 'Mellékhatások', 173, '2017-02-09', 'táncelőadás', NULL),
(5152, 'A dzsungel könyve', 59, '2020-10-18', 'musical', NULL),
(5153, 'Helyet az ifjúságnak', 102, '2015-09-19', 'zenés komédia', 'magyar'),
(5154, 'Pompejzetes eleven levelek', 116, '2016-09-25', 'bábelőadás', NULL),
(5155, 'Medvevár', 26, '2017-08-31', NULL, 'magyar'),
(5156, 'Mátyás király juhásza', 109, '2018-10-16', 'zenés játék', NULL),
(5157, 'Adáshiba', 202, '2020-09-07', NULL, NULL),
(5158, 'Szalon', 63, '2018-12-13', NULL, NULL),
(5159, 'Otello', 22, '2015-09-26', NULL, 'olasz'),
(5160, 'Hernádi pont', 68, '2016-04-08', 'zenés előadás', 'magyar'),
(5161, 'Dadogó Szimfónia', NULL, '2019-04-12', NULL, NULL),
(5162, 'Mesemasa és az aranylevél', 29, '2019-01-24', 'zenés mesejáték', 'magyar'),
(5163, 'Sári bíró', 70, '2012-01-27', 'népszínmű', 'magyar'),
(5164, 'Komámasszony, hol a stukker?', 126, '2016-02-15', 'vígjáték', 'magyar'),
(5165, 'Kalapkúra - Egy szörnyen British zenés kabaré', NULL, '2021-12-06', 'zenés kabaré', NULL),
(5166, 'Mephisto', 120, '2022-01-28', NULL, NULL),
(5167, 'Epifánia királynő', 140, '2016-04-23', 'dráma', 'magyar'),
(5168, 'Love Letters', 35, '2019-10-03', NULL, NULL),
(5169, 'Tartuffe', 44, '2019-02-08', 'komédia', NULL),
(5170, 'Kávécsarnok - Tűzoltó', 99, '2018-02-23', 'vígjáték', NULL),
(5171, 'Budapest fölött az ég', 36, '2020-01-30', 'vígjáték', NULL),
(5172, 'Mennyei hang!', 114, '2018-04-28', 'vígjáték', NULL),
(5173, 'Kőműves Kelemen', 73, '2020-10-09', 'ballada', NULL),
(5174, 'Jóembert keresünk', 32, '2018-12-07', NULL, NULL),
(5175, 'Liliomfi', 134, '2019-10-04', NULL, NULL),
(5176, 'Zorba', 82, '2012-07-26', 'táncjáték', 'magyar'),
(5177, 'Caesar és Kleopátra', 94, '2014-09-30', 'színházi közvetítés', NULL),
(5178, 'A kulcslyukon át', 152, '2019-03-30', 'komédia', NULL),
(5179, 'A pokoli puncs-pancs', 99, '2018-09-15', 'zenés mesejáték', NULL),
(5180, 'A Pál utcai fiúk', 195, '2017-04-08', 'zenés játék', 'magyar'),
(5181, 'Szeget szeggel', 92, '2016-07-12', NULL, NULL),
(5182, 'Szép magyar komédia', 102, '2013-11-26', 'színmű', 'magyar'),
(5183, 'IZP-estek - Krizsán Dániel: Diplopia / Bányai Mirjam Léna: Poker Face', NULL, '2020-04-07', 'táncelőadás', NULL),
(5184, 'Liliom', 152, '2014-06-14', 'színmű', 'magyar'),
(5185, '9000 km - Táncos földrajz óra', 183, '2012-10-22', NULL, NULL),
(5186, 'Black comedy', 99, '2012-10-12', NULL, 'magyar'),
(5187, 'Az ügynök halála', 157, '2017-10-01', 'színmű', 'magyar'),
(5188, 'Héthavas gyermekei', 109, '2016-03-18', NULL, 'magyar'),
(5189, 'Svindli cirkusz', NULL, '2019-05-26', NULL, NULL),
(5190, 'Tasso', NULL, '2018-01-16', NULL, NULL),
(5191, 'Sömmi.', 110, '2017-02-23', NULL, 'magyar'),
(5192, 'Buborékok', 181, '2019-10-23', NULL, NULL),
(5193, 'A hókirálynő', 116, '2013-09-29', 'bábjáték', 'magyar'),
(5194, 'Lukrécia meggyalázása', 22, '2014-11-05', 'opera', 'magyar'),
(5195, 'Numera! - Fókuszban a TIZENKETTES számA Magyar Nyelv Múzeuma', NULL, '2016-05-22', NULL, 'magyar'),
(5196, 'Vadregény - Into the woods', 83, '2014-04-26', 'musical', 'magyar'),
(5197, 'War Sum Up', 157, '2012-10-10', 'opera', NULL),
(5198, 'Harisnyás Pippi', 83, '2015-03-28', 'színmű', 'magyar'),
(5199, 'A napsugár fiúk', 114, '2015-11-18', NULL, NULL),
(5200, 'Péter és a farkas', 134, '2020-01-15', 'zenés mesejáték', NULL),
(5201, 'Menetfény', 42, '2016-01-27', 'táncelőadás', 'magyar'),
(5202, 'Bedöglött a tévénk', 171, '2016-05-14', NULL, 'magyar'),
(5203, 'Kézről kézre', 9, '2012-12-07', 'színmű', 'magyar'),
(5204, 'Salome', 150, '2020-09-15', 'opera', NULL),
(5205, 'W.S. Othello', 144, '2014-10-25', 'színmű', 'magyar'),
(5206, 'La Mancha lovagja', 185, '2012-12-14', 'zenés színmű', 'magyar'),
(5207, 'Miskin Herceg', NULL, '2018-02-15', NULL, NULL),
(5208, 'Kádárné balladája', NULL, '2019-01-19', NULL, NULL),
(5209, 'Macskajáték', 122, '2017-12-08', NULL, NULL),
(5210, 'NIBELUNGbeszéd', 140, '2014-04-05', 'színmű', 'magyar'),
(5211, 'Az özvegy Karnyóné és két szeleburdiak', 122, '2016-04-22', 'vígjáték', 'magyar'),
(5212, 'Kakukkfészek', 190, '2019-05-04', NULL, NULL),
(5213, 'Átutazók', 170, '2013-03-08', 'komédia', 'magyar'),
(5214, 'Kabaré', 50, '2012-05-18', 'musical', 'magyar'),
(5215, 'FAME-RENT, A hírnév ára', 102, '2012-10-27', 'musical', 'magyar'),
(5216, 'A táncoló karmester', NULL, '2018-07-20', 'táncelőadás', NULL),
(5217, 'A kis herceg', 109, '2016-01-22', 'zenés előadás', 'magyar'),
(5218, 'Julie kisasszony', 32, '2018-04-28', 'táncjáték', NULL),
(5219, 'Le Bon Sauvage / Nemes Vadember', 72, '2016-03-04', 'táncelőadás', 'magyar'),
(5220, 'Lüszisztraté', 134, '2014-04-11', 'vígjáték', 'magyar'),
(5221, 'Süsü, a sárkány', 73, '2017-01-26', 'zenés mesejáték', 'magyar'),
(5222, 'A hőstenor', 148, '2020-09-26', 'bohózat', NULL),
(5223, 'Chioggiai csetepaté', 50, '2014-02-21', NULL, 'magyar'),
(5224, 'Apa, anya, fiú, lány', 30, '2020-04-01', NULL, NULL),
(5225, 'Louis', NULL, '2018-10-13', 'dráma', NULL),
(5226, 'A repülő kastély', 139, '2017-02-18', 'bábjáték', 'magyar'),
(5227, 'Lutte', 19, '2016-09-23', 'táncelőadás', 'magyar'),
(5228, 'Kelet', 166, '2020-09-22', NULL, NULL),
(5229, 'Nyolc nő', 176, '2015-01-17', 'krimi', 'magyar'),
(5230, 'Édeskettes hármasban', 32, '2016-04-08', 'musical', 'magyar'),
(5231, 'Liliomfi', 109, '2019-04-12', 'vígjáték', NULL),
(5232, 'Az eltört korsó', 134, '2012-02-24', 'vígjáték', 'magyar'),
(5233, 'Egy, kettő, három/Az Ibolya', 181, '2014-02-07', 'komédia', 'magyar'),
(5234, 'Szenzációóóó!', 73, '2012-11-18', 'gyermekelőadás', 'magyar'),
(5235, 'A madárijesztő', 116, '2016-11-27', 'bábjáték', NULL),
(5236, 'A Hang-villa titka', 44, '2014-03-02', 'mesejáték', 'magyar'),
(5237, 'Sose halunk meg', 185, '2020-10-09', 'zenés játék', NULL),
(5238, 'Cserhalmi ANZIX', 95, '2017-04-25', 'beszélgetés', 'magyar'),
(5239, 'Sirály', 129, '2016-10-01', 'komédia', 'magyar'),
(5240, 'A kripli', 148, '2013-10-12', 'színmű', 'magyar'),
(5241, 'Francia szobalány', 56, '2016-12-17', 'vígjáték', 'magyar'),
(5242, 'Hazatérés', 32, '2021-06-26', 'tragikomédia', NULL),
(5243, 'Kreatív KríziSom', 191, '2012-05-14', 'táncelőadás', 'magyar'),
(5244, 'Carmina Burana', 165, '2012-02-17', 'táncelőadás', NULL),
(5245, 'Ványa bácsi', 32, '2015-10-03', 'színmű', 'magyar'),
(5246, 'Kellemes húsvéti ünnepeket!', 114, '2017-05-03', 'komédia', 'magyar'),
(5247, 'A sötétben látó tündér', 56, '2018-02-04', 'mesejáték', NULL),
(5248, 'Hogyan nevezzelek?', 100, '2019-05-17', 'vígjáték', NULL),
(5249, 'SZFEntivánéji álom', 140, '2016-01-15', 'színmű', 'magyar'),
(5250, 'Ágytól - Asztalig', 187, '2018-03-07', NULL, NULL),
(5251, 'Camille', 122, '2016-03-18', NULL, 'magyar'),
(5252, 'Csongor és Tünde', 157, '2016-03-11', 'színmű', 'magyar'),
(5253, 'A bagoly, aki félt a sötétben', 131, '2015-03-06', 'bábjáték', NULL),
(5254, 'Nemtudomka', 122, '2019-11-25', 'zenés mesejáték', NULL),
(5255, 'Psyché', 140, '2019-03-30', NULL, NULL),
(5256, 'Sirály', 140, '2015-09-25', 'színmű', 'magyar'),
(5257, 'Tajtékos dalok', 29, '2020-03-10', 'zenés előadás', NULL),
(5258, 'Babszem Jankó', 102, '2014-10-11', 'mesejáték', 'magyar'),
(5259, 'Csodálatos Radazána', 56, '2020-03-07', NULL, NULL),
(5260, 'Philoktétész', 140, '2014-02-24', 'színmű', 'magyar'),
(5261, 'Idegenek az éjszakában', 60, '2017-04-23', 'zenés est', 'magyar'),
(5262, 'A világgal békémet mára megkötöttem... ÉS TE?', 44, '2015-10-03', NULL, 'magyar'),
(5263, 'Semmi', 43, '2013-01-08', 'bábjáték', 'magyar'),
(5264, 'M. A. naplója', 32, '2019-10-18', NULL, NULL),
(5265, 'Anyám az őrületbe kerget', NULL, '2021-09-17', NULL, NULL),
(5266, 'Napszédítő - Táncköltemény', 154, '2014-03-24', 'táncelőadás', 'magyar'),
(5267, 'Kaktuszok', NULL, '2020-09-11', 'balett', NULL),
(5268, 'Legendás Budapest, legendás Angyalföld', 102, '2017-01-20', NULL, 'magyar'),
(5269, 'Marmorstein Berta', 64, '2017-11-29', 'monodráma', 'magyar'),
(5270, 'Válaszfalak', 68, '2021-06-18', 'vígjáték', NULL),
(5271, 'Imágó', 122, '2019-12-20', NULL, NULL),
(5272, 'Tovább szól a magyar nóta!', NULL, '2018-01-28', 'zenés est', NULL),
(5273, 'Babszem Jankó', 116, '2013-12-01', 'bábjáték', 'magyar'),
(5274, 'Égigérő fű', 83, '2013-03-23', 'mesejáték', 'magyar'),
(5275, 'A jelentéktelen', 200, '2020-09-11', NULL, NULL),
(5276, 'Lulu', 174, '2012-06-23', 'zenés vígjáték', 'magyar'),
(5277, 'Illemtan gyerekeknek', 131, '2015-01-23', 'bábjáték', NULL),
(5278, 'Fehér és Matisse', 193, '2015-03-14', 'táncelőadás', 'magyar'),
(5279, 'Miau', 151, '2016-10-05', NULL, NULL),
(5280, 'G. Samsa drámai ébredése', 140, '2019-11-09', NULL, NULL),
(5281, 'A dzsungel könyve', 50, '2014-05-23', 'színmű', 'magyar'),
(5282, 'Bűn és bűnhődés', 95, '2019-10-16', NULL, NULL),
(5283, 'A gyilkos', 64, '2017-11-18', NULL, 'magyar'),
(5284, 'Lepsénynél még megvolt', 161, '2012-08-04', NULL, NULL),
(5285, 'Milyen mágnes? / Mystery Magnet', 173, '2013-05-02', NULL, NULL),
(5286, 'Primadonnák', 148, '2015-10-03', 'bohózat', 'magyar'),
(5287, 'Prah', 6, '2018-11-03', 'komédia', 'magyar'),
(5288, 'A revizor', 9, '2018-10-05', 'komédia', NULL),
(5289, 'Dollárpapa', 129, '2015-10-03', NULL, 'magyar'),
(5290, 'Szerelem', 181, '2016-02-27', NULL, 'magyar'),
(5291, 'Cooling down signs (A beletörődés tünetei)', 169, '2014-01-30', 'táncelőadás', NULL),
(5292, 'Csalogány család', 121, '2015-09-25', 'zenés komédia', 'magyar'),
(5293, 'Muskátli kabaré', 143, '2021-11-21', 'zenés előadás', NULL),
(5294, 'Julie kisasszony', 7, '2012-03-06', NULL, NULL),
(5295, 'Kazohinia', 92, '2015-07-21', 'dráma', 'magyar'),
(5296, 'Ahol a farkas is jó', 21, '2014-02-14', 'színmű', 'magyar'),
(5297, 'Nincsenapám, seanyám', 144, '2013-11-06', 'színmű', 'magyar'),
(5298, 'Blackbird', 68, '2012-10-04', 'színmű', 'magyar'),
(5299, 'Leszámolás velem', 68, '2017-03-07', NULL, 'magyar'),
(5300, 'Keletre a Naptól, Nyugatra a Holdtól', 112, '2016-10-08', 'mesejáték', NULL),
(5301, 'Splash', 130, '2013-12-13', NULL, 'magyar'),
(5302, 'Boldogságlabirintus', 157, '2014-03-22', 'színmű', 'magyar'),
(5303, 'Rongy Elek, a példakép', 139, '2016-02-27', 'mesejáték', 'magyar'),
(5304, 'III. Richárd', 92, '2015-07-02', NULL, NULL),
(5305, 'A nagy Górky', 106, '2017-11-22', 'groteszk', 'magyar'),
(5306, 'Ködből, csöndből', 167, '2014-03-08', 'táncelőadás', 'magyar'),
(5307, 'IV. Henrik', 20, '2017-10-14', 'történelmi dráma', 'magyar'),
(5308, 'Alvás', 83, '2017-04-08', 'dráma', 'magyar'),
(5309, 'Zserbótangó', 44, '2020-07-16', 'tragikomédia', NULL),
(5310, 'Club Színház: Dr. ÜBÜ', NULL, '2019-05-18', NULL, NULL),
(5311, 'Virágos Magyarország', 21, '2012-04-26', 'operett', 'magyar'),
(5312, 'Szilágyi Eszter Anna: A Nyíregyháza utca', 140, '2018-01-28', NULL, 'magyar'),
(5313, 'Mágnás Miska', 32, '2021-09-17', 'operett', NULL),
(5314, 'Rómeó és Júlia', 199, '2013-09-28', 'balett', 'magyar'),
(5315, 'Emilia Galotti', 21, '2016-06-01', NULL, 'magyar'),
(5316, 'A palacsintás király', 162, '2019-10-19', 'mesejáték', NULL),
(5317, 'A tanítónő', 157, '2012-02-03', 'színmű', 'magyar'),
(5318, 'Hurka Gyurka', 116, '2018-02-11', 'bábjáték', NULL),
(5319, 'Pillantás a hídról', 50, '2018-10-26', 'színmű', NULL),
(5320, '#goshiwon', NULL, '2021-11-23', NULL, NULL),
(5321, 'A Pál utcai fiúk', 122, '2019-09-27', 'zenés játék', NULL),
(5322, 'Feketeszárú cseresznye', 102, '2012-10-06', 'színmű', 'magyar'),
(5323, 'Zarándokének (avagy a színház elfoglalása)', 9, '2012-01-20', 'ballada', 'magyar'),
(5324, 'Cigánykerék', 102, '2014-10-04', 'musical', 'magyar'),
(5325, 'Csipke', 7, '2013-05-21', 'színmű', 'magyar'),
(5326, 'Az emlékezés drámái', 45, '2013-05-30', NULL, 'magyar'),
(5327, 'Jézusfaragó ember', 162, '2012-10-19', 'színjáték', 'magyar'),
(5328, 'Valentin nap', 149, '2021-09-17', 'krimi', NULL),
(5329, 'Doktornők', 56, '2014-11-22', 'zenés játék', 'magyar'),
(5330, 'Mandragóra', 9, '2016-04-29', 'komédia', 'magyar'),
(5331, '...közben...', 36, '2017-03-16', NULL, 'magyar'),
(5332, 'Mátyás, a világ királya', 154, '2019-04-02', 'táncelőadás', NULL),
(5333, 'Úri muri', 32, '2012-10-05', 'színmű', 'magyar'),
(5334, 'Balett + Kodály', 134, '2017-10-24', 'balett', NULL),
(5335, 'Vicces, királykisasszony?', 201, '2015-03-19', 'színmű', 'magyar'),
(5336, 'Ördögök', 32, '2020-02-08', 'dráma', NULL),
(5337, 'GisL', 80, '2021-04-06', 'balett', NULL),
(5338, 'HA DÔ', 136, '2019-03-23', 'táncelőadás', NULL),
(5339, 'Cini-cini muzsika', 4, '2016-03-05', 'csecsemő színház', NULL),
(5340, 'Gombos Jim és Lukács, a masiniszta', 88, '2013-04-06', 'gyermekelőadás', 'magyar'),
(5341, 'A kis herceg', 99, '2016-01-29', 'táncmesejáték', 'magyar'),
(5342, 'A víg özvegy', 29, '2017-03-31', 'operett', 'magyar'),
(5343, 'Jelenetek egy házasságból', 134, '2019-12-05', 'színmű', NULL),
(5344, 'k2 színház: Cucli', NULL, '2020-10-05', NULL, NULL),
(5345, 'Én vagyok én, te vagy te', 38, '2019-09-29', 'bábjáték', NULL),
(5346, 'Oresztész', 190, '2014-10-05', 'színmű', 'magyar'),
(5347, 'Übüségeink kora', 106, '2020-03-12', NULL, NULL),
(5348, 'Színházi bestiák', 23, '2019-10-04', 'színmű', NULL),
(5349, 'Egy fenékkel két lovat', 68, '2016-06-23', 'zenés komédia', 'magyar'),
(5350, 'Makbett', 81, '2015-09-24', 'színmű', 'magyar'),
(5351, 'Nimfománia', 36, '2016-05-14', NULL, NULL),
(5352, 'Náthán gyermekei', 13, '2012-11-16', 'gyermekelőadás', 'magyar'),
(5353, 'A mosoly országa', 29, '2021-10-22', 'operett', NULL),
(5354, 'A padlás', 181, '2019-11-05', 'musical', NULL),
(5355, 'Ha majd egyszer mindenki visszajön...', 170, '2014-09-14', 'zenés előadás', 'magyar'),
(5356, 'Kitagadottak', 140, '2017-02-18', NULL, 'magyar'),
(5357, 'Pán Péter', 99, '2014-12-12', 'musical', 'magyar'),
(5358, 'Fluxus', 26, '2017-04-20', NULL, 'magyar'),
(5359, 'Mi történt Vegasban?', 35, '2019-11-08', NULL, NULL),
(5360, 'Bál a Savoyban', 109, '2014-10-17', 'revüoperett', 'magyar'),
(5361, 'Nyúl Karcsi a Vizslaparkban', 131, '2019-03-30', 'bábjáték', NULL),
(5362, 'Kövek', 122, '2018-01-16', NULL, NULL),
(5363, 'IZP-estek - Krizsán Dániel: Diplopia / Bányai Mirjam Léna: Poker Face', NULL, '2020-11-03', 'táncelőadás', NULL),
(5364, 'Angels in America', NULL, '2019-10-10', 'opera', NULL),
(5365, 'Öröm és boldogság', NULL, '2017-10-07', NULL, NULL),
(5366, 'Télapó gyere már!', 106, '2012-12-06', 'gyermekelőadás', 'magyar'),
(5367, 'Ágacska', 6, '2019-10-11', 'zenés mesejáték', NULL),
(5368, 'Túl zajos magány', 129, '2016-01-23', NULL, 'magyar'),
(5369, 'Today is today', 173, '2018-11-09', NULL, NULL),
(5370, 'Másikember', 23, '2014-03-18', 'vígjáték', 'magyar'),
(5371, 'Nagyvizit', 162, '2014-01-31', 'tragikomédia', 'magyar'),
(5372, 'Image', NULL, '2019-05-29', 'táncelőadás', NULL),
(5373, 'Nagymamával álmodtam', NULL, '2021-10-03', NULL, NULL),
(5374, 'Az utolsó szerep', 56, '2018-02-10', 'színmű', 'magyar'),
(5375, 'Pókháló', 134, '2022-01-08', NULL, NULL),
(5376, 'A négyszögletű kerek erdő', 151, '2015-10-11', NULL, NULL),
(5377, 'Tündér Lala', 83, '2018-10-27', 'zenés mesejáték', NULL),
(5378, 'A mumus', 99, '2017-05-27', 'mesemusical', 'magyar'),
(5379, 'Kölcsönlakás', 181, '2017-03-03', 'vígjáték', 'magyar'),
(5380, 'Ádám almái', 9, '2020-04-24', 'vígjáték', NULL),
(5381, 'Pillangó', 95, '2014-01-11', 'színmű', 'magyar'),
(5382, 'Heltai naplója', 190, '2015-10-31', NULL, 'magyar'),
(5383, 'Iza és Krisztián', 93, '2015-09-26', 'színmű', 'magyar'),
(5384, 'Karamazov testvérek', 190, '2014-12-21', 'színmű', 'magyar'),
(5385, 'Utánképzés ittas vezetőknek', 99, '2021-11-27', 'tragikomédia', NULL),
(5386, 'Bolero', 198, '2020-03-05', 'balett', NULL),
(5387, 'Kolpert úr', 130, '2014-04-17', NULL, 'magyar'),
(5388, 'Mobil', 99, '2019-11-29', NULL, NULL),
(5389, 'Kutyát nem eszünk', 8, '2014-09-19', 'táncelőadás', 'magyar'),
(5390, 'Stílusgyakorlatok', 128, '2014-12-14', NULL, 'magyar'),
(5391, 'Hagymát hagymával', 64, '2013-03-19', 'zenés előadás', 'magyar'),
(5392, 'Rumcájsz', 38, '2018-01-14', 'bábjáték', 'magyar'),
(5393, 'Titokzatos jóbarát', 139, '2017-10-07', 'mesejáték', 'magyar'),
(5394, 'Minden ötödik órában', 68, '2013-04-10', 'színmű', 'magyar'),
(5395, 'A Cenci-ház', 144, '2018-03-31', 'romantikus dráma', NULL),
(5396, 'Disney On Ice - A Fantázia Birodalma', 147, '2013-12-13', NULL, NULL),
(5397, 'Isten pénze', 134, '2015-11-20', 'musical', 'magyar'),
(5398, 'Maga lesz a férjem!', 56, '2012-06-16', 'zenés vígjáték', 'magyar'),
(5399, 'Hazudni tudni kell', 56, '2017-02-11', 'zenés vígjáték', 'magyar'),
(5400, 'Abigél titkai', 56, '2017-02-26', NULL, 'magyar'),
(5401, 'A rút kiskacsa', 38, '2012-11-04', 'mesejáték', 'magyar'),
(5402, 'Hoffmann és a megátalkodott felvilágosodás', 124, '2018-10-20', NULL, NULL),
(5403, '#SzentivánéjiÁlom', 120, '2018-02-14', NULL, NULL),
(5404, 'Hol van már a tavalyi hó!', 64, '2016-01-23', 'zenés előadás', 'magyar'),
(5405, 'Ne felejcs! - Gangaray Trambulin V.', 104, '2014-05-31', 'táncelőadás', 'magyar'),
(5406, 'Törvénytelen randevú', 50, '2017-09-15', NULL, 'magyar'),
(5407, 'Vadhattyúk', 139, '2019-11-16', 'mesejáték', NULL),
(5408, 'Deeper', 173, '2018-01-18', 'táncelőadás', NULL),
(5409, 'A csengő / A titkos házasság', 85, '2014-07-25', 'vígopera', NULL),
(5410, 'Tom Sawyer kalandjai', 83, '2019-10-19', NULL, NULL),
(5411, 'A manó', 163, '2021-12-10', 'vígjáték', NULL),
(5412, 'Versenyfutás', 140, '2012-04-25', NULL, 'magyar'),
(5413, 'Álomszövő Pendula', 27, '2016-09-25', 'bábjáték', NULL),
(5414, 'Távolsági szerelem', 79, '2013-10-29', NULL, 'magyar'),
(5415, 'Hedda Gabler', 23, '2012-02-24', 'dráma', 'magyar'),
(5416, 'Az aranyecset', 4, '2017-10-07', 'bábelőadás', 'magyar'),
(5417, 'Nem baj, majd megértem', 68, '2021-08-04', NULL, NULL),
(5418, 'A borbély', 34, '2014-02-02', 'színmű', 'magyar'),
(5419, 'Liliomfi', 9, '2019-11-08', 'vígjáték', NULL),
(5420, 'Kortárs koreográfusok estje XIV.', 86, '2013-09-23', 'táncelőadás', 'magyar'),
(5421, 'KÉKSZAKÁLLÚ100 - Prológ / A kékszakállú herceg vára', NULL, '2018-06-04', NULL, NULL),
(5422, 'Nekünk áll a László - Hadházi László önálló estje', 71, '2015-09-18', 'stand-up comedy', 'magyar'),
(5423, 'Kortalan kortárs - BOTRÁNY', 138, '2016-12-14', NULL, 'magyar'),
(5424, 'Nő a múltból', 23, '2012-01-27', 'színmű', 'magyar'),
(5425, 'Hal négyesben', 6, '2013-08-13', 'zenés komédia', 'magyar'),
(5426, 'Az olaszliszkai', 34, '2015-10-09', 'színmű', 'magyar'),
(5427, 'Trapiti', 192, '2012-02-10', 'mesejáték', NULL),
(5428, 'A vágy villamosa', 76, '2014-03-22', 'színmű', 'magyar'),
(5429, 'Auguszta kisasszony különös tavasza', 76, '2015-03-09', 'gyermekelőadás', 'magyar'),
(5430, 'Operett', 157, '2014-09-05', 'operett', 'magyar'),
(5431, 'Párizsi éjszakák', 56, '2015-11-14', 'zenés előadás', 'magyar'),
(5432, 'Csíksomlyói magyar passió', 12, '2013-03-23', 'misztériumjáték', 'magyar'),
(5433, 'My fair lady', NULL, '2020-07-25', NULL, NULL),
(5434, 'Carmen', 189, '2021-11-09', 'táncelőadás', NULL),
(5435, 'Egy szoknya egy nadrág', 143, '2012-10-06', 'zenés komédia', 'magyar'),
(5436, 'Garázsbanda', 124, '2017-09-16', 'zenés előadás', 'magyar'),
(5437, 'Galilei élete', 157, '2016-03-20', NULL, 'magyar'),
(5438, 'Don Quijote', 122, '2019-10-11', NULL, NULL),
(5439, 'Poligamy', 118, '2013-10-26', 'musical', 'magyar'),
(5440, 'Varázs', 6, '2017-10-06', 'színjáték', 'magyar'),
(5441, 'Odaadó hívetek, Surik', 79, '2012-12-15', 'színmű', 'magyar'),
(5442, 'Variációk egy rablásra', 181, '2021-05-06', NULL, NULL),
(5443, 'A madarász', 85, '2013-07-26', 'operett', 'magyar'),
(5444, 'Három nővér', 180, '2015-02-06', 'színmű', 'magyar'),
(5445, 'Egy nyári nap', 83, '2017-04-01', 'vígjáték', 'magyar'),
(5446, 'A kommunizmus története elmebetegeknek', 128, '2017-06-08', NULL, NULL),
(5447, 'Kék madár', 174, '2013-12-21', 'zenés mesejáték', 'magyar'),
(5448, 'Nanga, a varázslónő - Mese afrikából', 38, '2012-01-29', NULL, NULL),
(5449, 'Kézzel-lábbal', 131, '2018-09-22', 'csecsemő színház', NULL);
INSERT INTO `eloadas` (`id`, `cim`, `szinhazid`, `datum`, `mufaj`, `nyelv`) VALUES
(5450, 'Mindegy', 124, '2016-01-30', NULL, 'magyar'),
(5451, 'Az öldöklés istene', 76, '2013-10-05', 'komédia', 'magyar'),
(5452, 'Amit nem mondhattunk el...', 44, '2021-03-02', 'zenés est', NULL),
(5453, 'Default', 8, '2012-09-14', 'táncelőadás', NULL),
(5454, 'La Mancha lovagja', 76, '2013-10-12', 'zenés színmű', 'magyar'),
(5455, 'Jack, a megmentő', 151, '2019-12-01', 'zenés mesejáték', NULL),
(5456, 'there\'s an elephant in every room...', 91, '2013-09-20', 'táncelőadás', 'magyar'),
(5457, 'Vuk', 125, '2013-03-08', 'táncelőadás', 'magyar'),
(5458, 'Macska voltam Londonban', 40, '2013-03-16', 'gyermekelőadás', 'magyar'),
(5459, 'Moz-Art', 87, '2015-02-17', 'balett', NULL),
(5460, 'Hattyú', 25, '2014-02-28', 'táncelőadás', 'magyar'),
(5461, 'A medvefiú', 151, '2016-11-27', 'bábelőadás', NULL),
(5462, 'Menopauza', 114, '2018-10-11', 'musical', NULL),
(5463, 'Imádok férjhez menni', 163, '2013-07-19', 'zenés komédia', NULL),
(5464, 'Szöktetés a Szerájból', 23, '2020-11-27', 'vígopera', NULL),
(5465, 'Tóték', 134, '2015-11-06', 'tragikomédia', 'magyar'),
(5466, 'János Jelenések - Kardos-Horváth János zenés stand-up estje', 71, '2021-12-21', 'stand-up comedy', NULL),
(5467, 'Pillanatfelvétel', 54, '2016-05-06', NULL, 'magyar'),
(5468, 'Sherlock Holmes - A sátán kutyája', 129, '2017-09-09', 'krimi vígjáték', NULL),
(5469, 'Az olasz férfi', 41, '2018-02-23', 'táncelőadás', NULL),
(5470, 'Kiválasztottak', 155, '2018-09-30', NULL, NULL),
(5471, 'Magyar akác', 173, '2017-05-24', NULL, NULL),
(5472, 'Yerma', 122, '2019-10-04', 'dráma', NULL),
(5473, 'Állati színjáték', 129, '2019-11-29', NULL, NULL),
(5474, 'A velencei kalmár', 182, '2019-11-07', NULL, NULL),
(5475, 'Egy piaci nap', 190, '2018-05-13', NULL, NULL),
(5476, 'Illatszertár', 109, '2018-12-07', 'vígjáték', NULL),
(5477, 'A mélyben', 20, '2019-04-13', NULL, NULL),
(5478, 'Hamlet', 134, '2016-02-12', NULL, 'magyar'),
(5479, 'A halottember', 14, '2016-10-20', NULL, 'magyar'),
(5480, 'Chicago', 95, '2018-09-22', 'musical', NULL),
(5481, 'Bob herceg', NULL, '2019-04-20', NULL, NULL),
(5482, 'Koldusopera', 140, '2018-04-08', NULL, NULL),
(5483, 'Primadonnák', 114, '2014-12-13', 'bohózat', 'magyar'),
(5484, 'Székely Csaba: Szeretik a banánt, elvtársak?', 185, '2015-11-17', 'monodráma', 'magyar'),
(5485, 'Rák Jóska, dán királyfi', 9, '2012-03-09', NULL, 'magyar'),
(5486, 'eARTh - Górecki: 4. szimfónia', 137, '2016-10-10', 'balett', 'magyar'),
(5487, 'Nő létedre', NULL, '2019-05-04', 'mozgásszínház', NULL),
(5488, 'Primadonnák - Operett-Gála', 32, '2015-11-13', 'operett gála', NULL),
(5489, 'Karnyóné', 140, '2015-01-12', 'színmű', 'magyar'),
(5490, 'La Mancha lovagja', 109, '2017-03-24', 'musical', 'magyar'),
(5491, 'Szentivánéji álom', 9, '2012-01-27', 'vígjáték', 'magyar'),
(5492, 'Gershwin Show 2014', 159, '2014-12-28', 'zenés előadás', 'magyar'),
(5493, 'Négyszögletű kerek erdő', 181, '2016-12-06', 'mesejáték', NULL),
(5494, 'A csodaforrás', 108, '2012-05-08', 'mesejáték', NULL),
(5495, 'Világjobbítók', 192, '2012-10-12', NULL, NULL),
(5496, 'Kőműves Kelemen', 136, '2016-11-04', 'rock-musical', 'magyar'),
(5497, 'G-Monodráma Goethe és Lotte szerelméről', 32, '2014-10-12', 'monodráma', 'magyar'),
(5498, 'Egyetlen', 172, '2017-05-26', NULL, NULL),
(5499, 'Fekete Péter', 99, '2016-10-07', 'operett', 'magyar'),
(5500, 'Project Z', 123, '2014-12-13', 'táncjáték', 'magyar'),
(5501, 'A makrancos hölgy', 73, '2015-12-04', 'vígjáték', 'magyar'),
(5502, 'Az utolsó hősszerelmes', 111, '2016-09-17', 'vígjáték', 'magyar'),
(5503, 'GLOW', 173, '2012-10-13', 'táncelőadás', NULL),
(5504, 'Aranyozás - Költők Arany Jánosról', 20, '2017-09-24', 'felolvasószínház', 'magyar'),
(5505, 'Hello Again', 6, '2020-02-28', 'musical', NULL),
(5506, 'Rekviem', 25, '2016-01-20', 'táncelőadás', 'magyar'),
(5507, 'A csemegepultos naplója', 68, '2014-07-10', 'színmű', 'magyar'),
(5508, 'Babák', 43, '2012-04-14', NULL, 'magyar'),
(5509, 'Tóték', 9, '2013-10-04', 'tragikomédia', 'magyar'),
(5510, 'Suspiros - Sóhajok', 191, '2014-11-12', 'táncelőadás', 'magyar'),
(5511, 'Ballada-menü', 102, '2019-10-24', NULL, NULL),
(5512, 'Száll a kakukk fészkére', 95, '2016-04-02', NULL, 'magyar'),
(5513, 'Bűntény a Kecskeszigeten', 163, '2016-01-30', 'dráma', 'magyar'),
(5514, 'AFTER', 197, '2012-05-11', 'táncelőadás', 'magyar'),
(5515, 'Ooh La La', 82, '2015-07-30', 'show műsor', NULL),
(5516, 'A folyón túl Itália', 68, '2014-10-08', 'komédia', 'magyar'),
(5517, 'A salemi boszorkányok', 73, '2014-01-17', 'színmű', 'magyar'),
(5518, 'A hókirálynő', 131, '2019-11-19', 'bábjáték', NULL),
(5519, 'Forró mezők', 157, '2020-10-03', NULL, NULL),
(5520, 'Csodalámpa', 38, '2014-07-07', 'gyermekelőadás', 'magyar'),
(5521, 'Tortúra', 44, '2019-10-12', 'pszichothriller', NULL),
(5522, 'Kérész Művek XXVII.', 135, '2013-04-27', NULL, 'magyar'),
(5523, 'Veron', 32, '2022-01-21', 'opera', NULL),
(5524, 'Doctor Herz', 134, '2012-11-16', 'musical', 'magyar'),
(5525, 'Chicago', 44, '2014-10-03', 'musical', 'magyar'),
(5526, 'Aladdin', 56, '2021-11-07', 'gyerekműsor', NULL),
(5527, 'Sweet Charity', 9, '2015-03-20', 'musical', 'magyar'),
(5528, 'Az arany virágcserép', 140, '2016-03-05', NULL, 'magyar'),
(5529, 'Boeing, Boeing', 185, '2021-09-10', 'vígjáték', NULL),
(5530, 'A kiskakas gyémánt félkrajcárja', 50, '2013-03-13', 'mesejáték', 'magyar'),
(5531, 'Nem vagyunk mi barbárok', 34, '2017-01-07', 'szatíra', 'magyar'),
(5532, 'Anyám tyúkja 2.', 20, '2017-01-21', NULL, 'magyar'),
(5533, 'Akárki', NULL, '2020-07-04', NULL, NULL),
(5534, 'booty Looting', 173, '2014-05-23', 'táncelőadás', NULL),
(5535, 'MU Terminál C Est, 2012', 8, '2012-05-25', 'táncelőadás', 'magyar'),
(5536, 'De mi lett a nővel?', 143, '2022-01-15', NULL, NULL),
(5537, 'Rocksuli', 118, '2018-09-21', 'rock-musical', NULL),
(5538, 'Tévedések vígjátéka', 39, '2015-07-31', 'színmű', 'magyar'),
(5539, 'Ágacska', 151, '2017-11-19', 'mesejáték', 'magyar'),
(5540, 'ÁdámÉva', 115, '2021-11-13', 'balett', NULL),
(5541, 'Munkavégzés során nem biztonságos', 34, '2017-10-06', NULL, 'magyar'),
(5542, 'A régi nyár', 109, '2018-11-16', 'operett', NULL),
(5543, 'Mara halála', 26, '2012-10-08', 'színpadi játék', 'magyar'),
(5544, 'Holdkő', 14, '2017-05-14', NULL, 'magyar'),
(5545, 'Fülkefor és vidéke', 68, '2013-03-13', 'színmű', 'magyar'),
(5546, 'Az utolsó sikoly', 44, '2017-02-11', 'monodráma', 'magyar'),
(5547, 'Movein Mission: Virtus', 197, '2016-12-06', 'táncelőadás', NULL),
(5548, 'Szakadék', 26, '2018-05-06', NULL, NULL),
(5549, 'Montmartre-i ibolya', 109, '2021-11-12', 'operett', NULL),
(5550, 'Pianínó', 34, '2013-05-10', NULL, 'magyar'),
(5551, 'Fedák Sári', 44, '2013-02-09', NULL, 'magyar'),
(5552, 'Happy Ending', 68, '2014-07-25', 'prózai revü', 'magyar'),
(5553, 'Szöktetés a szerájból', 148, '2020-02-01', 'opera', NULL),
(5554, 'Ágrólszakadt Tóbiás', 45, '2013-11-08', NULL, 'magyar'),
(5555, 'Psyché', 157, '2015-11-21', 'dráma', 'magyar'),
(5556, 'A párnaember', 190, '2016-05-07', 'színmű', 'magyar'),
(5557, 'Préda', 136, '2013-09-18', 'táncelőadás', 'magyar'),
(5558, 'Dzsuva', 62, '2016-10-12', NULL, 'magyar'),
(5559, 'Hotel Mimóza', 50, '2020-11-06', 'vígjáték', NULL),
(5560, 'Gitta', 64, '2020-01-28', 'dráma', NULL),
(5561, 'Hamupipőke', 32, '2014-09-26', 'balett', NULL),
(5562, 'Ugye, hogy nem felejtesz el?', 73, '2012-05-06', NULL, NULL),
(5563, 'Circussimo!', 156, '2015-04-04', 'cirkuszi előadás', NULL),
(5564, 'Bábok', 192, '2012-06-22', 'dráma', NULL),
(5565, 'Névtelenül', 73, '2019-11-17', 'monodráma', NULL),
(5566, 'Intim vallomások', 79, '2021-06-28', NULL, NULL),
(5567, '39 lépcsőfok', 99, '2013-11-15', NULL, 'magyar'),
(5568, 'Szentivánéj', 201, '2013-04-05', 'színmű', 'magyar'),
(5569, 'Diótörő és Egérkirály', 50, '2016-11-25', 'mesejáték', 'magyar'),
(5570, 'A zuhanás második pillanata', 12, '2013-12-07', NULL, 'magyar'),
(5571, 'Káosz', 121, '2019-03-08', 'komédia', NULL),
(5572, 'A humor forrása', 152, '2012-10-26', 'kabaré', 'magyar'),
(5573, 'A hét királyfi', 151, '2017-09-30', 'bábelőadás', 'magyar'),
(5574, 'Az úrhatnám polgár', 99, '2019-12-06', NULL, NULL),
(5575, 'Édentől keletre', 182, '2020-07-18', NULL, NULL),
(5576, 'János vitéz', 148, '2013-03-09', 'daljáték', 'magyar'),
(5577, 'Barátom, Gombocska és a mágikus levelek története', 139, '2019-02-02', 'bábjáték', NULL),
(5578, 'Moulin Rouge', 109, '2013-03-22', 'táncjáték', 'magyar'),
(5579, 'Kék róka', 114, '2012-04-01', 'vígjáték', 'magyar'),
(5580, 'A kíváncsi pillangó', 116, '2017-03-25', 'bábjáték', 'magyar'),
(5581, 'Ember, ember, és ember', 73, '2021-10-30', NULL, NULL),
(5582, 'Made in Hungária', 70, '2013-05-31', 'musical', 'magyar'),
(5583, 'Nemek és igenek', 35, '2019-03-02', NULL, NULL),
(5584, 'Szélszabadító', 131, '2014-09-26', 'bábjáték', NULL),
(5585, 'A bogyósgyümölcskertész fia', 140, '2019-09-04', NULL, NULL),
(5586, 'A kiskakas meg a gyémánt 1/2krajcár', 116, '2020-02-09', 'bábjáték', NULL),
(5587, 'Tündérszép Ilona és Árgyélus királyfi', 13, '2017-02-26', 'bábjáték', NULL),
(5588, 'Rövid a póráz', 152, '2016-01-23', NULL, 'magyar'),
(5589, 'Ármány és szerelem', 83, '2018-02-16', NULL, NULL),
(5590, 'A tündérlaki lányok', 50, '2019-09-19', NULL, NULL),
(5591, 'Lola Blau', 182, '2014-09-24', 'mono-musical', 'magyar'),
(5592, 'Dandin György, avagy a megcsúfolt férj', 122, '2017-01-27', NULL, 'magyar'),
(5593, 'Kincskereső kisködmön', 56, '2019-12-12', NULL, NULL),
(5594, 'Leláncolt Prométheusz', 171, '2014-05-18', 'beavató színház', 'magyar'),
(5595, 'Robin Hood', 32, '2015-02-20', 'zenés játék', 'magyar'),
(5596, 'Az ágy közös, a párna... avagy hányszor kell még elmondanom?', NULL, '2018-06-16', NULL, NULL),
(5597, 'Rigócsőr király', 134, '2022-01-26', 'mesemusical', NULL),
(5598, 'Marica grófnő', 122, '2014-10-10', 'operett', 'magyar'),
(5599, 'Rubens és a nemeuklideszi asszonyok', 140, '2019-05-31', NULL, NULL),
(5600, 'Triple Dance', 22, '2018-10-12', 'balett', NULL),
(5601, 'Mi a neved?', 6, '2013-12-14', 'színmű', 'magyar'),
(5602, 'Budapest, Te!', 68, '2021-07-23', 'zenés előadás', NULL),
(5603, 'Holt költők társasága', 44, '2017-11-03', 'dráma', 'magyar'),
(5604, 'A nevem Mary Page Marlowe', 35, '2020-03-08', NULL, NULL),
(5605, 'A hattyúk tava', 56, '2012-11-21', 'színmű', 'magyar'),
(5606, 'Szarvasnak gyermeke', 62, '2021-12-14', NULL, NULL),
(5607, 'Passziviti - avagy akarsz róla beszélni?', 123, '2015-05-15', 'kabaré', 'magyar'),
(5608, 'Hárman a padon', 68, '2021-11-21', NULL, NULL),
(5609, 'Boldogtalanok', 99, '2015-10-10', 'színmű', 'magyar'),
(5610, 'A kripli', 99, '2014-12-05', NULL, 'magyar'),
(5611, 'Girls - swing - Tánc az életünk', 56, '2020-01-18', 'musical', NULL),
(5612, 'A revizor', 12, '2015-04-11', 'színpadi játék', 'magyar'),
(5613, 'Royal Opera House Live – The Royal Ballet: Hattyúk tava', NULL, '2018-06-12', 'balett', NULL),
(5614, 'artman_T_est', 173, '2017-03-01', 'táncelőadás', NULL),
(5615, 'Sárga liliom', 73, '2013-02-22', 'színmű', 'magyar'),
(5616, 'Trilógia maraton 2/2', 158, '2012-03-17', NULL, 'magyar'),
(5617, 'One way to Heaven', 80, '2021-12-22', 'balett', NULL),
(5618, 'Kötélen a Niagara felett', 152, '2014-09-27', NULL, NULL),
(5619, 'A régi nyár', 76, '2012-03-24', 'operett', 'magyar'),
(5620, 'Rendezés', 170, '2017-02-26', 'színmű', 'magyar'),
(5621, 'Látszatélet', 132, '2016-04-27', NULL, 'magyar'),
(5622, 'Egyformák vagyunk', 34, '2021-02-27', NULL, NULL),
(5623, 'Yerma', 140, '2018-11-22', NULL, NULL),
(5624, 'Völgyhíd', 185, '2012-04-06', NULL, 'magyar'),
(5625, 'Nils Holgersson', 177, '2012-02-13', 'mesejáték', 'magyar'),
(5626, 'A zöld kilences', 170, '2012-12-01', 'színmű', 'magyar'),
(5627, 'Tom Sawyer és Huckleberry Finn kalandjai', 83, '2012-04-20', 'mesejáték', NULL),
(5628, 'fightinGravity', 173, '2017-05-23', 'újcirkusz', NULL),
(5629, 'The Singleman Party', 8, '2017-02-24', 'táncelőadás', NULL),
(5630, 'Túszdráma', NULL, '2020-11-10', NULL, NULL),
(5631, 'Ivanov', 66, '2012-02-17', NULL, NULL),
(5632, 'Margarida asszony', 121, '2018-09-14', ' dráma', NULL),
(5633, 'Atlantisz gyermekei', 156, '2016-03-12', 'cirkuszi előadás', NULL),
(5634, 'Biztonsági sáv', 26, '2020-02-25', NULL, NULL),
(5635, 'A hőstenor', 152, '2014-10-11', 'bohózat', 'magyar'),
(5636, 'Minden kombi cirkó, de nem minden cirkó bojler', 34, '2017-12-19', NULL, 'magyar'),
(5637, 'My Fair Lady', 73, '2017-01-20', 'musical', 'magyar'),
(5638, 'A kis herceg', 163, '2014-07-03', 'színmű', 'magyar'),
(5639, 'Retúrjegyet!', 26, '2015-11-19', NULL, 'magyar'),
(5640, 'Légy jó mindhalálig', 50, '2016-01-21', 'musical', 'magyar'),
(5641, 'Majdnem', 15, '2012-01-21', NULL, 'magyar'),
(5642, 'Az egérfogó', 129, '2015-10-17', 'krimi', 'magyar'),
(5643, 'K-Arcok: InSoundOut / LILITH', 78, '2017-04-28', 'táncelőadás', NULL),
(5644, 'Árgyélus királyfi és Tündérszép Ilona', 4, '2013-02-16', 'bábjáték', 'magyar'),
(5645, 'Holle anyó', 112, '2012-02-19', 'mesejáték', 'magyar'),
(5646, 'Mamlasz királyság krónikája', 151, '2018-09-23', 'mesejáték', NULL),
(5647, 'Je suis Amphitryon', 173, '2018-04-24', NULL, NULL),
(5648, 'Fácántánc', 49, '2015-10-24', 'színmű', 'magyar'),
(5649, 'Bagoly és Cica', 68, '2014-07-02', 'színmű', 'magyar'),
(5650, 'Orpheus nyomában', 130, '2014-11-09', NULL, 'magyar'),
(5651, 'Láthatóságiak', 152, '2013-11-06', 'zenés előadás', 'magyar'),
(5652, 'Vitéz lélek', 50, '2021-05-03', 'színmű', NULL),
(5653, 'Billy Elliot - a Musical', 22, '2016-07-29', 'musical', 'magyar'),
(5654, 'A kisfiú meg az oroszlánok', 122, '2017-01-16', 'mesejáték', 'magyar'),
(5655, 'Zrínyi 1566', 109, '2017-12-08', 'rock-musical', NULL),
(5656, 'Élettörténetek.hu - A mi Józsink - Erzsike', 138, '2017-12-08', NULL, 'magyar'),
(5657, 'S', 173, '2013-05-30', 'újcirkusz', NULL),
(5658, 'A mi osztályunk', 32, '2017-01-27', NULL, 'magyar'),
(5659, 'Jelenetek 2 házasságból', 152, '2014-01-23', 'színmű', 'magyar'),
(5660, 'Tündérlaki lányok', NULL, '2018-02-03', NULL, NULL),
(5661, 'Hét randi', 182, '2013-09-14', 'színmű', 'magyar'),
(5662, 'A Négyszögletű kerek erdő', 192, '2016-03-20', 'gyermekelőadás', 'magyar'),
(5663, 'Egy egyszerű szemöldökráncolás', 182, '2018-03-30', NULL, NULL),
(5664, 'Hamm-Let', 92, '2016-07-14', 'színmű', NULL),
(5665, 'A király mulat', 9, '2015-04-30', 'dráma', 'magyar'),
(5666, 'I. Erzsébet', 9, '2017-04-03', 'színmű', 'magyar'),
(5667, 'Pandora szelencéje', 153, '2016-10-14', NULL, 'magyar'),
(5668, 'A rátóti csikótojás', 56, '2013-10-14', NULL, 'magyar'),
(5669, 'Grace és Glória', 6, '2019-03-15', NULL, NULL),
(5670, 'Amikor én halott voltam', 144, '2020-02-28', 'burleszk', NULL),
(5671, 'Egerek és emberek', 148, '2019-03-09', 'dráma', NULL),
(5672, 'Reggel/este', 163, '2014-11-07', NULL, 'magyar'),
(5673, 'Csoda és Kósza', 131, '2015-10-30', NULL, NULL),
(5674, 'Pont, pont, vesszőcske', 40, '2013-09-14', 'gyermekelőadás', 'magyar'),
(5675, 'Sziget', NULL, '2020-05-07', NULL, NULL),
(5676, 'B.R.I.S.A. / Schubert / Sad Case / Some Other Time', 87, '2015-04-22', 'táncelőadás', NULL),
(5677, 'János vitéz', 157, '2014-03-07', 'színmű', 'magyar'),
(5678, 'Ha elmúlik öt év', 34, '2019-05-18', NULL, NULL),
(5679, 'Macskafogó', 102, '2019-09-28', 'zenés előadás', NULL),
(5680, 'Emília és az angyal, akit Körmöczi Györgynek hívtak', 40, '2015-10-31', NULL, NULL),
(5681, 'Császárok napja: Marcus Claudius Tacitus', 9, '2014-12-12', NULL, 'magyar'),
(5682, 'Tanár úr kérem', 185, '2017-09-27', NULL, 'magyar'),
(5683, 'Mr Sloane szórakozik', 124, '2019-01-11', NULL, NULL),
(5684, 'Alszanak a halak?', 201, '2015-04-03', 'bábjáték', 'magyar'),
(5685, 'Gengszter nagyi', 43, '2016-10-02', 'bábelőadás', NULL),
(5686, 'Tündér Lala', 129, '2016-10-22', 'mesejáték', 'magyar'),
(5687, 'Részegek', 21, '2015-12-19', 'színmű', 'magyar'),
(5688, 'Amazonok', 169, '2014-10-28', 'zenés est', 'magyar'),
(5689, 'Madárasszonyok', 167, '2015-02-11', 'táncelőadás', 'magyar'),
(5690, 'Kulcskeresők', 129, '2012-02-04', NULL, 'magyar'),
(5691, 'Hamupipőke', 114, '2018-11-30', 'musical', NULL),
(5692, 'Háry János', 22, '2013-10-06', 'opera', 'magyar'),
(5693, 'Száll a kakukk fészkére', 68, '2015-10-07', 'színmű', 'magyar'),
(5694, 'Kurázsi és gyerekei', NULL, '2019-11-20', NULL, NULL),
(5695, 'Csárdáskirálynő', 29, '2019-09-06', 'operett', NULL),
(5696, 'Úrilány szobát keres', 53, '2015-12-13', 'zenés bohózat', 'magyar'),
(5697, 'Máriák városa', NULL, '2020-04-17', 'operakoncert', NULL),
(5698, 'Ábel', 162, '2012-12-14', 'zenés játék', 'magyar'),
(5699, 'Fekete ló', 8, '2016-05-23', 'táncelőadás', 'magyar'),
(5700, 'Nabucco', 22, '2015-02-13', 'opera', NULL),
(5701, 'Csésze a Niagara alatt – Andrássy Máté önálló estje', 71, '2021-10-22', 'stand-up comedy', NULL),
(5702, 'A kávéház', 44, '2014-03-21', 'vígjáték', 'magyar'),
(5703, 'A kíváncsi kiscsikó', 38, '2020-11-15', NULL, NULL),
(5704, 'Gangaray Dance Company: Agora II', 104, '2020-10-22', 'táncelőadás', NULL),
(5705, 'Hessmese', 122, '2016-11-07', 'mesejáték', 'magyar'),
(5706, 'Mártírok', 21, '2013-04-26', 'színmű', 'magyar'),
(5707, 'A kék madár', 29, '2018-12-05', 'zenés mesejáték', NULL),
(5708, 'Fagypont alatt', 64, '2020-09-13', NULL, NULL),
(5709, 'A rút kiskacsa', 151, '2017-04-22', 'mesejáték', 'magyar'),
(5710, 'Kit szerettél, Ádám?', 126, '2014-01-22', 'színpadi játék', 'magyar'),
(5711, 'A medve nem játék!', 56, '2017-12-16', 'kabaré', NULL),
(5712, 'Touch me not, Nebáncsvirág', 124, '2013-04-19', 'táncelőadás', 'magyar'),
(5713, 'Makrancos Kata', 170, '2012-01-08', 'vígjáték', 'magyar'),
(5714, 'A vaskakas', 80, '2015-02-02', 'táncjáték', NULL),
(5715, 'Vadon nő', 182, '2014-09-08', 'zenés előadás', 'magyar'),
(5716, 'Megszámláltatott fák', 162, '2017-04-21', 'dráma', 'magyar'),
(5717, 'Művészet', 6, '2016-10-09', NULL, 'magyar'),
(5718, 'Kukurikú ifiúr', 140, '2016-11-14', NULL, 'magyar'),
(5719, 'Szarvasének', 84, '2013-04-28', 'táncelőadás', 'magyar'),
(5720, 'Katonák', 68, '2014-03-27', 'színmű', 'magyar'),
(5721, 'Sutra', 135, '2014-04-26', 'táncelőadás', 'magyar'),
(5722, 'Hazát és szerelmet keresek', 157, '2015-12-11', NULL, 'magyar'),
(5723, 'Nem félünk a farkastól', 35, '2016-03-05', NULL, 'magyar'),
(5724, 'Máli néni', 58, '2013-01-12', 'színmű', 'magyar'),
(5725, 'A Pál utcai fiúk', 9, '2020-10-09', 'zenés játék', NULL),
(5726, 'A vihar', 92, '2012-07-15', NULL, NULL),
(5727, 'A tűzmadár', 108, '2012-11-13', 'mesejáték', NULL),
(5728, 'Csingiling', 56, '2017-04-09', 'mesejáték', 'magyar'),
(5729, 'Fém', 74, '2019-02-16', 'abszurd dráma', 'magyar'),
(5730, 'Karamazov testvérek', 134, '2012-01-27', NULL, 'magyar'),
(5731, 'Dózsa Imre 80 Balettgála', 150, '2021-11-21', 'balett', NULL),
(5732, 'Doctor Herz', 185, '2015-10-09', 'musical', 'magyar'),
(5733, 'Nagyon, nagyon, nagyon sötét dolog', 23, '2021-10-15', 'fekete komédia', NULL),
(5734, 'Danton halála', 170, '2013-10-25', 'dráma', 'magyar'),
(5735, 'Édes fiaim', 102, '2013-02-09', 'színmű', 'magyar'),
(5736, 'Nyolc nő', 114, '2013-12-14', 'bűnügyi komédia', 'magyar'),
(5737, 'A cégvezető', 95, '2021-10-16', NULL, NULL),
(5738, 'Origami', 8, '2012-12-06', 'táncelőadás', 'magyar'),
(5739, '33 változat Haydn-koponyára', 20, '2021-10-01', NULL, NULL),
(5740, 'A windsori víg nők', 148, '2014-09-27', 'vígjáték', 'magyar'),
(5741, '12 hét', 16, '2013-03-25', NULL, 'magyar'),
(5742, 'Három Nővér Gyakorlatok', 140, '2013-11-02', 'színmű', 'magyar'),
(5743, 'Lenkey tábornok - a tizenegyedik aradi vértanú', 109, '2018-10-05', 'történelmi dráma', NULL),
(5744, 'A Vasgróf', 23, '2014-09-26', NULL, 'magyar'),
(5745, 'Off Pointe', NULL, '2020-04-17', 'balett', NULL),
(5746, 'A revizor', 76, '2022-01-08', 'komédia', NULL),
(5747, 'Vízkereszt, vagy amit akartok', 60, '2014-01-10', 'vígjáték', 'magyar'),
(5748, 'Csoda és Kósza', 20, '2013-11-24', 'gyermekelőadás', 'magyar'),
(5749, 'Diplomácia', 79, '2018-10-30', NULL, NULL),
(5750, 'Francia rúdugrás', 163, '2017-04-07', 'vígjáték', 'magyar'),
(5751, 'Az őslakó (The Man from Earth)', 182, '2019-01-25', 'dráma', NULL),
(5752, 'Júlia kisasszony', 122, '2018-10-12', 'dráma', NULL),
(5753, 'Ádám almái', 190, '2017-10-21', NULL, 'magyar'),
(5754, 'A csodatükör', 196, '2018-02-07', 'zenés mesejáték', NULL),
(5755, 'Fondor és szerelem', 140, '2016-11-07', NULL, 'magyar'),
(5756, 'A Cirkuszhercegnő', 29, '2014-03-07', 'operett', 'magyar'),
(5757, 'Koronázási szertartásjáték - II. András', 95, '2018-08-18', NULL, NULL),
(5758, 'A bűvös vadász', 32, '2016-03-09', 'opera', 'magyar'),
(5759, 'A balek (A hülyéje)', NULL, '2018-04-28', 'bohózat', NULL),
(5760, 'Hapci király birodalma', 192, '2018-03-21', 'mesejáték', NULL),
(5761, 'A padlás', 109, '2014-01-10', 'musical', 'magyar'),
(5762, 'Vackor az óvodában', 38, '2014-12-07', 'bábjáték', 'magyar'),
(5763, 'Az ember tragédiája', 40, '2021-10-16', NULL, NULL),
(5764, 'A maratonfutók tiszteletkört futnak', 83, '2019-04-12', 'komédia', NULL),
(5765, 'Puccs', 171, '2012-03-13', 'vígjáték', 'magyar'),
(5766, 'Batu-tá kalandjai', 27, '2012-10-21', 'bábjáték', 'magyar'),
(5767, 'Bánk bán', 122, '2017-02-24', 'opera', 'magyar'),
(5768, 'Holle anyó', 38, '2019-02-03', 'bábjáték', NULL),
(5769, 'Shakespeare és a szenvedély', 44, '2016-01-23', NULL, 'magyar'),
(5770, 'Liliomfi', 143, '2016-01-30', NULL, 'magyar'),
(5771, 'Rohan(d)ó élet', 152, '2013-01-11', 'színházi est', 'magyar'),
(5772, 'Hamlet', 20, '2014-03-21', 'színmű', 'magyar'),
(5773, 'Mátyás madara', 56, '2019-03-03', 'mesejáték', NULL),
(5774, 'Oresztész meg a többiek', 155, '2022-01-21', NULL, NULL),
(5775, 'Isten előszobája', 200, '2012-07-06', NULL, 'magyar'),
(5776, 'Ők tudják, mi a szerelem', 30, '2015-01-31', 'színmű', 'magyar'),
(5777, 'Black Out', 54, '2015-10-12', 'táncelőadás', NULL),
(5778, 'Három nővér', 128, '2017-04-08', NULL, 'magyar'),
(5779, 'Kaviár és lencse', 102, '2015-02-21', 'komédia', 'magyar'),
(5780, '5 fiú: pénteken bemutató', 9, '2019-09-13', NULL, NULL),
(5781, 'Feydeau, avagy egy próba története', 122, '2019-03-22', NULL, NULL),
(5782, 'Medve és a Kislány', 181, '2019-03-12', 'csecsemő színház', NULL),
(5783, 'A nagy kapituláció', 173, '2020-10-07', NULL, NULL),
(5784, 'Nem bánok semmit sem...', 44, '2017-02-26', 'zenés előadás', 'magyar'),
(5785, 'A vörös bestia', 162, '2013-11-29', 'bohózat', 'magyar'),
(5786, 'Legtitkosabb Vágyak Szobája', NULL, '2014-12-14', 'fizikai színház', 'magyar'),
(5787, 'Lili bárónő', 44, '2021-12-17', 'operett', NULL),
(5788, 'Nabucco', 32, '2013-02-22', 'opera', NULL),
(5789, 'Nők az idegösszeomlás szélén', 29, '2016-05-20', 'musical', 'magyar'),
(5790, 'Szabadság kórus', 134, '2013-12-04', 'színmű', 'magyar'),
(5791, 'Nyaralás', 134, '2018-11-16', 'komédia', NULL),
(5792, 'M/S', 21, '2014-10-16', 'színmű', 'magyar'),
(5793, 'A Bernhardi-ügy', 20, '2015-03-27', 'színmű', 'magyar'),
(5794, 'Running', 54, '2013-04-12', 'táncelőadás', 'magyar'),
(5795, 'Apácák', 44, '2017-12-28', 'musical', NULL),
(5796, 'Széttáncolt cipellők', 61, '2013-01-20', 'táncelőadás', 'magyar'),
(5797, 'A félkegyelmű', 95, '2014-10-17', 'színmű', 'magyar'),
(5798, 'Palos Verdes, Kalifornia', 181, '2019-05-18', NULL, NULL),
(5799, 'Hedda Gabler', 7, '2012-01-24', NULL, NULL),
(5800, 'Jaj, Istenem!', 155, '2018-05-31', NULL, NULL),
(5801, 'Váratlan vendég', 118, '2016-01-30', 'krimi', 'magyar'),
(5802, 'Pom Pom meséi', 112, '2019-10-06', 'bábjáték', NULL),
(5803, 'A nagy Romulus', 30, '2016-04-27', NULL, 'magyar'),
(5804, 'Madarak', 162, '2019-03-01', NULL, NULL),
(5805, 'Egerek és emberek', 23, '2012-09-28', 'színmű', 'magyar'),
(5806, 'Szellem a spájzban', 56, '2018-04-21', 'vígjáték', 'magyar'),
(5807, 'A Háromágú Tölgyfa Tündére', 38, '2019-10-20', 'bábjáték', NULL),
(5808, 'Avatás', 97, '2015-06-06', 'mozgásszínház', 'magyar'),
(5809, 'A Békakirályfi', 88, '2013-09-21', 'gyermekelőadás', 'magyar'),
(5810, 'A dzsungel könyve', 76, '2012-10-13', 'musical', 'magyar'),
(5811, 'Figaro házassága', 23, '2018-11-02', 'vígopera', NULL),
(5812, 'Oversharing', 8, '2012-12-06', 'táncelőadás', 'magyar'),
(5813, 'A három magas nő', 171, '2016-04-20', 'dráma', 'magyar'),
(5814, 'A hókirálynő', 98, '2012-11-16', 'színmű', 'magyar'),
(5815, 'A két Lotti', 181, '2016-09-15', 'mesejáték', 'magyar'),
(5816, 'Aranyborjú', 118, '2014-04-25', 'musical', 'magyar'),
(5817, 'Ördögölő Józsiás', 29, '2013-03-30', 'zenés mesejáték', 'magyar'),
(5818, 'Halálos tavasz', 99, '2013-02-08', 'dráma', 'magyar'),
(5819, 'Az ember, az állat és az erény', 32, '2013-10-05', 'komédia', 'magyar'),
(5820, 'Tosca', 122, '2020-02-21', 'opera', NULL),
(5821, 'Magyar Menyegző', 147, '2015-04-24', 'táncelőadás', 'magyar'),
(5822, 'A hold gyermekei', 76, '2013-10-16', 'zenés mesejáték', 'magyar'),
(5823, 'Dühöngő ifjúság', 68, '2018-03-16', 'bohózat', NULL),
(5824, 'Recortes', 78, '2020-04-28', 'táncelőadás', NULL),
(5825, 'Ő+Ő', 163, '2014-03-14', NULL, 'magyar'),
(5826, 'István, a király', 39, '2013-08-17', 'rockopera', 'magyar'),
(5827, 'Őszi szonáta', 12, '2015-10-17', 'színpadi játék', 'magyar'),
(5828, 'Borsószem és a többiek', 30, '2012-12-08', 'zenés játék', 'magyar'),
(5829, 'Lear', 122, '2019-03-08', NULL, NULL),
(5830, 'Pogánytánc', 157, '2018-02-17', NULL, NULL),
(5831, 'Szívek messze egymástól', 142, '2015-01-14', 'színmű', 'magyar'),
(5832, 'Magyar mátrix', 36, '2017-10-27', NULL, 'magyar'),
(5833, 'Liliomfi', 103, '2012-01-15', 'táncelőadás', NULL),
(5834, 'Vértestvérek', 56, '2016-10-08', 'musical', 'magyar'),
(5835, 'Férj nélkül tökéletes', 56, '2019-02-23', 'vígjáték', NULL),
(5836, 'EDGE', 169, '2013-11-07', 'táncelőadás', 'magyar'),
(5837, 'A mumus', 129, '2015-10-31', 'gyermek musical', 'magyar'),
(5838, 'nem/más', 194, '2012-02-03', 'dráma', 'magyar'),
(5839, 'Kabaré', 140, '2012-12-31', 'musical', 'magyar'),
(5840, 'Hagymácska', 43, '2014-10-09', 'bábjáték', NULL),
(5841, 'Fenyő Iván', 124, '2018-07-26', NULL, NULL),
(5842, 'Perelj, Uram!', 95, '2018-10-06', 'dráma', NULL),
(5843, 'Kincsek szigete', 95, '2014-01-23', NULL, 'magyar'),
(5844, 'Margit jelenete a 89. oldaltól', 98, '2012-05-30', NULL, NULL),
(5845, 'Don Quijote', 14, '2015-04-29', 'színmű', 'magyar'),
(5846, 'A hiányzó padtárs', 45, '2012-09-15', NULL, 'magyar'),
(5847, 'A cigánybáró', 109, '2014-12-05', 'táncjáték', 'magyar'),
(5848, 'A mi osztályunk', 9, '2016-02-05', 'színmű', 'magyar'),
(5849, 'Point of You', 173, '2015-05-29', 'táncelőadás', 'magyar'),
(5850, 'Nővéreim, verselő asszonyok', NULL, '2020-08-10', 'irodalmi est', NULL),
(5851, 'Koldus és királylány', NULL, '2018-03-24', NULL, NULL),
(5852, 'Továbbisvan', 181, '2013-10-21', 'zenés mesejáték', 'magyar'),
(5853, 'NT Live - Peter Morgan: The Audience', 94, '2013-06-13', 'színházi közvetítés', 'angol'),
(5854, 'Amadeus', 99, '2015-12-11', 'színjáték', 'magyar'),
(5855, 'Babett hazudik', 181, '2016-10-28', 'dráma', 'magyar'),
(5856, 'Rövidzárlat', 40, '2017-05-12', NULL, 'magyar'),
(5857, 'Kutyaúti iskola', 88, '2012-10-19', 'mesejáték', 'magyar'),
(5858, 'A harmadik sárkány', 4, '2020-10-03', 'bábelőadás', NULL),
(5859, 'A hazug', 129, '2012-01-21', NULL, 'magyar'),
(5860, 'EgyMás', 88, '2015-05-08', NULL, NULL),
(5861, 'Hamupipőke', 32, '2020-09-19', 'mesejáték', NULL),
(5862, 'iJobs', 120, '2017-10-24', NULL, 'magyar'),
(5863, 'LOST...', 42, '2020-11-17', 'táncelőadás', NULL),
(5864, 'Sírnak a harangok...', 154, '2014-11-14', 'táncelőadás', 'magyar'),
(5865, 'Rokonok', 76, '2013-12-14', 'dráma', 'magyar'),
(5866, 'A Gézagyerek', 6, '2017-02-25', 'istendráma', 'magyar'),
(5867, 'Pinokkió', 27, '2017-04-23', 'mesejáték', 'magyar'),
(5868, 'La Fontaine, avagy a csodák éjszakája', 148, '2019-10-19', 'színmű', NULL),
(5869, 'Charley nénje?', 56, '2015-02-21', 'zenés vígjáték', 'magyar'),
(5870, 'Hattyúdal a Republic Együttessel', 102, '2013-12-21', 'zenés komédia', 'magyar'),
(5871, 'Die Vaterlosen', 124, '2014-11-28', NULL, 'német'),
(5872, 'Kádár utolsó beszéde', 22, '2016-10-23', NULL, 'magyar'),
(5873, 'Boross Martin-Thury Gábor: Emlékek klinikája', 127, '2017-01-27', NULL, NULL),
(5874, 'Figaro házassága', 145, '2018-07-27', 'opera', NULL),
(5875, 'IZP-estek - Veres Flóra (TalkingBodies): Egy az Egyben Sebestyén Tímea: Suprema', NULL, '2020-10-19', 'táncelőadás', NULL),
(5876, 'Hoffmann meséi', 191, '2013-11-20', 'táncelőadás', 'magyar'),
(5877, 'Hófehérke', 151, '2013-03-24', NULL, 'magyar'),
(5878, 'Vízkereszt, vagy bánom is én', 181, '2017-09-22', NULL, 'magyar'),
(5879, 'Švejk vagyok', NULL, '2016-02-13', NULL, 'magyar'),
(5880, 'István király', 82, '2013-08-20', 'opera', 'magyar'),
(5881, 'Rémusz bácsi meséi', 13, '2012-10-21', 'mesejáték', 'magyar'),
(5882, 'Ábrándok', 143, '2017-02-15', NULL, 'magyar'),
(5883, 'Az üveganya', 185, '2013-02-06', 'tragikomédia', 'magyar'),
(5884, 'Hosszúhajú veszedelem', 56, '2013-12-14', 'vígjáték', 'magyar'),
(5885, 'Színészbeszéd', 140, '2019-04-27', NULL, NULL),
(5886, 'Meggyeskert', NULL, '2018-05-15', NULL, NULL),
(5887, 'Csárdáskirálynő', 134, '2017-09-29', 'operett', 'magyar'),
(5888, 'A bűvös szekrény', 22, '2017-05-12', 'meseopera', NULL),
(5889, 'Cseresznyéskert', 57, '2019-03-09', 'komédia', NULL),
(5890, 'Figaro házassága', 181, '2016-04-15', 'vígjáték', 'magyar'),
(5891, 'Portugál', 9, '2013-05-03', 'tragikomédia', 'magyar'),
(5892, 'Gioco Delle Coppie', 25, '2017-04-22', 'táncelőadás', NULL),
(5893, 'Százlábúak láb alatt', 28, '2012-12-01', 'gyermekelőadás', 'magyar'),
(5894, 'Mágnás Miska', 48, '2012-12-20', NULL, NULL),
(5895, 'Lovagias ügy', 126, '2019-01-22', 'vígjáték', NULL),
(5896, 'Hun vagyunk?', 194, '2013-03-23', 'színjáték', 'magyar'),
(5897, 'Mire gondol Alma?', 43, '2019-03-21', 'csecsemő színház', NULL),
(5898, 'Black Comedy', 73, '2021-10-15', 'komédia', NULL),
(5899, 'Két szék között', 152, '2015-02-28', 'vígjáték', 'magyar'),
(5900, 'Tótferi', 53, '2019-04-06', 'misztériumjáték', NULL),
(5901, 'A kétbalkezes varázsló', 134, '2012-03-07', 'mesejáték', 'magyar'),
(5902, 'projekt_LULU', 201, '2015-03-05', 'színmű', 'magyar'),
(5903, 'Nyaralás', 136, '2019-09-22', 'táncelőadás', NULL);

CREATE TABLE `szinhaz` (
  `id` int(11) NOT NULL,
  `nev` varchar(100) COLLATE utf8mb4_hungarian_ci NOT NULL,
  `szekhely` varchar(30) COLLATE utf8mb4_hungarian_ci NOT NULL,
  `belfoldi` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_hungarian_ci;

INSERT INTO `szinhaz` (`id`, `nev`, `szekhely`, `belfoldi`) VALUES
(1, 'Térszínház', 'Budapest', 1),
(2, 'Y Csoport', 'Budapest', 1),
(3, 'Kecskemét City Balett', 'Kecskemét', 1),
(4, 'Bóbita Bábszínház', 'Pécs', 1),
(5, 'Stand Up Brigád', 'Budapest', 1),
(6, 'Pinceszínház', 'Budapest', 1),
(7, 'Kolozsvári Állami Magyar Színház', 'Kolozsvár', 0),
(8, 'MU Színház', 'Budapest', 1),
(9, 'Weöres Sándor Színház', 'Szombathely', 1),
(10, 'Pesti Művész Színház', 'Budapest', 1),
(11, 'Badora Társulat', 'Budapest', 1),
(12, 'Soproni Petőfi Színház', 'Sopron', 1),
(13, 'Harlekin Bábszínház', 'Eger', 1),
(14, 'Szkéné Színház', 'Budapest', 1),
(15, 'Szputnyik Hajózási Társaság - Modern Színház- és Viselkedéskutató Intézet-Labor', 'Budapest', 1),
(16, 'K. V. Társulat', 'Budapest', 1),
(17, 'Kvártélyház Szabadtéri Színház', 'Zalaegerszeg', 1),
(18, 'Baltazár Színház', 'Budapest', 1),
(19, 'Frenák Pál Társulat', 'Budapest', 1),
(20, 'Örkény István Színház', 'Budapest', 1),
(21, 'Kamra', 'Budapest', 1),
(22, 'Magyar Állami Operaház', 'Budapest', 1),
(23, 'Szegedi Nemzeti Színház', 'Szeged', 1),
(24, 'Főnix Színház', 'Budapest', 1),
(25, 'Feledi Project', 'Budapest', 1),
(26, 'Janus Egyetemi Színház', 'Pécs', 1),
(27, 'Vojtina Bábszínház', 'Debrecen', 1),
(28, 'Kolibri Fészek', 'Budapest', 1),
(29, 'Budapesti Operettszínház', 'Budapest', 1),
(30, 'Budaörsi Latinovits Színház', 'Budaörs', 1),
(31, 'Zsámbéki Színházi és Művészeti Bázis', 'Zsámbék', 1),
(32, 'Miskolci Nemzeti Színház', 'Miskolc', 1),
(33, 'Radikális Szabadidő Színház', 'Budapest', 1),
(34, 'Katona József Színház', 'Budapest', 1),
(35, 'Centrál Színház', 'Budapest', 1),
(36, 'RS9 Színház', 'Budapest', 1),
(37, 'SZINDRA társulat', 'Budapest', 1),
(38, 'Mesebolt Bábszínház', 'Szombathely', 1),
(39, 'Szegedi Szabadtéri Játékok - Dóm tér', 'Szeged', 1),
(40, 'Kolibri Gyermek- és Ifjúsági Színház', 'Budapest', 1),
(41, 'Forte Társulat', 'Budapest', 1),
(42, 'TranzDanz Társulat', 'Budapest', 1),
(43, 'Budapest Bábszínház', 'Budapest', 1),
(44, 'Veszprémi Petőfi Színház', 'Veszprém', 1),
(45, 'Káva Kulturális Műhely', 'Budapest', 1),
(46, 'Kosztolányi Dezső Színház', 'Szabadka', 0),
(47, 'Szigligeti Színház - Lilliput Társulat', 'Nagyvárad', 0),
(48, 'Szabadkai Népszínház Magyar Társulata', 'Szabadka', 0),
(49, 'Pintér Béla és Társulata', 'Budapest', 1),
(50, 'Békéscsabai Jókai Színház', 'Békéscsaba', 1),
(51, 'Hadart Művészeti Társulás', 'Budapest', 1),
(52, 'Muharay Színház', 'Fót', 1),
(53, 'Soltis Lajos Színház', 'Celldömölk', 1),
(54, 'Átrium', 'Budapest', 1),
(55, 'Pataky Klári Társulat', 'Budapest', 1),
(56, 'Turay Ida Színház', 'Budapest', 1),
(57, 'Trojka Színházi Társulás', 'Budapest', 1),
(58, 'Kispesti Kisszínház', 'Budapest', 1),
(59, 'Fedák Sári Színház', 'Budapest', 1),
(60, 'Pesti Színház', 'Budapest', 1),
(61, 'Coincidance Táncszínház', 'Budapest', 1),
(62, 'TÁP Színház', 'Budapest', 1),
(63, 'ÉLŐKÉP Színház', 'Budapest', 1),
(64, 'Spinoza Színház', 'Budapest', 1),
(65, 'Sivasakti Kalánanda Táncszínház', 'Budapest', 1),
(66, 'Tamási Áron Színház', 'Sepsiszentgyörgy', 0),
(67, 'Kőszegi Várszínház', 'Kőszeg', 1),
(68, 'Orlai Produkciós Iroda', 'Budapest', 1),
(69, 'STÚDIÓ Színház - Művészeti Egyetem', 'Marosvásárhely', 0),
(70, 'Komáromi Jókai Színház', 'Komárom', 1),
(71, 'Dumaszínház', 'Budapest', 1),
(72, 'Gangary Dance Company', 'Budapest', 1),
(73, 'Szigligeti Színház', 'Szolnok', 1),
(74, 'Fém Arts & Café', 'Budapest', 1),
(75, 'Pécsi Horvát Színház', 'Pécs', 1),
(76, 'Jászai Mari Színház, Népház', 'Tatabánya', 1),
(77, 'Bárka Színház', 'Budapest', 1),
(78, 'Közép-Európa Táncszínház', 'Budapest', 1),
(79, 'Rózsavölgyi Szalon Arts & Café', 'Budapest', 1),
(80, 'Győri Balett', 'Győr', 1),
(81, 'Kultúrbrigád', 'Budapest', 1),
(82, 'Margitszigeti Szabadtéri Színpad', 'Budapest', 1),
(83, 'Magyar Színház', 'Budapest', 1),
(84, 'Magyar Állami Népi Együttes', 'Budapest', 1),
(85, 'Városmajori Szabadtéri Színpad', 'Budapest', 1),
(86, 'Magyar Nemzeti Balett', 'Budapest', 1),
(87, 'Müpa', 'Budapest', 1),
(88, 'Ciróka Bábszínház', 'Kecskemét', 1),
(89, 'Láthatáron Csoport', 'Budapest', 1),
(90, 'Momentán Társulat', 'Budapest', 1),
(91, 'SÍN Kulturális Központ', 'Budapest', 1),
(92, 'Gyulai Várszínház', 'Gyula', 1),
(93, 'Fészek Színház / JEMOL', 'Budapest', 1),
(94, 'Uránia Nemzeti Filmszínház', 'Budapest', 1),
(95, 'Vörösmarty Színház', 'Székesfehérvár', 1),
(96, 'KOMA Bázis', 'Budapest', 1),
(97, 'Club Színház', 'Gödöllő', 1),
(98, 'Szekszárdi Német Színház', 'Szekszárd', 1),
(99, 'Pécsi Nemzeti Színház', 'Pécs', 1),
(100, 'Veres 1 Színház', 'Veresegyház', 1),
(101, 'Nézőművészeti Kft.', 'Budapest', 1),
(102, 'József Attila Színház', 'Budapest', 1),
(103, 'ExperiDance Produkció', 'Budapest', 1),
(104, 'Gangaray Dance Company', 'Budapest', 1),
(105, 'Újvidéki Színház', 'Újvidék', 0),
(106, 'Holdvilág Kamaraszínház', 'Budapest', 1),
(107, 'Góbi Rita Társulat', 'Budapest', 1),
(108, 'Csíki Játékszín', 'Csíkszereda', 0),
(109, 'Gárdonyi Géza Színház', 'Eger', 1),
(110, 'k2 Színház', 'Budapest', 1),
(111, 'Váci Dunakanyar Színház', 'Vác', 1),
(112, 'Vaskakas Bábszínház', 'Győr', 1),
(113, 'Miskolci Csodamalom Bábszínház', 'Miskolc', 1),
(114, 'Játékszín', 'Budapest', 1),
(115, 'Pécsi Balett', 'Pécs', 1),
(116, 'Kövér Béla Bábszínház', 'Szeged', 1),
(117, 'Belvárosi Színház', 'Budapest', 1),
(118, 'Madách Színház', 'Budapest', 1),
(119, 'Cervinus Teátrum', 'Szarvas', 1),
(120, 'Spirita Társulat', 'Budapest', 1),
(121, 'Karinthy Színház', 'Budapest', 1),
(122, 'Csokonai Színház', 'Debrecen', 1),
(123, 'Bethlen Téri Színház', 'Budapest', 1),
(124, 'Jurányi Produkciós Közösségi Inkubátorház', 'Budapest', 1),
(125, 'Inversedance - Fodor Zoltán Társulata', 'Budapest', 1),
(126, 'Zenthe Ferenc Színház', 'Salgótarján', 1),
(127, 'STEREO AKT', 'Budapest', 1),
(128, 'Maladype Színház', 'Budapest', 1),
(129, 'Móricz Zsigmond Színház', 'Nyíregyháza', 1),
(130, 'Bartók Kamaraszínház és Művészetek Háza', 'Dunaújváros', 1),
(131, 'Griff Bábszínház', 'Zalaegerszeg', 1),
(132, 'Proton Színház', 'Budapest', 1),
(133, 'Tünet Együttes', 'Budapest', 1),
(134, 'Kecskeméti Katona József Színház', 'Kecskemét', 1),
(135, 'Artus', 'Budapest', 1),
(136, 'Bozsik Yvette Társulat', 'Budapest', 1),
(137, 'Szegedi Kortárs Balett', 'Szeged', 1),
(138, 'Mozsár Műhely', 'Budapest', 1),
(139, 'Napsugár Bábszínház', 'Békéscsaba', 1),
(140, 'Színház- és Filmművészeti Egyetem (Ódry Színpad)', 'Budapest', 1),
(141, 'Csiky Gergely Állami Magyar Színház', 'Temesvár', 0),
(142, 'Medve Színpad', 'Budapest', 1),
(143, 'Gózon Gyula Kamaraszínház', 'Budapest', 1),
(144, 'Stúdió K Színház', 'Budapest', 1),
(145, 'Szentendrei Teátrum és Nyár', 'Szentendre', 1),
(146, 'Hybridkult Produkció', 'Budapest', 1),
(147, 'Papp László Budapest Sportaréna', 'Budapest', 1),
(148, 'Győri Nemzeti Színház', 'Győr', 1),
(149, 'Éless-Szín', 'Budapest', 1),
(150, 'Erkel Színház', 'Budapest', 1),
(151, 'Veszprémi Kabóca Bábszínház', 'Veszprém', 1),
(152, 'Thália Színház', 'Budapest', 1),
(153, 'KoMod - színház', 'Budapest', 1),
(154, 'Magyar Nemzeti Táncegyüttes (volt Honvéd Táncszínház)', 'Budapest', 1),
(155, 'Gólem Színház', 'Budapest', 1),
(156, 'Fővárosi Nagycirkusz', 'Budapest', 1),
(157, 'Nemzeti Színház', 'Budapest', 1),
(158, 'Gergye Krisztián Társulat', 'Budapest', 1),
(159, 'Kazán István Kamaraszínház', 'Budapest', 1),
(160, 'Kolibri Pince', 'Budapest', 1),
(161, '011- Alkotócsoport', 'Budapest', 1),
(162, 'Újszínház', 'Budapest', 1),
(163, 'Szegedi Pinceszínház', 'Szeged', 1),
(164, 'KB35 Társulat', 'Inárcs', 1),
(165, 'Marosvásárhelyi Nemzeti Színház Tompa Miklós Társulata', 'Marosvásárhely', 0),
(166, 'Dollár Papa Gyermekei', 'Budapest', 1),
(167, 'Duna Táncműhely', 'Budapest', 1),
(168, 'Vidám Színpad', 'Budapest', 1),
(169, 'Bakelit Multi Art Center', 'Budapest', 1),
(170, 'Vígszínház', 'Budapest', 1),
(171, 'Sanyi és Aranka Színház', 'Budapest', 1),
(172, 'Figura Stúdió Színház', 'Gyergyószentmiklós', 0),
(173, 'Trafó', 'Budapest', 1),
(174, 'Ivancsics Ilona és Színtársai', 'Szentendre', 1),
(175, 'MáSzínház', 'Budapest', 1),
(176, 'Ascher Oszkár Színház', 'Budapest', 1),
(177, 'Fogi Gyermekszínház', 'Budapest', 1),
(178, 'Duna Művészegyüttes', 'Budapest', 1),
(179, 'Hodworks', 'Budapest', 1),
(180, 'HOPPart Társulat', 'Budapest', 1),
(181, 'Csiky Gergely Színház', 'Kaposvár', 1),
(182, 'Spirit Színház', 'Budapest', 1),
(183, 'Szigligeti Színház - Nagyvárad Táncegyüttes', 'Nagyvárad', 0),
(184, 'FAQ Társulat', 'Győr', 1),
(185, 'Hevesi Sándor Színház', 'Zalaegerszeg', 1),
(186, 'Székelyudvarhelyi Tomcsa Sándor Színház', 'Székelyudvarhely', 0),
(187, 'Tesla Teátrum', 'Budapest', 1),
(188, 'Zadam Társulat', 'Budapest', 1),
(189, 'Székesfehérvári Balett Színház', 'Székesfehérvár', 1),
(190, 'Radnóti Színház', 'Budapest', 1),
(191, 'Nemzeti Táncszínház', 'Budapest', 1),
(192, 'Szatmárnémeti Északi Színház - Harag György Társulat', 'Szatmárnémeti', 0),
(193, 'Budapest Táncszínház', 'Budapest', 1),
(194, 'Fészek Színház', 'Budapest', 1),
(195, 'Pannon Várszínház', 'Veszprém', 1),
(196, 'Gárdonyi Géza Színház és Babszem Jankó Meseszínház', 'Eger', 1),
(197, 'Duda Éva Társulat', 'Budapest', 1),
(198, 'GG Tánc Eger', 'Eger', 1),
(199, 'Miskolci Balett', 'Miskolc', 1),
(200, 'FÜGE Produkció', 'Budapest', 1),
(201, 'Manna Produkció', 'Budapest', 1),
(202, 'Pécsi Harmadik Színház', 'Pécs', 1),
(203, 'Scallabouche', 'Budapest', 1);

CREATE TABLE `tulajdonsag` (
  `id` int(11) NOT NULL,
  `eloadasid` int(11) NOT NULL,
  `nev` varchar(15) COLLATE utf8mb4_hungarian_ci NOT NULL,
  `ertek` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_hungarian_ci;

INSERT INTO `tulajdonsag` (`id`, `eloadasid`, `nev`, `ertek`) VALUES
(1, 1383, 'felvonás', 2),
(2, 1898, 'ig', 14),
(3, 3822, 'ig', 14),
(4, 4634, 'felvonás', 3),
(5, 1312, 'felvonás', 2),
(6, 1746, 'perc', 25),
(7, 174, 'felvonás', 5),
(8, 2189, 'ig', 99),
(10, 2344, 'ig', 12),
(14, 2320, 'tol', 12),
(17, 2688, 'felvonás', 1),
(18, 4654, 'ig', 99),
(19, 2323, 'ig', 14),
(20, 1234, 'felvonás', 2),
(22, 2445, 'felvonás', 2),
(26, 332, 'ig', 99),
(27, 3110, 'perc', 150),
(31, 236, 'perc', 38),
(32, 5855, 'ig', 99),
(33, 4578, 'ig', 10),
(40, 1098, 'perc', 50),
(44, 5120, 'tol', 3),
(45, 1342, 'tol', 1),
(46, 2794, 'ig', 14),
(47, 4522, 'tol', 14),
(49, 1742, 'ig', 99),
(50, 3237, 'felvonás', 1),
(51, 3084, 'tol', 4),
(53, 2284, 'tol', 3),
(56, 3979, 'ig', 99),
(57, 2743, 'ig', 12),
(63, 483, 'ig', 3),
(64, 1924, 'ig', 14),
(65, 4439, 'felvonás', 2),
(66, 5896, 'felvonás', 1),
(69, 4627, 'ig', 12),
(70, 2351, 'felvonás', 2),
(73, 5345, 'tol', 7),
(76, 1326, 'felvonás', 5),
(80, 1937, 'perc', 110),
(84, 2705, 'perc', 105),
(85, 2749, 'perc', 50),
(86, 3662, 'felvonás', 1),
(90, 1932, 'perc', 95),
(94, 5331, 'perc', 100),
(95, 927, 'perc', 50),
(96, 3000, 'felvonás', 2),
(97, 1526, 'tol', 10),
(98, 5341, 'ig', 99),
(99, 3174, 'felvonás', 2),
(102, 2917, 'ig', 8),
(105, 1019, 'felvonás', 2),
(106, 226, 'ig', 5),
(108, 5297, 'tol', 15),
(109, 1799, 'perc', 52),
(110, 986, 'perc', 45),
(111, 5843, 'ig', 12),
(112, 3428, 'felvonás', 2),
(117, 2923, 'perc', 70),
(118, 4637, 'felvonás', 2),
(119, 2795, 'felvonás', 1),
(122, 4914, 'tol', 6),
(123, 1507, 'ig', 12),
(124, 2537, 'felvonás', 1),
(125, 1234, 'perc', 180),
(126, 4031, 'felvonás', 3),
(131, 4864, 'felvonás', 2),
(132, 301, 'felvonás', 3),
(136, 3345, 'ig', 14),
(137, 1415, 'perc', 140),
(138, 3191, 'tol', 6),
(139, 3837, 'felvonás', 2),
(145, 3269, 'ig', 99),
(149, 5760, 'ig', 14),
(150, 5179, 'felvonás', 2),
(151, 5770, 'felvonás', 2),
(152, 2727, 'felvonás', 1),
(153, 1627, 'tol', 3),
(154, 5068, 'felvonás', 2),
(158, 861, 'perc', 40),
(159, 1982, 'ig', 99),
(160, 1482, 'perc', 60),
(161, 192, 'felvonás', 2),
(164, 4057, 'ig', 14),
(165, 755, 'ig', 99),
(166, 3339, 'perc', 70),
(171, 4595, 'felvonás', 2),
(172, 3947, 'ig', 12),
(173, 1580, 'tol', 8),
(181, 3524, 'felvonás', 2),
(183, 3433, 'tol', 16),
(184, 4124, 'felvonás', 1),
(187, 451, 'tol', 4),
(191, 4636, 'felvonás', 2),
(192, 961, 'tol', 4),
(193, 4874, 'tol', 6),
(196, 3143, 'tol', 6),
(199, 110, 'felvonás', 2),
(201, 1702, 'felvonás', 1),
(202, 1065, 'ig', 4),
(203, 3062, 'ig', 10),
(205, 4541, 'ig', 12),
(208, 235, 'perc', 60),
(210, 2333, 'felvonás', 2),
(211, 302, 'perc', 135),
(212, 5121, 'felvonás', 2),
(213, 3345, 'felvonás', 1),
(215, 600, 'felvonás', 2),
(217, 4342, 'tol', 4),
(218, 2554, 'ig', 4),
(220, 2162, 'ig', 6),
(221, 1385, 'tol', 6),
(223, 5068, 'perc', 140),
(224, 5605, 'tol', 5),
(230, 4001, 'perc', 110),
(231, 1212, 'ig', 12),
(232, 1663, 'felvonás', 2),
(233, 3903, 'felvonás', 1),
(236, 2140, 'felvonás', 2),
(240, 1458, 'tol', 18),
(241, 988, 'felvonás', 2),
(242, 3252, 'perc', 55),
(243, 4235, 'felvonás', 2),
(246, 223, 'felvonás', 2),
(249, 965, 'perc', 70),
(251, 899, 'tol', 3),
(252, 1334, 'ig', 12),
(254, 4729, 'felvonás', 1),
(256, 5703, 'ig', 4),
(258, 202, 'felvonás', 2),
(259, 3359, 'ig', 9),
(263, 2053, 'tol', 3),
(264, 4199, 'felvonás', 2),
(267, 3176, 'perc', 100),
(269, 1944, 'tol', 14),
(271, 371, 'felvonás', 3),
(272, 4130, 'tol', 16),
(277, 3294, 'ig', 99),
(278, 5638, 'ig', 99),
(282, 5248, 'felvonás', 2),
(283, 1406, 'tol', 14),
(289, 4455, 'perc', 80),
(291, 1601, 'ig', 10),
(294, 5622, 'perc', 35),
(296, 9, 'tol', 3),
(298, 1977, 'perc', 120),
(302, 3294, 'tol', 5),
(305, 932, 'tol', 4),
(306, 5668, 'tol', 5),
(309, 5387, 'ig', 99),
(315, 3852, 'perc', 60),
(316, 5684, 'tol', 10),
(317, 1372, 'felvonás', 2),
(318, 1856, 'felvonás', 2),
(321, 2721, 'felvonás', 3),
(322, 5378, 'felvonás', 2),
(325, 1228, 'perc', 45),
(333, 1082, 'tol', 5),
(335, 767, 'felvonás', 2),
(336, 2656, 'felvonás', 2),
(337, 1127, 'perc', 120),
(338, 3000, 'tol', 6),
(339, 2068, 'perc', 70),
(346, 4120, 'felvonás', 2),
(348, 1381, 'tol', 18),
(349, 1615, 'felvonás', 1),
(350, 2919, 'perc', 100),
(351, 3604, 'tol', 3),
(352, 5397, 'perc', 180),
(353, 5009, 'tol', 4),
(354, 2829, 'tol', 15),
(356, 221, 'tol', 3),
(357, 2787, 'tol', 3),
(365, 3707, 'tol', 6),
(366, 2188, 'felvonás', 2),
(368, 2642, 'ig', 11),
(370, 3300, 'felvonás', 1),
(371, 3799, 'felvonás', 2),
(374, 5429, 'felvonás', 1),
(375, 759, 'tol', 4),
(376, 479, 'perc', 60),
(377, 2246, 'felvonás', 2),
(378, 515, 'perc', 60),
(379, 4962, 'ig', 10),
(380, 2131, 'felvonás', 3),
(382, 1024, 'felvonás', 1),
(384, 3741, 'perc', 40),
(386, 2844, 'perc', 70),
(387, 4224, 'felvonás', 2),
(388, 2921, 'tol', 12),
(389, 1707, 'felvonás', 2),
(390, 2650, 'felvonás', 3),
(391, 5435, 'felvonás', 2),
(392, 112, 'felvonás', 2),
(393, 4684, 'tol', 6),
(394, 4195, 'ig', 14),
(398, 2056, 'tol', 3),
(399, 2555, 'tol', 18),
(400, 3782, 'ig', 10),
(403, 1820, 'felvonás', 1),
(404, 3943, 'felvonás', 2),
(407, 3982, 'perc', 100),
(408, 2025, 'ig', 14),
(409, 4085, 'perc', 80),
(410, 1004, 'tol', 10),
(411, 2276, 'tol', 4),
(414, 4913, 'perc', 120),
(415, 5401, 'ig', 99),
(416, 5561, 'tol', 6),
(417, 1281, 'felvonás', 2),
(418, 1138, 'ig', 14),
(419, 5196, 'ig', 99),
(420, 4087, 'felvonás', 1),
(421, 1298, 'felvonás', 1),
(423, 80, 'tol', 6),
(426, 2051, 'perc', 60),
(427, 2063, 'tol', 4),
(428, 756, 'felvonás', 1),
(431, 4036, 'ig', 99),
(432, 5311, 'perc', 150),
(434, 5451, 'ig', 99),
(435, 5457, 'tol', 4),
(439, 3737, 'tol', 6),
(440, 5561, 'ig', 18),
(441, 4255, 'tol', 9),
(444, 4249, 'ig', 10),
(446, 3877, 'felvonás', 2),
(447, 1121, 'felvonás', 2),
(448, 5627, 'tol', 10),
(451, 5537, 'ig', 99),
(452, 5224, 'tol', 14),
(453, 1918, 'ig', 10),
(454, 3813, 'ig', 14),
(455, 1484, 'perc', 80),
(456, 4088, 'tol', 3),
(457, 2899, 'ig', 14),
(458, 5729, 'felvonás', 2),
(461, 1799, 'felvonás', 1),
(462, 3301, 'perc', 50),
(465, 1615, 'perc', 170),
(469, 4081, 'felvonás', 1),
(470, 2825, 'ig', 12),
(472, 1915, 'tol', 3),
(473, 304, 'ig', 14),
(474, 2073, 'perc', 70),
(475, 4853, 'tol', 5),
(476, 1943, 'felvonás', 3),
(477, 3699, 'tol', 12),
(479, 3554, 'ig', 12),
(484, 5748, 'tol', 7),
(485, 2362, 'ig', 14),
(486, 1397, 'felvonás', 2),
(487, 3317, 'ig', 99),
(490, 3740, 'tol', 6),
(492, 5170, 'felvonás', 2),
(494, 2336, 'ig', 3),
(496, 1310, 'tol', 4),
(497, 905, 'tol', 3),
(499, 5008, 'felvonás', 2),
(508, 2081, 'ig', 14),
(512, 1057, 'ig', 14),
(513, 1862, 'felvonás', 3),
(515, 3303, 'felvonás', 2),
(516, 23, 'tol', 14),
(519, 3403, 'felvonás', 3),
(520, 4087, 'tol', 3),
(522, 5101, 'tol', 4),
(523, 4242, 'felvonás', 2),
(526, 5786, 'ig', 99),
(527, 1660, 'tol', 4),
(529, 1511, 'ig', 14),
(530, 2982, 'ig', 99),
(531, 2687, 'tol', 3),
(532, 4144, 'perc', 70),
(533, 5145, 'ig', 99),
(534, 4877, 'felvonás', 2),
(537, 4759, 'ig', 12),
(539, 4313, 'perc', 40),
(541, 2377, 'perc', 120),
(543, 5710, 'felvonás', 1),
(548, 4459, 'ig', 14),
(550, 1685, 'perc', 50),
(551, 4339, 'felvonás', 1),
(553, 3516, 'felvonás', 1),
(556, 4876, 'ig', 99),
(557, 1669, 'ig', 12),
(558, 1748, 'ig', 12),
(559, 4055, 'tol', 3),
(564, 5000, 'felvonás', 2),
(567, 5099, 'ig', 99),
(569, 1327, 'felvonás', 2),
(571, 1900, 'tol', 3),
(574, 4365, 'tol', 3),
(575, 4583, 'felvonás', 1),
(577, 3523, 'tol', 3),
(579, 2276, 'ig', 10),
(581, 4087, 'ig', 99),
(583, 4576, 'perc', 150),
(584, 665, 'tol', 14),
(585, 4358, 'tol', 12),
(587, 3589, 'ig', 99),
(588, 1592, 'felvonás', 2),
(591, 5179, 'ig', 99),
(592, 2099, 'felvonás', 2),
(593, 4017, 'tol', 3),
(595, 2882, 'felvonás', 2),
(596, 2144, 'tol', 3),
(597, 4910, 'perc', 60),
(598, 1532, 'tol', 4),
(600, 3041, 'ig', 99),
(601, 4362, 'felvonás', 1),
(602, 3277, 'perc', 90),
(604, 5254, 'ig', 10),
(608, 4993, 'felvonás', 1),
(609, 134, 'felvonás', 4),
(612, 3984, 'ig', 10),
(613, 448, 'felvonás', 2),
(616, 3104, 'ig', 14),
(617, 1797, 'felvonás', 1),
(618, 1020, 'perc', 100),
(619, 5680, 'tol', 7),
(622, 4162, 'perc', 60),
(626, 2673, 'tol', 6),
(627, 4600, 'felvonás', 1),
(628, 2046, 'felvonás', 1),
(631, 4541, 'tol', 3),
(636, 4109, 'felvonás', 1),
(638, 5179, 'perc', 90),
(639, 4144, 'ig', 10),
(640, 205, 'ig', 3),
(643, 3197, 'perc', 90),
(644, 5081, 'felvonás', 2),
(645, 154, 'perc', 70),
(647, 2304, 'ig', 99),
(648, 5761, 'ig', 99),
(650, 2707, 'ig', 6),
(651, 3649, 'tol', 3),
(652, 2692, 'tol', 3),
(656, 714, 'felvonás', 1),
(657, 5098, 'perc', 110),
(658, 3024, 'perc', 155),
(660, 5648, 'felvonás', 1),
(662, 3190, 'tol', 3),
(663, 5824, 'felvonás', 1),
(668, 166, 'perc', 100),
(669, 1386, 'tol', 16),
(671, 3469, 'perc', 130),
(674, 2909, 'felvonás', 3),
(676, 3932, 'felvonás', 1),
(685, 52, 'tol', 1),
(700, 3294, 'felvonás', 1),
(701, 2918, 'felvonás', 1),
(704, 2004, 'tol', 4),
(705, 4472, 'ig', 99),
(707, 2554, 'tol', 1),
(708, 1004, 'perc', 120),
(709, 5843, 'tol', 9),
(710, 3236, 'tol', 3),
(713, 568, 'ig', 14),
(714, 2440, 'perc', 100),
(716, 850, 'perc', 45),
(717, 1093, 'ig', 99),
(719, 5429, 'ig', 10),
(720, 4497, 'felvonás', 1),
(721, 5646, 'ig', 10),
(723, 2986, 'tol', 12),
(724, 4984, 'tol', 9),
(725, 1742, 'tol', 10),
(729, 641, 'perc', 110),
(733, 477, 'felvonás', 2),
(735, 4573, 'tol', 16),
(739, 5852, 'tol', 6),
(740, 5366, 'tol', 3),
(741, 2535, 'felvonás', 2),
(745, 2501, 'perc', 140),
(746, 5179, 'tol', 10),
(747, 375, 'felvonás', 2),
(750, 2316, 'ig', 14),
(751, 3079, 'felvonás', 2),
(754, 848, 'felvonás', 1),
(757, 4804, 'felvonás', 3),
(758, 4911, 'tol', 3),
(761, 672, 'felvonás', 3),
(763, 5898, 'felvonás', 2),
(764, 3710, 'tol', 3),
(765, 4433, 'felvonás', 1),
(766, 484, 'ig', 10),
(767, 669, 'tol', 9),
(769, 3130, 'tol', 3),
(772, 3614, 'ig', 99),
(773, 1819, 'perc', 60),
(775, 700, 'tol', 3),
(778, 750, 'tol', 3),
(779, 96, 'felvonás', 3),
(783, 3183, 'felvonás', 2),
(787, 3115, 'tol', 14),
(792, 2998, 'felvonás', 2),
(794, 1562, 'ig', 105),
(797, 4099, 'ig', 12),
(799, 4187, 'tol', 14),
(800, 1839, 'felvonás', 2),
(801, 5024, 'felvonás', 3),
(805, 3147, 'tol', 4),
(807, 4611, 'felvonás', 2),
(808, 5377, 'felvonás', 2),
(809, 2505, 'ig', 99),
(810, 3658, 'felvonás', 1),
(811, 1971, 'ig', 10),
(814, 5293, 'perc', 70),
(815, 4404, 'perc', 20),
(817, 2994, 'perc', 90),
(821, 4627, 'tol', 3),
(822, 5764, 'felvonás', 2),
(823, 2015, 'felvonás', 2),
(824, 2932, 'tol', 14),
(826, 5416, 'perc', 50),
(827, 682, 'perc', 50),
(830, 972, 'felvonás', 2),
(831, 4681, 'felvonás', 2),
(833, 799, 'felvonás', 1),
(834, 37, 'felvonás', 2),
(835, 3835, 'felvonás', 2),
(837, 2418, 'perc', 50),
(838, 1063, 'ig', 3),
(840, 2162, 'tol', 3),
(841, 3451, 'tol', 3),
(843, 2925, 'perc', 40),
(848, 4223, 'felvonás', 3),
(849, 1008, 'perc', 150),
(850, 3719, 'felvonás', 2),
(851, 1262, 'ig', 10),
(853, 1984, 'tol', 6),
(854, 751, 'ig', 4),
(855, 4944, 'tol', 3),
(858, 2653, 'perc', 70),
(859, 3516, 'ig', 99),
(860, 2269, 'tol', 15),
(862, 2002, 'felvonás', 2),
(863, 665, 'felvonás', 2),
(864, 4656, 'tol', 16),
(867, 2719, 'tol', 10),
(868, 3642, 'ig', 3),
(869, 402, 'tol', 3),
(871, 766, 'felvonás', 2),
(873, 565, 'ig', 16),
(875, 671, 'felvonás', 3),
(876, 901, 'ig', 10),
(877, 905, 'ig', 14),
(878, 4960, 'tol', 4),
(881, 1741, 'ig', 14),
(882, 3568, 'ig', 12),
(884, 5137, 'felvonás', 1),
(886, 4551, 'tol', 5),
(887, 456, 'perc', 105),
(889, 1050, 'tol', 6),
(891, 5305, 'ig', 99),
(893, 1312, 'tol', 4),
(894, 3198, 'ig', 14),
(900, 4159, 'tol', 3),
(901, 3252, 'tol', 6),
(902, 848, 'perc', 45),
(903, 2057, 'ig', 14),
(904, 2240, 'tol', 3),
(906, 423, 'ig', 13),
(911, 4476, 'felvonás', 1),
(914, 3259, 'felvonás', 1),
(915, 2993, 'tol', 3),
(917, 3970, 'perc', 60),
(921, 5563, 'tol', 6),
(922, 2987, 'tol', 4),
(924, 2960, 'felvonás', 1),
(925, 342, 'ig', 14),
(926, 1101, 'tol', 1),
(928, 2525, 'tol', 6),
(930, 2862, 'tol', 8),
(933, 3164, 'felvonás', 3),
(935, 1546, 'perc', 90),
(939, 4452, 'tol', 5),
(944, 3953, 'felvonás', 2),
(946, 1659, 'perc', 90),
(947, 5711, 'felvonás', 2),
(951, 2759, 'tol', 12),
(955, 4909, 'tol', 3),
(956, 1691, 'tol', 4),
(957, 1569, 'tol', 3),
(958, 2652, 'perc', 120),
(960, 4135, 'tol', 14),
(962, 3979, 'tol', 3),
(964, 4962, 'tol', 3),
(966, 3833, 'felvonás', 2),
(969, 1075, 'ig', 99),
(970, 4463, 'tol', 16),
(971, 5587, 'ig', 14),
(972, 3873, 'tol', 3),
(977, 3972, 'perc', 60),
(979, 2534, 'felvonás', 2),
(980, 4951, 'perc', 100),
(982, 5118, 'tol', 5),
(983, 144, 'felvonás', 2),
(984, 1812, 'tol', 7),
(985, 409, 'felvonás', 2),
(986, 2654, 'tol', 3),
(987, 2406, 'felvonás', 1),
(990, 5325, 'perc', 100),
(991, 4685, 'perc', 50),
(994, 1511, 'felvonás', 2),
(999, 4931, 'tol', 5),
(1004, 1140, 'felvonás', 2),
(1005, 3549, 'ig', 14),
(1007, 4156, 'felvonás', 1),
(1010, 5709, 'ig', 10),
(1012, 5832, 'perc', 120),
(1014, 660, 'ig', 10),
(1017, 5870, 'felvonás', 2),
(1020, 3943, 'perc', 90),
(1022, 472, 'felvonás', 3),
(1024, 3345, 'tol', 6),
(1025, 1787, 'tol', 4),
(1026, 504, 'felvonás', 3),
(1029, 2487, 'perc', 130),
(1031, 5817, 'ig', 99),
(1033, 3577, 'tol', 8),
(1035, 3516, 'perc', 55),
(1038, 506, 'ig', 99),
(1043, 1208, 'perc', 120),
(1046, 3108, 'perc', 80),
(1049, 1073, 'ig', 99),
(1053, 1912, 'ig', 99),
(1055, 1097, 'perc', 150),
(1056, 5593, 'tol', 10),
(1058, 510, 'felvonás', 2),
(1059, 4025, 'ig', 99),
(1060, 5682, 'felvonás', 1),
(1061, 5867, 'tol', 6),
(1062, 2186, 'felvonás', 2),
(1064, 3765, 'felvonás', 2),
(1065, 5714, 'tol', 10),
(1068, 4040, 'tol', 3),
(1069, 1480, 'perc', 80),
(1071, 578, 'felvonás', 2),
(1073, 2807, 'felvonás', 2),
(1074, 11, 'ig', 99),
(1075, 3945, 'felvonás', 2),
(1077, 1819, 'felvonás', 1),
(1079, 2218, 'felvonás', 2),
(1081, 2793, 'felvonás', 2),
(1082, 689, 'ig', 14),
(1083, 3640, 'perc', 60),
(1085, 2070, 'ig', 99),
(1086, 4059, 'felvonás', 1),
(1090, 2402, 'felvonás', 1),
(1092, 260, 'tol', 3),
(1093, 3832, 'felvonás', 2),
(1094, 185, 'felvonás', 2),
(1095, 1168, 'tol', 3),
(1096, 4902, 'tol', 14),
(1098, 5088, 'perc', 125),
(1099, 344, 'perc', 45),
(1100, 573, 'perc', 60),
(1101, 5622, 'felvonás', 1),
(1103, 942, 'ig', 12),
(1109, 1950, 'felvonás', 3),
(1113, 835, 'ig', 2),
(1114, 3862, 'perc', 90),
(1115, 3677, 'perc', 40),
(1118, 4362, 'tol', 6),
(1119, 4948, 'ig', 99),
(1120, 4194, 'tol', 4),
(1121, 4904, 'tol', 4),
(1122, 4894, 'felvonás', 3),
(1123, 5061, 'perc', 140),
(1124, 3830, 'tol', 16),
(1125, 4720, 'ig', 14),
(1126, 5099, 'tol', 6),
(1128, 4604, 'ig', 14),
(1135, 14, 'tol', 6),
(1136, 5487, 'perc', 60),
(1137, 591, 'felvonás', 1),
(1139, 5729, 'perc', 140),
(1140, 1528, 'tol', 12),
(1141, 4773, 'felvonás', 2),
(1143, 156, 'tol', 4),
(1145, 4748, 'ig', 14),
(1146, 1300, 'perc', 55),
(1147, 19, 'felvonás', 2),
(1151, 1580, 'perc', 150),
(1152, 2695, 'ig', 10),
(1154, 1749, 'tol', 5),
(1155, 398, 'ig', 3),
(1158, 3859, 'perc', 180),
(1159, 3756, 'tol', 4),
(1161, 5378, 'tol', 6),
(1162, 1111, 'tol', 1),
(1164, 1221, 'tol', 12),
(1166, 1211, 'felvonás', 2),
(1167, 4002, 'tol', 3),
(1168, 1299, 'ig', 99),
(1170, 425, 'ig', 12),
(1173, 5461, 'ig', 6),
(1174, 841, 'perc', 40),
(1176, 2445, 'tol', 14),
(1177, 1437, 'felvonás', 2),
(1180, 3417, 'tol', 10),
(1182, 2502, 'tol', 3),
(1183, 361, 'tol', 4),
(1185, 5853, 'perc', 180),
(1188, 1863, 'tol', 4),
(1189, 5310, 'perc', 90),
(1190, 4356, 'tol', 16),
(1192, 3758, 'ig', 14),
(1195, 928, 'tol', 4),
(1196, 5316, 'felvonás', 2),
(1198, 499, 'ig', 10),
(1199, 1099, 'felvonás', 3),
(1200, 4600, 'perc', 90),
(1204, 2503, 'felvonás', 2),
(1205, 1675, 'felvonás', 2),
(1208, 2178, 'felvonás', 2),
(1210, 2522, 'felvonás', 2),
(1213, 1580, 'felvonás', 2),
(1215, 3382, 'felvonás', 2),
(1218, 3314, 'tol', 5),
(1220, 1459, 'felvonás', 1),
(1222, 3198, 'perc', 40),
(1226, 1310, 'ig', 10),
(1227, 2331, 'ig', 99),
(1229, 5671, 'felvonás', 2),
(1230, 3946, 'perc', 135),
(1231, 3460, 'tol', 10),
(1235, 3852, 'ig', 99),
(1237, 1700, 'perc', 60),
(1242, 2144, 'ig', 6),
(1244, 5376, 'ig', 14),
(1245, 4332, 'tol', 16),
(1247, 649, 'felvonás', 2),
(1249, 1736, 'perc', 80),
(1252, 5350, 'felvonás', 1),
(1253, 157, 'tol', 3),
(1256, 4914, 'felvonás', 1),
(1257, 3150, 'felvonás', 1),
(1258, 3244, 'ig', 14),
(1259, 2862, 'ig', 10),
(1261, 2733, 'felvonás', 2),
(1262, 3411, 'tol', 14),
(1263, 502, 'felvonás', 1),
(1264, 3800, 'felvonás', 2),
(1266, 1096, 'felvonás', 2),
(1268, 4127, 'felvonás', 3),
(1275, 2824, 'tol', 6),
(1277, 5254, 'tol', 6),
(1280, 2076, 'felvonás', 2),
(1282, 259, 'perc', 80),
(1285, 4091, 'tol', 6),
(1288, 3654, 'tol', 3),
(1289, 4876, 'tol', 6),
(1290, 253, 'ig', 99),
(1293, 310, 'felvonás', 2),
(1294, 4131, 'perc', 40),
(1295, 1917, 'perc', 150),
(1297, 2092, 'tol', 16),
(1300, 2547, 'perc', 60),
(1302, 5615, 'felvonás', 3),
(1304, 5455, 'perc', 45),
(1305, 851, 'ig', 12),
(1309, 287, 'perc', 180),
(1310, 1472, 'felvonás', 1),
(1311, 2970, 'felvonás', 2),
(1312, 514, 'felvonás', 2),
(1314, 4734, 'felvonás', 2),
(1317, 2599, 'tol', 18),
(1319, 1168, 'ig', 12),
(1320, 3956, 'ig', 99),
(1321, 3351, 'tol', 4),
(1323, 3971, 'ig', 14),
(1324, 4059, 'ig', 10),
(1326, 5173, 'felvonás', 2),
(1329, 3501, 'perc', 115),
(1330, 2761, 'felvonás', 1),
(1332, 4376, 'tol', 3),
(1333, 1600, 'felvonás', 1),
(1336, 2805, 'perc', 100),
(1337, 522, 'felvonás', 2),
(1338, 4305, 'tol', 14),
(1339, 4024, 'felvonás', 2),
(1343, 4766, 'tol', 4),
(1344, 1749, 'ig', 12),
(1345, 769, 'felvonás', 2),
(1346, 4135, 'felvonás', 2),
(1347, 959, 'tol', 3),
(1348, 737, 'felvonás', 1),
(1350, 2327, 'felvonás', 1),
(1351, 5625, 'tol', 6),
(1352, 5138, 'felvonás', 2),
(1354, 4374, 'felvonás', 2),
(1355, 782, 'felvonás', 2),
(1356, 4395, 'felvonás', 2),
(1357, 344, 'tol', 3),
(1358, 4692, 'ig', 99),
(1360, 2400, 'tol', 10),
(1361, 1523, 'felvonás', 2),
(1364, 1330, 'tol', 5),
(1366, 2385, 'felvonás', 1),
(1370, 65, 'perc', 120),
(1373, 5883, 'felvonás', 4),
(1374, 2862, 'felvonás', 1),
(1375, 5272, 'felvonás', 1),
(1376, 2303, 'ig', 8),
(1377, 2286, 'felvonás', 3),
(1381, 4587, 'perc', 150),
(1383, 5809, 'tol', 4),
(1385, 3763, 'tol', 4),
(1386, 1899, 'felvonás', 2),
(1387, 4013, 'tol', 3),
(1388, 2910, 'ig', 99),
(1389, 566, 'perc', 30),
(1391, 3620, 'tol', 3),
(1395, 5180, 'tol', 10),
(1397, 5677, 'tol', 8),
(1398, 5751, 'felvonás', 2),
(1403, 5189, 'ig', 99),
(1405, 5862, 'perc', 90),
(1406, 798, 'ig', 3),
(1407, 2918, 'tol', 8),
(1408, 2790, 'ig', 14),
(1409, 3466, 'felvonás', 3),
(1412, 2834, 'ig', 14),
(1414, 4783, 'ig', 10),
(1416, 4296, 'tol', 4),
(1417, 517, 'felvonás', 3),
(1418, 2059, 'tol', 10),
(1419, 3460, 'ig', 99),
(1421, 5457, 'ig', 99),
(1422, 5204, 'ig', 99),
(1424, 1506, 'perc', 60),
(1429, 3692, 'felvonás', 2),
(1431, 3498, 'ig', 14),
(1432, 2442, 'felvonás', 2),
(1436, 1331, 'felvonás', 2),
(1437, 1152, 'tol', 14),
(1438, 380, 'felvonás', 3),
(1439, 4008, 'tol', 3),
(1440, 4058, 'felvonás', 2),
(1441, 1474, 'ig', 14),
(1442, 5096, 'felvonás', 2),
(1444, 4648, 'perc', 75),
(1445, 4853, 'ig', 12),
(1447, 245, 'ig', 14),
(1448, 4706, 'ig', 10),
(1449, 3339, 'ig', 14),
(1453, 2862, 'perc', 50),
(1454, 3668, 'felvonás', 1),
(1455, 1063, 'perc', 40),
(1456, 2216, 'perc', 180),
(1457, 60, 'tol', 16),
(1458, 4491, 'felvonás', 2),
(1459, 4830, 'felvonás', 1),
(1460, 1197, 'perc', 180),
(1461, 4094, 'tol', 3),
(1462, 5066, 'ig', 99),
(1464, 2074, 'perc', 60),
(1465, 5679, 'tol', 10),
(1467, 1417, 'tol', 18),
(1473, 1757, 'perc', 60),
(1474, 310, 'perc', 105),
(1476, 1932, 'felvonás', 2),
(1478, 3523, 'ig', 14),
(1481, 1206, 'ig', 14),
(1484, 4464, 'tol', 3),
(1487, 4364, 'felvonás', 2),
(1488, 2196, 'perc', 60),
(1490, 2683, 'perc', 45),
(1492, 785, 'felvonás', 4),
(1494, 5563, 'ig', 14),
(1495, 2245, 'perc', 90),
(1496, 3061, 'tol', 6),
(1497, 1699, 'perc', 70),
(1498, 449, 'perc', 90),
(1499, 5352, 'ig', 14),
(1501, 5574, 'perc', 135),
(1502, 2829, 'ig', 99),
(1503, 4455, 'felvonás', 1),
(1504, 5447, 'ig', 14),
(1505, 3441, 'tol', 14),
(1507, 864, 'perc', 50),
(1508, 3709, 'perc', 60),
(1509, 1619, 'perc', 140),
(1510, 4752, 'tol', 4),
(1511, 2174, 'tol', 6),
(1512, 1063, 'tol', 1),
(1514, 1752, 'ig', 10),
(1518, 983, 'perc', 110),
(1521, 5388, 'perc', 130),
(1523, 5867, 'ig', 99),
(1524, 1287, 'tol', 3),
(1525, 4158, 'felvonás', 2),
(1526, 1303, 'perc', 45),
(1530, 3065, 'tol', 3),
(1533, 3747, 'tol', 6),
(1534, 1456, 'felvonás', 2),
(1538, 849, 'perc', 50),
(1539, 1643, 'perc', 105),
(1540, 2842, 'felvonás', 2),
(1541, 3609, 'perc', 50),
(1542, 2683, 'tol', 3),
(1543, 3859, 'felvonás', 2),
(1545, 5897, 'tol', 1),
(1547, 2516, 'felvonás', 2),
(1552, 5668, 'ig', 99),
(1553, 1141, 'felvonás', 3),
(1554, 3401, 'perc', 45),
(1558, 3933, 'ig', 14),
(1559, 5129, 'felvonás', 2),
(1560, 5785, 'felvonás', 2),
(1562, 4623, 'tol', 6),
(1564, 5153, 'perc', 155),
(1565, 1808, 'felvonás', 2),
(1566, 1515, 'ig', 6),
(1569, 4205, 'ig', 10),
(1572, 2863, 'tol', 12),
(1573, 822, 'ig', 16),
(1574, 5235, 'tol', 4),
(1575, 2453, 'tol', 18),
(1577, 762, 'felvonás', 2),
(1578, 1384, 'perc', 25),
(1580, 1088, 'ig', 99),
(1581, 2032, 'ig', 10),
(1584, 1867, 'tol', 18),
(1585, 1015, 'tol', 4),
(1592, 4943, 'tol', 12),
(1593, 2278, 'felvonás', 2),
(1594, 4142, 'tol', 1),
(1595, 3924, 'felvonás', 1),
(1599, 4411, 'ig', 18),
(1601, 3218, 'tol', 3),
(1602, 689, 'tol', 6),
(1606, 961, 'ig', 6),
(1607, 3280, 'felvonás', 1),
(1611, 2223, 'perc', 130),
(1615, 3391, 'tol', 6),
(1617, 1893, 'perc', 60),
(1619, 2982, 'tol', 8),
(1621, 1277, 'ig', 12),
(1623, 1858, 'felvonás', 1),
(1625, 1287, 'ig', 6),
(1626, 2787, 'felvonás', 1),
(1627, 849, 'tol', 4),
(1628, 3953, 'tol', 5),
(1630, 2428, 'tol', 3),
(1632, 4785, 'tol', 3),
(1633, 2873, 'perc', 80),
(1634, 1299, 'tol', 5),
(1636, 1845, 'tol', 6),
(1638, 2280, 'felvonás', 2),
(1641, 2474, 'ig', 12),
(1642, 594, 'tol', 3),
(1644, 3200, 'felvonás', 2),
(1645, 1754, 'tol', 4),
(1650, 5210, 'perc', 180),
(1651, 4175, 'perc', 90),
(1652, 3252, 'ig', 14),
(1656, 1312, 'ig', 6),
(1659, 4489, 'ig', 99),
(1661, 2008, 'perc', 100),
(1663, 3848, 'tol', 3),
(1664, 3047, 'felvonás', 3),
(1667, 5118, 'perc', 50),
(1668, 2531, 'felvonás', 2),
(1670, 1154, 'felvonás', 2),
(1671, 5101, 'ig', 14),
(1673, 3783, 'felvonás', 3),
(1675, 2969, 'tol', 6),
(1676, 5279, 'tol', 1),
(1677, 4737, 'felvonás', 2),
(1678, 3642, 'tol', 1),
(1680, 4868, 'tol', 12),
(1682, 2743, 'perc', 50),
(1683, 4153, 'tol', 1),
(1684, 1434, 'tol', 6),
(1688, 605, 'tol', 3),
(1689, 3840, 'tol', 14),
(1690, 401, 'perc', 120),
(1691, 4424, 'ig', 14),
(1696, 1487, 'perc', 140),
(1699, 3182, 'perc', 120),
(1701, 5166, 'felvonás', 2),
(1702, 3579, 'perc', 50),
(1708, 5728, 'tol', 4),
(1709, 2519, 'ig', 14),
(1710, 4510, 'perc', 50),
(1712, 2468, 'perc', 45),
(1713, 2838, 'perc', 80),
(1715, 15, 'perc', 150),
(1720, 4910, 'tol', 3),
(1722, 4019, 'perc', 140),
(1724, 5118, 'ig', 99),
(1725, 198, 'ig', 14),
(1729, 5861, 'tol', 3),
(1730, 4448, 'ig', 99),
(1731, 1384, 'tol', 4),
(1732, 2536, 'felvonás', 1),
(1734, 4974, 'ig', 14),
(1736, 4380, 'ig', 99),
(1737, 1544, 'tol', 16),
(1740, 2323, 'tol', 6),
(1741, 799, 'tol', 6),
(1742, 864, 'ig', 14),
(1743, 2042, 'felvonás', 2),
(1744, 772, 'perc', 100),
(1745, 2532, 'tol', 1),
(1746, 4372, 'perc', 115),
(1747, 1389, 'felvonás', 2),
(1748, 2200, 'felvonás', 1),
(1749, 2076, 'perc', 160),
(1750, 1127, 'felvonás', 2),
(1751, 664, 'ig', 14),
(1759, 1155, 'tol', 3),
(1763, 4752, 'ig', 13),
(1764, 1679, 'felvonás', 2),
(1765, 3568, 'tol', 3),
(1766, 528, 'tol', 3),
(1768, 2113, 'tol', 16),
(1770, 5498, 'perc', 60),
(1773, 1991, 'tol', 6),
(1776, 3954, 'perc', 55),
(1777, 1867, 'perc', 130),
(1779, 2547, 'tol', 5),
(1780, 4351, 'felvonás', 2),
(1781, 516, 'felvonás', 3),
(1782, 425, 'tol', 8),
(1783, 5461, 'perc', 60),
(1785, 479, 'tol', 10),
(1787, 4645, 'tol', 16),
(1789, 3970, 'felvonás', 1),
(1791, 3957, 'ig', 99),
(1792, 5584, 'tol', 6),
(1793, 4577, 'ig', 99),
(1794, 14, 'ig', 99),
(1795, 5447, 'tol', 3),
(1796, 2291, 'tol', 6),
(1798, 2867, 'tol', 7),
(1799, 2331, 'tol', 4),
(1800, 1081, 'tol', 6),
(1807, 2434, 'felvonás', 1),
(1808, 24, 'felvonás', 2),
(1809, 1215, 'felvonás', 2),
(1810, 1780, 'perc', 60),
(1812, 1816, 'felvonás', 2),
(1813, 2395, 'tol', 3),
(1816, 5586, 'tol', 4),
(1817, 3715, 'felvonás', 3),
(1821, 2368, 'felvonás', 2),
(1823, 1020, 'tol', 4),
(1825, 1138, 'tol', 5),
(1826, 499, 'tol', 3),
(1827, 1577, 'ig', 99),
(1828, 1958, 'tol', 6),
(1830, 861, 'tol', 14),
(1832, 573, 'tol', 10),
(1833, 5646, 'perc', 45),
(1834, 2739, 'perc', 180),
(1838, 3932, 'ig', 10),
(1840, 1672, 'tol', 10),
(1842, 4393, 'felvonás', 2),
(1843, 2437, 'felvonás', 1),
(1844, 1209, 'tol', 1),
(1845, 2938, 'felvonás', 1),
(1846, 374, 'ig', 14),
(1847, 2105, 'perc', 45),
(1849, 5305, 'perc', 80),
(1852, 4182, 'ig', 14),
(1854, 2269, 'ig', 99),
(1855, 1820, 'perc', 85),
(1856, 4484, 'tol', 4),
(1860, 5782, 'tol', 1),
(1861, 3253, 'tol', 4),
(1862, 5819, 'felvonás', 2),
(1863, 5056, 'tol', 12),
(1865, 4153, 'ig', 4),
(1869, 4174, 'perc', 100),
(1870, 4911, 'felvonás', 2),
(1873, 3439, 'felvonás', 2),
(1874, 4105, 'tol', 3),
(1876, 3191, 'felvonás', 1),
(1878, 4435, 'perc', 60),
(1879, 707, 'tol', 6),
(1880, 1601, 'tol', 3),
(1881, 2574, 'tol', 4),
(1882, 4955, 'tol', 10),
(1885, 1317, 'perc', 155),
(1887, 3376, 'perc', 47),
(1890, 3813, 'perc', 60),
(1892, 3563, 'perc', 145),
(1893, 1457, 'ig', 12),
(1895, 1803, 'ig', 6),
(1896, 2428, 'ig', 6),
(1898, 1263, 'felvonás', 2),
(1900, 1755, 'felvonás', 2),
(1902, 5130, 'tol', 3),
(1904, 3645, 'ig', 10),
(1906, 4191, 'felvonás', 3),
(1907, 2590, 'felvonás', 2),
(1908, 613, 'perc', 140),
(1910, 4205, 'tol', 6),
(1912, 5, 'ig', 12),
(1916, 2681, 'tol', 4),
(1917, 1531, 'tol', 6),
(1919, 540, 'felvonás', 3),
(1920, 5644, 'ig', 99),
(1925, 5573, 'tol', 3),
(1927, 3819, 'tol', 3),
(1928, 503, 'ig', 99),
(1929, 4367, 'felvonás', 2),
(1931, 1040, 'tol', 10),
(1932, 342, 'tol', 6),
(1939, 5645, 'perc', 45),
(1940, 592, 'tol', 3),
(1941, 1095, 'perc', 60),
(1943, 3553, 'felvonás', 2),
(1944, 5334, 'perc', 55),
(1945, 3776, 'tol', 18),
(1946, 1757, 'ig', 14),
(1949, 5352, 'perc', 120),
(1950, 3049, 'felvonás', 2),
(1951, 497, 'perc', 50),
(1953, 1550, 'ig', 14),
(1954, 5166, 'perc', 180),
(1955, 4785, 'ig', 99),
(1957, 1040, 'felvonás', 2),
(1959, 3105, 'ig', 99),
(1961, 4320, 'tol', 14),
(1962, 3707, 'ig', 10),
(1963, 1527, 'felvonás', 2),
(1965, 3032, 'felvonás', 2),
(1966, 2571, 'tol', 9),
(1970, 344, 'ig', 10),
(1971, 4741, 'felvonás', 1),
(1973, 3741, 'ig', 144),
(1974, 1877, 'perc', 65),
(1977, 4650, 'perc', 140),
(1978, 1694, 'felvonás', 2),
(1979, 5786, 'tol', 18),
(1983, 2510, 'tol', 3),
(1984, 109, 'tol', 6),
(1985, 979, 'perc', 120),
(1986, 3878, 'felvonás', 2),
(1989, 3866, 'perc', 100),
(1994, 702, 'felvonás', 2),
(1995, 1874, 'perc', 55),
(1998, 670, 'tol', 4),
(1999, 3956, 'felvonás', 2),
(2000, 3547, 'felvonás', 2),
(2001, 4420, 'tol', 3),
(2004, 4604, 'tol', 3),
(2010, 4121, 'felvonás', 2),
(2013, 5350, 'perc', 140),
(2015, 2573, 'felvonás', 2),
(2016, 2597, 'ig', 9),
(2017, 1004, 'ig', 99),
(2019, 4194, 'ig', 14),
(2021, 5277, 'ig', 14),
(2022, 599, 'felvonás', 2),
(2023, 5335, 'ig', 14),
(2025, 1487, 'felvonás', 1),
(2026, 3896, 'ig', 99),
(2027, 2849, 'perc', 150),
(2028, 606, 'perc', 90),
(2031, 3696, 'felvonás', 2),
(2032, 3913, 'tol', 16),
(2035, 5429, 'tol', 3),
(2037, 889, 'felvonás', 2),
(2038, 3281, 'felvonás', 2),
(2041, 449, 'ig', 99),
(2042, 203, 'felvonás', 2),
(2044, 2849, 'tol', 14),
(2047, 5215, 'felvonás', 2),
(2048, 1483, 'perc', 90),
(2051, 3656, 'felvonás', 2),
(2052, 4655, 'tol', 5),
(2054, 5895, 'felvonás', 2),
(2055, 4375, 'felvonás', 2),
(2058, 3611, 'ig', 14),
(2063, 2831, 'felvonás', 2),
(2066, 1407, 'felvonás', 2),
(2069, 67, 'felvonás', 3),
(2070, 2995, 'felvonás', 2),
(2071, 5763, 'ig', 15),
(2073, 102, 'tol', 3),
(2074, 3824, 'felvonás', 2),
(2075, 5556, 'ig', 99),
(2077, 3853, 'ig', 6),
(2078, 4261, 'tol', 4),
(2079, 5637, 'felvonás', 2),
(2080, 1416, 'tol', 6),
(2081, 4618, 'ig', 14),
(2082, 2844, 'felvonás', 1),
(2084, 1580, 'ig', 99),
(2087, 2054, 'tol', 3),
(2089, 3886, 'tol', 6),
(2090, 4986, 'tol', 3),
(2091, 5153, 'felvonás', 2),
(2093, 4766, 'ig', 14),
(2094, 5734, 'felvonás', 2),
(2095, 172, 'felvonás', 3),
(2096, 5371, 'felvonás', 2),
(2098, 4111, 'felvonás', 3),
(2100, 3589, 'felvonás', 2),
(2103, 3508, 'felvonás', 3),
(2104, 2720, 'perc', 80),
(2105, 5132, 'tol', 4),
(2106, 1135, 'perc', 120),
(2110, 3769, 'felvonás', 2),
(2111, 5760, 'tol', 4),
(2113, 204, 'ig', 10),
(2115, 2981, 'tol', 6),
(2116, 1685, 'ig', 4),
(2120, 5100, 'perc', 90),
(2121, 2780, 'tol', 6),
(2122, 2813, 'ig', 99),
(2123, 4317, 'perc', 40),
(2124, 5162, 'tol', 6),
(2125, 2805, 'felvonás', 1),
(2129, 4537, 'tol', 6),
(2131, 1627, 'ig', 14),
(2132, 3536, 'perc', 60),
(2133, 4548, 'ig', 12),
(2136, 1794, 'tol', 14),
(2137, 3019, 'perc', 90),
(2138, 3032, 'perc', 175),
(2139, 4780, 'tol', 3),
(2141, 2871, 'tol', 4),
(2142, 5053, 'felvonás', 1),
(2144, 68, 'felvonás', 2),
(2146, 5633, 'tol', 6),
(2148, 3985, 'perc', 90),
(2150, 930, 'ig', 14),
(2152, 307, 'felvonás', 1),
(2153, 2161, 'ig', 99),
(2154, 989, 'ig', 99),
(2155, 4261, 'ig', 8),
(2156, 2673, 'ig', 99),
(2158, 3452, 'ig', 12),
(2160, 3512, 'felvonás', 1),
(2162, 139, 'felvonás', 2),
(2163, 5595, 'tol', 10),
(2165, 4144, 'felvonás', 1),
(2167, 1098, 'tol', 5),
(2169, 3932, 'perc', 45),
(2170, 3017, 'felvonás', 1),
(2171, 5397, 'felvonás', 2),
(2172, 2159, 'perc', 160),
(2173, 3279, 'felvonás', 1),
(2176, 4259, 'felvonás', 2),
(2178, 1581, 'tol', 3),
(2180, 2254, 'felvonás', 2),
(2181, 3718, 'ig', 14),
(2184, 2701, 'felvonás', 2),
(2187, 1484, 'tol', 16),
(2188, 4655, 'ig', 14),
(2189, 5897, 'ig', 3),
(2190, 4237, 'tol', 10),
(2192, 1754, 'ig', 10),
(2193, 1829, 'perc', 110),
(2195, 2325, 'tol', 6),
(2197, 5881, 'ig', 10),
(2201, 4060, 'ig', 12),
(2202, 5674, 'ig', 5),
(2203, 1870, 'tol', 16),
(2204, 5743, 'felvonás', 2),
(2205, 366, 'felvonás', 3),
(2206, 5303, 'ig', 12),
(2208, 5802, 'tol', 4),
(2210, 1742, 'perc', 150),
(2211, 3124, 'ig', 14),
(2212, 3072, 'tol', 16),
(2213, 2594, 'tol', 6),
(2215, 1710, 'ig', 99),
(2216, 496, 'ig', 14),
(2217, 5868, 'tol', 6),
(2219, 2014, 'tol', 6),
(2220, 5132, 'ig', 99),
(2221, 4719, 'felvonás', 2),
(2222, 496, 'tol', 7),
(2223, 4280, 'ig', 99),
(2224, 5083, 'perc', 80),
(2226, 5714, 'ig', 14),
(2227, 4091, 'ig', 14),
(2228, 2913, 'felvonás', 2),
(2229, 3272, 'ig', 14),
(2230, 3246, 'felvonás', 1),
(2231, 4403, 'ig', 10),
(2235, 3317, 'tol', 4),
(2236, 5518, 'tol', 3),
(2237, 765, 'perc', 150),
(2239, 1457, 'tol', 5),
(2241, 3550, 'tol', 5),
(2245, 1431, 'felvonás', 2),
(2249, 5496, 'felvonás', 1),
(2250, 1395, 'perc', 65),
(2251, 1172, 'tol', 3),
(2255, 3266, 'tol', 6),
(2256, 1232, 'felvonás', 2),
(2258, 374, 'tol', 3),
(2260, 5235, 'ig', 12),
(2262, 2586, 'tol', 3),
(2263, 5580, 'ig', 10),
(2264, 4513, 'perc', 45),
(2266, 4886, 'tol', 3),
(2271, 1696, 'tol', 4),
(2273, 2555, 'perc', 60),
(2274, 4379, 'felvonás', 2),
(2275, 2942, 'tol', 4),
(2279, 1903, 'perc', 45),
(2281, 2993, 'ig', 99),
(2283, 4041, 'ig', 99),
(2284, 2950, 'felvonás', 3),
(2288, 5112, 'felvonás', 1),
(2289, 5393, 'tol', 4),
(2291, 807, 'perc', 80),
(2293, 2510, 'ig', 10),
(2294, 2880, 'tol', 3),
(2295, 3313, 'tol', 10),
(2297, 1589, 'perc', 120),
(2298, 3473, 'felvonás', 2),
(2299, 4910, 'felvonás', 1),
(2302, 5396, 'tol', 3),
(2303, 5145, 'tol', 3),
(2305, 2882, 'perc', 100),
(2306, 198, 'tol', 3),
(2310, 1409, 'felvonás', 2),
(2311, 3143, 'perc', 70),
(2312, 546, 'ig', 99),
(2316, 1695, 'ig', 14),
(2318, 906, 'felvonás', 1),
(2322, 3402, 'tol', 9),
(2326, 165, 'tol', 3),
(2327, 5347, 'tol', 14),
(2330, 5763, 'tol', 12),
(2334, 4618, 'tol', 4),
(2337, 1702, 'perc', 90),
(2339, 593, 'felvonás', 2),
(2340, 5033, 'felvonás', 2),
(2342, 200, 'felvonás', 1),
(2346, 2537, 'perc', 40),
(2348, 2189, 'tol', 11),
(2350, 294, 'ig', 99),
(2351, 1983, 'tol', 6),
(2357, 4828, 'ig', 99),
(2363, 987, 'ig', 12),
(2365, 5761, 'tol', 9),
(2371, 1155, 'ig', 14),
(2372, 5645, 'ig', 99),
(2375, 2981, 'ig', 14),
(2377, 42, 'felvonás', 2),
(2378, 5050, 'perc', 90),
(2379, 999, 'tol', 12),
(2380, 4255, 'ig', 99),
(2385, 4631, 'felvonás', 2),
(2387, 2063, 'ig', 10),
(2388, 3019, 'felvonás', 1),
(2389, 2926, 'ig', 14),
(2392, 3807, 'tol', 3),
(2396, 3383, 'perc', 75),
(2399, 5529, 'felvonás', 2),
(2402, 1296, 'perc', 60),
(2403, 4200, 'felvonás', 1),
(2404, 245, 'tol', 6),
(2407, 1737, 'felvonás', 2),
(2409, 5311, 'felvonás', 2),
(2413, 4863, 'felvonás', 2),
(2419, 4601, 'felvonás', 3),
(2420, 4403, 'felvonás', 2),
(2421, 3236, 'perc', 20),
(2422, 4976, 'tol', 4),
(2423, 3140, 'felvonás', 2),
(2425, 5279, 'ig', 3),
(2428, 3151, 'tol', 3),
(2429, 2102, 'perc', 25),
(2430, 5643, 'perc', 50),
(2431, 4356, 'perc', 85),
(2432, 1524, 'tol', 4),
(2435, 4122, 'felvonás', 1),
(2436, 5166, 'tol', 16),
(2437, 5292, 'felvonás', 2),
(2438, 5258, 'ig', 99),
(2440, 1613, 'ig', 6),
(2441, 4421, 'tol', 6),
(2442, 4022, 'perc', 40),
(2443, 2348, 'felvonás', 2),
(2444, 1791, 'felvonás', 2),
(2448, 901, 'tol', 3),
(2450, 2452, 'felvonás', 3),
(2451, 4783, 'tol', 3),
(2453, 375, 'perc', 130),
(2454, 4006, 'tol', 15),
(2455, 3126, 'felvonás', 3),
(2458, 3961, 'tol', 4),
(2459, 2505, 'tol', 6),
(2460, 4020, 'felvonás', 2),
(2464, 1888, 'perc', 120),
(2466, 5016, 'felvonás', 2),
(2467, 839, 'felvonás', 1),
(2468, 4145, 'felvonás', 1),
(2469, 3784, 'felvonás', 1),
(2470, 4334, 'tol', 1),
(2472, 2863, 'ig', 99),
(2474, 3310, 'tol', 18),
(2476, 788, 'felvonás', 2),
(2477, 3289, 'ig', 14),
(2478, 144, 'perc', 150),
(2480, 594, 'ig', 10),
(2482, 827, 'perc', 100),
(2489, 2708, 'felvonás', 2),
(2490, 5573, 'ig', 10),
(2491, 5858, 'perc', 50),
(2498, 3943, 'tol', 10),
(2500, 35, 'felvonás', 2),
(2501, 4609, 'felvonás', 2),
(2502, 1253, 'felvonás', 2),
(2503, 1542, 'tol', 10),
(2505, 817, 'ig', 99),
(2506, 2046, 'perc', 80),
(2508, 4074, 'tol', 16),
(2509, 5113, 'perc', 20),
(2510, 5090, 'felvonás', 1),
(2512, 5083, 'tol', 16),
(2515, 3689, 'tol', 10),
(2516, 5080, 'perc', 45),
(2517, 1342, 'ig', 3),
(2518, 5571, 'felvonás', 2),
(2520, 52, 'ig', 3),
(2523, 3256, 'felvonás', 2),
(2525, 5010, 'tol', 3),
(2528, 1273, 'felvonás', 3),
(2529, 4200, 'tol', 6),
(2532, 2177, 'felvonás', 2),
(2534, 2407, 'felvonás', 2),
(2535, 1208, 'tol', 12),
(2537, 5387, 'tol', 16),
(2544, 1452, 'felvonás', 3),
(2545, 2587, 'ig', 3),
(2547, 2146, 'ig', 14),
(2548, 1533, 'felvonás', 1),
(2550, 3391, 'perc', 45),
(2551, 3406, 'ig', 14),
(2554, 3983, 'perc', 60),
(2558, 2876, 'perc', 90),
(2559, 1411, 'felvonás', 2),
(2564, 2191, 'felvonás', 2),
(2566, 2344, 'tol', 3),
(2567, 4182, 'tol', 6),
(2573, 580, 'tol', 16),
(2574, 3645, 'tol', 4),
(2575, 5673, 'tol', 3),
(2576, 2022, 'ig', 99),
(2578, 1979, 'tol', 14),
(2585, 686, 'tol', 12),
(2590, 345, 'perc', 50),
(2594, 3710, 'ig', 12),
(2595, 241, 'felvonás', 2),
(2596, 180, 'perc', 180),
(2597, 5806, 'felvonás', 2),
(2598, 1689, 'felvonás', 3),
(2600, 4517, 'ig', 6),
(2601, 3185, 'tol', 7),
(2602, 1285, 'felvonás', 3),
(2607, 697, 'tol', 4),
(2611, 1008, 'felvonás', 2),
(2613, 3838, 'tol', 7),
(2616, 5274, 'ig', 99),
(2617, 377, 'perc', 45),
(2618, 3483, 'tol', 18),
(2621, 4200, 'perc', 90),
(2624, 984, 'tol', 6),
(2625, 17, 'ig', 10),
(2627, 4218, 'felvonás', 2),
(2628, 713, 'felvonás', 2),
(2631, 4692, 'tol', 12),
(2632, 5451, 'tol', 16),
(2634, 1929, 'tol', 4),
(2635, 3404, 'felvonás', 2),
(2636, 2601, 'tol', 6),
(2638, 1450, 'perc', 50),
(2639, 5305, 'tol', 16),
(2640, 5106, 'felvonás', 2),
(2642, 3612, 'perc', 45),
(2643, 1374, 'perc', 150),
(2644, 1035, 'felvonás', 1),
(2645, 3626, 'felvonás', 2),
(2646, 630, 'perc', 60),
(2649, 3151, 'ig', 10),
(2650, 4776, 'ig', 16),
(2655, 355, 'felvonás', 2),
(2658, 5310, 'felvonás', 1),
(2659, 4759, 'tol', 3),
(2660, 1544, 'ig', 99),
(2662, 1453, 'ig', 10),
(2663, 1365, 'felvonás', 2),
(2664, 3199, 'tol', 4),
(2667, 505, 'tol', 16),
(2668, 1643, 'felvonás', 2),
(2670, 4780, 'ig', 12),
(2673, 3612, 'tol', 12),
(2674, 390, 'perc', 70),
(2675, 4169, 'ig', 12),
(2676, 260, 'ig', 12),
(2677, 11, 'tol', 4),
(2679, 1965, 'felvonás', 1),
(2680, 1924, 'tol', 6),
(2682, 3173, 'felvonás', 2),
(2683, 4362, 'ig', 14),
(2684, 604, 'felvonás', 1),
(2686, 5643, 'felvonás', 2),
(2688, 4334, 'ig', 4),
(2689, 3073, 'tol', 4),
(2692, 4027, 'felvonás', 2),
(2694, 3970, 'tol', 12),
(2696, 1780, 'felvonás', 1),
(2699, 1388, 'perc', 90),
(2702, 2008, 'felvonás', 1),
(2703, 3268, 'felvonás', 1),
(2705, 3756, 'ig', 9),
(2706, 5328, 'felvonás', 2),
(2707, 1266, 'felvonás', 2),
(2708, 3343, 'perc', 90),
(2709, 4363, 'tol', 6),
(2710, 4376, 'ig', 12),
(2711, 4722, 'ig', 99),
(2713, 2856, 'felvonás', 1),
(2714, 2358, 'felvonás', 3),
(2715, 695, 'felvonás', 2),
(2716, 4688, 'felvonás', 2),
(2717, 2342, 'tol', 12),
(2718, 1770, 'tol', 3),
(2719, 842, 'perc', 120),
(2720, 2711, 'felvonás', 1),
(2721, 5277, 'tol', 3),
(2723, 2757, 'ig', 10),
(2724, 2463, 'ig', 10),
(2725, 4296, 'ig', 12),
(2731, 3713, 'ig', 14),
(2732, 4641, 'felvonás', 2),
(2733, 3394, 'felvonás', 1),
(2734, 4830, 'tol', 16),
(2736, 273, 'ig', 99),
(2738, 5377, 'ig', 14),
(2739, 5877, 'tol', 4),
(2740, 1665, 'tol', 3),
(2741, 3406, 'tol', 3),
(2745, 4189, 'tol', 18),
(2747, 1915, 'perc', 40),
(2748, 1596, 'perc', 70),
(2749, 2483, 'tol', 2),
(2750, 345, 'ig', 99),
(2751, 3954, 'felvonás', 1),
(2752, 1511, 'tol', 8),
(2755, 3740, 'ig', 14),
(2756, 2378, 'felvonás', 2),
(2757, 5896, 'perc', 70),
(2762, 1334, 'tol', 9),
(2763, 1392, 'perc', 60),
(2765, 5762, 'tol', 4),
(2768, 697, 'ig', 12),
(2769, 964, 'felvonás', 1),
(2771, 5171, 'felvonás', 2),
(2773, 2871, 'ig', 99),
(2775, 123, 'tol', 14),
(2776, 2185, 'ig', 99),
(2777, 5139, 'felvonás', 2),
(2779, 3852, 'tol', 14),
(2780, 232, 'tol', 8),
(2781, 949, 'tol', 12),
(2783, 1035, 'perc', 70),
(2784, 881, 'perc', 30),
(2785, 290, 'felvonás', 2),
(2786, 1450, 'ig', 6),
(2787, 1236, 'felvonás', 2),
(2788, 4006, 'felvonás', 1),
(2789, 467, 'tol', 16),
(2795, 624, 'felvonás', 1),
(2797, 804, 'felvonás', 2),
(2798, 5745, 'felvonás', 3),
(2799, 1385, 'felvonás', 1),
(2800, 5666, 'felvonás', 2),
(2808, 5576, 'felvonás', 3),
(2809, 790, 'perc', 60),
(2810, 4650, 'felvonás', 2),
(2811, 378, 'felvonás', 4),
(2813, 3808, 'felvonás', 2),
(2817, 500, 'perc', 25),
(2818, 4294, 'felvonás', 2),
(2820, 4143, 'tol', 16),
(2822, 3804, 'felvonás', 2),
(2825, 1058, 'ig', 99),
(2830, 1983, 'ig', 99),
(2832, 1400, 'tol', 6),
(2834, 923, 'felvonás', 2),
(2836, 4822, 'felvonás', 2),
(2837, 3427, 'felvonás', 3),
(2838, 2688, 'tol', 12),
(2840, 3936, 'felvonás', 2),
(2841, 166, 'tol', 16),
(2842, 3792, 'ig', 14),
(2843, 2864, 'tol', 18),
(2844, 4948, 'tol', 4),
(2845, 4019, 'felvonás', 2),
(2846, 2641, 'tol', 3),
(2849, 15, 'felvonás', 2),
(2850, 977, 'felvonás', 2),
(2854, 4318, 'tol', 3),
(2856, 1015, 'ig', 10),
(2857, 3050, 'tol', 4),
(2859, 1830, 'perc', 90),
(2860, 4910, 'ig', 99),
(2861, 3518, 'tol', 3),
(2862, 4810, 'felvonás', 2),
(2864, 2968, 'felvonás', 3),
(2865, 478, 'felvonás', 2),
(2868, 2072, 'felvonás', 2),
(2869, 2526, 'felvonás', 2),
(2871, 163, 'felvonás', 2),
(2874, 1848, 'felvonás', 3),
(2878, 2784, 'felvonás', 2),
(2879, 5330, 'felvonás', 2),
(2884, 4460, 'ig', 99),
(2885, 4281, 'perc', 90),
(2890, 5262, 'perc', 60),
(2892, 506, 'tol', 16),
(2894, 4826, 'felvonás', 2),
(2895, 850, 'ig', 99),
(2896, 16, 'felvonás', 3),
(2897, 3084, 'ig', 99),
(2898, 5440, 'felvonás', 2),
(2899, 1601, 'perc', 50),
(2901, 4412, 'felvonás', 2),
(2902, 5630, 'perc', 80),
(2903, 577, 'perc', 90),
(2904, 3650, 'perc', 60),
(2905, 2319, 'felvonás', 2),
(2906, 2200, 'perc', 50),
(2908, 2747, 'perc', 165),
(2909, 2790, 'tol', 4),
(2911, 5411, 'felvonás', 2),
(2916, 2685, 'tol', 3),
(2918, 2468, 'ig', 99),
(2921, 4843, 'tol', 7),
(2925, 3031, 'tol', 14),
(2927, 531, 'felvonás', 1),
(2928, 2656, 'perc', 130),
(2930, 5340, 'tol', 3),
(2931, 5245, 'ig', 99),
(2934, 1668, 'tol', 4),
(2940, 5788, 'felvonás', 3),
(2942, 4684, 'ig', 14),
(2944, 4698, 'felvonás', 2),
(2945, 2182, 'felvonás', 3),
(2946, 2377, 'felvonás', 2),
(2947, 4598, 'tol', 9),
(2948, 4982, 'tol', 3),
(2950, 478, 'perc', 150),
(2951, 2837, 'tol', 3),
(2952, 2240, 'ig', 14),
(2954, 5008, 'perc', 150),
(2957, 4823, 'ig', 14),
(2958, 3373, 'ig', 12),
(2960, 3558, 'tol', 12),
(2963, 1114, 'tol', 6),
(2965, 2278, 'perc', 120),
(2966, 2676, 'felvonás', 2),
(2967, 1468, 'felvonás', 2),
(2969, 3359, 'felvonás', 2),
(2974, 5520, 'tol', 4),
(2975, 1276, 'felvonás', 2),
(2976, 4685, 'tol', 8),
(2977, 3185, 'ig', 99),
(2978, 1305, 'perc', 45),
(2979, 3521, 'perc', 40),
(2980, 5333, 'felvonás', 2),
(2981, 1212, 'tol', 8),
(2983, 873, 'ig', 10),
(2984, 1669, 'tol', 5),
(2985, 4513, 'tol', 16),
(2987, 5332, 'tol', 10),
(2988, 3741, 'tol', 4),
(2991, 3054, 'ig', 12),
(2993, 2450, 'tol', 3),
(2994, 1193, 'felvonás', 2),
(2995, 4038, 'ig', 10),
(2996, 2558, 'ig', 14),
(3000, 4500, 'tol', 6),
(3001, 4891, 'felvonás', 2),
(3005, 963, 'felvonás', 3),
(3008, 5709, 'tol', 3),
(3010, 2845, 'felvonás', 3),
(3014, 3062, 'tol', 3),
(3018, 2692, 'ig', 12),
(3023, 2069, 'ig', 99),
(3024, 5387, 'felvonás', 1),
(3025, 2571, 'ig', 99),
(3026, 3199, 'ig', 14),
(3027, 1824, 'felvonás', 3),
(3029, 467, 'ig', 99),
(3031, 2518, 'felvonás', 2),
(3034, 1774, 'tol', 3),
(3035, 1375, 'tol', 18),
(3036, 1468, 'perc', 180),
(3039, 4313, 'tol', 3),
(3040, 1564, 'felvonás', 2),
(3041, 1648, 'felvonás', 2),
(3043, 3896, 'tol', 10),
(3045, 3756, 'perc', 55),
(3046, 2385, 'perc', 90),
(3047, 4094, 'ig', 12),
(3048, 2196, 'tol', 18),
(3049, 4511, 'tol', 3),
(3051, 1472, 'perc', 60),
(3052, 1038, 'felvonás', 2),
(3057, 5796, 'ig', 99),
(3058, 5673, 'ig', 12),
(3059, 2151, 'tol', 10),
(3063, 4195, 'tol', 7),
(3067, 2822, 'ig', 99),
(3069, 3418, 'perc', 60),
(3070, 409, 'perc', 110),
(3071, 2813, 'tol', 4),
(3072, 3158, 'felvonás', 2),
(3075, 3289, 'felvonás', 1),
(3076, 2069, 'tol', 6),
(3077, 4899, 'ig', 3),
(3078, 2412, 'felvonás', 2),
(3079, 2816, 'ig', 99),
(3081, 837, 'felvonás', 2),
(3083, 5234, 'tol', 3),
(3084, 2685, 'ig', 14),
(3085, 4980, 'felvonás', 1),
(3087, 4961, 'felvonás', 2),
(3090, 2519, 'tol', 3),
(3091, 2867, 'perc', 60),
(3092, 3739, 'felvonás', 3),
(3094, 3261, 'felvonás', 2),
(3095, 220, 'tol', 6),
(3097, 5707, 'tol', 12),
(3101, 4654, 'tol', 12),
(3103, 2268, 'ig', 99),
(3104, 1813, 'tol', 4),
(3105, 5058, 'ig', 14),
(3108, 5401, 'tol', 3),
(3110, 5350, 'tol', 15),
(3111, 3538, 'felvonás', 1),
(3114, 2537, 'tol', 12),
(3115, 1388, 'tol', 14),
(3117, 2866, 'tol', 4),
(3120, 5312, 'tol', 16),
(3122, 5071, 'tol', 5),
(3124, 265, 'felvonás', 2),
(3125, 3577, 'perc', 110),
(3126, 1611, 'felvonás', 2),
(3127, 1018, 'felvonás', 2),
(3128, 4313, 'ig', 10),
(3130, 3171, 'tol', 5),
(3131, 3138, 'tol', 3),
(3132, 1537, 'felvonás', 2),
(3133, 4291, 'ig', 10),
(3134, 232, 'perc', 150),
(3136, 628, 'felvonás', 2),
(3138, 219, 'ig', 19),
(3141, 2966, 'ig', 12),
(3143, 2474, 'tol', 3),
(3144, 347, 'perc', 120),
(3148, 5554, 'tol', 8),
(3152, 1383, 'ig', 99),
(3153, 2152, 'ig', 99),
(3154, 4200, 'ig', 14),
(3155, 4874, 'ig', 99),
(3156, 3218, 'ig', 10),
(3158, 2100, 'felvonás', 2),
(3159, 4477, 'ig', 10),
(3160, 3236, 'ig', 14),
(3163, 1932, 'tol', 4),
(3164, 3138, 'ig', 99),
(3165, 3837, 'ig', 14),
(3167, 132, 'felvonás', 1),
(3169, 5770, 'tol', 10),
(3171, 3604, 'ig', 10),
(3173, 4099, 'tol', 5),
(3174, 4520, 'tol', 6),
(3177, 219, 'tol', 13),
(3178, 5625, 'ig', 12),
(3179, 145, 'felvonás', 1),
(3180, 2027, 'tol', 1),
(3181, 4143, 'perc', 90),
(3182, 115, 'tol', 1),
(3183, 2501, 'felvonás', 2),
(3184, 1512, 'ig', 14),
(3188, 719, 'perc', 90),
(3190, 379, 'tol', 5),
(3192, 4931, 'ig', 99),
(3194, 4811, 'perc', 120),
(3199, 553, 'tol', 3),
(3200, 638, 'tol', 10),
(3203, 1845, 'ig', 14),
(3204, 1029, 'felvonás', 2),
(3206, 4174, 'felvonás', 1),
(3208, 1267, 'perc', 135),
(3211, 3868, 'tol', 3),
(3212, 4687, 'tol', 10),
(3214, 4424, 'tol', 6),
(3215, 3029, 'felvonás', 2),
(3216, 2852, 'felvonás', 3),
(3219, 4767, 'perc', 100),
(3220, 3600, 'felvonás', 2),
(3224, 3256, 'perc', 150),
(3225, 2747, 'felvonás', 3),
(3226, 2397, 'ig', 12),
(3227, 3869, 'felvonás', 4),
(3229, 2186, 'ig', 12),
(3230, 4623, 'ig', 14),
(3231, 2780, 'ig', 14),
(3232, 3264, 'felvonás', 2),
(3233, 3885, 'tol', 12),
(3234, 817, 'tol', 4),
(3242, 1847, 'tol', 3),
(3245, 2014, 'ig', 99),
(3246, 759, 'ig', 10),
(3247, 2406, 'perc', 70),
(3248, 4300, 'tol', 18),
(3251, 3454, 'tol', 3),
(3253, 546, 'tol', 4),
(3254, 1106, 'ig', 8),
(3255, 3156, 'tol', 10),
(3257, 266, 'ig', 14),
(3258, 4315, 'tol', 16),
(3259, 3171, 'felvonás', 2),
(3260, 5421, 'felvonás', 1),
(3261, 1089, 'perc', 180),
(3262, 1406, 'ig', 99),
(3265, 3968, 'tol', 6),
(3266, 1277, 'tol', 10),
(3267, 162, 'felvonás', 1),
(3268, 3913, 'ig', 99),
(3274, 4042, 'tol', 3),
(3277, 1811, 'ig', 99),
(3279, 2440, 'felvonás', 2),
(3281, 695, 'ig', 99),
(3282, 3849, 'felvonás', 2),
(3283, 1093, 'tol', 3),
(3285, 3402, 'ig', 99),
(3287, 4460, 'tol', 3),
(3290, 2342, 'felvonás', 2),
(3291, 4437, 'felvonás', 1),
(3292, 1547, 'felvonás', 2),
(3295, 642, 'tol', 12),
(3299, 3276, 'tol', 3),
(3303, 613, 'tol', 10),
(3304, 9, 'ig', 12),
(3305, 1542, 'ig', 99),
(3306, 5696, 'felvonás', 2),
(3311, 1082, 'ig', 9),
(3315, 852, 'felvonás', 2),
(3316, 3266, 'ig', 14),
(3317, 2602, 'felvonás', 2),
(3318, 5254, 'perc', 60),
(3320, 2297, 'felvonás', 3),
(3323, 5300, 'ig', 16),
(3325, 4870, 'felvonás', 2),
(3326, 5109, 'perc', 45),
(3327, 2787, 'ig', 99),
(3328, 3378, 'tol', 6),
(3333, 5318, 'ig', 10),
(3337, 4280, 'tol', 4),
(3339, 175, 'felvonás', 2),
(3340, 2921, 'perc', 145),
(3341, 1296, 'felvonás', 1),
(3342, 3700, 'felvonás', 2),
(3343, 2271, 'felvonás', 2),
(3348, 2371, 'felvonás', 2),
(3349, 327, 'perc', 170),
(3351, 4993, 'ig', 8),
(3352, 5857, 'ig', 99),
(3353, 1860, 'ig', 14),
(3354, 4943, 'ig', 18),
(3357, 657, 'tol', 18),
(3358, 2241, 'perc', 130),
(3360, 2252, 'ig', 14),
(3363, 3012, 'felvonás', 2),
(3364, 4411, 'tol', 14),
(3365, 2171, 'felvonás', 1),
(3368, 2320, 'ig', 99),
(3369, 1668, 'ig', 14),
(3370, 2025, 'tol', 7),
(3372, 3536, 'felvonás', 2),
(3373, 4164, 'felvonás', 2),
(3374, 1651, 'felvonás', 2),
(3377, 621, 'perc', 60),
(3378, 2020, 'ig', 99),
(3379, 3573, 'felvonás', 2),
(3383, 3036, 'ig', 10),
(3384, 4135, 'perc', 135),
(3389, 1619, 'tol', 16),
(3396, 4425, 'tol', 4),
(3400, 2241, 'felvonás', 2),
(3401, 4835, 'tol', 16),
(3402, 5376, 'tol', 5),
(3404, 3101, 'tol', 5),
(3406, 4490, 'felvonás', 2),
(3408, 4329, 'felvonás', 2),
(3409, 4892, 'ig', 99),
(3411, 1030, 'tol', 2),
(3412, 2138, 'ig', 3),
(3413, 886, 'perc', 120),
(3414, 3669, 'felvonás', 1),
(3417, 3290, 'tol', 3),
(3418, 4314, 'perc', 40),
(3419, 983, 'felvonás', 1),
(3420, 4628, 'perc', 70),
(3421, 3973, 'felvonás', 2),
(3422, 2322, 'tol', 10),
(3423, 239, 'tol', 4),
(3424, 4062, 'felvonás', 1),
(3427, 1902, 'felvonás', 3),
(3430, 3366, 'perc', 70),
(3431, 3701, 'felvonás', 2),
(3432, 5374, 'felvonás', 2),
(3434, 1919, 'tol', 18),
(3435, 2134, 'felvonás', 1),
(3436, 4118, 'tol', 4),
(3439, 420, 'felvonás', 2),
(3440, 3191, 'perc', 85),
(3443, 2149, 'tol', 1),
(3444, 2769, 'felvonás', 1),
(3445, 4662, 'felvonás', 2),
(3451, 5801, 'felvonás', 2),
(3452, 3484, 'perc', 80),
(3455, 2787, 'perc', 80),
(3457, 2151, 'ig', 14),
(3460, 821, 'tol', 4),
(3464, 2413, 'ig', 99),
(3465, 4942, 'felvonás', 2),
(3471, 4950, 'felvonás', 1),
(3472, 1439, 'felvonás', 2),
(3473, 5815, 'tol', 6),
(3476, 115, 'ig', 3),
(3478, 5858, 'tol', 4),
(3480, 3691, 'perc', 90),
(3481, 302, 'felvonás', 2),
(3483, 3968, 'ig', 99),
(3485, 1659, 'felvonás', 1),
(3486, 1927, 'tol', 3),
(3487, 3389, 'tol', 4),
(3488, 2873, 'felvonás', 1),
(3489, 4641, 'tol', 16),
(3490, 1604, 'ig', 99),
(3491, 3017, 'perc', 90),
(3492, 2112, 'felvonás', 2),
(3494, 3016, 'tol', 5),
(3495, 4671, 'tol', 3),
(3496, 1303, 'tol', 3),
(3498, 5585, 'perc', 69),
(3503, 286, 'felvonás', 1),
(3505, 2411, 'felvonás', 2),
(3506, 3104, 'tol', 6),
(3507, 5226, 'tol', 3),
(3514, 5520, 'ig', 99),
(3516, 5428, 'perc', 160),
(3518, 728, 'ig', 10),
(3519, 5253, 'ig', 12),
(3520, 4307, 'ig', 3),
(3522, 5449, 'tol', 1),
(3524, 4517, 'perc', 40),
(3525, 5367, 'tol', 3),
(3526, 418, 'perc', 40),
(3527, 5674, 'tol', 2),
(3529, 2992, 'ig', 99),
(3530, 2532, 'ig', 4),
(3533, 4402, 'ig', 14),
(3535, 3633, 'ig', 99),
(3538, 484, 'tol', 4),
(3539, 674, 'felvonás', 2),
(3541, 179, 'ig', 11),
(3549, 2057, 'tol', 10),
(3550, 305, 'perc', 90),
(3551, 729, 'perc', 65),
(3552, 4598, 'ig', 14),
(3553, 121, 'tol', 15),
(3554, 4159, 'ig', 10),
(3556, 5350, 'ig', 99),
(3558, 4576, 'felvonás', 2),
(3564, 4476, 'perc', 120),
(3567, 4018, 'ig', 99),
(3569, 2938, 'tol', 3),
(3571, 3000, 'ig', 99),
(3572, 2964, 'ig', 99),
(3576, 2111, 'ig', 99),
(3577, 807, 'ig', 99),
(3578, 1077, 'ig', 12),
(3583, 998, 'felvonás', 2),
(3586, 1228, 'ig', 99),
(3587, 3108, 'felvonás', 1),
(3588, 5874, 'felvonás', 2),
(3591, 452, 'perc', 110),
(3593, 4378, 'ig', 99),
(3594, 2092, 'ig', 99),
(3596, 4057, 'tol', 6),
(3598, 5716, 'felvonás', 2),
(3599, 3357, 'tol', 4),
(3601, 5334, 'felvonás', 1),
(3606, 226, 'tol', 3),
(3607, 1203, 'felvonás', 1),
(3608, 2541, 'perc', 60),
(3611, 2327, 'ig', 99),
(3613, 4873, 'ig', 14),
(3614, 5705, 'ig', 99),
(3615, 1205, 'ig', 99),
(3616, 3189, 'felvonás', 3),
(3617, 1903, 'ig', 10),
(3618, 718, 'tol', 3),
(3619, 4517, 'tol', 3),
(3625, 1771, 'tol', 6),
(3626, 1017, 'tol', 4),
(3629, 811, 'felvonás', 2),
(3630, 415, 'felvonás', 1),
(3632, 2151, 'perc', 150),
(3635, 978, 'felvonás', 2),
(3636, 4314, 'ig', 10),
(3637, 5888, 'ig', 14),
(3638, 1154, 'perc', 120),
(3639, 3747, 'ig', 12),
(3640, 4976, 'ig', 10),
(3641, 2395, 'ig', 12),
(3643, 2778, 'tol', 3),
(3645, 4846, 'ig', 14),
(3646, 1748, 'tol', 6),
(3647, 1344, 'tol', 18),
(3648, 5857, 'tol', 4),
(3650, 4904, 'perc', 50),
(3651, 1265, 'felvonás', 1),
(3654, 3006, 'felvonás', 2),
(3655, 4902, 'felvonás', 2),
(3656, 1589, 'felvonás', 2),
(3659, 1305, 'ig', 14),
(3661, 4062, 'perc', 50),
(3662, 5396, 'ig', 99),
(3667, 1449, 'perc', 90),
(3670, 3118, 'perc', 50),
(3672, 1205, 'tol', 13),
(3673, 627, 'tol', 6),
(3677, 4359, 'tol', 4),
(3680, 4271, 'felvonás', 3),
(3681, 2392, 'felvonás', 2),
(3685, 1920, 'felvonás', 2),
(3688, 5705, 'tol', 6),
(3692, 3763, 'ig', 10),
(3693, 2309, 'ig', 10),
(3694, 3599, 'felvonás', 2),
(3696, 1752, 'tol', 8),
(3697, 5130, 'ig', 12),
(3699, 4444, 'perc', 100),
(3704, 217, 'felvonás', 2),
(3705, 3306, 'tol', 9),
(3706, 3630, 'tol', 7),
(3708, 111, 'perc', 70),
(3712, 2007, 'tol', 7),
(3713, 2696, 'felvonás', 1),
(3714, 4939, 'tol', 6),
(3718, 5547, 'perc', 75),
(3720, 5685, 'ig', 14),
(3721, 5838, 'felvonás', 1),
(3723, 4608, 'ig', 99),
(3725, 2687, 'ig', 14),
(3730, 5455, 'tol', 3),
(3731, 1058, 'tol', 9),
(3732, 3041, 'tol', 6),
(3733, 3451, 'ig', 10),
(3735, 1159, 'perc', 110),
(3737, 3227, 'tol', 16),
(3739, 3828, 'perc', 130),
(3744, 4493, 'tol', 3),
(3745, 1233, 'felvonás', 1),
(3748, 4693, 'tol', 3),
(3749, 4828, 'perc', 50),
(3750, 3785, 'ig', 14),
(3752, 2191, 'perc', 80),
(3753, 2744, 'perc', 90),
(3754, 1077, 'tol', 3),
(3755, 220, 'ig', 12),
(3756, 3043, 'felvonás', 2),
(3758, 4463, 'ig', 99),
(3760, 1053, 'felvonás', 2),
(3761, 612, 'ig', 10),
(3762, 641, 'felvonás', 1),
(3763, 1908, 'felvonás', 3),
(3766, 5577, 'tol', 3),
(3767, 5644, 'tol', 4),
(3769, 2322, 'felvonás', 2),
(3771, 657, 'perc', 90),
(3772, 452, 'felvonás', 1),
(3775, 1808, 'ig', 14),
(3777, 5120, 'ig', 12),
(3779, 1726, 'felvonás', 2),
(3782, 3276, 'ig', 12),
(3783, 1766, 'perc', 50),
(3784, 3179, 'ig', 99),
(3785, 4281, 'felvonás', 1),
(3788, 1999, 'ig', 99),
(3789, 1354, 'felvonás', 2),
(3790, 1979, 'ig', 99),
(3794, 3118, 'tol', 4),
(3795, 3799, 'perc', 130),
(3796, 2729, 'tol', 10),
(3797, 3544, 'felvonás', 2),
(3799, 918, 'felvonás', 2),
(3800, 2152, 'tol', 4),
(3802, 1829, 'tol', 14),
(3805, 4386, 'felvonás', 2),
(3806, 4959, 'tol', 14),
(3808, 2303, 'tol', 4),
(3809, 1098, 'ig', 12),
(3814, 2574, 'ig', 14),
(3816, 5429, 'perc', 45),
(3819, 5822, 'tol', 4),
(3820, 930, 'tol', 6),
(3823, 2761, 'perc', 90),
(3824, 2533, 'perc', 45),
(3825, 5740, 'perc', 150),
(3827, 2215, 'ig', 14),
(3829, 5164, 'perc', 120),
(3830, 639, 'felvonás', 2),
(3832, 2413, 'tol', 4),
(3834, 273, 'tol', 3),
(3835, 1645, 'tol', 6),
(3836, 3889, 'felvonás', 2),
(3838, 1526, 'ig', 14),
(3840, 1214, 'perc', 100),
(3841, 740, 'felvonás', 4),
(3846, 2646, 'felvonás', 2),
(3848, 3401, 'tol', 5),
(3851, 1036, 'felvonás', 2),
(3853, 1994, 'tol', 3),
(3857, 2688, 'perc', 50),
(3859, 848, 'ig', 6),
(3863, 3469, 'tol', 6),
(3864, 3386, 'felvonás', 1),
(3865, 3781, 'perc', 30),
(3866, 806, 'felvonás', 2),
(3867, 3479, 'felvonás', 2),
(3868, 1344, 'ig', 99),
(3869, 2186, 'tol', 5),
(3872, 2342, 'perc', 120),
(3873, 3729, 'tol', 4),
(3876, 5320, 'perc', 60),
(3880, 2855, 'tol', 3),
(3881, 3742, 'felvonás', 2),
(3885, 3975, 'ig', 99),
(3886, 5189, 'tol', 6),
(3887, 1953, 'tol', 14),
(3891, 4578, 'tol', 5),
(3893, 35, 'perc', 86),
(3895, 2814, 'tol', 10),
(3896, 228, 'perc', 55),
(3898, 4138, 'tol', 12),
(3901, 1603, 'tol', 3),
(3902, 5837, 'ig', 14),
(3905, 5023, 'felvonás', 2),
(3906, 1819, 'ig', 8),
(3908, 5302, 'felvonás', 2),
(3910, 4445, 'felvonás', 2),
(3911, 786, 'tol', 16),
(3912, 2631, 'felvonás', 2),
(3914, 945, 'tol', 6),
(3915, 1075, 'tol', 3),
(3916, 1672, 'ig', 99),
(3917, 1025, 'ig', 14),
(3918, 2309, 'tol', 3),
(3919, 1952, 'tol', 3),
(3922, 2838, 'felvonás', 2),
(3923, 807, 'tol', 12),
(3925, 1965, 'perc', 55),
(3926, 4069, 'perc', 50),
(3928, 5569, 'felvonás', 2),
(3935, 2596, 'tol', 15),
(3937, 4962, 'perc', 25),
(3939, 3733, 'perc', 180),
(3942, 279, 'tol', 4),
(3945, 3050, 'ig', 99),
(3947, 3246, 'perc', 90),
(3949, 5646, 'tol', 4),
(3952, 2677, 'perc', 60),
(3953, 5351, 'tol', 18),
(3954, 4269, 'tol', 18),
(3956, 2562, 'ig', 99),
(3958, 59, 'felvonás', 2),
(3961, 5267, 'ig', 99),
(3965, 3721, 'ig', 99),
(3966, 2872, 'perc', 130),
(3967, 415, 'perc', 60),
(3968, 5001, 'tol', 3),
(3970, 1786, 'felvonás', 3),
(3973, 5198, 'ig', 14),
(3975, 869, 'felvonás', 2),
(3976, 3791, 'ig', 99),
(3978, 1057, 'tol', 3),
(3980, 1029, 'perc', 180),
(3981, 5413, 'ig', 7),
(3982, 1315, 'tol', 10),
(3983, 842, 'tol', 10),
(3984, 3220, 'felvonás', 1),
(3986, 1812, 'ig', 99),
(3989, 3234, 'tol', 3),
(3991, 4905, 'felvonás', 3),
(3993, 4017, 'ig', 6),
(3994, 2485, 'felvonás', 2),
(3995, 580, 'perc', 35),
(3997, 5768, 'tol', 4),
(3998, 2856, 'perc', 80),
(4000, 4105, 'ig', 99),
(4002, 4360, 'felvonás', 2),
(4003, 2533, 'tol', 3),
(4005, 5633, 'perc', 150),
(4006, 5564, 'felvonás', 1),
(4009, 1459, 'perc', 70),
(4011, 3886, 'ig', 99),
(4014, 43, 'ig', 96),
(4018, 3240, 'felvonás', 3);
INSERT INTO `tulajdonsag` (`id`, `eloadasid`, `nev`, `ertek`) VALUES
(4020, 2511, 'felvonás', 2),
(4021, 5647, 'perc', 80),
(4022, 2943, 'perc', 60),
(4023, 1455, 'felvonás', 2),
(4025, 4162, 'felvonás', 1),
(4026, 2183, 'ig', 6),
(4030, 423, 'tol', 11),
(4031, 2840, 'perc', 75),
(4033, 4088, 'felvonás', 1),
(4035, 4772, 'felvonás', 2),
(4036, 921, 'felvonás', 1),
(4037, 4138, 'ig', 99),
(4038, 379, 'ig', 10),
(4039, 1650, 'felvonás', 2),
(4041, 526, 'ig', 99),
(4042, 666, 'tol', 16),
(4046, 1178, 'perc', 120),
(4047, 642, 'ig', 99),
(4048, 5735, 'felvonás', 2),
(4051, 2706, 'felvonás', 1),
(4052, 2533, 'ig', 12),
(4053, 3330, 'tol', 3),
(4054, 3370, 'felvonás', 2),
(4056, 5889, 'perc', 130),
(4057, 837, 'perc', 170),
(4058, 3972, 'ig', 14),
(4059, 1408, 'tol', 6),
(4060, 2864, 'perc', 60),
(4061, 4291, 'perc', 45),
(4062, 3381, 'tol', 7),
(4063, 2697, 'felvonás', 3),
(4064, 470, 'felvonás', 2),
(4069, 3, 'ig', 14),
(4070, 3888, 'felvonás', 3),
(4071, 1608, 'felvonás', 2),
(4073, 796, 'perc', 115),
(4075, 2356, 'perc', 110),
(4076, 3191, 'ig', 99),
(4078, 101, 'perc', 180),
(4079, 3009, 'perc', 70),
(4081, 3650, 'tol', 3),
(4082, 2237, 'tol', 3),
(4086, 4145, 'ig', 14),
(4090, 1262, 'tol', 3),
(4092, 2122, 'perc', 50),
(4093, 4390, 'tol', 6),
(4094, 5219, 'perc', 40),
(4096, 3345, 'perc', 80),
(4097, 5403, 'tol', 16),
(4099, 786, 'ig', 99),
(4100, 3828, 'felvonás', 2),
(4101, 942, 'tol', 3),
(4105, 4420, 'perc', 45),
(4106, 1827, 'tol', 3),
(4107, 2151, 'felvonás', 2),
(4109, 3531, 'felvonás', 1),
(4110, 812, 'ig', 14),
(4114, 3775, 'felvonás', 1),
(4115, 5648, 'perc', 105),
(4116, 230, 'ig', 6),
(4120, 4954, 'ig', 3),
(4126, 3072, 'felvonás', 2),
(4128, 1450, 'felvonás', 1),
(4129, 1383, 'tol', 9),
(4133, 3985, 'felvonás', 1),
(4134, 4372, 'tol', 6),
(4137, 5361, 'tol', 3),
(4138, 3550, 'ig', 99),
(4139, 827, 'felvonás', 1),
(4142, 5180, 'ig', 14),
(4143, 4359, 'ig', 14),
(4145, 577, 'tol', 16),
(4147, 1878, 'tol', 5),
(4148, 2027, 'ig', 10),
(4149, 2719, 'perc', 120),
(4151, 3633, 'tol', 4),
(4152, 1509, 'ig', 10),
(4153, 4078, 'tol', 1),
(4154, 4187, 'perc', 100),
(4155, 5845, 'perc', 90),
(4156, 800, 'ig', 99),
(4157, 2054, 'ig', 12),
(4158, 4841, 'tol', 16),
(4161, 2977, 'tol', 6),
(4163, 1449, 'ig', 99),
(4164, 4577, 'tol', 18),
(4165, 732, 'ig', 14),
(4169, 3833, 'perc', 150),
(4170, 1400, 'ig', 14),
(4171, 4103, 'felvonás', 3),
(4172, 2921, 'felvonás', 2),
(4173, 5786, 'perc', 90),
(4177, 4218, 'tol', 3),
(4178, 1382, 'tol', 8),
(4179, 4509, 'perc', 60),
(4180, 2751, 'ig', 12),
(4181, 765, 'tol', 16),
(4182, 4709, 'felvonás', 2),
(4185, 3346, 'tol', 12),
(4187, 3634, 'felvonás', 1),
(4188, 4320, 'ig', 18),
(4190, 3306, 'ig', 99),
(4193, 2185, 'tol', 14),
(4195, 520, 'ig', 14),
(4196, 1169, 'felvonás', 1),
(4197, 612, 'tol', 3),
(4200, 4984, 'ig', 11),
(4203, 4533, 'felvonás', 1),
(4204, 5112, 'perc', 100),
(4205, 5874, 'perc', 160),
(4207, 669, 'ig', 99),
(4208, 4452, 'ig', 8),
(4210, 5893, 'ig', 10),
(4211, 5066, 'tol', 6),
(4214, 2429, 'felvonás', 2),
(4216, 2247, 'tol', 10),
(4217, 2187, 'perc', 70),
(4218, 4230, 'perc', 50),
(4226, 2171, 'tol', 5),
(4227, 3227, 'ig', 99),
(4228, 4118, 'perc', 50),
(4230, 4349, 'felvonás', 2),
(4231, 2458, 'felvonás', 3),
(4233, 4497, 'ig', 99),
(4236, 4581, 'felvonás', 2),
(4237, 2900, 'tol', 16),
(4238, 1900, 'ig', 99),
(4239, 1824, 'ig', 14),
(4240, 2420, 'tol', 3),
(4241, 3442, 'tol', 3),
(4242, 4745, 'felvonás', 1),
(4244, 2605, 'perc', 140),
(4246, 1040, 'ig', 99),
(4251, 5458, 'tol', 7),
(4252, 849, 'felvonás', 1),
(4260, 1863, 'ig', 16),
(4261, 4142, 'perc', 45),
(4262, 1386, 'perc', 70),
(4264, 2017, 'ig', 14),
(4265, 4173, 'perc', 50),
(4271, 4175, 'felvonás', 1),
(4272, 5539, 'tol', 3),
(4274, 5433, 'perc', 130),
(4275, 701, 'felvonás', 1),
(4276, 5220, 'felvonás', 1),
(4277, 3244, 'tol', 3),
(4279, 60, 'perc', 100),
(4280, 3212, 'felvonás', 2),
(4281, 4576, 'tol', 16),
(4282, 1817, 'felvonás', 2),
(4283, 973, 'tol', 1),
(4284, 3156, 'ig', 99),
(4285, 3721, 'tol', 6),
(4287, 2502, 'ig', 12),
(4289, 1828, 'tol', 14),
(4290, 287, 'felvonás', 2),
(4292, 4654, 'felvonás', 2),
(4293, 3125, 'tol', 4),
(4294, 1624, 'tol', 9),
(4296, 4671, 'ig', 14),
(4298, 665, 'ig', 99),
(4300, 4176, 'felvonás', 2),
(4301, 3358, 'perc', 120),
(4302, 3984, 'tol', 3),
(4304, 2886, 'felvonás', 2),
(4306, 2974, 'felvonás', 2),
(4307, 430, 'perc', 40),
(4308, 3885, 'ig', 99),
(4310, 3549, 'tol', 4),
(4311, 4820, 'tol', 10),
(4313, 3117, 'tol', 8),
(4314, 4036, 'tol', 16),
(4319, 43, 'tol', 6),
(4320, 4980, 'tol', 5),
(4321, 2816, 'tol', 4),
(4322, 2651, 'ig', 12),
(4323, 4967, 'ig', 14),
(4326, 5090, 'tol', 4),
(4327, 3866, 'felvonás', 1),
(4328, 624, 'perc', 110),
(4329, 4977, 'perc', 50),
(4330, 3224, 'tol', 15),
(4331, 3241, 'tol', 3),
(4333, 1746, 'ig', 3),
(4336, 3289, 'tol', 10),
(4337, 282, 'felvonás', 2),
(4338, 1788, 'felvonás', 2),
(4341, 1465, 'tol', 12),
(4342, 3114, 'tol', 4),
(4346, 266, 'tol', 3),
(4348, 3974, 'tol', 4),
(4350, 3553, 'perc', 155),
(4352, 5584, 'ig', 12),
(4354, 2121, 'ig', 14),
(4356, 582, 'felvonás', 2),
(4357, 5006, 'tol', 4),
(4358, 1451, 'felvonás', 2),
(4360, 3690, 'tol', 4),
(4362, 859, 'ig', 12),
(4363, 1350, 'ig', 5),
(4365, 3975, 'tol', 3),
(4366, 3054, 'tol', 3),
(4368, 413, 'perc', 25),
(4370, 4886, 'ig', 14),
(4371, 5526, 'tol', 3),
(4373, 1531, 'felvonás', 1),
(4374, 4743, 'ig', 12),
(4375, 4402, 'tol', 3),
(4376, 529, 'ig', 6),
(4377, 2913, 'perc', 70),
(4379, 5364, 'felvonás', 2),
(4382, 670, 'ig', 14),
(4383, 187, 'felvonás', 2),
(4384, 5129, 'ig', 14),
(4385, 3442, 'ig', 12),
(4387, 3597, 'felvonás', 2),
(4391, 3317, 'felvonás', 2),
(4393, 1726, 'tol', 16),
(4395, 1988, 'perc', 90),
(4396, 1869, 'perc', 60),
(4399, 324, 'tol', 4),
(4400, 3791, 'tol', 6),
(4401, 5253, 'tol', 3),
(4402, 946, 'perc', 40),
(4405, 5327, 'felvonás', 2),
(4409, 1776, 'felvonás', 1),
(4410, 4745, 'ig', 10),
(4411, 2212, 'tol', 12),
(4414, 1377, 'felvonás', 1),
(4417, 3096, 'felvonás', 2),
(4419, 4811, 'felvonás', 2),
(4422, 1987, 'tol', 3),
(4425, 2276, 'perc', 74),
(4427, 3706, 'ig', 18),
(4436, 2989, 'perc', 45),
(4437, 4472, 'tol', 3),
(4438, 2215, 'tol', 4),
(4439, 1242, 'tol', 14),
(4441, 4409, 'felvonás', 2),
(4442, 2837, 'ig', 14),
(4443, 2671, 'perc', 145),
(4448, 1350, 'tol', 3),
(4449, 2105, 'tol', 12),
(4450, 4317, 'tol', 3),
(4453, 4002, 'ig', 14),
(4454, 3595, 'felvonás', 1),
(4455, 987, 'tol', 3),
(4456, 4025, 'tol', 15),
(4457, 4947, 'tol', 16),
(4462, 2807, 'perc', 160),
(4463, 3554, 'tol', 3),
(4466, 3291, 'perc', 165),
(4468, 864, 'tol', 4),
(4470, 3564, 'felvonás', 1),
(4471, 2926, 'tol', 6),
(4472, 5632, 'felvonás', 2),
(4474, 512, 'perc', 120),
(4482, 1472, 'tol', 12),
(4485, 4477, 'tol', 4),
(4487, 1540, 'felvonás', 2),
(4488, 1294, 'felvonás', 2),
(4491, 35, 'tol', 3),
(4492, 1338, 'ig', 99),
(4493, 2824, 'perc', 70),
(4494, 2886, 'perc', 135),
(4495, 5263, 'tol', 14),
(4497, 1169, 'tol', 8),
(4498, 2834, 'tol', 4),
(4499, 4305, 'ig', 99),
(4500, 406, 'felvonás', 2),
(4501, 565, 'felvonás', 2),
(4503, 891, 'tol', 6),
(4504, 984, 'ig', 14),
(4506, 872, 'felvonás', 3),
(4507, 3259, 'perc', 70),
(4508, 5464, 'felvonás', 3),
(4510, 412, 'ig', 99),
(4513, 4815, 'ig', 3),
(4515, 5297, 'ig', 99),
(4516, 4777, 'felvonás', 2),
(4517, 606, 'tol', 7),
(4518, 848, 'tol', 3),
(4519, 3555, 'felvonás', 2),
(4521, 4904, 'ig', 10),
(4522, 4007, 'felvonás', 2),
(4523, 5770, 'perc', 130),
(4524, 3068, 'tol', 3),
(4525, 5627, 'ig', 99),
(4526, 2642, 'tol', 9),
(4528, 2201, 'tol', 3),
(4529, 5633, 'ig', 14),
(4530, 2866, 'ig', 10),
(4531, 5809, 'ig', 99),
(4533, 5145, 'perc', 40),
(4535, 1081, 'ig', 14),
(4537, 1320, 'felvonás', 3),
(4538, 4146, 'perc', 50),
(4540, 3268, 'perc', 80),
(4541, 3257, 'tol', 13),
(4542, 3298, 'ig', 12),
(4543, 5877, 'ig', 99),
(4545, 3751, 'tol', 3),
(4547, 2554, 'perc', 40),
(4548, 237, 'perc', 100),
(4549, 4475, 'tol', 6),
(4552, 2574, 'perc', 50),
(4554, 2249, 'felvonás', 2),
(4555, 581, 'ig', 3),
(4557, 4372, 'ig', 14),
(4558, 5378, 'perc', 120),
(4559, 3248, 'ig', 10),
(4561, 1757, 'felvonás', 1),
(4562, 5782, 'ig', 3),
(4565, 1662, 'tol', 4),
(4566, 2483, 'ig', 99),
(4567, 565, 'tol', 10),
(4568, 835, 'perc', 30),
(4573, 3419, 'perc', 50),
(4574, 2212, 'perc', 160),
(4577, 3498, 'tol', 6),
(4578, 4382, 'felvonás', 3),
(4579, 4145, 'perc', 70),
(4580, 1116, 'felvonás', 2),
(4581, 2137, 'felvonás', 3),
(4583, 4489, 'tol', 16),
(4585, 546, 'felvonás', 1),
(4588, 5502, 'felvonás', 3),
(4592, 2987, 'ig', 14),
(4595, 2823, 'perc', 150),
(4596, 4767, 'felvonás', 2),
(4598, 2734, 'perc', 50),
(4599, 920, 'perc', 90),
(4602, 264, 'perc', 90),
(4611, 5112, 'tol', 16),
(4615, 5410, 'tol', 8),
(4616, 4511, 'ig', 99),
(4617, 2601, 'ig', 14),
(4618, 3631, 'tol', 4),
(4619, 2305, 'felvonás', 2),
(4620, 1100, 'felvonás', 2),
(4623, 3068, 'ig', 14),
(4624, 1597, 'felvonás', 2),
(4626, 1113, 'felvonás', 2),
(4627, 2242, 'felvonás', 1),
(4628, 5815, 'perc', 105),
(4632, 2227, 'tol', 3),
(4635, 5340, 'ig', 12),
(4636, 2007, 'perc', 50),
(4638, 1844, 'tol', 14),
(4639, 945, 'ig', 14),
(4642, 2489, 'felvonás', 2),
(4644, 3795, 'perc', 75),
(4645, 4475, 'ig', 14),
(4646, 259, 'felvonás', 2),
(4647, 5335, 'tol', 4),
(4649, 1139, 'felvonás', 1),
(4651, 4006, 'perc', 90),
(4652, 1539, 'felvonás', 2),
(4653, 841, 'felvonás', 1),
(4654, 3460, 'felvonás', 2),
(4657, 3234, 'perc', 40),
(4658, 3117, 'ig', 99),
(4659, 1017, 'ig', 99),
(4660, 1512, 'tol', 3),
(4661, 2261, 'ig', 99),
(4663, 4959, 'perc', 60),
(4664, 1599, 'tol', 5),
(4665, 2041, 'ig', 10),
(4667, 1661, 'ig', 14),
(4669, 4378, 'tol', 14),
(4671, 5041, 'felvonás', 2),
(4673, 906, 'perc', 90),
(4674, 5204, 'tol', 16),
(4675, 3257, 'ig', 15),
(4679, 5366, 'ig', 10),
(4682, 3916, 'perc', 65),
(4683, 5619, 'felvonás', 2),
(4687, 4559, 'felvonás', 3),
(4692, 204, 'tol', 3),
(4693, 2156, 'felvonás', 2),
(4695, 5442, 'perc', 70),
(4696, 2824, 'felvonás', 1),
(4698, 2469, 'felvonás', 1),
(4699, 3630, 'ig', 10),
(4700, 5846, 'tol', 18),
(4703, 4911, 'ig', 14),
(4704, 949, 'ig', 99),
(4705, 5006, 'felvonás', 2),
(4706, 1374, 'felvonás', 2),
(4707, 4955, 'ig', 99),
(4711, 341, 'ig', 99),
(4713, 3064, 'felvonás', 3),
(4716, 382, 'perc', 135),
(4718, 2675, 'felvonás', 2),
(4719, 605, 'ig', 8),
(4721, 4607, 'felvonás', 2),
(4722, 3073, 'felvonás', 2),
(4723, 481, 'ig', 99),
(4727, 807, 'felvonás', 2),
(4728, 4287, 'ig', 14),
(4730, 1665, 'ig', 14),
(4734, 4053, 'tol', 12),
(4736, 3357, 'ig', 12),
(4741, 5198, 'tol', 6),
(4743, 3343, 'felvonás', 1),
(4745, 960, 'felvonás', 2),
(4746, 5098, 'felvonás', 1),
(4749, 2550, 'felvonás', 2),
(4751, 4635, 'felvonás', 2),
(4752, 4641, 'perc', 140),
(4754, 5813, 'felvonás', 2),
(4755, 3807, 'ig', 10),
(4756, 4318, 'ig', 6),
(4760, 3186, 'tol', 6),
(4762, 5321, 'tol', 10),
(4768, 2713, 'tol', 10),
(4770, 938, 'felvonás', 2),
(4772, 3512, 'perc', 160),
(4774, 4507, 'ig', 14),
(4778, 106, 'felvonás', 2),
(4779, 5172, 'felvonás', 2),
(4780, 1410, 'felvonás', 2),
(4781, 642, 'perc', 65),
(4782, 4980, 'ig', 9),
(4788, 2641, 'ig', 14),
(4790, 512, 'felvonás', 2),
(4791, 4843, 'ig', 99),
(4792, 5168, 'tol', 15),
(4795, 5263, 'felvonás', 1),
(4796, 3469, 'felvonás', 2),
(4798, 5428, 'felvonás', 2),
(4799, 2103, 'tol', 6),
(4801, 2938, 'perc', 45),
(4805, 2838, 'tol', 16),
(4806, 2795, 'perc', 70),
(4807, 3504, 'felvonás', 2),
(4808, 93, 'tol', 16),
(4810, 686, 'ig', 99),
(4812, 2822, 'tol', 8),
(4813, 2450, 'ig', 14),
(4816, 398, 'tol', 1),
(4817, 3634, 'perc', 90),
(4818, 4217, 'perc', 100),
(4820, 1874, 'ig', 7),
(4821, 3256, 'tol', 18),
(4822, 1202, 'felvonás', 2),
(4823, 750, 'ig', 12),
(4824, 3656, 'perc', 170),
(4825, 800, 'tol', 3),
(4827, 1422, 'felvonás', 2),
(4828, 1415, 'felvonás', 2),
(4831, 4046, 'felvonás', 1),
(4832, 3346, 'ig', 99),
(4833, 3971, 'tol', 3),
(4837, 79, 'felvonás', 3),
(4839, 409, 'tol', 15),
(4842, 425, 'perc', 70),
(4843, 3065, 'ig', 10),
(4844, 1971, 'tol', 3),
(4845, 3171, 'ig', 12),
(4846, 5267, 'tol', 12),
(4848, 3234, 'ig', 8),
(4849, 210, 'felvonás', 1),
(4851, 2400, 'perc', 50),
(4852, 991, 'felvonás', 2),
(4854, 986, 'felvonás', 1),
(4857, 5050, 'tol', 16),
(4858, 1582, 'felvonás', 2),
(4859, 2316, 'tol', 5),
(4861, 1020, 'felvonás', 2),
(4862, 1929, 'ig', 99),
(4863, 2683, 'ig', 12),
(4867, 5180, 'perc', 180),
(4868, 4339, 'perc', 53),
(4869, 3198, 'tol', 6),
(4870, 695, 'tol', 14),
(4872, 3899, 'tol', 1),
(4873, 4645, 'ig', 99),
(4875, 2602, 'tol', 16),
(4885, 5766, 'ig', 99),
(4886, 3364, 'tol', 3),
(4888, 3016, 'perc', 45),
(4890, 4000, 'perc', 50),
(4892, 3339, 'tol', 10),
(4895, 2972, 'tol', 7),
(4896, 1824, 'tol', 10),
(4897, 3868, 'ig', 12),
(4899, 5378, 'ig', 99),
(4900, 4257, 'perc', 80),
(4902, 1375, 'felvonás', 2),
(4903, 1206, 'tol', 6),
(4904, 1213, 'felvonás', 2),
(4905, 4543, 'tol', 3),
(4907, 4914, 'perc', 60),
(4908, 3951, 'ig', 99),
(4910, 5893, 'tol', 7),
(4911, 5177, 'perc', 130),
(4913, 2320, 'perc', 50),
(4914, 5728, 'ig', 14),
(4915, 2392, 'perc', 160),
(4923, 5270, 'perc', 165),
(4924, 4372, 'felvonás', 2),
(4925, 1825, 'felvonás', 2),
(4927, 1499, 'felvonás', 2),
(4928, 2217, 'perc', 140),
(4930, 4087, 'perc', 55),
(4932, 2876, 'felvonás', 1),
(4933, 5815, 'ig', 99),
(4935, 2758, 'ig', 14),
(4937, 481, 'tol', 5),
(4938, 2416, 'felvonás', 2),
(4940, 2858, 'felvonás', 2),
(4941, 5416, 'tol', 5),
(4945, 2346, 'tol', 16),
(4947, 5840, 'tol', 6),
(4948, 3392, 'tol', 3),
(4952, 2201, 'ig', 14),
(4954, 4868, 'felvonás', 2),
(4962, 4146, 'tol', 4),
(4963, 5837, 'tol', 6),
(4966, 3127, 'tol', 3),
(4971, 3202, 'felvonás', 2),
(4972, 5322, 'felvonás', 2),
(4974, 1532, 'ig', 99),
(4978, 4751, 'felvonás', 2),
(4979, 5611, 'felvonás', 2),
(4980, 1025, 'tol', 6),
(4981, 1710, 'tol', 3),
(4984, 3967, 'felvonás', 2),
(4986, 2006, 'tol', 18),
(4987, 960, 'perc', 150),
(4988, 1228, 'tol', 5),
(4990, 5838, 'perc', 80),
(4991, 998, 'perc', 140),
(4992, 928, 'ig', 14),
(4993, 2977, 'ig', 14),
(4994, 536, 'ig', 14),
(4995, 3073, 'perc', 70),
(5000, 3528, 'tol', 3),
(5003, 2405, 'ig', 14),
(5004, 2587, 'tol', 1),
(5005, 55, 'ig', 99),
(5008, 2651, 'tol', 3),
(5009, 3752, 'tol', 4),
(5010, 910, 'felvonás', 2),
(5011, 2097, 'felvonás', 2),
(5013, 5233, 'felvonás', 2),
(5016, 2085, 'felvonás', 3),
(5018, 2419, 'felvonás', 3),
(5019, 1348, 'ig', 12),
(5021, 2886, 'tol', 16),
(5022, 1757, 'tol', 3),
(5024, 965, 'felvonás', 1),
(5025, 4060, 'tol', 6),
(5026, 568, 'tol', 4),
(5027, 4655, 'perc', 125),
(5028, 4341, 'ig', 99),
(5031, 63, 'tol', 16),
(5032, 33, 'perc', 100),
(5034, 3545, 'felvonás', 1),
(5037, 4404, 'tol', 1),
(5038, 3279, 'perc', 90),
(5040, 1375, 'ig', 99),
(5045, 2557, 'felvonás', 3),
(5049, 5698, 'felvonás', 2),
(5050, 1999, 'tol', 14),
(5051, 62, 'felvonás', 1),
(5054, 728, 'tol', 4),
(5056, 3361, 'felvonás', 1),
(5057, 5773, 'tol', 4),
(5058, 1991, 'felvonás', 1),
(5061, 2732, 'ig', 99),
(5063, 4813, 'tol', 14),
(5065, 3398, 'tol', 6),
(5066, 526, 'tol', 7),
(5067, 428, 'felvonás', 3),
(5068, 4849, 'ig', 12),
(5069, 2586, 'ig', 12),
(5070, 208, 'ig', 99),
(5074, 3291, 'felvonás', 2),
(5075, 1178, 'felvonás', 2),
(5078, 329, 'felvonás', 2),
(5080, 1073, 'tol', 6),
(5081, 4805, 'felvonás', 1),
(5084, 2333, 'perc', 150),
(5086, 4745, 'tol', 3),
(5087, 1003, 'tol', 4),
(5088, 2245, 'tol', 16),
(5092, 3464, 'perc', 60),
(5094, 2663, 'tol', 6),
(5099, 17, 'tol', 5),
(5100, 5158, 'perc', 50),
(5102, 842, 'felvonás', 2),
(5105, 1746, 'tol', 1),
(5106, 5786, 'felvonás', 1),
(5108, 1991, 'ig', 99),
(5109, 2268, 'tol', 6),
(5111, 4487, 'felvonás', 2),
(5116, 822, 'tol', 12),
(5117, 4328, 'tol', 4),
(5124, 3397, 'tol', 12),
(5125, 5162, 'ig', 10),
(5126, 4836, 'felvonás', 2),
(5128, 3902, 'felvonás', 2),
(5129, 2727, 'perc', 20),
(5131, 3706, 'tol', 13),
(5132, 2553, 'perc', 110),
(5134, 1454, 'tol', 8),
(5136, 3572, 'felvonás', 2),
(5138, 720, 'felvonás', 3),
(5140, 5824, 'perc', 60),
(5143, 914, 'felvonás', 1),
(5145, 4830, 'perc', 90),
(5146, 2991, 'felvonás', 2),
(5148, 2457, 'tol', 3),
(5149, 3171, 'perc', 120),
(5150, 370, 'ig', 14),
(5151, 1632, 'felvonás', 2),
(5152, 4500, 'ig', 99),
(5153, 927, 'ig', 10),
(5154, 1727, 'tol', 3),
(5155, 2226, 'felvonás', 2),
(5156, 3995, 'felvonás', 3),
(5157, 4004, 'felvonás', 2),
(5158, 279, 'ig', 14),
(5159, 2332, 'tol', 10),
(5160, 3946, 'felvonás', 2),
(5162, 5236, 'tol', 3),
(5163, 4493, 'ig', 99),
(5165, 1226, 'perc', 90),
(5167, 3837, 'tol', 10),
(5168, 4868, 'perc', 130),
(5174, 2103, 'ig', 14),
(5175, 3391, 'ig', 12),
(5177, 4899, 'tol', 1),
(5178, 162, 'perc', 90),
(5180, 452, 'tol', 18),
(5181, 3589, 'perc', 90),
(5182, 4448, 'tol', 5),
(5184, 3017, 'tol', 14),
(5185, 3110, 'felvonás', 1),
(5186, 2404, 'felvonás', 1),
(5188, 3899, 'ig', 4),
(5192, 2596, 'perc', 90),
(5194, 1539, 'perc', 120),
(5197, 2815, 'felvonás', 3),
(5198, 71, 'perc', 160),
(5199, 1453, 'tol', 8),
(5201, 886, 'felvonás', 2),
(5204, 1303, 'ig', 10),
(5205, 3290, 'ig', 12),
(5206, 4928, 'tol', 3),
(5208, 638, 'ig', 99),
(5209, 1267, 'felvonás', 2),
(5210, 5537, 'tol', 14),
(5212, 4852, 'felvonás', 2),
(5214, 1012, 'perc', 60),
(5215, 4008, 'perc', 40),
(5217, 4537, 'ig', 14),
(5218, 529, 'tol', 3),
(5222, 4295, 'ig', 99),
(5223, 3237, 'perc', 130),
(5224, 899, 'ig', 10),
(5225, 2843, 'felvonás', 2),
(5228, 664, 'tol', 8),
(5229, 4954, 'perc', 20),
(5230, 1444, 'tol', 6),
(5234, 5767, 'felvonás', 3),
(5235, 209, 'tol', 4),
(5236, 3128, 'tol', 9),
(5238, 2654, 'ig', 14),
(5242, 4392, 'tol', 9),
(5243, 1912, 'tol', 18),
(5246, 33, 'felvonás', 1),
(5248, 2719, 'ig', 99),
(5249, 244, 'ig', 15),
(5250, 1209, 'ig', 4),
(5251, 973, 'ig', 14),
(5252, 5764, 'tol', 16),
(5254, 4655, 'felvonás', 2),
(5257, 1004, 'felvonás', 2),
(5263, 4892, 'felvonás', 1),
(5264, 2966, 'tol', 3),
(5266, 178, 'tol', 8),
(5272, 5587, 'tol', 6),
(5273, 4311, 'felvonás', 2),
(5275, 4390, 'ig', 99),
(5276, 4419, 'tol', 6),
(5278, 1705, 'felvonás', 2),
(5279, 5187, 'felvonás', 2),
(5281, 2605, 'felvonás', 2),
(5282, 1827, 'ig', 14),
(5283, 2732, 'tol', 4),
(5284, 1977, 'felvonás', 2),
(5285, 4307, 'tol', 1),
(5289, 5042, 'tol', 6),
(5292, 2643, 'ig', 99),
(5293, 3699, 'perc', 50),
(5298, 2255, 'felvonás', 2),
(5301, 512, 'tol', 14),
(5304, 1264, 'felvonás', 1),
(5305, 4402, 'felvonás', 1),
(5307, 4752, 'perc', 60),
(5308, 4149, 'perc', 180),
(5310, 1483, 'tol', 14),
(5312, 5530, 'tol', 6),
(5313, 5493, 'ig', 99),
(5314, 4873, 'tol', 6),
(5315, 4459, 'perc', 50),
(5317, 3269, 'tol', 6),
(5318, 4363, 'ig', 14),
(5319, 3223, 'tol', 3),
(5321, 4880, 'tol', 9),
(5323, 370, 'tol', 6),
(5325, 2726, 'felvonás', 2),
(5326, 4913, 'felvonás', 2),
(5329, 1473, 'tol', 6),
(5330, 2287, 'tol', 3),
(5331, 863, 'ig', 10),
(5332, 2306, 'felvonás', 2),
(5333, 5677, 'ig', 99),
(5337, 5685, 'tol', 10),
(5339, 4917, 'tol', 14),
(5341, 5351, 'felvonás', 2),
(5343, 558, 'perc', 120),
(5347, 4945, 'ig', 13),
(5350, 826, 'ig', 14),
(5351, 4603, 'felvonás', 2),
(5352, 4591, 'perc', 20),
(5353, 3851, 'felvonás', 2),
(5354, 4225, 'perc', 200),
(5355, 1132, 'felvonás', 2),
(5356, 1517, 'felvonás', 1),
(5357, 1008, 'tol', 15),
(5359, 4620, 'tol', 8),
(5360, 4321, 'felvonás', 2),
(5362, 5027, 'felvonás', 3),
(5364, 2109, 'perc', 50),
(5365, 2261, 'tol', 10),
(5367, 1561, 'felvonás', 1),
(5368, 1103, 'felvonás', 2),
(5369, 4935, 'felvonás', 2),
(5371, 4639, 'tol', 8),
(5372, 2812, 'felvonás', 2),
(5373, 3389, 'ig', 10),
(5374, 1014, 'perc', 96),
(5375, 2200, 'tol', 6),
(5380, 1613, 'tol', 2),
(5381, 1696, 'ig', 99),
(5382, 2356, 'felvonás', 2),
(5383, 423, 'perc', 135),
(5384, 1624, 'ig', 12),
(5386, 2160, 'felvonás', 1),
(5387, 3917, 'felvonás', 1),
(5389, 3469, 'ig', 14),
(5390, 4835, 'felvonás', 1),
(5391, 3378, 'ig', 14),
(5392, 1742, 'felvonás', 1),
(5395, 5691, 'tol', 10),
(5396, 979, 'tol', 16),
(5398, 4179, 'ig', 99),
(5399, 1699, 'felvonás', 1),
(5400, 1562, 'tol', 5),
(5402, 3484, 'tol', 16),
(5403, 418, 'ig', 3),
(5408, 5046, 'perc', 60),
(5410, 1847, 'ig', 12),
(5412, 2910, 'tol', 18),
(5414, 1732, 'felvonás', 2),
(5415, 1495, 'felvonás', 1),
(5417, 207, 'felvonás', 1),
(5419, 3691, 'tol', 18),
(5426, 324, 'ig', 10),
(5431, 1852, 'felvonás', 2),
(5434, 4846, 'tol', 7),
(5435, 3330, 'ig', 6),
(5437, 616, 'felvonás', 4),
(5439, 3280, 'perc', 110),
(5440, 4849, 'tol', 7),
(5441, 858, 'ig', 99),
(5443, 936, 'felvonás', 2),
(5444, 720, 'perc', 160),
(5445, 4096, 'ig', 99),
(5448, 2865, 'perc', 50),
(5449, 3901, 'felvonás', 2),
(5450, 4693, 'ig', 10),
(5451, 1130, 'felvonás', 2),
(5457, 2927, 'ig', 14),
(5458, 2170, 'ig', 14),
(5460, 2716, 'tol', 6),
(5461, 2468, 'tol', 4),
(5465, 722, 'felvonás', 2),
(5466, 1115, 'felvonás', 2),
(5468, 3241, 'ig', 14),
(5469, 5270, 'felvonás', 2),
(5470, 763, 'felvonás', 2),
(5471, 1118, 'ig', 10),
(5474, 3816, 'felvonás', 3),
(5475, 5101, 'perc', 45),
(5478, 2292, 'felvonás', 2),
(5479, 5661, 'felvonás', 1),
(5480, 3145, 'ig', 6),
(5482, 412, 'tol', 14),
(5484, 1507, 'tol', 6),
(5485, 2325, 'ig', 14),
(5490, 3398, 'felvonás', 2),
(5491, 1815, 'perc', 75),
(5494, 4776, 'tol', 10),
(5495, 332, 'tol', 3),
(5497, 5293, 'felvonás', 1),
(5499, 2981, 'felvonás', 2),
(5501, 5888, 'felvonás', 2),
(5505, 4907, 'perc', 90),
(5507, 5540, 'perc', 90),
(5508, 1798, 'tol', 3),
(5509, 5245, 'tol', 18),
(5510, 1787, 'ig', 99),
(5511, 3454, 'ig', 99),
(5512, 2237, 'ig', 14),
(5514, 1265, 'perc', 120),
(5516, 2518, 'perc', 140),
(5519, 5234, 'ig', 14),
(5522, 1350, 'perc', 55),
(5524, 5318, 'tol', 3),
(5527, 4873, 'felvonás', 2),
(5530, 989, 'tol', 12),
(5531, 4240, 'tol', 6),
(5535, 3608, 'tol', 16),
(5536, 208, 'tol', 3),
(5537, 5753, 'ig', 99),
(5539, 625, 'tol', 12),
(5540, 873, 'tol', 3),
(5541, 1101, 'ig', 3),
(5542, 5226, 'ig', 12),
(5546, 4254, 'felvonás', 2),
(5547, 2393, 'felvonás', 3),
(5548, 1770, 'ig', 99),
(5549, 1088, 'tol', 6),
(5550, 4828, 'tol', 3),
(5551, 5129, 'tol', 6),
(5552, 4599, 'perc', 60),
(5553, 755, 'tol', 10),
(5556, 4150, 'felvonás', 3),
(5558, 1474, 'tol', 4),
(5559, 1364, 'tol', 4),
(5561, 2281, 'tol', 6),
(5563, 2707, 'tol', 3),
(5565, 1550, 'tol', 6),
(5566, 4218, 'ig', 10),
(5568, 5286, 'perc', 155),
(5571, 5413, 'tol', 4),
(5572, 855, 'felvonás', 2),
(5573, 2371, 'perc', 165),
(5575, 241, 'perc', 120),
(5577, 4907, 'tol', 6),
(5578, 3563, 'felvonás', 2),
(5579, 881, 'ig', 3),
(5580, 500, 'ig', 3),
(5581, 5010, 'ig', 10),
(5585, 5530, 'ig', 14),
(5586, 2056, 'ig', 12),
(5589, 4015, 'felvonás', 2),
(5591, 5220, 'perc', 90),
(5592, 5796, 'tol', 5),
(5594, 3381, 'ig', 99),
(5596, 5580, 'tol', 3),
(5598, 4466, 'ig', 99),
(5599, 18, 'felvonás', 2),
(5603, 1982, 'tol', 6),
(5604, 2017, 'tol', 7),
(5607, 2970, 'perc', 150),
(5609, 3306, 'felvonás', 2),
(5610, 60, 'felvonás', 2),
(5611, 3862, 'felvonás', 1),
(5612, 570, 'felvonás', 2),
(5616, 4316, 'felvonás', 2),
(5618, 1338, 'tol', 4),
(5619, 780, 'tol', 3),
(5621, 1449, 'tol', 14),
(5622, 2491, 'tol', 5),
(5623, 3128, 'ig', 99),
(5624, 3589, 'tol', 12),
(5625, 1926, 'tol', 16),
(5627, 1169, 'ig', 99),
(5629, 3767, 'felvonás', 2),
(5631, 5410, 'ig', 105),
(5634, 2252, 'tol', 6),
(5635, 3734, 'felvonás', 4),
(5637, 2247, 'ig', 99),
(5638, 1843, 'tol', 4),
(5642, 5372, 'tol', 15),
(5644, 874, 'felvonás', 2),
(5645, 853, 'perc', 60),
(5648, 377, 'felvonás', 1),
(5649, 2068, 'felvonás', 2),
(5651, 1594, 'tol', 5),
(5653, 1162, 'tol', 6),
(5654, 1041, 'felvonás', 3),
(5655, 2602, 'perc', 140),
(5657, 2204, 'felvonás', 2),
(5658, 1444, 'ig', 14),
(5659, 1137, 'felvonás', 2),
(5660, 4088, 'ig', 10),
(5662, 340, 'tol', 6),
(5664, 2463, 'tol', 3),
(5665, 4822, 'perc', 90),
(5666, 5770, 'ig', 14),
(5667, 2760, 'felvonás', 3),
(5670, 3003, 'felvonás', 1),
(5674, 1958, 'ig', 14),
(5676, 5822, 'ig', 99),
(5677, 5376, 'perc', 40),
(5678, 1360, 'felvonás', 2),
(5679, 4315, 'felvonás', 2),
(5681, 3702, 'perc', 90),
(5682, 460, 'perc', 150),
(5684, 5766, 'tol', 3),
(5688, 3953, 'perc', 135),
(5694, 5164, 'felvonás', 2),
(5697, 5768, 'ig', 10),
(5698, 2574, 'felvonás', 1),
(5700, 3595, 'perc', 50),
(5701, 3572, 'tol', 12),
(5704, 1524, 'ig', 8),
(5705, 455, 'felvonás', 3),
(5706, 1003, 'ig', 14),
(5708, 5832, 'felvonás', 1),
(5710, 532, 'felvonás', 2),
(5711, 3036, 'tol', 3),
(5718, 2474, 'perc', 40),
(5719, 3564, 'perc', 60),
(5720, 3, 'felvonás', 2),
(5723, 2391, 'felvonás', 2),
(5725, 4966, 'felvonás', 1),
(5727, 2558, 'tol', 10),
(5729, 642, 'felvonás', 1),
(5731, 25, 'perc', 90),
(5735, 512, 'ig', 99),
(5736, 1877, 'tol', 18),
(5737, 5753, 'tol', 16),
(5738, 3021, 'tol', 12),
(5742, 5476, 'felvonás', 3),
(5743, 5273, 'tol', 3),
(5748, 3770, 'felvonás', 3),
(5753, 2794, 'tol', 6),
(5755, 4459, 'tol', 4),
(5757, 205, 'tol', 1),
(5759, 2122, 'tol', 4),
(5761, 1581, 'ig', 12),
(5762, 5113, 'felvonás', 1),
(5766, 4647, 'felvonás', 2),
(5767, 4385, 'felvonás', 2),
(5768, 2972, 'ig', 14),
(5773, 5543, 'felvonás', 1),
(5774, 5458, 'ig', 10),
(5775, 1480, 'felvonás', 1),
(5777, 3961, 'ig', 99),
(5778, 851, 'tol', 3),
(5779, 5140, 'tol', 4),
(5780, 4945, 'tol', 6),
(5781, 3718, 'tol', 6),
(5782, 2893, 'felvonás', 3),
(5783, 1337, 'felvonás', 2),
(5786, 4570, 'felvonás', 2),
(5790, 1577, 'tol', 8),
(5791, 3853, 'tol', 3),
(5795, 3298, 'tol', 3),
(5796, 1903, 'tol', 6),
(5797, 577, 'felvonás', 1),
(5798, 3612, 'ig', 99),
(5799, 2814, 'felvonás', 2),
(5804, 647, 'felvonás', 2),
(5807, 753, 'felvonás', 2),
(5808, 5638, 'tol', 3),
(5809, 2246, 'perc', 125),
(5810, 2884, 'felvonás', 2),
(5812, 5258, 'tol', 3),
(5813, 4042, 'ig', 99),
(5817, 2327, 'tol', 3),
(5820, 592, 'ig', 10),
(5826, 3182, 'ig', 14),
(5830, 4169, 'tol', 4),
(5831, 4722, 'tol', 3),
(5834, 1771, 'ig', 14),
(5839, 2322, 'ig', 99),
(5840, 2889, 'ig', 4),
(5842, 5210, 'felvonás', 2),
(5845, 3720, 'felvonás', 3),
(5846, 4096, 'tol', 6),
(5848, 1927, 'ig', 14),
(5849, 3713, 'tol', 3),
(5850, 707, 'ig', 14),
(5851, 2159, 'felvonás', 2),
(5852, 4814, 'felvonás', 2),
(5853, 1910, 'tol', 15),
(5855, 3654, 'ig', 14),
(5857, 4763, 'perc', 60),
(5860, 3519, 'tol', 14),
(5862, 4419, 'ig', 12),
(5864, 536, 'tol', 6),
(5865, 2907, 'perc', 60),
(5869, 4291, 'tol', 5),
(5873, 2527, 'perc', 80),
(5878, 5483, 'felvonás', 2),
(5880, 2918, 'perc', 90),
(5885, 5071, 'ig', 99),
(5886, 1107, 'perc', 80),
(5889, 4777, 'tol', 12),
(5890, 5090, 'perc', 60),
(5892, 1334, 'felvonás', 2),
(5896, 3917, 'perc', 65),
(5897, 563, 'tol', 6),
(5898, 5846, 'ig', 99),
(5900, 1159, 'felvonás', 2),
(5903, 5377, 'tol', 4),
(5904, 2509, 'perc', 60),
(5905, 4679, 'perc', 45),
(5907, 5303, 'tol', 4),
(5908, 2041, 'tol', 3),
(5909, 757, 'perc', 150),
(5911, 4466, 'tol', 3),
(5913, 2182, 'perc', 190),
(5915, 5561, 'felvonás', 2),
(5917, 4834, 'felvonás', 3),
(5919, 1995, 'felvonás', 1),
(5922, 4038, 'tol', 8),
(5923, 4907, 'ig', 14),
(5926, 1986, 'ig', 12),
(5927, 1869, 'felvonás', 1),
(5929, 2343, 'felvonás', 3),
(5930, 4421, 'ig', 14),
(5932, 553, 'ig', 14),
(5933, 2596, 'ig', 18),
(5935, 4392, 'ig', 12),
(5936, 5605, 'ig', 99),
(5938, 3822, 'tol', 4),
(5939, 3855, 'tol', 10),
(5940, 4442, 'tol', 3),
(5941, 3888, 'perc', 300),
(5942, 4462, 'felvonás', 1),
(5944, 3105, 'tol', 14),
(5949, 2439, 'felvonás', 2),
(5950, 3631, 'ig', 10),
(5952, 1097, 'tol', 10),
(5958, 3785, 'tol', 4),
(5959, 5097, 'felvonás', 2),
(5960, 308, 'perc', 100),
(5961, 4232, 'perc', 100),
(5962, 858, 'tol', 9),
(5964, 1229, 'felvonás', 1),
(5966, 3398, 'perc', 100),
(5967, 4963, 'perc', 110),
(5968, 3188, 'felvonás', 2),
(5969, 1334, 'perc', 165),
(5970, 2371, 'tol', 16),
(5973, 2735, 'ig', 99),
(5974, 4083, 'felvonás', 3),
(5976, 2671, 'felvonás', 2),
(5978, 1898, 'tol', 4),
(5983, 110, 'perc', 135),
(5984, 1111, 'ig', 3),
(5988, 581, 'tol', 1),
(5989, 3938, 'ig', 14),
(5990, 3241, 'perc', 50),
(5991, 1444, 'felvonás', 2),
(5996, 799, 'perc', 45),
(5997, 2918, 'ig', 99),
(6000, 5252, 'tol', 14),
(6005, 5196, 'tol', 12),
(6006, 1960, 'tol', 6),
(6008, 429, 'tol', 16),
(6010, 4944, 'ig', 99),
(6013, 3147, 'ig', 14),
(6017, 2872, 'felvonás', 2),
(6018, 5240, 'felvonás', 2),
(6020, 4748, 'tol', 10),
(6022, 4179, 'tol', 3),
(6023, 5339, 'ig', 3),
(6024, 2756, 'felvonás', 2),
(6025, 815, 'felvonás', 3),
(6027, 3248, 'tol', 3),
(6032, 999, 'ig', 18),
(6036, 2235, 'ig', 10),
(6037, 3519, 'ig', 19),
(6040, 5471, 'perc', 90),
(6041, 927, 'tol', 4),
(6044, 5856, 'ig', 15),
(6046, 5487, 'felvonás', 1),
(6047, 563, 'ig', 99),
(6048, 2551, 'tol', 3),
(6049, 340, 'ig', 99),
(6051, 2663, 'ig', 14),
(6053, 4548, 'tol', 3),
(6055, 1425, 'felvonás', 2),
(6056, 890, 'felvonás', 1),
(6061, 4934, 'tol', 16),
(6062, 2757, 'tol', 3),
(6064, 1470, 'felvonás', 2),
(6065, 3301, 'felvonás', 1),
(6066, 3359, 'tol', 7),
(6069, 4892, 'tol', 5),
(6070, 3125, 'ig', 14),
(6071, 4907, 'felvonás', 2),
(6072, 232, 'felvonás', 2),
(6073, 1416, 'ig', 99),
(6075, 4249, 'tol', 3),
(6077, 228, 'tol', 4),
(6080, 5392, 'tol', 4),
(6082, 5817, 'tol', 8),
(6086, 700, 'ig', 12),
(6088, 1088, 'felvonás', 1),
(6090, 4059, 'tol', 3),
(6091, 4720, 'tol', 3),
(6095, 4426, 'perc', 180),
(6097, 4606, 'felvonás', 1),
(6098, 1918, 'tol', 4),
(6099, 5595, 'ig', 99),
(6101, 1874, 'tol', 4),
(6102, 611, 'felvonás', 1),
(6103, 5626, 'felvonás', 2),
(6104, 2909, 'perc', 210),
(6105, 4974, 'tol', 6),
(6106, 4616, 'felvonás', 2),
(6108, 4786, 'felvonás', 2),
(6111, 3611, 'felvonás', 2),
(6112, 2022, 'tol', 3),
(6113, 3399, 'felvonás', 2),
(6114, 4011, 'tol', 10),
(6116, 5651, 'felvonás', 1),
(6122, 5806, 'perc', 150),
(6123, 5144, 'tol', 10),
(6124, 3729, 'ig', 8),
(6127, 5273, 'ig', 99),
(6128, 3668, 'perc', 50),
(6129, 5539, 'perc', 45),
(6130, 5661, 'perc', 65),
(6132, 5645, 'tol', 3),
(6133, 3017, 'ig', 99),
(6136, 796, 'felvonás', 2),
(6137, 3545, 'perc', 40),
(6139, 881, 'felvonás', 1),
(6140, 2491, 'ig', 12),
(6143, 756, 'perc', 115),
(6144, 5445, 'felvonás', 1),
(6146, 2778, 'ig', 10),
(6148, 5200, 'tol', 10),
(6149, 5286, 'felvonás', 2),
(6150, 2940, 'felvonás', 1),
(6152, 3813, 'tol', 5),
(6154, 2825, 'tol', 3),
(6155, 4497, 'tol', 18),
(6156, 2170, 'felvonás', 2),
(6157, 4685, 'ig', 14),
(6158, 382, 'felvonás', 2),
(6161, 4339, 'tol', 6),
(6162, 2304, 'tol', 12),
(6163, 5167, 'perc', 90),
(6165, 3860, 'felvonás', 3),
(6166, 3394, 'perc', 110),
(6169, 1097, 'felvonás', 2),
(6174, 2250, 'tol', 4),
(6175, 921, 'tol', 12),
(6179, 4959, 'felvonás', 1),
(6180, 4775, 'felvonás', 3),
(6182, 697, 'perc', 45),
(6186, 2122, 'ig', 14),
(6187, 3982, 'felvonás', 1),
(6188, 3463, 'felvonás', 2),
(6190, 5597, 'tol', 4),
(6191, 2986, 'ig', 99),
(6194, 5684, 'ig', 14),
(6196, 826, 'tol', 3),
(6197, 4181, 'felvonás', 2),
(6198, 5539, 'ig', 10),
(6199, 781, 'perc', 165),
(6200, 5840, 'ig', 99),
(6204, 3853, 'perc', 65),
(6205, 5061, 'felvonás', 1),
(6207, 1330, 'perc', 50),
(6208, 5665, 'felvonás', 1),
(6211, 520, 'tol', 6),
(6214, 4018, 'tol', 5),
(6215, 919, 'tol', 16),
(6216, 5351, 'perc', 150),
(6217, 1614, 'ig', 14),
(6219, 2128, 'perc', 100),
(6222, 3521, 'ig', 3),
(6223, 3386, 'perc', 110),
(6224, 2222, 'felvonás', 2),
(6226, 660, 'tol', 3),
(6227, 1118, 'tol', 3),
(6228, 2482, 'felvonás', 2),
(6229, 5855, 'perc', 90),
(6230, 1056, 'felvonás', 3),
(6231, 1305, 'tol', 4),
(6233, 4706, 'tol', 4),
(6236, 3364, 'ig', 99),
(6238, 4391, 'felvonás', 2),
(6239, 980, 'tol', 3),
(6240, 790, 'felvonás', 1),
(6242, 3114, 'ig', 99),
(6244, 2989, 'tol', 16),
(6246, 5881, 'tol', 3),
(6247, 513, 'perc', 180),
(6249, 4144, 'tol', 3),
(6250, 1993, 'perc', 90),
(6251, 4404, 'ig', 3),
(6254, 294, 'felvonás', 2),
(6255, 4939, 'ig', 99),
(6259, 3145, 'perc', 50),
(6261, 1910, 'ig', 99),
(6264, 230, 'tol', 2),
(6266, 3518, 'ig', 14),
(6268, 1874, 'felvonás', 1),
(6271, 5855, 'tol', 14),
(6272, 921, 'ig', 99),
(6273, 4163, 'tol', 4),
(6274, 3742, 'perc', 210),
(6275, 318, 'ig', 99),
(6276, 3931, 'felvonás', 2),
(6277, 3957, 'tol', 3),
(6278, 5243, 'felvonás', 1),
(6279, 5367, 'felvonás', 1),
(6280, 5381, 'felvonás', 3),
(6282, 4322, 'felvonás', 2),
(6283, 5762, 'ig', 14),
(6285, 3398, 'ig', 14),
(6287, 1025, 'perc', 50),
(6289, 2758, 'tol', 3),
(6291, 5449, 'ig', 3),
(6296, 4643, 'felvonás', 1),
(6297, 2781, 'felvonás', 1),
(6300, 3310, 'felvonás', 1),
(6302, 227, 'felvonás', 2),
(6306, 4210, 'tol', 10),
(6308, 5178, 'felvonás', 2),
(6312, 4608, 'tol', 6),
(6314, 1135, 'ig', 14),
(6315, 1642, 'ig', 99),
(6318, 341, 'tol', 6),
(6319, 1589, 'tol', 10),
(6320, 3573, 'perc', 90),
(6321, 483, 'tol', 1),
(6324, 1349, 'felvonás', 2),
(6328, 460, 'felvonás', 2),
(6329, 25, 'felvonás', 2),
(6330, 4980, 'perc', 50),
(6331, 3209, 'perc', 100),
(6336, 4509, 'tol', 14),
(6338, 3489, 'tol', 16),
(6341, 4551, 'ig', 99),
(6342, 1053, 'perc', 170),
(6343, 4873, 'perc', 140),
(6344, 3310, 'perc', 100),
(6345, 5193, 'ig', 99),
(6347, 1348, 'tol', 4),
(6353, 4142, 'ig', 6),
(6354, 1515, 'tol', 2),
(6355, 4147, 'felvonás', 1),
(6357, 985, 'perc', 51),
(6361, 1237, 'ig', 3),
(6362, 2051, 'felvonás', 1),
(6365, 376, 'felvonás', 2),
(6366, 2284, 'ig', 12),
(6367, 5059, 'felvonás', 3),
(6368, 4818, 'felvonás', 2),
(6371, 1726, 'perc', 140),
(6372, 5236, 'ig', 99),
(6376, 4041, 'tol', 16),
(6377, 409, 'ig', 18),
(6378, 35, 'ig', 99),
(6379, 3782, 'tol', 3),
(6381, 3498, 'felvonás', 2),
(6384, 1376, 'felvonás', 2),
(6386, 1811, 'tol', 10),
(6387, 1654, 'felvonás', 2),
(6388, 4947, 'perc', 80),
(6389, 4971, 'tol', 6),
(6391, 1944, 'ig', 99),
(6393, 5122, 'felvonás', 2),
(6395, 4823, 'tol', 10),
(6396, 497, 'tol', 18),
(6397, 5312, 'ig', 99),
(6399, 4687, 'ig', 99),
(6400, 1506, 'felvonás', 1),
(6403, 2597, 'tol', 5),
(6406, 3815, 'perc', 75),
(6407, 1661, 'tol', 3),
(6408, 5274, 'tol', 5),
(6411, 1984, 'ig', 99),
(6412, 4909, 'ig', 99),
(6413, 811, 'perc', 130),
(6415, 1509, 'tol', 3),
(6416, 1406, 'felvonás', 1),
(6417, 3781, 'felvonás', 1),
(6418, 1450, 'tol', 3),
(6419, 5042, 'ig', 10),
(6421, 828, 'felvonás', 2),
(6422, 1208, 'ig', 14),
(6423, 976, 'felvonás', 2),
(6424, 2402, 'perc', 80),
(6426, 3127, 'ig', 12),
(6427, 3313, 'ig', 16),
(6428, 4702, 'felvonás', 2),
(6429, 4420, 'ig', 99),
(6434, 1614, 'tol', 3),
(6435, 3047, 'perc', 200),
(6438, 4429, 'tol', 12),
(6439, 3897, 'tol', 6),
(6441, 5493, 'tol', 4),
(6442, 3863, 'perc', 90),
(6444, 2681, 'ig', 14),
(6445, 1965, 'ig', 10),
(6450, 2149, 'ig', 3),
(6451, 5263, 'perc', 90),
(6453, 859, 'tol', 4),
(6454, 2049, 'perc', 60),
(6455, 3223, 'ig', 12),
(6457, 5768, 'perc', 55),
(6459, 1720, 'felvonás', 2),
(6464, 2037, 'tol', 5),
(6466, 3674, 'felvonás', 2),
(6467, 3751, 'ig', 12),
(6468, 3649, 'ig', 12),
(6470, 3411, 'ig', 99),
(6473, 5748, 'ig', 15),
(6474, 5680, 'ig', 10),
(6475, 1385, 'ig', 12),
(6477, 2917, 'tol', 4),
(6479, 5425, 'felvonás', 2),
(6481, 5088, 'felvonás', 2),
(6482, 3733, 'felvonás', 2),
(6483, 345, 'tol', 3),
(6484, 1860, 'tol', 6),
(6487, 1575, 'felvonás', 2),
(6488, 111, 'tol', 14),
(6491, 3843, 'tol', 18),
(6493, 503, 'tol', 18),
(6495, 1438, 'perc', 90),
(6496, 1267, 'tol', 6),
(6497, 1330, 'felvonás', 1),
(6498, 3824, 'perc', 87),
(6499, 606, 'ig', 14),
(6500, 2299, 'felvonás', 3),
(6508, 2553, 'felvonás', 1),
(6510, 164, 'felvonás', 3),
(6511, 2743, 'tol', 6),
(6515, 868, 'felvonás', 2),
(6519, 4954, 'tol', 1),
(6522, 4110, 'felvonás', 1),
(6523, 5193, 'tol', 3),
(6525, 145, 'perc', 90),
(6526, 4628, 'felvonás', 1),
(6528, 178, 'ig', 10),
(6529, 3951, 'tol', 16),
(6533, 2111, 'tol', 13),
(6534, 5341, 'tol', 6),
(6535, 2235, 'tol', 3),
(6538, 244, 'tol', 11),
(6543, 1454, 'ig', 14),
(6545, 2899, 'tol', 10),
(6546, 2190, 'perc', 45),
(6548, 5713, 'perc', 165),
(6549, 2161, 'tol', 3),
(6551, 1112, 'tol', 5),
(6552, 2138, 'tol', 1),
(6553, 4507, 'tol', 12),
(6556, 54, 'felvonás', 1),
(6557, 3233, 'felvonás', 3),
(6558, 1813, 'ig', 104),
(6560, 2735, 'tol', 6),
(6562, 1978, 'felvonás', 2),
(6563, 5557, 'perc', 60),
(6565, 88, 'felvonás', 1),
(6566, 1093, 'felvonás', 1),
(6568, 839, 'perc', 90),
(6569, 5895, 'perc', 140),
(6570, 239, 'ig', 10),
(6571, 4654, 'perc', 45),
(6572, 4509, 'ig', 99),
(6573, 253, 'tol', 3),
(6575, 1065, 'tol', 1),
(6576, 1050, 'ig', 14),
(6577, 2867, 'ig', 99),
(6578, 765, 'ig', 99),
(6579, 376, 'perc', 135),
(6580, 4738, 'tol', 4),
(6582, 4841, 'perc', 30),
(6585, 3852, 'felvonás', 1),
(6586, 3441, 'ig', 99),
(6593, 5807, 'tol', 3),
(6598, 3620, 'ig', 99),
(6599, 2751, 'tol', 3),
(6600, 5300, 'tol', 10),
(6604, 3192, 'tol', 6),
(6605, 3190, 'ig', 12),
(6606, 2764, 'tol', 3),
(6607, 5058, 'tol', 6),
(6610, 4008, 'ig', 14),
(6611, 2381, 'felvonás', 2),
(6614, 4478, 'felvonás', 3),
(6615, 5703, 'tol', 1),
(6619, 1769, 'tol', 3),
(6620, 850, 'tol', 4),
(6624, 5403, 'perc', 140),
(6626, 1594, 'ig', 10),
(6628, 1952, 'ig', 99),
(6629, 1283, 'felvonás', 2),
(6631, 3483, 'perc', 56),
(6632, 4380, 'tol', 14),
(6633, 1775, 'felvonás', 1),
(6636, 348, 'felvonás', 2),
(6637, 1633, 'felvonás', 3),
(6638, 4797, 'felvonás', 2),
(6640, 1274, 'felvonás', 2),
(6641, 55, 'tol', 6),
(6643, 4341, 'tol', 10),
(6644, 1402, 'felvonás', 2),
(6645, 4088, 'perc', 75),
(6646, 509, 'tol', 12),
(6648, 5089, 'felvonás', 1),
(6650, 2276, 'felvonás', 2),
(6651, 2092, 'perc', 100),
(6652, 4271, 'perc', 170),
(6654, 1297, 'felvonás', 2),
(6656, 2947, 'perc', 130),
(6659, 179, 'tol', 4),
(6660, 364, 'felvonás', 1),
(6661, 5633, 'felvonás', 2),
(6662, 2562, 'tol', 3),
(6664, 2764, 'ig', 10),
(6665, 3072, 'ig', 130),
(6666, 3614, 'tol', 18),
(6668, 3452, 'tol', 3),
(6669, 5053, 'perc', 50),
(6671, 5156, 'tol', 3),
(6678, 3619, 'felvonás', 2),
(6679, 4465, 'tol', 6),
(6680, 4729, 'perc', 50),
(6681, 2123, 'tol', 3),
(6682, 1819, 'tol', 4),
(6684, 4306, 'felvonás', 2),
(6685, 3460, 'perc', 135),
(6686, 1965, 'tol', 3),
(6688, 714, 'perc', 90),
(6689, 5392, 'ig', 10),
(6691, 1798, 'ig', 99),
(6693, 3373, 'tol', 6),
(6694, 4215, 'tol', 4),
(6697, 1135, 'tol', 6),
(6700, 2070, 'tol', 10),
(6702, 4815, 'perc', 20),
(6708, 2490, 'perc', 90),
(6710, 1704, 'felvonás', 3),
(6717, 1106, 'tol', 5),
(6718, 3873, 'ig', 12),
(6720, 4403, 'tol', 3),
(6723, 3358, 'felvonás', 2),
(6724, 5888, 'tol', 10),
(6729, 1465, 'perc', 50),
(6730, 2927, 'tol', 6),
(6733, 318, 'tol', 6),
(6735, 2674, 'felvonás', 2),
(6736, 4185, 'felvonás', 2),
(6737, 294, 'tol', 16),
(6739, 1642, 'tol', 5),
(6740, 1237, 'tol', 1),
(6741, 1112, 'ig', 14),
(6743, 4508, 'felvonás', 2),
(6746, 4141, 'felvonás', 2),
(6752, 5852, 'ig', 14),
(6754, 3601, 'felvonás', 1),
(6755, 5109, 'tol', 3),
(6757, 2739, 'felvonás', 2),
(6759, 3528, 'perc', 60),
(6762, 2547, 'ig', 99),
(6764, 3182, 'tol', 5),
(6766, 1619, 'felvonás', 2),
(6767, 451, 'ig', 99),
(6770, 4900, 'tol', 3),
(6771, 718, 'ig', 99),
(6772, 4078, 'ig', 3),
(6773, 591, 'perc', 90),
(6777, 2362, 'tol', 6),
(6778, 1803, 'tol', 3),
(6779, 2643, 'tol', 6),
(6780, 5116, 'tol', 18),
(6781, 2781, 'perc', 80),
(6782, 4532, 'felvonás', 2),
(6784, 4114, 'felvonás', 2),
(6785, 3516, 'tol', 6),
(6787, 4743, 'tol', 3),
(6788, 5856, 'tol', 12),
(6789, 2816, 'perc', 50),
(6790, 4186, 'felvonás', 3),
(6791, 1937, 'felvonás', 2),
(6794, 1342, 'perc', 25),
(6795, 72, 'perc', 70),
(6796, 3611, 'tol', 12),
(6797, 2964, 'tol', 9),
(6798, 1469, 'felvonás', 1),
(6799, 189, 'tol', 8),
(6800, 5554, 'ig', 10),
(6801, 528, 'ig', 12),
(6802, 1879, 'perc', 55),
(6803, 3848, 'ig', 14),
(6804, 711, 'tol', 3),
(6805, 2397, 'tol', 3),
(6806, 3176, 'felvonás', 1),
(6810, 2541, 'tol', 12),
(6811, 2965, 'perc', 105),
(6812, 3776, 'perc', 85),
(6813, 1960, 'ig', 99),
(6815, 5684, 'perc', 70),
(6816, 3962, 'perc', 60),
(6817, 1405, 'felvonás', 1),
(6818, 303, 'perc', 90),
(6819, 1599, 'ig', 99),
(6821, 2525, 'ig', 10),
(6823, 744, 'felvonás', 2),
(6824, 5090, 'ig', 12),
(6825, 4709, 'tol', 10),
(6828, 1741, 'tol', 6),
(6829, 3145, 'tol', 3),
(6830, 3124, 'tol', 4),
(6833, 3143, 'ig', 14),
(6834, 3956, 'tol', 6),
(6836, 4716, 'perc', 140),
(6838, 4426, 'felvonás', 3),
(6839, 1939, 'tol', 3),
(6840, 2070, 'perc', 45),
(6841, 3162, 'tol', 4),
(6852, 3417, 'felvonás', 2),
(6854, 268, 'felvonás', 1),
(6856, 3324, 'felvonás', 2),
(6857, 1447, 'felvonás', 1),
(6859, 3521, 'tol', 1),
(6860, 4157, 'felvonás', 2),
(6862, 1171, 'felvonás', 2),
(6864, 2121, 'tol', 4),
(6867, 2826, 'perc', 50),
(6869, 4587, 'felvonás', 3),
(6874, 4215, 'ig', 99),
(6876, 189, 'ig', 10),
(6877, 3309, 'felvonás', 3),
(6878, 3938, 'tol', 6),
(6879, 1727, 'ig', 16),
(6880, 4911, 'perc', 80),
(6886, 1325, 'felvonás', 2),
(6889, 4210, 'felvonás', 2),
(6890, 4620, 'ig', 99),
(6891, 364, 'tol', 14),
(6892, 456, 'felvonás', 1),
(6895, 1221, 'ig', 14),
(6899, 3130, 'ig', 99),
(6900, 449, 'tol', 14),
(6904, 613, 'ig', 99),
(6905, 65, 'tol', 18),
(6906, 765, 'felvonás', 2),
(6911, 3024, 'felvonás', 2),
(6913, 1531, 'ig', 14),
(6915, 2165, 'tol', 15),
(6917, 1482, 'tol', 14),
(6918, 1567, 'felvonás', 2),
(6919, 347, 'tol', 16),
(6920, 3792, 'tol', 5),
(6921, 627, 'ig', 99),
(6924, 2420, 'ig', 10),
(6926, 2880, 'ig', 10),
(6927, 4287, 'tol', 3),
(6929, 402, 'ig', 14),
(6930, 1830, 'felvonás', 2),
(6931, 3847, 'felvonás', 2),
(6932, 5416, 'ig', 14),
(6933, 1695, 'tol', 6),
(6934, 3182, 'felvonás', 2),
(6937, 2032, 'tol', 3),
(6940, 3577, 'felvonás', 2),
(6943, 5815, 'felvonás', 2),
(6944, 5006, 'perc', 100),
(6945, 1988, 'felvonás', 1),
(6946, 4644, 'felvonás', 2),
(6947, 4967, 'tol', 6),
(6948, 2205, 'felvonás', 2),
(6949, 5171, 'perc', 200),
(6950, 2583, 'tol', 16),
(6951, 1377, 'perc', 80),
(6952, 5, 'tol', 3),
(6953, 2171, 'ig', 12),
(6955, 3567, 'ig', 12),
(6958, 4880, 'ig', 12),
(6962, 732, 'tol', 6),
(6967, 3178, 'tol', 16),
(6968, 2020, 'tol', 16),
(6973, 5407, 'tol', 3),
(6976, 3030, 'tol', 16),
(6977, 834, 'felvonás', 4),
(6978, 4055, 'ig', 14),
(6979, 4338, 'felvonás', 2),
(6980, 4471, 'tol', 16),
(6981, 3179, 'tol', 3),
(6982, 2141, 'felvonás', 2),
(6983, 450, 'felvonás', 2),
(6984, 2583, 'felvonás', 3),
(6985, 3388, 'felvonás', 2),
(6988, 3522, 'tol', 2),
(6989, 4412, 'perc', 100),
(6990, 5140, 'ig', 12),
(6991, 3073, 'ig', 16),
(6992, 4835, 'ig', 99),
(6994, 1994, 'ig', 99),
(6995, 573, 'ig', 99),
(6996, 1551, 'felvonás', 2),
(6998, 5733, 'tol', 16),
(6999, 1660, 'ig', 14),
(7000, 863, 'tol', 3),
(7001, 1635, 'tol', 6),
(7002, 2053, 'ig', 99),
(7003, 265, 'perc', 200),
(7004, 2583, 'ig', 99),
(7005, 3932, 'tol', 6),
(7008, 5221, 'felvonás', 2),
(7010, 2823, 'felvonás', 2),
(7012, 2318, 'felvonás', 2),
(7016, 2984, 'ig', 99),
(7017, 2453, 'perc', 60),
(7018, 5556, 'tol', 16),
(7019, 3294, 'perc', 45),
(7020, 5393, 'ig', 10),
(7021, 4705, 'perc', 60),
(7024, 1840, 'felvonás', 4),
(7025, 4429, 'ig', 99),
(7029, 509, 'ig', 99),
(7030, 1986, 'tol', 6),
(7032, 3735, 'felvonás', 2),
(7033, 4328, 'ig', 12),
(7038, 2564, 'felvonás', 2),
(7041, 3679, 'felvonás', 2),
(7043, 2695, 'tol', 3),
(7044, 4295, 'tol', 6),
(7045, 5156, 'ig', 10),
(7047, 3801, 'tol', 12),
(7049, 4573, 'ig', 99),
(7050, 4131, 'ig', 3),
(7051, 4362, 'perc', 60),
(7054, 3567, 'tol', 6),
(7057, 3031, 'felvonás', 3),
(7058, 5461, 'tol', 3),
(7059, 3476, 'perc', 20),
(7060, 1408, 'ig', 99),
(7061, 1477, 'felvonás', 2),
(7063, 392, 'felvonás', 3),
(7064, 4365, 'ig', 10),
(7067, 5316, 'tol', 4),
(7068, 1317, 'felvonás', 2),
(7071, 3120, 'felvonás', 4),
(7074, 2984, 'tol', 6),
(7075, 5644, 'perc', 50),
(7076, 1604, 'tol', 16),
(7080, 4993, 'tol', 3),
(7083, 3947, 'tol', 6),
(7085, 4314, 'tol', 3),
(7087, 4232, 'tol', 16),
(7088, 5352, 'tol', 12),
(7089, 2696, 'perc', 75),
(7091, 5141, 'felvonás', 2),
(7094, 5385, 'felvonás', 2),
(7095, 3737, 'ig', 14);


ALTER TABLE `eloadas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `szinhazid` (`szinhazid`);

ALTER TABLE `szinhaz`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `tulajdonsag`
  ADD PRIMARY KEY (`id`),
  ADD KEY `eloadasid` (`eloadasid`);


ALTER TABLE `eloadas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5904;

ALTER TABLE `szinhaz`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=204;

ALTER TABLE `tulajdonsag`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7096;


ALTER TABLE `eloadas`
  ADD CONSTRAINT `eloadas_ibfk_1` FOREIGN KEY (`szinhazid`) REFERENCES `szinhaz` (`id`);

ALTER TABLE `tulajdonsag`
  ADD CONSTRAINT `tulajdonsag_ibfk_1` FOREIGN KEY (`eloadasid`) REFERENCES `eloadas` (`id`);
COMMIT;
