CREATE DATABASE IF NOT EXISTS `kulturtortenet` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_hungarian_ci;
USE `kulturtortenet`;

CREATE TABLE `csapat` (
  `id` int(11) NOT NULL,
  `nev` varchar(30) COLLATE utf8mb4_hungarian_ci NOT NULL,
  `tagszam` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_hungarian_ci;

INSERT INTO `csapat` (`id`, `nev`, `tagszam`) VALUES
(1, 'Királyok', 4),
(2, 'Nyerő Páros', 2),
(3, 'Anonymous', 3),
(4, 'Visegrád', 3),
(5, 'Kolozsi', 5),
(6, 'Pecások', 3),
(7, 'Dobozoló', 4),
(8, '#unboxing', 5),
(9, 'Vuvuzela', 3),
(10, 'Tom&Tom', 2),
(11, '#win', 4),
(12, 'STG', 3),
(13, 'Keri', 3);

CREATE TABLE `feladat` (
  `id` int(11) NOT NULL,
  `feladatsorid` int(11) NOT NULL,
  `pontszam` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_hungarian_ci;

INSERT INTO `feladat` (`id`, `feladatsorid`, `pontszam`) VALUES
(1, 6, 30),
(2, 15, 15),
(3, 7, 15),
(4, 9, 15),
(5, 2, 20),
(6, 6, 30),
(7, 1, 15),
(8, 8, 25),
(9, 15, 40),
(10, 5, 20),
(11, 15, 30),
(12, 8, 20),
(13, 9, 40),
(14, 4, 35),
(15, 10, 35),
(16, 8, 25),
(17, 12, 25),
(18, 9, 25),
(19, 2, 25),
(20, 9, 20),
(21, 4, 35),
(22, 14, 30),
(23, 13, 30),
(24, 5, 30),
(25, 11, 25),
(26, 12, 25),
(27, 12, 20),
(28, 11, 35),
(29, 1, 30),
(30, 3, 15),
(31, 5, 30),
(32, 3, 20),
(33, 12, 40),
(34, 10, 25),
(35, 10, 25),
(36, 6, 20),
(37, 7, 40),
(38, 12, 20),
(39, 6, 25),
(40, 9, 20),
(41, 14, 30),
(42, 5, 30),
(43, 2, 15),
(44, 3, 40),
(45, 14, 15),
(46, 2, 35),
(47, 7, 35),
(48, 3, 30),
(49, 10, 25),
(50, 7, 15),
(51, 8, 15),
(52, 14, 15),
(53, 8, 30),
(54, 4, 15),
(55, 7, 30),
(56, 13, 15),
(57, 10, 15),
(58, 6, 15),
(59, 14, 30),
(60, 1, 25),
(61, 11, 25),
(62, 5, 25),
(63, 13, 25),
(64, 1, 40),
(65, 15, 25),
(66, 8, 35),
(67, 1, 15),
(68, 9, 30),
(69, 15, 25),
(70, 4, 25),
(71, 6, 30),
(72, 11, 15),
(73, 7, 15),
(74, 3, 20),
(75, 13, 20),
(76, 5, 15),
(77, 2, 35),
(78, 11, 30),
(79, 15, 15),
(80, 10, 25),
(81, 2, 20),
(82, 1, 25),
(83, 11, 20),
(84, 12, 15),
(85, 14, 30),
(86, 3, 25),
(87, 13, 40),
(88, 4, 25),
(89, 13, 20);

CREATE TABLE `feladatsor` (
  `id` int(11) NOT NULL,
  `nevado` varchar(40) COLLATE utf8mb4_hungarian_ci NOT NULL,
  `ag` varchar(20) COLLATE utf8mb4_hungarian_ci NOT NULL,
  `kituzes` date NOT NULL,
  `hatarido` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_hungarian_ci;

INSERT INTO `feladatsor` (`id`, `nevado`, `ag`, `kituzes`, `hatarido`) VALUES
(1, 'Ybl Miklós', 'építőművészet', '2018-09-06', '2018-09-24'),
(2, 'Bartók Béla', 'zeneművészet', '2018-09-26', '2018-10-12'),
(3, 'Karinthy Frigyes', 'irodalom', '2018-10-15', '2018-10-26'),
(4, 'Vasarely', 'képzőművészet', '2018-10-29', '2018-11-14'),
(5, 'Molnár Ferenc', 'irodalom', '2018-11-17', '2018-12-04'),
(6, 'Mikszáth Kálmán', 'irodalom', '2018-12-09', '2018-12-27'),
(7, 'Munkácsy Mihály', 'képzőművészet', '2018-12-29', '2019-01-18'),
(8, 'Szabó István', 'filmművészet', '2019-01-19', '2019-02-06'),
(9, 'Borsos Miklós', 'képzőművészet', '2019-02-08', '2019-02-27'),
(10, 'Várkonyi Zoltán', 'filmművészet', '2019-03-02', '2019-03-21'),
(11, 'Jókai Mór', 'irodalom', '2019-03-24', '2019-04-15'),
(12, 'Kodály Zoltán', 'zeneművészet', '2019-04-17', '2019-04-30'),
(13, 'Csontváry Kosztka Tivadar', 'képzőművészet', '2019-05-03', '2019-05-15'),
(14, 'Lechner Ödön', 'építőművészet', '2019-05-18', '2019-06-04'),
(15, 'Liszt Ferenc', 'zeneművészet', '2019-06-08', '2019-06-24');

CREATE TABLE `megoldas` (
  `id` int(11) NOT NULL,
  `feladatid` int(11) NOT NULL,
  `csapatid` int(11) NOT NULL,
  `datum` date NOT NULL,
  `pontszam` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_hungarian_ci;

INSERT INTO `megoldas` (`id`, `feladatid`, `csapatid`, `datum`, `pontszam`) VALUES
(1, 79, 11, '2019-06-13', 16),
(2, 83, 13, '2019-04-05', 1),
(3, 3, 2, '2019-01-04', 15),
(4, 67, 13, '2018-09-15', 16),
(5, 77, 5, '2018-10-02', 15),
(6, 73, 4, '2019-01-01', 15),
(7, 36, 6, '2018-12-27', 17),
(8, 22, 3, '2019-05-28', 14),
(9, 77, 2, '2018-10-03', 15),
(10, 70, 2, '2018-11-14', 9),
(11, 23, 2, '2019-05-11', 40),
(12, 46, 12, '2018-10-11', 1),
(13, 38, 3, '2019-04-30', 2),
(14, 87, 9, '2019-05-10', 24),
(15, 55, 2, '2019-01-13', 15),
(16, 55, 10, '2019-01-13', 15),
(17, 41, 4, '2019-05-25', 35),
(18, 6, 1, '2018-12-11', 3),
(19, 24, 8, '2018-11-18', 20),
(20, 9, 6, '2019-06-19', 35),
(21, 27, 7, '2019-04-24', 16),
(22, 69, 3, '2019-06-20', 11),
(23, 36, 1, '2018-12-17', 30),
(24, 45, 8, '2019-06-02', 3),
(25, 26, 3, '2019-04-27', 17),
(26, 51, 10, '2019-02-04', 1),
(27, 18, 10, '2019-02-19', 2),
(28, 23, 13, '2019-05-12', 40),
(29, 80, 10, '2019-03-14', 20),
(30, 16, 2, '2019-01-20', 25),
(31, 80, 11, '2019-03-20', 20),
(32, 10, 12, '2018-11-26', 20),
(33, 60, 1, '2018-09-13', 16),
(34, 43, 13, '2018-10-03', 9),
(35, 89, 7, '2019-05-09', 4),
(36, 17, 12, '2019-04-30', 18),
(37, 88, 13, '2018-11-11', 5),
(38, 6, 6, '2018-12-18', 5),
(39, 14, 6, '2018-11-02', 12),
(40, 70, 12, '2018-11-07', 13),
(41, 63, 8, '2019-05-15', 40),
(42, 46, 5, '2018-09-27', 13),
(43, 74, 11, '2018-10-20', 0),
(44, 81, 4, '2018-10-02', 15),
(45, 15, 5, '2019-03-20', 7),
(46, 86, 4, '2018-10-27', 15),
(47, 2, 1, '2019-06-24', 21),
(48, 49, 4, '2019-03-06', 2),
(49, 15, 6, '2019-03-21', 11),
(50, 2, 11, '2019-06-15', 25),
(51, 81, 5, '2018-10-06', 1),
(52, 27, 6, '2019-04-23', 19),
(53, 61, 4, '2019-04-01', 30),
(54, 9, 11, '2019-06-23', 35),
(55, 36, 11, '2018-12-13', 4),
(56, 64, 3, '2018-09-14', 0),
(57, 52, 10, '2019-05-24', 35),
(58, 62, 6, '2018-12-03', 3),
(59, 23, 5, '2019-05-15', 4),
(60, 49, 13, '2019-03-14', 9),
(61, 41, 13, '2019-06-03', 0),
(62, 32, 7, '2018-10-22', 10),
(63, 78, 8, '2019-04-09', 2),
(64, 53, 7, '2019-02-01', 25),
(65, 88, 6, '2018-11-12', 11),
(66, 33, 5, '2019-04-29', 16),
(67, 74, 7, '2018-10-17', 15),
(68, 4, 13, '2019-02-18', 31),
(69, 60, 10, '2018-09-14', 13),
(70, 75, 2, '2019-05-14', 16),
(71, 71, 4, '2018-12-20', 29),
(72, 43, 11, '2018-10-07', 8),
(73, 70, 8, '2018-11-08', 15),
(74, 55, 9, '2019-01-15', 15),
(75, 33, 6, '2019-04-24', 15),
(76, 25, 12, '2019-03-29', 22),
(77, 27, 1, '2019-04-26', 20),
(78, 2, 5, '2019-06-20', 25),
(79, 37, 6, '2019-01-11', 5),
(80, 25, 4, '2019-04-10', 22),
(81, 1, 5, '2018-12-20', 25),
(82, 67, 6, '2018-09-18', 27),
(83, 70, 5, '2018-11-02', 5),
(84, 40, 2, '2019-02-27', 12),
(85, 45, 10, '2019-06-01', 35),
(86, 29, 3, '2018-09-23', 30),
(87, 22, 8, '2019-05-21', 29),
(88, 26, 13, '2019-04-26', 20),
(89, 81, 12, '2018-10-03', 9),
(90, 74, 5, '2018-10-22', 7),
(91, 77, 6, '2018-10-01', 15),
(92, 17, 7, '2019-04-22', 8),
(93, 39, 3, '2018-12-24', 30),
(94, 60, 4, '2018-09-13', 11),
(95, 15, 13, '2019-03-21', 20),
(96, 3, 9, '2019-01-09', 15),
(97, 72, 13, '2019-04-02', 19),
(98, 48, 2, '2018-10-24', 13),
(99, 61, 3, '2019-03-29', 5),
(100, 2, 4, '2019-06-12', 35),
(101, 8, 8, '2019-01-24', 20),
(102, 12, 4, '2019-01-25', 14),
(103, 17, 6, '2019-04-30', 14),
(104, 17, 4, '2019-04-22', 0),
(105, 88, 3, '2018-11-13', 8),
(106, 89, 13, '2019-05-12', 23),
(107, 47, 9, '2019-01-03', 15),
(108, 79, 10, '2019-06-17', 35),
(109, 20, 8, '2019-02-13', 37),
(110, 28, 5, '2019-04-01', 30),
(111, 85, 9, '2019-06-01', 35),
(112, 47, 1, '2019-01-16', 2),
(113, 50, 11, '2019-01-17', 7),
(114, 51, 5, '2019-01-22', 21),
(115, 88, 1, '2018-11-11', 15),
(116, 20, 1, '2019-02-18', 2),
(117, 5, 1, '2018-10-07', 15),
(118, 32, 2, '2018-10-25', 8),
(119, 71, 11, '2018-12-23', 3),
(120, 61, 1, '2019-04-02', 30),
(121, 20, 2, '2019-02-25', 16),
(122, 89, 6, '2019-05-08', 40),
(123, 25, 7, '2019-04-10', 20),
(124, 58, 1, '2018-12-17', 21),
(125, 51, 1, '2019-02-03', 25),
(126, 59, 9, '2019-05-25', 15),
(127, 11, 2, '2019-06-16', 35),
(128, 24, 12, '2018-11-20', 6),
(129, 74, 9, '2018-10-22', 12),
(130, 57, 2, '2019-03-11', 14),
(131, 13, 9, '2019-02-13', 22),
(132, 84, 2, '2019-04-29', 7),
(133, 77, 11, '2018-10-07', 14),
(134, 4, 9, '2019-02-27', 9),
(135, 69, 9, '2019-06-18', 35),
(136, 44, 8, '2018-10-22', 7),
(137, 18, 4, '2019-02-15', 7),
(138, 54, 9, '2018-11-03', 14),
(139, 32, 9, '2018-10-27', 15),
(140, 19, 10, '2018-10-10', 6),
(141, 52, 3, '2019-06-04', 13),
(142, 59, 3, '2019-05-25', 24),
(143, 9, 9, '2019-06-14', 32),
(144, 77, 4, '2018-10-09', 8),
(145, 7, 2, '2018-09-23', 18),
(146, 16, 6, '2019-01-31', 1),
(147, 34, 7, '2019-03-19', 8),
(148, 15, 12, '2019-03-18', 2),
(149, 34, 8, '2019-03-13', 11),
(150, 78, 6, '2019-04-10', 30),
(151, 49, 6, '2019-03-21', 17),
(152, 43, 1, '2018-09-27', 10),
(153, 33, 11, '2019-04-28', 19),
(154, 15, 11, '2019-03-15', 10),
(155, 42, 6, '2018-12-04', 19),
(156, 56, 7, '2019-05-08', 29),
(157, 16, 11, '2019-01-23', 10),
(158, 53, 1, '2019-01-21', 9),
(159, 9, 5, '2019-06-13', 34),
(160, 36, 9, '2018-12-22', 8),
(161, 50, 13, '2019-01-01', 15),
(162, 5, 7, '2018-10-02', 14),
(163, 83, 1, '2019-04-04', 2),
(164, 48, 12, '2018-10-24', 2),
(165, 80, 6, '2019-03-08', 20),
(166, 54, 3, '2018-11-01', 10),
(167, 24, 7, '2018-11-25', 20),
(168, 33, 10, '2019-04-30', 20),
(169, 69, 13, '2019-06-19', 20),
(170, 44, 11, '2018-10-24', 0),
(171, 44, 10, '2018-10-21', 15),
(172, 40, 4, '2019-02-19', 40),
(173, 61, 5, '2019-04-08', 28),
(174, 34, 9, '2019-03-15', 20),
(175, 68, 10, '2019-02-21', 20),
(176, 2, 10, '2019-06-21', 28),
(177, 79, 7, '2019-06-20', 31),
(178, 76, 8, '2018-12-01', 5),
(179, 3, 13, '2019-01-03', 0),
(180, 76, 6, '2018-11-22', 8),
(181, 5, 13, '2018-10-05', 13),
(182, 78, 9, '2019-04-03', 25),
(183, 39, 5, '2018-12-14', 23),
(184, 20, 6, '2019-02-25', 20),
(185, 31, 6, '2018-12-04', 20),
(186, 18, 9, '2019-02-21', 40),
(187, 72, 12, '2019-04-05', 9),
(188, 3, 10, '2019-01-01', 11),
(189, 69, 8, '2019-06-16', 33),
(190, 40, 7, '2019-02-18', 40),
(191, 8, 1, '2019-02-06', 20),
(192, 87, 4, '2019-05-10', 27),
(193, 63, 6, '2019-05-12', 40),
(194, 68, 7, '2019-02-27', 40),
(195, 38, 13, '2019-04-23', 20),
(196, 22, 9, '2019-06-01', 35),
(197, 59, 12, '2019-05-31', 7),
(198, 8, 9, '2019-01-30', 25),
(199, 37, 13, '2019-01-08', 6),
(200, 20, 5, '2019-02-21', 27),
(201, 12, 3, '2019-02-05', 22),
(202, 13, 10, '2019-02-20', 20),
(203, 33, 1, '2019-04-24', 20),
(204, 83, 11, '2019-03-26', 30),
(205, 54, 6, '2018-11-05', 7),
(206, 82, 6, '2018-09-18', 0),
(207, 31, 4, '2018-11-29', 20),
(208, 79, 5, '2019-06-21', 14),
(209, 74, 2, '2018-10-26', 0),
(210, 23, 3, '2019-05-08', 40),
(211, 63, 7, '2019-05-13', 31),
(212, 52, 5, '2019-05-25', 35),
(213, 7, 11, '2018-09-19', 19),
(214, 89, 4, '2019-05-14', 27),
(215, 71, 5, '2018-12-27', 4),
(216, 79, 8, '2019-06-17', 7),
(217, 79, 9, '2019-06-20', 6),
(218, 84, 5, '2019-04-27', 17),
(219, 62, 2, '2018-11-28', 5),
(220, 31, 8, '2018-12-03', 15),
(221, 16, 13, '2019-02-06', 24),
(222, 24, 2, '2018-11-23', 6),
(223, 61, 7, '2019-04-13', 30),
(224, 65, 6, '2019-06-20', 17),
(225, 55, 1, '2019-01-16', 7),
(226, 85, 2, '2019-05-31', 10),
(227, 11, 10, '2019-06-18', 35),
(228, 4, 7, '2019-02-26', 24),
(229, 29, 13, '2018-09-21', 5),
(230, 77, 8, '2018-10-11', 11),
(231, 10, 9, '2018-12-01', 20),
(232, 10, 8, '2018-11-19', 20),
(233, 19, 4, '2018-10-02', 10),
(234, 89, 8, '2019-05-12', 32),
(235, 32, 13, '2018-10-17', 15),
(236, 27, 9, '2019-04-28', 20),
(237, 51, 3, '2019-01-29', 4),
(238, 20, 10, '2019-02-27', 21),
(239, 53, 5, '2019-02-06', 7),
(240, 58, 7, '2018-12-22', 20),
(241, 62, 5, '2018-11-22', 20),
(242, 2, 13, '2019-06-19', 35),
(243, 86, 7, '2018-10-26', 15),
(244, 86, 12, '2018-10-22', 12),
(245, 12, 10, '2019-02-03', 7),
(246, 18, 3, '2019-02-24', 16),
(247, 81, 8, '2018-09-30', 12),
(248, 14, 8, '2018-11-14', 12),
(249, 75, 9, '2019-05-11', 37),
(250, 53, 8, '2019-02-01', 2),
(251, 50, 10, '2019-01-11', 7),
(252, 41, 7, '2019-05-21', 35),
(253, 31, 1, '2018-12-04', 20),
(254, 65, 2, '2019-06-18', 4),
(255, 71, 1, '2018-12-26', 24),
(256, 4, 11, '2019-02-22', 17),
(257, 77, 13, '2018-10-01', 13),
(258, 11, 6, '2019-06-22', 26),
(259, 11, 12, '2019-06-21', 9),
(260, 26, 8, '2019-04-28', 18),
(261, 20, 4, '2019-02-13', 40),
(262, 53, 2, '2019-01-25', 25),
(263, 56, 3, '2019-05-12', 14),
(264, 81, 13, '2018-10-10', 10),
(265, 19, 12, '2018-10-02', 1),
(266, 35, 1, '2019-03-13', 9),
(267, 84, 8, '2019-04-20', 11),
(268, 89, 9, '2019-05-13', 40),
(269, 7, 1, '2018-09-21', 8),
(270, 72, 11, '2019-03-31', 3),
(271, 70, 1, '2018-10-31', 5),
(272, 47, 11, '2019-01-18', 15),
(273, 7, 3, '2018-09-18', 26),
(274, 36, 8, '2018-12-27', 1),
(275, 64, 13, '2018-09-23', 30),
(276, 62, 9, '2018-11-22', 5),
(277, 29, 7, '2018-09-19', 28),
(278, 53, 13, '2019-01-28', 3),
(279, 38, 10, '2019-04-19', 17),
(280, 49, 9, '2019-03-14', 20),
(281, 51, 6, '2019-01-26', 2),
(282, 26, 12, '2019-04-26', 6),
(283, 66, 4, '2019-02-04', 4),
(284, 5, 12, '2018-09-27', 10),
(285, 24, 4, '2018-11-24', 20),
(286, 63, 12, '2019-05-09', 10),
(287, 57, 5, '2019-03-15', 12),
(288, 42, 3, '2018-11-22', 16),
(289, 89, 5, '2019-05-13', 13),
(290, 64, 9, '2018-09-23', 17),
(291, 81, 9, '2018-10-01', 15),
(292, 43, 2, '2018-10-10', 13),
(293, 27, 13, '2019-04-24', 4),
(294, 45, 11, '2019-05-30', 2),
(295, 68, 3, '2019-02-19', 40),
(296, 12, 2, '2019-01-31', 0),
(297, 12, 8, '2019-01-29', 25),
(298, 13, 7, '2019-02-20', 40),
(299, 55, 3, '2019-01-01', 10),
(300, 28, 4, '2019-04-04', 12),
(301, 28, 2, '2019-04-01', 30),
(302, 28, 9, '2019-04-10', 20),
(303, 33, 7, '2019-04-30', 20),
(304, 86, 3, '2018-10-23', 15),
(305, 83, 10, '2019-03-31', 30),
(306, 71, 6, '2018-12-17', 20),
(307, 21, 2, '2018-11-13', 6),
(308, 14, 10, '2018-11-04', 7),
(309, 73, 5, '2019-01-06', 14),
(310, 14, 4, '2018-11-03', 7),
(311, 61, 11, '2019-04-11', 30),
(312, 32, 10, '2018-10-25', 15),
(313, 39, 7, '2018-12-15', 17),
(314, 45, 3, '2019-05-24', 2),
(315, 77, 3, '2018-10-03', 10),
(316, 55, 5, '2019-01-10', 15),
(317, 53, 6, '2019-01-21', 20),
(318, 66, 9, '2019-01-29', 25),
(319, 55, 12, '2019-01-11', 10),
(320, 29, 11, '2018-09-14', 21),
(321, 15, 7, '2019-03-06', 5),
(322, 59, 11, '2019-05-28', 20),
(323, 54, 11, '2018-11-07', 11),
(324, 53, 3, '2019-02-06', 25),
(325, 44, 7, '2018-10-26', 12),
(326, 69, 5, '2019-06-24', 35),
(327, 82, 2, '2018-09-21', 13),
(328, 46, 10, '2018-10-10', 5),
(329, 69, 10, '2019-06-12', 35),
(330, 51, 8, '2019-01-24', 19),
(331, 82, 10, '2018-09-15', 4),
(332, 8, 7, '2019-01-26', 25),
(333, 28, 13, '2019-04-06', 8),
(334, 24, 13, '2018-11-29', 12),
(335, 21, 10, '2018-11-05', 13),
(336, 70, 10, '2018-11-09', 15),
(337, 32, 3, '2018-10-22', 12),
(338, 30, 2, '2018-10-18', 15),
(339, 10, 1, '2018-11-25', 18),
(340, 23, 7, '2019-05-10', 17),
(341, 30, 9, '2018-10-25', 6),
(342, 86, 13, '2018-10-26', 15),
(343, 78, 13, '2019-04-12', 30),
(344, 19, 5, '2018-10-11', 15),
(345, 72, 4, '2019-03-26', 17),
(346, 31, 13, '2018-12-04', 20),
(347, 40, 9, '2019-02-10', 0),
(348, 57, 11, '2019-03-19', 9),
(349, 37, 7, '2019-01-15', 7),
(350, 12, 5, '2019-02-03', 0),
(351, 38, 11, '2019-04-30', 7),
(352, 74, 13, '2018-10-19', 12),
(353, 5, 6, '2018-10-03', 15),
(354, 14, 2, '2018-11-01', 15),
(355, 60, 2, '2018-09-18', 30),
(356, 73, 13, '2019-01-16', 15),
(357, 18, 13, '2019-02-25', 33),
(358, 85, 7, '2019-05-22', 14),
(359, 69, 1, '2019-06-16', 12),
(360, 26, 10, '2019-04-23', 9),
(361, 69, 7, '2019-06-18', 35),
(362, 30, 7, '2018-10-25', 9),
(363, 46, 9, '2018-10-08', 15),
(364, 4, 8, '2019-02-21', 21),
(365, 17, 10, '2019-04-30', 11),
(366, 82, 12, '2018-09-23', 30),
(367, 68, 11, '2019-02-22', 40),
(368, 9, 3, '2019-06-17', 12),
(369, 5, 9, '2018-10-07', 15),
(370, 61, 10, '2019-03-28', 17),
(371, 24, 1, '2018-12-03', 8),
(372, 45, 2, '2019-05-31', 24),
(373, 87, 1, '2019-05-15', 9),
(374, 56, 10, '2019-05-15', 4),
(375, 79, 2, '2019-06-13', 29),
(376, 76, 1, '2018-11-20', 14),
(377, 32, 4, '2018-10-24', 15),
(378, 19, 8, '2018-10-04', 8),
(379, 65, 7, '2019-06-17', 29),
(380, 42, 10, '2018-11-23', 5),
(381, 12, 13, '2019-02-02', 25),
(382, 63, 13, '2019-05-08', 40),
(383, 9, 13, '2019-06-11', 18),
(384, 24, 11, '2018-11-25', 5),
(385, 19, 11, '2018-10-10', 7),
(386, 55, 4, '2019-01-15', 15),
(387, 13, 11, '2019-02-14', 18),
(388, 26, 9, '2019-04-28', 17),
(389, 84, 7, '2019-04-24', 20),
(390, 87, 2, '2019-05-08', 7),
(391, 71, 10, '2018-12-15', 29),
(392, 23, 4, '2019-05-15', 40),
(393, 83, 7, '2019-04-03', 11),
(394, 43, 9, '2018-10-03', 4),
(395, 26, 7, '2019-04-20', 11),
(396, 72, 6, '2019-03-25', 30),
(397, 37, 12, '2019-01-03', 15),
(398, 14, 3, '2018-11-03', 14),
(399, 15, 2, '2019-03-20', 17),
(400, 20, 3, '2019-02-21', 31),
(401, 29, 10, '2018-09-23', 17),
(402, 21, 7, '2018-11-12', 13),
(403, 5, 3, '2018-10-09', 15),
(404, 30, 6, '2018-10-21', 11),
(405, 41, 1, '2019-05-25', 18),
(406, 44, 5, '2018-10-23', 10),
(407, 55, 6, '2019-01-04', 1),
(408, 32, 11, '2018-10-21', 15),
(409, 88, 12, '2018-11-02', 4),
(410, 64, 5, '2018-09-08', 3),
(411, 27, 8, '2019-04-27', 20),
(412, 68, 8, '2019-02-21', 9),
(413, 11, 1, '2019-06-19', 3),
(414, 12, 1, '2019-01-29', 11),
(415, 22, 12, '2019-06-03', 30),
(416, 82, 3, '2018-09-24', 1),
(417, 57, 8, '2019-03-13', 20),
(418, 10, 2, '2018-11-23', 11),
(419, 30, 13, '2018-10-16', 6),
(420, 74, 4, '2018-10-25', 6),
(421, 32, 8, '2018-10-25', 15),
(422, 43, 6, '2018-10-03', 15),
(423, 9, 2, '2019-06-13', 9),
(424, 82, 1, '2018-09-23', 2),
(425, 85, 13, '2019-05-27', 28),
(426, 3, 12, '2019-01-03', 9),
(427, 1, 9, '2018-12-27', 17),
(428, 39, 8, '2018-12-27', 30),
(429, 2, 6, '2019-06-21', 35),
(430, 28, 12, '2019-04-03', 8),
(431, 86, 9, '2018-10-21', 14),
(432, 65, 11, '2019-06-23', 11),
(433, 6, 10, '2018-12-25', 25),
(434, 59, 13, '2019-05-29', 20),
(435, 26, 5, '2019-04-27', 18),
(436, 3, 11, '2019-01-11', 5),
(437, 56, 1, '2019-05-14', 40),
(438, 87, 11, '2019-05-08', 26),
(439, 70, 9, '2018-11-11', 15),
(440, 1, 1, '2018-12-21', 4),
(441, 60, 9, '2018-09-14', 18),
(442, 21, 3, '2018-11-02', 9),
(443, 29, 5, '2018-09-17', 3),
(444, 2, 3, '2019-06-18', 6),
(445, 85, 1, '2019-05-29', 13),
(446, 37, 9, '2019-01-03', 2),
(447, 76, 10, '2018-11-19', 13),
(448, 72, 3, '2019-04-07', 4),
(449, 23, 6, '2019-05-13', 8),
(450, 76, 12, '2018-11-29', 4),
(451, 60, 6, '2018-09-21', 15),
(452, 60, 12, '2018-09-18', 23),
(453, 32, 12, '2018-10-24', 14),
(454, 26, 11, '2019-04-23', 20),
(455, 47, 3, '2019-01-04', 8),
(456, 72, 10, '2019-04-06', 30),
(457, 42, 2, '2018-11-24', 18),
(458, 62, 13, '2018-12-02', 3),
(459, 74, 3, '2018-10-27', 13),
(460, 80, 5, '2019-03-06', 13),
(461, 35, 6, '2019-03-07', 10),
(462, 3, 6, '2019-01-04', 9),
(463, 15, 1, '2019-03-15', 12),
(464, 69, 6, '2019-06-21', 11),
(465, 85, 4, '2019-05-29', 25),
(466, 87, 3, '2019-05-10', 40),
(467, 41, 12, '2019-05-30', 3),
(468, 64, 12, '2018-09-17', 28),
(469, 37, 5, '2018-12-30', 15),
(470, 11, 8, '2019-06-22', 27),
(471, 62, 3, '2018-12-03', 15),
(472, 36, 4, '2018-12-19', 13),
(473, 79, 12, '2019-06-21', 35),
(474, 70, 6, '2018-11-03', 2),
(475, 34, 11, '2019-03-21', 1),
(476, 65, 12, '2019-06-24', 0),
(477, 36, 2, '2018-12-17', 30),
(478, 17, 3, '2019-04-21', 15),
(479, 77, 9, '2018-10-08', 12),
(480, 73, 3, '2019-01-04', 15),
(481, 75, 6, '2019-05-11', 40),
(482, 65, 13, '2019-06-17', 15),
(483, 85, 5, '2019-05-25', 4),
(484, 62, 8, '2018-12-04', 0),
(485, 78, 3, '2019-03-29', 11),
(486, 78, 10, '2019-03-29', 2),
(487, 56, 9, '2019-05-15', 40),
(488, 13, 6, '2019-02-12', 37),
(489, 3, 3, '2019-01-03', 15),
(490, 30, 1, '2018-10-26', 5),
(491, 83, 3, '2019-04-02', 20),
(492, 29, 2, '2018-09-20', 30),
(493, 16, 10, '2019-01-21', 23),
(494, 43, 8, '2018-10-08', 5),
(495, 16, 7, '2019-02-02', 17),
(496, 55, 7, '2019-01-10', 15),
(497, 66, 7, '2019-01-28', 25),
(498, 21, 5, '2018-11-05', 15),
(499, 10, 6, '2018-11-22', 6),
(500, 47, 13, '2019-01-06', 12),
(501, 63, 9, '2019-05-08', 34),
(502, 11, 9, '2019-06-19', 23),
(503, 75, 11, '2019-05-14', 40),
(504, 50, 4, '2019-01-11', 15),
(505, 69, 2, '2019-06-09', 35),
(506, 19, 13, '2018-10-04', 15),
(507, 25, 10, '2019-04-04', 8),
(508, 58, 12, '2018-12-19', 0),
(509, 82, 7, '2018-09-16', 1),
(510, 53, 11, '2019-01-26', 1),
(511, 38, 12, '2019-04-21', 20),
(512, 18, 5, '2019-02-23', 40),
(513, 19, 3, '2018-09-27', 15),
(514, 32, 5, '2018-10-27', 13),
(515, 40, 8, '2019-02-16', 40),
(516, 75, 3, '2019-05-08', 40),
(517, 65, 8, '2019-06-23', 7),
(518, 37, 3, '2019-01-05', 7),
(519, 54, 1, '2018-11-06', 14),
(520, 7, 5, '2018-09-19', 1),
(521, 61, 6, '2019-04-07', 19),
(522, 13, 2, '2019-02-16', 40),
(523, 12, 11, '2019-01-31', 12),
(524, 5, 4, '2018-10-07', 15),
(525, 41, 9, '2019-05-28', 35),
(526, 81, 11, '2018-10-07', 5),
(527, 33, 8, '2019-04-22', 20),
(528, 13, 4, '2019-02-15', 37),
(529, 28, 10, '2019-03-25', 25),
(530, 89, 1, '2019-05-11', 39),
(531, 54, 8, '2018-11-13', 10),
(532, 73, 12, '2019-01-11', 9),
(533, 5, 10, '2018-10-03', 15),
(534, 1, 12, '2018-12-23', 30),
(535, 36, 10, '2018-12-13', 30),
(536, 20, 9, '2019-02-27', 19),
(537, 64, 11, '2018-09-23', 4),
(538, 79, 6, '2019-06-12', 35),
(539, 45, 1, '2019-05-27', 3),
(540, 32, 1, '2018-10-21', 11),
(541, 67, 12, '2018-09-17', 16),
(542, 12, 6, '2019-02-02', 16),
(543, 58, 13, '2018-12-26', 30),
(544, 2, 7, '2019-06-19', 28),
(545, 44, 12, '2018-10-24', 5),
(546, 67, 1, '2018-09-23', 13),
(547, 50, 9, '2019-01-18', 15),
(548, 87, 10, '2019-05-08', 36),
(549, 80, 8, '2019-03-21', 14),
(550, 72, 9, '2019-04-10', 8),
(551, 15, 3, '2019-03-15', 20),
(552, 65, 5, '2019-06-21', 31),
(553, 57, 10, '2019-03-03', 10),
(554, 83, 9, '2019-04-03', 2),
(555, 34, 12, '2019-03-16', 3),
(556, 23, 9, '2019-05-10', 36),
(557, 73, 8, '2019-01-11', 15),
(558, 58, 5, '2018-12-20', 2),
(559, 84, 12, '2019-04-26', 16),
(560, 78, 11, '2019-03-31', 3),
(561, 62, 10, '2018-11-18', 17),
(562, 72, 7, '2019-04-09', 30),
(563, 82, 8, '2018-09-11', 30),
(564, 4, 2, '2019-02-15', 23),
(565, 68, 13, '2019-02-21', 5),
(566, 63, 3, '2019-05-05', 37),
(567, 7, 12, '2018-09-18', 29),
(568, 56, 6, '2019-05-05', 40),
(569, 20, 7, '2019-02-09', 40),
(570, 17, 9, '2019-04-22', 8),
(571, 52, 7, '2019-05-24', 1),
(572, 7, 6, '2018-09-11', 30),
(573, 57, 1, '2019-03-05', 9),
(574, 42, 7, '2018-11-30', 7),
(575, 49, 8, '2019-03-13', 0),
(576, 54, 13, '2018-11-12', 13),
(577, 35, 8, '2019-03-03', 5),
(578, 3, 4, '2019-01-18', 15),
(579, 27, 12, '2019-04-28', 5),
(580, 57, 13, '2019-03-10', 2),
(581, 9, 7, '2019-06-10', 35),
(582, 39, 4, '2018-12-26', 1),
(583, 39, 11, '2018-12-19', 28),
(584, 42, 13, '2018-12-04', 6),
(585, 88, 2, '2018-11-04', 14),
(586, 52, 13, '2019-05-23', 2),
(587, 24, 9, '2018-11-23', 15),
(588, 29, 8, '2018-09-12', 23),
(589, 74, 1, '2018-10-24', 9),
(590, 47, 7, '2019-01-07', 15),
(591, 86, 8, '2018-10-27', 6),
(592, 85, 3, '2019-05-20', 22),
(593, 39, 2, '2018-12-22', 9),
(594, 76, 13, '2018-11-26', 20),
(595, 34, 3, '2019-03-18', 11),
(596, 12, 12, '2019-02-04', 22),
(597, 88, 5, '2018-11-09', 15),
(598, 13, 5, '2019-02-18', 40),
(599, 87, 5, '2019-05-08', 6),
(600, 52, 8, '2019-05-27', 22),
(601, 51, 12, '2019-01-21', 25),
(602, 33, 3, '2019-04-29', 5),
(603, 87, 8, '2019-05-10', 0),
(604, 55, 13, '2019-01-11', 2),
(605, 36, 5, '2018-12-19', 30),
(606, 27, 5, '2019-04-25', 20),
(607, 64, 4, '2018-09-19', 20),
(608, 21, 1, '2018-11-07', 4),
(609, 89, 12, '2019-05-08', 3),
(610, 56, 11, '2019-05-10', 38),
(611, 46, 1, '2018-10-12', 15),
(612, 85, 6, '2019-05-24', 35),
(613, 37, 10, '2019-01-14', 15),
(614, 3, 1, '2019-01-15', 8),
(615, 6, 4, '2018-12-23', 16),
(616, 37, 4, '2019-01-09', 15),
(617, 43, 12, '2018-10-04', 15),
(618, 21, 4, '2018-11-13', 12),
(619, 87, 12, '2019-05-12', 17),
(620, 58, 10, '2018-12-23', 12),
(621, 33, 9, '2019-04-25', 20),
(622, 2, 8, '2019-06-18', 20),
(623, 49, 12, '2019-03-12', 11),
(624, 65, 10, '2019-06-13', 10),
(625, 78, 4, '2019-03-29', 22),
(626, 22, 4, '2019-06-03', 31),
(627, 44, 6, '2018-10-27', 0),
(628, 6, 7, '2018-12-14', 24),
(629, 88, 4, '2018-11-08', 13),
(630, 63, 11, '2019-05-13', 27),
(631, 59, 4, '2019-05-28', 18),
(632, 71, 3, '2018-12-27', 10),
(633, 89, 10, '2019-05-11', 40),
(634, 66, 10, '2019-01-27', 2),
(635, 70, 3, '2018-11-09', 10),
(636, 18, 12, '2019-02-09', 13),
(637, 48, 7, '2018-10-23', 15),
(638, 63, 10, '2019-05-13', 37),
(639, 68, 2, '2019-02-24', 33),
(640, 68, 9, '2019-02-24', 40),
(641, 15, 10, '2019-03-04', 2),
(642, 66, 12, '2019-01-28', 21),
(643, 84, 3, '2019-04-24', 3),
(644, 44, 13, '2018-10-24', 15),
(645, 86, 5, '2018-10-23', 12),
(646, 46, 11, '2018-10-10', 15),
(647, 16, 8, '2019-01-22', 3),
(648, 8, 2, '2019-01-31', 25),
(649, 4, 4, '2019-02-16', 3),
(650, 75, 10, '2019-05-12', 25),
(651, 5, 8, '2018-10-02', 1),
(652, 26, 4, '2019-04-27', 7),
(653, 72, 8, '2019-04-01', 30),
(654, 84, 4, '2019-04-21', 16),
(655, 60, 11, '2018-09-15', 30),
(656, 53, 10, '2019-01-31', 3),
(657, 46, 8, '2018-10-03', 5),
(658, 85, 8, '2019-05-30', 35),
(659, 80, 13, '2019-03-20', 17),
(660, 42, 9, '2018-11-22', 7),
(661, 35, 3, '2019-03-08', 11),
(662, 81, 1, '2018-10-02', 3),
(663, 73, 10, '2019-01-03', 12),
(664, 31, 10, '2018-11-30', 2),
(665, 57, 9, '2019-03-09', 7),
(666, 30, 3, '2018-10-22', 4),
(667, 56, 13, '2019-05-08', 9),
(668, 50, 3, '2019-01-03', 15),
(669, 66, 3, '2019-01-28', 3),
(670, 49, 7, '2019-03-19', 19),
(671, 21, 8, '2018-11-04', 15),
(672, 80, 9, '2019-03-20', 15),
(673, 27, 2, '2019-04-27', 18),
(674, 46, 7, '2018-10-03', 6),
(675, 88, 9, '2018-11-11', 14),
(676, 17, 11, '2019-04-22', 0),
(677, 54, 7, '2018-11-14', 11),
(678, 38, 2, '2019-04-26', 20),
(679, 31, 11, '2018-11-26', 19),
(680, 14, 5, '2018-11-08', 15),
(681, 33, 4, '2019-04-23', 20),
(682, 23, 11, '2019-05-13', 9),
(683, 51, 9, '2019-01-26', 6),
(684, 1, 4, '2018-12-17', 2),
(685, 5, 2, '2018-09-28', 12),
(686, 85, 12, '2019-06-04', 22),
(687, 44, 9, '2018-10-22', 15),
(688, 40, 3, '2019-02-25', 13),
(689, 8, 12, '2019-02-03', 6),
(690, 34, 4, '2019-03-12', 15),
(691, 56, 5, '2019-05-07', 23),
(692, 54, 4, '2018-11-05', 9),
(693, 8, 10, '2019-01-24', 18),
(694, 65, 9, '2019-06-24', 15),
(695, 64, 6, '2018-09-24', 9),
(696, 89, 11, '2019-05-15', 5),
(697, 82, 9, '2018-09-11', 30),
(698, 48, 11, '2018-10-27', 2),
(699, 24, 6, '2018-12-02', 2),
(700, 20, 12, '2019-02-17', 40),
(701, 89, 2, '2019-05-14', 30),
(702, 3, 5, '2019-01-15', 15),
(703, 17, 5, '2019-04-20', 5),
(704, 83, 2, '2019-04-08', 1),
(705, 52, 4, '2019-05-23', 6),
(706, 61, 9, '2019-04-07', 16),
(707, 25, 11, '2019-04-05', 2),
(708, 66, 13, '2019-01-27', 8),
(709, 41, 6, '2019-05-26', 35),
(710, 3, 8, '2019-01-13', 15),
(711, 47, 10, '2019-01-09', 7),
(712, 58, 8, '2018-12-25', 30),
(713, 46, 4, '2018-10-06', 9),
(714, 79, 1, '2019-06-18', 16),
(715, 42, 1, '2018-11-30', 20),
(716, 25, 3, '2019-03-25', 4),
(717, 62, 1, '2018-11-30', 5),
(718, 48, 8, '2018-10-22', 14),
(719, 26, 6, '2019-04-23', 15),
(720, 57, 12, '2019-03-21', 20),
(721, 13, 12, '2019-02-19', 13),
(722, 50, 5, '2019-01-09', 5),
(723, 64, 1, '2018-09-24', 21),
(724, 68, 12, '2019-02-12', 40),
(725, 58, 2, '2018-12-24', 30),
(726, 23, 1, '2019-05-15', 22),
(727, 87, 13, '2019-05-09', 6),
(728, 76, 3, '2018-12-01', 6),
(729, 82, 4, '2018-09-16', 18),
(730, 47, 5, '2019-01-10', 14),
(731, 81, 6, '2018-10-08', 6),
(732, 40, 1, '2019-02-16', 8),
(733, 28, 3, '2019-04-06', 30),
(734, 52, 12, '2019-05-27', 35),
(735, 41, 2, '2019-05-21', 2),
(736, 52, 1, '2019-05-26', 35),
(737, 58, 4, '2018-12-26', 30),
(738, 61, 13, '2019-04-05', 23),
(739, 66, 2, '2019-01-27', 23),
(740, 14, 9, '2018-10-30', 6),
(741, 29, 1, '2018-09-17', 30),
(742, 5, 5, '2018-10-05', 15),
(743, 5, 11, '2018-10-09', 8),
(744, 49, 1, '2019-03-13', 16),
(745, 23, 8, '2019-05-09', 40),
(746, 10, 10, '2018-12-04', 16),
(747, 68, 4, '2019-02-26', 17),
(748, 66, 5, '2019-01-24', 12),
(749, 19, 2, '2018-10-07', 11),
(750, 50, 6, '2019-01-09', 12),
(751, 10, 13, '2018-11-27', 8),
(752, 29, 4, '2018-09-20', 13),
(753, 9, 10, '2019-06-21', 35),
(754, 77, 7, '2018-10-09', 15),
(755, 48, 6, '2018-10-18', 11),
(756, 21, 6, '2018-11-11', 10),
(757, 16, 12, '2019-01-29', 21),
(758, 69, 4, '2019-06-14', 19),
(759, 10, 4, '2018-11-28', 1),
(760, 40, 6, '2019-02-11', 24),
(761, 45, 5, '2019-05-23', 11),
(762, 31, 2, '2018-11-21', 18),
(763, 84, 6, '2019-04-19', 10),
(764, 44, 1, '2018-10-21', 15),
(765, 67, 9, '2018-09-18', 5),
(766, 63, 4, '2019-05-12', 11),
(767, 71, 13, '2018-12-14', 18),
(768, 80, 12, '2019-03-07', 19),
(769, 9, 1, '2019-06-24', 7),
(770, 45, 9, '2019-06-04', 6),
(771, 54, 10, '2018-11-09', 14),
(772, 21, 12, '2018-11-03', 15),
(773, 64, 8, '2018-09-10', 30),
(774, 7, 7, '2018-09-21', 30),
(775, 57, 6, '2019-03-13', 7),
(776, 54, 5, '2018-10-31', 15),
(777, 72, 1, '2019-04-03', 30),
(778, 62, 7, '2018-11-19', 18),
(779, 65, 1, '2019-06-14', 28),
(780, 52, 6, '2019-06-03', 2),
(781, 56, 2, '2019-05-08', 9),
(782, 76, 5, '2018-11-29', 19),
(783, 38, 7, '2019-04-25', 3),
(784, 35, 2, '2019-03-15', 20),
(785, 42, 4, '2018-11-22', 5),
(786, 13, 3, '2019-02-23', 40),
(787, 11, 13, '2019-06-17', 30),
(788, 73, 1, '2019-01-12', 15),
(789, 30, 11, '2018-10-16', 14),
(790, 48, 10, '2018-10-21', 2),
(791, 17, 13, '2019-04-18', 13),
(792, 37, 11, '2019-01-18', 14),
(793, 64, 10, '2018-09-21', 30),
(794, 50, 2, '2019-01-12', 13),
(795, 63, 5, '2019-05-09', 40),
(796, 86, 1, '2018-10-16', 15),
(797, 30, 8, '2018-10-27', 6),
(798, 9, 4, '2019-06-24', 30),
(799, 70, 4, '2018-11-11', 2),
(800, 60, 8, '2018-09-15', 6),
(801, 1, 3, '2018-12-25', 30),
(802, 84, 1, '2019-04-28', 14),
(803, 61, 8, '2019-04-13', 25),
(804, 24, 10, '2018-12-04', 12),
(805, 6, 2, '2018-12-12', 4),
(806, 6, 3, '2018-12-17', 6),
(807, 31, 3, '2018-11-21', 5),
(808, 29, 6, '2018-09-23', 30),
(809, 75, 8, '2019-05-12', 6),
(810, 63, 2, '2019-05-09', 14),
(811, 14, 13, '2018-11-13', 15),
(812, 50, 7, '2019-01-06', 15),
(813, 48, 13, '2018-10-23', 13),
(814, 28, 11, '2019-03-31', 16),
(815, 22, 6, '2019-05-26', 32),
(816, 55, 11, '2019-01-02', 8),
(817, 18, 11, '2019-02-15', 9),
(818, 68, 5, '2019-02-25', 23),
(819, 58, 9, '2018-12-21', 29),
(820, 48, 4, '2018-10-22', 11),
(821, 53, 12, '2019-01-29', 25),
(822, 7, 13, '2018-09-08', 15),
(823, 48, 1, '2018-10-24', 10),
(824, 18, 1, '2019-02-13', 40),
(825, 35, 13, '2019-03-05', 20),
(826, 59, 1, '2019-05-28', 14),
(827, 46, 6, '2018-10-02', 11),
(828, 37, 2, '2019-01-18', 10),
(829, 53, 9, '2019-02-02', 25),
(830, 65, 4, '2019-06-23', 35),
(831, 67, 8, '2018-09-19', 15),
(832, 43, 5, '2018-10-07', 12),
(833, 39, 10, '2018-12-23', 1),
(834, 70, 11, '2018-10-30', 7),
(835, 24, 5, '2018-12-04', 20),
(836, 6, 12, '2018-12-10', 12),
(837, 83, 5, '2019-03-29', 10),
(838, 45, 4, '2019-05-23', 35),
(839, 30, 4, '2018-10-24', 5),
(840, 80, 2, '2019-03-21', 6),
(841, 27, 4, '2019-04-19', 9),
(842, 11, 7, '2019-06-20', 29),
(843, 1, 10, '2018-12-24', 20),
(844, 52, 11, '2019-05-22', 4),
(845, 58, 11, '2018-12-17', 1),
(846, 43, 10, '2018-10-12', 12),
(847, 6, 5, '2018-12-16', 30),
(848, 73, 2, '2019-01-09', 12),
(849, 47, 8, '2019-01-12', 11),
(850, 30, 12, '2018-10-25', 15),
(851, 27, 3, '2019-04-28', 20),
(852, 47, 4, '2019-01-14', 10),
(853, 70, 7, '2018-11-05', 2),
(854, 16, 1, '2019-02-01', 25),
(855, 78, 7, '2019-03-31', 30),
(856, 68, 6, '2019-02-09', 0),
(857, 16, 9, '2019-02-03', 25),
(858, 33, 2, '2019-04-24', 10),
(859, 89, 3, '2019-05-14', 2),
(860, 75, 7, '2019-05-15', 40),
(861, 19, 7, '2018-09-27', 15),
(862, 26, 2, '2019-04-28', 17),
(863, 16, 5, '2019-01-27', 16),
(864, 37, 8, '2019-01-03', 0),
(865, 49, 10, '2019-03-07', 11),
(866, 4, 5, '2019-02-20', 2),
(867, 58, 3, '2018-12-17', 7),
(868, 77, 10, '2018-10-04', 12),
(869, 36, 13, '2018-12-27', 30),
(870, 61, 2, '2019-04-03', 9),
(871, 16, 4, '2019-01-21', 8),
(872, 7, 4, '2018-09-07', 4),
(873, 4, 12, '2019-02-20', 4),
(874, 71, 2, '2018-12-22', 30),
(875, 86, 11, '2018-10-23', 15),
(876, 59, 6, '2019-05-30', 35),
(877, 74, 8, '2018-10-25', 0),
(878, 4, 6, '2019-02-25', 29),
(879, 71, 9, '2018-12-21', 30),
(880, 13, 13, '2019-02-21', 40),
(881, 52, 9, '2019-05-30', 35),
(882, 66, 1, '2019-01-24', 4),
(883, 7, 8, '2018-09-15', 13),
(884, 58, 6, '2018-12-16', 30),
(885, 51, 7, '2019-01-29', 25),
(886, 4, 1, '2019-02-13', 1),
(887, 28, 1, '2019-04-11', 30),
(888, 46, 2, '2018-10-02', 2),
(889, 48, 3, '2018-10-22', 0),
(890, 25, 13, '2019-04-04', 10),
(891, 78, 12, '2019-04-07', 29),
(892, 10, 3, '2018-11-27', 20),
(893, 20, 11, '2019-02-25', 3),
(894, 38, 6, '2019-04-24', 9),
(895, 44, 2, '2018-10-16', 8),
(896, 8, 5, '2019-01-25', 17),
(897, 47, 2, '2019-01-12', 14),
(898, 86, 6, '2018-10-25', 6),
(899, 18, 8, '2019-02-26', 29),
(900, 78, 5, '2019-04-13', 30),
(901, 29, 9, '2018-09-08', 29),
(902, 62, 11, '2018-11-20', 1),
(903, 77, 12, '2018-10-12', 15),
(904, 45, 6, '2019-05-31', 7),
(905, 13, 1, '2019-02-10', 40),
(906, 13, 8, '2019-02-24', 35),
(907, 87, 7, '2019-05-14', 40),
(908, 43, 3, '2018-10-09', 2),
(909, 75, 1, '2019-05-08', 40),
(910, 51, 11, '2019-01-25', 11),
(911, 88, 8, '2018-11-09', 6),
(912, 59, 10, '2019-05-24', 35),
(913, 67, 10, '2018-09-10', 30),
(914, 40, 10, '2019-02-23', 1),
(915, 76, 4, '2018-11-29', 7),
(916, 70, 13, '2018-11-02', 15),
(917, 35, 9, '2019-03-15', 20),
(918, 83, 8, '2019-04-01', 27),
(919, 48, 5, '2018-10-21', 2),
(920, 3, 7, '2019-01-09', 8),
(921, 67, 2, '2018-09-17', 30),
(922, 57, 3, '2019-03-09', 7),
(923, 19, 6, '2018-10-12', 15),
(924, 38, 8, '2019-04-25', 20),
(925, 57, 4, '2019-03-10', 0),
(926, 19, 1, '2018-10-03', 14),
(927, 40, 13, '2019-02-25', 4),
(928, 35, 12, '2019-03-18', 14),
(929, 51, 13, '2019-02-01', 25),
(930, 60, 5, '2018-09-10', 30),
(931, 16, 3, '2019-02-05', 1),
(932, 35, 11, '2019-03-15', 9),
(933, 67, 4, '2018-09-11', 30),
(934, 55, 8, '2019-01-04', 15),
(935, 36, 12, '2018-12-19', 29),
(936, 59, 2, '2019-05-26', 35),
(937, 73, 11, '2019-01-16', 6),
(938, 56, 4, '2019-05-11', 40),
(939, 71, 7, '2018-12-16', 4),
(940, 80, 7, '2019-03-15', 20),
(941, 41, 8, '2019-06-03', 28),
(942, 88, 10, '2018-11-07', 13),
(943, 79, 3, '2019-06-16', 35),
(944, 64, 7, '2018-09-09', 1),
(945, 75, 13, '2019-05-09', 34),
(946, 19, 9, '2018-10-10', 3),
(947, 62, 12, '2018-11-29', 5),
(948, 10, 5, '2018-11-18', 7),
(949, 82, 5, '2018-09-09', 30),
(950, 42, 8, '2018-12-04', 20),
(951, 76, 2, '2018-11-28', 13),
(952, 41, 10, '2019-05-31', 0),
(953, 51, 4, '2019-01-29', 0),
(954, 50, 12, '2019-01-03', 15),
(955, 85, 11, '2019-05-28', 35),
(956, 54, 2, '2018-11-13', 12),
(957, 28, 7, '2019-04-06', 2),
(958, 71, 12, '2018-12-17', 2),
(959, 63, 1, '2019-05-09', 40),
(960, 38, 9, '2019-04-25', 20),
(961, 38, 4, '2019-04-22', 20),
(962, 72, 2, '2019-04-11', 28),
(963, 14, 7, '2018-11-03', 12),
(964, 81, 2, '2018-10-08', 14),
(965, 1, 7, '2018-12-14', 16),
(966, 22, 2, '2019-05-23', 19),
(967, 83, 4, '2019-04-06', 12),
(968, 30, 10, '2018-10-27', 12),
(969, 25, 9, '2019-03-29', 30),
(970, 45, 7, '2019-06-01', 1),
(971, 45, 12, '2019-06-01', 17),
(972, 44, 3, '2018-10-23', 13),
(973, 4, 3, '2019-02-18', 40),
(974, 7, 9, '2018-09-13', 14),
(975, 22, 7, '2019-05-23', 1),
(976, 27, 10, '2019-04-24', 19),
(977, 83, 12, '2019-04-11', 29),
(978, 34, 5, '2019-03-17', 7),
(979, 25, 1, '2019-04-06', 11),
(980, 72, 5, '2019-04-04', 4),
(981, 2, 12, '2019-06-20', 29),
(982, 30, 5, '2018-10-23', 12),
(983, 50, 1, '2019-01-07', 13),
(984, 87, 6, '2019-05-14', 40),
(985, 12, 9, '2019-01-26', 1),
(986, 11, 11, '2019-06-23', 25),
(987, 67, 11, '2018-09-11', 18),
(988, 73, 7, '2019-01-02', 9),
(989, 11, 3, '2019-06-15', 30),
(990, 35, 10, '2019-03-17', 11),
(991, 53, 4, '2019-02-01', 25),
(992, 73, 6, '2019-01-15', 15),
(993, 60, 7, '2018-09-24', 23),
(994, 35, 5, '2019-03-19', 10),
(995, 78, 1, '2019-04-07', 6),
(996, 25, 6, '2019-03-29', 22),
(997, 39, 1, '2018-12-22', 24),
(998, 39, 9, '2018-12-23', 26),
(999, 9, 12, '2019-06-20', 35),
(1000, 75, 5, '2019-05-07', 27),
(1001, 31, 9, '2018-11-28', 18),
(1002, 21, 9, '2018-11-13', 15),
(1003, 78, 2, '2019-03-31', 10),
(1004, 14, 12, '2018-11-04', 0),
(1005, 10, 11, '2018-11-24', 11),
(1006, 31, 12, '2018-11-18', 4),
(1007, 49, 3, '2019-03-13', 8),
(1008, 26, 1, '2019-04-30', 14),
(1009, 12, 7, '2019-01-25', 25),
(1010, 27, 11, '2019-04-23', 4),
(1011, 31, 5, '2018-11-26', 17),
(1012, 8, 4, '2019-01-23', 3),
(1013, 67, 5, '2018-09-24', 30),
(1014, 1, 8, '2018-12-22', 4),
(1015, 22, 13, '2019-05-28', 8),
(1016, 38, 5, '2019-04-23', 20),
(1017, 49, 5, '2019-03-12', 3),
(1018, 35, 4, '2019-03-10', 4),
(1019, 7, 10, '2018-09-23', 7),
(1020, 2, 2, '2019-06-23', 13),
(1021, 65, 3, '2019-06-20', 35),
(1022, 57, 7, '2019-03-08', 1),
(1023, 11, 4, '2019-06-15', 35),
(1024, 68, 1, '2019-02-23', 16),
(1025, 66, 8, '2019-02-02', 10),
(1026, 47, 6, '2019-01-07', 10),
(1027, 6, 9, '2018-12-24', 24),
(1028, 1, 6, '2018-12-27', 2),
(1029, 46, 13, '2018-10-07', 10),
(1030, 79, 4, '2019-06-22', 2),
(1031, 11, 5, '2019-06-09', 1),
(1032, 54, 12, '2018-11-13', 15),
(1033, 25, 5, '2019-04-05', 29),
(1034, 43, 4, '2018-10-06', 10),
(1035, 15, 4, '2019-03-11', 13),
(1036, 86, 10, '2018-10-26', 15),
(1037, 82, 13, '2018-09-14', 30),
(1038, 80, 3, '2019-03-20', 2),
(1039, 25, 2, '2019-04-13', 10),
(1040, 22, 5, '2019-05-28', 2),
(1041, 76, 11, '2018-12-02', 20),
(1042, 75, 12, '2019-05-10', 40),
(1043, 28, 8, '2019-04-04', 0),
(1044, 64, 2, '2018-09-24', 3),
(1045, 84, 13, '2019-04-20', 20),
(1046, 52, 2, '2019-05-25', 0),
(1047, 43, 7, '2018-10-07', 12),
(1048, 48, 9, '2018-10-27', 7),
(1049, 36, 3, '2018-12-26', 30),
(1050, 85, 10, '2019-05-20', 17),
(1051, 59, 7, '2019-05-28', 11),
(1052, 59, 5, '2019-05-26', 35),
(1053, 23, 10, '2019-05-09', 40),
(1054, 21, 11, '2018-11-08', 15),
(1055, 59, 8, '2019-06-03', 35),
(1056, 15, 8, '2019-03-11', 20),
(1057, 39, 12, '2018-12-19', 20),
(1058, 84, 9, '2019-04-27', 20),
(1059, 42, 12, '2018-12-03', 20),
(1060, 44, 4, '2018-10-19', 7),
(1061, 56, 8, '2019-05-04', 36),
(1062, 73, 9, '2019-01-12', 13),
(1063, 14, 1, '2018-11-04', 9),
(1064, 6, 13, '2018-12-23', 9),
(1065, 17, 1, '2019-04-30', 7),
(1066, 18, 7, '2019-02-18', 19),
(1067, 2, 9, '2019-06-19', 20),
(1068, 20, 13, '2019-02-22', 0),
(1069, 18, 2, '2019-02-10', 40),
(1070, 17, 2, '2019-04-25', 4),
(1071, 24, 3, '2018-11-28', 20),
(1072, 8, 3, '2019-02-03', 23),
(1073, 35, 7, '2019-03-14', 20),
(1074, 82, 11, '2018-09-15', 3),
(1075, 81, 10, '2018-10-01', 5),
(1076, 56, 12, '2019-05-04', 22),
(1077, 74, 12, '2018-10-26', 3),
(1078, 45, 13, '2019-05-21', 10),
(1079, 29, 12, '2018-09-14', 11),
(1080, 84, 10, '2019-04-27', 20),
(1081, 40, 5, '2019-02-16', 40),
(1082, 47, 12, '2019-01-07', 5),
(1083, 9, 8, '2019-06-14', 20),
(1084, 67, 3, '2018-09-24', 1),
(1085, 39, 13, '2018-12-15', 30),
(1086, 22, 10, '2019-06-02', 24),
(1087, 21, 13, '2018-11-10', 1),
(1088, 76, 7, '2018-11-25', 20),
(1089, 41, 3, '2019-05-24', 35),
(1090, 50, 8, '2019-01-11', 2),
(1091, 71, 8, '2018-12-21', 30),
(1092, 28, 6, '2019-03-26', 26),
(1093, 62, 4, '2018-11-23', 18),
(1094, 31, 7, '2018-12-02', 10),
(1095, 40, 12, '2019-02-21', 4),
(1096, 60, 13, '2018-09-07', 30),
(1097, 74, 6, '2018-10-24', 15),
(1098, 34, 6, '2019-03-15', 11),
(1099, 60, 3, '2018-09-19', 10),
(1100, 32, 6, '2018-10-27', 14),
(1101, 36, 7, '2018-12-14', 12),
(1102, 81, 7, '2018-10-12', 0),
(1103, 1, 2, '2018-12-23', 30),
(1104, 69, 11, '2019-06-09', 35),
(1105, 81, 3, '2018-10-09', 4),
(1106, 88, 7, '2018-11-07', 15),
(1107, 22, 1, '2019-05-26', 35),
(1108, 6, 8, '2018-12-27', 19),
(1109, 8, 6, '2019-02-03', 17),
(1110, 83, 6, '2019-03-30', 0),
(1111, 1, 13, '2018-12-18', 30),
(1112, 33, 12, '2019-04-28', 16),
(1113, 6, 11, '2018-12-23', 28),
(1114, 17, 8, '2019-04-22', 20),
(1115, 86, 2, '2018-10-25', 14),
(1116, 10, 7, '2018-12-03', 20),
(1117, 80, 4, '2019-03-15', 8),
(1118, 23, 12, '2019-05-12', 40),
(1119, 61, 12, '2019-04-03', 30),
(1120, 74, 10, '2018-10-22', 11),
(1121, 76, 9, '2018-11-18', 20),
(1122, 77, 1, '2018-10-11', 14),
(1123, 51, 2, '2019-01-20', 19),
(1124, 66, 6, '2019-01-27', 17),
(1125, 34, 10, '2019-03-13', 6),
(1126, 34, 2, '2019-03-12', 10),
(1127, 33, 13, '2019-04-23', 0),
(1128, 49, 11, '2019-03-16', 18),
(1129, 84, 11, '2019-04-28', 20),
(1130, 41, 5, '2019-05-26', 31),
(1131, 15, 9, '2019-03-11', 20),
(1132, 75, 4, '2019-05-11', 4),
(1133, 4, 10, '2019-02-21', 8),
(1134, 80, 1, '2019-03-06', 0),
(1135, 49, 2, '2019-03-17', 14),
(1136, 88, 11, '2018-11-07', 8),
(1137, 37, 1, '2019-01-10', 15),
(1138, 14, 11, '2018-11-10', 7),
(1139, 8, 13, '2019-01-31', 25),
(1140, 18, 6, '2019-02-13', 18),
(1141, 38, 1, '2019-04-28', 20),
(1142, 46, 3, '2018-10-08', 9),
(1143, 25, 8, '2019-04-12', 4),
(1144, 79, 13, '2019-06-21', 0),
(1145, 67, 7, '2018-09-21', 28),
(1146, 41, 11, '2019-05-29', 35),
(1147, 34, 13, '2019-03-20', 20),
(1148, 34, 1, '2019-03-15', 20),
(1149, 69, 12, '2019-06-15', 35),
(1150, 39, 6, '2018-12-19', 24),
(1151, 42, 5, '2018-12-03', 20);


ALTER TABLE `csapat`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `feladat`
  ADD PRIMARY KEY (`id`),
  ADD KEY `feladatsorid` (`feladatsorid`);

ALTER TABLE `feladatsor`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `megoldas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `csapatid` (`csapatid`),
  ADD KEY `feladatid` (`feladatid`);


ALTER TABLE `csapat`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `feladat`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `feladatsor`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `megoldas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;


ALTER TABLE `feladat`
  ADD CONSTRAINT `feladat_ibfk_1` FOREIGN KEY (`feladatsorid`) REFERENCES `feladatsor` (`id`);

ALTER TABLE `megoldas`
  ADD CONSTRAINT `megoldas_ibfk_1` FOREIGN KEY (`feladatid`) REFERENCES `feladat` (`id`),
  ADD CONSTRAINT `megoldas_ibfk_2` FOREIGN KEY (`csapatid`) REFERENCES `csapat` (`id`);
COMMIT;
