using System;
using System.Collections.Generic;
using System.Text;

namespace AirNoise.Mathlib {

    public class Spline {

        private Vector3 constans = null;
        private List<Key> keyList = new List<Key>();

        #region Key struct

        public struct Key {

            public Key(float pTime, Vector3 pValue, Vector3 pTangentIn, Vector3 pTangentOut) {

                Time = pTime;

                Value = pValue;

                TangentIn = pTangentIn;
                TangentOut = pTangentOut;            
            
            }

            public float Time;

            public Vector3 Value;

            public Vector3 TangentIn;
            public Vector3 TangentOut;

        }

        #endregion

        #region Properties

        public Vector3 Constans {

            get {

                return constans;

            } set {

                constans = value;

            } 

        
        
        }

        #endregion

        public Spline() {

            constans = new Vector3(0, 0, 0);
        
        }

        public Spline(float x, float y, float z) {

            constans = new Vector3(x, y, z);

        }

        public void Clear() {

            keyList.Clear();
            constans = new Vector3(0, 0, 0);        
        }


        public void AddKey(float pTime, Vector3 pValue, Vector3 pTangentIn, Vector3 pTangentOut) {
        
            AddKey(new Key(pTime, pValue, pTangentIn, pTangentOut));

        }


        public void AddKey(Key key) {

            for (int i = 0; i < keyList.Count; i++) {

                if (keyList[i].Time > key.Time) {
                    keyList.Insert(i, key);
                    return;
                }
            }
            keyList.Add(key);
        }

        public Vector3 Evaluate(float pTime) {

            	
            if(keyList.Count < 1) {
                return constans;
            } else if(keyList.Count < 2) {
                return keyList[0].Value;
            }

            if (keyList[keyList.Count - 1].Time < pTime) {
                return keyList[keyList.Count - 1].Value;
            }


            if (keyList[0].Time > pTime) {

                return keyList[0].Value;

            }                       
            for (int i = 0; i < (keyList.Count - 1); i++)  {

                if (pTime >= keyList[i].Time && pTime < keyList[i + 1].Time) {

                    return Interpolate(keyList[i], keyList[i + 1], (pTime - keyList[i].Time) / (keyList[i + 1].Time - keyList[i].Time));

                }
            }
            return constans;
        }

        private Vector3 Interpolate(Key key1, Key key2, float t) {

            Vector3 p0 = key1.Value;
            Vector3 p1 = key1.TangentOut;
            Vector3 p2 = key2.Value;
            Vector3 p3 = key2.TangentIn;

            float tQuad = t * t;
            float tCube = tQuad * t;

            return p0 * (2 * tCube - 3 * tQuad + 1) + p1 * (tCube - 2 * tQuad + t) + p2 * (-2* tCube + 3 * tQuad) + p3 * (tCube - tQuad);
        }
    }
}
