using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using AirNoise.Mathlib;

namespace AirNoise.Core
{
    public partial class Renderer : Form
    {
        private Bitmap backBuffer = null;

        private Image backgroundImage = null;
        
        public Renderer()
        {
            InitializeComponent();

            SetStyle(ControlStyles.DoubleBuffer | ControlStyles.UserPaint | ControlStyles.AllPaintingInWmPaint, true);
            UpdateStyles();

            backgroundImage = Image.FromFile("xyz.jpg");

        }

        public bool IsActive()
        {
            return (ActiveForm == this);
        }

        private void DrawSID(Graphics g) {


            Vector3 temp = Kernel.AirPlane.Position(0);

            for (int i = 0; i < Kernel.AirPlane.Timer.Seconds; i += 10) {

                Vector3 pos = Kernel.AirPlane.Position(i);

          
                g.DrawLine(new Pen(Color.Black, 2.0f), pos.x, pos.y, temp.x, temp.y);
             

                temp = pos;
          
            }

   
        }

        private void DrawNoiseRing(Graphics g, Vector3 pos, float I) {

            float d = Kernel.AirPlane.D(I); 

            if (d > 0)
            {

                int a = (int)((150.0) / 256.0 * I);

                Color c = Color.FromArgb(a, Color.Red);

                g.FillEllipse(new SolidBrush(c), pos.x - d * 0.5f, pos.y - d * 0.5f, d, d);
            }    
        }

        private void DrawAirplane(Graphics g)
        {

            Vector3 pos = Kernel.AirPlane.Position(Kernel.AirPlane.Timer.Seconds);

            DrawNoiseRing(g, pos, 120);
            DrawNoiseRing(g, pos, 85);
            DrawNoiseRing(g, pos, 70);


        }

        protected override void OnPaint(PaintEventArgs e)
        {
            if (backBuffer == null)
            {
                backBuffer = new Bitmap(pictureBox1.Width, pictureBox1.Height);
            }
            
            Graphics g = Graphics.FromImage(backBuffer);

            g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;

            g.DrawImage(backgroundImage, 0, 0, 730, 670);
           
            if (Kernel.AirPlane != null)
            {
                DrawAirplane(g);
                DrawSID(g);
                timelineBar.Value = (int)(Kernel.AirPlane.Timer.Percent * 100);
            }

            pictureBox1.Image = backBuffer;

           
        }

        private void playButton_Click(object sender, EventArgs e)
        {
            Kernel.AirPlane.Timer.Play();
        }

        private void pauseButton_Click(object sender, EventArgs e)
        {
            Kernel.AirPlane.Timer.Pause();
        }

        private void timelineBar_Scroll(object sender, EventArgs e)
        {
            Kernel.AirPlane.Timer.SetWithPercent(timelineBar.Value * 0.01f);
        }

        private void openFileDialog1_FileOk(object sender, CancelEventArgs e)
        {
            Kernel.AirPlane = Airplane.FromFile(openFileDialog.FileName);
            Kernel.AirPlane.Timer.Play();
        }

        private void openButton_Click(object sender, EventArgs e)
        {
            openFileDialog.ShowDialog();
        }

    }
}